%%% STYLE of the Turkish Journal of Physics.
%%% Author: Ziya Karakaya
%%% Revision : 1.0
%%% ====================================================================
%%%  @LaTeX-file{
%%%     filename        = "fizik.cls"
%%%     author          = "Ziya Karakaya"
%%%     address         = "Ziya Karakaya
%%%                        Turkiye Bilimsel ve Teknik Arastirma Kurumu
%%%                        Bilimsel Yayinlar Dairesi Baskanligi
%%%                        Sistem Sorumlusu
%%%                        Kavaklidere Ankara/Turkey"
%%%     telephone       = "(+90) 312-4685300/2305"
%%%     email           = "ziya@tubitak.gov.tr"
%%%     keywords        = "fizik style"
%%%  }
%%% ====================================================================

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{fizik}[1998/04/17 v1.0
    TUBITAK - Turkish Journal of Physics]
\newif\if@draftcopy
\@draftcopyfalse
\DeclareOption{a5paper}
    {\ClassError{fizik}{Option `a5paper' not supported}{}}
\DeclareOption{b5paper}
    {\ClassError{fizik}{Option `b5paper' not supported}{}}
\DeclareOption{twocolumn}%
    {\ClassError{fizik}{Option `twocolumn' not supported}{}}
\DeclareOption{titlepage}%
    {\ClassError{fizik}{Option `titlepage' not supported}{}}
\DeclareOption{draft}
    {\@draftcopytrue
    \setlength\overfullrule{5pt}}
\DeclareOption{final}
    {\@draftcopyfalse
     \setlength\overfullrule{0pt}}

\PassOptionsToClass{letterpaper,twoside}{article}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass{article}
\ExecuteOptions{letterpaper,10pt,onecolumn,final}
%%%%%%%%%%%%%%%%% CAPTION %%%%%%%%%%%%%%%%%%%%%%

\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}

\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\small{\bfseries #1}. #2}%
  \ifdim \wd\@tempboxa >\hsize
    {\small {\bfseries #1}. #2\par}
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%% PAGE SIZE DEFINITIONS %%%%%%%%%%%%%%%%
\setlength\textwidth{5.35in}
\@settopoint\textwidth
\setlength\textheight{7in}
\advance\textheight by \topskip
%\setlength\oddsidemargin{-10\p@}
%\setlength\evensidemargin{-10\p@}
\setlength\oddsidemargin{40\p@}
\setlength\evensidemargin{40\p@}
\setlength\marginparwidth {\z@}
%\setlength\topmargin{-47\p@}
%\setlength\headheight{30\p@}
\setlength\topmargin{25\p@}
\setlength\headheight{12\p@}
\setlength\headsep{25\p@}
\setlength\footskip{30\p@}

\def\firstpage@putlabel{
   \immediate\write\@auxout{\string
   \newlabel{FirstPage}{{}{\thepage}}}%
}
\AtBeginDocument{
        \firstpage@putlabel%
        \settoheight{\footnotesep}{\footnotesize M$^1$}}%
\def\lastpage@putlabel{\addtocounter{page}{-1}%
   \immediate\write\@auxout{\string
   \newlabel{LastPage}{{}{\thepage}}}%
   \addtocounter{page}{1}}
\AtEndDocument{\clearpage\lastpage@putlabel}%

\renewcommand{\author}[2][]{
   \gdef\@surnames{#1}\gdef\@author{#2}
   \ifx\@empty\@surnames \gdef\@surnames{*****YOU MUST SUPPLY SURNAMES*****}\fi
}

\def\vol #1{\gdef\@vol{#1}
            \ifx\@empty\@vol\gdef\@vol{1}\fi}
\def\pyear #1{\gdef\@pyear{#1}
            \ifx\@empty\@pyear \gdef\@pyear{\number\year}\fi}
\def\received #1{\gdef\@received{#1}
            \ifx\@empty\@received \gdef\@received{\today}\fi}

\def\@oddhead{\normalfont\hfil\small\@surnames\hfil}
\def\@oddfoot{\normalfont\hfil\thepage }
\def\@evenhead{\normalfont\hfil\small\@surnames\hfil}
\def\@evenfoot{\normalfont\thepage\hfil}

\renewcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \thispagestyle{myheadings}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}

\def\serieslogo@{\vtop to 50pt{%
  \parindent\z@ \small\normalfont
  %\hbox{To appear in Turkish Journal of Physics\hfil}
  %\hbox{\@vol\ (\@pyear)\ , \pageref{FirstPage}\ --
  %\pageref{LastPage}.\hfil}
  %\hbox{\copyright\ T\"{U}B\.{I}TAK\hfil}%
   \endgraf\vss}}

\def\ps@myheadings{%
    \def\@oddhead{\vbox{\serieslogo@}\hss}
    \def\@oddfoot{\normalfont  \hfil \thepage}
    \let\@evenhead\@oddhead
    \def\@evenfoot{\normalfont \thepage \hfil}
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
}

\def\@maketitle{%
  \newpage
  \null
{\small
\begin{flushright} 
\baselineskip=8pt 
\vskip -.6cm
UMN-TH-1839/00\\
NUC-MINN-00/2-T\\
BNL-NT-00/1\\
(\mydate)
\end{flushright}
}
 
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\Large\bfseries \@title \par}%
    \vskip 2.5em%
    \lineskip .5em%
    \begin{tabular}[t]{c}%
       \@author
    \end{tabular}
    \par%
   \vskip 3.0em%
   {\small To appear in the Proceedings for\\
{\it The 6th International Wigner Symposium}\\
16 - 22 August 1999, Istanbul, Turkey}%

  \end{center}%
  \par
  \vskip 3.0em
}


\renewenvironment{abstract}{%
     \small
     \begin{center}%
     {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
     \end{center}%
     \quotation
   }
   {\endquotation}

\newenvironment{ozet}{%
     \small
     \begin{center}%
     {\bfseries \"{O}zet\vspace{-.5em}\vspace{\z@}}%
     \end{center}%
     \quotation
   }
   {\endquotation}

\renewenvironment{thebibliography}[1]
     {\zsection*{\refname
        \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}



\newenvironment{reference}{\begin{thebibliography}{99}}
                        {\end{thebibliography}}

\def\baslik#1{ \vskip -\parskip
%               \vskip0pt plus.1\vsize\penalty-250
               \vskip0pt plus-.1\vsize \vskip.5cm plus 0.1cm
               \noindent {\bf #1 } \par\nobreak \vskip\medskipamount\nobreak }

\def\arabaslik#1{\vskip -\parskip
%               \vskip0pt plus.1\vsize\penalty-250
               \vskip0pt plus-.1\vsize \vskip.5cm plus 0.1cm
               \noindent {\bf #1 } \par\nobreak \vskip\medskipamount\nobreak }


\newcommand\zsection{\@startsection {section}{1}{\z@}%
                      {-3.5ex \@plus -1ex \@minus -.2ex}%
                      {2.3ex \@plus.2ex}%
                      {\centering\normalfont\normalsize\bfseries}}
\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\normalsize\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\bfseries}}

\renewcommand\@seccntformat[1]{\csname the#1\endcsname.\quad}

 \if@draftcopy\renewcommand\baselinestretch{2}\else
  \renewcommand\baselinestretch{}\fi

\endinput
%%
%% End of file `fizik.cls'.
