%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                    %
%  Style file for preparing papers for the CHEP 2000 Conference      %
%  in Padova. Derived from CSC96 Style of Michel Goosens             %
%                                                                    %
%  Corresponds to the instructions by the organizing committee,      %
%  as distributed to the contributors.                               %
%                                                                    %
%  Author : Michele Michelotto                                       %
%                                                                    %
%  Date:      07 Dec. 1999 mm                                        %
%  Last Mod:  13 Dec. 1999 mm                                        %
%                                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\fileversion{1.14}
\def\filedate{1999/12/07}
\def\docdate {1999/12/07}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{c2k}[\filedate\space CHEP 2000 class]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[11pt]{article}
\pagestyle{empty}
\@twosidefalse
%   *****  Global definitions for page layout *****
\hoffset-1in
\voffset-1in
%\topskip0pt
\oddsidemargin35mm\evensidemargin35mm\marginparwidth25mm
\marginparsep 0pt
\headheight 0pt
\headsep 0pt
\footskip 30pt
\textwidth 150mm
\setlength{\parindent}{1cm}
\parskip 0pt
\textheight=230mm
\topmargin=35mm
\headsep=0pt
\headheight=0pt


%%%
%%% Don't print the page numbers
%%%

\def\thetable{\Roman{table}}
\long\def\@makecaption#1#2{
 \vskip 10pt
 \setbox\@tempboxa\hbox{{\sffamily\footnotesize\textbf{#1:} #2}}
 \ifdim \wd\@tempboxa >\hsize \unhbox\@tempboxa\par \else \hbox
to\hsize{\hfil\box\@tempboxa\hfil}
 \fi}
%%%
%%%                                 Titlepage
%%%
%
% Definition of environment "titlepage"
\def\titlepage{\clearpage%
\setcounter{footnote}{0}\setcounter{page}{1}%
   \let\save@thefootnote=\thefootnote
   \let\save@makefnmark=\@makefnmark
   \def\thefootnote{\fnsymbol{footnote}}%
   \def\@makefnmark{\hbox
       to2mm{$\m@th^{\@thefnmark}$\hss}}%
\kern1mm %???
}% End of \titlepage tag

% conference{}
\def\conference#1{}

% note{}
\def\note#1{\vskip1em{\it#1\par}}

% dedication{}
\def\Dedication#1{\vskip1em{\it#1\par}}

\RequirePackage{url}
\RequirePackage{array}

% bibliography list
\def\@biblabel#1{\makebox[10mm][l]{\hspace*{2mm}#1\hfil}}
%%%%%%%%%%%%%%%%%%%       ^^^^ fixed width----------------------+
\renewenvironment{thebibliography}[1]%                          |
   {\section*{\refname             %                            |
      \@mkboth{\uppercase{\refname}}{\uppercase{\refname}}}%    |
    \list{\@biblabel{\arabic{enumiv}}}%                         |
           {\settowidth\labelwidth{10mm}%<<<<<<<< fixed width---+
            \labelsep0mm%
            \leftmargin\labelwidth
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand{\theenumiv}{\arabic{enumiv}}}%
        \renewcommand{\newblock}{\hskip .11em \@plus.33em \@minus.07em}%
      \sloppy\clubpenalty4000\widowpenalty4000%
      \sfcode`\.=\@m}
{\def\@noitemerr
    {\@latex@warning{Empty `thebibliography' environment}}%
   \endlist}
      
      
% LaTeX does not provide a command to enter the authors institute
% addresses. The \institute command is defined here.
 
\newcounter{@inst}
\newcounter{@auth}
\newdimen\instindent
 
\def\institute#1{\gdef\@institute{#1}}
 
\def\institutename{\par
 \begingroup
 \parskip=0pt
 \setcounter{@inst}{1}%
 \def\and{\par\stepcounter{@inst}%
 \hangindent\instindent\hangafter=0\noindent
 \llap{$^{\the@inst}$\enspace}\ignorespaces}%
 \setbox0=\vbox{\def\thanks##1{}\@institute}%
 \ifnum\c@@inst>9\relax\setbox0=\hbox{$^{88}$\enspace}%
                 \else\setbox0=\hbox{$^{8}$\enspace}\fi
 \instindent=\wd0\relax
 \ifnum\c@@inst=1\relax\else
 \setcounter{footnote}{\c@@inst}%
 \setcounter{@inst}{1}%
 \hangindent\instindent\hangafter=0\noindent
 \llap{$^{\the@inst}$\enspace}\fi\ignorespaces
 \@institute\par
 \endgroup}

 
\def\@fnsymbol#1{\ifcase#1\or\star\or{\star\star}\or{\star\star\star}%
   \or \dagger\or \ddagger\or
   \mathchar "278\or \mathchar "27B\or \|\or **\or \dagger\dagger
   \or \ddagger\ddagger\else\@ctrerr\fi\relax}
 
\def\inst#1{\unskip\/$^{#1}$}
 
\def\subtitle#1{\gdef\@subtitle{#1}}
\def\@subtitle{}
 
\def\titlerunning#1{\gdef\@titlerunning{#1}}
\def\@titlerunning{}
 
\def\authorrunning#1{\gdef\@authorrunning{#1}}
\def\@authorrunning{}

%
% Make Title par
%

\def\maketitle{\par
 \begingroup
 \parindent=\z@
 \def\thefootnote{\fnsymbol{footnote}}
 \if@twocolumn
 \twocolumn[\@maketitle]
 \else \newpage
 \global\@topnum\z@ \@maketitle \fi\thispagestyle{empty}\@thanks
 \endgroup
 \let\maketitle\relax
 \let\@maketitle\relax
 \gdef\@thanks{}\gdef\@author{}\gdef\@title{}\gdef\@subtitle{}%
 \let\thanks\relax}

\def\@maketitle{\newpage
 {\Large \bf\boldmath
  \pretolerance=10000
  \rightskip=0pt plus 4cm
  \@title \par}\vskip .6cm
\if!\@subtitle!\else {\large \bf\boldmath
  \vskip -.45cm
  \pretolerance=10000
  \rightskip=0pt plus 3cm
  \@subtitle \par}\vskip .6cm\fi
{\large\it \lineskip .5em
\@author\vskip.35cm
\def\\{ }\def\inst##1{}\def\thanks##1{}\def\and{}%
\setcounter{@auth}{1}%
\if!\@titlerunning!\else\def\@title{\@titlerunning}\fi
\if!\@authorrunning!\else\def\@author{\@authorrunning}\fi
\xdef\@author{\@author\unskip\unskip}%
\xdef\@title{\ignorespaces\@title}%
\instindent=\hsize\advance\instindent by-1cm\relax
\setbox0=\hbox{\@author}\ifdim\wd0>\instindent
\typeout{CHEP2000 Warning: The running head produced by the
\protect\author \space command}\typeout{exceeds the pagewidth,
please supply a short form with \protect\authorrunning.}%
\def\@author{Authors suppressed due to excessive length,
please use {\tt$\backslash$authorrunning}.}\fi
\setbox0=\hbox{\@title}\ifdim\wd0>\instindent
\typeout{CHEP2000 Warning: The running head produced by the
\protect\title \space command}\typeout{exceeds the pagewidth,
please supply a short form with \protect\titlerunning.}%
\def\@title{Title suppressed due to excessive length,
please use {\tt$\backslash$titlerunning}.}\fi
\markboth{\@author}{\@title}}
 {\small\rm\institutename}
 \par
 \ifdim\pagetotal<5.8true cm\instindent=5.8true cm\relax
 \advance\instindent by-\pagetotal\relax
 \advance\instindent by-18pt\relax
 \ifdim\instindent>0pt\relax\vskip\instindent\hrule height0pt\fi\fi}

      
%
% Abstract
\newenvironment{Abstract}
  {\par\vskip1ex\list{}{\listparindent 0pt\small
    \itemindent=0pt\relax
    \leftmargin=1cm\relax
    \rightmargin\leftmargin \parsep \z@ plus\p@}
    \item[]{\small\abstractname}\\[1ex]
    \item[]\ignorespaces}
  {\endlist}
%
\def\Keywords#1{{\small\par\vspace*{1pt}\par\noindent
   \hspace*{5mm}\begin{tabular}{@{}lp{12cm}}
                   \sffamily Keywords: & #1
                 \end{tabular}}\par}
		 
\def\endtitlepage{%% Reset counters
\@thanks{}%
\let\thefootnote=\save@thefootnote
\let\@makefnmark=\save@makefnmark
\setcounter{footnote}{0}\let\titlepage\relax\vskip 3mm\upshape
\gdef\@author{}\gdef\@title{}\global\let\thanks\relax
\global\let\@thanks\relax}
 
% The section levels are defined with the help of the
% \Lcs{@startsection} command, defined in \LaTeX{} as follows:
%
% \begin{verbatim}
% \@startsection {NAME}{LEVEL}{INDENT}{BEFORESKIP}{AFTERSKIP}{STYLE}
%            optional * [ALTHEADING]{HEADING}
%    Generic command to start a section.
%    NAME       : e.g., 'subsection'
%    LEVEL      : a number, denoting depth of section -- e.g., chapter=1,
%                 section = 2, etc.  A section number will be printed if
%                 and only if LEVEL < or = the value of the secnumdepth
%                 counter.
%    INDENT     : Indentation of heading from left margin
%    BEFORESKIP : Absolute value = skip to leave above the heading.
%                 If negative, then paragraph indent of text following
%                 heading is suppressed.
%    AFTERSKIP  : if positive, then skip to leave below heading,
%                       else - skip to leave to right of run-in heading.
%    STYLE      : commands to set style
%  If '*' missing, then increments the counter.  If it is present, then
%  there should be no [ALTHEADING] argument.  A sectioning command
%  is normally defined to \@startsection + its first six arguments.
% \end{verbatim}
%

\def\section{\@startsection {section}{1}{\z@}{-2.5ex plus-1ex minus
    -.2ex}{2.3ex plus.2ex}{\reset@font\large\bfseries}}
\def\subsection{\@startsection{subsection}{2}{\z@}{-2.25ex plus-1ex
    minus-.2ex}{1.5ex plus.2ex}{\reset@font\normalsize
                                \bfseries}}
\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{-2.25ex plus
 -1ex minus-.2ex}{1.5ex plus.2ex}{\reset@font\normalsize
                                \mdseries}}
% \def\@seccntformat#1{\hbox to 0pt{\hss\csname the#1\endcsname\quad}}


%
%  Dense lists
%
\def\@listI{%
            \leftmargin10mm%
            \labelsep5mm%
            \labelwidth\leftmargin
            \advance\labelwidth-\labelsep
            \parsep \z@
            \topsep 0\p@ \@plus\p@
            \itemsep 0\p@ \@plus1\p@}
\let\@listi\@listI
\@listi
\def\@listii {\leftmargin10mm%
              \labelsep   5mm%
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    0\p@ \@plus\p@
              \parsep    \z@
              \itemsep   \z@ \@plus\p@}
\def\@listiii{\leftmargin10mm%
              \labelsep   5mm%
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    0\p@ \@plus\p@
              \parsep    \z@
              \partopsep \z@ \@plus\p@
              \itemsep   \z@ \@plus\p@}
\def\@listiv {\leftmargin10mm%
              \labelsep   5mm%
              \labelwidth\leftmarginiv%
              \advance\labelwidth-\labelsep
              \topsep    0\p@ \@plus\p@
              \parsep    \z@
              \itemsep   \z@ \@plus\p@}
\def\@listv  {\leftmargin10mm%
              \labelsep   5mm%
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep%
              \topsep    0\p@ \@plus\p@
              \parsep    \z@
              \itemsep   \z@ \@plus\p@}
\def\@listvi {\leftmargin10mm%
              \labelsep   5mm
              \labelwidth\leftmarginvi
              \advance\labelwidth{-\labelsep}%
              \topsep    0\p@ \@plus\p@
              \parsep    \z@
              \itemsep   \z@ \@plus\p@}
%-----------------------------------------------------------------------
%-----------------------------------------------------------------------
% Here are some useful commands which facilitate correct formatting:
%
% To give a numerical value with units, e.g. \QTY{ 4.2 }{ MV\,n^{-1} }
% (this takes care that the units in an equation are in a roman font
%  and not in math-italic which is used for symbols, IMPORTANT!!)
%
\newcommand{\QTY}[2]{\mbox{\(#1\rm\,#2\)}}
%-----------------------------------------------------------------------
%
% To express a number in scientific notation, e.g. \Enum{1.7}{32}
\newcommand{\Enum}[2]{\mbox{\(#1\times10^{#2}\)}}
%
%-----------------------------------------------------------------------
% numerical formula e.g. \NQTY{E}{GeV} gives [E/GeV]
\newcommand{\NQTY}[2]{\mbox{$[#1/{\rm #2}]$}} % symbol with units in
%
%-----------------------------------------------------------------------
%  Expectation value or average, e.g. \EV{ x^2 } gives  <x^2>
\newcommand{\EV}[1]{\left\langle #1 \right\rangle} % expectation value
%
%-----------------------------------------------------------------------
% These are convenient for quoting luminosity:
\newcommand{\LUMI}[1]{\QTY{#1}{cm^{-2}s^{-1}}}
\newcommand{\LUM}[2]{\LUMI{#1\times10^{#2}}}
%
% thus a B-factory design might quote         \LUM{3.0}{33}
%-----------------------------------------------------------------------
\def\gappeq{\mathrel{ \rlap{\raise.5ex\hbox{$>$}}
                      {\lower.5ex\hbox{$\sim$}}  } }
%
%  \gappeq is a compound symbol made out of a > sign on top of a tilde
%  usually used to mean "greater than or approximately equal to"
%  or "vaguely greater than"  by physicists.
%  It behaves as a mathematical relation in TeX's math modes, e.g.
%  $ a \gappeq b $    in the text and
%  $$ a \gappeq b $$  as a display.
%
\def\lappeq{\mathrel{ \rlap{\raise.5ex\hbox{$<$}}
                      {\lower.5ex\hbox{$\sim$}}  } }
%-----------------------------------------------------------------------
%
%
%  Select the fonts
%
\renewcommand{\rmdefault}{ptm}
\renewcommand{\sfdefault}{phv}
\endinput
