% ====================== CRCKAPB.STY ===========================
%
% CRCKAPB DOCUMENT STYLE, version 1.0
%   for LaTeX version 2.09
%   Portions Copyright (C) 1988 by Leslie Lamport

\typeout{^^JDocument Style `CRCKAPB' <version 1.0, June 1994>/<KAP>.}
\typeout{ LaTeX style file for Books, Kluwer Academic Publishers^^J}


\def\author@uppercase{}    % Author's name(s) uppercase


\@ifundefined{abstractname}%
{\def\abstractname{Abstract}}{\relax}
\@ifundefined{keywordsname}%
{\def\keywordsname{Key words}}{\relax}
\@ifundefined{notesname}{\def\notesname{Notes}}{\relax}
\@ifundefined{acknowledgementsname}%
{\def\acknowledgementsname{Acknowledgements}}{\relax}
\@ifundefined{refname}{\def\refname{References}}{\relax}
\@ifundefined{appendixname}{\def\appendixname{Appendix}}{\relax}

\def\@ptsize{2}
\@namedef{ds@10pt}{\def\@ptsize{0}}
\@namedef{ds@11pt}{\def\@ptsize{1}}
\@namedef{ds@12pt}{\def\@ptsize{2}}

\@twosidetrue     %  Defines twoside option.
% \@mparswitchtrue  %  Marginpars go on outside of page.

\def\ds@draft{\overfullrule 5pt}  % Causes overfull hboxes to be marked.

\newif\if@nato
\newif\if@NATO
\newif\if@monograph
\newif\if@editedvolume
\newif\if@proceedings
\def\ds@nato{\@natotrue\typeout{^^JKAP -- NATO Series^^J}}
\def\ds@NATO{\@natotrue\typeout{^^JKAP -- NATO Series^^J}}
\def\ds@monograph{\@monographtrue\typeout{^^JKAP -- Monograph^^J}}
\def\ds@editedvolume{\@editedvolumetrue\typeout{^^JKAP -- Edited Volume^^J}}
\def\ds@proceedings{\@proceedingstrue\typeout{^^JKAP -- Proceedings^^J}}


\newif\if@numreferences
\def\ds@numreferences{\@numreferencestrue}
\@ifundefined{default@numreferences}{\@numreferencesfalse}%
{\@numreferencestrue}

\newif\if@namedreferences
\def\ds@namedreferences{\@namedreferencestrue}
\@ifundefined{default@namedreferences}{\@namedreferencesfalse}%
{\@namedreferencestrue}

\@options

\if@monograph
  \else
  \if@editedvolume
     \else
     \if@proceedings
     \else
     \if@nato
      \else
       \if@NATO
        \else
        \typeout{^^JBook Type Not Specified! Please specify}%
        \typeout{ proceedings, editedvolume, monograph or nato as documentstyle option.^^J}
      \@editedvolumetrue
     \fi
  \fi
\fi
\fi
\fi

\newif\if@subtitledefined
 
\lineskip 1pt 
\normallineskip 1pt
\def\baselinestretch{1}
 
% \typeout{KAP -- Eleven Point}
 
\def\@normalsize{\@setsize\normalsize{13pt}\xipt\@xipt
  \abovedisplayskip 11pt plus3pt minus6pt
  \belowdisplayskip \abovedisplayskip
  \abovedisplayshortskip \z@ plus3pt
  \belowdisplayshortskip 6.6pt plus3.5pt minus3pt}

\def\small{\@setsize\small{11pt}\xpt\@xpt
  \abovedisplayskip 10pt plus2pt minus5pt
  \belowdisplayskip \abovedisplayskip
  \abovedisplayshortskip \z@ plus3pt
  \belowdisplayshortskip 6pt plus3pt minus3pt
  \def\@listi{\topsep 6pt plus 2pt minus 2pt
    \parsep 3pt plus 2pt minus 1pt
    \itemsep \parsep}}

\def\footnotesize{\@setsize\footnotesize{10pt}\ixpt\@ixpt
  \abovedisplayskip 8pt plus 2pt minus 4pt
  \belowdisplayskip \abovedisplayskip
  \abovedisplayshortskip \z@ plus 1pt
  \belowdisplayshortskip 4pt plus 2pt minus 2pt
  \def\@listi{\topsep 4pt plus 2pt minus 2pt
    \parsep 2pt plus 1pt minus 1pt
    \itemsep \parsep}}

\def\scriptsize{\@setsize\scriptsize{9.5pt}\viiipt\@viiipt}
\def\tiny{\@setsize\tiny{7pt}\vipt\@vipt}
\def\large{\@setsize\large{14pt}\xiipt\@xiipt}
\def\Large{\@setsize\Large{18pt}\xivpt\@xivpt}
\def\LARGE{\@setsize\LARGE{22pt}\xviipt\@xviipt}
\def\huge{\@setsize\huge{25pt}\xxpt\@xxpt}
\def\Huge{\@setsize\Huge{30pt}\xxvpt\@xxvpt}

\normalsize

\oddsidemargin .2in % .25in 
\evensidemargin .2in % 1.25in

\marginparwidth 1in 
\marginparsep 10pt % 7pt

\topmargin -0.6mm % .73in 
\headheight 12pt 
\headsep 6mm % .275in 
\footskip 39pt
 
\textheight 19cm        % 21.5cm     
\textwidth  12.5cm      % 15cm     

% \marginpar redefined: text is set within \fbox 

\long\def\@savemarbox#1#2{\global\setbox#1\vtop{\fbox{\vtop{\hsize\marginparwidth
    \@parboxrestore  \raggedright\footnotesize #2}}}}

\columnsep 10pt 
\columnseprule 0pt
\advance\textheight by \topskip

\footnotesep 6.65pt

\if@monograph
  \skip\footins 0.7pc
\else % editedvolume or proceedings
  \skip\footins 12.8pt plus 4pt minus 2pt
\fi

\floatsep 14pt plus 2pt minus 4pt 
\textfloatsep 20pt plus 2pt minus 4pt
\intextsep 14pt plus 4pt minus 4pt 

\@maxsep 20pt 
\dblfloatsep 14pt plus 2pt minus 4pt 
\dbltextfloatsep 20pt plus 2pt minus 4pt 
\@dblmaxsep 20pt

\@fptop 0pt plus 1fil 
\@fpsep 10pt plus 2fil 
\@fpbot 0pt plus 1fil
\@dblfptop 0pt plus 1fil 
\@dblfpsep 10pt plus 2fil 
\@dblfpbot 0pt plus 1fil

\marginparpush 7pt

\parskip 0pt plus 1pt 
\parindent 1.5em 
\partopsep 3pt plus 2pt minus 2pt

\@lowpenalty 51 
\@medpenalty 151 
\@highpenalty 301

\@beginparpenalty -\@lowpenalty 
\@endparpenalty -\@lowpenalty 
\@itempenalty -\@lowpenalty
 


\if@monograph

\def\@makechapterhead#1{%
\hyphenpenalty10000
 \vspace*{26pt} { \baselineskip=1.5\baselineskip
 \parindent 0pt \centering
 \normalsize\bf #1\par
 \nobreak 
 \if@subtitledefined 
 \vskip 8pt
 \else
 \vskip 50pt
 \fi} }

\def\@makeschapterhead#1{%
\hyphenpenalty10000
\vspace*{26pt} { \baselineskip=1.5\baselineskip
 \parindent 0pt \centering
 \normalsize\bf #1\par
 \nobreak
 \if@subtitledefined
 \vskip 8pt
 \else
 \vskip 50pt
 \fi} }

\else % proceedings or editedvolume

\def\@makechapterhead#1{%
\hyphenpenalty10000
\vspace*{26pt} { \baselineskip=1.5\baselineskip
\parindent 0pt 
 \normalsize\bf #1\par
 \nobreak 
 \if@subtitledefined
 \vskip 8pt
 \else 
 \vskip 50pt
 \fi} }

\def\@makeschapterhead#1{%
\hyphenpenalty10000
\vspace*{26pt} {\baselineskip=1.5\baselineskip
 \parindent 0pt 
 \normalsize\bf #1\par
 \nobreak 
 \if@subtitledefined
 \vskip 8pt
 \else
 \vskip 50pt
 \fi} }

\fi

\if@monograph  % title centred: \\ = \@centercr

\def\chapter{\let\\=\@centercr  % added 21 Sep. '93 RdJ
   \cleardoublepage \thispagestyle{plain} \global\@topnum\z@
   \@afterindentfalse \secdef\@chapter\@schapter}

\else          % title flush left: \\ = \@normalcr

\def\chapter{\let\\=\@normalcr  % added 21 Sep. '93 RdJ
   \cleardoublepage \thispagestyle{plain} \global\@topnum\z@
   \@afterindentfalse \secdef\@chapter\@schapter}

\fi

\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
 \refstepcounter{chapter}
 \if@editedvolume \setcounter{section}{0}\fi
 \if@proceedings \setcounter{section}{0}\fi
 \typeout{\@chapapp\space\thechapter.}
 \addcontentsline{toc}{chapter}{\protect
 \numberline{\thechapter}#1}\else
 \addcontentsline{toc}{chapter}{#1}\fi
 \chaptermark{#1}
 \addtocontents{lof}{\protect\addvspace{10pt}}
 \addtocontents{lot}{\protect\addvspace{10pt}} \if@twocolumn
 \@topnewpage[\@makechapterhead{#2}]
 \else \@makechapterhead{#2}
 \@afterheading \fi} 
\def\@schapter#1{\if@twocolumn \@topnewpage[\@makeschapterhead{#1}]
 \else \@makeschapterhead{#1}
 \chaptermark{#1}
 \@afterheading\fi}


\def\vsecspace#1{\ifvmode\if@nobreak\else\vskip #1\relax\fi\fi}

\def\@makesectionhead#1{ \vsecspace{16pt} { \parindent 0pt %\centering
 \normalsize\bf\baselineskip 12pt \thesection.\hskip 0.7em #1\par
 \nobreak \vskip 8pt} }

\def\@makessectionhead#1{ \vsecspace{16pt} { \parindent 0pt %\centering
 \normalsize\bf\baselineskip 12pt #1\par
 \nobreak \vskip 8pt} }

\def\section{\@afterindentfalse \secdef\@section\@ssection}
\def\@section[#1]#2{\ifnum \c@secnumdepth >\m@ne
 \refstepcounter{section}
 \addcontentsline{toc}{section}{\protect
 \numberline{\thesection}#1}\else
 \addcontentsline{toc}{section}{#1}\fi
 \sectionmark{#1}
 \if@twocolumn\@topnewpage[\@makesectionhead{#2}]
 \else \@makesectionhead{#2}\@afterheading \fi}
\def\@ssection#1{\if@twocolumn \@topnewpage[\@makessectionhead{#1}]
 \else \@makessectionhead{#1}\@afterheading\fi}

\def\@makesubsectionhead#1{ \vsecspace{16pt} { \parindent 0pt \raggedright
 \small\rm \thesubsection.\hskip 0.7em  \uppercase{#1}\par
 \nobreak \vskip 8pt} }

\def\@makessubsectionhead#1{ \vsecspace{16pt} { \parindent 0pt \raggedright
 \small\rm \uppercase{#1}\par
 \nobreak \vskip 8pt} }

\def\subsection{\@afterindentfalse \secdef\@subsection\@ssubsection}
\def\@subsection[#1]#2{\ifnum \c@secnumdepth >\m@ne
 \refstepcounter{subsection}
 \addcontentsline{toc}{subsection}{\protect
 \numberline{\thesubsection}#1}\else
 \addcontentsline{toc}{subsection}{#1}\fi
 \if@twocolumn\@topnewpage[\@makesubsectionhead{#2}]
 \else \@makesubsectionhead{#2}\@afterheading \fi}
\def\@ssubsection#1{\if@twocolumn \@topnewpage[\@makessubsectionhead{#1}]
 \else \@makessubsectionhead{#1}\@afterheading\fi}

\if@monograph

\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{-13pt plus
  -1pt minus -.5pt}{1sp}{\normalsize\it}}

\else

\def\@makesubsubsectionhead#1{ \vsecspace{12pt} { \parindent 0pt \raggedright
  \normalsize\rm \thesubsubsection.\hskip 0.7em \it #1\par
  \nobreak \vskip 1sp} }

 \def\@makessubsubsectionhead#1{ \vsecspace{12pt} { \parindent 0pt \raggedright
  \normalsize\it #1\par
  \nobreak \vskip 1sp} }

\def\subsubsection{\@afterindentfalse \secdef\@subsubsection\@ssubsubsection}
\def\@subsubsection[#1]#2{\ifnum \c@secnumdepth >\m@ne
  \refstepcounter{subsubsection}
  \addcontentsline{toc}{subsubsection}{\protect
  \numberline{\thesubsubsection}#1}\else
  \addcontentsline{toc}{subsubsection}{#1}\fi
  \if@twocolumn\@topnewpage[\@makesubsubsectionhead{#2}]
  \else \@makesubsubsectionhead{#2}\@afterheading \fi}
\def\@ssubsubsection#1{\if@twocolumn \@topnewpage[\@makessubsubsectionhead{#1}]
  \else \@makessubsubsectionhead{#1}\@afterheading\fi}

\fi

\def\paragraph{\@startsection
 {paragraph}{4}{\z@}{3.25ex plus 1ex minus .2ex}{-12pt}{\normalsize\it}}
\let\subparagraph=\paragraph
%\def\subparagraph{\@startsection
% {subparagraph}{4}{\parindent}{3.25ex plus 1ex minus 
% .2ex}{-1em}{\normalsize\bf}}

\def\chaptermark#1{}

\if@monograph
  \setcounter{secnumdepth}{2}
\else
  \setcounter{secnumdepth}{3}
\fi

\def\acknowledgements{\section*{\acknowledgementsname}%
  \typeout{\acknowledgementsname}}

\def\appendix{\par
  \setcounter{section}{0}
  \setcounter{subsection}{0}%
  \def\thesection{\Alph{section}}}


\leftmargini 2em        %17mm
\leftmarginii 2.2em     %22pt 
\leftmarginiii 1.87em   %18.7pt 
\leftmarginiv 1.7em     %17pt 
\leftmarginv 1em        %10pt
\leftmarginvi 1em       %10pt
\leftmargin\leftmargini
\labelsep .4em          %10mm

\labelwidth\leftmargini \advance\labelwidth-\labelsep

\def\@listI{\leftmargin\leftmargini
  \parsep 0pt
  \topsep 3pt plus 1pt minus 1pt
  \itemsep 0pt}
  \let\@listi\@listI
  \@listi 

\def\@listii{\leftmargin\leftmarginii
  \labelwidth\leftmarginii\advance\labelwidth-\labelsep
  \topsep 4pt plus 2pt minus 1pt
  \parsep 2pt plus 1pt minus 1pt
  \itemsep \parsep}

\def\@listiii{\leftmargin\leftmarginiii
  \labelwidth\leftmarginiii\advance\labelwidth-\labelsep
  \topsep 2pt plus 1pt minus 1pt 
  \parsep \z@ \partopsep 1pt plus 0pt minus 1pt
  \itemsep \topsep}

\def\@listiv{\leftmargin\leftmarginiv
  \labelwidth\leftmarginiv\advance\labelwidth-\labelsep}

\def\@listv{\leftmargin\leftmarginv
  \labelwidth\leftmarginv\advance\labelwidth-\labelsep}

\def\@listvi{\leftmargin\leftmarginvi
  \labelwidth\leftmarginvi\advance\labelwidth-\labelsep}





\@ifundefined{refname}{\def\refname{References}}{\relax}
% \@ifundefined{bibname}{\def\bibname{Bibliography}}{\relax}
\@ifundefined{bibname}{\def\bibname{References}}{\relax}

\@ifundefined{tablename}{\def\tablename{TABLE}}{\relax}



\def\labelenumi{\theenumi.}    
\def\theenumi{\arabic{enumi}}     
 
\def\labelenumii{(\theenumii)}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}

\def\labelenumiii{\theenumiii.}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}

\def\labelenumiv{\theenumiv.}
\def\theenumiv{\Alph{enumiv}}     
\def\p@enumiv{\p@enumiii\theenumiii}

\def\labelitemi{$-$}
\def\labelitemii{$\bullet$}
\def\labelitemiii{$\ast$}
\def\labelitemiv{{\small $+$}}


\def\verse{\let\\=\@centercr  
  \list{}{\itemsep\z@
  \parskip 12pt
  \itemindent -1.5em
  \listparindent \itemindent 
  \rightmargin\leftmargin\advance\leftmargin 1.5em}\item[]}
\let\endverse\endlist

\def\quotation{\par\normalsize
  \list{}{\listparindent 0pt
%  \leftmargin 0pt
  \leftmargin 1.5em
  \listparindent 1em
  \topsep .5ex plus 2pt minus 1pt 
  \itemindent\listparindent
  \parsep 0pt plus 1pt}\item[]\hskip-1em}
\def\endquotation{\endlist\par}


\def\quote{\list{}{\leftmargin 1.5em
  \topsep.5ex plus 2pt minus 1pt}\item[]}
\let\endquote=\endlist

\def\descriptionlabel#1{\hspace\labelsep \bf #1}
\def\description{\list{}{\labelwidth\z@ 
   \itemindent-\leftmargin
   \let\makelabel\descriptionlabel}}
\let\enddescription\endlist

\newdimen\descriptionmargin
\descriptionmargin=3em


\def\titlepage{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
     \else \newpage \fi \thispagestyle{empty}\c@page\z@}

\def\endtitlepage{\if@restonecol\twocolumn \else \newpage \fi}


\arraycolsep 5pt     % Half the space between columns in an array environment.
\tabcolsep 6pt       % Half the space between columns in a tabular environment.
\arrayrulewidth .4pt % Width of rules in array and tabular environment.
\doublerulesep 2pt   % Space between adjacent rules in array or tabular env.

\tabbingsep \labelsep   % Space used by the \' command.  (See LaTeX manual.)


\skip\@mpfootins = \skip\footins

\fboxsep = 3pt    % Space left between box and text by \fbox and \framebox.
\fboxrule = .4pt  % Width of rules in box made by \fbox and \framebox.


\newcounter{part}
\newcounter {chapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]

\def\thepart          {\Roman{part}}
\def\thechapter       {\arabic{chapter}}
\if@monograph
  \def\thesection       {\thechapter.\arabic{section}}
\else
  \def\thesection       {\arabic{section}}
\fi
\def\thesubsection    {\thesection.\arabic{subsection}}
\def\thesubsubsection {\thesubsection .\arabic{subsubsection}}
\def\theparagraph     {\thesubsubsection.\arabic{paragraph}}
\def\thesubparagraph  {\theparagraph.\arabic{subparagraph}}
                     
\def\@chapapp{Chapter}


\def\part{\cleardoublepage   % Starts new page.
   \thispagestyle{plain}     % Page style of part page is 'plain'
  \if@twocolumn              % IF two-column style
     \onecolumn              %  THEN \onecolumn
     \@tempswatrue           %       @tempswa := true
    \else \@tempswafalse     %  ELSE @tempswa := false
  \fi                        % FI
  \hbox{}\vfil               % Add fil glue to center title  
  \secdef\@part\@spart}     

\def\@part[#1]#2{\ifnum \c@secnumdepth >-2\relax  % IF secnumdepth > -2
        \refstepcounter{part}                     %   THEN step part counter
        \addcontentsline{toc}{part}{\thepart      %        add toc line
        \hspace{1em}#1}\else                      %   ELSE add unnumbered line
        \addcontentsline{toc}{part}{#1}\fi        % FI
   \markboth{}{}
   {\centering                       % %% added 19 Jan 88
    \ifnum \c@secnumdepth >-2\relax  % IF secnumdepth > -2
      \huge\bf Part \thepart         %   THEN Print 'Part' and number
    \par                             %         in \huge bold.
    \vskip 20pt \fi                  %        Add space before title.
    \Huge \bf                        % FI
    #1\par}\@endpart}                % Print Title in \Huge bold.
    
\def\@endpart{\vfil\newpage   % End page with 1fil glue.
   \if@twoside                % IF twoside printing
       \hbox{}                %   THEN Produce totally blank page
       \thispagestyle{empty}  
       \newpage        
   \fi                        % FI
   \if@tempswa                % IF @tempswa = true       
     \twocolumn               %   THEN \twocolumn 
   \fi}                       % FI

\def\@spart#1{{\centering      % %% added 19 Jan 88
   \Huge \bf                   % Print title in \huge boldface
   #1\par}\@endpart}


\def\@pnumwidth{1.55em}
\def\@tocrmarg {2.55em}
\def\@dotsep{4.5}
\setcounter{tocdepth}{2}


\def\tableofcontents{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
  \fi\chapter*{{Table of Contents}\@mkboth{TABLE OF CONTENTS}{TABLE OF CONTENTS}}
  \@starttoc{toc}\if@restonecol\twocolumn\fi}

\def\l@part#1#2{\addpenalty{-\@highpenalty}
   \addvspace{2.25em plus 1pt}  % space above part line
   \begingroup
   \@tempdima 3em         % width of box holding part number, used by 
     \parindent \z@ \rightskip \@pnumwidth             %% \numberline
     \parfillskip -\@pnumwidth   
     {\large \bf          % set line in \large boldface
     \leavevmode          % TeX command to enter horizontal mode.       
     #1\hfil \hbox to\@pnumwidth{\hss #2}}\par
     \nobreak             % Never break after part entry
    \global\@nobreaktrue                        %% Added 24 May 89 as 
    \everypar{\global\@nobreakfalse\everypar{}}%% suggested by Jerry Leichter
   \endgroup}

\def\l@chapter#1#2{\addpenalty{-\@highpenalty}  
   \vskip 1.0em plus 1pt  % space above chapter line
   \@tempdima 1.5em       % width of box holding chapter number
   \begingroup
     \parindent \z@ \rightskip \@pnumwidth 
     \parfillskip -\@pnumwidth   
     \bf                  % Boldface.
     \leavevmode          % TeX command to enter horizontal mode.       
      \advance\leftskip\@tempdima  %% added 5 Feb 88 to conform to 
      \hskip -\leftskip            %% 25 Jan 88 change to \numberline
     #1\nobreak\hfil \nobreak\hbox to\@pnumwidth{\hss #2}\par
     \penalty\@highpenalty %% added 24 May 89 as suggested by J. Leichter
   \endgroup}

\def\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
\def\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}
\def\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}
\def\l@paragraph{\@dottedtocline{4}{10em}{5em}}
\def\l@subparagraph{\@dottedtocline{5}{12em}{6em}}


\def\listoffigures{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
  \fi\chapter*{List of Figures\@mkboth
   {LIST OF FIGURES}{LIST OF FIGURES}}\@starttoc{lof}\if@restonecol
   \twocolumn\fi}

\def\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}

\def\listoftables{\@restonecolfalse\if@twocolumn\@restonecoltrue\onecolumn
  \fi\chapter*{List of Tables\@mkboth
   {LIST OF TABLES}{LIST OF TABLES}}\@starttoc{lot}\if@restonecol
    \twocolumn\fi}

\let\l@table\l@figure


\def\thebibliography#1{{\section*{\refname}\@mkboth
  {\refname}{\refname}}\footnotesize
  \typeout{\refname}\def\bibwidthlabel{#1}\list
  {\kapbib@counter}{\kapbib@list}
    \let\makelabel\@biblabel
    \def\newblock{\hskip .11em plus .33em minus .07em}
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax}


\let\endthebibliography=\endlist


\if@numreferences
\if@namedreferences
  \@numreferencesfalse
\fi
\fi

\if@nato
  \@numreferencestrue
\fi

\if@NATO
  \@numreferencestrue
\fi


\if@numreferences

  \typeout{KAP -- Numbered References}

  \def\kapbib@counter{\arabic{enumi}}

  \def\kapbib@list{\setlength{\labelsep}{1em}%
    \settowidth{\labelwidth}{\@biblabel{\bibwidthlabel}}%
    \setlength{\leftmargin}{\labelwidth}%
    \addtolength{\leftmargin}{\labelsep}%
    \setlength{\itemindent}{0pt}%
    \setlength{\itemsep}{0pt}%
    \setlength{\parsep}{0pt}%
    \usecounter{enumi}%
    \let\makelabel\kap@biblabel}

  \def\@biblabel#1{\hfill #1.}

  \def\@bibitem#1{\item\if@filesw\immediate\write\@auxout
    {\string\bibcite{#1}{\the\value{\@listctr}}}\fi\ignorespaces}


\def\@lbibitem[#1]#2{\item\if@filesw
    {\def\protect##1{\string ##1\space}\immediate
    \write\@auxout{\string\bibcite{#2}{\the
    \value{\@listctr}}}}\fi\ignorespaces}


\let\@internalcite\cite
\def\cite{\@ifstar{\@internalcite}{\@internalcite}}

\def\shortcite{\@ifstar{\@internalcite}{\@internalcite}}
\def\citeauthor{\@ifstar{\@internalcite}{\@internalcite}}
\def\citeyear{\@ifstar{\@internalcite}{\@internalcite}}

\def\citeauthoryear{}

\def\kluwer@cite#1#2{}

  \def\@citex[#1]#2{\if@filesw\immediate\write\@auxout{\string\citation{#2}}\fi
    \def\@citea{}\@cite{\@for\@citeb:=#2\do
      {\@citea\def\@citea{,\penalty\@m\ }\@ifundefined
        {b@\@citeb}{{\bf ?}\@warning
            {Citation `\@citeb' on page \thepage \space undefined}}%
          {\csname b@\@citeb\endcsname}}}{#1}}

\else

%%%% \if@namedreferences % IF AUTHOR USED DOCUMENTSTYLE [namedreferences]
                    % NEW DEFINITIONS FROM NAMED.STY 

  \typeout{KAP -- Documentstyle Named References}

  \def\kapbib@counter{\relax}

  \def\kapbib@list{\setlength{\labelsep}{0em}%
        \setlength{\labelwidth}{0pt}%
	\setlength{\itemindent}{-\bibhang}%
	\setlength{\itemsep}{0pt}%
	\setlength{\parsep}{0pt}%
	\setlength{\leftmargin}{\bibhang}}

  \newlength{\bibhang}
  \setlength{\bibhang}{1.4em}


  \def\@biblabel#1{}

  
\def\@up#1{\raisebox{.2ex}{#1}}%[rmjw]

\let\@internalcite\cite


\def\cite{\def\@citeseppen{-1000}%
\def\@cite##1##2{({##1\if@tempswa , ##2\fi})}%
    \def\citeauthoryear##1##2{\rm ##1, ##2}\@internalcite}

\def\shortcite{\def\@citeseppen{1000}%
    \def\@cite##1##2{({##1\if@tempswa , ##2\fi})}%
    \def\citeauthoryear##1##2{\rm ##2}\@internalcite}

\def\citeauthor#1{\def\@citeseppen{1000}%
    \def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
    \def\citeauthoryear##1##2{\rm ##1}\@citedata{#1}}

\def\citeyear#1{\def\@citeseppen{1000}%
    \def\@cite##1##2{{##1\if@tempswa , ##2\fi}}%
    \def\citeauthoryear##1##2{\rm ##2}\@citedata{#1}}

\def\@citedata#1{\@tempswafalse%
 \if@filesw\immediate\write\@auxout{\string\citation{#1}}\fi
  \def\@citea{}\@cite{\@for\@citeb:=#1\do
    {\@citea\def\@citea{,\penalty\@citeseppen\ }\@ifundefined
       {b@\@citeb}{{\bf ?}\@warning
       {Citation `\@citeb' on page \thepage \space undefined}}%
{\csname b@\@citeb\endcsname}}}{}}


\def\@citex[#1]#2{\if@filesw\immediate\write\@auxout{\string\citation{#2}}\fi
  \def\@citea{}\@cite{\@for\@citeb:=#2\do
    {\@citea\def\@citea{;\penalty\@citeseppen\ }\@ifundefined
       {b@\@citeb}{{\bf ?}\@warning
       {Citation `\@citeb' on page \thepage \space undefined}}%
{\csname b@\@citeb\endcsname}}}{#1}}

\def\kluwer@cite#1#2{}

%%% \else 
%%% 
%%% 
%%%   \typeout{KAP -- Named References}
%%% 
%%%   \def\kapbib@counter{\relax}
%%% 
%%%   \def\kapbib@list{\setlength{\labelsep}{0em}%
%%% 	\setlength{\labelwidth}{0pt}%
%%% 	\setlength{\itemindent}{-\bibhang}%
%%% 	\setlength{\itemsep}{0pt}%
%%% 	\setlength{\parsep}{0pt}%
%%% 	\setlength{\leftmargin}{\bibhang}}
%%% 
%%%   \newlength{\bibhang}
%%%   \setlength{\bibhang}{1.4em}
%%% 
%%%   \def\@biblabel#1{}
%%% 
%%%   \def\@lbibitem[#1]#2{\item[\@biblabel{#1}]\if@filesw
%%%     {\def\protect##1{\string ##1\space}\immediate
%%%     \write\@auxout{\string\bibcite{#2}{\string
%%%     \bibnameyear #1}}}\fi\ignorespaces}
%%% 
%%%   \let\@internalcite\cite
%%% 
%%%   \def\cite{\@ifstar{\citeyear}{\citefull}}
%%%   \def\citefull{\def
%%%      \kluwer@cite##1##2{##1, ##2}\@internalcite}
%%%   \def\citeyear{\def
%%%      \kluwer@cite##1##2{##2}\@internalcite}
%%% 
%%% \def\shortcite{}
%%% \def\citeauthor{}
%%% \def\citeyear{}
%%% \def\citeauthoryear{}
%%% %\let\shortcite=\cite
%%% %\let\citeauthor=\cite
%%% %\let\citeyear=\cite
%%% % \def\citeauthoryear{}
%%% 
%%% 
%%%   \def\@citex[#1]#2{\if@filesw\immediate\write
%%%      \@auxout{\string\citation{#2}}\fi
%%%     \def\@citea{}\@cite{\@for\@citeb:=#2\do
%%%       {\@citea\def\@citea{;\penalty\@m\ }\@ifundefined
%%% 	{b@\@citeb}{{\bf ?}\@warning
%%% 	  {Citation `\@citeb' on page \thepage
%%% 	   \space undefined}}%
%%% 	{\csname b@\@citeb\endcsname}}}{#1}}
%%% 
%%% 
%%% \fi % \if@namedreferences
\fi % \if@numreferences


\def\astroncite{\kluwer@cite}
\def\bibnameyear{\kluwer@cite}
 

\newif\if@restonecol

\def\theindex{\@restonecoltrue\if@twocolumn\@restonecolfalse\fi
\columnseprule \z@
\columnsep 35pt\twocolumn[\@makeschapterhead{INDEX}]
    \@mkboth{INDEX}{INDEX}\thispagestyle{plain}\parindent\z@
    \parskip\z@ plus .3pt\relax\let\item\@idxitem}

\def\@idxitem{\par\hangindent 40pt}

\def\subitem{\par\hangindent 40pt \hspace*{20pt}}

\def\subsubitem{\par\hangindent 40pt \hspace*{30pt}}

\def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}

\def\indexspace{\par \vskip 10pt plus 5pt minus 3pt\relax}


\def\footnoterule{}

\@addtoreset{footnote}{chapter}  % Numbers footnotes within chapters

\long\def\@makefntext#1{\parindent 1em\noindent 
            \hbox to 1.8em{\hss$^{\@thefnmark}$}#1}


\setcounter{topnumber}{2}
\def\topfraction{.99}
\setcounter{bottomnumber}{1}
\def\bottomfraction{.3}
\setcounter{totalnumber}{3}
\def\textfraction{.01}
\def\floatpagefraction{.9}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.7}
\def\dblfloatpagefraction{.5}


% FROM KLUWER.STY

\newif\if@adjustcaption
\newif\if@captionabovetabular
\newif\if@tabularabovecaption
\newdimen\@tabularwidth


\def\@tablecapfont{\footnotesize}
\def\@figcapfont{\footnotesize}

\long\def\@makecaption#1#2{\vskip 10pt
 \ifnum\cap@type=1 
  \typeout{Figure \thefigure}%
  \setbox\@tempboxa\hbox{\@figcapfont #1 #2}%
  \ifdim \wd\@tempboxa >\hsize \unhbox\@tempboxa\@figcapfont\par \else
   \hbox to\hsize{\hbox{}\hfil\box\@tempboxa\hfil} \fi \fi
  \ifnum\cap@type=2 
   \typeout{\tablename\space\thetable}%
   \if@adjustcaption
   \if@tabularabovecaption\@maketablecaption{#1}{#2}\else
   \global\@captionabovetabulartrue\gdef\@captab{{#1}{#2}}\fi\else
   \@maketablecaption{#1}{#2}\fi\fi}


\long\def\@maketablecaption#1#2{\if@adjustcaption
    \setbox\@tempboxa\hbox{\@tablecapfont #1#2}%
    \ifdim\wd\@tempboxa>\@tabularwidth
      \@tablecapfont
      \centerline{\parbox{\@tabularwidth}{\unhbox\@tempboxa}}\par
      \else
     \hbox to\hsize{\hfil\box\@tempboxa\hfil} \fi
  \else
    \setbox\@tempboxa\hbox{\@tablecapfont #2}%
    \ifdim\wd\@tempboxa>\hsize #1 \unhbox\@tempboxa\@tablecapfont
    \else
    \hbox to\hsize{\hfil\box\@tempboxa\hfil} \fi
  \fi \vspace{3pt}}
 

\let\kap@tabular\tabular
\let\kap@endtabular\endtabular


% \hline redefined within tabular environment: 3pt extra space above and below


\def\tabular{%
\def\hline{\noalign{\ifnum0=`}\fi\vskip 3pt\hrule \@height \arrayrulewidth 
\vskip 3pt \futurelet
   \@tempa\@xhline}
\begingroup\centering\if@captionabovetabular
  \else\global\@tabularabovecaptiontrue\fi
  \setbox\strutbox\hbox{\vrule height.8\baselineskip
  depth.4\baselineskip width\z@}\setbox0=\hbox\bgroup\kap@tabular}
\def\endtabular{\kap@endtabular\egroup\global\@tabularwidth\wd0
  \if@adjustcaption\if@captionabovetabular
  \expandafter\@maketablecaption\@captab\fi\fi\unhbox0\endgroup}



\newcounter{figure}[chapter]
\if@monograph
  \def\thefigure{\thechapter.\@arabic\c@figure}
\else
  \def\thefigure{\@arabic\c@figure}
\fi
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\footnotesize{\it Figure~\thefigure.~~}}
% \def\figure{\@float{figure}}
\def\figure{\def\cap@type{1} \@float{figure}} % FROM KLUWER.STY
\let\endfigure\end@float
\@namedef{figure*}{\def\cap@type{1} \@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}

\newcounter{table}[chapter]
\if@monograph
\def\thetable{\thechapter.\@arabic\c@table}
\else
\def\thetable{\@arabic\c@table}
\fi

\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\footnotesize{TABLE~\thetable.~~}}
% \def\table{\@float{table}}
\def\table{\def\cap@type{2}\@adjustcaptiontrue\@captionabovetabularfalse
 \@tabularabovecaptionfalse\footnotesize \@float{table}}
\let\endtable\end@float
\@namedef{table*}{\def\cap@type{2}\@adjustcaptiontrue\@captionabovetabularfalse
 \@tabularabovecaptionfalse\footnotesize \@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat}


\def\maketitle{\kap@warning
  \typeout{ -- '\string\maketitle' is not needed, title is made by
  document style^^J}}


\def\subtitle@#1{\gdef\@subtitle{#1}%
\global\@subtitledefinedtrue}


\def\maketitle@@{%
  \begingroup
    \setcounter{footnote}{0}%
    \def\thefootnote{\fnsymbol{footnote}}%
    \gdef\thanks##1{\footnotemark\begingroup
    \def\protect{\noexpand\protect\noexpand}\xdef\@thanks{\@thanks
        \protect\footnotetext[\the\c@footnote]{##1}}\endgroup}%
    \@maketitle
    \@thanks
  \endgroup
\setcounter{footnote}{0}
\let\maketitle\relax
\let\@maketitle\relax
\gdef\@thanks{}%
\gdef\@title{}%
\gdef\@authors{}%
\let\thanks\relax}



\newif\if@keywords \@keywordsfalse
\def\@keywords{}
 \long\def\keywords#1\end@keywords{\gdef\@keywords{#1}%
  \global\@keywordstrue}

\newif\if@abstract \@abstractfalse

\long\def\abstract#1\end#2{\gdef\@abstract{#1\end@keywords
  }\@abstracttrue\end{#2}}
\def\endabstract{\make@abstract\vskip24pt\relax}
\def\@abstract{}
\def\end@keywords{}

% \def\make@abstract{{\normalsize\typeout{\abstractname}
%   {\noindent{\bf \abstractname.}\@abstract}\gdef\@abstract{}
%   \if@keywords{\vskip 1\baselineskip\typeout{\keywordsname}
%     \noindent{\bf \keywordsname:\/} \@keywords\gdef
%     \@keywords{}}\fi
% \par}}

\def\make@abstract{{\normalsize\typeout{\abstractname}
  {\noindent{\bf \abstractname.}\@abstract}\gdef\@abstract{}
  \if@keywords{%
    \vskip 1\baselineskip\typeout{\keywordsname}
    \noindent{\bf \keywordsname:\/} \@keywords\gdef
    \@keywords{}%
}\fi
\par}}

\if@monograph


\def\@maketitle{\begingroup
    \chapter{\@title}
\thispagestyle{myheadings}%  THISPAGESTYLE SHOULD COME AFTER TITLE
    \if@subtitledefined
     \begin{center}
      {\large\it \@subtitle}\par
     \end{center}
      \vskip 33pt
    \fi
  \endgroup
}


\else  % proceedings, editedvolume or NATO



\newskip\afterauthinsskip

\def\@maketitle{\begingroup
    \chapter{\@title}
% \thispagestyle{myheadings}%  THISPAGESTYLE SHOULD COME AFTER TITLE
\thispagestyle{empty}%
    \if@subtitledefined
     {\normalsize\it \@subtitle}\par
     \vskip 2\baselineskip%3pc
     \fi
     {\advance\leftskip by 5pc   % For indentation of \author & \insitute
        \setbox\@tempboxa\vbox{\@formatauthorsandinstitutes}%
        \ifdim\ht\@tempboxa<1.5pc \afterauthinsskip 4pc
        \else\ifdim\ht\@tempboxa<2.5pc \afterauthinsskip 3pc
              \else\afterauthinsskip 2pc
              \fi
        \fi
    \normalsize\@formatauthorsandinstitutes
    \vskip \afterauthinsskip\relax}
 \endgroup
}

\fi


\newif\ifkern@mathmode \kern@mathmodefalse

\def\kern@charspace{\kern 0.5ex}
\def\kern@wordspace{\unskip\hskip 0.5em}

\def\@kap@tfor#1:=#2\do#3{\def\@fortmp{#2}\ifx\@fortmp\@empty
  \else\@tforloop#2\@nil\@nil\@@#1{#3}\fi}

\def\charkern#1{\begingroup
  \def\@@kc{#1}
  \def\c@@k{@s@e@v@y}%
  \def\ck@@##1 @s@e@v@y\@@ck{\def\@@kc{##1}}%
  \def\ck@##1 ##2\@@ck{\def\@kc{##1}\def\@@kc{##2}}%
  \def\iterate{\expandafter\expandafter\expandafter\ck@
    \expandafter\@@kc\space @s@e@v@y\@@ck
    \expandafter\@kernword\expandafter{\@kc}%
    \ifx\@@kc\c@@k
      \let\next\relax
    \else
      \expandafter\ck@@\@@kc\@@ck
      \let\next\iterate\kern@wordspace
    \fi\next}\iterate
  \endgroup}

\def\@kernword#1{\def\d@ll@rm@th{$}\@kap@tfor\@nextchar:=#1\do{%
    \ifx\@nextchar\d@ll@rm@th
      \ifkern@mathmode
        \kern@mathmodefalse
        $\kern@math$%
      \else
        \kern@mathmodetrue
        \xdef\kern@math{}%
      \fi
    \else
      \ifkern@mathmode
        \begingroup
          \def\protect{\noexpand}%
          \xdef\kern@math{\kern@math\@nextchar}%
        \endgroup
      \else
        \uppercase\expandafter{\@nextchar}\kern@charspace
      \fi
    \fi}}



\def\numtoword#1{\ifcase#1\or one\or two\or three\or four\or
    five\or six\or seven\or eight\or nine\or ten\or eleven\or twelve\or
    thirteen\or fourteen\or fifteen\or sixteen\or seventeen\or
    eighteen\or nineteen\fi}

\mark{{}{}}   % Initializes TeX's marks

\if@monograph

\def\ps@headings{\let\@mkboth\@gobbletwo
\def\@oddfoot{}\def\@evenfoot{}%       No feet.
\def\@evenhead{\rm\normalsize\hbox to 0pt{\thepage\hss}\hfil
  \small\leftmark\hfil}%
\def\@oddhead{\hbox{}\rm\small\hfil\rightmark\hfil
  \rm\normalsize\hbox to 0pt{\hss\thepage}}%
\def\chaptermark##1{%
\markboth{\expandafter\protect
 \expandafter{CHAPTER \thechapter}}%
 {\expandafter\protect\expandafter{\@runningtitle}}}%

\def\sectionmark##1{}}

\def\ps@myheadings{\let\@mkboth\@gobbletwo
\def\@oddhead{\hbox{}\rm\small\hfil\leftmark\hfil}%
\def\@oddfoot{\hbox{}\hfil\rm\normalsize\thepage\hfil}%
\let\@evenhead\@oddhead%
\let\@evenfoot\@oddfoot%
\def\chaptermark##1{}%
\def\sectionmark##1{}%
\def\subsectionmark##1{}}

\else\if@proceedings 

\def\ps@headings{\let\@mkboth\@gobbletwo
\def\@oddfoot{}\def\@evenfoot{}%       No feet.
\def\@evenhead{\rm\normalsize\hbox to 0pt{\thepage\hss}\hfil
 \small\@runningauthor\hfil}%
\def\@oddhead{\hbox{}\rm\small\hfil\rightmark\hfil
  \rm\normalsize\hbox to 0pt{\hss\thepage}}%
\def\chaptermark##1{%
\markboth{\expandafter\protect\expandafter{\@runningauthor}}%
{\expandafter\protect\expandafter{\@runningtitle}}}%
\def\sectionmark##1{}}

\def\ps@myheadings{\let\@mkboth\@gobbletwo
   \def\@oddhead{\hbox{}\rm\small\hfil
   \expandafter{\@runningauthor}\hfil}%
\def\@oddfoot{{\parindent 0pt
  \parbox{\textwidth}{\hbox{}\vskip 3pt
  \hbox{}\hfil\rm\normalsize\thepage\hfil\\
  \vskip 0pt\small\@copyright}}}
  \let\@evenhead\@oddhead%
  \let\@evenfoot\@oddfoot%
  \def\chaptermark##1{}%
  \def\sectionmark##1{}%
  \def\subsectionmark##1{}}

\else\if@editedvolume

\def\ps@headings{\let\@mkboth\@gobbletwo
\def\@oddfoot{}\def\@evenfoot{}%       No feet.
\def\@evenhead{\rm\normalsize\hbox to 0pt{\thepage\hss}\hfil
 \small\@runningauthor\hfil}%
\def\@oddhead{\hbox{}\rm\small\hfil\rightmark\hfil
  \rm\normalsize\hbox to 0pt{\hss\thepage}}%
\def\chaptermark##1{%
\markboth{\expandafter\protect\expandafter{\@runningauthor}}%
{\expandafter\protect\expandafter{\@runningtitle}}}%
\def\sectionmark##1{}}

\def\ps@myheadings{\let\@mkboth\@gobbletwo
   \def\@oddhead{\hbox{}\rm\small\hfil
   \expandafter{\@runningauthor}\hfil}%
\def\@oddfoot{{\parindent 0pt
  \parbox{\textwidth}{\hbox{}\vskip 3pt
  \hbox{}\hfil\rm\normalsize\thepage\hfil\\
  \vskip 0pt\small\@copyright}}}
  \let\@evenhead\@oddhead%
  \let\@evenfoot\@oddfoot%
  \def\chaptermark##1{}%
  \def\sectionmark##1{}%
  \def\subsectionmark##1{}}

\else % NATO

\def\ps@headings{\let\@mkboth\@gobbletwo
\def\@oddfoot{}\def\@evenfoot{}%       No feet.
\def\@evenhead{\rm\normalsize\hbox to 0pt{\thepage\hss}\hfil}%
\def\@oddhead{\hfil\rm\normalsize\hbox to 0pt{\hss\thepage}}%
\def\chaptermark##1{}%
\def\sectionmark##1{}}

\def\ps@myheadings{\let\@mkboth\@gobbletwo
\def\@oddfoot{}\def\@evenfoot{}%       No feet.
\def\@evenhead{}\def\@oddhead{}%
\def\chaptermark##1{}%
\def\sectionmark##1{}}

\fi
\fi
\fi


\newif\if@runningtitleset
\newif\if@runningauthorset


  \def\runningtitle#1{\if@runningtitleset\else
    \xdef\@runningtitle{{\uppercase{#1}}}\fi
    \global\@runningtitlesettrue}
  \gdef\@runningtitle{}


% \def\runningauthor#1{\if@runningauthorset\else
%    \xdef\@runningauthor{#1}\global\@runningauthorsettrue\fi}
%    \gdef\@runningauthor{}
\def\runningauthor#1{\if@runningauthorset\else
   \xdef\@runningauthor{{\uppercase{#1}}}\fi
   \global\@runningauthorsettrue}
   \gdef\@runningauthor{}



\newif\ifopening@opened \opening@openedfalse
\newif\ifopening@closed \opening@closedfalse

\def\opening{\global\opening@openedtrue
  \let\title=\title@
  \let\subtitle=\subtitle@
  \let\author=\author@
  \let\institute=\institute@
  \let\date=\date@
  \let\thanks=\footnote}
\def\endopening{\global\opening@closedtrue
   \let\title=\opening@only
   \let\subtitle=\opening@only
   \let\author=\opening@only
   \let\institute=\opening@only
   \let\date=\opening@only}
 
\def\opening@only#1{\kap@warning\typeout{ -- \string\title, \string\subtitle,
  \string\author, \string\institute, or \string\date { }effective only
  inside}\typeout{ -- opening environment. Please refer to Author's
  Instructions.^^J}}

\let\title=\opening@only
\let\subtitle=\opening@only
\let\author=\opening@only
\let\institute=\opening@only
\let\date=\opening@only
 

\newtoks\t@a
\newtoks\t@b
\long\def\append@item#1\to#2{\t@a={\@k@p{#1}}\t@b=\expandafter{#2}%
  \xdef#2{\the\t@b\the\t@a}}
\def\get@left#1\to#2{\expandafter\g@l#1\g@l#1#2}
\long\def\g@l\@k@p#1#2\g@l#3#4{\def#4{#1}\def#3{#2}}

\def\noauthors{}

\def\@authors{}
\def\@allauthors{}
\def\@institutes{}
\def\authors@institute{}


% \\ is defined as space before runningtitle is read out

% \def\title@#1{\gdef\@title{#1}\def\\{ }\xdef\@runningtitle{#1}}

\def\title@#1{\gdef\@title{\uppercase{#1}}\def\\{ }\xdef\@runningtitle{#1}
               \typeout{KAP -- Title Uppercase}}

\def\subtitle@#1{\gdef\@subtitle{#1}\global\@subtitledefinedtrue}


\def\author@#1{\append@item#1\to\@authors
  \append@item#1\to\@allauthors \xdef\@runningauthor{#1}}
\def\institute@#1{\append@item#1\to\@institutes
  \expandafter\append@item\expandafter{\@authors}\to\authors@institute
  \gdef\@authors{}}

% \def\date@#1{\gdef\@date{#1}}

\def\date@#1{}


\newif\ifthanks 
\newbox\@kapbox 
\newcount\@kapcount


\@ifundefined{author@uppercase}{

  \typeout{KAP -- Author(s) Normal}

  \def\@formatname#1#2{\@kapcount\c@footnote\begingroup
    \def\thanks##1{\global\thankstrue}\setbox\@kapbox\vbox{#1}\endgroup
    \c@footnote\@kapcount
    \begingroup
      \ifthanks
        \def\fn##1\thanks##2{{##1}\hbox
          to 0pt{#2\hss}\thanks{##2}}\expandafter\fn#1
      \else
        \def\fn##1{{##1}#2}\expandafter\fn\expandafter{#1}\fi
    \endgroup\global\thanksfalse}

}{

  \typeout{KAP -- Author(s) Uppercase}

  \def\@formatname#1#2{\@kapcount\c@footnote\begingroup
  \def\thanks##1{\global\thankstrue}\setbox\@kapbox\vbox{#1}\endgroup
    \c@footnote\@kapcount
    \begingroup
      \ifthanks
        \def\fn##1\thanks##2{\uppercase{##1}\hbox
          to 0pt{#2\hss}\thanks{##2}}\expandafter\fn#1
      \else
        \def\fn##1{\uppercase{##1}#2}\expandafter\fn\expandafter{#1}\fi
    \endgroup\global\thanksfalse}

}


\def\@formatauthors{{\small\begingroup
  \newcount\cnt@authors
  \cnt@authors=0\def\@k@p##1{\advance\cnt@authors by 1}\@curauths
  \def\@k@p##1{\advance\cnt@authors by -1
    \ifnum\cnt@authors>1 \hbox{\@formatname{##1}{,}\penalty-1000}\space\fi
    \ifnum\cnt@authors=1 \hbox{\@formatname{##1}{} AND\penalty-1000}\space\fi
   \ifnum\cnt@authors<1 \hbox{\@formatname{##1}{}}\par\fi}\@curauths
  \endgroup}}


\def\@formatinstitute{{\normalsize\it \@curinst\par}}

\def\@formatauthorsandinstitutes{\begingroup
  \newcount\cnt@institutes
  \newcount\cnt@authors
  \newbox\@authbox
  \cnt@authors=0\def\@k@p##1{\advance\cnt@authors by 1}\@allauthors
  \xdef\@authnames{}%
  \begingroup
    \def\thanks##1{}%
    \def\@k@p##1{\advance\cnt@authors by -1
      \ifnum\cnt@authors=0 \xdef\@authnames{\@authnames ##1}\fi
      \ifnum\cnt@authors=1 \xdef\@authnames{##1\ AND }\fi
      \ifnum\cnt@authors>1 \xdef\@authnames{##1\ ET AL.}\cnt@authors=0\fi}%
    \global\setbox\@authbox=\hbox{\@allauthors}%
    \expandafter\runningauthor\expandafter{\@authnames}
  \endgroup
  \cnt@institutes=0
  \def\@k@p##1{\advance\cnt@institutes by 1}\@institutes
  \loop\ifnum\cnt@institutes>0
    \get@left\authors@institute\to\@curauths
    \noindent\@formatauthors
    \get@left\@institutes\to\@curinst
    \noindent\@formatinstitute
    \ifnum\cnt@institutes=2
      \vskip 0.4\baselineskip
       \noindent {\small AND} % and
    \fi
    \ifnum\cnt@institutes>1
      \vskip 0.4\baselineskip
    \fi
    \advance\cnt@institutes by -1
  \repeat\endgroup}


\def\kap@warning{\typeout{^^J !! KAP Style File Warning}}

\newread\@editorfile
\newread\@kapjrnls
\let\kapdocument\document

\def\document{\kapdocument
  \ifopening@opened
    \ifopening@closed
    \else
      \@latexerr{`opening' environment not closed}{Close `opening' environment
        before beginning of document}
    \fi
  \else
    \@latexerr{No `opening' environment present}{Use `opening' environment
      before beginning of document}
  \fi
  \let\kap@chapter\chapter
  \def\chapter##1{\setcounter{chapter}{##1}\addtocounter{chapter}{-1}}
  \openin\@editorfile=\jobname.kap
  \ifeof\@editorfile
    \closein\@editorfile
  \else
    \closein\@editorfile \input{\jobname.kap} \setlastpage
    \typeout{^^J -- File `\jobname.tex' processed with Kluwer Editor file for:}
    \typeout{ -- \@journal^^J}
  \fi\par
  \let\chapter\kap@chapter
\maketitle@@}

\let\kapenddocument\enddocument
\def\enddocument{\label{lastpage} \kapenddocument}
 
\def\editor#1{\gdef\@kapident{\hbox{}\hfill\elvtt #1\\
  \hbox{}\hfill\jobname.tex - Date: \today~Time: \timenow\par}}
\let\typesetter\editor
\gdef\@kapident{}

\newif\if@editorsset
\def\editors#1{\gdef\@editors{#1}\global\@editorssettrue}
\def\@editors{}

\def\@copyright{\footnotesize\vskip 2\baselineskip\vskip1em
  \normalsize\@kapident}

\newcount\@hour
\newcount\@minute
\def\timenow{\@hour=\time \divide\@hour by 60 \number\@hour:%
  \multiply\@hour by 60 \@minute=\time \global\advance\@minute by -\@hour%
  \ifnum\@minute<10 0\number\@minute\else\number\@minute\fi}
 
\def\journal#1{\@ifundefined{@#1}{\kap@warning\typeout{ --
      Journal code `#1' does not exist.^^J}}{\csname @#1\endcsname}
  \gdef\@copyright{\footnotesize
  \it
  \if@editorsset \@editors~(eds), \fi
  \@journal, \@firstpage--\@lastpage.
  \hfill\hbox{}\\
  \copyright~\number\@pubyear~{\it\@printline}
  \hfill\hbox{}\par
  \vskip 1em
  \normalsize\@kapident}}
\gdef\@journal{NAME OF JOURNAL}

\def\book#1{\@ifundefined{@#1}{\kap@warning\typeout{ --
      Book code `#1' does not exist.^^J}}{\csname @#1\endcsname}
  \gdef\@copyright{\footnotesize
  \it
  \if@editorsset \@editors~(eds), \fi
  \@book, \@firstpage--\@lastpage.
  \hfill\hbox{}\\
  \copyright~\number\@pubyear~{\it\@printline}
  \hfill\hbox{}\par
  \vskip 1em
  \normalsize\@kapident}}
\gdef\@book{NAME OF BOOK PROJECT}

\def\@printline{\@kap. \@prin\ \@country.}
\def\@kap{Kluwer Academic Publishers}
\def\@prin{Printed in}

\def\country#1{\gdef\@country{#1}}
\gdef\@country{\@defaultcountry}
\def\defaultcountry#1{\gdef\@defaultcountry{#1}}
\defaultcountry{the Netherlands}

\def\volume#1{\gdef\@volume{#1}}
\gdef\@volume{0}

\def\pubyear#1{\gdef\@pubyear{#1}}
\gdef\@pubyear{\year}

\def\firstpage#1{\c@page=0 \global\advance\c@page by #1
  \xdef\@firstpage{\thepage}}
\gdef\@firstpage{1}

\def\lastpage#1{\gdef\@lastpage{#1}}
\def\setlastpage{\@ifundefined{r@lastpage}{}{\expandafter\@setlastp\r@lastpage}}
\def\@setlastp#1#2{\gdef\@lastpage{#2}}
\gdef\@lastpage{1}

\def\received#1{\gdef\@pubdate{(#1)}}
\gdef\@pubdate{\@date}

\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}


\@addtoreset{equation}{chapter}   % Makes \chapter reset 'equation' counter.
\if@monograph
\def\theequation{\thechapter.\arabic{equation}}
\else
\def\theequation{\arabic{equation}}
\fi

\clubpenalty=4000
\widowpenalty=4000
\ps@headings                % `headings' page style
\pagenumbering{arabic}      % Arabic page numbers
\onecolumn                  % Single-column.
\frenchspacing


% File kapjrnls.tex contains information for copyright lines;
% to be added by Kluwer Academic Publishers

  \openin\@kapjrnls=kapjrnls.tex 
  \ifeof\@kapjrnls
    \closein\@kapjrnls
    \else
    \closein\@kapjrnls \input{kapjrnls.tex}
  \fi\par


% \input fleqn.sty
% fleqn.sty 26-Sep-89
 
% \def\[{\relax\ifmmode\@badmath\else
%  \begin{trivlist}
%  \@beginparpenalty\predisplaypenalty
%  \@endparpenalty\postdisplaypenalty
%  \item[]\leavevmode
%  \hbox to\linewidth\bgroup$ \displaystyle
%  \hskip\mathindent\bgroup\fi}
% \def\]{\relax\ifmmode \egroup $\hfil \egroup \end{trivlist}\else \@badmath \fi}
% \def\equation{\@beginparpenalty\predisplaypenalty
%  \@endparpenalty\postdisplaypenalty
% \refstepcounter{equation}\trivlist \item[]\leavevmode
%  \hbox to\linewidth\bgroup $ \displaystyle
% \hskip\mathindent}
% \def\endequation{$\hfil \displaywidth\linewidth\@eqnnum\egroup \endtrivlist}
% \def\eqnarray{\stepcounter{equation}\let\@currentlabel=\theequation
% \global\@eqnswtrue
% \global\@eqcnt\z@\tabskip\mathindent\let\\=\@eqncr
% \abovedisplayskip\topsep\ifvmode\advance\abovedisplayskip\partopsep\fi
% \belowdisplayskip\abovedisplayskip
% \belowdisplayshortskip\abovedisplayskip
% \abovedisplayshortskip\abovedisplayskip
% $$\halign to
% \linewidth\bgroup\@eqnsel\hskip\@centering$\displaystyle\tabskip\z@
%  {##}$&\global\@eqcnt\@ne \hskip 2\arraycolsep \hfil${##}$\hfil
%  &\global\@eqcnt\tw@ \hskip 2\arraycolsep $\displaystyle{##}$\hfil
%  \tabskip\@centering&\llap{##}\tabskip\z@\cr}
% \def\endeqnarray{\@@eqncr\egroup
%  \global\advance\c@equation\m@ne$$\global\@ignoretrue }
% \newdimen\mathindent
% \mathindent = \leftmargini

% end fleqn.sty 

% \mathindent 3pc
