\NeedsTeXFormat{LaTeX2e}[1995/06/01]
\newcommand{\rmaa@version}{0.7}
\newcommand{\rmaa@date}{1999/10/04}
%% version 0.7 : Increased spacing between sections in single column
%%                 styles. 
%%               Suppressed floats at bottom of pages (didn't work though)
%% version 0.6 : Tweaked \adjustfinalcols (still not perfect)
%%               Added proceedings option
%%               Added onecolumn/twocolumn options (orthogonal to
%%                 journal/proceedings) 
%\ProvidesClass{rmaa}[1999/09/24 v0.6 RevMexAA article class]
%% version 0.5 : Added \fulladdresses and \adjustfinalcols (just about 
%%                 working) 
%\ProvidesClass{rmaa}[1999/09/23 v0.5 RevMexAA article class]
%% version 0.4 : Minor stylistic changes
%\ProvidesClass{rmaa}[1999/09/22 v0.4 RevMexAA article class]
%% version 0.3 : Better mechanism for alternative affiliations
%%               Added `guide' option for user guide
%\ProvidesClass{rmaa}[1999/06/28 v0.3 RevMexAA article class]
%% version 0.2 : All basic functionality present, I think
%\ProvidesClass{rmaa}[1999/05/27 v0.2 RevMexAA article class]
%% version 0.1 : Just about working - still missing Fig/Tab/Refs
%\ProvidesClass{rmaa}[1999/05/26 v0.1 RevMexAA article class]
%\ProvidesClass{rmaa}[1999/05/21 v0.0 RevMexAA article class]
\ProvidesClass{rmaa}[\rmaa@date\ v\rmaa@version\ RevMexAA article class]


%%% Declarations that are needed in options

\newif\if@journal
\@journaltrue
\newif\if@proceedings
\@proceedingsfalse
\newif\if@manuscript
\@manuscriptfalse
\newif\if@guide
\@guidefalse
\newif\if@preprint
\@preprintfalse
\newif\if@rmtwocol
\@rmtwocoltrue
\newif\if@biblist
\@biblistfalse

%%% The option handling - this obviously needs work

\DeclareOption{manuscript}{\typeout{Manuscript option not yet
    implemented} \@manuscripttrue\@journalfalse}
\DeclareOption{journal}{\typeout{Main journal  option}%
  \@journaltrue\@rmtwocoltrue}
\DeclareOption{guide}{\typeout{User guide  option}%
  \@guidetrue\@journalfalse\@rmtwocoltrue}
\DeclareOption{preprint}{\typeout{Preprint option}%
  \@preprinttrue\@journalfalse}
\DeclareOption{proceedings}{\typeout{Proceedings option}%
  \@proceedingstrue\@journalfalse\@rmtwocolfalse} 
% these two need to be declared explicitly so that \ExecuteOptions
% actually does something
\DeclareOption{twocolumn}{\@rmtwocoltrue}
\DeclareOption{onecolumn}{\@rmtwocolfalse}
%\DeclareOption{twocolumn}{\PassOptionsToClass{\CurrentOption}{article}}
%\DeclareOption{onecolumn}{\PassOptionsToClass{\CurrentOption}{article}}
\DeclareOption{twoside}{\PassOptionsToClass{\CurrentOption}{article}}
% pass any other option along to the article class
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

% In the long run, we will have a onecolumn option for proceedings
% We should always use twoside, though, so that we get different 
% running headers on the two sides
\ExecuteOptions{twoside,article}
\ProcessOptions\relax

\if@rmtwocol\LoadClass[twocolumn]{article}\else\LoadClass{article}\fi
\RequirePackage{graphicx}
\RequirePackage{ifthen}
% explicitly require babel just to make sure
\IfFileExists{babel.sty}{\RequirePackage[english]{babel}}{\typeout{Babel 
    not found}}
% commented out for moment since requires more modern version of LaTeX
%\RequirePackage[latin1]{inputenc}
%%% The other stuff....

%% other declarations
\newif\if@needaddresses
\@needaddressestrue

%% This is necessary for older versions of latex2e
\providecommand{\MakeUpperCase}[1]{\uppercase{#1}}

%% Dimensions of the text
% width and side margins
\setlength{\textwidth}{169mm}
\setlength{\@tempdima}{\paperwidth}
\addtolength{\@tempdima}{-\textwidth}
\setlength{\oddsidemargin}{0.5\@tempdima}
\addtolength{\oddsidemargin}{-1in}
\setlength{\evensidemargin}{\oddsidemargin}
% height and top margin
\setlength{\textheight}{22.5cm} % this is height of whole lot, measured on RevMex
%\addtolength{\textheight}{-\headsep}% subtract the header/footer
%\addtolength{\textheight}{-\headheight}
%\addtolength{\textheight}{-\footskip}
\setlength{\topmargin}{-1in} % margin 8mm from top of page
\addtolength{\topmargin}{14mm}
% columns
\setlength{\columnsep}{9.5mm}
% header/footer
\setlength{\headsep}{0.7cm}
\setlength{\footskip}{0.75cm}
% paragraphs
\setlength{\parindent}{1.5em}
%% float parameters
% need to experiment with some of these
%% don't allow bottom floats 04 Oct 1999
\renewcommand{\fps@figure}{tp}
\renewcommand{\fps@table}{tp}

%% Various parameters that we will use later. 
%%
%% These include style commands for various types of headings and
%% text, which have the form \rmaa@XYZStyle{TEXT}
%%
\newcommand{\rmaa@AffilStyle}[1]{{\normalsize\rmfamily#1}}
\newcommand{\rmaa@PagesStyle}[1]{{\normalsize\rmfamily#1}}
\newcommand{\rmaa@YearStyle}[1]{{\normalsize\rmfamily#1}}
\newcommand{\rmaa@VolumeStyle}[1]{{\normalsize\rmfamily\bfseries#1}}
\newcommand{\rmaa@JournalNameStyle}[1]{{\normalsize\itshape#1}}
\newcommand{\rmaa@ReceivedStyle}[1]{{\normalsize\rmfamily\itshape#1}}
\newcommand{\rmaa@AbstractHeaderStyle}[1]{%
  {\normalsize\rmfamily\MakeUpperCase{#1}}}
\newcommand{\rmaa@TitleStyle}[1]{%
  {\large\bfseries\rmfamily\MakeUpperCase{#1}\par}}
\newcommand{\rmaa@KeywordStyle}[1]{%
  {\normalsize\bfseries\MakeUpperCase{\raggedright #1}}}
\newcommand{\rmaa@KeywordHeaderStyle}[1]{%
  {\normalsize\itshape#1}}
%% There are also various spacing parameters 
\newcommand{\rmaa@AbstractWidthFrac}{0.75}
\newcommand{\rmaa@AuthorWidthFrac}{1.0}

%% The running headers
% for normal pages
\newcommand{\ps@rmaa}{%
  % nothing in either foot
  \renewcommand\@oddfoot{\relax}%
  \renewcommand\@evenfoot{\relax}%
  % page num and short author list in the even heads
  \renewcommand\@evenhead{\parbox{0pt}{\thepage}\hfil\@shortauthor\hfil}%
  % short title and page num in the odd heads
  \renewcommand\@oddhead{\parbox{\textwidth}{\hfil\@shorttitle\hfil}\hspace*{-\textwidth}{\hfil\thepage}}}
% for the first page of the article
\newcommand{\ps@rmaafront}{%
  \renewcommand\@oddfoot{\hfil \thepage }%
  \renewcommand\@evenfoot{\hfil \thepage }%
  \renewcommand\@oddhead{\@journalname, 
    \if@journal
    \@volume, \@artpages\ 
    \fi
    \if@proceedings
    \@volume, \@artpages\ 
    \fi
    \if@guide
    \textsc{Documentation}
    \fi
    \if@preprint
    \textsc{Preprint}
    \fi
    (\@year)\hfil}%
  \renewcommand\@evenhead{\@oddhead}}

% normally use this
\pagestyle{rmaa}
% actually, nothing comes out on the first page - this needs fixing

%% User commands for setting the resumen and abstract. 
%% These should be used in the document header
\newif\if@setresumen
\newcommand{\resumen}[1]{%
%  \renewcommand{\@resumen}{{\selectlanguage{spanish}#1}}%
  \renewcommand{\@resumen}{{#1}}%
  \@setresumentrue}
\renewcommand{\abstract}[1]{%
  \renewcommand{\@abstract}{#1}}

%% User commands for affiliation, etcetera
% Principal affiliation. Typeset in italics after the authors
%\newcommand{\affil}[1]{\begin{center}
%    \textit{#1} 
%  \end{center}}

\renewcommand{\title}[1]{\renewcommand{\@title}{\rmaa@TitleStyle{#1}}}
\newcommand{\affil}[1]{\\[1.5ex]\rmaa@AffilStyle{#1}\\[1.5ex]}
\renewcommand{\and}{and\\[1.5ex]}
% alternative affiliation is footnoted
\newcommand{\altaffil}{\thanks}
%% Alternative mechanism for alternative affiliations - should not be
%% mixed with \altaffil or there will be problems with numbering
\newcommand{\altaffilmark}[1]{\textsuperscript{#1}\hspace{-0.2em}} 
\newcommand{\altaffiltext}[2]{%
  \stepcounter{footnote}%
  \protected@xdef\@thanks{\@thanks
    \protect\footnotetext[#1]{#2}}} 
\newcommand{\keywords}[1]{%
  \renewcommand{\@keywords}{\rmaa@KeywordStyle{#1}}}
\newcommand{\@keywordheader}{\rmaa@KeywordHeaderStyle{Key Words:}}
%% commands for setting the running headers
\newcommand{\shorttitle}[1]{%
  \renewcommand\@shorttitle{\MakeUpperCase{#1}}}
\newcommand{\shortauthor}[1]{%
  \renewcommand\@shortauthor{\MakeUpperCase{#1}}}

\newlength{\@fulladdheight}
\newlength{\@fulladddepth}
\newsavebox{\@fulladdbox}
\newcommand{\fulladdresses}[1]{%
  \renewcommand{\@fulladdresses}{
    \normalsize\vspace*{1ex}
    %% do addresses as a list (copied from thebibliography environment) 
    \list{\null}{\leftmargin 1.5em\labelwidth\z@\labelsep\z@\itemindent -1.5em
      \itemsep\z@\parsep\z@\usecounter{enumi}}
    \sloppy\clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax
    #1
    \endlist
    }
  }

%% Default value in each case is to print out a warning if not set
\newcommand{\@resumen}{%
  \@setresumenfalse
  \ClassWarningNoLine{rmaa}{No resumen specified - don't worry about this}
  El resumen ser\'a traducido al espa\~nol por los editores.\\}
\newcommand{\@abstract}{\ClassWarningNoLine{rmaa}{No abstract specified}}
\newcommand{\@keywords}{%
  \ClassWarningNoLine{rmaa}{No keywords specified}%
  Keywords go here
  }
\newcommand{\@shorttitle}{SHORT TITLE GOES HERE}
\newcommand{\@shortauthor}{SHORT AUTHOR GOES HERE}
\newcommand{\@fulladdresses}{Full addresses go here}

%% These are for the editors to set the volume number, etc
% cunning trick to get the page numbers from \pageref
% Put a label on the first and last page of the document
\AtBeginDocument{\label{RMAAFirstPage}}
\AtEndDocument{\label{RMAALastPage}}
\newcommand{\SetVolume}[1]{\renewcommand{\@volume}{\rmaa@VolumeStyle{#1}}}
\newcommand{\SetFirstPage}[1]{\setcounter{page}{#1}}
%\newcommand{\SetPages}[1]{\renewcommand{\@artpages}{\rmaa@PagesStyle{#1}}}
\newcommand{\SetYear}[1]{\renewcommand{\@year}{\rmaa@YearStyle{#1}}}
%% some new commands
\newcommand{\ReceivedDate}[1]{\renewcommand{\@received}{#1}}
\newcommand{\AcceptedDate}[1]{\renewcommand{\@accepted}{#1}}
% default vals for above
\newcommand{\@volume}{\rmaa@VolumeStyle{00}}
\newcommand{\@artpages}{%
  \rmaa@PagesStyle{\pageref{RMAAFirstPage}--\pageref{RMAALastPage}}}
\newcommand{\@year}{\rmaa@YearStyle{1999}}
\newcommand{\@journalname}{\rmaa@JournalNameStyle{%
    \if@proceedings\RMAASClong\else\RMAAlong\fi}}
\newcommand{\@received}{\today}
\newcommand{\@accepted}{\today}

%% Note, we have to redefine the \maketitle command to use the
%% numbered footnotes. This means we needn't use the atbeginend stuff. 
\renewcommand{\maketitle}{\par
  \begingroup
  %% Don't switch to marked footnotes
  %% This is consistent with existing style but I'm not sure I like it
  %%  \renewcommand\thefootnote{\fnsymbol{footnote}}%
%  \def\@makefnmark{\hbox to\z@{$\m@th^{\@thefnmark}$\hss}}%
  \def\@makefnmark{\textsuperscript{\@thefnmark}\hspace{-0.2em}}%
  \long\def\@makefntext##1{\parindent 1em\noindent
    \hbox to1.8em{\hss$\m@th^{\@thefnmark}$}##1}%
  \if@twocolumn
  \ifnum \col@number=\@ne
  \@maketitle
  \else
  \twocolumn[\@maketitle]%
  \fi
  \else
  \newpage
  \global\@topnum\z@   % Prevents figures from going at top of page.
  \@maketitle
  \fi
  \thispagestyle{rmaafront}\@thanks
  \endgroup
  %% don't reset footnote counter (not sure whether this is good thing
  %% or not)
  %%  \setcounter{footnote}{0}%
  \let\thanks\relax\let\affil\relax\let\altaffil\relax
  \let\maketitle\relax\let\@maketitle\relax
  \gdef\@thanks{}\gdef\@author{}\gdef\@title{}}

%% Redefine \@maketitle to include the abstract, resumen and keywords
\renewcommand{\@maketitle}{%
  \newpage
  \null 
  \vskip 2em%
  \begin{center}%
    {\@title \par}%
    \vskip 1.5em%
    \parbox{\rmaa@AuthorWidthFrac\textwidth}{\centering
      \lineskip .5em%
      \@author
      \par}
    %% this should be replaced with `Submitted to...' for preprints
    \if@journal
    \rmaa@ReceivedStyle{Received \@received; accepted \@accepted}
    \fi
    \if@preprint
    \rmaa@ReceivedStyle{Submitted to RevMexAA \@received}
    \fi
    \if@guide
    \rmaa@ReceivedStyle{Version \rmaa@version, \rmaa@date}
    \fi
    \vskip 3ex%
    \parbox{\rmaa@AbstractWidthFrac\textwidth}{
      \setlength{\parindent}{0.9cm}
      \centerline{\rmaa@AbstractHeaderStyle{Resumen}}\par%
      \vskip 1ex%
      \@resumen
      \if@setresumen\else\@abstract\fi % append english abstract if
                                       % spanish one not set
      \vskip 2ex%
      \centerline{\rmaa@AbstractHeaderStyle{Abstract}}\par%
      \vskip 1ex%
      \@abstract
      \vskip 1ex%
      % Format the Key Words with hanging indentation:
      % They are put in a \parbox with width equal to the line width
      % minus the width of the header. 
      {\newlength{\@kwhwidth}\newlength{\@kwtwidth} % Widths of keyword
        \settowidth{\@kwhwidth}{\@keywordheader~}   % header and
        \setlength{\@kwtwidth}{\linewidth}          % keyword text
        \addtolength{\@kwtwidth}{-\@kwhwidth}       %
        \noindent\@keywordheader~\parbox[t]{\@kwtwidth}{\@keywords}}%
      }
  \end{center}%
  \par
  \vskip 1.5em
  \usebox{\@fulladdbox}
  }

%% reset the sectioning commands

%% different spacing depending on whether we are in twocolumn mode or not
\if@rmtwocol
\newcommand{\abovesectionskip}{2.5ex \@plus 1ex \@minus .2ex}
\newcommand{\belowsectionskip}{0.5ex \@plus.12ex}
\newcommand{\aboveparaskip}{2.0ex \@plus 1.0ex}
\newcommand{\belowparaskip}{-1em}
\else
\newcommand{\abovesectionskip}{3.5ex \@plus 1ex \@minus .2ex}
\newcommand{\belowsectionskip}{2.3ex \@plus.2ex}
\newcommand{\aboveparaskip}{3.25ex \@plus1ex \@minus.2ex}
\newcommand{\belowparaskip}{-1em}
\fi

\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {\abovesectionskip}%
                                   {\belowsectionskip}%
                                   %% how do we get upper case here
                                   {%
%                                     \renewcommand{\sec@upcase}{\uppercase}
                                     \centering\reset@font\normalsize}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {\abovesectionskip}%
                                     {\belowsectionskip}%
                                     {\centering\reset@font\normalsize\itshape}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {\abovesectionskip}%
                                     {\belowsectionskip}%
                                     {\centering\reset@font\normalsize\itshape}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {\aboveparaskip}%
                                    {\belowparaskip}%
                                    {\reset@font\normalsize\bfseries}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                      {\aboveparaskip}%
                                      {\belowparaskip}%
                                      {\reset@font\normalsize\bfseries}}

% For subsection and subsubsection, we want the numbers to be roman
% but the title to be italic. This seems the easiest way to go about it.
\renewcommand{\thesubsection}{{\upshape\thesection.\@arabic\c@subsection}}
\renewcommand{\thesubsubsection}{\thesubsection{\upshape.\@arabic\c@subsubsection}}

% add a ``.'' to the number here so we can remove it from \thesection,
% etc. Reduce gap between number and title WJH 27 Jan 1995
%\def\@seccntformat#1{\csname the#1\endcsname\hskip 1em}
\def\@seccntformat#1{\csname the#1\endcsname .\hskip 0.4em}

% mess with the \@sect command to get upper case
\def\@sect#1#2#3#4#5#6[#7]#8{\ifnum #2>\c@secnumdepth
     \let\@svsec\@empty\else
     \refstepcounter{#1}%
     \let\@@protect\protect
     \def\protect{\noexpand\protect\noexpand}%
     \edef\@svsec{\@seccntformat{#1}}%
     \let\protect\@@protect\fi
                                % my bit WJH 27 Jan 1995
     \ifnum #2=1                   % use upper case for \section
     \def\sec@upcase##1{\uppercase{##1}}
     \else                         % use mixed case for the rest 
     \def\sec@upcase##1{\relax{##1}}
     \fi
                                %
     \@tempskipa #5\relax
      \ifdim \@tempskipa>\z@
        \begingroup #6\relax
          \@hangfrom{\hskip #3\relax\@svsec}%
                    {\interlinepenalty \@M \sec@upcase{#8}\par}%
        \endgroup
       \csname #1mark\endcsname{#7}\addcontentsline
         {toc}{#1}{\ifnum #2>\c@secnumdepth \else
                      \protect\numberline{\csname the#1\endcsname}\fi
                    #7}\else
        \def\@svsechd{#6\hskip #3\relax  %% \relax added 2 May 90
                   \@svsec #8\csname #1mark\endcsname
                      {#7}\addcontentsline
                           {toc}{#1}{\ifnum #2>\c@secnumdepth \else
                           \protect\numberline{\csname the#1\endcsname}%
                                     \fi
                       #7}}\fi
     \@xsect{#5}}


%% Floating things   

% 
\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{TABLE}
\long\def\@makefigcap#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1. #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1. #2 \par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\long\def\@maketabcap#1#2{%
  \hbox to\hsize{\hfil #1 \hfil}
  \vskip 6pt 
  \centering \uppercase{#2}\par}
\renewenvironment{figure}
                 {\renewcommand{\@makecaption}{\@makefigcap}\@float{figure}}
                 {\end@float}
\renewenvironment{figure*}
                 {\renewcommand{\@makecaption}{\@makefigcap}\@dblfloat{figure}}
                 {\end@dblfloat}
\renewenvironment{table}
                 {\renewcommand{\@makecaption}{\@maketabcap}\@float{table}}
                 {\end@float}
\renewenvironment{table*}
                 {\renewcommand{\@makecaption}{\@maketabcap}\@dblfloat{table}}
                 {\end@dblfloat}
               
\renewcommand{\arraystretch}{1.15}
\setlength{\doublerulesep}{0.4pt}

%% References
\renewenvironment{thebibliography}{%
%% done as starred section with extra vertical space after heading
  \section*{REFERENCES} 
%  \vspace*{1.5ex}
  \small
                                % references themselves set as a list
                                % to get the hanging indentation 
  \list{\null}{\leftmargin 1.5em\labelwidth\z@\labelsep\z@\itemindent -1.5em
    \itemsep\z@\parsep\z@\usecounter{enumi}}
  \sloppy\clubpenalty4000\widowpenalty4000
  \sfcode`\.=1000\relax\@biblisttrue}
{\endlist\@biblistfalse\normalsize\@outputaddressesifnecessary}

%% Comand to output the addresses if we haven't already done so
\newcommand{\@outputaddressesifnecessary}{%
  \ifthenelse{\boolean{@needaddresses}}{%
    %% If in one column style, or in the first column of a two column
    %% style then we can try to put it on this page 
    \ifthenelse{\boolean{@firstcolumn} \or \not\boolean{@rmtwocol}}{%
      \@outputaddresses}{%
      %% otherwise give warning it will be on a separate page
      \ClassWarning{rmaa}{Full addresses will go on a separate
        page (please see User Guide for how to remedy this)}}%
    %% If we haven't managed yet, put it on its own page
    \ifthenelse{\boolean{@needaddresses}}{%
      \clearpage\vfill\@outputaddresses}{}%
    }{}%
  }  
%% This command starts a new column and should be 
%% used to ensure that the columns balance on nthe last page. It also
%% outputs the full 
%% author addresses to ensure that this occurs in the left hand
%% column. 
%% The \par command is so that the current line will be taken account
%% of when working out \pagetotal
\newcommand{\adjustfinalcols}{\if@twocolumn\par\@outputaddresses\newpage\noindent\fi}

%% command to do the work of outputting the addresses
\newcommand{\@outputaddresses}{%
  %% save the full addresses in a box for output later
  \sbox{\@fulladdbox}{\parbox{\textwidth}{\@fulladdresses}}
  % calculate height of address box  
  \settoheight{\@fulladdheight}{\usebox{\@fulladdbox}}
  \settodepth{\@fulladddepth}{\usebox{\@fulladdbox}}
  \addtolength{\@fulladdheight}{\@fulladddepth}
%  \typeout{Address total height: \the\@fulladdheight}
%  \typeout{Text height: \the\pagetotal}
%  \typeout{Goal height: \the\pagegoal}
  % reuse \@fulladdheight to mean the total height of text+addresses
  \addtolength{\@fulladdheight}{\pagetotal}
  % check it will fit on current page
  \ifdim\@fulladdheight<\pagegoal
  % must shift it to the left
  % to compensate for the hanging indentation in the reference list. 
  % NOTE: this is not foolproof!
  % NB. This will give overfull hbox warnings, which is a bit ugly.
  \vfill\noindent\if@biblist\hspace*{-\leftmargin}\fi
  \usebox{\@fulladdbox}
  \@needaddressesfalse
  \else
  % if not, hold over to next page
%  \typeout{Holding over full addresses to next page}
  \fi
  }
%% some random definitions

\newcommand{\RMAA}{RevMexAA}
\newcommand{\RMAAlong}{Revista Mexicana de Astronom\'{\i}a y Astrof\'{\i}sica}
\newcommand{\RMAASC}{RevMexAA(SC)}
\newcommand{\RMAASClong}{\RMAA\ (Serie de Conferencias)}

%\usepackage{rmaaextr}

%% Various new commands from AAS macros
\def\acknowledgments{\vskip 3ex plus .8ex minus .4ex}
\let\acknowledgements=\acknowledgments                  % second spelling

\let\jnl@style=\rm
\def\ref@jnl#1{{\jnl@style#1}}
\def\aj{\ref@jnl{AJ}}                   
\def\araa{\ref@jnl{ARA\&A}}             
\def\apj{\ref@jnl{ApJ}}                 
\def\apjl{\ref@jnl{ApJ}}                
\def\apjs{\ref@jnl{ApJS}}               
\def\ao{\ref@jnl{Appl.~Opt.}}           
\def\apss{\ref@jnl{Ap\&SS}}             
\def\aap{\ref@jnl{A\&A}}                
\def\aapr{\ref@jnl{A\&A~Rev.}}          
\def\aaps{\ref@jnl{A\&AS}}              
\def\azh{\ref@jnl{AZh}}                 
\def\baas{\ref@jnl{BAAS}}               
\def\jrasc{\ref@jnl{JRASC}}             
\def\memras{\ref@jnl{MmRAS}}            
\def\mnras{\ref@jnl{MNRAS}}             
\def\pra{\ref@jnl{Phys.~Rev.~A}}        
\def\prb{\ref@jnl{Phys.~Rev.~B}}        
\def\prc{\ref@jnl{Phys.~Rev.~C}}        
\def\prd{\ref@jnl{Phys.~Rev.~D}}        
\def\pre{\ref@jnl{Phys.~Rev.~E}}        
\def\prl{\ref@jnl{Phys.~Rev.~Lett.}}    
\def\pasp{\ref@jnl{PASP}}               
\def\pasj{\ref@jnl{PASJ}}               
\def\qjras{\ref@jnl{QJRAS}}             
\def\skytel{\ref@jnl{S\&T}}             
\def\solphys{\ref@jnl{Sol.~Phys.}}      
\def\sovast{\ref@jnl{Soviet~Ast.}}      
\def\ssr{\ref@jnl{Space~Sci.~Rev.}}     
\def\zap{\ref@jnl{ZAp}}                 
\def\nat{\ref@jnl{Nature}}              
\def\iaucirc{\ref@jnl{IAU~Circ.}}
\def\aplett{\ref@jnl{Astrophys.~Lett.}}
\def\apspr{\ref@jnl{Astrophys.~Space~Phys.~Res.}}
\def\bain{\ref@jnl{Bull.~Astron.~Inst.~Netherlands}}
\def\fcp{\ref@jnl{Fund.~Cosmic~Phys.}}
\def\gca{\ref@jnl{Geochim.~Cosmochim.~Acta}}
\def\grl{\ref@jnl{Geophys.~Res.~Lett.}}
\def\jcp{\ref@jnl{J.~Chem.~Phys.}}      
\def\jgr{\ref@jnl{J.~Geophys.~Res.}}    
\def\jqsrt{\ref@jnl{J.~Quant.~Spec.~Radiat.~Transf.}}
\def\memsai{\ref@jnl{Mem.~Soc.~Astron.~Italiana}}
\def\nphysa{\ref@jnl{Nucl.~Phys.~A}}
\def\physrep{\ref@jnl{Phys.~Rep.}}
\def\physscr{\ref@jnl{Phys.~Scr}}
\def\planss{\ref@jnl{Planet.~Space~Sci.}}
\def\procspie{\ref@jnl{Proc.~SPIE}}
\let\astap=\aap
\let\apjlett=\apjl
\let\apjsupp=\apjs
\let\applopt=\ao
\def\phn{\phantom{0}}
\def\phd{\phantom{.}}
\def\phs{\phantom{$-$}}
\def\phm#1{\phantom{#1}}
\def\sun{\hbox{$\odot$}}
\def\earth{\hbox{$\oplus$}}
\def\lesssim{\mathrel{\hbox{\rlap{\hbox{\lower4pt\hbox{$\sim$}}}\hbox{$<$}}}}
\def\gtrsim{\mathrel{\hbox{\rlap{\hbox{\lower4pt\hbox{$\sim$}}}\hbox{$>$}}}}
\def\sq{\hbox{\rlap{$\sqcap$}$\sqcup$}}
\def\arcdeg{\hbox{$^\circ$}}
\def\arcmin{\hbox{$^\prime$}}
\def\arcsec{\hbox{$^{\prime\prime}$}}
\def\fd{\hbox{$.\!\!^{\rm d}$}}
\def\fh{\hbox{$.\!\!^{\rm h}$}}
\def\fm{\hbox{$.\!\!^{\rm m}$}}
\def\fs{\hbox{$.\!\!^{\rm s}$}}
\def\fdg{\hbox{$.\!\!^\circ$}}
\def\farcm{\hbox{$.\mkern-4mu^\prime$}}
\def\farcs{\hbox{$.\!\!^{\prime\prime}$}}
\def\fp{\hbox{$.\!\!^{\scriptscriptstyle\rm p}$}}
\def\micron{\hbox{$\mu$m}}
\let\la=\lesssim                        
\let\ga=\gtrsim
\def\case#1#2{\hbox{$\frac{#1}{#2}$}}
\def\slantfrac#1#2{\hbox{$\,^#1\!/_#2$}}
\def\onehalf{\slantfrac{1}{2}}
\def\onethird{\slantfrac{1}{3}}
\def\twothirds{\slantfrac{2}{3}}
\def\onequarter{\slantfrac{1}{4}}
\def\threequarters{\slantfrac{3}{4}}
\def\ubvr{\hbox{$U\!BV\!R$}}            
\def\ub{\hbox{$U\!-\!B$}}               
\def\bv{\hbox{$B\!-\!V$}}               
\def\vr{\hbox{$V\!-\!R$}}               
\def\ur{\hbox{$U\!-\!R$}}               
\def\ion#1#2{#1$\;${\small\rm\@Roman{#2}}\relax}
\def\nodata{ ~$\cdots$~ }

%% Things for the User Guide
\if@guide
% stolen from doc.sty
\def\MakeShortVerb#1{%
  \expandafter\ifx\csname cc\string#1\endcsname\relax
  \@shortvrbinfo{Made }{#1}%
  \add@special{#1}%
  \expandafter
  \xdef\csname cc\string#1\endcsname{\the\catcode`#1}%
  \begingroup
  \catcode`\~\active  \lccode`\~`#1%
  \lowercase{%
    \global\expandafter\let
    \csname ac\string#1\endcsname~%
    \gdef~{\verb~}}%
  \endgroup
  \global\catcode`#1\active
  \else
  \@shortvrbinfo\@empty{#1 already}%
  \fi}
\def\DeleteShortVerb#1{%
  \expandafter\ifx\csname cc\string#1\endcsname\relax
  \else
  \@shortvrbinfo{Deleted }{#1 as}%
  \rem@special{#1}%
  \global\catcode`#1\csname cc\string#1\endcsname
  \global \expandafter\let \csname cc\string#1\endcsname \relax
  \ifnum\catcode`#1=\active
  \begingroup
  \catcode`\~\active   \lccode`\~`#1%
  \lowercase{%
    \global\expandafter\let\expandafter~%
    \csname ac\string#1\endcsname}%
  \endgroup \fi \fi}
\def\@shortvrbinfo#1#2{%
  \PackageInfo{doc}{%
    #1\expandafter\@gobble\string#2 a short reference
    for \string\verb}}
\def\add@special#1{%
  \rem@special{#1}%
  \expandafter\gdef\expandafter\dospecials\expandafter
  {\dospecials \do #1}%
  \expandafter\gdef\expandafter\@sanitize\expandafter
  {\@sanitize \@makeother #1}}
\def\rem@special#1{%
  \def\do##1{%
    \ifnum`#1=`##1 \else \noexpand\do\noexpand##1\fi}%
  \xdef\dospecials{\dospecials}%
  \begingroup
  \def\@makeother##1{%
    \ifnum`#1=`##1 \else \noexpand\@makeother\noexpand##1\fi}%
  \xdef\@sanitize{\@sanitize}%
  \endgroup}
% define | as shortcut for \verbatim
\MakeShortVerb{\|}
% comand to specify arguments to LaTeX commands
\newcommand{\rmArg}[1]{%
  \ensuremath{\langle}{\scriptsize \textsf{\MakeUpperCase{#1}}}\ensuremath{\rangle}}
%\newcommand{\rmArg}[1]{\ensuremath{\langle}\textsc{#1}\ensuremath{\rangle}}
\providecommand{\BibTeX}{{\rmfamily B\kern-.05em%
    \textsc{i\kern-.025em b}\kern-.08em%
    T\kern-.1667em\lower.7ex\hbox{E}\kern-.125emX}}
%% Environment for code examples
\newenvironment{Code}{%
  \begin{list}{}{\setlength{\leftmargin}{0.05\columnwidth}} 
  \item[]}{\end{list}}
\fi