%%
%% This is file `acta.cls',
%% generated from article.cls
%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{acta}
              [1998/11/20 v1
 Acta Astronomica LaTeX document class]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\fi
\if@compatibility
  \renewcommand\@ptsize{0}
\else
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\if@compatibility\else
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\fi
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\if@compatibility\else
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\DeclareOption{titlepage}{\@titlepagetrue}
\if@compatibility\else
\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}}%
}
\ExecuteOptions{a4paper,11pt,twoside,onecolumn,final}
\ProcessOptions
\input{acta1\@ptsize.clo}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{1}
\setcounter{bottomnumber}{2}
\renewcommand\bottomfraction{1}
\setcounter{totalnumber}{4}
\renewcommand\textfraction{0}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\thepage\hfil\slshape\leftmark}%
      \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
      \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markboth {\MakeUppercase{%
        \ifnum \c@secnumdepth >\z@
          \thesection\quad
        \fi
        ##1}}{}}%
    \def\subsectionmark##1{%
      \markright {%
        \ifnum \c@secnumdepth >\@ne
          \thesubsection\quad
        \fi
        ##1}}}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\markboth
    \def\sectionmark##1{%
      \markright {\MakeUppercase{%
        \ifnum \c@secnumdepth >\m@ne
          \thesection\quad
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil\slshape\leftmark}%
    \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
    \let\@mkboth\@gobbletwo
    \let\sectionmark\@gobble
    \let\subsectionmark\@gobble
    }
  \if@titlepage
  \newcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \let \footnote \thanks
  \null\vfil
  \vskip 60\p@
  \begin{center}%
    {\LARGE \@title \par}%
    \vskip 3em%
    {\large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
    {\large \@date \par}%       % Set date in \large size.
  \end{center}\par
  \@thanks
  \vfil\null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\else
\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em}
\fi
\setcounter{secnumdepth}{3}
\newcounter {part}
\newcounter {section}
\newcounter {subsection}[section]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\newcounter {subparagraph}[paragraph]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thesection {\@arabic\c@section.}
\renewcommand\thesubsection   {\thesection\@arabic\c@subsection.}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\part{\par
   \addvspace{4ex}%
   \@afterindentfalse
   \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >\m@ne
       \Large\bfseries \partname~\thepart
       \par\nobreak
     \fi
     \huge \bfseries #2%
     \markboth{}{}\par}%
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\@spart#1{%
    {\parindent \z@ \raggedright
     \interlinepenalty \@M
     \normalfont
     \huge \bfseries #1\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
\newcommand\section{\@startsection {section}{1}{\z@}%
                                   {6mm \@plus 1mm \@minus .2mm}%
                                   {4mm \@plus 1mm}%
                                   {\normalfont\normalsize\bfseries\centering}}
\newcommand\subsection{\@startsection{subsection}{2}{\parindent}%
                                     {3mm \@plus .5mm \@minus .2mm}%
                                     {2mm \@plus .4mm}%
                                     {\normalfont\normalsize\itshape}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\bfseries}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\normalsize\bfseries}}
\newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
                                       {3.25ex \@plus1ex \@minus .2ex}%
                                       {-1em}%
                                      {\normalfont\normalsize\bfseries}}
\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2.5em}
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\arabic{enumi}.}
\newcommand\labelenumii{(\alph{enumii})}
\newcommand\labelenumiii{\roman{enumiii}.}
\newcommand\labelenumiv{\Alph{enumiv}.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\if@titlepage
  \newenvironment{abstract}{%
      \titlepage
      \null\vfil
      \@beginparpenalty\@lowpenalty
      \begin{center}%
        \bfseries \abstractname
        \@endparpenalty\@M
      \end{center}}%
     {\par\vfil\null\endtitlepage}
\else
  \newenvironment{abstract}{%
      \if@twocolumn
        \section*{\abstractname}%
      \else
        \small
        \begin{center}%
          {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
        \end{center}%
        \quotation
      \fi}
      {\if@twocolumn\else\endquotation\fi}
\fi
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\if@compatibility
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\fi
\newcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\thesection{\@Alph\c@section}}
\setlength\arraycolsep{2\p@}
\setlength\tabcolsep{5\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand \theequation {\@arabic\c@equation}
\newcounter{figure}
\renewcommand \thefigure {\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    \unhbox\@tempboxa\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
% here some 'article.cls' defs was cut out
% \def\@pnumwidth{1.55em}
% ...
% \def\indexspace{...
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\newcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\refname{References}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\appendixname{Appendix}
\newcommand\abstractname{Abstract}
\newcommand\today{}
\edef\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{plain}
\pagenumbering{arabic}
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi
%\endinput
%%
%% End of original part of file `article.cls'.
%%
%% New acta definitions
%%
\font\ttit=pcrbo at 8 pt

\textwidth 12.7cm
\textheight 20.4cm
\headsep 6mm
\topskip 11pt
\leftmargin 0.5cm
\evensidemargin 36pt
\flushbottom
\mathsurround 1pt

\newcommand{\dd}{\,{\rm d}}
\newcommand{\ie}{{\it i.e.},\,}
\newcommand{\etal}{{\it et al.\ }}
\newcommand{\eg}{{\it e.g.},\,}
\newcommand{\cf}{{\it cf.\ }}
\newcommand{\vs}{{\it vs.\ }}
\newcommand{\ttt}[1]{\!\times\!10^{#1}}
\newcommand{\sst}{\scriptscriptstyle}
\newcommand{\fns}{\footnotesize}
\newcommand{\beq}{\begin{equation}
  \renewcommand{\int}{\intop\limits}
  \renewcommand{\oint}{\ointop\limits}}
\newcommand{\eeq}{\end{equation}}
\newcommand{\beqarr}{\par\begin{minipage}{11cm} \begin{eqnarray*}}
\newcommand{\eeqarr}{\end{eqnarray*} \end{minipage} \hfill 
   \stepcounter{equation}{\rm (\theequation)}\vspace{3mm}\linebreak}
\newcommand{\bdm}{\begin{displaymath}
  \renewcommand{\int}{\intop\limits}
  \renewcommand{\oint}{\ointop\limits}}
\newcommand{\edm}{\end{displaymath}}
\newcommand{\trule}{\rule{0pt}{14pt}}
\newcommand{\zdot}{\makebox[0pt][l]{.}}
\newcommand{\up}[1]{\ifmmode^{\rm #1}\else$^{\rm #1}$\fi}
\newcommand{\dn}[1]{\ifmmode_{\rm #1}\else$_{\rm #1}$\fi}
\newcommand{\upd}{\up{d}}
\newcommand{\uph}{\up{h}}
\newcommand{\upm}{\up{m}}
\newcommand{\ups}{\up{s}}
\newcommand{\arcd}{\ifmmode^{\circ}\else$^{\circ}$\fi}
\newcommand{\arcm}{\ifmmode{'}\else$'$\fi}
\newcommand{\arcs}{\ifmmode{''}\else$''$\fi}
\newcommand{\pder}[2]{\frac{\partial#1}{\partial#2}}
\newcommand{\der}[2]{\frac{{\rm d}#1}{{\rm d}#2}}
\newcommand{\m}{{\rm m}}
\newcommand{\cm}{{\rm cm}}
\newcommand{\g}{{\rm g}}
\newcommand{\kg}{{\rm kg}}
\newcommand{\s}{{\rm s}}
\newcommand{\MS}{{\rm M}\ifmmode_{\odot}\else$_{\odot}$\fi}
\newcommand{\RS}{{\rm R}\ifmmode_{\odot}\else$_{\odot}$\fi}
\newcommand{\LS}{{\rm L}\ifmmode_{\odot}\else$_{\odot}$\fi}
\newcounter{pagefrom}
\newcounter{pageto}
\newcounter{volume}
\newcounter{year}

\newcommand{\SetPages}[2]{\setcounter{page}{#1}
  \setcounter{pagefrom}{#1}\setcounter{pageto}{#2}}
\newcommand{\SetVol}[2]{\setcounter{volume}{#1}\setcounter{year}{#2}}
\newcommand{\SetNum}[1]{\newcommand{\Num}{{\bf #1}}}

\newenvironment{Titlepage}{
  \markboth{{\bf A. A.}}{{\bf Vol.\ \arabic{volume}}}
  \renewcommand{\and}{{\small ~~and~~ }}
  \thispagestyle{empty} 
  \begin{flushright} \small {\it ACTA ASTRONOMICA} \\
    Vol.\ {\bf \arabic{volume}} (\arabic{year}) 
    pp.\ \arabic{pagefrom}--\arabic{pageto}\\[13mm]
  \end{flushright} 
  \begin{center}
}{
  \end{center}\par\vspace{3mm}
}

\newcommand{\Title}[1]{{\large\bf\boldmath #1 \\[3mm] {\footnotesize\rm by} 
\\[3mm]}}

\newcommand{\Author}[2]{{\large\spaceskip 2pt plus 1pt minus 1pt #1}\\[3mm]
   {\small #2}\\[6mm]}

\newcommand{\Received}[1]{\small\it Received #1 \\}

\newcommand{\Abstract}[2]{{\footnotesize\begin{center}ABSTRACT\end{center}
\vspace{1mm}\par#1\par
\noindent
{\bf Key words:~~}{\it #2}}}

\newcommand{\FigCap}[1]{\footnotesize\par\noindent Fig.\  % 
  \refstepcounter{figure}\thefigure. #1\par}

\newcommand{\TabCap}[2]{\begin{center}\parbox[t]{#1}{\begin{center}
  \small {\spaceskip 2pt plus 1pt minus 1pt T a b l e}
  \refstepcounter{table}\thetable \\[2mm]
  \footnotesize #2 \end{center}}\end{center}}

\newcommand{\Table}[3]{\begin{table}[htb]\TabCap{#2}{#3}
  \vspace{#1}\end{table}}

\newcommand{\TableSep}[2]{\begin{table}[p]\vspace{#1}
\TabCap{#2}\end{table}}

\newcommand{\TableFont}{\footnotesize}
\newcommand{\TableFontIt}{\ttit}
\newcommand{\SetTableFont}[1]{\renewcommand{\TableFont}{#1}}

\newcommand{\MakeTable}[4]{\begin{table}[htb]\TabCap{#2}{#3}
  \begin{center} \TableFont \begin{tabular}{#1} #4 
  \end{tabular}\end{center}\end{table}}

\newcommand{\MakeFrameTable}[5]{\begin{table}[htb]\TabCap{#2}{#3}
  \begin{center} \TableFont \begin{tabular}{#1}\hline\trule #4\\[1mm]
  \hline\trule #5\\[1mm]\hline
  \end{tabular}\end{center}\end{table}}

\newcommand{\MakeOwnTable}[6]{\begin{table}[htb]\TabCap{#2}{#3}
  \begin{center}\TableFont #4 \begin{tabular}{#1} #5
  \end{tabular} #6 \end{center}\end{table}}

\newcommand{\MakeTableSep}[4]{\begin{table}[p]\TabCap{#2}{#3}
  \begin{center} \TableFont \begin{tabular}{#1} #4 
  \end{tabular}\end{center}\end{table}}

\newcommand{\Figure}[2]{\begin{figure}[htb]\vspace{#1}
\FigCap{#2}\end{figure}}

\newcommand{\FigureSep}[2]{\begin{figure}[p]\vspace{#1}
\FigCap{#2}\end{figure}}

\newcommand{\FigureOwn}[3]{\begin{figure}[htb]\vspace{#1}#3
\FigCap{#2}\end{figure}}
\newcommand{\FigureOwnSep}[3]{\begin{figure}[p]\vspace{#1}#3
\FigCap{#2}\end{figure}}
\newcommand{\LeavePage}{\begin{table}[p]\vspace{19.5cm}\end{table}}

\newenvironment{references}%
{
\footnotesize \frenchspacing
\renewcommand{\thesection}{}
\renewcommand{\in}{{\rm in }}
\renewcommand{\AA}{Astron.\ Astrophys.}
\newcommand{\AAS}{Astron.~Astrophys.~Suppl.~Ser.}
\newcommand{\ApJ}{Astrophys.\ J.}
\newcommand{\ApJS}{Astrophys.\ J.~Suppl.~Ser.}
\newcommand{\ApJL}{Astrophys.\ J.~Letters}
\newcommand{\AJ}{Astron.\ J.}
\newcommand{\IBVS}{IBVS}
\newcommand{\PASP}{P.A.S.P.}
\newcommand{\Acta}{Acta Astron.}
\newcommand{\MNRAS}{MNRAS}
\renewcommand{\and}{{\rm and }}
\section{{\rm REFERENCES}}
\sloppy \hyphenpenalty10000
\begin{list}{}{\leftmargin1cm\listparindent-1cm
\itemindent\listparindent\parsep0pt\itemsep0pt}}%
{\end{list}\vspace{2mm}}

\def\TYLDA{~}
\newlength{\DW}
\settowidth{\DW}{0}
\newcommand{\dw}{\hspace{\DW}}

\newcommand{\refitem}[5]{\item[]{#1} #2%
\def\REFARG{#3}\ifx\REFARG\TYLDA\else, {\it#3}\fi
\def\REFARG{#4}\ifx\REFARG\TYLDA\else, {\bf#4}\fi
\def\REFARG{#5}\ifx\REFARG\TYLDA\else, {#5}\fi.}

\newcommand{\Section}[1]{\section{#1}}
\newcommand{\Subsection}[1]{\subsection{#1}}
\newcommand{\Acknow}[1]{\par\vspace{5mm}{\bf Acknowledgements.} #1}
\pagestyle{myheadings}

%\usepackage{babel}
\usepackage[T1]{fontenc}
\usepackage[latin2]{inputenc}
\usepackage{pslatex}
\usepackage{graphicx}
