%%% ====================================================================
%%% @LaTeX-file{
%%%    filename  = "conm-p-l.cls",
%%%    version   = "1.2b",
%%%    date      = "1996/10/25",
%%%    time      = "16:51:54 EDT",
%%%    checksum  = "31137 36 137 1346",
%%%    author    = "Michael Downes",
%%%    address   = "American Mathematical Society, PO Box 6248,
%%%                       Providence, RI 02940, USA",
%%%    email     = "tech-support@ams.org (Internet)",
%%%    supported = "yes",
%%%    abstract  = "This is a LaTeX documentclass for proceedings volumes
%%%                 in the AMS Contemporary Mathematics series.",
%%%    docstring = "The checksum field above contains a CRC-16 checksum
%%%                 as the first value, followed by the equivalent of
%%%                 the standard UNIX wc (word count) utility output
%%%                 of lines, words, and characters.  This is produced
%%%                 by Robert Solovay's checksum utility.",
%%% }
%%% ====================================================================

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{conm-p-l}
              [1996/10/25 v1.2b CONM-P Author Class]

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{amsproc}}
\ProcessOptions

\LoadClass{amsproc}[1996/10/24]

\def\publname{Contemporary Mathematics}

\def\ISSN{0271-4132}

\def\temp{\@startsection{subsection}%
                        {2}%
                        {0mm}%
                        {-\baselineskip}%
                        {-\baselineskip}%
                        {\normalfont\bfseries}}%

\def\bekezdes#1#2{\temp{#1}\label{#2}}

\renewcommand{\subjclassname}{\textup{2000} Mathematics Subject
     Classification}

\renewcommand{\section}{\@startsection{section}%
                        {2}%
                        {0mm}%
                        {-\baselineskip}%
                        {0.5\baselineskip}%
                        {\normalfont\bfseries}}%

\renewcommand{\subsection}{\@startsection{subsection}%
                        {2}%
                        {0mm}%
                        {-\baselineskip}%
                        {0.5\baselineskip}%
                        {\normalfont\bfseries}}%

\endinput
