% improve printing
on div; off allfac; on revpri; factor gam;

% make function of xi=(x-x_j)/h
depend xi,x;
let df(xi,x)=>1/h;

% parametrise with evolving u(j)
operator u; depend u,t;
let df(u(~k),t)=>sub(j=k,g);

% solvability condition
operator solg; linear solg;
let { solg(xi^~p,xi)=>(1+(-1)^p)/(p+2)/(p+1)
    , solg(xi,xi)=>0, solg(1,xi)=>1 };

% solves v''=RHS s.t. v(0)=0 and v(+1)=v(-1)
operator solv; linear solv;
let { solv(xi^~p,xi) =>
          ( xi^(p+2)-(1-(-1)^p)*xi/2 )/(p+1)/(p+2)
    , solv(xi,xi) => (xi^3-xi)/6
    , solv(1,xi) => (xi^2)/2 };

% linear solution in jth interval
v:=u(j);
g:=0;

% iterative refinement to specified error
let { gam^3=>0, eps^4=>0 };
repeat begin
   deq:=-df(v,t)-eps*df(v,x)+df(v,x,2);
   abc:=-(sub(xi=+1,v)-sub(xi=-1,v))/2
        +gam*(u(j+1)-u(j-1))/2;
   bbc:=-(sub(xi=1,v)-2*sub(xi=0,v)+sub(xi=-1,v))
        +gam*(u(j+1)-2*u(j)+u(j-1));
   gd:=bbc/h^2+solg(deq,xi);
   g:=g+gd;
   v:=v+h^2*solv(-deq+gd,xi)+xi*abc;
   showtime;
end until (deq=0)and(abc=0)and(bbc=0);
deq:=sub(xi=0,v)-u(j); % confirms amplitude

% get difference form of evolution
gd:=( g where { mu^2=>1+del^2/4, u(j)=>1,
    u(j+~k)=>(1+mu*del+del^2/2)^k when k>0,
    u(j+~k)=>(1-mu*del+del^2/2)^(-k) when k<0 } );
% deduce the equivalent differential form,
operator du;
o:=8;
let h^~p=>0 when p>o;
ge:=( g where u(~k)=>(du(0)+for n:=1:o+3 sum
              du(n)*h^n*(k-j)^n/factorial(n)) )$
gee:=coeff(sub(gam=1,ge),h);

end;
