%%
%% This is file `an_art.cls', a derivative of `article.cls'
%%
%% The original source files were:
%%
%% classes.dtx  (with options: `article')
%% 
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{an_art}
              [1997/09/02 v1.0
 Standard LaTeX document class]
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\fi
\if@compatibility
  \renewcommand\@ptsize{0}
\else
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\if@compatibility\else
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\fi
 \DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
 \DeclareOption{draft}{\setlength\overfullrule{5pt}}
 \if@compatibility\else
 \DeclareOption{final}{\setlength\overfullrule{0pt}}
 \fi
 \DeclareOption{titlepage}{\@titlepagetrue}
 \if@compatibility\else
 \DeclareOption{notitlepage}{\@titlepagefalse}
 \fi
 \if@compatibility\else
 \DeclareOption{onecolumn}{\@twocolumnfalse}
 \fi
 \DeclareOption{twocolumn}{\@twocolumntrue}
 \DeclareOption{leqno}{\input{leqno.clo}}
 \DeclareOption{fleqn}{\input{fleqn.clo}}
 \DeclareOption{openbib}{%
   \AtEndOfPackage{%
    \renewcommand\@openbib@code{%
       \advance\leftmargin\bibindent
       \itemindent -\bibindent
       \listparindent \itemindent
       \parsep \z@
       }%
    \renewcommand\newblock{\par}}%
 }
 %\ExecuteOptions{letterpaper,10pt,oneside,onecolumn,final}
 \ExecuteOptions{a4paper,10pt,twoside,fleqn,onecolumn,final}
 \ProcessOptions
 \input{size1\@ptsize.clo}
 \setlength\lineskip{1\p@}
 \setlength\normallineskip{1\p@}
 %
 \setlength{\textwidth}{175mm} % the AN width - ADS 010997
 \setlength{\textheight}{247mm} % the AN height - ADS 010997
 \setlength\topmargin{0pt} % AN value - ADS 010997
 \setlength\topmargin{-2cm} % AN value - ADS 06012000
 \setlength\oddsidemargin   {-25\p@} % AN value - ADS 010997
 \setlength\evensidemargin  {-25\p@} % AN value - ADS 010997
 \setlength\headheight{8\p@} % AN value - ADS 010997
 \setlength\headsep   {6mm} % AN value - ADS 010997
 %
 \renewcommand\baselinestretch{}
 \setlength\parskip{1\p@ \@plus 2\p@ minus 1\p@} % the AN-value - ADS 010997
 %\setlength\parskip{0\p@ \@plus \p@}
 \@lowpenalty   51
 \@medpenalty  151
 \@highpenalty 301
 \setcounter{topnumber}{2}
 \renewcommand\topfraction{.7}
 \setcounter{bottomnumber}{1}
 \renewcommand\bottomfraction{.3}
 \setcounter{totalnumber}{3}
 \renewcommand\textfraction{.2}
 \renewcommand\floatpagefraction{.5}
 \setcounter{dbltopnumber}{2}
 \renewcommand\dbltopfraction{.7}
 \renewcommand\dblfloatpagefraction{.5}
 \if@twoside
   \def\ps@headings{%
       \let\@oddfoot\@empty\let\@evenfoot\@empty
%       \def\@evenhead{\thepage\hfil\slshape\leftmark}%
%       \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
       \def\@evenhead{\thepage\hfil\small\leftmark}%
       \def\@oddhead{{\small\rightmark}\hfil\thepage}%
       \let\@mkboth\markboth
     \def\sectionmark##1{%
       \markboth {\MakeUppercase{%
	 \ifnum \c@secnumdepth >\z@
	   \thesection\quad
	 \fi
	 ##1}}{}}%
     \def\subsectionmark##1{%
       \markright {%
	 \ifnum \c@secnumdepth >\@ne
	   \thesubsection\quad
	 \fi
	 ##1}}}
 \else
   \def\ps@headings{%
     \let\@oddfoot\@empty
%     \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
     \def\@oddhead{{\small\rightmark}\hfil\thepage}%
     \let\@mkboth\markboth
     \def\sectionmark##1{%
       \markright {\MakeUppercase{%
	 \ifnum \c@secnumdepth >\m@ne
	   \thesection\quad
	 \fi
	 ##1}}}}
 \fi
 \def\ps@myheadings{%
     \let\@oddfoot\@empty\let\@evenfoot\@empty
%     \def\@evenhead{\thepage\hfil\slshape\leftmark}%
%     \def\@oddhead{{\slshape\rightmark}\hfil\thepage}%
     \def\@evenhead{\thepage\hfil\small\leftmark}%
     \def\@oddhead{{\small\rightmark}\hfil\thepage}%
     \let\@mkboth\@gobbletwo
     \let\sectionmark\@gobble
     \let\subsectionmark\@gobble
     }
   \if@titlepage
   \newcommand\maketitle{\begin{titlepage}%
   \let\footnotesize\small
   \let\footnoterule\relax
   \let \footnote \thanks
   \null\vfil
   \vskip 60\p@
 %  \begin{center}%   title, author etc not centered - ADS 010997
   \begin{flushleft}
 %    {\LARGE \@title \par}%
     {\Large\bf \@title \par}% size changed to \large\bf - ADS 010997
 %    \vskip 3em %
     \vskip 10mm % % fixed vskip - ADS 010997
     \leftskip=18mm % - ADS 010997
      {\@author \par} % - ADS 010997 
       \vskip 8mm {\small \@date} % - ADS 010997 
 %    {\large
 %     \lineskip .75em%
 %      \begin{tabular}[t]{c}%
 %        \@author
 %      \end{tabular}\par}%
 %      \vskip 1.5em%
 %    {\large \@date \par}%       % Set date in \large size.
 %  \end{center}     %   title, author etc not centered - ADS 010997
   \end{flushleft}
   \par
   \@thanks
   \vfil\null
   \end{titlepage}%
   \setcounter{footnote}{0}%
   \global\let\thanks\relax
   \global\let\maketitle\relax
   \global\let\@thanks\@empty
   \global\let\@author\@empty
   \global\let\@date\@empty
   \global\let\@title\@empty
   \global\let\title\relax
   \global\let\author\relax
   \global\let\date\relax
   \global\let\and\relax
 }
 \else
 \newcommand\maketitle{\par
   \begingroup
     \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
     \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
     \long\def\@makefntext##1{\parindent 1em\noindent
	     \hb@xt@1.8em{%
		 \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
     \if@twocolumn
       \ifnum \col@number=\@ne
	 \@maketitle
       \else
	 \twocolumn[\@maketitle]%
       \fi
     \else
 %      \newpage  % title and headline on same page - ADS 010997
       \global\@topnum\z@   % Prevents figures from going at top of page.
       \@maketitle
     \fi
%     \thispagestyle{plain}\@thanks
     \thispagestyle{empty}\@thanks % ADS 051197 no pagenumber on title page
   \endgroup
   \setcounter{footnote}{0}%
   \global\let\thanks\relax
   \global\let\maketitle\relax
   \global\let\@maketitle\relax
   \global\let\@thanks\@empty
   \global\let\@author\@empty
   \global\let\@date\@empty
   \global\let\@title\@empty
   \global\let\title\relax
   \global\let\author\relax
   \global\let\date\relax
   \global\let\and\relax
 }


\def\makeheadbox{{
\hbox to\textwidth{%
\hbox to0pt{\vbox{\hsize=30cc
\baselineskip=12pt\hrule\hbox
{\vrule\kern3pt\vbox{\kern3pt
\hbox to30cc{\bf\ manuscript no.\hfil}
\hbox{(will be inserted by hand later)}
\kern3pt\hrule\kern3pt\bf
\hbox{Your thesaurus codes are:}
\hbox{\rightskip=0pt plus3em\advance\hsize by-7pt
\vbox{\noindent\ignorespaces}}
\kern3pt}\hfil\kern3pt\vrule}\hrule}\hss}
\hfil\llap{\quad}}}}

 \def\@maketitle{%
%   \newpage % title and headline on same page
   \null
%\vbox to0pt{\vskip-40pt \nointerlineskip \makeheadbox} % test ADS 0611
%   \vskip 2em%
%   \vskip 10em% drive distance between headline and title
%  \begin{center}%   title, author etc not centered - ADS 010997
   \begin{flushleft}
   \let \footnote \thanks
 %    {\LARGE \@title \par}%
     {\vskip -6.5 mm \large \bf \@title \par}% size changed to large - ADS 010997
     \vskip 10mm% % fixed vskip - ADS 010997
     \leftskip=18mm % - ADS 010997
      {\@author \par} % - ADS 010997 
       \vskip 8mm {\small \@date } % - ADS 010997 
 %    {\LARGE \@title \par}%
 %    \vskip 1.5em%
 %    {\large
 %      \lineskip .5em%
 %      \begin{tabular}[t]{c}%
 %        \@author
 %      \end{tabular}\par}%
 %    \vskip 1em%
 %    {\large \@date}%
 %  \end{center}% -ADS 010997
   \end{flushleft}
   \par
%   \vskip 1.5em}
   \vskip 10 mm} % ADS 061197
 \fi
 \setcounter{secnumdepth}{3}
 % 
 \newcounter {part}
 \newcounter {section}
 \newcounter {subsection}[section]
 \newcounter {subsubsection}[subsection]
 \newcounter {paragraph}[subsubsection]
 \newcounter {subparagraph}[paragraph]
 \renewcommand \thepart {\@Roman\c@part}
% \renewcommand \thesection {\@arabic\c@section}
% \renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
% \renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
% -ADS 160498, dots following counter added 
 \renewcommand \thesection {\@arabic\c@section .}
 \renewcommand\thesubsection   {\thesection\@arabic\c@subsection .}
 \renewcommand\thesubsubsection{\thesubsection\@arabic\c@subsubsection .}
 \renewcommand\theparagraph    {\thesubsubsection\@arabic\c@paragraph.}
 \renewcommand\thesubparagraph {\theparagraph\@arabic\c@subparagraph.}
 \newcommand\part{\par
    \addvspace{4ex}%
    \@afterindentfalse
    \secdef\@part\@spart}

 \def\@part[#1]#2{%
     \ifnum \c@secnumdepth >\m@ne
       \refstepcounter{part}%
       \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
     \else
       \addcontentsline{toc}{part}{#1}%
     \fi
     {\parindent \z@ \raggedright
      \interlinepenalty \@M
      \normalfont
      \ifnum \c@secnumdepth >\m@ne
	\Large\bfseries \partname~\thepart
	\par\nobreak
      \fi
      \huge \bfseries #2%
      \markboth{}{}\par}%
     \nobreak
     \vskip 3ex
     \@afterheading}
 \def\@spart#1{%
     {\parindent \z@ \raggedright
      \interlinepenalty \@M
      \normalfont
      \huge \bfseries #1\par}%
      \nobreak
      \vskip 3ex
      \@afterheading}
 \newcommand\section{\@startsection {section}{1}{\z@}%
				    {-3.5ex \@plus -1ex \@minus -.2ex}% ori
%				    {+5.5ex \@plus -1ex \@minus -.2ex}% ads
				    {2.3ex \@plus.2ex}%
				    {\normalfont\normalsize\bfseries}} %-ADS
%				    {\normalfont\Large\bfseries}}% ori
 \newcommand\subsection{\@startsection{subsection}{2}{\z@}%
				      {-3.25ex\@plus -1ex \@minus -.2ex}%
%				      {+2.5ex\@plus -1ex \@minus -.2ex}%
				      {1.5ex \@plus .2ex}%
				      {\normalfont\small\bfseries}}
%				      {\normalfont\large\bfseries}}
 \newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
				      {-3.25ex\@plus -1ex \@minus -.2ex}%
				      {1.5ex \@plus .2ex}%
				      {\normalfont\small\bfseries}}
%				      {\normalfont\normalsize\bfseries}}
 \newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
				     {3.25ex \@plus1ex \@minus.2ex}%
				     {-1em}%
				     {\normalfont\normalsize\bfseries}}
 \newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
					{3.25ex \@plus1ex \@minus .2ex}%
					{-1em}%
				       {\normalfont\normalsize\bfseries}}
 \if@twocolumn
   \setlength\leftmargini  {2em}
 \else
   \setlength\leftmargini  {2.5em}
 \fi
 \leftmargin  \leftmargini
 \setlength\leftmarginii  {2.2em}
 \setlength\leftmarginiii {1.87em}
 \setlength\leftmarginiv  {1.7em}
 \if@twocolumn
   \setlength\leftmarginv  {.5em}
   \setlength\leftmarginvi {.5em}
 \else
   \setlength\leftmarginv  {1em}
   \setlength\leftmarginvi {1em}
 \fi
 \setlength  \labelsep  {.5em}
 \setlength  \labelwidth{\leftmargini}
 \addtolength\labelwidth{-\labelsep}
 \@beginparpenalty -\@lowpenalty
 \@endparpenalty   -\@lowpenalty
 \@itempenalty     -\@lowpenalty
 \renewcommand\theenumi{\@arabic\c@enumi}
 \renewcommand\theenumii{\@alph\c@enumii}
 \renewcommand\theenumiii{\@roman\c@enumiii}
 \renewcommand\theenumiv{\@Alph\c@enumiv}
 \newcommand\labelenumi{\theenumi.}
 \newcommand\labelenumii{(\theenumii)}
 \newcommand\labelenumiii{\theenumiii.}
 \newcommand\labelenumiv{\theenumiv.}
 \renewcommand\p@enumii{\theenumi}
 \renewcommand\p@enumiii{\theenumi(\theenumii)}
 \renewcommand\p@enumiv{\p@enumiii\theenumiii}
 \newcommand\labelitemi{\textbullet}
 \newcommand\labelitemii{\normalfont\bfseries \textendash}
 \newcommand\labelitemiii{\textasteriskcentered}
 \newcommand\labelitemiv{\textperiodcentered}
 \newenvironment{description}
		{\list{}{\labelwidth\z@ \itemindent-\leftmargin
			 \let\makelabel\descriptionlabel}}
		{\endlist}
 \newcommand*\descriptionlabel[1]{\hspace\labelsep
				 \normalfont\bfseries #1}
 \if@titlepage
   \newenvironment{abstract}{%
       \titlepage
       \null\vfil
       \@beginparpenalty\@lowpenalty
       \begin{center}%
	 \bfseries \abstractname
	 \@endparpenalty\@M
       \end{center}}%
      {\par\vfil\null\endtitlepage}
 \else
   \newenvironment{abstract}{%
       \if@twocolumn
	 \section*{\abstractname}%
       \else
	 \small
%test	 \begin{center}%
%test	   {\bfseries \abstractname\vspace{-.5em}\vspace{\z@}}%
%test	 \end{center}%
	 \quotation
       \fi}
       {\if@twocolumn\else\endquotation\fi}
 \fi
 \newenvironment{verse}
		{\let\\\@centercr
		 \list{}{\itemsep      \z@
			 \itemindent   -1.5em%
			 \listparindent\itemindent
			 \rightmargin  \leftmargin
			 \advance\leftmargin 1.5em}%
		 \item\relax}
		{\endlist}
 \newenvironment{quotation}
		{\list{}{\listparindent 1.5em%
			 \itemindent    \listparindent
			 \rightmargin   \leftmargin
			 \parsep        \z@ \@plus\p@}%
		 \item\relax}
		{\endlist}
 \newenvironment{quote}
		{\list{}{\rightmargin\leftmargin}%
		 \item\relax}
		{\endlist}
 \if@compatibility
 \newenvironment{titlepage}
     {%
       \if@twocolumn
	 \@restonecoltrue\onecolumn
       \else
 %        \@restonecolfalse\newpage test with \newpage supressed - ADS 010997
	 \@restonecolfalse%\newpage test with \newpage supressed - ADS 010997
       \fi
       \thispagestyle{empty}%
       \setcounter{page}\z@
     }%
 %    {\if@restonecol\twocolumn \else \newpage \fi
     {\if@restonecol\twocolumn \else \fi % test ADS 010997
     }
 \else
 \newenvironment{titlepage}
     {%
       \if@twocolumn
	 \@restonecoltrue\onecolumn
       \else
 %        \@restonecolfalse\newpage
	 \@restonecolfalse % test newpage supressed ADS 010997
       \fi
       \thispagestyle{empty}%
       \setcounter{page}\@ne
     }%
 %    {\if@restonecol\twocolumn \else \newpage \fi
     {\if@restonecol\twocolumn \else \fi % test - ADS 010997
      \if@twoside\else
	 \setcounter{page}\@ne
      \fi
     }
 \fi
 \newcommand\appendix{\par
   \setcounter{section}{0}%
   \setcounter{subsection}{0}%
%\hangafter=1\hangindent=0pt
   \renewcommand\thesection{\@Alph\c@section}}
 \setlength\arraycolsep{5\p@}
 \setlength\tabcolsep{6\p@}
 \setlength\arrayrulewidth{.4\p@}
 \setlength\doublerulesep{2\p@}
 \setlength\tabbingsep{\labelsep}
 \skip\@mpfootins = \skip\footins
 \setlength\fboxsep{3\p@}
 \setlength\fboxrule{.4\p@}
 \renewcommand \theequation {\@arabic\c@equation}
 \newcounter{figure}
 \renewcommand \thefigure {\@arabic\c@figure}
 \def\fps@figure{tbp}
 \def\ftype@figure{1}
 \def\ext@figure{lof}
 \def\fnum@figure{\figurename~\thefigure}
 \newenvironment{figure}
		{\@float{figure}}
		{\end@float}
 \newenvironment{figure*}
		{\@dblfloat{figure}}
		{\end@dblfloat}
 \newcounter{table}
 \renewcommand\thetable{\@arabic\c@table}
 \def\fps@table{tbp}
 \def\ftype@table{2}
 \def\ext@table{lot}
 \def\fnum@table{\tablename~\thetable}
 \newenvironment{table}
		{\@float{table}}
		{\end@float}
 \newenvironment{table*}
		{\@dblfloat{table}}
		{\end@dblfloat}
 \newlength\abovecaptionskip
 \newlength\belowcaptionskip
 \setlength\abovecaptionskip{10\p@}
 \setlength\belowcaptionskip{0\p@}
 \long\def\@makecaption#1#2{%
   \vskip\abovecaptionskip
%%%%%%%%%%%%%%%%%%%%%%%%%%%%% {\small } eingefuegt
   \setlength{\baselineskip}{10pt} %-ADS 16OCT1998 kleinerer Zeilenabstand%
%				   in figure und table captions
   \sbox\@tempboxa{{\small #1: #2}}%
   \ifdim \wd\@tempboxa >\hsize
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    {\small #1: #2}\par
   \else
     \global \@minipagefalse
     \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
   \fi
   \vskip\belowcaptionskip}
 \DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
 \DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
 \DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
 \DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
 \DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
 \DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
% \DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\small} % ADS 13-11-97
 \DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
 \DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
 \DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
 \newcommand\@pnumwidth{1.55em}
 \newcommand\@tocrmarg{2.55em}
 \newcommand\@dotsep{4.5}
 \setcounter{tocdepth}{3}
 \newcommand\tableofcontents{%
     \section*{\contentsname
	 \@mkboth{%
	    \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
     \@starttoc{toc}%
     }
 \newcommand*\l@part[2]{%
   \ifnum \c@tocdepth >-2\relax
     \addpenalty\@secpenalty
     \addvspace{2.25em \@plus\p@}%
     \begingroup
       \setlength\@tempdima{3em}%
       \parindent \z@ \rightskip \@pnumwidth
       \parfillskip -\@pnumwidth
       {\leavevmode
	\large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
	\nobreak
	\if@compatibility
	  \global\@nobreaktrue
	  \everypar{\global\@nobreakfalse\everypar{}}%
       \fi
     \endgroup
   \fi}
 \newcommand*\l@section[2]{%
   \ifnum \c@tocdepth >\z@
     \addpenalty\@secpenalty
     \addvspace{1.0em \@plus\p@}%
     \setlength\@tempdima{1.5em}%
     \begingroup
       \parindent \z@ \rightskip \@pnumwidth
       \parfillskip -\@pnumwidth
       \leavevmode \bfseries
       \advance\leftskip\@tempdima
       \hskip -\leftskip
       #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
     \endgroup
   \fi}
 \newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
 \newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
 \newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
 \newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
 \newcommand\listoffigures{%
     \section*{\listfigurename
       \@mkboth{\MakeUppercase\listfigurename}%
	       {\MakeUppercase\listfigurename}}%
     \@starttoc{lof}%
     }
 \newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
 \newcommand\listoftables{%
     \section*{\listtablename
       \@mkboth{%
	   \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
     \@starttoc{lot}%
     }
 \let\l@table\l@figure
 \newdimen\bibindent
%\setlength\bibindent{1.5em} %040598 -ADS out
 \setlength\bibindent{\parindent} %040598 -ADS
 \def\@biblabel#1{}
 \def\@cite#1#2{{#1\if@tempswa , #2\fi}}
 \newenvironment{thebibliography}[1]
      {\section*{\refname
%      {\subsection*{\refname
%       \@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%040598 -ADS
        \@mkboth{\refname}{\refname}}\small %040598 -ADS in
       \list{\@biblabel{\@arabic\c@enumiv}}%
	    {\settowidth\labelwidth{\@biblabel{#1}}%
%040598	     \leftmargin\labelwidth
	     \leftmargin\bibindent %040598 -ADS in
%040598	     \advance\leftmargin\labelsep
             \setlength{\itemindent}{-\leftmargin} %040598 -ADS in
	     \setlength{\itemsep}{0ex} %240898 ADS in 
	     \setlength{\parsep}{-0.5pt} %240898 ADS in 
	     \@openbib@code
	     \usecounter{enumiv}%
	     \let\p@enumiv\@empty
	     \renewcommand\theenumiv{\@arabic\c@enumiv}}%
       \sloppy
       \clubpenalty4000
       \@clubpenalty \clubpenalty
       \widowpenalty4000%
       \sfcode`\.\@m}
      {\def\@noitemerr
	{\@latex@warning{Empty `thebibliography' environment}}%
       \endlist}
 \newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
 \let\@openbib@code\@empty
 \newenvironment{theindex}
		{\if@twocolumn
		   \@restonecolfalse
		 \else
		   \@restonecoltrue
		 \fi
		 \columnseprule \z@
		 \columnsep 35\p@
		 \twocolumn[\section*{\indexname}]%
		 \@mkboth{\MakeUppercase\indexname}%
			 {\MakeUppercase\indexname}%
%		 \thispagestyle{plain}\parindent\z@
		 \thispagestyle{empty}\parindent\z@ % ADS 051197 no pagenumber on title page
		 \parskip\z@ \@plus .3\p@\relax
		 \let\item\@idxitem}
		{\if@restonecol\onecolumn\else\clearpage\fi}
 \newcommand\@idxitem{\par\hangindent 40\p@}
 \newcommand\subitem{\@idxitem \hspace*{20\p@}}
 \newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
 \newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
 \renewcommand\footnoterule{%
   \kern-3\p@
   \hrule\@width.4\columnwidth
   \kern2.6\p@}
 \newcommand\@makefntext[1]{%
     \parindent 1em%
     \noindent
     \hb@xt@1.8em{\hss\@makefnmark}#1}
 \newcommand\contentsname{Contents}
 \newcommand\listfigurename{List of Figures}
 \newcommand\listtablename{List of Tables}
 \newcommand\refname{References}
 \newcommand\indexname{Index}
 \newcommand\figurename{Fig.}
 \newcommand\tablename{Table}
 \newcommand\partname{Part}
 \newcommand\appendixname{Appendix}
 \newcommand\abstractname{Abstract}
 \newcommand\today{}
 \edef\today{\ifcase\month\or
   January\or February\or March\or April\or May\or June\or
   July\or August\or September\or October\or November\or December\fi
   \space\number\day, \number\year}
 \setlength\columnsep{10\p@}
 \setlength\columnseprule{0\p@}
 \pagestyle{plain}
 \pagenumbering{arabic}
 \if@twoside
 \else
   \raggedbottom
 \fi
 \if@twocolumn
   \twocolumn
   \sloppy
   \flushbottom
 \else
   \onecolumn
 \fi

 % all definitions following here are AN specific - ADS010997
\def\headnote#1{\gdef\@headnote{#1}}
\def\@headnote{}

% \def\makeheadline{\vbox to 0pt{\vskip -34pt\hbox to 50mm
% {\small Astron. Nachr. 319, (1998) \hfill}}}
 \def\makeheadline{\vbox to 0pt{\vskip -34pt\hbox to 50mm
 {\small \@headnote\hfill}}}

 \def\acknowledgements{\par\addvspace{6pt}\small\rm
 \trivlist\item[\hskip\labelsep{\em Acknowledgements.\/}]}
 \def\endacknowledgements{\endtrivlist\addvspace{6pt}}

% \def\address #1END {{\vspace{9mm}\noindent\small Address of the author: \\ #1}}
% \def\addresses #1END {{\vspace{9mm}\noindent\small Addresses of the authors: \\ #1}}
% END phrase omitted -ADS 170498
 \def\address{{\vspace{9mm}\noindent\small Address of the author: \\}}
 \def\addresses{{\vspace{9mm}\noindent\small Addresses of the authors: \\}}

 \newcounter{kap}
 \newcounter{sect}
 \newcounter{subsect}
 \setcounter{kap}{1}
 %
 \def\kap #1 {
 \setcounter{sect}{1}
 {\vspace{9mm}\noindent\bf\arabic{kap}. 
%\hspace{12mm} 
{#1} 
 \bigskip\par\noindent\stepcounter{kap}}}

 \def\sect #1 {
 \addtocounter{kap}{-1}
 {\bigskip\noindent\small\bf\arabic{kap}.\arabic{sect}.% \hspace{9mm} 
\ {#1} 
\medskip\par\noindent\setcounter{subsect}{1}\addtocounter{kap}{1}
%\medskip\noindent\setcounter{subsect}{1}\addtocounter{kap}{1}
\stepcounter{sect}}}

 \def\subsect #1 {
 \addtocounter{kap}{-1}
 \addtocounter{sect}{-1}
 {\bigskip\noindent\normalsize\it\arabic{kap}.\arabic{sect}.\arabic{subsect}.\ {#1}  
 \smallskip\par\noindent\addtocounter{kap}{1}\addtocounter{sect}{1}\stepcounter{subsect}}}
 \def\app #1 {
 {\vspace{9mm}\noindent\bf Appendix. \hspace{2mm} {#1} 
 \bigskip\par\noindent\stepcounter{kap}}}

 \newcommand{\aba}{\renewcommand{\baselinestretch}{0.9}\noindent\small}
 \newcommand{\abe}{\renewcommand{\baselinestretch}{1}\normalsize}
 \def\summary #1END {{\noindent \small #1 \par \medskip}}
 \def\keyw #1END {{\noindent \small {\it Key words:} #1 \par \medskip}} 
 \def\AAAcla #1END {{\noindent \small {\it AAA subject classification:} #1 
 \par \vspace{2mm}}} 
 %
 %
% \def\refer {{\vspace{9mm}\hspace{2mm}{\bf References}\bigskip}}
\def\refer {{\vspace{9mm}{\noindent\normalfont\normalsize\bfseries References}\bigskip}}
\def\rf{\small\parindent=0.0cm\hangindent=10pt\hangafter=1\par}
%\def\rfe{\small\parindent=0.0cm\hangindent=0pt\hangafter=1\indent\par}

\def\aap{Astron.~Astrophys.~}
\def\aaps{Astron.~Astrophys.~Suppl.~}
\def\mnras{Mon.~Not.~R.~Astron.~Soc.~}
\def\aj{Astron.~J.~}
\def\apj{Astrophys.~J.~}
\def\apjl{Astrophys.~J.~Lett.~}
\def\apjs{Astrophys.~J.~Suppl.~}
\def\baas{Bull.~Am.~Astron.~Soc.~}
\def\pasp{Publ.~Astron.~Soc.~Pac.~}
\def\pasj{Publ.~Astron.~Soc.~Jap.~}
\def\araa{Ann.~Rev.~Astron.~Astrophys.~}
\def\an{Astron.~Nachr.~}
\def\apss{Astrophys.~Sp.~Sci.~}

%%% definition of astronomical and mathematical symbols adapted from A&A

\def\sun{\hbox{$\odot$}}
\def\la{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
<\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
<\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr\sim\cr}}}}}
\def\ga{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
>\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
>\cr\sim\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr\sim\cr}}}}}
\def\degr{\hbox{$^\circ$}}
\def\arcmin{\hbox{$^\prime$}}
\def\arcsec{\hbox{$^{\prime\prime}$}}
\def\utw{\smash{\rlap{\lower5pt\hbox{$\sim$}}}}
\def\udtw{\smash{\rlap{\lower6pt\hbox{$\approx$}}}}
\def\fd{\hbox{$.\!\!^{\rm d}$}}
\def\fh{\hbox{$.\!\!^{\rm h}$}}
\def\fm{\hbox{$.\!\!^{\rm m}$}}
\def\fs{\hbox{$.\!\!^{\rm s}$}}
\def\fdg{\hbox{$.\!\!^\circ$}}
\def\farcm{\hbox{$.\mkern-4mu^\prime$}}
\def\farcs{\hbox{$.\!\!^{\prime\prime}$}}
\def\fp{\hbox{$.\!\!^{\scriptscriptstyle\rm p}$}}
\def\cor{\mathrel{\mathchoice {\hbox{$\widehat=$}}{\hbox{$\widehat=$}}
{\hbox{$\scriptstyle\hat=$}}
{\hbox{$\scriptscriptstyle\hat=$}}}}
\def\sol{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr\sim\cr<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\sim\cr
<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr\sim\cr
<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
\sim\cr<\cr}}}}}
\def\sog{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr\sim\cr>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\sim\cr
>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
\sim\cr>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
\sim\cr>\cr}}}}}
\def\lse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
<\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr\simeq\cr}}}}}
\def\gse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
>\cr\simeq\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr\simeq\cr}}}}}
\def\grole{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\noalign{\vskip-1.5pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
>\cr\noalign{\vskip-1.5pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
>\cr\noalign{\vskip-1pt}<\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr\noalign{\vskip-0.5pt}<\cr}}}}}
\def\leogr{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\noalign{\vskip-1.5pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
<\cr\noalign{\vskip-1.5pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
<\cr\noalign{\vskip-1pt}>\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr\noalign{\vskip-0.5pt}>\cr}}}}}
\def\loa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
<\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr\approx\cr}}}}}
\def\goa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
>\cr\approx\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr\approx\cr}}}}}
\def\diameter{{\ifmmode\mathchoice
{\ooalign{\hfil\hbox{$\displaystyle/$}\hfil\crcr
{\hbox{$\displaystyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\textstyle/$}\hfil\crcr
{\hbox{$\textstyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\scriptstyle/$}\hfil\crcr
{\hbox{$\scriptstyle\mathchar"20D$}}}}
{\ooalign{\hfil\hbox{$\scriptscriptstyle/$}\hfil\crcr
{\hbox{$\scriptscriptstyle\mathchar"20D$}}}}
\else{\ooalign{\hfil/\hfil\crcr\mathhexbox20D}}%
\fi}}

\def\getsto{\mathrel{\mathchoice {\vcenter{\offinterlineskip
\halign{\hfil
$\displaystyle##$\hfil\cr\gets\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\gets
\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr\gets
\cr\to\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
\gets\cr\to\cr}}}}}
\def\lid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr<\cr\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr<\cr
\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr<\cr
\noalign{\vskip1pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
<\cr
\noalign{\vskip0.9pt}=\cr}}}}}
\def\gid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
$\displaystyle##$\hfil\cr>\cr\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr>\cr
\noalign{\vskip1.2pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr>\cr
\noalign{\vskip1pt}=\cr}}}
{\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
>\cr
\noalign{\vskip0.9pt}=\cr}}}}}
\def\bbbr{{\rm I\!R}} %reelle Zahlen
\def\bbbm{{\rm I\!M}}
\def\bbbn{{\rm I\!N}} %natuerliche Zahlen
\def\bbbf{{\rm I\!F}}
\def\bbbh{{\rm I\!H}}
\def\bbbk{{\rm I\!K}}
\def\bbbp{{\rm I\!P}}
\def\bbbone{{\mathchoice {\rm 1\mskip-4mu l} {\rm 1\mskip-4mu l}
{\rm 1\mskip-4.5mu l} {\rm 1\mskip-5mu l}}}
\def\bbbc{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm C$}\hbox{\hbox
to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\textstyle\rm C$}\hbox{\hbox
to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptstyle\rm C$}\hbox{\hbox
to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptscriptstyle\rm C$}\hbox{\hbox
to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}}}
\def\bbbq{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm
Q$}\hbox{\raise
0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.8\ht0\hss}\box0}}
{\setbox0=\hbox{$\textstyle\rm Q$}\hbox{\raise
0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.8\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptstyle\rm Q$}\hbox{\raise
0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.7\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptscriptstyle\rm Q$}\hbox{\raise
0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.7\ht0\hss}\box0}}}}
\def\bbbt{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm
T$}\hbox{\hbox to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\textstyle\rm T$}\hbox{\hbox
to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptstyle\rm T$}\hbox{\hbox
to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptscriptstyle\rm T$}\hbox{\hbox
to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}}}
\def\bbbs{{\mathchoice
{\setbox0=\hbox{$\displaystyle     \rm S$}\hbox{\raise0.5\ht0\hbox
to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\hbox
to0pt{\kern0.55\wd0\vrule height0.5\ht0\hss}\box0}}
{\setbox0=\hbox{$\textstyle        \rm S$}\hbox{\raise0.5\ht0\hbox
to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\hbox
to0pt{\kern0.55\wd0\vrule height0.5\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptstyle      \rm S$}\hbox{\raise0.5\ht0\hbox
to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\raise0.05\ht0\hbox
to0pt{\kern0.5\wd0\vrule height0.45\ht0\hss}\box0}}
{\setbox0=\hbox{$\scriptscriptstyle\rm S$}\hbox{\raise0.5\ht0\hbox
to0pt{\kern0.4\wd0\vrule height0.45\ht0\hss}\raise0.05\ht0\hbox
to0pt{\kern0.55\wd0\vrule height0.45\ht0\hss}\box0}}}}
\def\bbbz{{\mathchoice {\hbox{$\sf\textstyle Z\kern-0.4em Z$}}
{\hbox{$\sf\textstyle Z\kern-0.4em Z$}}
{\hbox{$\sf\scriptstyle Z\kern-0.3em Z$}}
{\hbox{$\sf\scriptscriptstyle Z\kern-0.2em Z$}}}}
\def\ts{\thinspace}




\endinput

%%
%% End of file `an_art.cls'.

