% Document class file for Journal of Nonlinear Mathematical Physics
% Document history:
%     Version 0.1a: 2000-02-25 Ove Edlund
%     Version 0.1b: 2000-02-27 Ove Edlund, Fixed fleqn
%
% Known problems:
%     None

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jnmp01b}[2000/02/27 v0.1b Document class for JNMP]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[fleqn,11pt,twoside]{article}
\PassOptionsToPackage{fleqn}{amsmath}
\RequirePackage{amsthm}
\RequirePackage{amssymb}

% Titlepage

\newcommand{\copyrightnote}[2]{{\renewcommand{\thefootnote}{}
 \footnotetext{\small\it
\begin{flushleft}
Copyright \copyright \ #1 by  #2
\end{flushleft}}}}

\newcommand{\Name}[1]{\begin{flushleft}
                       \LARGE \bf #1
                       \end{flushleft}\vspace{-3mm}}

\newcommand{\Author}[1]{\begin{flushleft}
                       \it #1 \end{flushleft}}

\newcommand{\Adress}[1]{\begin{flushleft}
                       \it #1 \end{flushleft}}


\newcommand{\Date}[1]{\begin{flushleft}
                      \small  \it #1 \end{flushleft}}


% Replace these in document

\newcommand{\evenhead}{Author \ name}
\newcommand{\oddhead}{Article \ name}

% Set head and foot

\renewcommand{\@evenhead}{
\hspace*{-3pt}\raisebox{-15pt}[\headheight][0pt]{\vbox{\hbox to \textwidth 
{\thepage \hfil \evenhead}\vskip4pt \hrule}}}
\renewcommand{\@oddhead}{
\hspace*{-3pt}\raisebox{-15pt}[\headheight][0pt]{\vbox{\hbox to \textwidth 
{\oddhead \hfil \thepage}\vskip4pt\hrule}}}
\renewcommand{\@evenfoot}{}
\renewcommand{\@oddfoot}{}


% Papersize

\setlength{\textwidth}{150.0mm}
\setlength{\textheight}{220.0mm}
\setlength{\oddsidemargin}{0in}
\setlength{\evensidemargin}{0in}
\setlength{\topmargin}{-1cm}
\setlength{\parindent}{5.0mm}


% This makes the Figure/Table text a little smaller and makes the
% number boldface.

\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\small \textbf{#1.}\ \ #2}%
  \ifdim \wd\@tempboxa >\hsize
    {\small \textbf{#1.}\ \ #2}\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}


% Defines the \numberwithin command from AMS-LaTeX
%
\def\numberwithin#1#2{\@ifundefined{c@#1}{\@nocounterr{#1}}{%
  \@ifundefined{c@#2}{\@nocnterr{#2}}{%
  \@addtoreset{#1}{#2}%
  \toks@\@xp\@xp\@xp{\csname the#1\endcsname}%
  \@xp\xdef\csname the#1\endcsname
    {\@xp\@nx\csname the#2\endcsname
     .\the\toks@}}}}

% Proof should be boldface
%
\renewenvironment{proof}[1][\proofname]{\par
  \normalfont
  \topsep6\p@\@plus6\p@ \trivlist
  \item[\hskip\labelsep\textbf{%
    #1}\@addpunct{.}]\ignorespaces
}{%
  \qed\endtrivlist
}

% Command for reseting the footnote rule to LaTeX default
%
\newcommand{\resetfootnoterule} {
  \renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
}

%  Initializations
%
\renewcommand{\qedsymbol}{$\blacksquare$}
\renewcommand{\footnoterule}{}

\endinput
