
%Cut here for the OUP style file (filename `multi3.cls'):
%***********************************************************************
% OXFORD UNIVERSITY PRESS
% LaTeX2e class file (modified style file)
% Name: MULTI3.CLS
% Last updated: November 1994
% Version number: 3.0
% Copyright Oxford University Press 1994
% Authors: Richard Preston and Anna Drage
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{multi3}
	      [1994/07/13 v1.2u
 OUP LaTeX Multi3 class]
\RequirePackage{latexsym}
%\typeout{Using MULTI3.sty Version 2.0 <April 1996>}
%
% *************************************
% Page dimensions, lineskips, typesizes
% *************************************
% \magnification=\magstep0
\lineskip 1pt \normallineskip 1pt
\def\baselinestretch{1}

\@twosidetrue
\@mparswitchtrue

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}

\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xpt\@xiipt
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\def\@normalsize{\@setsize\normalsize{12pt}\xpt\@xpt
	\abovedisplayskip 8pt minus1pt
	\belowdisplayskip\abovedisplayskip
	\abovedisplayshortskip \z@
	\belowdisplayshortskip 8pt minus1pt
	\let\@listi\@listI} 
\newcommand\small{%
   \@setfontsize\small\@ixpt{10}%
   \abovedisplayskip 6pt minus1pt
   \belowdisplayskip \abovedisplayskip
	\abovedisplayshortskip \z@
   \belowdisplayshortskip 6pt minus1pt
	\def\@listi{\parsep \z@
		\itemsep 2pt
	  \topsep 3pt minus 1pt}%
}
\newcommand\footnotesize{%
   \@setfontsize\footnotesize\@viiipt{9}%
	\abovedisplayskip 4pt minus1pt
	  \belowdisplayskip\abovedisplayskip
	\abovedisplayshortskip \z@
	\belowdisplayshortskip 4pt minus1pt
	  \def\@listi{\leftmargin\leftmargini
	\topsep 3pt minus 1pt
	\parsep \z@
	\itemsep 1pt}
}
\def\scriptsize{\@setsize\scriptsize{9pt}\viiipt\@viiipt}
\def\tiny{\@setsize\tiny{7pt}\vipt\@vipt}
\def\large{\@setsize\large{14pt}\xiipt\@xiipt}   % B
\def\Large{\@setsize\Large{16pt}\xivpt\@xivpt}   % A
\def\LARGE{\@setsize\LARGE{20pt}\xviipt\@xviipt} % Chap
\def\huge{\@setsize\huge{30pt}\xxvpt\@xxvpt}
\let\Huge=\huge
\normalfont
\def\sl{\it}
\def\em{\it}

\oddsidemargin 21pt
\evensidemargin 59pt
\marginparwidth 59pt

\marginparsep 10pt \topmargin 27pt \headheight 8pt
\headsep 18pt
\footskip 30pt

\if@compatibility
  \textheight = 44\baselineskip
\else
  \textheight = 52\baselineskip
\fi
\advance\textheight by \topskip
\textwidth 29pc \columnsep 2pc \columnseprule 0pt

\footnotesep 8.4pt
\skip\footins 10.8pt plus 4pt minus 2pt
\floatsep 14pt minus 2pt \textfloatsep 12pt minus 2pt
\intextsep 14pt minus 2pt \dblfloatsep 12pt minus2pt
\dbltextfloatsep 12pt minus 2pt 
\@fptop 0pt plus 1fil \@fpsep 8pt plus 2fil \@fpbot 0pt plus 1fil
\@dblfptop 0pt plus 1fil \@dblfpsep 8pt plus 2fil \@dblfpbot 0pt plus 1fil
\marginparpush 5pt

\parskip 0pt \parindent 1.5em 
\@lowpenalty 51 \@medpenalty 151 \@highpenalty 301
\@beginparpenalty -\@lowpenalty \@endparpenalty -\@lowpenalty
\@itempenalty -\@lowpenalty \widowpenalty4000 \clubpenalty4000

% ****************
% Author's options
% ****************
\def\ds@twoside{}
\def\ds@draft{\overfullrule 5pt}
\@options
\relax

% *******************
% Sectioning commands
% *******************
% Counters
\newcounter{part}
\newcounter{chapter}
\newcounter{section}[chapter]
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]
\newcounter{subparagraph}[paragraph]

% Form of numbers
\def\thepart{\Roman{part}}
\def\thechapter{\arabic{chapter}}
\def\thesection{\arabic{section}}
\def\thesubsection{\thesection.\arabic{subsection}}
\def\thesubsubsection{\thesubsection.\arabic{subsubsection}}
\def\theparagraph{\thesubsubsection.\arabic{paragraph}}
\def\thesubparagraph {\theparagraph.\arabic{subparagraph}}
\def\@chapapp{Chapter}

%%
%% Sectioning macros
%%

%\def\thanks#1{{\protect\footnote{#1}}}

\def\part{\cleardoublepage
\thispagestyle{empty}
  \if@twocolumn
     \onecolumn
     \@tempswatrue
     \else \@tempswafalse
  \fi
  \secdef\@part\@spart}
\def\@part[#1]#2{\ifnum \c@secnumdepth >-2 \relax%  #1=short part title, 
       \refstepcounter{part}%     			read to toc file
       \addcontentsline{toc}{part}{\thepart%	    #2=part title proper
       \hspace{1em}#1{}}\else
       \addcontentsline{toc}{part}{#1}\fi
  \markboth{}{}
  {\centering
   \ifnum \c@secnumdepth >-2 \relax
      \hbox{}\vskip 24pt
      \huge\uppercase{Part \thepart}
      \par \addvspace{20pt} \fi
      \LARGE #2 \par} \@endpart}
\def\@spart#1{\hbox{}\vskip 24pt%		#1=part title proper
    {\centering%				for un-numbered parts
    \LARGE #1\par} \@endpart}
\def\@endpart{\vfil\newpage
    \if@twoside
       \hbox{}
       \thispagestyle{empty}
       \newpage
    \fi
    \if@tempswa
       \twocolumn
    \fi}
\long\def\chapter
   {\global\@topnum\z@
    \cleardoublepage
    \thispagestyle{plain}
    \secdef\@chapter\@schapter}

% *************************************
% Use this for default chapters
% *************************************
\long\def\@chapter[#1]#2%
   {\refstepcounter{chapter}
 \thispagestyle{empty}
	\@chapterboth[#1]{#2}}
 \long\def\@chapterboth[#1]#2
    {\chaptermark{#1}
    \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#2}%
    \hbox{} \vskip 24pt
    \begin{center}
	{\huge \thechapter}\\[12pt] 
       {\LARGE \rm #2} \\[12pt]
    \end{center}
    \@afterindentfalse
    \@afterheading}

\def\@schapter#1%		For unnumbered chapters
   {\markboth{#1}{#1}
   \hbox{}\vskip 24pt
   \begin{center}
       {\LARGE\rm #1} \\[12pt]
    \end{center}
    \nobreak
    \@afterindentfalse
    \@afterheading}
\def\section{%
    \@ifstar{\@sectionstar}{\@section}}
\def\@sectionstar#1{%
    \@startsection{section}{1}{\z@}
    {-2ex minus -.1ex}{3pt}{\large\bf}*{#1}
    \typeout{#1}
    \addcontentsline{toc}{section}{#1}}
\def\@section#1{%
    \@startsection{section}{1}{\z@}
    {-2ex minus -.1ex}{3pt}{\large\bf}{#1}
    \typeout{\thesection. #1}}
\def\subsection{%
    \@ifstar{\@ssubsection}{\@subsection}}
\def\@ssubsection{\@startsection{subsection}{2}{\z@}
   {-1.5ex minus -.1ex}{3pt}{\reset@font\bfseries}*}
\def\@subsection{\@startsection{subsection}{2}{\z@}
   {-1.5ex minus -.1ex}{3pt}{\normalfont\bfseries}}
\def\subsubsection#1{\@startsection{subsubsection}{3}
   {\z@}{-1ex minus -.1ex}{3pt}
   {\normalfont\rmfamily}{\normalfont\itshape #1}}
\def\paragraph{\@startsection{paragraph}{4}{\z@}
   {1.5ex minus .1ex}{-1em}{\normalfont\bfseries}}
\def\subparagraph{\@startsection{subparagraph}{4}{\parindent}
   {1ex minus .1ex}{-1em}{\normalfont\bfseries}}
\def\@appendix{\@startsection{section}{1}{\z@}
   {-2ex minus -.1ex}{3pt}{\large\bf}}
\def\appendix#1{\setcounter{equation}{0} \@appendix{#1}
   \message{Appendix \Alph{section}~ #1}}


\setcounter{secnumdepth}{3}

% Running headlines
\mark{{}{}}

\def\ps@headings
   {\let\@mkboth\markboth
    \def\@oddfoot{}%
    \def\@evenfoot{}%
    \def\@evenhead{\rm\thepage\hfil\it\rightmark\hfil\hbox{}}%
    \def\@oddhead{\hbox{}\hfil\it\leftmark\hfil\rm\thepage}%
    \def\authormark##1{\markright{##1}}%
    \def\chaptermark##1{\markboth{##1}{##1}}%
    \def\subsectionmark##1{}}

\def\ps@myheadings
   {\@monogerr{The page style `myheadings' is not available}}


% ********************
% Figures and tables *
% ********************
% \@caption redefined so entries in Table of figs and tables
% appear as Table 1.1 [Caption] etc, rather than 1.1 [Caption]
\long\def\@caption#1[#2]#3{\par\addcontentsline{\csname ext@#1\endcsname}
	{#1}{\protect\numberline{\bf\csname fnum@#1\endcsname}
	{\ignorespaces #2}}
	\begingroup
	\@parboxrestore
	\normalfont
	\@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
	\endgroup}

\long\def\@makecaption#1#2{
	\vskip 6pt 
	\setbox\@tempboxa\hbox{\par\hangindent 1.5em{\sc #1.\enspace\rm #2}}
	\ifdim \wd\@tempboxa >\hsize 
		\par\hangindent 1.5em{\sc #1.\enspace\rm #2}
		\else
		\hbox to\hsize{\hfil\box\@tempboxa\hfil} 
	\fi}

\long\def\@tablecaption#1#2{
	\setbox\@tempboxa\hbox{\bf #1\enspace\rm #2}
	\ifdim \wd\@tempboxa>\hsize {\par\bf #1\enspace\rm #2}
		\else
		\hbox to\hsize{\hfil\box\@tempboxa\hfil}
	\fi\vskip 6pt}

% \tableparts definition
\newbox\@tempboxb
\def\tableparts#1#2{% title, tabular environment
	\hbox to\linewidth{\hss\vbox{%
	\setbox\@tempboxb\hbox{#2}\hsize\wd\@tempboxb 
	\ifdim\hsize<3in \hsize=3in \relax \fi \linewidth=\hsize
	#1\par
	\hfil\box\@tempboxb\hfil
	}\hss}}

\newcounter{figure}[chapter]
\def\thefigure{\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{Fig.\ \thefigure}
\def\figure{\@float{figure}}
\let\endfigure\end@float
\@namedef{figure*}{\@dblfloat{figure}}
\@namedef{endfigure*}{\end@dblfloat}
\newcounter{table}[chapter]
\def\thetable{\@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{Table\ \thetable}
\def\table{\let\@makecaption\@tablecaption\@float{table}}
\let\endtable\end@float
\@namedef{table*}{\@dblfloat{table}}
\@namedef{endtable*}{\end@dblfloat}

% *******************************************
% Modifications to the equation environment *
% Equations are numbered by section
% *******************************************
\@addtoreset{equation}{section}
\def\theequation{\thesection.\arabic{equation}}
\arraycolsep 5pt \tabcolsep 6pt \arrayrulewidth .4pt \doublerulesep 2pt 
\tabbingsep\labelsep 

% New theorem-like environments
\def\ex@mple{example}
\def\theoremfont{\ifx\@currenvir\ex@mple
	\def\@thmfont{\rm} \else
	\def\@thmfont{\it}\fi}
\newtheorem{definition}{Definition}[section]
\newtheorem{theorem}[definition]{Theorem}
\newtheorem{lemma}[definition]{Lemma}
\newtheorem{example}[definition]{Example}
\newtheorem{proposition}[definition]{Proposition}
\newtheorem{corollary}[definition]{Corollary}
\def\@begintheorem#1#2{\theoremfont \trivlist 
	\item[\hskip \labelsep{\bf #1\ #2}]\ \@thmfont}
\def\@opargbegintheorem#1#2#3{\theoremfont \trivlist
	\item[\hskip \labelsep{\bf #1\ #2.\ (#3)}]\ \@thmfont}
\def\endmark{\hskip 2em$\Box$\par}
\def\proof{\trivlist \item[\hskip \labelsep{\bf Proof\ }]}
\def\endproof{\null\hfill\endmark\endtrivlist}
\def\followon#1{\trivlist \item[\hskip \labelsep{\bf #1\ }]}
\def\endfollowon{\endtrivlist}

% ****************************
% List numbering and lettering
% ****************************

\def\labelenumi{{\rm(\arabic{enumi})}}
\def\theenumi{\arabic{enumi}} 
\def\labelenumii{{\rm (\alph{enumii})}}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}
\def\labelenumiii{{\rm\roman{enumiii}.}}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}
\def\labelenumiv{{\rm\Alph{enumiv}.}}
\def\theenumiv{\Alph{enumiv}} 
\def\p@enumiv{\p@enumiii\theenumiii}

\def\labelitemi{$\bullet$}
\def\labelitemii{$\ast$}
\def\labelitemiii{$\circ$}
\def\labelitemiv{\bf --}

\def\descriptionlabel#1{\hspace\labelsep \bf #1}
\def\description{\list{}{\labelwidth\z@ \itemindent-\leftmargin
 \let\makelabel\descriptionlabel}}
\let\enddescription\endlist

\leftmargini 2.5em
\leftmarginii 2.2em \leftmarginiii 1.87em \leftmarginiv 1.7em \leftmarginv
1em
\leftmarginvi 1em
\leftmargin\leftmargini
\labelsep .5em
\labelwidth\leftmargini\advance\labelwidth-\labelsep
\def\@listI{\leftmargin\leftmargini
	\parsep \z@
	\topsep 6pt minus 3pt
	\itemsep 2pt}
\let\@listi\@listI
\@listi 
\def\@listii{\leftmargin\leftmarginii
 \labelwidth\leftmarginii\advance\labelwidth-\labelsep
 \topsep 3pt minus 1pt
 \parsep \z@
 \itemsep 1pt}
\def\@listiii{\leftmargin\leftmarginiii
 \labelwidth\leftmarginiii\advance\labelwidth-\labelsep
 \topsep 2.5pt minus 1pt 
 \parsep \z@ \partopsep 1pt plus 0pt minus 1pt
 \itemsep 1pt}
\def\@listiv{\leftmargin\leftmarginiv
 \labelwidth\leftmarginiv\advance\labelwidth-\labelsep}
\def\@listv{\leftmargin\leftmarginv
 \labelwidth\leftmarginv\advance\labelwidth-\labelsep}
\def\@listvi{\leftmargin\leftmarginvi
 \labelwidth\leftmarginvi\advance\labelwidth-\labelsep}

% Verse, quotation, and quote environments
\def\verse{\let\\=\@centercr
   \list{}{\itemsep\z@ \itemindent -1.5em\listparindent \itemindent
   \rightmargin\leftmargin\advance\leftmargin 1.5em}\item[]}
   \let\endverse\endlist
\def\quotation{\list{}{\listparindent 1.5em
   \itemindent\listparindent
   \rightmargin\leftmargin \parsep 0pt plus 1pt}\item[]}
   \let\endquotation=\endlist
\def\quote{\list{}{\rightmargin\leftmargin}\item[]}
   \let\endquote=\endlist

\skip\@mpfootins = \skip\footins
\fboxsep = 3pt \fboxrule = .4pt

% Table of contents
\def\numberline#1{\advance\hangindent\@tempdima\hbox
		to\@tempdima{#1\hfil}\ignorespaces}
\def\@pnumwidth{6em}
\def\@tocrmarg {2.55em}
\def\@dotsep{4.5}
\def\tableofcontents{
   \setcounter{tocdepth}{4}
   \chapter*{Contents}
   \vspace{5mm}
   \@starttoc{toc}
   }
\def\l@author#1#2{\hbox to\textwidth{\hbox to2pt{}\vtop{%
	\hsize 15pc\normalfont\itshape #1\par\smallskip}\hfill}}
\def\l@part#1#2{\addpenalty{-\@highpenalty}
   \addvspace{2.25em}
   \begingroup
   \@tempdima 2em
     \parindent \z@ \rightskip \@pnumwidth
     \parfillskip -\@pnumwidth
     {\centering\large \sc
      \leavevmode
      #1\par}
      % no page numbers for part title pages, so #2 deleted
      \nobreak
     \global\@nobreaktrue
     \everypar{\global\@nobreakfalse\everypar{}}
     \endgroup}
\def\l@chapter#1#2{\ifnum\c@tocdepth<2 \relax \else%
   \addpenalty{\@secpenalty}
   \addvspace{2ex plus 1pt minus 1pt} \begingroup
   \@tempdima 1.75em \parindent \z@ \rightskip \@pnumwidth
   \parfillskip -\@pnumwidth
   \leavevmode {\raggedright\normalfont\bfseries #1}\hfil \hbox 
   to\@pnumwidth{\hss\rm #2}\par
   \nobreak \endgroup\fi}
\def\l@section#1#2{\ifnum\c@tocdepth<3 \relax\else\addpenalty{\@secpenalty}
	\begingroup\@tempdima 1.75em 
	\parindent \z@ \rightskip \@pnumwidth
	\parfillskip -\@pnumwidth 
	\leavevmode \normalfont \rmfamily
	\advance\leftskip 2.0\@tempdima \hskip -\@tempdima
	#1\hfil \hbox to\@pnumwidth{\hss #2}\par
	\endgroup\fi}
% the subsection can be % if not needed in toc
\def\l@subsection#1#2{\ifnum\c@tocdepth<4 \relax \else\addpenalty{\@secpenalty}
	\begingroup\@tempdima 2.75em 
	\parindent \z@ \rightskip \@pnumwidth \leftskip 3.5em
	\parfillskip -\@pnumwidth \labelsep 1em
	\leavevmode\normalfont \rmfamily  #1\hfil \hbox to\@pnumwidth{\hss #2}\par
	\endgroup\fi}
% end of subsection
\def\l@subsubsection#1#2{\relax}
\def\l@paragraph#1#2{\relax}
\def\l@subparagraph#1#2{\relax}


% Bibliography
% Normally references are to be cited by "[n]",
% and bibliography to be labelled correspondingly.  If cited
% by name and date explicitly, use "\unnumberedbib".
\newif\ifunnumberedbib \unnumberedbibtrue
\def\numberedbib{\numberedbibtrue}
\def\unnumberedbib{\numberedbibfalse}

\def\@cite#1{[#1]}
\def\@biblabel#1{\ifunnumberedbib{[#1]}\else\relax\fi}

\def\thebibliography#1%
   {\section*{Bibliography}
    \list{\arabic{enumi}.}{\settowidth\labelwidth{[#1]}
	\leftmargin\labelwidth
	\advance\leftmargin\labelsep
	\usecounter{enumi}}
\def\newblock{\hskip .11em plus .33em minus .07em}
\sloppy\clubpenalty4000\widowpenalty4000
\sfcode`\.=1000\relax}
\let\endthebibliography=\endlist

\def\contributorlist%
	{\chapter*{Contributors}
	\vspace{5mm}
	\addcontentsline{toc}{chapter}{List of contributors}
	\null
%	\begin{center}
\begin{description}
	}
\def\short@uthor[#1]{\authormark{#1}\@uthor}
\def\shortstar@uthor[#1]{\authormark{#1}\@uthorstar}
\def\@uthor{}
%
\def\author{%
   \@ifstar{\@authorstar}{\@author}}
\def\@author{%
   \@ifnextchar[{\short@uthor}{\@uthor}}
\def\@uthor#1{%
   \addcontentsline{toc}{author}{#1}
   \vspace*{1pc}%
   {\centering{\normalfont\bfseries#1}%
   \par}}
\def\@authorstar{%
   \@ifnextchar[{\shortstar@uthor}{\@uthorstar}}
\def\@uthorstar#1{%
   \vspace*{1pc}%
   {\centering{\normalfont\bfseries#1}%
   \par}}
\def\address#1{%
   {\centering{\normalfont\itshape#1}%
   \par}}

\def\endcontributorlist{\end{description}}
%\def\endcontributorlist{\end{center}}

% Index
\def\indexentry#1#2{\item #1\quad #2}
\newif\if@restonecol
\def\theindex{\@restonecoltrue
 \columnseprule \z@
 \columnsep 35pt\twocolumn[\chapter*{Index}]
 \markboth{Index}{Index}
 \thispagestyle{empty}\parindent\z@
 \parskip\z@ plus .3pt\relax\let\item\@idxitem}
\def\@idxitem{\par\hangindent 40pt}
\def\subitem{\par\hangindent 40pt \hspace*{20pt}}
\def\subsubitem{\par\hangindent 40pt \hspace*{30pt}}
\def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}
\def\indexspace{\par \vskip 10pt plus 5pt minus 3pt\relax}

% Footnotes
\def\footnoterule{\kern-3\p@
 \hrule width .4\columnwidth
 \kern 2.6\p@}

\long\def\@makefntext#1{\parindent 1em\noindent
 \hbox to 1.8em{\hss$^{\@thefnmark}$}#1}
\def\thanks#1{\insert\footins{\footnotesize\ignorespaces #1\strut}}

\setcounter{topnumber}{2}
\def\topfraction{.9}
\setcounter{bottomnumber}{2}
\def\bottomfraction{.9}
\setcounter{totalnumber}{3}
\def\textfraction{.1}
\def\floatpagefraction{.9}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.7}
\def\dblfloatpagefraction{.5}


% Title page
\def\titlepage{\@restonecolfalse \cleardoublepage
\c@page\z@}
\def\endtitlepage{}

\def\maketitle{\begin{titlepage}
   \let\footnotesize\small \let\footnoterule\relax
   \null
   \begin{center}
   {\message{Title ``\@title''} \Large \bf \@title \par}
   \vskip 1em \message{Author(s)}{\large \lineskip .75em
   \begin{tabular}[t]{c}\@author
   \end{tabular}\par}
   \end{center} \par
   \@thanks
   \null
   \end{titlepage}
   \setcounter{footnote}{0} \let\thanks\relax
   \gdef\@thanks{}\gdef\@author{}\gdef\@title{}\let\maketitle\relax}

\def\abstract{\message{Abstract}\small
   \begin{center}
      {\bf Abstract\vspace{-.5em}\vspace{0pt}}
   \end{center}
   \quotation}

\def\endabstract{\endquotation}

\newenvironment{ackn}{\subsection*{}\begin{quotation}\small
\message{Acknowledgments }}{\end{quotation}}

% Date
\def\today{\ifcase\month\or
   January\or February\or March\or April\or May\or June\or
   July\or August\or September\or October\or November\or December\fi
   \space\number\day, \number\year}


\def\beginappendices{\par
%\setcounter{chapter}{0}
  \setcounter{section}{0}
  \def\@chapapp{Appendix}
%\def\theequation{\Alph{section}\arabic{equation}}
  \def\theequation{\Alph{section}\arabic{equation}\alph{equationa}}
%\def\thechapter{\Alph{chapter}}\message{Appendix }
  \def\thesection{Appendix \Alph{section}}
}

\def\endappendices{
%\setcounter{chapter}{0}
  \setcounter{section}{0}
  \def\@chapapp{Chapter}
  \def\thesection{\arabic{section}}
%\def\theequation{\thesection.\arabic{equation}}
  \def\theequation{\thesection.\arabic{equation}\alph{equationa}}
%\def\thechapter{\Alph{chapter}}\message{Appendix }
}

\ps@headings \onecolumn
\pagenumbering{arabic}


% The following macros still work but are not used in multi3.
% *************************************
% Use this for chapters with one author
% *************************************
%\long\def\@chaptero[#1]#2#3#4%
%   {\refstepcounter{chapter}
%	\@chapterbotho[#1]{#2}{#3}{#4}}%#1=short running head text
%\long\def\@chapterbotho[#1]#2#3#4%#2=chapter title #3=author name
%    {\chaptermark{#1} \authormark{#3}%#4=author's affiliation
%    \addcontentsline{toc}{chapter}{\protect\numberline{\thechapter}#2}%
%    \addcontentsline{toc}{author}{#3}
%    \hbox{} \vskip 24pt
%    \begin{center}
%	{\huge \thechapter}\\[12pt] 
%       {\LARGE \rm #2} \\[12pt]
%        \bf #3\@thanks \\[6pt]
%        \it #4 \\[24pt]
%    \end{center}
%    \@afterindentfalse
%    \@afterheading}

% *******************************************************
% Use this heading for multiple authors, same affiliation
% *******************************************************
%\long\def\chapterm
%   {\global\@topnum\z@
%    \cleardoublepage
%    \thispagestyle{plain}
%    \refstepcounter{chapter}
%    \secdef\@chapterm\@schapter}
%\long\def\@chapterm[#1]#2#3#4#5%
%   {\@chapterbothm[#1]{#2}{#3}{#4}{#5}}
%\long\def\@chapterbothm[#1]#2#3#4#5%			#1=optional running head text (shortened chpter
%title)
%    {\chaptermark{#1} \authormark{#5}%			#2=chapter title
%    \addcontentsline{toc}{chapter}%
%	{\protect\numberline{\thechapter}#2}%			#3=authors' names
%    \addcontentsline{toc}{author}{#3}%			#4=authors' affiliation
%% \addtocontents{lof}{\protect\addvspace{10pt}}%	#5=authors' names for running head.If three
%% \addtocontents{lot}{\protect\addvspace{10pt}}%     or more authors, use first name and {\it et al.}
%    \hbox{} \vskip 24pt
%    \begin{center}
%	{\huge \thechapter}\\[12pt] 
%       {\LARGE \rm #2} \\[12pt]
%       \bf #3 \\[6pt]
%       \it #4 \\[24pt]
%    \end{center}
%    \@afterindentfalse
%    \@afterheading}
% ******************************************************
% Use this heading for 2 authors, different affiliations
% ******************************************************
%\long\def\chapterb
%   {\global\@topnum\z@
%    \cleardoublepage
%    \thispagestyle{plain}
%    \refstepcounter{chapter}
%    \secdef\@chapterb\@schapter}
%\long\def\@chapterb[#1]#2#3#4#5#6%
%   {\@chapterbothb[#1]{#2}{#3}{#4}{#5}{#6}}
%\long\def\@chapterbothb[#1]#2#3#4#5#6%
%    {\chaptermark{#1} \authormark{#3}
%    \addcontentsline{toc}{chapter}%
%	{\protect\numberline{\thechapter}#2}
%    \addcontentsline{toc}{author}{#3 and #5}
%%   \addtocontents{lof}{\protect\addvspace{10pt}}
%%   \addtocontents{lot}{\protect\addvspace{10pt}}
%    \hbox{} \vskip 24pt
%    \begin{center}
%	{\huge \thechapter}\\[12pt] 
%       {\LARGE \rm #2} \\[12pt]
%       \bf #3 \\[6pt]
%       \it #4 \\[12pt]
%       \bf #5 \\[6pt]
%       \it #6 \\[12pt]
%    \end{center}
%    \@afterindentfalse
%    \@afterheading}
% ******************************************************
% This heading for three authors, different affiliations
% ******************************************************
%\long\def\chapterc
%   {\global\@topnum\z@
%    \cleardoublepage
%    \thispagestyle{plain}
%    \refstepcounter{chapter}
%    \secdef\@chapterc\@schapter}
%\long\def\@chapterc[#1]#2#3#4#5#6#7#8%
%   {\@chapterbothc[#1]{#2}{#3}{#4}{#5}{#6}{#7}{#8}}
%\long\def\@chapterbothc[#1]#2#3#4#5#6#7#8%
%{   \chaptermark{#1} \authormark{#3}
%    \addcontentsline{toc}{chapter}%
%	{\protect\numberline{\thechapter}#2}
%    \addcontentsline{toc}{author}{#3, #5, and #7}
%   \addtocontents{lof}{\protect\addvspace{10pt}}
%   \addtocontents{lot}{\protect\addvspace{10pt}}
%    \hbox{} \vskip 24pt
%    \begin{center}
%	{\huge \thechapter}\\[12pt] 
%       {\LARGE \rm #2} \\[12pt]
%       \bf #3 \\[6pt]
%       \it #4 \\[12pt]
%       \bf #5 \\[6pt]
%       \it #6 \\[12pt]
%       \bf #7 \\[6pt]
%       \it #8 \\[12pt]
%    \end{center}
%    \@afterindentfalse
%    \@afterheading}
%%End of multi3.cls



