\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{macros/cft}[1995/10/30 Costas Efthimiou's cft class]
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{book}}
\ProcessOptions\relax
\LoadClassWithOptions{book}
\setlength{\textheight}{8in}
\setlength{\textwidth}{6in}
\setlength{\topmargin}{-10mm}
\setlength{\oddsidemargin}{10mm}
\setlength{\evensidemargin}{-10mm}
\usepackage{fancyhdr}
\pagestyle{fancy}
\newcommand{\MarkBoth}[1]{\markboth{\textcolor{blue}{CHAPTER \thechapter:}\ %
  {\bfseries  \textcolor{blue}{#1}}}{}}
\newcommand{\MarkRight}[1]{\markright{\textcolor{blue}{\S\thesection:\ %
  {\bfseries #1}}}}
\renewcommand{\chaptermark}[1]{\MarkBoth{#1}}
\renewcommand{\sectionmark}[1]{\MarkRight{#1}}
\fancyhf{}
\fancyhead[LE,RO]{\thepage}
\fancyhead[LO]{\rightmark}
\fancyhead[RE]{\leftmark}
\renewcommand{\headrulewidth}{3pt}
\renewcommand{\footrulewidth}{0pt}
\addtolength{\headheight}{3pt}
\fancypagestyle{plain}{%
  \fancyhead{}%
  \renewcommand{\headrulewidth}{0.5pt}%
                      }
\newcommand{\prolegomena}{\clearpage{\pagestyle{empty}\cleardoublepage}
                            \thispagestyle{empty}
  \space\vspace{-35mm}
      \noindent
      \textcolor{blue}{\rule{\textwidth}{2mm}}
      \newline\noindent
      \vspace{-8.3mm}
      \newline\noindent
      \textcolor{blue}{\rule{\textwidth}{.7mm}}
      \begin{center}
      \huge\bfseries \textcolor{blue}{PROLEGOMENA}
      \end{center}
      \par\nobreak
                            \noindent
                            \textcolor{blue}{\rule{\textwidth}{.7mm}}
                            \newline\noindent
                            \vspace{-7mm}
                            \newline\noindent
                            \textcolor{blue}{\rule{\textwidth}{2mm}}
                            \space\vspace{2cm}}
\newcommand{\newchapter}[1]{\clearpage{\pagestyle{empty}\cleardoublepage}
                            \chapter{#1}\thispagestyle{empty}
                            \vspace{-10mm}
                            \noindent
                            \textcolor{blue}{\rule{\textwidth}{.7mm}}
                            \newline\noindent
                            \vspace{-7mm}
                            \newline\noindent
                            \textcolor{blue}{\rule{\textwidth}{2mm}}
                            \space\vspace{2cm}}
\renewcommand{\@makechapterhead}[1]{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedright \normalfont
    \ifnum \c@secnumdepth >\m@ne
      \if@mainmatter
      \space\vspace{-35mm}
      \noindent
      \textcolor{blue}{\rule{\textwidth}{2mm}}
      \newline\noindent
      \vspace{-8.3mm}
      \newline\noindent
      \textcolor{blue}{\rule{\textwidth}{.7mm}}
      \begin{center}
      \huge\bfseries \textcolor{blue}{\@chapapp\space \thechapter}
      \end{center}
      \par\nobreak
      \fi
    \fi
    \interlinepenalty\@M
    \begin{center}
    \Huge \bfseries \vbox{\textcolor{blue}{#1}}
    \par\nobreak
    \end{center}
  \vspace*{30\p@}%
  }}
\usepackage{graphicx}
\usepackage[small,bf]{caption}
\usepackage{psfrag}
