%%
%% This is file `aastex.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% aasclass.dtx  (with options: `class')
%% 
%% This is a generated file;
%% altering it directly is inadvisable;
%% instead, modify the original source file.
%% 
%% Copyright notice.
%% 
%%    These files are distributed
%%    WITHOUT ANY WARRANTY; without even the implied warranty of
%%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
%% 
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}%
%%%  @LaTeX-file{
%%%     filename        = "aastex.dtx",
%%%     version         = "5.0rc3",
%%%     date            = "1999/05/23",
%%%     time            = "16:23:00 GMT",
%%%     checksum        = "4868",
%%%     author          = "Arthur Ogawa (mailto:ogawa@teleport.com)",
%%%     copyright       = "Copyright (C) 1998 American Astronomical Society,
%%%                        all rights reserved.  Copying of this file is
%%%                        authorized only if either:
%%%                        (1) you make absolutely no changes to your copy,
%%%                        including name; OR
%%%                        (2) if you do make changes, you first rename it
%%%                        to some other name.",
%%%     address         = "American Astronomical Society
%%%                        USA",
%%%     telephone       = "+1 ???",
%%%     FAX             = "",
%%%     email           = "ogawa@teleport.com",
%%%     codetable       = "ISO/ASCII",
%%%     keywords        = "latex, AAS, journal",
%%%     supported       = "yes",
%%%     abstract        = "formatter for AAS journal submissions",
%%%     docstring       = "The checksum field above generated by ltxdoc",
%%%  }
\NeedsTeXFormat{LaTeX2e}[1995/12/01]%
\ProvidesClass{aastex}%
 [1999/05/23 5.0rc3 AAS markup document class]%
\def\substitute@option#1#2{%
 \ClassWarning{aastex}{%
  Substyle #1 is deprecated in aastex.
  Using #2 instead (please fix your document).
 }\@nameuse{ds@#2}%
}%
\ClassInfo{aastex}{%
 Original \protect\LaTeX2.09 style
 by Chris Biemesderfer (chris@seagoat.com).
 Adapted to \protect\LaTeXe\space
 by A. Ogawa (ogawa@teleport.com)%
}%
\DeclareOption{10pt}{\newcommand\aas@ptsize{0}}%
\DeclareOption{11pt}{\newcommand\aas@ptsize{1}}%
\DeclareOption{12pt}{\newcommand\aas@ptsize{2}}%
\DeclareOption{landscape}{\OptionNotUsed}%
\DeclareOption{eqsecnum}{\AtEndOfClass{\eqsecnum}}%
\DeclareOption{flushrt}{\let\opt@just\just@just}%
\let\opt@just\@empty
\def\just@just{%
 \@rightskip\z@skip
 \rightskip\@rightskip
 \pretolerance=100\relax
}%
\DeclareOption{tighten}{\def\opt@tighten{\tightenlines}}%
\let\opt@tighten\@empty

\DeclareOption{manuscript}{\def\aas@substyle{manuscript}}%
\DeclareOption{preprint}{\def\aas@substyle{preprint}}%
\DeclareOption{preprint2}{\def\aas@substyle{preprint2}\@twocolumntrue}%
\DeclareOption{aasms4}{\substitute@option{aasms4}{manuscript}}%
\DeclareOption{aaspp4}{\substitute@option{aaspp4}{preprint}}%
\DeclareOption{aas2pp4}{\substitute@option{aas2pp4}{preprint2}}%
\DeclareOption{aj_pt4}{\substitute@option{aj_pt4}{preprint}}%
\DeclareOption{apjpt4}{\substitute@option{apjpt4}{preprint}}%
\def\aas@substyle{manuscript}%
\AtEndOfPackage{%
 \@nameuse{aas@\aas@substyle}%
}%
\DeclareOption{astro}{\AtBeginDocument{\load@astro}}%
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}%
\ExecuteOptions{letterpaper,oneside,onecolumn,final}%
\ProcessOptions\relax
\@namedef{aas@size@manuscript}{%
 \def\aas@ptsize{2}%
 \pass@aassize
}%
\@namedef{aas@size@preprint}{%
 \ifx\undefined\aas@ptsize
  \expandafter\@firstoftwo\else\expandafter\@secondoftwo
 \fi
 {\def\aas@ptsize{1}}{}%
 \pass@aassize
}%
\@namedef{aas@size@preprint2}{%
 \ifx\undefined\aas@ptsize
  \expandafter\@firstoftwo\else\expandafter\@secondoftwo
 \fi
 {\def\aas@ptsize{0}}{}%
 \pass@aassize
}%
\def\pass@aassize{%
 \expandafter\PassOptionsToClass
 \expandafter{%
 \expandafter1\aas@ptsize pt}{article}%
}%
\@nameuse{aas@size@\aas@substyle}%
\LoadClass{article}[1995/12/01]%
\RequirePackage{latexsym}%
\RequirePackage{graphicx}%
\RequirePackage{amssymb}%
\RequirePackage{natbib}%
\newcommand{\bibstyle@aas}{\bibpunct{(}{)}{;}{a}{}{,}}%
\@citestyle{aas}%
\RequirePackage{verbatim}%
\def\@to{to}%
\newcommand\ulap[1]{\vbox\@to\z@{{\vss#1}}}%
\newcommand\dlap[1]{\vbox\@to\z@{{#1\vss}}}%
\newcommand\let@environment[2]{%
 \expandafter\let
 \csname#1\expandafter\endcsname\csname#2\endcsname
 \expandafter\let
 \csname end#1\expandafter\endcsname\csname end#2\endcsname
 }%
\newcommand\say[1]{\typeout{<\noexpand#1=\meaning#1>}}%
\newcommand\saythe[1]{\typeout{<\noexpand#1=\the#1>}}%
\newcommand\tracingplain{%
 \tracingonline\z@\tracingcommands\z@\tracingstats\z@
 \tracingpages\z@\tracingoutput\z@\tracinglostchars\@ne
 \tracingmacros\z@\tracingparagraphs\z@\tracingrestores\z@
 \showboxbreadth5\showboxdepth3\relax %\errorstopmode
 }%
\newcommand\traceoutput{%
 \appdef\@resetactivechars{\showoutput}%
}%
\newcommand\nohyphenation{\kern\z@}%
\newcommand\offhyphenation{%
 \lefthyphenmin\maxdimen\emergencystretch8\p@
}%
\def\substitute@command#1#2{%
 \ClassWarning{aastex}{%
  Command \protect#1\space is deprecated in aastex.
  Using \protect#2\space instead (please fix your document).
 }%
 #2%
}%
\def\remove@command#1{%
 \ClassWarning{aastex}{%
  Command \protect#1\space is deprecated in aastex.
  Please remove it from your document%
 }%
}%
\def\@provide#1{%Implicit #2
 \@ifxundefined#1{\def#1}{\def\@tempa}%
}%
\def\prepdef#1#2{%
 \@ifxundefined#1{\toks@{}}{\toks@\expandafter{#1}}%
 \toks@ii{#2}%
 \edef#1{\the\toks@ii\the\toks@}%
}%
\def\appdef#1#2{%
 \@ifxundefined#1{\toks@{}}{\toks@\expandafter{#1}}%
 \toks@ii{#2}%
 \edef#1{\the\toks@\the\toks@ii}%
}%
\def\appgdef#1#2{%
 \@ifxundefined#1{\toks@{}}{\toks@\expandafter{#1}}%
 \toks@ii{#2}%
 \xdef#1{\the\toks@\the\toks@ii}%
}%
\toksdef\toks@ii=\tw@
\long\def\@ifxundefined#1{\@ifx{\undefined#1}}%
\def\@boolean#1#2{%
  \long\def#1{%
    #2% \if<something>
      \expandafter\boolean@true
    \else
      \expandafter\boolean@false
    \fi
  }%
}%
\def\@boole@def#1#{\@boolean{#1}}% Implicit #2
\@boole@def\@ifx#1{\ifx#1}%
\@boole@def\@ifx@empty#1{\ifx\@empty#1}%
\@boole@def\@ifnum#1{\ifnum#1}%
\@boole@def\@ifdim#1{\ifdim#1}%
\@boole@def\@ifvoid#1{\ifvoid#1}%
\long\def\boolean@true#1#2{#1}%
\long\def\boolean@false#1#2{#2}%
\renewcommand\addpenalty[1]{%
  \ifvmode
    \if@minipage
    \else
      \if@nobreak
      \else
        \ifinner
          \@tempskipa\lastskip \unskip
          \@tempcnta\lastpenalty \unpenalty
          \ifnum#1<\@tempcnta
            \penalty#1\relax
          \else
            \penalty\@tempcnta
          \fi
          \vskip\@tempskipa
        \else
          \ifdim\lastskip=\z@
            \penalty#1\relax
          \else
            \@tempskipb\lastskip
            \vskip-\lastskip
            \penalty#1%
            \vskip\@tempskipb
          \fi
        \fi
      \fi
    \fi
  \else
    \@noitemerr
  \fi
}%
\renewcommand\addvspace[1]{%
  \ifvmode
    \if@minipage
    \else
      \ifinner
        \@tempskipa\lastskip \unskip
        \ifdim\@tempskipa=\z@
          \vskip#1\relax
        \else
          \@tempskipb#1\relax
          \ifdim\@tempskipa<\@tempskipb
            \vskip\@tempskipb
          \else
            \ifdim\@tempskipb<\z@
              \ifdim\@tempskipa<\z@
                \vskip\@tempskipa
              \else
                \advance\@tempskipb\@tempskipa
                \vskip\@tempskipb
              \fi
            \else
              \vskip\@tempskipa
            \fi
          \fi
        \fi
      \else
        \ifdim\lastskip=\z@
          \vskip#1\relax
        \else
          \@tempskipb#1\relax
          \@xaddvskip
        \fi
      \fi
    \fi
  \else
    \@noitemerr
  \fi
}%
\newcommand\maketitle@page{%
 \maketitle@disarm
 \begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \let \footnote \thanks
  \@maketitle
  \@thanks
  \vfil\null
 \end{titlepage}%
 \after@maketitle
}%
\newcommand\maketitle@runin{%
  \par
  \maketitle@disarm
  \begingroup
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{%
     \parindent 1em\noindent
     \hb@xt@1.8em{%
      \hss\@textsuperscript{\normalfont\@thefnmark}%
     }%
     ##1%
    }%
    \if@twocolumn
      \@ifnum{\col@number=\@ne}{%
        \global\let\@title@footnote@text\@empty
        \twocolumn[%
         \let\@footnotetext\@title@footnotetext
         \@maketitle
        ]%
        \@title@footnote@text
      }{%
        \@maketitle
      }%
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}%
    \@thanks
  \endgroup
  \after@maketitle
}%
\def\after@maketitle{%
 \global\let\thanks\@gobble
 \global\let\maketitle\relax
 \global\let\@maketitle\relax
 \global\let\@thanks\@empty
 \global\let\@author\@empty
 \global\let\@date\@empty
 \global\let\@title\@empty
 \global\let\title\relax
 \global\let\author\relax
 \global\let\date\relax
 \global\let\and\relax
 \global\let\email\@text@email
}%
\AtEndOfClass{%
 \if@titlepage
  \let\maketitle\maketitle@page
 \else
  \let\maketitle\maketitle@runin
 \fi
}%
\def\open@footnotetext{%
 \insert\footins\bgroup % \egroup in \close@footnotetext
  \interlinepenalty\interfootnotelinepenalty
  \splittopskip\footnotesep
  \splitmaxdepth\dp\strutbox
  \floatingpenalty \@MM
  \reset@font\footnote@size
  \hsize\columnwidth
  \@parboxrestore
}%
\def\close@footnotetext#1{%
  \color@begingroup
   \@makefntext{%
    \rule\z@\footnotesep\ignorespaces
    #1\@finalstrut\strutbox
   }%
  \color@endgroup
 \egroup
}%
\def\@footnotetext{% Implict #1
 \open@footnotetext
  \set@footnotetext{p@footnote}%
}%
\def\@mpfootnotetext{% Implict #1
 \global\setbox\@mpfootins\vbox\bgroup % \egroup in \set@footnotetext
  \unvbox\@mpfootins
  \set@footnotetext{p@mpfootnote}%
}%
\long\def\set@footnotetext#1{%Implicit #2
  \protected@edef\@currentlabel{%
   \csname #1\endcsname\@thefnmark
  }%
 \close@footnotetext
}%
\def\@title@footnotetext#1{%
 \protected@edef\@tempa{\csname p@footnote\endcsname\@thefnmark}%
 \expandafter\appgdef
 \expandafter\@title@footnote@text
 \expandafter{%
 \expandafter\insert@footnotetext
 \expandafter{\@tempa}{#1}}%
}%
\def\insert@footnotetext#1{%Implicit #2
 \open@footnotetext
  \def\@thefnmark{#1}%
  \def\@currentlabel{#1}%
 \close@footnotetext
}%
\AtBeginDocument{%
 \ifx\footnote@size\undefined
  \let\footnote@size\footnotesize
 \fi
}%
\long\def\eqnarray@broken{%
 \stepcounter{equation}\def\@currentlabel{\p@equation\theequation}%
 \global\@eqnswtrue\m@th\global\@eqcnt\z@
 \tabskip\mathindent
 \let\\=\@eqncr
 \setlength\abovedisplayskip{\topsep}%
 \ifvmode\addtolength\abovedisplayskip{\partopsep}\fi
 \addtolength\abovedisplayskip{\parskip}%
 \setlength\belowdisplayskip{\abovedisplayskip}%
 \setlength\belowdisplayshortskip{\abovedisplayskip}%
 \setlength\abovedisplayshortskip{\abovedisplayskip}%
 $$%
 \everycr{}%
 \halign to\linewidth\bgroup
  \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
  &\global\@eqcnt\@ne
   \hskip\tw@\arraycolsep
   \hfil${##}$\hfil
  &\global\@eqcnt\tw@
   \hskip\tw@\arraycolsep
   $\displaystyle{##}$\hfil\tabskip\@centering
  &\global\@eqcnt\thr@@\hb@xt@\z@\bgroup\hss##\egroup
   \tabskip\z@skip
  \cr
}%
\long\def\eqnarray@fleqn@fixed{%
 \stepcounter{equation}\def\@currentlabel{\p@equation\theequation}%
 \global\@eqnswtrue\m@th\global\@eqcnt\z@
 \tabskip\mathindent
 \let\\=\@eqncr
 \setlength\abovedisplayskip{\topsep}%
 \ifvmode\addtolength\abovedisplayskip{\partopsep}\fi
 \addtolength\abovedisplayskip{\parskip}%
 \setlength\belowdisplayskip{\abovedisplayskip}%
 \setlength\belowdisplayshortskip{\abovedisplayskip}%
 \setlength\abovedisplayshortskip{\abovedisplayskip}%
 $$%
 \everycr{}%
 \halign\@to\linewidth\bgroup
  \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
  &\global\@eqcnt\@ne
   \hskip\tw@\eqncolsep
   \hfil${{}##{}}$\hfil
  &\global\@eqcnt\tw@
   \hskip\tw@\eqncolsep
   $\displaystyle{##}$\hfil\tabskip\@centering
  &\global\@eqcnt\thr@@\hb@xt@\z@\bgroup\hss##\egroup
   \tabskip\z@skip
  \cr
}%
\ifx\eqnarray\eqnarray@broken
 \ClassWarningNoLine{aastex}{Repairing broken {eqnarray} definition}%
 \let\eqnarray\eqnarray@fleqn@fixed
\fi
\let\eqnarray@broken\relax
\let\eqnarray@fleqn@fixed\relax
\def\@startsection#1#2#3#4#5#6{%
 \@startsection@hook
 \if@noskipsec \leavevmode \fi
 \par
 \@tempskipa #4\relax
 \@afterindenttrue
 \ifdim \@tempskipa <\z@
  \@tempskipa -\@tempskipa \@afterindentfalse
 \fi
 \if@nobreak
  \everypar{}%
 \else
  \addpenalty\@secpenalty\addvspace\@tempskipa
 \fi
 \@ifstar
  {\@ssect{#3}{#4}{#5}{#6}}%
  {\@dblarg{\@sect{#1}{#2}{#3}{#4}{#5}{#6}}}%
}%
\def\@startsection@hook{}%
\def\@sect#1#2#3#4#5#6[#7]#8{%
 \ifnum #2>\c@secnumdepth
  \let\@svsec\@empty
 \else
  \refstepcounter{#1}%
  \protected@edef\@svsec{\@seccntformat{#1}\relax}%
 \fi
 \@tempskipa #5\relax
 \ifdim \@tempskipa>\z@
  \begingroup
   \section@centering
   #6{%
    \@hangfrom{\hskip #3\relax\@svsec}%
    \interlinepenalty \@M\sec@upcase{#8}\@@par
   }%
  \endgroup
  \csname #1mark\endcsname{#7}%
  \addcontentsline{toc}{#1}{%
   \ifnum #2>\c@secnumdepth \else
    \protect\numberline{\csname the#1\endcsname}%
   \fi
   #7%
  }%
 \else
  \def\@svsechd{%
   #6{%
    \hskip#3\relax\@svsec
    \sec@upcase{#8}%
   }%
   \csname #1mark\endcsname{#7}%
   \addcontentsline{toc}{#1}{%
    \ifnum #2>\c@secnumdepth
    \else
     \protect\numberline{\csname the#1\endcsname}%
    \fi
    #7%
   }%
  }%
 \fi
 \@xsect{#5}%
}%
\def\@ssect#1#2#3#4#5{%
 \@tempskipa #3\relax
 \ifdim \@tempskipa>\z@
  \begingroup
   \section@centering
   #4{%
    \@hangfrom{\hskip #1}%
    \interlinepenalty \@M\sec@upcase{#5}\@@par
   }%
  \endgroup
 \else
  \def\@svsechd{#4{\hskip #1\relax \sec@upcase{#5}}}%
 \fi
 \@xsect{#3}%
}%
\def\@seccntformat#1{\csname the#1\endcsname.\quad}%
\def\section@centering{\centering}%
\def\sec@upcase#1{\relax{#1}}%
\def\@citex[#1]#2{%
 \let\@citea\@empty
 \@cite{%
  \@for\@citeb:=#2\do{%
   \@citea
   \def\@citea{,\penalty\@m\ }%
   \edef\@citeb{\expandafter\@firstofone\@citeb\@empty}%
   \if@filesw\immediate\write\@auxout{\string\citation{\@citeb}}\fi
   \@ifundefined{b@\@citeb}{%
    \G@refundefinedtrue
    \@latex@warning{%
     Citation `\@citeb' on page \thepage \space undefined%
    }%
   }{%
     \csname b@\@citeb\endcsname
   }%
  }%
 }{#1}%
}%
\def\revtex@ver{5.0}%
\def\revtex@date{25 Sep 98}%
\def\revtex@org{AAS}%
\def\revtex@jnl{AAS}%
\def\revtex@genre{manuscript}%
\def\class@typeout{%
 \typeout{%
  \revtex@org\space
  \revtex@genre\space substyle, v\revtex@ver\space <\revtex@date>.%
 }%
}%
\def\class@typeout@jnl{%
 \typeout{%
  \revtex@org\space
  \revtex@jnl\space
  \revtex@genre\space substyle, v\revtex@ver\space <\revtex@date>.%
 }%
}%
\AtBeginDocument{%
 \class@typeout
}%
\def\revtex@pageid{%
 \xdef\@thefnmark{\null}%
 \@footnotetext{%
  This \revtex@genre\space was prepared with the
  \revtex@org\space \LaTeX\ macros v\revtex@ver.%
 }%
}%
\def\ps@plaintop{%
 \let\@mkboth\@gobbletwo
 \def\@oddfoot{}%
 \def\@oddhead{\rmfamily\hfil--\space\thepage\space--\hfil}%
 \def\@evenfoot{}%
 \let\@evenhead\@oddhead
}%
\setlength\textwidth{6.5in}%
\setlength\textheight{8.4in}%
\setlength\headheight{.15in}%
 \setlength\marginparsep {10\p@}%
 \setlength\marginparpush{5\p@}%
 \setlength\oddsidemargin   {0in}%
 \setlength\evensidemargin  {0in}%
 \setlength\marginparwidth  {0in}%
 \setlength\topmargin{0in}%
\setlength\lineskip{1\p@}%
\setlength\normallineskip{1\p@}%
\def\@doubleleading{1.6}%
\def\@tightleading{1.1}%
\renewcommand\baselinestretch{\@tightleading}%
\newcommand\tighten{\def\baselinestretch{\@tightleading}}%
\newcommand\tightenlines{\tighten}%
\newcommand\singlespace{%
 \def\baselinestretch{\@tightleading}%
 \normalsize
}%
\newcommand\doublespace{%
 \def\baselinestretch{\@doubleleading}%
 \normalsize
}%
\def\singlespace@apj{%
 \def\baselinestretch{\@tightleading}%
 \def\arraystretch{\@tightleading}%
 \normalsize
}%
\def\doublespace@apj{%
 \def\baselinestretch@apj{\@doubleleading}%
 \def\arraystretch{\@doubleleading}%
 \normalsize
}%
\setlength\parskip{1.5ex}%
\setlength\parindent{2em}%
\setlength\smallskipamount{3\p@\@plus1\p@\@minus1\p@}%
\setlength\medskipamount{6\p@\@plus2\p@\@minus2\p@}%
\setlength\bigskipamount{12\p@\@plus4\p@\@minus4\p@}%
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\newcommand\ptlandscape{%
 \setlength\textwidth{9in}%
 \setlength\textheight{6.5in}%
 \setlength\pt@width{\textwidth}%
 \setlength\hoffset{0.0in}%
 \setlength\voffset{-0.25in}%
}%
\def\eqsecnum{%
 \@addtoreset{equation}{section}%
 \def\theequation{%
 %\mbox{\normalsize\arabic{section}-\arabic{equation}}% Wrong!
  \arabic{section}-\arabic{equation}%
 }%
}%
\def\@journalname{The Astropolitical Journal}%
\def\cpr@holder{American Astronomical Society}%
\newcommand\received[1]{\gdef\@recvdate{#1}}%
\newcommand\accepted[1]{\gdef\@accptdate{#1}}%
\newcommand\revised[1]{\gdef\@revisedate{#1}}%
\newcommand\journalid[2]{\gdef\@jourvol{#1}\gdef\@jourdate{#2}}%
\newcommand\articleid[2]{\gdef\@startpage{#1}\gdef\@finishpage{#2}}%
\newcommand\paperid[1]{\gdef\@paperid{#1}}%
\newcommand\ccc[1]{\gdef\CCC@code{#1}}%
\AtEndOfClass{%
 \@provide\@recvdate{}%
 \@provide\@accptdate{}%
 \@provide\@revisedate{}%
 \@provide\@jourvol{}%
 \@provide\@jourdate{}%
 \@provide\@startpage{}%
 \@provide\@finishpage{}%
 \@provide\@paperid{MS-0001-SAMP}%
 \@provide\CCC@code{000-00\$75.95-CDB}%
}%
\newcommand\cpright[2]{%
 \global\expandafter\let\expandafter\cpr@type\csname cpr@#1\endcsname
 \gdef\cpr@year{#2}%
 \typeout{`#1' copyright \cpr@year.}%
}%
\def\cpr@AAS{Copyright \cpr@year\space by the \cpr@holder.}%
\def\cpr@PD{This article is in the public domain.}%
\def\cpr@Crown{Crown copyright \cpr@year\space by the \cpr@holder.}%
\def\cpr@none{No copyright is claimed for this article.}%
\def\cpr@ASP{Copyright \cpr@year\space by the ASP.}%
\def\cpr@year{\number\year}%
\def\@slug{%
 \par
 \noindent\cpr@type\par
 \noindent Manuscript number \@paperid.\par
 \noindent\CCC@code\par
}%
\newcommand\lefthead{\substitute@command\lefthead\shorttitle}%
\newcommand\righthead{\substitute@command\righthead\shortauthors}%
\newcommand\shorttitle[1]{\gdef\@versohead{#1}}%
\newcommand\shortauthors[1]{\gdef\@rectohead{#1}}%
\shorttitle{\relax}%
\shortauthors{\relax}%
\def\@runheads{%
 \@tempcnta\c@page
 \@whilenum\@tempcnta>\z@\do{%
  \vskip 3ex
  \hbox\@to30pc{%
   \small
   \expandafter\uppercase\expandafter{\@versohead}:
   \expandafter\uppercase\expandafter{\@rectohead}\hfil
  }%
  \advance\@tempcnta\m@ne
 }%
}%
\newcommand\slugcomment[1]{\gdef\slug@comment{#1}}%
\slugcomment{}%
\newdimen\@slugcmmntwidth
\long\def\@makeslugcmmnt@mss{%
 \@ifx@empty\slug@comment{\relax}{%
  \vskip 5ex
  \sbox\@tempboxa{\slug@comment}%
  \@ifdim{\wd\@tempboxa >\@slugcmmntwidth}{%
   \hbox\@to\textwidth{%
    \hss
    \parbox\@slugcmmntwidth\slug@comment
   }%
  }{%
   \hbox\@to\textwidth{\hfil\box\@tempboxa\hfil}%
  }%
 }%
}%
\long\def\@makeslugcmmnt@ppt{%
 \@ifx@empty\slug@comment{\relax}{%
  \sbox\@tempboxa{\slug@comment}%
  \@ifdim{\wd\@tempboxa >\@slugcmmntwidth}{%
   \hbox\@to\textwidth{%
    \hss
    \parbox\@slugcmmntwidth\slug@comment
   }%
  }{%
   \hbox\@to\textwidth{\hfil\box\@tempboxa}%
  }%
  \vskip 2ex
 }%
}%
\def\@rcvaccrule{\vrule\@width1.75in\@height0.5pt\@depth\z@}%
\def\@dates{%
 \@ifx@empty\@recvdate{}{%
  \@ifx@empty\@accptdate{}{%
   {Received}\space\@recvdate;
   \hspace{1.5em}%
   {accepted}\space\@accptdate
  }%
 }%
}%
\def\@dates@pptt{%
 \@ifx@empty\@recvdate{}{%
  \@ifx@empty\@accptdate{}{%
   {%
    \center
     \@ifnum{\col@number=\tw@}{\small}{\normalsize}%
     {\itshape Received}\space
     \@recvdate
     \@ifnum{\col@number=\tw@}{\\[.5ex]}{\hspace{1.5em}}%
     {\itshape accepted}\space
     \@accptdate
    \endcenter
   }%
  }%
 }%
}%
\def\sluginfo@mss{%
 {%
  \addpenalty{\@M}%
  \addvspace{6\p@}%
  \centering
  \@dates
  \@makeslugcmmnt
  \par
  \addvspace{6\p@}%
 }%
}%
\newcommand\sluginfo{%
 {%
  \addpenalty{\@M}%
  \addvspace{6\p@}%
  \centering
  \@dates
  \par
  \addvspace{6\p@}%
 }%
}%
\let\dates=\sluginfo
\renewenvironment{abstract}{%
 \global\setbox\abstract@box\vtop\bgroup
  \columnwidth\textwidth\hsize\columnwidth\linewidth\hsize
  \normalsize
  \color@begingroup
  \@parboxrestore
  \@setminipage
  \quotation
}{%
  \par
  \endquotation
  \removelastskip
  \vskip-\prevdepth
  \color@endgroup
 \egroup
}%
\newbox\abstract@box
\def\abstractname{ABSTRACT}%
\def\@abstract@mss{%
 \sluginfo
 \clearpage
 \@ifvoid\abstract@box{}{%
  \begin{center}\bfseries\abstractname\end{center}%
  \contribute@box\abstract@box
 }%
}%
\def\contribute@box#1{%
 \dimen@\ht#1%
 \leavevmode\hbox{\vrule\@height\ht#1\@width\z@}\par
 \nointerlineskip\nobreak\kern-\ht#1\box#1\prevdepth\z@
}%
\def\@abstract@ppt{%
 \@ifvoid\abstract@box{}{%
  \begin{center}\bfseries\abstractname\end{center}%
  \contribute@box\abstract@box
 }%
}%
\def\@abstract@pptt{%
 \@ifvoid\abstract@box{}{%
  \@ifnum{\col@number=\tw@}{%
   \section*{Abstract}%
  }{%
   \vspace{3em}%
   \begin{center}%
    \large
    \bfseries\abstractname\vspace{-.5em}\vspace{\z@}%
   \end{center}%
  }%
  \contribute@box\abstract@box
 }%
}%
\def\title#1{\appdef\@title{\make@title{#1}}}%
\def\author#1{\appdef\@author{\make@author{#1}}}%
\def\authoraddr{\substitute@command\authoraddr\affil}%
\def\email#1{\appdef\@author{\make@authoremail{#1}}}%
\def\affil#1{\appdef\@author{\make@affil{#1}}}%
\def\altaffilmark#1{\appdef\@author{\make@altaffilmark{#1}}}%
\def\altaffiltext#1#2{\appdef\@author{\make@altaffiltext{#1}{#2}}}%
\def\and{\appdef\@author{\make@and}}%
\let\@title\@empty
\let\@author\@empty
\let\@date\@empty
\def\@maketitle{%
 \newpage
 \begingroup
  \let\footnote\thanks
  \let\email\make@authoremail
  \let\affil\make@affil
  \let\altaffilmark\make@altaffilmark
  \let\altaffiltext\make@altaffiltext
  \let\and\make@and
  \@title
  \@author
  \@date
  \par
  \@abstract
  \@ifxundefined\keyword@list{}{%
   \expandafter\@keywords
   \expandafter{\keyword@list}%
  }%
 \endgroup
}%
\def\make@title@mss#1{%
 {%
  \def\baselinestretch{\@tightleading}%
  \center\large\bfseries{#1}\endcenter
 }%
 \thispagestyle{empty}%
}%
\def\make@title@ppt#1{%
 \@makeslugcmmnt
 {\center\large\bfseries{#1}\endcenter}%
 \thispagestyle{empty}%
}%
\def\make@title@pptt#1{%
 {%
  \center
  \@ifnum{\col@number=\tw@}{\large}{\Large}%
  \bfseries
  #1%
  \endcenter
 }%
}%
\def\make@author#1{%
 {\topsep\z@\center\normalsize#1\endcenter}%
}%
\def\make@author@pptt#1{%
 {\topsep\z@
  \center
  \@ifnum{\col@number=\tw@}{\normalsize}{\vspace{4ex}\large}%
  #1%
  \endcenter
 }%
}%
\let\make@authoraddr=\@gobble
\let\make@authoremail=\@gobble
\newcommand\make@affil[1]{%
 \vspace*{-2.5ex}%
 {\topsep\z@\center#1\endcenter}%
}%
\def\make@affil@pptt#1{%
 \vspace*{-0.8ex}%
 {%
  \topsep\z@
  \center
   \@ifnum{\col@number=\tw@}{\small}{\normalsize}%
   \itshape
   #1%
  \endcenter
 }%
}%
\newcommand\make@altaffilmark[1]{$^{#1}$}%
\newcommand\make@altaffiltext[2]{%
 \footnotetext[#1]{#2}\stepcounter{footnote}%
}%
\def\make@and{\vspace*{-0.5ex}{\topsep\z@\center and\endcenter}}%
\newcommand\keywords{\appdef\keyword@list}%
\let\keyword@list\undefined
\def\@keywords#1{%
 \vspace*{-.7ex}%
 \@ifnum{\col@number=\tw@}{%
  \noindent
  {{\itshape\@keywordtext:\/}\space\@kwds{#1}}%
 }{%
  {%
   \quote
   {\itshape\@keywordtext:\/}\space
   \@kwds{#1}%
   \endquote
  }%
 }%
}%
\def\@keywords@pptt#1{%
 \vspace*{-.7ex}%
 \@ifnum{\col@number=\tw@}{%
  \noindent
  {%
   \small
   {\itshape\@keywordtext:\/}\space
   \@kwds{#1}%
  }%
 }{%
  {%
   \quote
   \small
   {\itshape\@keywordtext:\/}\space
   \@kwds{#1}%
   \endquote
  }%
 }%
}%
\let\subjectheadings=\keywords
\def\@keywordtext{Subject headings}%
\def\@keyworddelim{---}%
\def\@kwds@jnl#1{%
 \def\@kwddlm{}%
 \@for\@kwd:=#1\do{%
  \@kwddlm
  \def\@kwddlm{\space\@keyworddelim\penalty\@m\space}%
  {\@kwd}%
 }%
}%
\def\@kwds#1{#1\relax}%
\AtBeginDocument{%
 \everypar{%
  \everypar@hook
 }%
}%
\def\everypar@hook{%
 \setbox\z@\lastbox\par\removelastskip
 \everypar{}%
 \maketitle@trigger
 \leavevmode
}%
\def\@startsection@hook{\maketitle@trigger}%
\prepdef\tableofcontents{\listof@hook}%
\prepdef\listoffigures{\listof@hook}%
\prepdef\listoftables{\listof@hook}%
\def\listof@hook{\maketitle@trigger}%
\def\maketitle@disarm{%
 \global\let\maketitle@trigger\relax
 \global\let\@startsection@hook\@empty
 \global\let\listof@hook\@empty
 \global\let\everypar@hook\@empty
}%
\def\maketitle@trigger{%
 \maketitle
}%
\setlength{\skip\footins}{4ex\@plus1ex\@minus.5ex}%
\setlength\footnotesep{3ex}%
\long\def\@makefntext@pptt#1{%
 \noindent
 \hbox\@to\z@{\hss$^{\@thefnmark}$}%
 #1%
}%
\newcounter{editornote}%
\def\theeditornote{{\rmfamily E}\arabic{editornote}}%
\newcommand\notetoeditor[1]{%
 \stepcounter{editornote}%
 \begingroup
  \def\protect{\noexpand\protect\noexpand}%
  \xdef\@thefnmark{\theeditornote}%
 \endgroup
 \@footnotemark\@footnotetext{NOTE TO EDITOR: #1}%
}%
\renewcommand\section{%
 \@startsection{section}{1}%
  {\z@}{5ex\@plus.5ex}{1ex\@plus.2ex}{\normalsize\bfseries}%
}%
\def\thesection{\@arabic{\c@section}}%
\def\clear@section@page{}%
\renewcommand\subsection{%
 \@startsection{subsection}{2}%
  {\z@}{5ex\@plus.5ex}{1ex\@plus.2ex}{\normalsize\bfseries}%
}%
\def\thesubsection{\thesection.\@arabic{\c@subsection}}%
\renewcommand\subsubsection{%
 \@startsection{subsubsection}{3}%
  {\z@}{5ex\@plus.5ex}{1ex\@plus.2ex}{\normalsize\itshape}%
}%
\def\thesubsubsection{\thesubsection.\@arabic{\c@subsubsection}}%
\newcommand\subsubsubsection{%
 \@startsection{subsubsection}{4}%
  {\z@}{-15\p@\@plus-5\p@\@minus-2\p@}{5\p@}{\normalfont\normalsize\itshape}%
}%
\def\thesubsubsubsection{\thesubsubsection.\@arabic{\c@subsubsubsection}}%
\def\theparagraph{\thesubsubsection.\@arabic{\c@paragraph}}%
\newcommand\acknowledgments{\vskip 3ex\@plus.8ex\@minus.4ex}%
\let\acknowledgements=\acknowledgments
\renewcommand\appendix{%
 \par
 \if@twocolumn\@restonecoltrue\onecolumn\fi
 \setcounter{section}{\z@}%
 \setcounter{subsection}{\z@}%
 \setcounter{equation}{\z@}%
 \def\thesection{\Alph{section}}%
 \def\theequation{%
 %\hbox{\normalsize\Alph{section}\arabic{equation}}%
  \thesection\arabic{equation}%
 }%
 \@addtoreset{equation}{section}%
 \appendix@figtab@defs
 \def\section{%
  \@startsection
   {section}{1}{\z@}%
   {5ex\@plus.5ex}{1ex\@plus.2ex}{\normalsize\bfseries}%
   }%
}%
\let\appendix@figtab@defs\@empty
\def\appendix@figtab@defs@pptt{}%
\newcounter{cureqno}%
\newenvironment{mathletters}{%
 \refstepcounter{equation}%
 \setcounter{cureqno}{\value{equation}}%
 \let\@curtheeqn\theequation
 \edef\@tempa{\theequation}%
 \expandafter\def
 \expandafter\theequation
 \expandafter{\@tempa\alph{equation}}%
 \setcounter{equation}{0}%
}{%
 \let\theequation\@curtheeqn
 \setcounter{equation}{\value{cureqno}}%
}%
\newcommand\eqnum[1]{%
 \def\theequation{#1}%
 \let\@currentlabel\theequation
 \addtocounter{equation}{\m@ne}%
}%
\renewenvironment{thebibliography}[1]{%
 \clear@thebibliography@page
 \subsection*{REFERENCES}%
 \thebib@list
 \def\refpar{\relax}%
 \def\newblock{\hskip .11em\@plus.33em\@minus.07em}%
 \sloppy
 \clubpenalty4000
 \widowpenalty4000
 \sfcode`\.=1000\relax
}{%
 \endlist
 \revtex@pageid
}%
\def\clear@thebibliography@page{}%
\def\thebib@list{%
 \list{\null}{%
  \leftmargin 3em\labelwidth\z@\labelsep\z@\itemindent-\leftmargin
  \usecounter{enumi}%
 }%
}%
\def\thebib@list@pptt{%
 \list{\null}{%
  \leftmargin 1.2em\labelwidth\z@\labelsep\z@\itemindent-\leftmargin
  \usecounter{enumi}%
 }%
}%
\newenvironment{references}{%
 \clear@thebibliography@page
 \subsection*{REFERENCES}%
 \bgroup
  \setlength\parindent\z@
  \setlength\parskip\itemsep
  \let\refpar\references@refpar
}{%
  \refpar
 \egroup
 \revtex@pageid
}%
\def\references@refpar@mss{%
 \par\setlength\hangindent{3em}\hangafter\@ne
}%
\def\references@refpar@pptt{%
 \par\setlength\hangindent{1.2em}\hangafter\@ne
}%
\let\references@refpar\references@refpar@mss
\newcommand\reference{%
 \@ifnextchar\bgroup{\@reference}{%
  \@latexerr{Missing key on reference command}{%
   Each reference command should have a key corresponding
   to a \protect\markcite\space somewhere in the text
  }%
 }%
}%
\def\@reference#1{\relax\refpar}%
\newcommand\markcite[1]{\remove@command\markcite}%
 \def\@biblabel#1{\relax}%
 \def\@cite#1#2{#1\if@tempswa , #2\fi}%
\setcounter{topnumber}{7}%
\newcommand\tablenotemark[1]{%
 \rlap{$^{\mathrm #1}$}%
}%
\def\@tablenotetext#1#2{%
 \vspace{.5ex}%
 {\noindent\llap{$^{#1}$}#2\par}%
}%
\def\@tablenotes#1{%
 \par
 \vspace{4.5ex}\footnoterule\vspace{.5ex}%
 {\footnotesize#1}%
}%
\def\@tablenotes@pptt#1{%
 \par
 \vspace{3.2ex}\footnoterule\vspace{.4ex}%
 {\footnotesize#1}%
}%
\AtBeginDocument{%
 \let\tblnote@list\@empty
}%
\newcommand\tablenotetext[2]{%
 \appgdef\tblnote@list{\@tablenotetext{#1}{#2}}%
}%
\def\spew@tblnotes{%
 \@ifx@empty\tblnote@list{}{%
  \@tablenotes{\tblnote@list}%
  \global\let\tblnote@list\@empty
 }%
}%
\prepdef\endtable{\spew@tblnotes}%
\expandafter\prepdef\csname endtable*\endcsname{\spew@tblnotes}%
\let\tableline=\hline
\long\def\@makecaption#1#2{\vskip 2ex\noindent#1\ #2\par}%
\newcommand\tablenum[1]{%
 \def\thetable{#1}%
 \let\@currentlabel\thetable
 \addtocounter{table}{\m@ne}%
}%
\newcommand\figurenum[1]{%
 \def\thefigure{#1}%
 \let\@currentlabel\thefigure
 \addtocounter{figure}{\m@ne}%
}%
\newcommand\placetable{\@place@float{TABLE}}%
\newcommand\placefigure{\@place@float{FIGURE}}%
\newcommand\placeplate{\@place@float{PLATE}}%
\def\@place@float#1#2{%
 \vspace{0.5ex}%
 \begin{center}EDITOR: PLACE #1 \ref{#2} HERE.\end{center}%
 \vspace{0.5ex}%
}%
\newcommand\figcaption{\@testopt{\@xfigcaption}{}}%
\def\@xfigcaption[#1]#2{{\def\@captype{figure}\caption{#2}}}%
\newcommand\dummytable{\refstepcounter{table}}%
\newbox\pt@box
\newdimen\pt@width
\newcount\pt@line
\newcount\pt@column
\newcount\pt@nlines
\newcount\pt@ncol
\newcount\pt@page
\newcommand\colhead[1]{\multicolumn{1}{c}{#1}\pt@addcol}%
\newcommand\tablecolumns[1]{%
 \pt@column=#1\relax
 \pt@ncol=#1\relax
 \global\let\pt@addcol\@empty
}%
\newcommand\tablecaption[1]{\gdef\pt@caption{#1}}%
\newcommand\tablehead[1]{%
 \gdef\pt@head{%
  \hline\hline
  \relax\\[-1.7ex]%
  #1\hskip\tabcolsep
  \\[.7ex]%
  \hline
  \relax\\[-1.5ex]%
 }%
}%
\def\tablehead@aj#1{%
 \gdef\pt@head{%
  #1\hskip\tabcolsep
  \\[.7ex]%
  \hline
  \relax\\[-1.5ex]%
 }%
}%
\newif\if@pt@rot
\newcommand\rotate{\@pt@rottrue}%
\newcommand\tabletail[1]{\gdef\pt@tail{#1}}%
\newcommand\tablewidth[1]{\pt@width=#1\relax}%
\newcommand\tableheadfrac[1]{\gdef\pt@headfrac{#1}}%
\AtBeginDocument{%
 \let\pt@caption\@empty
 \let\pt@head\@empty
 \let\pt@tail\@empty
 \pt@width\textwidth
 \def\pt@headfrac{.1}%
}%
\def\pt@calcnlines{%
 \@tempdima\pt@headfrac\textheight
 \@tempdimb\textheight\advance\@tempdimb by-\@tempdima
 \@tempdima\arraystretch\baselineskip
 \divide\@tempdimb by\@tempdima
 \global\pt@nlines\@tempdimb
}%
\def\pt@tabacol{%
 \edef\@preamble{\@preamble\hskip\tabcolsep\tabskip\fill}%
}%
\newdimen\pt@tmpcapwidth
\long\def\@makecaption@plano#1#2{%
 \@ifdim{\pt@width>\z@}{%
  \pt@tmpcapwidth\pt@width
 }{%
  \pt@tmpcapwidth\textwidth
 }%
 \center
  \parbox{\pt@tmpcapwidth}{%
   \@make@caption@text{#1}{#2}%
  }%
 \endcenter
}%
\def\fnum@ptable{Table \thetable}%
\def\fnum@ptablecont{Table \thetable---{\rmfamily Continued}}%
\long\def\@make@caption@text#1#2{%
 \center\rmfamily#1.\quad#2\endcenter
}%
\long\def\@makecaption@plano@cont#1#2{%
 \center\rmfamily#1\endcenter
 \vskip 2.5ex
}%
\def\fnum@ptablecont@pptt{Table \thetable---{\itshape Continued}}%
\long\def\@make@caption@text@pptt#1#2{%
 \center\sc#1\\[.5ex]#2\endcenter
}%
\long\def\@makecaption@plano@cont@pptt#1#2{%
 \center\sc#1\endcenter
 \vskip 1.5ex
}%
\def\fnum@ptable@apj{TABLE \thetable}%
\def\fnum@ptablecont@apj{TABLE \thetable---{\itshape Continued}}%
\long\def\@make@caption@text@apj#1#2{%
 \center\Large\sc#1\\[.5ex]#2\endcenter
}%
\long\def\@makecaption@plano@cont@apj#1#2{%
 \center\Large\sc#1\endcenter
 \vskip 1.5ex
}%
\def\fnum@ptable@aj{Table \thetable.}%
\def\fnum@ptablecont@aj{Table \thetable.\space{\rmfamily (continued)}}%
\long\def\@make@caption@text@aj#1#2{%
 \center\large{\sc#1}\space#2\endcenter
}%
\long\def\@makecaption@plano@cont@aj#1#2{%
 \center\large{\sc#1}\endcenter
 \vskip 1.5ex
}%
\newenvironment{deluxetable}[1]{%
 \def\pt@format{\string#1}%
 \let\@acol\pt@tabacol
 \let\@tabularcr\@ptabularcr
 \let\@tablenotetext\@ptablenotetext
 \let\@tablenotes\@ptablenotes
 \global\pt@ncol\z@
 \global\pt@column\z@
 \global\pt@page\@ne
 \gdef\pt@addcol{\global\advance\pt@ncol\@ne}%
}{%
 \spew@tblnotes
 \typeout@deluxetable
 \endcenter
 \end@plano@float
}%
\let@environment{planotable}{deluxetable}%
\def\@plano@float{\@float{table}}%
\def\end@plano@float{\end@float}%
\def\typeout@deluxetable@mss{%
 \typeout{%
  Table \thetable\space has been set to width \the\pt@width
 }%
}%
\def\typeout@deluxetable@ppt{%
 \typeout{%
  Page  \the\pt@page \space of table \thetable\space has been set to
  width \the\pt@width\space with \the\pt@nlines\space lines per page
 }%
}%
\let\typeout@deluxetable\typeout@deluxetable@mss
\newcommand\startdata{%
 \pt@calcnlines
 \@ifdim{\pt@width>\z@}{%
  \def\@halignto{\@to\pt@width}%
 }{%
  \def\@halignto{}%
 }%
 \let\fnum@table=\fnum@ptable
 \let\@makecaption\@makecaption@plano
 \global\pt@line\z@
 \start@pt@tabular
 \after@startdata
}%
\def\start@pt@tabular{%
 \@plano@float
 \center
 \expandafter\caption\expandafter{\pt@caption}%
 \expandafter\@tabular\expandafter{\pt@format}%
}%
\def\set@pt@box#1{\setbox\pt@box}%
\def\after@startdata{\pt@head}%
\def\after@startdata@aj{\hline\hline\relax\\[-1.7ex]\pt@head}%
\def\enddata{%
 \crcr
 \noalign{\vskip .7ex}%
 \before@enddata
 \endtabular
 \setbox\pt@box\lastbox
 \pt@width\wd\pt@box\box\pt@box
}%
\def\before@enddata{\hline}%
\def\before@enddata@aj{\hline\hline}%
\def\nl{\substitute@command\nl\\}%
\def\nextline{\substitute@command\nextline\\}%
\def\@ptabularcr{%
 {\ifnum0=`}\fi % A klootch just in case the next token is & or \cr
 \@ifstar{%
  \@testopt{\@argptabularcr\@empty}\z@skip
 }{%
  \@testopt{\@argptabularcr\ptable@@split}\z@skip
 }%
}%
\def\@argptabularcr#1[#2]{%
 \ifnum0=`{\fi}% To undo the effect of the klootch.
 \@ifdim{#2>\z@}{%
  \unskip\@xargarraycr{#2}%
 }{%
  \@yargarraycr{#2}%
 }\ptable@split#1%
}%
\def\ptable@split#1{%
 \noalign{%
  \global\advance\pt@line\@ne
  \@ifnum{\pt@line<\pt@nlines}{}{%
   \aftergroup#1%
  }%
 }%
}%
\def\ptable@@split{%
  \before@suspendpt
  \endtabular
  \setbox\pt@box\lastbox
  \pt@width\wd\pt@box\box\pt@box
  \typeout@pt@nl
  \global\advance\pt@page\@ne
  \endcenter
  \end@plano@float
  \clearpage
  \addtocounter{table}{\m@ne}%
  \let\fnum@table=\fnum@ptablecont
  \let\@makecaption\@makecaption@plano@cont
  \global\pt@ncol=\pt@column%  Either 0 or value of \tablecolumns
  \global\pt@line\z@
  \start@pt@tabular
  \before@resumept
  \pt@head
}%
\def\before@suspendpt{}%
\def\before@resumept{}%
\def\before@suspendpt@aj{\@tabularcr\noalign{\vskip .7ex}\hline}%
\def\before@resumept@aj{\hline\relax\@tabularcr[-1.7ex]}%
\def\typeout@pt@nl@ppt{%
 \typeout{%
  Page \the\pt@page\space of table \thetable\space has been set to
  width \the\pt@width
 }%
}%
\def\typeout@pt@nl@mss{%
 \typeout{%
  Page \the\pt@page\space of table \thetable\space has been set to
  width \the\pt@width\space with \the\pt@nlines\space lines per page
 }%
}%
\def\typeout@pt@nl@aj{%
 \typeout{%
  Table \thetable\space has been set to
  width \the\pt@width\space with \the\pt@nlines\space lines per page
 }%
}%
\let\typeout@pt@nl\typeout@pt@nl@mss
\newcommand\tablevspace[1]{\substitute@command\tablevspace\\[#1]}%
\newcommand\tablebreak{\substitute@command\tablebreak\\}%{\cr\ptable@@split}%
\newcommand\cutinhead[1]{%
 \noalign{\vskip 1.5ex}%
 \hline
 \@ptabularcr
 \noalign{\vskip -4ex}%
 \multicolumn{\pt@ncol}{c}{#1}%
 \@ptabularcr
 \noalign{\vskip .8ex}%
 \hline
 \@ptabularcr
 \noalign{\vskip -2ex}%
}%
\def\cutinhead@ppt#1{%
 \noalign{\vskip 1.5ex}%
 \hline
 \@ptabularcr
 \noalign{\vskip -2ex}% Style Note: in apj, it is -1.5ex
 \multicolumn{\pt@ncol}{c}{#1}%
 \@ptabularcr
 \noalign{\vskip .8ex}%
 \hline
 \@ptabularcr
 \noalign{\vskip -2ex}%
}%
\newcommand\sidehead[1]{%
 \noalign{\vskip 1.5ex}%
 \multicolumn{\pt@ncol}{@{\hskip\z@}l}{#1}%
 \@ptabularcr
 \noalign{\vskip .5ex}%
}%
\def\@ptablenotetext#1#2{%
 \vspace{0ex}% Style Note: in ppt, it is gone
 {\parbox{\pt@width}{\hskip1em$^{\mathrm#1}$#2}\par}%
}%
\def\@ptablenotes#1{%
 \par
 \vspace{2ex}%
 {\setlength\parskip{1.5ex}#1}%
}%
\def\@ptablenotes@apj#1{%
 \par
 \vspace{2ex}%
 {#1}%
}%
\newcommand\tablerefs[1]{\appgdef\tblnote@list{\@tableref{#1}}}%
\def\@tableref#1{%
 \par
 \vspace*{3ex}%
 {\parbox{\pt@width}{\hskip1em\rmfamily References. --- #1}\par}%
}%
\newcommand\tablecomments[1]{\appgdef\tblnote@list{\@tablecom{#1}}}%
\def\@tablecom#1{%
 \par
 \vspace*{3ex}%
 {\parbox{\pt@width}{\hskip1em\rmfamily Note. --- #1}\par}%
}%
\def\@tableref@pptt#1{%
 \par
 \vspace*{3ex}{%
 \parbox{\pt@width}{\hskip1em{\sc References.---}#1}\par}%
}%
\def\@tablecom@pptt#1{%
 \vspace*{3ex}{%
 \parbox{\pt@width}{\hskip1em{\sc Note.---}#1}\par}%
}%
\newcounter{plate}%
\def\ftype@plate{4}%
\def\ext@plate{lof}%
\newenvironment{plate}{\@float{plate}}{\end@float}%
\newenvironment{plate*}{\@dblfloat{plate}}{\end@dblfloat}%
\let\platewidth=\tablewidth
\newcommand\platenum[1]{%
 \def\theplate{#1}%
 \let\@currentlabel\theplate
 \addtocounter{plate}{\m@ne}%
}%
\def\thefigure{\@arabic\c@figure}%
\def\thetable{\@arabic\c@table}%
\def\theplate{\@arabic\c@plate}%
\def\fnum@figure{{\rmfamily Fig.\space\thefigure.---}}%
\def\fnum@table{{\rmfamily Table \thetable:}}%
\def\fnum@plate{{\bfseries Plate \theplate.}}%
\def\fps@figure{bp}%
\def\fps@table{bp}%
\def\fps@plate{bp}%
\def\eps@scaling{.95}%
\newcommand\epsscale[1]{\gdef\eps@scaling{#1}}%
\newcommand\plotone[1]{%
 \centering
 \leavevmode
 \includegraphics[width={\eps@scaling\columnwidth}]{#1}%
}%
\newcommand\plottwo[2]{%
 \centering
 \leavevmode
 \columnwidth=.45\columnwidth
 \includegraphics[width={\eps@scaling\columnwidth}]{#1}%
 \hfil
 \includegraphics[width={\eps@scaling\columnwidth}]{#2}%
}%
\newcommand\plotfiddle[7]{%
 \centering
 \leavevmode
 \vbox\@to#2{\rule{\z@}{#2}}%
 \includegraphics[%
  scale=#4
  angle=#3
 ]{#1}%
}%
\let\jnl@style=\rmfamily
\def\ref@jnl#1{{\jnl@style#1}}%
\newcommand\aj{\ref@jnl{AJ}}%
          % Astronomical Journal
\newcommand\araa{\ref@jnl{ARA\&A}}%
          % Annual Review of Astron and Astrophys
\newcommand\apj{\ref@jnl{ApJ}}%
          % Astrophysical Journal
\newcommand\apjl{\ref@jnl{ApJ}}%
          % Astrophysical Journal, Letters
\newcommand\apjs{\ref@jnl{ApJS}}%
          % Astrophysical Journal, Supplement
\newcommand\ao{\ref@jnl{Appl.~Opt.}}%
          % Applied Optics
\newcommand\apss{\ref@jnl{Ap\&SS}}%
          % Astrophysics and Space Science
\newcommand\aap{\ref@jnl{A\&A}}%
          % Astronomy and Astrophysics
\newcommand\aapr{\ref@jnl{A\&A~Rev.}}%
          % Astronomy and Astrophysics Reviews
\newcommand\aaps{\ref@jnl{A\&AS}}%
          % Astronomy and Astrophysics, Supplement
\newcommand\azh{\ref@jnl{AZh}}%
          % Astronomicheskii Zhurnal
\newcommand\baas{\ref@jnl{BAAS}}%
          % Bulletin of the AAS
\newcommand\jrasc{\ref@jnl{JRASC}}%
          % Journal of the RAS of Canada
\newcommand\memras{\ref@jnl{MmRAS}}%
          % Memoirs of the RAS
\newcommand\mnras{\ref@jnl{MNRAS}}%
          % Monthly Notices of the RAS
\newcommand\pra{\ref@jnl{Phys.~Rev.~A}}%
          % Physical Review A: General Physics
\newcommand\prb{\ref@jnl{Phys.~Rev.~B}}%
          % Physical Review B: Solid State
\newcommand\prc{\ref@jnl{Phys.~Rev.~C}}%
          % Physical Review C
\newcommand\prd{\ref@jnl{Phys.~Rev.~D}}%
          % Physical Review D
\newcommand\pre{\ref@jnl{Phys.~Rev.~E}}%
          % Physical Review E
\newcommand\prl{\ref@jnl{Phys.~Rev.~Lett.}}%
          % Physical Review Letters
\newcommand\pasp{\ref@jnl{PASP}}%
          % Publications of the ASP
\newcommand\pasj{\ref@jnl{PASJ}}%
          % Publications of the ASJ
\newcommand\qjras{\ref@jnl{QJRAS}}%
          % Quarterly Journal of the RAS
\newcommand\skytel{\ref@jnl{S\&T}}%
          % Sky and Telescope
\newcommand\solphys{\ref@jnl{Sol.~Phys.}}%
          % Solar Physics
\newcommand\sovast{\ref@jnl{Soviet~Ast.}}%
          % Soviet Astronomy
\newcommand\ssr{\ref@jnl{Space~Sci.~Rev.}}%
          % Space Science Reviews
\newcommand\zap{\ref@jnl{ZAp}}%
          % Zeitschrift fuer Astrophysik
\newcommand\nat{\ref@jnl{Nature}}%
          % Nature
\newcommand\iaucirc{\ref@jnl{IAU~Circ.}}%
          % IAU Cirulars
\newcommand\aplett{\ref@jnl{Astrophys.~Lett.}}%
          % Astrophysics Letters
\newcommand\apspr{\ref@jnl{Astrophys.~Space~Phys.~Res.}}%
          % Astrophysics Space Physics Research
\newcommand\bain{\ref@jnl{Bull.~Astron.~Inst.~Netherlands}}%
          % Bulletin Astronomical Institute of the Netherlands
\newcommand\fcp{\ref@jnl{Fund.~Cosmic~Phys.}}%
          % Fundamental Cosmic Physics
\newcommand\gca{\ref@jnl{Geochim.~Cosmochim.~Acta}}%
          % Geochimica Cosmochimica Acta
\newcommand\grl{\ref@jnl{Geophys.~Res.~Lett.}}%
          % Geophysics Research Letters
\newcommand\jcp{\ref@jnl{J.~Chem.~Phys.}}%
          % Journal of Chemical Physics
\newcommand\jgr{\ref@jnl{J.~Geophys.~Res.}}%
          % Journal of Geophysics Research
\newcommand\jqsrt{\ref@jnl{J.~Quant.~Spec.~Radiat.~Transf.}}%
          % Journal of Quantitiative Spectroscopy and Radiative Trasfer
\newcommand\memsai{\ref@jnl{Mem.~Soc.~Astron.~Italiana}}%
          % Mem. Societa Astronomica Italiana
\newcommand\nphysa{\ref@jnl{Nucl.~Phys.~A}}%
          % Nuclear Physics A
\newcommand\physrep{\ref@jnl{Phys.~Rep.}}%
          % Physics Reports
\newcommand\physscr{\ref@jnl{Phys.~Scr}}%
          % Physica Scripta
\newcommand\planss{\ref@jnl{Planet.~Space~Sci.}}%
          % Planetary Space Science
\newcommand\procspie{\ref@jnl{Proc.~SPIE}}%
          % Proceedings of the SPIE
\let\astap=\aap
\let\apjlett=\apjl
\let\apjsupp=\apjs
\let\applopt=\ao
\newcommand\phn{\phantom{0}}%
\newcommand\phd{\phantom{.}}%
\newcommand\phs{\phantom{$-$}}%
\newcommand\phm[1]{\phantom{#1}}%
\let\la=\lesssim            % For Springer A&A compliance...
\let\ga=\gtrsim
\newcommand\sq{\mbox{\rlap{$\sqcap$}$\sqcup$}}%
\newcommand\arcdeg{\mbox{$^\circ$}}%
\newcommand\arcmin{\mbox{$^\prime$}}%
\newcommand\arcsec{\mbox{$^{\prime\prime}$}}%
\newcommand\fd{\mbox{$.\!\!^{\mathrm d}$}}%
\newcommand\fh{\mbox{$.\!\!^{\mathrm h}$}}%
\newcommand\fm{\mbox{$.\!\!^{\mathrm m}$}}%
\newcommand\fs{\mbox{$.\!\!^{\mathrm s}$}}%
\newcommand\fdg{\mbox{$.\!\!^\circ$}}%
\newcommand\farcm@mss{\mbox{$.\mkern-4mu^\prime$}}%
\let\farcm\farcm@mss
\newcommand\farcs@mss{\mbox{$.\!\!^{\prime\prime}$}}%
\let\farcs\farcs@mss
\newcommand\fp{\mbox{$.\!\!^{\scriptscriptstyle\mathrm p}$}}%
\newcommand\micron{\mbox{$\mu$m}}%
\def\farcm@apj{%
 \mbox{.\kern -0.7ex\raisebox{.9ex}{\scriptsize$\prime$}}%
}%
\def\farcs@apj{%
 \mbox{%
  \kern  0.13ex.%
  \kern -0.95ex\raisebox{.9ex}{\scriptsize$\prime\prime$}%
  \kern -0.1ex%
 }%
}%
\newcommand\case[2]{\mbox{$\frac{#1}{#2}$}}%
\newcommand\slantfrac{\case}%
\newcommand\onehalf{\slantfrac{1}{2}}%
\newcommand\onethird{\slantfrac{1}{3}}%
\newcommand\twothirds{\slantfrac{2}{3}}%
\newcommand\onequarter{\slantfrac{1}{4}}%
\newcommand\threequarters{\slantfrac{3}{4}}%
\newcommand\ubvr{\mbox{$U\!BV\!R$}}%% UBVR system
\newcommand\ub{\mbox{$U\!-\!B$}}%   % U-B
\newcommand\bv{\mbox{$B\!-\!V$}}%   % B-V
\newcommand\vr{\mbox{$V\!-\!R$}}%   % V-R
\newcommand\ur{\mbox{$U\!-\!R$}}%   % U-R
\newcommand\ion[2]{#1$\;${\small\rmfamily\@Roman{#2}}\relax}%
\newcommand\nodata{ ~$\cdots$~ }%
\newcommand\diameter{\ooalign{\hfil/\hfil\crcr\mathhexbox20D}}%
\newcommand\degr{\arcdeg}%
\newcommand\Sun{\sun}%
\newcommand\Sol{\sun}%
\newcommand\sun{\odot}%
\newcommand\Mercury{\astro{\char1}}% Mercury symbol, "1"
\newcommand\Venus{\astro{\char2}}% Venus symbol, "2"
\newcommand\Earth{\earth}%
\newcommand\Terra{\earth}%
\newcommand\earth{\oplus}%
\newcommand\Mars{\astro{\char4}}% Mars symbol, "4"
\newcommand\Jupiter{\astro{\char5}}% Jupiter symbol, "5"
\newcommand\Saturn{\astro{\char6}}% Saturn symbol, "6"
\newcommand\Uranus{\astro{\char7}}% Uranus symbol, "7"
\newcommand\Neptune{\astro{\char8}}% Neptune symbol, "8"
\newcommand\Pluto{\astro{\char9}}% Pluo symbol, "9"
\newcommand\Moon{\astro{\char10}}% Moon symbol, "M"
\newcommand\Luna{\Moon}%
\newcommand\Aries{\astro{\char11}}%
\newcommand\VEq{\Aries}% vernal equinox (Aries)
\newcommand\Taurus{\astro{\char12}}%
\newcommand\Gemini{\astro{\char13}}%
\newcommand\Cancer{\astro{\char14}}%
\newcommand\Leo{\astro{\char15}}%
\newcommand\Virgo{\astro{\char16}}%
\newcommand\Libra{\astro{\char17}}%
\newcommand\AEq{\Libra}% autumnal equinox (Libra)
\newcommand\Scorpius{\astro{\char18}}%
\newcommand\Sagittarius{\astro{\char19}}%
\newcommand\Capricornus{\astro{\char20}}%
\newcommand\Aquarius{\astro{\char21}}%
\newcommand\Pisces{\astro{\char22}}%
\def\load@astro{%
 \dimen@=1\aas@ptsize\p@
 \font\astro@font=Astrosym at\dimen@
}%
\def\astro#1{\leavevmode\hbox{\astro@font#1}}%
\def\astro@font{%
 \ClassWarning{aastex}{%
  Please use class option `astro', since you are using the astro font.%
 }%
}%
\newcommand\sbond{\chem@bnd{\@sbnd}}%
\newcommand\dbond{\chem@bnd{\@dbnd}}%
\newcommand\tbond{\chem@bnd{\@tbnd}}%
\def\chem@bnd#1{%
 {%
  \kern.1em\relax
  \setbox\z@\hbox{M}%
  \dimen@ii.8em\relax
  \p@=.1em\relax
  \dimen@.5\ht\z@\dimen@i-\dimen@
  \advance\dimen@1.5\p@\advance\dimen@i-1.0\p@
  #1%
  \kern.1em\relax
  }%
 }%
\def\@sbnd{%
 \advance\dimen@-1.5\p@\advance\dimen@i1.5\p@
 \vrule\@height\dimen@\@depth\dimen@i\@width\dimen@ii\nobreak
 }%
\def\@dbnd{%
 \advance\dimen@-0.5\p@\advance\dimen@i0.5\p@
 \vrule\@height\dimen@\@depth\dimen@i\@width\dimen@ii\nobreak
 \advance\dimen@-1.5\p@\advance\dimen@i1.5\p@
 \hskip-\dimen@ii
 \vrule\@height\dimen@\@depth\dimen@i\@width\dimen@ii\nobreak
 }%
\def\@tbnd{%
 \vrule\@height\dimen@\@depth\dimen@i\@width\dimen@ii\nobreak
 \advance\dimen@-1.5\p@\advance\dimen@i1.5\p@
 \hskip-\dimen@ii
 \vrule\@height\dimen@\@depth\dimen@i\@width\dimen@ii\nobreak
 \advance\dimen@-1.5\p@\advance\dimen@i1.5\p@
 \hskip-\dimen@ii
 \vrule\@height\dimen@\@depth\dimen@i\@width\dimen@ii\nobreak
 }%
\renewcommand\LaTeX{%
 \leavevmode
 L%
 \raise.42ex\hbox{%
  \count@=\the\fam
  $\fam\count@\scriptstyle\kern-.3em A$%
 }%
 \kern-.15em\TeX
}%
\newcommand\anchor[2]{#2}%
\newcommand\url{\@dblarg\@url}%
\def\@url[#1]{\anchor{#1}}%
\def\@text@email#1{\texttt{mailto:#1}}%
\def\authoremail{\substitute@command\authoremail\email}%
\newcommand\objectname{\@testopt\@objectname{[]}}%
\def\@objectname[#1]#2{#2}%
\newcommand\sizrpt{%
 (\fontname\the\font): em=\the\fontdimen6\font, ex=\the\fontdimen5\font
 \typeout{%
  (\fontname\the\font): em=\the\fontdimen6\font, ex=\the\fontdimen5\font
 }%
}%
\def\aas@preprint{%
 \def\revtex@genre{preprint}%
 \let\ptlandscape\@empty
 \setlength\@slugcmmntwidth{.67\textwidth}%
 \let\@makeslugcmmnt\@makeslugcmmnt@ppt
 \let\@abstract\@abstract@ppt
 \let\make@title\make@title@ppt
 \let\make@affil\make@affil@pptt
 \let\notetoeditor\@gobble
 \let\clear@section@page\@empty
 \let\placetable\@gobble
 \let\placefigure\@gobble
 \let\placeplate\@gobble
 \let\typeout@deluxetable\typeout@deluxetable@ppt
 \let\typeout@pt@nl\typeout@pt@nl@mss
 \ps@plaintop
 \let\references@refpar\references@refpar@mss
 \let\cutinhead\cutinhead@ppt
}%
\@namedef{aas@preprint2}{%
 \aas@preprint
 \def\revtex@genre{2-column preprint}%
 \ps@plain
 \@twocolumntrue
 \setlength\parindent{1.2em}%
 \setlength\parskip{0.5ex}%
 \setlength\columnsep{0.5in}%
 \setlength\hoffset{-0.2in}%
 \tolerance=600
 \setlength\emergencystretch{6\p@}%
 \def\baselinestretch{1.0}%
 \def\@tightleading{1.0}%
 \let\singlespace\@empty
 \let\doublespace\@empty
 \let\@dates\@dates@pptt
 \let\@abstract\@abstract@pptt
 \let\make@title\make@title@pptt
 \let\make@author\make@author@pptt
 \let\@keywords\@keywords@pptt
 \setlength{\skip\footins}{3ex\@plus1ex\@minus.5ex}%
 \setlength\footnotesep{2ex}%
 \let\@makefntext\@makefntext@pptt
 \let\section\section@pptt
 \let\subsection\subsection@pptt
 \let\subsubsection\subsubsection@pptt
 \let\section@centering\@empty
 \let\appendix@figtab@defs\appendix@figtab@defs@pptt
 \def\clear@thebibliography@page{%
  \if@restonecol\if@twocolumn\else\twocolumn\fi\fi
 }%
 \let\references@refpar\references@refpar@pptt
 \let\thebib@list\thebib@list@pptt
 \let\@tablenotes\@tablenotes@pptt
 \let\fnum@ptablecont\fnum@ptablecont@pptt
 \let\@make@caption@text\@make@caption@text@pptt
 \let\@makecaption@plano@cont\@makecaption@plano@cont@pptt
 \let\cutinhead\cutinhead@ppt
 \def\@plano@float{\@dblfloat{table}}%
 \def\end@plano@float{\end@dblfloat}%
 \let\@tableref\@tableref@pptt
 \let\@tablecom\@tablecom@pptt
}%
\def\section@pptt{%
 \@startsection{section}{1}%
  {\z@}{2.3ex\@plus1ex\@minus.2ex}%
  {1.5ex\@plus.2ex}{\normalsize\bfseries}%
}%
\def\subsection@pptt{%
 \@startsection{subsection}{2}%
  {\z@}{2ex\@plus1ex\@minus.2ex}{1ex\@plus.2ex}{\normalsize\bfseries}%
}%
\def\subsubsection@pptt{%
 \@startsection{subsubsection}{3}%
  {\z@}{2ex\@plus1ex\@minus.2ex}{1ex\@plus.2ex}{\normalsize\itshape}%
}%
\def\aas@manuscript{%
 \def\revtex@genre{manuscript}%
 \let\ptlandscape\@empty
 \def\baselinestretch{\@doubleleading}%
 \let\footnote@size\@empty
 \def\tighten{\def\baselinestretch{\@doubleleading}}%
 \def\singlespace{}%
 \def\doublespace{}%
 \opt@tighten
 \setlength\@slugcmmntwidth{\textwidth}%
 \let\@makeslugcmmnt\@makeslugcmmnt@mss
 \@rightskip=\z@\@plus4em
 \rightskip\@rightskip
 \opt@just
 \let\sluginfo\sluginfo@mss
 \let\@abstract\@abstract@mss
 \let\make@title\make@title@mss
 \def\clear@section@page{\clearpage}%
 \def\clear@thebibliography@page{\clearpage}%
 \let\footnotesize=\normalsize
 \let\typeout@deluxetable\typeout@deluxetable@mss
 \let\typeout@pt@nl\typeout@pt@nl@mss
 \ps@plaintop
 \let\references@refpar\references@refpar@mss
}%
\def\journal{\@gobble}%
\def\volume{\@gobble}%
\def\issue{\@gobble}%
\def\SGMLbi#1{#1}%
\def\SGMLbsc#1{#1}%
\def\SGMLclc#1{#1}%
\def\SGMLentity#1{\&#1;}%
\def\SGML{\@gobble}%
\endinput
%%
%% End of file `aastex.cls'.
