%%
%% This is file `aipproc.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% aipproc.dtx  (with options: `class')
%% 
%% Class aipproc to use with LaTeX2e
%% (C) 1998 American Institute of Physics and Frank Mittelbach
%% All rights reserved
%% 
%% Class aipproc to use with LaTeX2e
%%
%% Copyright (C) 1998  Frank Mittelbach
%% Copyright (C) 1998 American Institute of Physics, all rights reserved.
%%
%% Development of this class was commissioned by American Institute of Physics.
%%
\NeedsTeXFormat{LaTeX2e}[1996/12/01]
\ProvidesClass{aipproc}
    [1998/09/14 v1.0a AIP Proceedings (FMi)]
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%%
\RequirePackage{calc}
\RequirePackage{graphicx}
\let\setinternalcounter\calc@assign@count
\newcommand\AIP@optionnotsupported[1]
    {\ClassWarningNoLine{aipproc}%
                {Option `#1' not supported --- request ignored}}
\newcommand\AIP@error{\ClassError{aipproc}}
\newcommand\AIP@cmdnotsupported[1]
    {\def#1{\AIP@error{Command \noexpand#1not supported}\@eha}}
\DeclareOption{a5paper}       {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{b5paper}       {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{letterpaper}   {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{legalpaper}    {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{executivepaper}{\AIP@optionnotsupported\CurrentOption}
\DeclareOption{landscape}     {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{11pt}          {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{12pt}          {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{titlepage}     {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{notitlepage}   {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{onecolumn}     {\AIP@optionnotsupported\CurrentOption}
\DeclareOption{tnotealph}  {\def\AIP@tnote@representation{\@alph}}
\DeclareOption{tnotesymbol}{\def\AIP@tnote@representation{\@fnsymbol}}
\DeclareOption{cmfonts}    {\def\AIP@mathfontsused{0}}
\DeclareOption{mathptm}    {\def\AIP@mathfontsused{1}}
\DeclareOption{mathtime}   {\def\AIP@mathfontsused{2}}
\DeclareOption{nomathfonts}{\def\AIP@mathfontsused{3}}
\def\pageref{0}
\DeclareOption{varioref}      {\def\pageref{1}}
\DeclareOption{nonvarioref}   {\def\pageref{2}}
\DeclareOption{draft}{\PassOptionsToClass{\CurrentOption}{article}%
    \AtEndOfPackage{\let\AIP@pagenumerror\@gobble
          \def\@oddfoot{\reset@font\@title\hfil\@date\hfil\thepage}}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ExecuteOptions{mathptm,tnotesymbol}
\ProcessOptions\relax
\LoadClass[twocolumn,a4paper,10pt]{article}
\setlength\textwidth {40pc}
\setlength\textheight{54pc - 2pt}
\setlength\columnsep {2pc}
\setlength\topmargin{-1pc}
\flushbottom
\pagestyle{empty}
\AIP@cmdnotsupported\pagestyle
\setlength\parindent{12pt}
\setinternalcounter\widowpenalty{10000}
\setinternalcounter\clubpenalty{9999}
\newcommand*\affiliation[1]{\def\AIP@affiliation{#1}}
\newcommand*\affiliationmark[1]{\textsuperscript{#1}}
\title{TITLE here}
\author{AUTHOR here}
\affiliation{AFFILIATION here}
\newcommand\AIP@waitforabstractfalse
      {\global\let\ifAIP@waitforabstract\iffalse}
\newcommand\AIP@waitforabstracttrue
      {\global\let\ifAIP@waitforabstract\iftrue}
\AIP@waitforabstractfalse             % by default we don't wait
\renewcommand\maketitle{%
 \ifAIP@waitforabstract
 \else
  \par
  \begingroup
    \gdef\@thanks{}%
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark
        {\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \normalfont\@thefnmark~##1}%
    \twocolumn[\@maketitle]%
    \@thanks
    \AIP@abstract@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\AIP@affiliation\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\affiliation\relax
  \global\let\and\relax
 \fi
}
\renewcommand\@maketitle{%
  \newpage
  \null
  \vskip 4pc
  \begin{center}%
  \let \footnote \thanks
  {\AIPtitlefont \@title \par}%
  \vskip 7pt
  {\AIPauthorfont
   \ignorespaces
   \@author
   \par}%
  \vskip 9pt
  {\AIPaffiliationfont
   \ignorespaces
   \AIP@affiliation\par}%
  \vskip 10pt
  \unhbox\AIP@box
  \end{center}%
  \par
  \vskip 1.5em}
\AIP@cmdnotsupported\and
\renewenvironment{abstract}
  {\begin{lrbox}\AIP@box
   \let \footnote \thanks
   \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
   \begin{minipage}{\textwidth-48pt}
   \AIPAbstractheadingfont\abstractname.\quad\normalfont
  }
  {\end{minipage}\end{lrbox}%
   % store any thanks away:
   \global\let\AIP@abstract@thanks\@thanks
   \ifAIP@waitforabstract       % so \maketitle came first
     \AIP@waitforabstractfalse
     \maketitle
   \else
     \global\setbox\AIP@box\hbox{\unhbox\AIP@box}%
   \fi
   \immediate\write\@auxout{\string\AIP@waitforabstracttrue}%
  }
\newbox\AIP@box
\let\AIP@abstract@thanks\@empty
\newcommand\AIP@pagenumerror[1]{%
  \AIP@error{Command \string#1 can't be used
       in production}%
      {This command will produce page numbers which will
       be incorrect in the\MessageBreak final production.
       It should therefore only be used while producing
       drafts.}}
\let\@@tableofcontents\tableofcontents
\let\@@listoffigures\listoffigures
\let\@@listoftables\listoftables
\renewcommand\tableofcontents{%
   \AIP@pagenumerror\tableofcontents\@@tableofcontents}
\renewcommand\listoffigures{%
   \AIP@pagenumerror\listoffigures\@@listoffigures}
\renewcommand\listoftables{%
   \AIP@pagenumerror\listoftables\@@listoftables}
\setcounter{secnumdepth}{-2}
\renewcommand\section
   {\@startsection {section}{1}{\z@}%
                   {2\baselineskip \@plus 3pt \@minus 1pt}%
                   {\baselineskip}%
                   {\AIPsectionfont\centering\MakeUppercase}}
\renewcommand\subsection
   {\@startsection {subsection}{2}{\z@}%
                   {2\baselineskip \@plus 3pt \@minus 1pt}%
                   {\baselineskip}%
                   {\AIPsubsectionfont\centering}}
\renewcommand\subsubsection
   {\@startsection {subsubsection}{3}{\z@}%
                   {2\baselineskip \@plus 3pt \@minus 1pt}%
                   {\baselineskip}%
                   {\AIPsubsubsectionfont\centering}}
\renewcommand\paragraph
   {\@startsection {paragraph}{4}{\parindent}%
                   {-1\baselineskip \@plus -3pt \@minus -1pt}%
                   {-1em}%
                   {\AIPparagraphfont}}
\renewcommand\subparagraph
   {\@startsection {subparagraph}{5}{\parindent}%
                   {-1\baselineskip \@plus -3pt \@minus -1pt}%
                   {-1em}%
                   {\AIPsubparagraphfont}}
\ifcase \AIP@mathfontsused
                                 % 0 use cm for everything
\or
  \RequirePackage{mathptm}       % 1
  \def\boldmath{%
   \PackageWarning{mathptm}{There is no bold Symbol font\MessageBreak
       \noexpand\boldmath command ignored}%
   \global\let\boldmath=\relax
  }
\or
  \RequirePackage{mathtime}      % 2
\or
                                 % 3 use cm for math
\fi
\ifnum \AIP@mathfontsused > 0
  \RequirePackage[T1]{fontenc}
  \RequirePackage{times}
  \RequirePackage{textcomp}
\fi
\newcommand\AIPtitlefont      {\fontsize{18}{19}\bfseries}
\newcommand\AIPaffiliationfont{\fontsize{10}{11}\itshape}
\newcommand\AIPauthorfont     {\fontsize{14}{15}\normalfont}
\newcommand\AIPAbstractheadingfont{\fontsize{9}{12}\bfseries}
\newcommand\AIPsectionfont{\normalfont\fontsize{12}{14}\bfseries}
\newcommand\AIPsubsectionfont{\normalfont\fontsize{12}{14}\bfseries}
\newcommand\AIPsubsubsectionfont{\normalfont\fontsize{12}{14}\itshape}
\newcommand\AIPparagraphfont{\normalfont\normalsize\bfseries}
\newcommand\AIPsubparagraphfont{\normalfont\normalsize\itshape}
\newcommand\AIPcaptionfont{\fontsize{9}{11}\bfseries}
\newcommand\AIPtablefont{\fontsize{9}{12}\normalfont}
\newcommand\AIPtableheadfont{\fontsize{9}{10}\bfseries}
\newcommand\AIPbibliographyfont{\fontsize{9}{11}\selectfont}
\setlength{\skip\footins}{.25in+.125in}
\renewcommand\footnoterule{%
  \kern-.125in
  \kern-.5pt
  \hrule \@width 2in \@height .5pt
  \kern.125in}
\renewcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \@makefnmark~#1}
\def \@makecol {%
   \setbox\@outputbox \box\@cclv
   \@combinefloats
   \ifvoid\footins
   \else
     \setbox\@outputbox \vbox {%
       \boxmaxdepth \@maxdepth
       \unvbox \@outputbox
       \vskip \skip\footins
       \color@begingroup
         \normalcolor
         \footnoterule
         \unvbox \footins
       \color@endgroup
       }%
   \fi
   \xdef\@freelist{\@freelist\@midlist}%
   \global \let \@midlist \@empty
   \ifvbox\@kludgeins
     \@makespecialcolbox
   \else
     \setbox\@outputbox \vbox to\@colht {%
       \@texttop
       \dimen@ \dp\@outputbox
       \unvbox \@outputbox
       \vskip -\dimen@
       \@textbottom
       }%
   \fi
   \global \maxdepth \@maxdepth
}
\def\@fnsymbol#1{\ensuremath{\ifcase#1\or *\or \dagger\or **\or
   \ddagger\or \mathsection\or \mathparagraph\or \|\or \dagger\dagger
   \or \ddagger\ddagger \or\mathsection\mathsection
   \or \mathparagraph\mathparagraph \or *{*}*\or
   \dagger{\dagger}\dagger \or\ddagger{\ddagger}\ddagger\or
   \mathsection{\mathsection}\mathsection
   \or \mathparagraph{\mathparagraph}\mathparagraph \else\@ctrerr\fi}}
\def\@alph#1{\ifcase#1\or a\or b\or c\or d\or e\or f\or g\or h\or i\or
  j\or k\or l\or m\or n\or o\or p\or q\or r\or s\or t\or u\or v\or
  w\or x\or y\or z\or aa\or bb\or cc\or dd\or ee\or ff\or gg\or hh\or
  ii\or jj\or kk\or ll\or mm\or nn\or oo\or pp\or qq\or rr\or ss\or
  tt\or uu\or vv\or ww\or xx\or yy\or zz\else\@ctrerr\fi}
\setinternalcounter\@beginparpenalty{10000}
\ifnum\pageref>0
 \RequirePackage{varioref}
 \renewcommand\reftextfaceafter {on the next page}
 \renewcommand\reftextfacebefore{on the \reftextvario{previous}%
                                                     {preceding} page}
 \renewcommand\reftextafter     {on the \reftextvario{following}%
                                                     {next} page}
 \renewcommand\reftextbefore    {on the \reftextvario{preceding page}%
                                                     {page before}}
 \renewcommand\reftextcurrent   {on \reftextvario{this}%
                                                 {the current} page}
 \renewcommand\reftextfaraway[1]{%
   \is@pos@number\@tempb
    {\ifnum\@tempb<0\@tempa\relax
       \reftextearlier
     \else
       \reftextlater
     \fi}%
   {\@setref\relax\relax{#1}}}
 \newcommand\reftextearlier{\reftextvario{on an earlier page}%
                                         {earlier on}}
 \newcommand\reftextlater  {\reftextvario{later on}{further down}}
 \ifnum\pageref=2
   \def\reftextvario#1#2{#1}
 \fi
 \let\pageref\vpageref
\else
  \renewcommand\pageref[1]
    {\AIP@error{Page references not supported}
      {This class does not support references to page
       numbers unless the varioref or the nonvarioref option
       is used, since it doesn't print page numbers.}}
\fi
\RequirePackage{fix2col}[1998/08/17]
\newcommand\AIP@maketablecaption[2]{%
  \vskip\abovecaptionskip \AIPcaptionfont
  \noindent#1.\normalfont~#2\par \vskip\belowcaptionskip}
\newcommand\AIP@makefigurecaption[2]{%
  \vskip\abovecaptionskip
  \AIPcaptionfont
  \settowidth\@tempdima{\noindent#1.\normalfont~#2}%
  \ifdim\@tempdima<\hsize
     \centering
  \fi
  \noindent#1.\normalfont~#2\par
  \vskip\belowcaptionskip}
\let\@makecaption\AIP@maketablecaption
\setlength\abovecaptionskip{6mm - 11pt}      % b/b spacing
\setlength\belowcaptionskip{6mm - 11pt - 2pt}
\newcommand\AIP@sourceerror{\AIP@error
  {\noexpand\source is only supported with `table' or `figure'
   environment}\@ehd}
\let\source\AIP@sourceerror
\newcommand\AIP@source[1]{\gdef\AIP@typeset@source
   {\addvspace{1mm}\rightline{\footnotesize\itshape Source: #1}}}
\newcommand\AIP@source@setup{%
    \let\source\AIP@source
    \global\let\AIP@typeset@source\@empty}
\newcommand\AIP@tablenoteerror{\AIP@error
  {\noexpand\tablenote is only supported inside `table'
   environment\MessageBreak and not allowed inside
   the \noexpand\caption or \noexpand\source command}\@ehd}
\let\tablenote\AIP@tablenoteerror
\newcommand\AIP@tablenote[2]{%
       \leavevmode
       \stepcounter\@mpfn
       \protected@xdef\@thefnmark{\thempfn}%
       #1\@footnotemark
       \protected@xdef\AIP@tnote@process
            {\AIP@tnote@process
             \protect\footnotetext
             [\the\c@mpfootnote]{\protect\raggedright#2}}%
}
\newcommand\AIP@tnote@setup{%
    \def\@mpfn{mpfootnote}%
    \def\thempfn{\thempfootnote}%
    \def\thempfootnote{\AIP@tnote@representation\c@mpfootnote}%
    \global\c@mpfootnote\z@
    \def\tablenote{\@ifstar{\AIP@tablenote\relax}%
                           {\AIP@tablenote\rlap}}%
    \gdef\AIP@tnote@process{}%
    \setlength{\skip\@mpfootins}{2mm}%
    \let\footnoterule\relax
    \let\@footnotetext\@mpfootnotetext
}
\newcommand\AIP@tablehead[4]{\multicolumn{#1}{#2}%
   {\AIPtableheadfont\begin{tabular}[#3]{@{}#2@{}}%
    \vrule \@height 10pt\@width 0pt\relax
    \ignorespaces#4\unskip
    \vrule \@depth 5pt\@width 0pt\end{tabular}}}
\def\hline{%
  \noalign{\ifnum0=`}\fi\vskip\hlinesep
      \hrule \@height \arrayrulewidth\vskip3\hlinesep
      \futurelet \reserved@a\@xhline}
\newdimen\hlinesep
\setlength\hlinesep{1pt}
\newenvironment{ltxtable}
               {\@float{table}%
                \AIPtablefont}
               {\end@float}
\newenvironment{ltxtable*}
               {\@dblfloat{table}%
                \AIPtablefont}
               {\end@dblfloat}
\renewenvironment{table*}[1][tbp]
   {\AIP@error{Environment `table*' not supported\MessageBreak
                         --- environment `table' used instead}%
    {The class automatically determines the position of the float
     according\MessageBreak
     to its size.}%
    \begin{table}}
   {\end{table}}
\renewenvironment{table}[1][tbp]
   {\def\AIP@floatspec{#1}%
    \let\tablehead\AIP@tablehead
    \AIP@source@setup
    \AIP@tnote@setup
    \global \setbox\AIP@box
    \color@hbox
      \hbox \bgroup
      \@floatboxreset
         \def\caption##1{\gdef\AIP@save@caption{##1}}%
         \def\label##1{\gdef\AIP@save@label{##1}}%
         \global\let\AIP@save@caption\@undefined
         \global\let\AIP@save@label\@undefined
       \normalcolor
       \AIPtablefont
       \ignorespaces
   }
   {%
       \AIP@remove@any@previous@space
       \outer@nobreak
      \egroup
    \color@endbox
    \setlength\dimen@{\columnwidth+1pt}%
    \ifdim\wd\AIP@box >\dimen@
      \setlength\dimen@{\textwidth+1pt}%
      \ifdim\wd\AIP@box >\dimen@
        \def\@captype{table}%
        \sbox\@tempboxa{\AIP@make@table@body}%
        \setlength\dimen@{\ht\@tempboxa+\dp\@tempboxa}%
        \ifdim\dimen@ <\columnwidth
          \def\@tempa{\@float{table}}%
          \expandafter\@tempa\expandafter[\AIP@floatspec]%
            \centerline{\rotatebox{90}{\box\@tempboxa}}%
          \end@float
        \else
           \def\@tempa{\@dblfloat{table}}%
           \expandafter\@tempa\expandafter[\AIP@floatspec]%
           \centerline{\rotatebox{90}{\box\@tempboxa}}%
          \end@dblfloat
        \fi
      \else
        \def\@tempa{\@dblfloat{table}}%
        \expandafter\@tempa\expandafter[\AIP@floatspec]%
          \AIP@make@table@body
        \end@dblfloat
      \fi
    \else
      \def\@tempa{\@float{table}}%
      \expandafter\@tempa\expandafter[\AIP@floatspec]%
        \AIP@make@table@body
      \end@float
    \fi
}
\newcommand\AIP@make@table@body{%
      \centering
      \@tempdima\wd\AIP@box
      \ifdim\@tempdima<.6\columnwidth \@tempdima.6\columnwidth \fi
      \begin{minipage}\@tempdima
        \ifx\AIP@save@caption\@undefined\else
          \let\tablenote\AIP@tablenoteerror
          \caption{\AIP@save@caption
                   \ifx\AIP@save@label\@undefined\else
                     \label\AIP@save@label
                   \fi}%
        \fi
        \par
        \vbox{\hsize\wd\AIP@box
                          \box\AIP@box
                          \AIP@typeset@source}%
        \AIP@tnote@process
     \end{minipage}%
}
\newcommand\AIP@remove@any@previous@space
  {\unskip\loop\unskip\ifdim\lastskip>\z@\repeat}
\newenvironment{ltxfigure}
               {\@float{figure}}
               {\end@float}
\newenvironment{ltxfigure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\renewenvironment{figure}[1][tbp]
   {\def\AIP@floatspec{#1}%
    \AIP@source@setup
    \global \setbox\AIP@box
    \color@hbox
      \hbox \bgroup
      \@floatboxreset
         \def\caption##1{\gdef\AIP@save@caption{##1}}%
         \def\label##1{\gdef\AIP@save@label{##1}}%
         \global\let\AIP@save@caption\@undefined
         \global\let\AIP@save@label\@undefined
       \normalcolor
       \normalfont
       \normalsize
       \ignorespaces
   }
   {%
       \AIP@remove@any@previous@space
       \outer@nobreak
      \egroup
    \color@endbox
    \def\@tempa{\@dblfloat{figure}}%
    \setlength\dimen@{\columnwidth+1pt}%
    \ifdim\wd\AIP@box >\dimen@
      \expandafter\@tempa\expandafter[\AIP@floatspec]%
        \AIP@make@figure@body
      \end@dblfloat
    \else
      \def\@tempa{\@float{figure}}%
      \expandafter\@tempa\expandafter[\AIP@floatspec]%
        \AIP@make@figure@body
      \end@float
    \fi
}
\newcommand\AIP@make@figure@body{%
      \centering
      \setlength\@tempdima{\wd\AIP@box-1pt}%
      \ifdim\@tempdima>\columnwidth
         \@tempdima\textwidth
      \else
         \@tempdima\columnwidth
      \fi
      \begin{minipage}\@tempdima
        \centerline{\vbox{\hsize\wd\AIP@box
                          \box\AIP@box
                          \AIP@typeset@source}}%
        \ifx\AIP@save@caption\@undefined\else
          \let\@makecaption\AIP@makefigurecaption
          \caption{\AIP@save@caption
                   \ifx\AIP@save@label\@undefined\else
                     \label\AIP@save@label
                   \fi}%
        \fi
        \par
     \end{minipage}}
\renewcommand\fnum@figure{\MakeUppercase\figurename~\thefigure}
\AtBeginDocument{%
\newcommand\@@longtable{}%
\let\@@longtable\longtable
\def\longtable{%
  \begingroup
    \LTcapwidth\z@
    \advance\c@LT@tables\@ne   % local as stepcounter comes later
    \let\LT@entry\AIP@get@longtable@width
    \csname LT@\romannumeral\c@LT@tables\endcsname
    \ifdim \LTcapwidth=\z@ \global \LTcapwidth2in
    \else \global\LTcapwidth\LTcapwidth
    \fi
  \endgroup
  \let\tablehead\AIP@tablehead
  \@@longtable
}%
\def\LT@makecaption#1#2#3{%
  \LT@mcol\LT@cols {@{}l@{}}{\rlap{\parbox[t]\LTcapwidth{%
    \vskip\abovecaptionskip
  \AIPcaptionfont
  \noindent#1{#2.\ }\normalfont#3\endgraf
  \vskip\belowcaptionskip
  }}}}%
}
\newcommand\AIP@get@longtable@width[2]{\advance\LTcapwidth#2\relax }
\renewcommand\dblfloatpagefraction{.5}
\renewcommand\dbltopfraction{.7}
\renewcommand\topfraction{.85}
\renewcommand\bottomfraction{.3}
\renewcommand\floatpagefraction{.8}
\renewcommand\textfraction{.15}
\setcounter{bottomnumber}{1}
\setcounter{dbltopnumber}{2}
\setcounter{topnumber}{2}
\setcounter{totalnumber}{4}
\setlength\dblfloatsep    {12pt plus 2pt minus 2pt}
\setlength\dbltextfloatsep{30pt plus 4pt minus 2pt}
\setlength\@dblfpbot{0pt plus 1fil}
\setlength\@dblfpsep{8pt plus 2fil}
\setlength\@dblfptop{0pt plus 1fil}
\setlength\@fpbot{0pt plus 1fil}
\setlength\@fpsep{8pt plus 2fil}
\setlength\@fptop{0pt plus 1fil}
\setlength\floatsep    {12pt plus 2pt minus 2pt}
\setlength\intextsep   {12pt plus 2pt minus 2pt}
\setlength\textfloatsep{30pt plus 4pt minus 2pt}
\setlength\bibindent{1.5em}
\renewenvironment{thebibliography}[1]
     {\section*{\MakeUppercase\refname}
      \AIPbibliographyfont
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \itemsep 0pt plus 1pt\relax
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\renewcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\renewcommand*\@biblabel[1]{#1.}
%77\renewcommand*\@cite[2]{({#1\if@tempswa , #2\fi})}
\renewcommand*\@cite[2]{[{#1\if@tempswa , #2\fi}]}
\endinput
%%
%% End of file `aipproc.cls'.
