% created by Zung based on CRAS Paris style file.

\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\LoadClassWithOptions{article}
%
\textheight 20.5cm \textwidth 15cm
\oddsidemargin 2mm \evensidemargin=\oddsidemargin
\topmargin 3mm \headheight 9mm \headsep 9mm \topskip 1pt
\footskip 9mm
\abovedisplayskip 4pt plus2pt minus2pt
\belowdisplayskip \abovedisplayskip
\abovedisplayshortskip \z@ plus 1pt
\belowdisplayshortskip 2.5pt plus 1pt minus 1.5pt
\parskip 0pt plus 1pt minus 0pt
\parindent 10pt
\topsep 0pt plus 1pt
\partopsep 3pt plus 1pt minus 2pt
\itemsep 0pt
\parsep 3pt plus 1pt minus 1pt
\arraycolsep 5pt \tabcolsep 6pt \arrayrulewidth .4pt
\doublerulesep 2pt
\tabbingsep \labelsep
%
\def\@listI{\leftmargin\leftmargini
     \parsep 1.5pt plus 3pt minus 2pt
      \topsep 1.5pt plus 3pt minus 2pt\itemsep\parsep}
\let\@listi\@listI
%%
\def\ps@myheadings{%
    \def\@oddfoot{\normalsize\hfill\textsf{\thepage}}
    \def\@evenfoot{\normalsize\textsf{\thepage}\hfill\hbox{}}
    \def\@evenhead{\small\textrm{\textbf{\textsf{\@AuteurCourant}}}\hfill}%
    \def\@oddhead{\hfill\small\textrm{\textbf{\textsf{\@TitreCourant}}}}%
    }
\pagestyle{myheadings}
\def\AuteurCourant#1{\gdef\@AuteurCourant{#1}}
\def\TitreCourant#1{\gdef\@TitreCourant{#1}}
%%%%
\def\ComParit#1{\gdef\@ComParit{#1}}
\def\PIT#1{\gdef\@PIT{#1}}
\def\PXMA#1{\gdef\@PXMA{#1}}
\def\Add#1{\gdef\@Add{#1}}
\def\PII{Version: \today}
%
\def\Volume#1{\gdef\@Volume{#1}}
\def\Year#1{\gdef\@Year{#1}}
\def\FirstPage#1{\gdef\@FirstPage{#1}}
\def\LastPage#1{\gdef\@LastPage{#1}}
\def\Journal{\gdef\@Journal{C.~R.~Acad.~Sci.~Paris, t.~\@Volume, S\'erie~I, p.~\@FirstPage--\@LastPage, \@Year}}
\def\Rubrique#1#2{\gdef\@Rubrique{#1/\textit{#2}}}
\def\SousRubrique#1#2{\gdef\@SousRubrique{(#1/\textit{#2})}}
\def\PresentePar#1#2{\gdef\@PresentePar{
     \renewcommand{\thefootnote}{}
     \renewcommand{\footnoterule}{}
     \footnotetext{     \small\textbf{
     \noindent\mbox{}\hspace{-5mm}
     }     
      \vskip2mm
    \noindent\PII \ . \ 
     \hfill \textsf{\normalsize\thepage}}}}
\def\Acknowledgements#1{\par\medskip{\small\textbf{Acknowledgements.}~#1}}
\def\address#1{\gdef\@address{#1}}
\def\Recu#1#2#3{\gdef\@Recu{(Re\c{c}u le~{#1}, accept\'e~{#2} le~{#3})}}
%
\def\@maketitle{%
\begin{flushleft}
  \hbox{}
  \vskip-1cm
  {\small\textsf{\textbf{ }}}
  {\small\textbf{\@PresentePar}\par}\vskip 10mm
  {\baselineskip 18pt\textbf{\LARGE\@title}\par}\vskip4mm
  {\normalsize\textbf{\@author}\par}\vskip3mm
  {\small\textbf{\@address}\par}\vskip3mm
\end{flushleft}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% ABSTRACT  %%%
%%%%%%%%%%%%%%%%%
      \newenvironment{Abstract}[1]%
      {\par\vskip 2mm plus 1mm minus 1mm
      \begin{flushleft}%
      \noindent\hskip2cm\rule{11.5cm}{0.25mm}
      \par\vskip 3mm plus 1mm minus 1mm
      {\hangindent=2cm\hangafter1\rightskip 1.5cm
      \noindent\textsf{\textbf{Abstract.\hskip12pt}}%
      \small\hskip1.5pt #1\
      \par}\vskip 1mm plus .5mm minus .5mm}
      {\end{flushleft}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% TITRE EN FRANCAIS  %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%
      \newenvironment{Ftitle}[1]%
      {\par\vskip 1mm plus .5mm minus .5mm
      \begin{flushleft}
      \hangindent=2cm\hangafter0\rightskip 1.5cm
      \normalsize\textit{\textbf{#1}}
      \par\vskip 2mm plus 1mm minus 1mm
      \par}
      {\end{flushleft}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% RESUME  %%%
%%%%%%%%%%%%%%%%
      \newenvironment{Resume}[1]%
      {\begin{flushleft}%
      {\hangindent=2cm\hangafter1\rightskip 1.5cm
      \noindent\textsf{\textbf{R\'esum\'e.\hskip15.5pt}}%
      \small\hskip1.5pt\textit{#1}\
      \par}      \par\vskip 2mm plus 1mm minus 1mm
      \noindent\hskip2cm\rule{11.5cm}{0.25mm}
      \par\vskip 1mm plus .5mm minus .5mm}
      {\end{flushleft}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% VERSION francaise abregee  %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\AFv{\par\vskip2mm plus 1mm minus 1mm
     \noindent\textbf{\textsf{\textit{Version fran\c{c}aise abr\'eg\'ee}}}
      \par\vskip2mm plus 1mm minus 1mm}
%%%
\renewcommand{\thesection}{\arabic{section}.}
\renewcommand{\theequation}{\arabic{section}.\arabic{equation}}
\newcommand{\Sect}[1]{\renewcommand{\thesection}{\Roman{section}}
 \setcounter{equation}{0} \section{#1}
  \renewcommand{\thesection}{\arabic{section}.}
 }
%%%
\def\thesection{\arabic{section}.}
\def\section{\vspace*{3mm}\@startsection{section}{1}{\z@}%
            {0ex}{1ex plus .3ex minus .3ex}{\bf}}
\def\thesubsection{\arabic{section}.\arabic{subsection}.}
\def\subsection{\vspace*{2mm}\@startsection{subsection}{1}{\z@}%
            {0ex}{1ex plus .3ex minus .3ex}{\bf}}
%
\def\@thmcountersep{}
\def\@begintheorem#1#2{\par\smallskip\textsc{#1}~\textrm{#2}.~~--~~\it}
%
\def\thebibliography#1{\small\par\vskip4mm plus 1mm minus 1mm
\centerline{\normalsize\textbf{References}}
\par\nobreak\list
 {[\arabic{enumi}]}{\settowidth\labelwidth{[#1]}
 \leftmargin\labelwidth\advance\leftmargin\labelsep
 \partopsep 0pt \itemsep 0pt \parsep 0pt
 \usecounter{enumi}}
 \def\newblock{\hskip .11em plus .33em minus -.07em}
 \sloppy
 \sfcode`\.=1000\relax}
\let\endthebibliography=\endlist
%%
\def\demo{\smallskip\goodbreak{\it D\'emonstration.~~--~\kern.3em}
     \ignorespaces}%
\def\qedbox{$\square$}%
\def\qed{\ifmmode\qedbox\else\unskip\ \hglue0mm\hfill
     \qedbox\smallskip\goodbreak\fi}%
\def\enddemo{\qed\goodbreak\vskip6pt}%
\def\proof{\smallskip\goodbreak{\it Proof\/.~~--~\kern.3em}
     \ignorespaces}%
\def\endproof{\qed\goodbreak\vskip6pt}%
%
\endinput
%%
