%%
%% This is file `revtex4.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% revtex4.dtx  (with options: `class,revsymb')
%% REVTeX 4.0 beta 1 - TEST RELEASE
%% ****** Start of file revtex4.dtx ****** %
%%
%%
%%   This file is part of the APS files in the REVTeX 4 distribution.
%%   Version 4.0 beta 1 of REVTeX, March 31, 1999.
%%
%%   Original versions by David Carlisle
%%
%%   Copyright (c) 1999 The American Physical Society.
%%
%%    See the REVTeX 4 README file for restrictions and more information.

%% ****** Start of file revtex4.cls ******
%%
%%
%%   This file is part of the APS files in the REVTeX 4 distribution.
%%   Version 4.0 beta 1 of REVTeX, March 31, 1999.
%%
%%   Original version by David Carlisle
%%
%%   Copyright (c) 1999 The American Physical Society.
%%
%%   See the REVTeX 4 README file for restrictions and more information.
%%
\NeedsTeXFormat{LaTeX2e}[1996/06/01]
\ProvidesClass{revtex4}
          [1999/03/31 v4.0beta 1 RevTeX class (DPC,APS)]

\if@compatibility
  \ifx\every@math@size\@undefined
  \else
    \let\old@expast\@expast
    \def\@expast#1{\old@expast{#1}\let\@tempa\reserved@a}
  \fi
  \input{revtex.sty}
  \expandafter\endinput
\fi
\def\REVTEX@err#1{\ClassError{revtex}{#1}\@eha}
\def\REVTEX@warn#1{\ClassWarningNoLine{revtex}{#1}}
\def\title{\@dblarg\REVTEX@title}
\def\REVTEX@title[#1]#2{%
  \def\@title{#2}%
  \def\@shorttitle{#1}}
\def\@title{\REVTEX@warn{No title}}
\def\@shorttitle{}
\newcounter{affil}
\def\author#1{%
  \ifx\@author\relax
    \REVTEX@addaffils
  \fi
  \move@author
  \def\@author{{}{}{#1}{}}}
\def\move@author{%
  \ifx\@author\relax
  \else
  \if@collaboration
  \@collaborationfalse
  \expandafter\g@addto@macro\expandafter
                 \@curr@authors\expandafter
                     {\expandafter\@docollaboration\@author}%
  \else
  \expandafter\g@addto@macro\expandafter
                 \@curr@authors\expandafter
                     {\expandafter\@doauthor\@author}%
  \fi
  \fi}
\newif\if@collaboration
\def\@docollaboration#1#2#3#4{%
  \par{\let\@affil\@empty\@doauthor{#1}{#2}{(#3)}{#4}}\par}
\def\collaboration#1{%
  \if@groupauthors
  \REVTEX@err{\noexpand\collaboration not allowed with groupaddress
option. Use superscriptaddress instead}
  \else
  \ifx\@author\relax
    \REVTEX@addaffils
  \fi
  \move@author
  \@collaborationtrue
  \def\@author{{}{}{#1}{}}%
 \fi}%
\let\@author\relax
\def\@authors{}
\let\surname\@firstofone
\let\firstname\@firstofone
\def\@curr@authors{}
\def\and{\REVTEX@err{\protect\and\space is not supported}}
\def\noaffiliation{%
  \move@author
  \let\@author\relax
   \edef\@curr@affils{\@curr@affils}}%
\def\affiliation#1{%
  \move@author
  \let\@author\relax
  \def\@tempa{#1}%
  \@tempswatrue
  \run@affils
  \if@tempswa
    \stepcounter{affil}%
    \edef\@tempa##1{%
      \noexpand\g@addto@macro\noexpand\@affils{%
        \noexpand\doaffil{\theaffil}{##1}}}%
    \@tempa{#1}%
    \edef\@curr@affils{\@curr@affils{\theaffil}}%
  \else
    \edef\@curr@affils{\@curr@affils{\@tempc}}%
  \fi}
\def\REVTEX@addaffils{%
    \toks@\expandafter{\@curr@authors}%
    \toks2\expandafter{\@authors}%
    \edef\@authors{%
      \the\toks\tw@\noexpand\set@affil{\@curr@affils}\the\toks@}%
    \begingroup
      \@tempswatrue
      \def\@doaffil@grouped##1{%
        \def\@tempa{##1}%
        \ifx\@curr@affils\@tempa
          \@tempswafalse
        \fi}%
      \@affilgroups
      \let\@doaffil@grouped\relax
      \if@tempswa
        \xdef\@affilgroups{%
          \@affilgroups\@doaffil@grouped{\@curr@affils}}%
      \fi
    \endgroup
    \let\@curr@authors\@empty
    \let\@curr@affils\@empty
  } %\fi}
\let\@affilgroups\@empty
\let\@doaffil@grouped\relax
\let\@affils\@empty
\let\@curr@affils\@empty
\def\doaffil#1#2{%
  \def\@tempb{#2}%
  \ifx\@tempa\@tempb
    \@tempswafalse
    \def\@tempc{#1}%
  \fi}
\def\address{\affiliation}
\def\@join#1#2#3{%
  \if$#2$
      #3%
  \else
      #2#1#3%
   \fi}
\def\@separator{;\space}
\newcommand*\email[2][Electronic address: ]{%
  \expandafter\@add@email\@author{#1\texttt{#2}}}
  \def\@add@email#1#2#3#4#5{%
  \def\@author{{#1}{\@join{\@separator}{#2}{#5}}{#3}{#4}}}
\newcommand*\homepage[2][URL:\space]{%
  \begingroup
  \@makeother\~%
  \@makeother\%%
  \expandafter\@add@url\@author{#1\texttt{#2}}}
\def\@add@url#1#2#3#4#5{%
  \endgroup
  \def\@author{{#1}{\@join{\@separator}{#2}{#5}}{#3}{#4}}}
\def\thanks{%
  \expandafter\@add@thanks\@author}
\def\@add@thanks#1#2#3#4#5{%
  \def\@author{{#1}{\@join{\@separator}{#2}{#5}}{#3}{#4}}}
\newcommand*\altaffiliation[2][]{%
  \expandafter\@add@altaffiliation\@author{#1#2}}
\def\@add@altaffiliation#1#2#3#4#5{%
  \def\@author{{#1}{\@join{\@separator}{#2}{#5}}{#3}{#4}}}
\def\altaddress{\altaffiliation}
\def\@listand{\ifnum\@tempcnta=\tw@\andname\fi\space}
\def\@listcomma{\ifnum\@tempcnta>\@ne,\fi}
  \def\doauthor#1#2#3#4{%
    #3\@listcomma
    \ifx\@affil\@empty\else#4\fi% No affiliation...
    \if$#1#2$\else
     \ifx\@affil\@empty\else\comma@space\fi%
      \author@note{%
       % \ttfamily
          #1%
          \if$#1$%
          \else
            \if$#2$%
            \else
              , %
            \fi
          \fi
          #2}%
    \fi
    \space\@listand}%
\def\set@affil#1{\def\@affil{#1}}
\def\@thanks{\comma@space\footnote}
\def\@doaffil@marked#1#2{%
  \par{\frontmatter@affiliationfont \textsuperscript{\normalfont#1}#2\par}}
\def\@@doaffil@grouped#1{%
  \def\@tempa{#1}%
  \def\set@affil##1{%
    \def\@tempb{##1}%
    \ifx\@tempa\@tempb
      \def\@doauthor{\advance\@tempcnta\@ne\@gobblefour}%
    \else
      \let\@doauthor\@gobblefour
    \fi}%
   \begingroup
   \@tempcnta\z@
   \@authors
  \ifnum\@tempcnta>\z@
     \begingroup
     \ifnum\@tempcnta=\tw@
        \let\@listcomma\relax
     \fi
    \def\set@affil##1{%
      \def\@tempb{##1}%
      \ifx\@tempa\@tempb
        \let\@doauthor\@@doauthor
      \else
        \let\@doauthor\@gobblefour
      \fi}%
    \@authors
    {\parskip-3ex\par}
    \endgroup
    {\frontmatter@affiliationfont
     \let\\\frontmatter@addressnewline
     \if@runinaddress
       \@tempcnta\z@
       \@tfor\@tempa:=#1\do{\advance\@tempcnta\@ne}%
       \ifnum\@tempcnta=\tw@
          \let\@listcomma\relax
       \fi
       \def\after@address{\@listcomma\ \@listand}%
     \else
      \if@tightenlines
      \else
       \parskip 0ex %space between affilations in grouped mode
      \fi
       \let\after@address\par
     \fi
     \let\doaffil\doaffil@group
     \do@affil@fromgroup#1\relax}%
  \fi
  \par
  \endgroup
  \smallskip}
\newif\if@runinaddress
\def\do@affil@fromgroup#1{%
  \ifx\relax#1%
  \else
    \count@#1\relax
    \@affils
    \expandafter\do@affil@fromgroup
  \fi}
\def\doaffil@group#1#2{%
  \ifnum\count@=#1\relax
    #2\after@address\advance\@tempcnta\m@ne
  \fi}
\def\keywords#1{%
  \gdef\@keywords{#1}}
\def\@keywords{}
\def\received#1{%
  \gdef\@received{#1}}
\def\@received{}
\def\revised#1{%
  \gdef\@revised{#1}}
\let\@revised\@empty
\def\accepted#1{%
  \gdef\@accepted{#1}}
\def\@accepted{}
\def\pacs#1{%
  \REVTEX@aftermaketitle{\pacs}%
  \gdef\@pacs{#1}}
\def\@pacs{\REVTEX@warn{No PACS numbers}}
\newbox\absbox
\def\abstract{%
  \REVTEX@aftermaketitle{\begin{abstract}}%
  \lrbox\absbox\minipage{\frontmatter@abstractwidth}%
  \ifpreprintsty
    \if$\abstractname$%
    \else
      \frontmatter@abstractheading
    \fi
  \fi
  \frontmatter@abstractfont}
\def\endabstract{\endminipage\endlrbox}
\def\maketitle{%
 \ifx\@author\relax
   \REVTEX@addaffils
 \else
   \move@author
   \REVTEX@addaffils
    \REVTEX@warn{No affiliation specified for \@author}%
  \fi
  \onecolumn
  {%
  \let\thefootnote\frontmatter@thefootnote
  \let\@makefntex\frontmatter@makefntex
  \frontmatter@setup
  \thispagestyle{title}\label{FirstPage}%
  {\frontmatter@titlefont\@title\par}%
  \addvspace{\frontmatter@belowtitlespace}%
  \global\c@footnote\@ne
  \let\@makefnmark\frontmatter@makefnmark
  \begingroup
  \frontmatter@authorformat
  \if@groupauthors
    \let\@doaffil@grouped\@@doaffil@grouped
    \@affilgroups
  \else
    \let\@tempa\@empty
    \let\set@affil\@gobble
    \def\@doauthor{\advance\@tempcnta\@ne\@gobblefour}%
    \def\@docollaboration{%
      \edef\@tempa{\@tempa{\the\@tempcnta}}%
      \@tempcnta\z@\@gobblefour}%
    \@tempcnta\z@
    \@authors
    \edef\@tempa{\@tempa{\the\@tempcnta}}%
    \reset@authorcount
\baselineskip3ex
    \def\@docollaboration##1##2##3##4{%
      \par\@@doauthor{##1}{##2}{(##3)}{##4}\par\smallskip
      \reset@authorcount}%
    \let\@doauthor\@@doauthor
    \def\set@affil##1{\def\@affil{##1}}%
    \parskip\z@skip
    \@authors
    \smallskip
    \let\doaffil\@doaffil@marked
    \def\\{\newline}%
    \@affils
    \par
  \fi
  \par
  \endgroup
  \par
  \addvspace\frontmatter@preabstractspace
  \leavevmode\box\absbox
  \par
  \addvspace\frontmatter@postabstractspace
  \ifdraft\parbox[t]{\frontmatter@abstractwidth}{\@pacs}\fi
  \@received
  \@revised
  \@accepted
  \par
  \addvspace\frontmatter@finalspace}%
  \suppressfloats[t]%
    \multicol@code
\if@footinbib
 \gdef\footnote{\endnote}
\fi
  \let\and\relax
  \let\affiliation\relax
  \let\author\relax
  \let\@author\relax
  \let\@authors\relax
  \let\@curr@authors
  \let\@affils\relax
  \let\keywords\relax
  \let\@keywords\relax
  \let\address\relax
  \let\email\relax
  \let\@address\relax
  \let\maketitle\relax
  \let\thanks\@gobble
  \global\c@footnote\REVfirstnote
  \if@titlepage
    \clearpage
  \fi}
\def\reset@authorcount{%
  \expandafter\@reset@ac\@tempa0\@reset@ac
  \ifnum\@tempcnta=\tw@
    \let\@listcomma\relax
  \else
    \def\@listcomma{\ifnum\@tempcnta>\@ne,\fi}%
  \fi}
\def\@reset@ac#1#2\@reset@ac{%
  \@tempcnta#1%
  \def\@tempa{#2}}
\chardef\REVfirstnote\z@
\def\frontmatter@thefootnote{\@fnsymbol\c@footnote}%
\long\def\frontmatter@makefntext#1{\parindent 1em\noindent
    \@textsuperscript{\normalfont\@thefnmark}#1}%
\def\frontmatter@setup{\normalfont\centering}
\def\frontmatter@titlefont{\Large\bfseries}
\def\frontmatter@belowtitlespace{2\baselineskip}
\def\frontmatter@makefnmark{\@textsuperscript{\normalfont\@thefnmark}}%
\let\frontmatter@authorformat\centering
\def\frontmatter@affiliationfont{\small\it}
\def\frontmatter@abstractheading{%
  \ifpreprintsty
    \begin{center}\large\abstractname\end{center}%
    \vspace{-1pc}%
  \fi}
\def\frontmatter@abstractfont{%
  \small}
\def\frontmatter@abstractfont{%
  \small}
\def\frontmatter@abstractwidth{.75\textwidth}
\def\frontmatter@preabstractspace{.5\baselineskip}
\def\frontmatter@postabstractspace{.5\baselineskip}
\def\frontmatter@finalspace{2\baselineskip}
\def\frontmatter@addressnewline{%
  \vskip-.5ex}% was \newline space between lines of addresss
\def\REVTEX@aftermaketitle#1{%
  \ifx\maketitle\relax
    \REVTEX@err{\protect#1 must be used before \protect\maketitle}%
  \fi}
\def\ps@title{%
  \ifpreprintsty
    \def\@oddhead{\hfill\vtop to \z@{%
      \def\baselinestretch{1}\small\@preprint\par\vss}}%
  \else
    \let\@oddhead\@empty
  \fi
  \let\@evenhead\@oddhead
  \let\@oddfoot\@empty
  \let\@evenfoot\@empty}
\def\@volumeyear{????}
\def\@volumenumber{??}
\def\@issuenumber{??}
\def\@startpage{\pageref{FirstPage}}
\def\@endpage{\pageref{LastPage}}
\def\volumeyear#1{\gdef\@volumeyear{#1}}
\def\volumenumber#1{\gdef\@volumenumber{#1}}
\def\issuenumber#1{\gdef\@issuenumber{#1}}
\def\startpage#1{\gdef\@startpage{#1}\c@page#1}
\def\endpage#1{\gdef\@endpage{#1}}
\newif\if@groupauthors

\def\rtx@bibnote#1{%
  \protected@xdef\@thefnmark{\thempfn}%
  \protected@xdef\@@thefnmark{\textsuperscript{\normalfont\thempfn}}%
  \@footnotemark
  \stepcounter\@mpfn
  \expandafter
  \g@addto@macro
  \expandafter\@bibnotes\expandafter
           {\expandafter\item\expandafter[\@@thefnmark]#1\par}}
\let\@bibnotes\@empty
\def\endnote{\@ifnextchar[\@xendnote{\stepcounter{footnote}%
     \protected@xdef\@thefnmark{\thefootnote}%
     \@footnotemark\@endnotetext}}
\def\@xendnote[#1]{%
   \begingroup
     \c@footnote #1\relax
     \unrestored@protected@xdef\@thefnmark{\thefootnote}%
   \endgroup
   \@footnotemark\@endnotetext}
\newwrite\@@endnoteout
\long\def\@endnotetext#1{%
  \ifx\@endnoteout\@undefined
    \global\let\@endnoteout\@@endnoteout
    \immediate\openout\@endnoteout=\jobname.end
  \fi
     \begingroup
     \let\protect\noexpand
     \newlinechar`\ %
     \immediate\write\@endnoteout{\noexpand\REVdoendnote{\@thefnmark} {#1}}%
     \endgroup}
\def\endnotetext{%
     \@ifnextchar [\@xendnotenext
       {\protected@xdef\@thefnmark{\thefootnote}%
    \@endnotetext}}
\def\@xendnotenext[#1]{%
  \begingroup
     \c@footnote#1\relax
     \unrestored@protected@xdef\@thefnmark{\thefootnote}%
  \endgroup
  \@endnotetext}
\def\printendnotes{%
  \section*{\notesname}%
  \ifx\@endnoteout\@undefined
  \else
    \immediate\closeout\@endnoteout
    \global\let\@endnoteout\@undefined
    \begin{enumerate}%
    \input{\jobname.end}%
    \end{enumerate}
  \fi}
\let\@endnotesinbib\relax
\def\endnotesinbibliography{%
  \let\printendnotes\relax
  \def\@endnotesinbib{%
  \ifnum\REVfirstnote=\c@enumiv
  \else
   \REVTEX@warn{Endnote numbers changed: rerun LaTeX}%
  \fi
  \immediate\write\@mainaux{%
    \global\chardef\string\REVfirstnote\the\c@enumiv\relax}%
  \ifx\@endnoteout\@undefined
  \else
    \immediate\closeout\@endnoteout
    \global\let\@endnoteout\@undefined
    \input{\jobname.end}
  \fi
}}
\def\notesname{Notes}
\def\REVdoendnote#1#2{\bibitem{endnote#1}#2}
\let\@bibnotes\@empty
\def\author@note{\footnote}

\DeclareOption{10pt}{\def\@pointsize{10}}
\DeclareOption{11pt}{\def\@pointsize{11}}
\DeclareOption{12pt}{\def\@pointsize{12}}
\DeclareOption{a4paper}{\REVTEX@warn{\CurrentOption\space ignored}}
\DeclareOption{letterpaper}{\REVTEX@warn{\CurrentOption\space ignored}}
\DeclareOption{bibnotes}{\def\author@note{\rtx@bibnote}}
\newif\if@footinbib
\DeclareOption{footinbib}{\@footinbibtrue\endnotesinbibliography}
\newcommand*{\place@bibnumber}[1]{[#1]}
\DeclareOption{superbib}{\renewcommand*{\place@bibnumber}[1]{\textsuperscript{#1}}}
\DeclareOption{twoside}{\@twosidetrue \@mparswitchfalse}
\DeclareOption{oneside}{\@twosidefalse \@mparswitchtrue}
\let\multicol@code\relax
\DeclareOption{twocolumn}{%
  \@twocolumntrue
  \AtEndDocument{\end{multicols}\hfuzz\maxdimen}%
  \def\multicol@code{%
    \@twocolumntrue
    \begin{multicols}{2}}%
  \AtEndOfClass{%
    \let\REVTEX@tempa\@classoptionslist
    \let\@classoptionslist\@empty
    \RequirePackage{multicol}%
    \let\@classoptionslist\REVTEX@tempa
    }}
\DeclareOption{onecolumn}{%
  \@twocolumnfalse}
\DeclareOption{galley}{%
  \@twocolumnfalse
  \AtEndOfClass{%
    \advance\textwidth-\columnsep
    \textwidth.5\textwidth}}
\newif\ifpreprintsty
\DeclareOption{preprint}{%
  \preprintstytrue
  \let\@preprint\@empty
  \def\@pointsize{12}}
\DeclareOption{hyper}{%
  \AtEndOfClass{%
    \let\@clsextension\@empty
    \RequirePackage{hyperref}%
    \def\@clsextension{cls}}%
  \def\@pointsize{10}}
\DeclareOption{manuscript}{\ExecuteOptions{preprint}}
\newif\if@tightenlines
\DeclareOption{tightenlines}{\@tightenlinestrue}
\DeclareOption{draft}{\overfullrule 5\p@}
\DeclareOption{final}{}
\newif\ifsecnumbers
\DeclareOption{eqsecnum}{\secnumberstrue}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\newif\if@floats
\DeclareOption{floats}{\@floatstrue}
\DeclareOption{endfloats}{\@floatsfalse}
\newif\if@titlepage
\DeclareOption{titlepage}{\@titlepagetrue}
\DeclareOption{notitlepage}{\@titlepagefalse}
\DeclareOption{pra}{\def\@society{aps}\def\@journal{pra}}
\DeclareOption{prb}{\def\@society{aps}\def\@journal{prb}}
\DeclareOption{prc}{\def\@society{aps}\def\@journal{prc}}
\DeclareOption{prd}{\def\@society{aps}\def\@journal{prd}}
\DeclareOption{pre}{\def\@society{aps}\def\@journal{pre}}
\DeclareOption{prl}{\def\@society{aps}\def\@journal{prl}}
\DeclareOption{josaa}{\def\@society{osa}\def\@journal{josaa}}
\DeclareOption{josab}{\def\@society{osa}\def\@journal{josab}}
\DeclareOption{aplop}{\def\@society{aps}\def\@journal{aplop}}
\def\@inputrtx{\input{\@society.rtx}}
\DeclareOption{aps}{\def\@society{aps}}
\DeclareOption{osa}{\def\@society{osa}}
\DeclareOption{amsfonts}{%
  \def\REVTEX@amsfonts{\RequirePackage{amsfonts}}}
\DeclareOption{noamsfonts}{%
  \let\REVTEX@amsfonts\relax}
\DeclareOption{amssymb}{%
  \def\REVTEX@amssymb{\RequirePackage{amssymb}}}
\DeclareOption{noamssymb}{%
  \let\REVTEX@amssymb\relax}
\def\run@affils{\@affils}
\DeclareOption{groupedaddress}{\@groupauthorstrue}
\DeclareOption{unsortedaddress}{\@groupauthorstrue\let\run@affils\relax}
\DeclareOption{runinaddress}{\@groupauthorstrue\@runinaddresstrue}
\DeclareOption{superscriptaddress}{\@groupauthorsfalse}
\DeclareOption*{%
  \IfFileExists{\CurrentOption.rtx}%
        {\let\@society\CurrentOption}
        \OptionNotUsed}%
\ExecuteOptions{10pt,noamsfonts,noamssymb,groupauthors}
\ProcessOptions*
\if@twoside %
  \def\ps@headings{%
    \let\@mkboth\markboth
    \let\@oddfoot\@empty
    \let\@evenfoot\@empty
    \def\@evenhead{\thepage\hfil \slshape \leftmark}%
    \def\@oddhead{{\slshape \rightmark}\hfil \thepage}%
    \def\sectionmark##1{%
      \markboth {\MakeTextUppercase{%
        \ifnum \c@secnumdepth >\z@\thesection\hskip 1em\relax \fi
         ##1}}{}}%
    \def\subsectionmark##1{%
      \markright {%
        \ifnum \c@secnumdepth >\@ne \thesubsection\hskip 1em\relax \fi
         ##1}}}
\else
  \def\ps@headings{%
    \let\@mkboth\markboth
    \let\@oddfoot\@empty
    \let\@evenfoot\@empty
    \def\@oddhead{{\slshape \rightmark}\hfil\thepage}%
    \def\sectionmark##1{\markright {\MakeTextUppercase{%
      \ifnum \c@secnumdepth >\z@ \thesection\hskip 1em\relax \fi
      ##1}}}}
\fi
\def\ps@myheadings{%
  \let\@mkboth\@gobbletwo
  \def\@oddhead{{\slshape\rightmark}\hfil \thepage}%
  \let\@oddfoot\@empty
  \def\@evenhead{\thepage\hfil\slshape\leftmark}%
  \let\@evenfoot\@empty
  \let\sectionmark\@gobble
  \let\subsectionmark\@gobble}
\def\lastpage@putlabel{%
  \advance\c@page\m@ne
   \immediate\write\@auxout{\string
   \newlabel{LastPage}{{}{\thepage}}}%
   \advance\c@page\@ne}
\AtEndDocument{%
  \clearpage\lastpage@putlabel}%
\if@groupauthors
  \def\@@doauthor#1#2#3#4{%
    \gdef\comma@space{\gdef\comma@space{\textsuperscript{,\,}}}%
    \doauthor{#1}{#2}{#3}{#4}%
    \advance\@tempcnta\m@ne}
\else
  \def\@@doauthor#1#2#3#4{%
    \gdef\comma@space{\textsuperscript{,\,}}%
    \doauthor{#1}{#2}{#3}{%
      \textsuperscript{\expandafter\@affilcomma\@affil\relax\relax}#4}%
    \advance\@tempcnta\m@ne}
    \def\@affilcomma#1#2{%
      #1%
      \ifx\relax#2%
      \else
        ,\,%
        \expandafter\@affilcomma
      \fi
      #2}
\fi
\if@groupauthors
  \def\@tempaffil#1#2{%
    \def\@tempc{#1}%
   {\def\doaffil##1##2{%
      \def\@tempa{##1}%
    \ifx\@tempa\@tempc
      \comma@space
      \footnote{#2##2}%
   \fi}%
  \@affils}}%
\else
  \def\@tempaffil#1#2{%
    ,\,#1}
\fi
\def\partname{Part}
\def\contentsname{Contents}
\def\listfigurename{List of Figures}
\def\listtablename{List of Tables}
\def\refname{REFERENCES}
\def\indexname{Index}
\def\figurename{FIG.}
\def\tablename{TABLE}
\def\abstractname{Abstract}
\def\@alph#1{\ifcase#1\or a\or b\or c\or d\else\@ialph{#1}\fi}
\def\@ialph#1{\ifcase#1\or \or \or \or \or e\or f\or g\or h\or i\or j\or
  k\or l\or m\or n\or o\or p\or q\or r\or s\or t\or u\or v\or w\or x\or
  y\or z\or aa\or bb\or cc\or dd\or ee\or ff\or gg\or hh\or ii\or jj\or
  kk\or ll\or mm\or nn\or oo\or pp\or qq\or rr\or ss\or tt\or uu\or
  vv\or ww\or xx\or yy\or zz\else\@ctrerr\fi}
\def\@fnsymbol#1{\ensuremath{\ifcase#1\or *\or \dagger\or \ddagger\or
  \mathchar "278\or **\or \dagger\dagger
  \or \ddagger\ddagger \or \mathsection \mathsection\or
  *{*}*\or\dagger\dagger\dagger\or\ddagger\ddagger\ddagger\or
  \mathsection \mathsection \mathsection
  \else\@ctrerr\fi}}
\def\labelenumi{\theenumi.}
\def\theenumi{\arabic{enumi}}
\def\labelenumii{(\theenumii)}
\def\theenumii{\alph{enumii}}
\def\p@enumii{\theenumi}
\def\labelenumiii{\theenumiii.}
\def\theenumiii{\roman{enumiii}}
\def\p@enumiii{\theenumi(\theenumii)}
\def\labelenumiv{\theenumiv.}
\def\theenumiv{\Alph{enumiv}}
\def\p@enumiv{\p@enumiii\theenumiii}
\def\labelitemi{\textbullet}
\def\labelitemii{\normalfont\bfseries\textendash}
\def\labelitemiii{\textasteriskcentered}
\def\labelitemiv{\textperiodcentered}
\pagenumbering{arabic}
\setcounter{topnumber}{2}
\def\topfraction{.7}
\setcounter{bottomnumber}{1}
\def\bottomfraction{.3}
\setcounter{totalnumber}{3}
\def\textfraction{.2}
\def\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\def\dbltopfraction{.7}
\def\dblfloatpagefraction{.5}
\def\verse{%
  \let\\=\@centercr
  \list{}{%
    \itemsep\z@ \itemindent -1.5em\listparindent \itemindent
    \rightmargin\leftmargin\advance\leftmargin 1.5em}\item[]}
\let\endverse\endlist
\def\quotation{%
  \list{}{%
    \listparindent 1.5em
    \itemindent\listparindent
    \rightmargin\leftmargin \parsep \z@ \@plus\p@}\item[]}
\let\endquotation=\endlist
\def\quote{%
  \list{}{%
  \rightmargin\leftmargin}\item[]}
\let\endquote=\endlist
\def\descriptionlabel#1{%
  \hspace\labelsep \normalfont\bfseries #1}
\def\description{%
  \list{}{%
    \labelwidth\z@ \itemindent-\leftmargin
    \let\makelabel\descriptionlabel}}
\let\enddescription\endlist
\newenvironment{titlepage}
    {%
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\long\def\@footnotetext#1{\insert\footins{%
    \def\baselinestretch{1}%
    \reset@font\footnotesize
    \interlinepenalty\interfootnotelinepenalty
    \splittopskip\footnotesep
    \splitmaxdepth \dp\strutbox \floatingpenalty \@MM
    \hsize\columnwidth \@parboxrestore
    \protected@edef\@currentlabel{%
       \csname p@footnote\endcsname\@thefnmark
    }%
    \color@begingroup
      \@makefntext{%
        \rule\z@\footnotesep\ignorespaces#1\@finalstrut\strutbox}%
    \color@endgroup}}%
\newcounter{part}
\newcounter{section}
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]
\newcounter{paragraph}[subsubsection]
\newcounter{subparagraph}[paragraph]
\def\thepart          {\Roman{part}} %
\def\thesection       {\Roman{section}}
\def\p@section        {}
\def\thesubsection    {\Alph{subsection}}
\def\p@subsection     {\thesection\,}
\def\thesubsubsection {\arabic{subsubsection}}
\def\p@subsubsection  {\thesection\,\thesubsection\,}
\def\theparagraph     {\alph{paragraph}}
\def\thesubparagraph  {\theparagraph.\arabic{subparagraph}}
\def\acknowledgments{\section*{ACKNOWLEDGMENTS}}
\let\acknowledgements\acknowledgments
\def\part{\par
   \addvspace{4ex}
   \@afterindentfalse
   \secdef\@part\@spart}
\def\@part[#1]#2{\ifnum \c@secnumdepth >\m@ne
        \refstepcounter{part}
        \addcontentsline{toc}{part}{\thepart
        \hspace{1em}#1}\else
      \addcontentsline{toc}{part}{#1}\fi
   {\parindent \z@ \raggedright
    \interlinepenalty\@M
    \ifnum \c@secnumdepth >\m@ne
      \Large \bf \partname~\thepart%
      \par\nobreak
    \fi
    \huge \bf
    #2%
    \markboth{}{}\par
   }\nobreak
   \vskip 3ex
   \@afterheading}
\def\@spart#1{{\parindent \z@ \raggedright
    \interlinepenalty\@M
    \huge \bf
    #1\par}
    \nobreak
    \vskip 3ex
    \@afterheading}
\def\section{%
  \@startsection
    {section}%
    {1}%
    {\z@}%
    {0.8cm \@plus1ex \@minus .2ex}%
    {0.5cm \@plus1ex \@minus.2ex}%
    {\normalfont\small\bfseries\centering\MakeTextUppercase}}
\def\subsection{%
  \@startsection
    {subsection}%
    {2}%
    {\z@}%
    {.8cm \@plus1ex \@minus .2ex}%
    {.5cm \@plus1ex \@minus.2ex}%
    {\normalfont\small\bfseries\centering}}
\def\subsubsection{%
  \@startsection
    {subsubsection}%
    {3}%
    {\z@}%
    {.8cm \@plus1ex \@minus .2ex}%
    {.5cm \@plus1ex \@minus.2ex}%
    {\normalfont\small\itshape\centering}}
\def\paragraph{%
  \@startsection
    {paragraph}%
    {4}%
    {\parindent}%
    {\z@}%
    {-1em}%
    {\normalfont\normalsize\itshape}}
\def\subparagraph{%
  \@startsection
    {subparagraph}%
    {5}%
    {\parindent}%
    {3.25ex \@plus1ex \@minus .2ex}%
    {-1em}%
    {\normalfont\normalsize\bfseries}}
\ifnum\@pointsize=10
\def\@tempa{prl}
\ifx\@journal\@tempa
  \def\normalsize{%
    \@setfontsize\normalsize\@xpt\@xiipt
    \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
    \belowdisplayskip \abovedisplayskip
    \abovedisplayshortskip  \abovedisplayskip
    \belowdisplayshortskip \abovedisplayskip
    \let\@listi\@listI}
\else
  \def\normalsize{%
    \@setfontsize\normalsize\@xpt{11.5}%
    \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
    \belowdisplayskip \abovedisplayskip
    \abovedisplayshortskip  \abovedisplayskip
    \belowdisplayshortskip \abovedisplayskip
    \let\@listi\@listI}
\fi
\def\small{%
  \@setfontsize\small\@ixpt{11}%
  \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
  \belowdisplayskip \abovedisplayskip
  \abovedisplayshortskip \z@ \@plus2\p@
  \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
  \def\@listi{%
    \leftmargin\leftmargini
    \topsep 4\p@ \@plus2\p@ \@minus2\p@
    \parsep 2\p@ \@plus\p@ \@minus\p@
    \itemsep \parsep}}
\def\footnotesize{%
  \@setfontsize\footnotesize\@viiipt{9.5pt}%
  \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
  \belowdisplayskip \abovedisplayskip
  \abovedisplayshortskip \z@ \@plus\p@
  \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
  \def\@listi{%
    \leftmargin\leftmargini
    \topsep 3\p@ \@plus\p@ \@minus\p@
    \parsep 2\p@ \@plus\p@ \@minus\p@
    \itemsep \parsep}}
\def\scriptsize{%
  \@setfontsize\scriptsize\@viipt\@viiipt}
\def\tiny{%
  \@setfontsize\tiny\@vpt\@vipt}
\def\large{%
  \@setfontsize\large\@xiipt{14pt}}
\def\Large{%
  \@setfontsize\Large\@xivpt{18pt}}
\def\LARGE{%
  \@setfontsize\LARGE\@xviipt{22pt}}
\def\huge{%
    \@setfontsize\huge\@xxpt{25pt}}
\def\Huge{%
  \@setfontsize\Huge\@xxvpt{30pt}}
\fi
\ifnum\@pointsize=11
\def\normalsize{%
    \@setfontsize\normalsize\@xipt{13.6}%
    \abovedisplayskip 11\p@ \@plus3\p@ \@minus6\p@
    \belowdisplayskip \abovedisplayskip
    \abovedisplayshortskip  \abovedisplayskip
    \belowdisplayshortskip \abovedisplayskip
    \let\@listi\@listI}
\def\small{%
   \@setfontsize\small\@xpt\@xiipt
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 6\p@ \@plus2\p@ \@minus2\p@
               \parsep 3\p@ \@plus2\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip}
\def\footnotesize{%
   \@setfontsize\footnotesize\@ixpt{11}%
   \abovedisplayskip 8\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip}
\def\scriptsize{%
  \@setfontsize\scriptsize\@viiipt{9.5}}
\def\tiny{%
  \@setfontsize\tiny\@vipt\@viipt}
\def\large{%
  \@setfontsize\large\@xiipt{14}}
\def\Large{%
  \@setfontsize\Large\@xivpt{18}}
\def\LARGE{%
  \@setfontsize\LARGE\@xviipt{22}}
\def\huge{%
    \@setfontsize\huge\@xxpt{25pt}}
\def\Huge{%
  \@setfontsize\Huge\@xxvpt{30pt}}
\fi
\ifnum\@pointsize=12
\def\normalsize{%
  \@setfontsize\normalsize\@xiipt{14pt}%
  \abovedisplayskip 12\p@ \@plus3\p@ \@minus7\p@
  \belowdisplayskip \abovedisplayskip
  \abovedisplayshortskip  \z@ plus3\p@
  \belowdisplayshortskip  6.5\p@ \@plus3.5\p@ \@minus3\p@
  \let\@listi\@listI}
\def\small{%
  \@setfontsize\small\@xipt{14.5pt}%
  \abovedisplayskip 811\p@ \@plus3\p@ \@minus6\p@
  \belowdisplayskip \abovedisplayskip
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
  \def\@listi{%
    \leftmargin\leftmargini
    \topsep 9\p@ \@plus3\p@ \@minus5\p@
    \parsep 4.5\p@ \@plus2\p@ \@minus\p@
    \itemsep \parsep}}
\def\footnotesize{%
  \@setfontsize\footnotesize\@xpt{14.5pt}%
  \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
  \belowdisplayskip \abovedisplayskip
  \abovedisplayshortskip \z@ \@plus3\p@
  \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
  \def\@listi{%
    \leftmargin\leftmargini
    \topsep 6\p@ \@plus2\p@ \@minus2\p@
    \parsep 3\p@ \@plus2\p@ \@minus\p@
    \itemsep \parsep}}
\def\scriptsize{%
  \@setfontsize\scriptsize\@viiipt{9.5pt}}
\def\tiny{%
  \@setfontsize\tiny\@vipt{7pt}}
\def\large{%
  \@setfontsize\large\@xivpt{18pt}}
\def\Large{%
  \@setfontsize\Large\@xviipt{22pt}}
\def\LARGE{%
  \@setfontsize\LARGE\@xxpt{25pt}}
\def\huge{%
    \@setfontsize\huge\@xxv{30pt}}
\let\Huge=\huge
\fi
\setcounter{secnumdepth}{4}
\lineskip 1pt
\normallineskip 1pt
\def\baselinestretch{1}
\normalsize
\ifnum\@pointsize=10
  \if@twoside
    \oddsidemargin  -.4in
    \evensidemargin -.1in
    \marginparwidth 107pt
  \else
    \oddsidemargin  -.25in
    \evensidemargin -.25in
    \marginparwidth 30pt
  \fi
  \marginparsep 6pt
  \topmargin -61pt
  \headheight 25pt
  \headsep 16pt
  \topskip 10pt
  \footskip 30pt
  \def\@tempa{prl}
   \ifx\@journal\@tempa
     \textheight = 55\baselineskip
    \else
      \textheight = 57\baselineskip
    \fi
  \advance\textheight by \topskip
  \textwidth42.5pc
  \columnsep 1.5pc
  \columnseprule 0pt
  \footnotesep 1pt
  \skip\footins 39pt plus 4pt minus 2pt
  \def\footnoterule{\kern-19pt\hrule width.5in\kern18.6pt}
  \floatsep 12pt plus 2pt minus 2pt
  \textfloatsep 20pt plus 2pt minus 4pt
  \intextsep 12pt plus 2pt minus 2pt
  \dblfloatsep 12pt plus 2pt minus 2pt
  \dbltextfloatsep 20pt plus 2pt minus 4pt
  \@fptop 0pt plus 1fil
  \@fpsep 8pt plus 2fil
  \@fpbot 0pt plus 1fil
  \@dblfptop 0pt plus 1fil
  \@dblfpsep 8pt plus 2fil
  \@dblfpbot 0pt plus 1fil
  \marginparpush 5pt
  \parskip 0pt plus 1pt
  \parindent 1em
  \partopsep 2pt plus 1pt minus 1pt
  \leftmargini 25pt
  \leftmarginii 22pt
  \leftmarginiii 18.7pt
  \leftmarginiv 17pt
  \leftmarginv 10pt
  \leftmarginvi 10pt
  \leftmargin\leftmargini
  \labelsep 4pt
  \labelwidth\leftmargini
  \advance\labelwidth-\labelsep
  \def\@listI{%
    \leftmargin\leftmargini
    \parsep 4\p@ plus2\p@ minus\p@
    \topsep 8\p@ plus2\p@ minus4\p@
    \itemsep 4\p@ plus2\p@ minus\p@}
  \let\@listi\@listI
  \@listi
  \def\@listii{%
    \leftmargin\leftmarginii
    \labelwidth\leftmarginii
    \advance\labelwidth-\labelsep
    \topsep 4\p@ plus2\p@ minus\p@
    \parsep 2\p@ plus\p@ minus\p@
    \itemsep \parsep}
  \def\@listiii{%
    \leftmargin\leftmarginiii
    \labelwidth\leftmarginiii
    \advance\labelwidth-\labelsep
    \topsep 2\p@ plus\p@ minus\p@
    \parsep \z@
    \partopsep \p@ plus\z@ minus\p@
    \itemsep \topsep}
  \def\@listiv{%
    \leftmargin\leftmarginiv
    \labelwidth\leftmarginiv
    \advance\labelwidth-\labelsep}
  \def\@listv{%
    \leftmargin\leftmarginv
    \labelwidth\leftmarginv
    \advance\labelwidth-\labelsep}
  \def\@listvi{%
    \leftmargin\leftmarginvi
    \labelwidth\leftmarginvi
    \advance\labelwidth-\labelsep}
\fi
\ifnum 11=\ifnum\@pointsize=12 11\else\@pointsize\fi
  \if@tightenlines
  \else
    \linespread{1.655}\normalfont
  \fi
  \if@twoside
    \oddsidemargin .25in
    \evensidemargin -.25in
    \marginparwidth 60pt
  \else
    \oddsidemargin 0pt
    \evensidemargin 0pt
    \marginparwidth 44pt
  \fi
  \marginparsep 10pt
  \topmargin -37pt
  \headheight 12pt
  \headsep 25pt
  \topskip 10pt
  \footskip 30pt
  \if@tightenlines
    \textheight = 44\baselineskip
  \else
    \textheight = 27\baselineskip
  \fi
  \advance\textheight by \topskip
  \textwidth 468pt
  \columnsep 10pt
  \columnseprule 0pt
  \footnotesep 1pt
  \skip\footins 25.25pt plus 4pt minus 2pt
  \def\footnoterule{\kern-5.25pt\hrule width.5in\kern4.85pt}
  \floatsep 14pt plus 2pt minus 4pt
  \textfloatsep 20pt plus 2pt minus 4pt
  \intextsep 14pt plus 4pt minus 4pt
  \dblfloatsep 14pt plus 2pt minus 4pt
  \dbltextfloatsep 20pt plus 2pt minus 4pt
  \@fptop 0pt plus 1fil
  \@fpsep 10pt plus 2fil
  \@fpbot 0pt plus 1fil
  \@dblfptop 0pt plus 1fil
  \@dblfpsep 10pt plus 2fil%
  \@dblfpbot 0pt plus 1fil
\marginparpush 7pt
  \parskip 0pt plus 1pt
  \parindent 1.5em
  \partopsep 3pt plus 2pt minus 2pt
  \leftmargini 2.5em
  \leftmarginii 2.2em
  \leftmarginiii 1.87em
  \leftmarginiv 1.7em
  \leftmarginv 1em
  \leftmarginvi 1em
  \leftmargin\leftmargini
  \labelsep .5em
  \labelwidth\leftmargini\advance\labelwidth-\labelsep
  \def\@listI{\leftmargin\leftmargini \parsep 5\p@ plus2.5\p@ minus\p@
  \topsep 10\p@ plus4\p@ minus6\p@
  \itemsep 5\p@ plus2.5\p@ minus\p@}
  \let\@listi\@listI
  \@listi
  \def\@listii{\leftmargin\leftmarginii
  \labelwidth\leftmarginii\advance\labelwidth-\labelsep
  \topsep 5\p@ plus2.5\p@ minus\p@
  \parsep 2.5\p@ plus\p@ minus\p@
  \itemsep \parsep}
  \def\@listiii{\leftmargin\leftmarginiii
  \labelwidth\leftmarginiii\advance\labelwidth-\labelsep
  \topsep 2.5\p@ plus\p@ minus\p@
  \parsep \z@ \partopsep \p@ plus\z@ minus\p@
  \itemsep \topsep}
  \def\@listiv{\leftmargin\leftmarginiv
  \labelwidth\leftmarginiv\advance\labelwidth-\labelsep}
  \def\@listv{\leftmargin\leftmarginv
  \labelwidth\leftmarginv\advance\labelwidth-\labelsep}
  \def\@listvi{\leftmargin\leftmarginvi
  \labelwidth\leftmarginvi\advance\labelwidth-\labelsep}
\fi
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\arraycolsep 3pt
\tabcolsep 2pt
\arrayrulewidth .4pt
\doublerulesep 2pt
\tabbingsep \labelsep
\skip\@mpfootins = \skip\footins
\fboxsep = 3pt
\fboxrule = .4pt
\newif\ifappendixon
\def\appendix{%
  \par
  \appendixontrue
  \setcounter{section}\z@
  \setcounter{subsection}\z@
  \setcounter{subsubsection}\z@
  \def\thesection{\Alph{section}}%
  \def\thesubsection{\arabic{subsection}}%
  \def\thesubsubsection{\alph{subsubsection}}%
  \def\theequation@prefix{\thesection}%
  \@addtoreset{equation}{section}%
  \addcontentsline{toc}{section}{%
     \protect\numberline{%
       APPENDIXES\hskip\z@\@plus1fill \@minus1fill\relax}}}
\if@twocolumn
  \def\widetext{%
    \endgroup
    \def\@tempa{multicols}%
    \ifx\@currenvir\@tempa
      \end{multicols}%
    \else
      \REVTEX@err{%
        widetext environment must not be inside any environment: \@currenvir}%
      \def\endwidetext{\begingroup\def\@currenvir{widetext}}%
    \fi}%
  \def\endwidetext{%
    \begin{multicols}{2}%
    \begingroup
    \def\@currenvir{widetext}}
\else
  \ifpreprintsty
    \def\widetext{\par\ignorespaces}
    \def\endwidetext{\par\global\@ignoretrue}
  \else
\newenvironment{widetext}
               {\list{}{\listparindent \parindent
                        \itemindent    \parindent
                         \leftmargin   \z@
                        \rightmargin   -\columnwidth
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
  \fi
\fi
\global\let\ifdraft\iffalse
\def\draft{\global\let\ifdraft\iftrue}
\def\preprint#1{%
  \ifpreprintsty
    \g@addto@macro\@preprint{\hbox{#1}}%
  \fi}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\def\journalname{??}
\def\copyrightname{??}
\def\andname{and}
\def\ppname{pp}
\def\numbername{number}
\def\volumename{volume}
\ps@plain
\pagenumbering{arabic}
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \raggedbottom
\else
  \sloppy
  \onecolumn
  \raggedbottom
\fi
\def\eqnum#1{%
  \REVTEX@err{use \noexpand\tag from amsmath package}\@eha}
\def\mathletters{%
  \REVTEX@err{use {subequations} from amsmath package}\@eha}
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newenvironment{thebibliography}[1]
     {\section*{\refname
        \@mkboth
          {\MakeTextUppercase\refname}%
          {\MakeTextUppercase\refname}}%
      \list{\place@bibnumber{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#1}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
\itemsep 0pt
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m
      \@bibnotes}
     {%
      \@endnotesinbib
      \def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\def\references{\thebibliography{xxxxxxx}}
\let\endreferences\endthebibliography
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{10\p@}
\setlength\belowcaptionskip{0\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\newcounter{figure}
\renewcommand \thefigure {\@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\let\REVTEX@xfloat\@xfloat
\def\@xfloat#1[#2]{%
  \def\@mpfn{mpfootnote}\def\thempfn{\thempfootnote}\c@mpfootnote\z@
  \let\@footnotetext\@mpfootnotetext
  \def\@makefntext##1{%
    \parindent 1em%
    \noindent
    \hb@xt@1em{\hss\@makefnmark}##1}%
  \if@twocolumn
   \par
   \addvspace\intextsep
   \vbox\bgroup
   \def\@captype{#1}%
   \def\end@float{%
     \minipagefootnotes
     \egroup
     \par
     \addvspace\intextsep}%
  \else
      \REVTEX@xfloat#1[#2]%
      \def\@mpfn{mpfootnote}\def\thempfn{\thempfootnote}\c@mpfootnote\z@
      \let\@footnotetext\@mpfootnotetext
  \fi}
\let\REVTEX@end@float\end@float
\def\minipagefootnotes{%
    \par
    \ifvoid\@mpfootins\else
      \unvbox\@mpfootins
    \fi}
\let\REVTEX@caption\caption
\def\caption{%
  \minipagefootnotes
  \REVTEX@caption}
\def\end@float{%
  \minipagefootnotes
  \REVTEX@end@float}
\def\write@float#1{%
  \ifhmode
     \@bsphack
  \fi
  \chardef\@tempc\csname#1write\endcsname
  \immediate\write\@tempc{^^J\string\begin{#1}}%
  \def\@tempb{\end{#1}}%
  \catcode`\^^M\active
  \write@floatline}
{\catcode`\^^M\active%
\gdef\write@floatline#1^^M{%
  \toks@{#1}%
  \immediate\write\@tempc{\the\toks@}%
  \def\@tempa{#1}%
  \ifx\@tempa\@tempb%
  \expandafter\@tempa%
  \else%
  \expandafter\write@floatline%
  \fi}%
}%
\def\end@writefloat{\@Esphack}
\if@floats
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\let\printfigures\relax
\else
  \newwrite\figurewrite
  \immediate\openout\figurewrite=\jobname.fgx
  \def\figure{\write@float{figure}}
  \let\endfigure\end@writefloat
\def\printfigures{%
  \immediate\closeout\figurewrite
  \renewenvironment{figure}
               {\@twocolumntrue\@float{figure}}
               {\end@float}
  \def\endfigure{\egroup}%
  \section{FIGURES}%
  \raggedbottom
  \input{\jobname.fgx}}
\fi
\newcounter{table}
\renewcommand\thetable{\@Roman\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\let\tabbodyfont\small
\def\squeezetable{\let\tabbodyfont\scriptsize}
\if@floats
\newenvironment{table}
               {\@float{table}\tabbodyfont}
               {\end@float}
\let\printtables\relax
\else
  \def\table{\write@float{table}}
  \let\endtable\end@writefloat
  \newwrite\tablewrite
  \immediate\openout\tablewrite=\jobname.tbx
\def\printtables{%
  \immediate\closeout\tablewrite
  \renewenvironment{table}
               {\@twocolumntrue\@float{table}}
               {\end@float}
  \section{TABLES}%
  \raggedbottom
  \input{\jobname.tbx}}
\fi
\newcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}
\ifx\@society\@undefined
  \REVTEX@warn{No Society specified, using generic APS style}
  \def\@society{aps}
\fi
\@inputrtx
\REVTEX@amssymb
\REVTEX@amsfonts
\AtBeginDocument{%
  \providecommand\MakeTextUppercase{\MakeUppercase}}
\AtBeginDocument{%
 \providecommand\bibinfo[2]{#2}
 \providecommand\eprint[1]{#1}
 \providecommand\url[1]{#1}}
\DeclareRobustCommand\lambdabar{%
  \bgroup
    \def\@tempa{%
      \hbox{%
        \raise.73\ht\z@
        \hbox to\z@{\kern.25\wd0\vrule \@width.5\wd\z@
        \@height.1pt \@depth.1pt\hss}%
      \box\z@}}%
    \mathchoice
      {\setbox0\hbox{$\displaystyle\lambda$}\@tempa}%
      {\setbox0\hbox{$\textstyle\lambda$}\@tempa}%
      {\setbox0\hbox{$\scriptstyle\lambda$}\@tempa}%
      {\setbox0\hbox{$\scriptscriptstyle\lambda$}\@tempa}%
  \egroup}
\def\openone{\leavevmode\hbox{\small1\normalsize\kern-.33em1}}%
\def\corresponds{{\lower.2ex\hbox{=}}{\kern-.75em^\triangle}}
\def\slantfrac#1#2{\kern1em^{#1}\kern-.3em/\kern-.1em_{#2}}
\def\succsim{\succ\kern-.9em_\sim\kern.3em}
\def\precsim{\prec\kern-1em_\sim\kern.3em}
\AtBeginDocument{%
\providecommand\lesssim{\mathrel{\mathpalette\vereq<}}
\def\vereq#1#2{%
  \lower3pt\vbox{\baselineskip1.5pt \lineskip1.5pt
  \ialign{$\m@th#1\hfill##\hfil$\crcr#2\crcr\sim\crcr}}}
\providecommand\gtrsim{\mathrel{\mathpalette\vereq>}}}
\def\tensor#1{\@ontopof{#1}{\leftrightarrow}{1.15}\mathord{\box2}}
\def\overstar#1{\@ontopof{#1}{\ast}{1.15}\mathord{\box2}}
\def\overdots#1{\@ontopof{#1}{\cdots}{1.0}\mathord{\box2}}
\def\overcirc#1{\@ontopof{#1}{\circ}{1.2}\mathord{\box2}}
\def\loarrow#1{\@ontopof{#1}{\leftarrow}{1.15}\mathord{\box2}}
\def\roarrow#1{\@ontopof{#1}{\rightarrow}{1.15}\mathord{\box2}}
\def\tensor#1{\@ontopof{#1}{\leftrightarrow}{1.15}\mathord{\box2}}
\def\overstar#1{\@ontopof{#1}{\ast}{1.15}\mathord{\box2}}
\def\overdots#1{\@ontopof{#1}{\cdots}{1.0}\mathord{\box2}}
\def\overcirc#1{\@ontopof{#1}{\circ}{1.2}\mathord{\box2}}
\def\loarrow#1{\@ontopof{#1}{\leftarrow}{1.15}\mathord{\box2}}
\def\roarrow#1{\@ontopof{#1}{\rightarrow}{1.15}\mathord{\box2}}
\DeclareRobustCommand\@ontopof[3]{{%
  \mathchoice
    {\@@ontopof{#1}{#2}{#3}\displaystyle\scriptstyle}%
    {\@@ontopof{#1}{#2}{#3}\textstyle\scriptstyle}%
    {\@@ontopof{#1}{#2}{#3}\scriptstyle\scriptscriptstyle}%
    {\@@ontopof{#1}{#2}{#3}\scriptscriptstyle\scriptscriptstyle}}}
\def\@@ontopof#1#2#3#4#5{%
  \setbox\z@\hbox{$#4#1$}%
  \setbox4\hbox{$#5#2$}%
  \setbox\tw@\null\ht\tw@\ht\z@ \dp\tw@\dp\z@
  \ifdim\wd\z@>\wd4 %
    \setbox4\hbox to\wd0{\hss\box4\hss}%
    \mathord{\rlap{\raise#3\ht\z@\box4}\box\z@}%
  \else
    \setbox4\hbox to.9\wd4{\hss\box4\hss}%
    \setbox\z@\hbox to\wd4{\hss$#4\relax#1$\hss}%
    \mathord{\rlap{\copy\z@}\raise#3\ht\z@\box4}%
  \fi}%
\endinput
%%
%% End of file `revtex4.cls'.
