%%% generic genericAP class file version 6 September, 1999
%%% Copyright (c) Focal Image Ltd 1999
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{academic}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\setlength\paperheight {297mm}
\setlength\paperwidth  {210mm}
\newif\if@csla \@cslafalse
\newif\if@bulm \@bulmfalse
\newif\if@jsco \@jscofalse
\newif\if@eujc \@eujcfalse
\newif\if@jcht \@jchtfalse
\newif\if@spmi \@spmifalse
\newif\if@seiz \@seizfalse
\newcounter{@status}
\newcounter{@KEY}
\DeclareOption{csla}{\@cslatrue\setcounter{@status}{1}\setcounter{@KEY}{0}}
\DeclareOption{bulm}{\@bulmtrue\setcounter{@status}{1}\setcounter{@KEY}{0}}
\DeclareOption{jsco}{\@jscotrue\setcounter{@status}{1}\setcounter{@KEY}{0}}
\DeclareOption{jcht}{\@jchttrue\setcounter{@status}{0}\setcounter{@KEY}{1}}
\DeclareOption{spmi}{\@spmitrue\setcounter{@status}{0}\setcounter{@KEY}{1}}
\DeclareOption{eujc}{\@eujctrue\setcounter{@status}{0}\setcounter{@KEY}{0}}
\DeclareOption{seiz}{\@seiztrue\setcounter{@status}{0}\setcounter{@KEY}{1}}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions
\LoadClass[a4paper,oneside,12pt]{article}
\RequirePackage{ifthen}
\RequirePackage[final]{graphicx}
\RequirePackage{latexsym}
\RequirePackage{amsfonts,amssymb}
\RequirePackage{xspace}
%%%
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{1}
\setlength\parskip{0\p@ \@plus \p@}
\setlength\parindent{1em}
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\clubpenalty  0
\widowpenalty 10000
\@twosidefalse
\@mparswitchtrue
\setlength\headheight{18\p@}
\setlength\headsep   {12\p@}
\setlength\topskip   {12\p@}
\setlength\footskip{24\p@}
\setlength\maxdepth{0.5\topskip}
\setlength\textwidth{34pc}
  \setlength\@tempdima{\paperwidth}
  \addtolength\@tempdima{-2in}
  \setlength\@tempdimb{34pc}
    \ifdim\@tempdima>\@tempdimb\relax
      \setlength\textwidth{\@tempdimb}
    \else
      \setlength\textwidth{\@tempdima}
    \fi
  \@settopoint\textwidth
\setlength\textheight{43\baselineskip}
\addtolength\textheight{\topskip}
\setlength\marginparsep{10\p@}
\setlength\marginparpush{6\p@}
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.5\@tempdima}
    \addtolength\oddsidemargin  {-1in}
    \setlength\marginparwidth   {.5\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}
    \addtolength\marginparwidth {-.4in}
  \ifdim \marginparwidth >2in
     \setlength\marginparwidth{2in}
  \fi
  \setlength\marginparwidth{6pc}
  \@settopoint\oddsidemargin
  \@settopoint\marginparwidth
  \setlength\evensidemargin  {\paperwidth}
  \addtolength\evensidemargin{-2in}
  \addtolength\evensidemargin{-\textwidth}
  \addtolength\evensidemargin{-\oddsidemargin}
  \@settopoint\evensidemargin
  \setlength\topmargin{\paperheight}
  \addtolength\topmargin{-2in}
  \addtolength\topmargin{-\headheight}
  \addtolength\topmargin{-\headsep}
  \addtolength\topmargin{-\textheight}
  \addtolength\topmargin{-\footskip}     % this might be wrong!
  \addtolength\topmargin{-0.5\topmargin}
  \@settopoint\topmargin
\setlength\footnotesep{12\p@}
\setlength{\skip\footins}{6\p@ \@plus 6\p@ \@minus 2\p@}
\setcounter{topnumber}{3}
\renewcommand\topfraction{1}
\setcounter{bottomnumber}{2}
\renewcommand\bottomfraction{0.8}
\setcounter{totalnumber}{4}
\renewcommand\textfraction{0}
\renewcommand\floatpagefraction{0.8}
\setlength\floatsep    {12\p@ \@plus 6\p@ \@minus 1\p@}
\setlength\textfloatsep{18\p@ \@plus 6\p@ \@minus 2\p@}
\setlength\intextsep   {18\p@ \@plus 3\p@ \@minus 2\p@}
\setlength\@fptop{0\p@ \@plus 0fil}
\setlength\@fpsep{12\p@ \@plus 0fil}
\setlength\@fpbot{0\p@ \@plus 3fil}

\let\@correspondence\@empty
\def\correspondence#1{\gdef\@correspondence{\footnotesize%
  Correspondence to:\space#1}}

\def\@ideal{Available online at
     {http://www.idealibrary.com} on  \textsf{IDEAL}}

\setlength\floatsep    {12\p@ \@plus 6\p@ \@minus 1\p@}
\setlength\textfloatsep{18\p@ \@plus 6\p@ \@minus 2\p@}
\setlength\intextsep   {18\p@ \@plus 3\p@ \@minus 2\p@}
\setlength\@fptop{0\p@ \@plus 0fil}
\setlength\@fpsep{12\p@ \@plus 0fil}
\setlength\@fpbot{0\p@ \@plus 3fil}
\def\verso#1{\gdef\@verso{#1}}
\def\recto#1{\gdef\@recto{#1}}
\let\shortauthor\verso
\let\shorttitle\recto
\def\seiz{Seizure}
\def\eujc{European Journal of Combinatorics}
\def\jcht{Journal of Chemical Thermodynamics}
\def\spmi{Superlattices and Microstructures}
\def\csla{Computer Speech and Language}
\def\bulm{Bulletin of Mathematical Biology}
\def\jsco{Journal of Symbolic Computation}
\def\@journalname{%
                \if@eujc{European Journal of Combinatorics}\else
                \if@seiz{Seizure}\else
                \if@jcht{Journal of Chemical Thermodynamics}\else
                \if@spmi{Superlattices and Microstructures}\else
                \if@bulm{Bulletin of Mathematical Biology}\else
                \if@jsco{Journal of Symbolic Computation}\else
                \if@csla{Computer Speech and Language}\else
                *** Unknown Journal ***
    \fi\fi\fi\fi\fi\fi\fi}
%
\ifnum\the@status=0\RequirePackage[numbers,sort&compress]{natbib}%
	 \typeout{**** natbib.sty with numbers, sort&compress option invoked ***}
   \else\ifnum\the@status=1\RequirePackage{natbib}
	 \typeout{**** natbib.sty with author year option invoked ***}
   \else\RequirePackage[numbers,sort&compress]{natbib}\fi\fi
  
\def\ps@AP{\if@twoside%
  \def\@oddhead{%
      \relax
     {\small\hfil{\@verso}\hfil
      \thepage}}%
  \def\@evenhead{%
      {\small\thepage\hfil
      {\@recto}%
       \relax}\hfil}%
  \else%
  \def\@oddhead{%
      \relax
     {\small\hfil{\@verso:~\@recto}\hfil
      \thepage}}%
  \let\@evenhead\@oddhead%
  \fi
  \let\@oddfoot\@empty
  \let\@evenfoot\@empty}
\ps@AP
\def\ps@title{%
  \def\@oddhead{%
      \smash{\lower12pt\rlap{{\footnotesize\itshape Article Submitted to \@journalname}}}%
     \relax
     \relax}%
  \let\@evenhead\@oddhead
  \def\@oddfoot{\hfil\thepage\hfil%
     \relax}%
  \let\@evenfoot\@empty%
}
\def\ps@empty{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \let\@evenhead@empty\let\@oddhead\@empty
}
\def\etal{\emph{et al}.\xspace}
\setcounter{secnumdepth}{3}
\renewcommand\thesection      {\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
\def\@seccntformat#1{\csname the#1\endcsname.\hskip 0.5em}
\renewcommand\section{\@startsection {section}{1}{\z@}%
             {-18\p@ \@plus-6\p@ \@minus-3\p@}%
             {  6\p@ \@plus  \z@ \@minus \p@}%
             {\large\bfseries}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
             {-18\p@ \@plus-6\p@ \@minus-3\p@}%
             {  6\p@ \@plus  \z@ \@minus \p@}%
             {\normalfont\small\bfseries}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
             {-12\p@ \@plus-6\p@ \@minus-3\p@}%
             {  6\p@ \@plus  \z@ \@minus \p@}%
             {\normalfont\itshape}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{10\p@}%
             {12\p@}%
             {-1em}%
             {\normalfont\itshape}}

\renewenvironment{abstract}{%
      \list{}{\leftmargin2.5pc\rightmargin\leftmargin
        \parsep\z@ \@plus\p@\listparindent 1em\labelsep \z@}
          \item[]\begin{center}\textbf{Abstract}\end{center}
          \item\relax\small}%
      {\ifnum\the@KEY=0\relax\else\KEYWORDS\fi%
          \endlist\noindent}
\def\KEYWORDS{\ifx\@keywords\@empty%
        \par\vspace*{12pt}\noindent\MakeUppercase{keywords}:\space
        *** \textbf{Keywords not supplied} ***
      \else
        \par\vspace*{12pt}\noindent\MakeUppercase{keywords}:\space\@keywords
      \fi}

\let\@keywords\@empty
\def\keyword#1{%
  \ifx\@keywords\@empty
    \def\@keywords{#1}
  \else
    \g@addto@macro\@keywords{; #1}
  \fi}
\def\keywords#1{%
  \ifx\@keywords\@empty
    \def\@keywords{#1}
  \else
    \g@addto@macro\@keywords{#1}
  \fi}
%------------ theorem environment ----------
\def\newdefinition#1{%
  \@ifnextchar[{\@odef{#1}}{\@ndef{#1}}}
\def\@ndef#1#2{%
  \@ifnextchar[{\@xndef{#1}{#2}}{\@yndef{#1}{#2}}}
\def\@xndef#1#2[#3]{%
  \expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}\@newctr{#1}[#3]%
     \expandafter\xdef\csname the#1\endcsname{%
       \expandafter\noexpand\csname the#3\endcsname \@defcountersep
          \@defcounter{#1}}%
     \global\@namedef{#1}{\@prf{#1}{#2}}%
     \global\@namedef{end#1}{\@enddefinition}}}
\def\@yndef#1#2{%
  \expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}%
     \expandafter\xdef\csname the#1\endcsname{\@defcounter{#1}}%
     \global\@namedef{#1}{\@def{#1}{#2}}%
     \global\@namedef{end#1}{\@enddefinition}}}
\def\@odef#1[#2]#3{%
  \@ifundefined{c@#2}{\@nocounterr{#2}}%
    {\expandafter\@ifdefinable\csname #1\endcsname
    {\global\@namedef{the#1}{\@nameuse{the#2}}%
  \global\@namedef{#1}{\@def{#2}{#3}}%
  \global\@namedef{end#1}{\@enddefinition}}}}
\def\@def#1#2{%
  \refstepcounter{#1}%
  \@ifnextchar[{\@ydef{#1}{#2}}{\@xdef{#1}{#2}}}
\def\@xdef#1#2{%
  \@begindefinition{#2}{\csname the#1\endcsname}\ignorespaces}
\def\@ydef#1#2[#3]{%
  \@opargbegindefinition{#2}{\csname the#1\endcsname}{#3}\ignorespaces}
\def\@defcounter#1{\noexpand\arabic{#1}}
\def\@defcountersep{.}
\def\@begindefinition#1#2{\trivlist
   \item[\hskip \labelsep{\scshape #1\ #2:}]\rmfamily}
\def\@opargbegindefinition#1#2#3{\trivlist
      \item[\hskip \labelsep{\scshape #1\ #2\ (#3):}]\rmfamily}
\def\@enddefinition{\endtrivlist}
\def\@begintheorem#1#2{\trivlist
   \item[\hskip \labelsep{\scshape #1\ #2:}]\itshape}
\def\@opargbegintheorem#1#2#3{\trivlist
      \item[\hskip \labelsep{\scshape #1\ #2\ (#3):}]\itshape}
\def\newproof#1{%
  \@ifnextchar[{\@oprf{#1}}{\@nprf{#1}}}
\def\@nprf#1#2{%
  \@ifnextchar[{\@xnprf{#1}{#2}}{\@ynprf{#1}{#2}}}
\def\@xnprf#1#2[#3]{%
  \expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}\@newctr{#1}[#3]%
     \expandafter\xdef\csname the#1\endcsname{%
       \expandafter\noexpand\csname the#3\endcsname \@prfcountersep
          \@prfcounter{#1}}%
     \global\@namedef{#1}{\@prf{#1}{#2}}%
     \global\@namedef{end#1}{\@endproof}}}
\def\@ynprf#1#2{%
  \expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}%
     \expandafter\xdef\csname the#1\endcsname{\@prfcounter{#1}}%
     \global\@namedef{#1}{\@prf{#1}{#2}}%
     \global\@namedef{end#1}{\@endproof}}}
\def\@oprf#1[#2]#3{%
  \@ifundefined{c@#2}{\@nocounterr{#2}}%
    {\expandafter\@ifdefinable\csname #1\endcsname
    {\global\@namedef{the#1}{\@nameuse{the#2}}%
  \global\@namedef{#1}{\@prf{#2}{#3}}%
  \global\@namedef{end#1}{\@endproof}}}}
\def\@prf#1#2{%
  \refstepcounter{#1}%
  \@ifnextchar[{\@yprf{#1}{#2}}{\@xprf{#1}{#2}}}
\def\@xprf#1#2{%
  \@beginproof{#2}{\csname the#1\endcsname}\ignorespaces}
\def\@yprf#1#2[#3]{%
  \@opargbeginproof{#2}{\csname the#1\endcsname}{#3}\ignorespaces}
\def\@prfcounter#1{\noexpand\arabic{#1}}
\def\@prfcountersep{.}
\def\@beginproof#1#2{\trivlist
   \item[\hskip \labelsep{\itshape #1:}]\rmfamily}
\def\@opargbeginproof#1#2#3{\trivlist
      \item[\hskip \labelsep{\itshape #1\ (#3):}]\rmfamily}
\def\@endproof{\qed\endtrivlist}
\newcommand*{\qed}{\hbox{}\hfill$\Box$}
\newproof{proof}{Proof}
\newtheorem{theorem}{Theorem}[section]
\newtheorem{lemma}{Lemma}[section]
\newtheorem{proposition}{Proposition}[section]
\newtheorem{corollary}{Corollary}[section]
\newtheorem{conjecture}{Conjecture}[section]
\newtheorem{case}{Case}[section]
\newdefinition{remark}{Remark}[section]
\newdefinition{definition}{Definition}[section]
\newdefinition{axiom}{Axiom}[section]
\newdefinition{note}{Note}[section]

%------ end of theorem environment ------

\renewcommand\appendix{\par
  \setcounter{section}{0}%
  \setcounter{subsection}{0}%
  \renewcommand\thesection{\@Alph\c@section}}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{0.5\p@}%0.5
\setlength\doublerulesep{0.5\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{0.5\p@}
\renewcommand\theequation{\@arabic\c@equation}
\chardef\@ne=1
\chardef\tw@=2
\chardef\thr@@=3
\def\hb@xt@{\hbox to}

\setcounter{tocdepth}{1}
\renewcommand{\footnoterule}{\relax}
\renewcommand\refname{References}
\renewcommand\figurename{Figure}
\renewcommand\tablename{Table}
\renewcommand\appendixname{Appendix}
\renewcommand\abstractname{}
\pagestyle{AP}
\pagenumbering{arabic}
\frenchspacing
\newcounter{AuthorCtr}
\newcounter{AddressCtr}
\def\author{\@ifnextchar[{\Xauthor}{\Xauthor[]}}%
\def\Xauthor[#1]#2{%
        \expandafter\def\csname @AuthorLabel\theAuthorCtr\endcsname{#1}%
        \expandafter\def\csname @eachAuthor\theAuthorCtr\endcsname{#2}%
        \stepcounter{AuthorCtr}%
}%
\def\address{\@ifnextchar[{\Xaddress}{\Xaddress[]}}%
\def\Xaddress[#1]#2{%
        \expandafter\def\csname @addressLabel\theAddressCtr\endcsname{#1}%
        \expandafter\def\csname @eachAddress\theAddressCtr\endcsname{#2}%
        \stepcounter{AddressCtr}%
}%
\def\@PAauthorconnect{ and }
\def\maketitle{%
 \null\addvspace{45pt}\begingroup
 \renewcommand\thefootnote{\fnsymbol{footnote}}
 \newcounter{kCtr}\newcounter{lCtr}
 \newcounter{AuthorControlCtr}
 \newcounter{AddressControlCtr}
 \newcounter{KCtr}\setcounter{KCtr}{\theAuthorCtr}
 \addtocounter{KCtr}{-2}
 \newcounter{@KCtr}\setcounter{@KCtr}{\theAuthorCtr}
 \addtocounter{@KCtr}{-1}
 \def\@AuthSep{\ifnum\c@kCtr=\c@KCtr\@PAauthorconnect\else%
     \ifnum\c@kCtr=\c@@KCtr\relax\else,\space\fi\fi}
 \begingroup
  \def\AuthorBlock{%
        \setcounter{kCtr}{0}\setcounter{AuthorControlCtr}{0}
                \loop\ifnum\number\thekCtr<\number\theAuthorCtr%
     \csname @eachAuthor\thekCtr\endcsname\unskip%
     \textsuperscript{\csname @AuthorLabel\thekCtr\endcsname}\@AuthSep%
        \stepcounter{AuthorControlCtr}%
    \stepcounter{kCtr}\repeat
}      
\def\AddressBlock{%
 \def\@AddSep{\ifnum\c@lCtr=\c@LCtr\@PAauthorconnect\else%
     \ifnum\c@lCtr=\c@@LCtr.\else,\space\fi\fi}
        \setcounter{lCtr}{0}
        \loop\ifnum\number\thelCtr<\number\theAddressCtr%
    \textsuperscript%
    {{\upshape\csname @addressLabel\thelCtr\endcsname}}%
    \unskip\csname @eachAddress\thelCtr\endcsname\par\vskip3pt
    \stepcounter{lCtr}\repeat
}
%
\list{}{\leftmargin 15pt \rightmargin 15pt%
     \topsep \z@\parsep0\p@ \@plus\p@\itemsep0pt%
     \listparindent 0em\labelsep \z@}%
  \item[]\relax\centering{{\strut\Large\bfseries\@title\strut}}%
  \endlist
  \addvspace{20pt}
%
  \begingroup
  \list{}
  {\leftmargin 15pt\rightmargin 15pt%
     \topsep \z@\parsep0\p@ \@plus\p@\itemsep0pt%
     \listparindent 0em\labelsep \z@}%
  \item[]\relax\centering{\normalsize\scshape\AuthorBlock}\par%
  \addvspace{10pt}%
  \endgroup
%
  \begingroup\list{}
  {\leftmargin 15pt\rightmargin 15pt%
     \topsep \z@\parsep0\p@ \@plus\p@\itemsep0pt%
     \listparindent 0em\labelsep \z@}%
                \item[]\relax\centering
        \footnotesize\itshape\AddressBlock%
  \endlist\endgroup\addvspace{10pt}%
  \ifx\@correspondence\@empty\relax\else\@correspondence\par
  \addvspace{10pt}\fi%
  \@thanks\endgroup\addvspace{20pt}%
  \endgroup
\thispagestyle{title}
}
\def\email#1{E-mail:\space{\normalfont\texttt{#1}}}
%\let\savehline\hline
%\def\hline{\noalign{\vskip3pt}\savehline\noalign{\vskip3pt}}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\footnotesize\textbf{#1:} #2}%
  \ifdim \wd\@tempboxa >\hsize
    \footnotesize\textbf{#1:} #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\setlength\belowcaptionskip{6pt}
\let\otable\table
\def\table{\otable\footnotesize\centering}
\def\fps@table{htbp}
%
\def\Bibitem{\begingroup%
\def\author##1{\ifx{##1}\@empty\relax\else##1\unskip,\xspace\fi}%
\def\editor##1{\ifx{##1}\@empty\relax\else##1\unskip,\xspace\@editortrue\fi}%
\def\atitle##1{\ifx{##1}\@empty\relax\else##1\unskip,\xspace\fi}%
\def\jtitle##1{\ifx{##1}\@empty\relax\else\emph{##1}\unskip,\xspace\fi}%
\def\bktitle##1{\ifx{##1}\@empty\relax\else%
  \if@editor(eds.)\space\fi\emph{##1}\unskip,\xspace\fi}%
\def\bkstitle##1{\ifx{##1}\@empty\relax\else##1\unskip,\xspace\fi}%
\def\vol##1{\ifx{##1}\@empty\relax\else\textbf{##1}\unskip,\xspace\fi}%
\def\year##1{\ifx{##1}\@empty\relax\else(##1)\unskip.\xspace\fi}%
\def\fpage##1{\ifx{##1}\@empty\relax\else ##1\fi}%
\def\lpage##1{\ifx{##1}\@empty\unskip.\relax\else\unskip--##1.\fi}%
\def\pages##1{\ifx{##1}\@empty\relax\else##1.\ignorespaces\fi}%
\def\publisher##1{\ifx{##1}\@empty\relax\else##1\unskip,\xspace\fi}%
\def\place##1{\ifx{##1}\@empty\relax\else##1\unskip,\xspace\fi}%
\def\commn##1{\ifx{##1}\@empty\relax\else##1\unskip,\xspace\fi}%
\def\thesis##1{\ifx{##1}\@empty\relax\else##1\unskip,\xspace\fi}%
}%


\def\endBibitem{\endgroup\global\@editorfalse}
%
\newif\if@editor \@editorfalse
%
\@namedef{article}{\Bibitem}
\@namedef{endarticle}{\endBibitem}
\@namedef{book}{\Bibitem}
\@namedef{endbook}{\endBibitem}
\@namedef{inbook}{\Bibitem}
\@namedef{endinbook}{\endBibitem}
\@namedef{others}{\Bibitem}
\@namedef{endothers}{\endBibitem}
\@namedef{thesis}{\Bibitem}
\@namedef{endthesis}{\endBibitem}

\def\@biblabel#1{#1.}
\def\topline{\hline}
\def\botline{\hline}
\def\query#1#2{#2}
 \renewcommand\thefootnote{\fnsymbol{footnote}}
 \def\authornote#1{\protect\footnote{\itshape#1}}
\endinput
%%
%% end of file `academic.cls'

