%revised092105
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{aomamlt2e}
  \RequirePackage{theorem}
%\RequirePackage{amsthm}
\LoadClassWithOptions{article} 
 \usepackage{epsfig}  
\usepackage{amscd}
\usepackage[all]{xypic}
 
  \usepackage{latexsym,amsmath,amssymb,euscript} %
  
\renewcommand{\normalsize}{\fontsize{11pt}{13.9pt}\selectfont}

%%%%%%%fonts

\def\thebibliography#1{\vskip12pt \centerline{\footnotesize\scshape References}  \vskip12pt
 % \defaultfont
\footnotesize\labelsep .5em\relax
  \list{\@arabic\c@enumi.}{\settowidth\labelwidth{#1.}%
  \leftmargin\labelwidth \advance\leftmargin\labelsep
  \usecounter{enumi}}%
  \sloppy \clubpenalty4000\relax \widowpenalty\clubpenalty
  \sfcode`\.\@m}
%\let\endthebibliography=\endlist

%%%%%page setup
\setlength{\textwidth}{31pc}
\setlength{\textheight}{49pc}  %48pc
 \setlength{\parindent}{22pt}
\setlength{\topskip}{12pt}
\setlength{\headsep}{14pt}

\setlength{\parskip}{0pt}

 \setlength{\widowpenalty}{10000}
 \setlength{\clubpenalty}{10000}
\setlength{\skip\footins}{20pt}
\setlength{\dimen\footins}{3in}
\setlength{\abovedisplayskip}{6.95pt plus3.5pt minus 3pt}
\setlength{\belowdisplayskip}{\abovedisplayskip}

%%%%%Output routine
%\setlength{\voffset}{7pt}
\setlength{\voffset}{-40pt}
% \newcommand{\bindingoffset}{\ifodd\pageno\hoffset=-18pt\else\hoffset-18pt\fi}


  \oddsidemargin=.65in
  \evensidemargin=.65in

 

%%%%%title page

 \newcommand{\email}[1]{{\scriptsize{\it E-mail address}\/: {\rm #1}} }
\newcommand{\url}[1]{{\scriptsize{\it URL}\/: {\rm #1}}}
\newcommand{\emails}[2]{{\scriptsize{\it E-mail addresses}\/: {\rm #1}}\\ \vskip-14pt
\hglue70pt {\rm #2}}
\newcommand{\current}[1]{{\scriptsize{\it Current address}\/: {\scshape #1}} }

\newcommand{\institution}[1]{\newcommand{\theinstitutions}{\vskip16pt\baselineskip10pt\begin{quote}\scriptsize\scshape
#1\end{quote}}}
 
\newcommand{\received}[1]{\AtEndDocument{\medbreak%1sp
\centerline{\small (Received #1)\label{lastpage}}}}

\newcommand{\revised}[1]{\AtEndDocument{\smallbreak%\medbreak%\vskip-2.9pt 
\centerline{\small (Revised #1)}}}

 

 \newcommand\pageno[1]{\setcounter{page}{#1}}
 
\newif\iftitlepage
\DeclareOption{titlepage}{\titlepagetrue}
\DeclareOption{notitlepage}{\titlepagefalse}
\def\titlepage{%
\clearpage
\thispagestyle{empty}}

   

 

\newcommand{\currannalsline}[2]{\titlepage
\vglue-42pt\centerline{\hfill{\scriptsize Annals of Mathematics},
{\scriptsize\bf#1} {\scriptsize (#2),  \thepage--\pageref{lastpage}} \hfill}}    
  

 \newif\ifacks
\long\def\acknowledgements#1{{\def\@makefnmark{\empty}
\def\one{#1}\ifx\one\empty\else
\global\ackstrue%\vskip-\baselineskip
%\footnote{\ \unskip}{*#1}\fi}
\footnotetext{*#1}\fi}
}



\let\acknowledgement\acknowledgements
 


 \def\title#1{\vbox to102pt{\vfill   %86pt
\baselineskip=20pt
\parindent=0pt
\overfullrule=0pt
\hyphenpenalty=10000
\everypar={\hskip\parfillskip\relax}
\hbadness=10000
\def\\ {\vskip1sp}
{\normalfont\LARGE\bfseries#1}\vskip1sp}\titleheadline{#1}
}

 
 \newif\ifauthor
 \def\author#1{\vskip15pt
 \hbox to\hsize{\hss\small By {\scshape#1}\ifacks\global\acksfalse*\fi\hss}
 \ifshort\else
\newcommand{\theauthors}{{\scriptsize\scshape\uppercase{#1}}}\fi
\vskip7pt
\vskip\baselineskip
\global\authortrue\everypar={\global\authorfalse\everypar={}}}

 

\def\twoauthors#1#2{\vskip15pt
\hbox to\hsize{\hss%
\small By {\scshape#1}   and  {\scshape#2}\ifacks\global\acksfalse*\fi\hss}
\ifshort\else
\newcommand{\theauthors}{{\scriptsize\scshape\uppercase{#1 and #2}}}\fi
\vskip7pt
\vskip\baselineskip
\global\authortrue\everypar={\global\authorfalse\everypar={}}}

\let\authors\author

%\def\amheadline{\iftitle
%\hbox to\hsize{\hss\currannalsline\hss}\else\line{\ifodd\pageno
%\hfill\thetitle\hfill\llap{\elevenrm\folio}\else\rlap{\elevenrm\folio}
%\hfill\theauthors\hfill\fi}\fi}

 \newcommand{\titleheadline}[1]{\def\one{#1}\ifx\one\empty\else
\gdef\thetitle{{\frenchspacing%
     \let\\ \relax\scriptsize\scshape\uppercase{#1}}}\fi}




\newif\ifshort
\newcommand*{\shortname}[1]{\global\shorttrue
\renewcommand*{\theauthors}{{\scshape\uppercase{\scriptsize #1}}}}
\let\shorttitle\titleheadline


 \newcommand*{\ps@dochead}{%
\renewcommand*{\@evenhead}{%
\thepage\hfill\theauthors\hfill}
 \renewcommand*{\@oddhead}{%
\hfill\thetitle\hfill\thepage}
\renewcommand*{\@oddfoot}{}
\renewcommand*{\@evenfoot}{}
}
\pagestyle{dochead}


%%%%%%%%%section commands
\setcounter{secnumdepth}{4}  

 
\renewcommand{\section}{\@startsection
{section}
{0}
{0mm}
{18pt}
{12pt}
{\centering\normalfont\normalsize\bf}
}

 \renewcommand{\thesection}{\arabic{section}}
\makeatletter
\renewcommand{\@seccntformat}[1]{\csname
the#1\endcsname.\hspace{0.5em}\setcounter{equation}{0}\setcounter{Subsec}{0}\setcounter{Subsubsec}{0}\setcounter{figure}{0}}\makeatother

 
\newcounter{Subsec}
\newcommand{\Subsec}[1] {\setcounter{Subsubsec}{0}\vskip10pt \refstepcounter{Subsec}  \thesection.\arabic{Subsec}. {\it #1.}}
 \renewcommand{\theSubsec}{\thesection.\arabic{Subsec}}
 

\newcounter{Subsubsec}
\newcommand{\Subsubsec}[1] {\vskip10pt \refstepcounter{Subsubsec}  \theSubsec.\arabic{Subsubsec}. {\it #1.}}
 \renewcommand{\theSubsubsec}{\theSubsec.\arabic{Subsubsec}}
 
%%%%%%%counters

\newcounter{theoremcount}
\newcounter{sectioncount}
 

\newcounter{eqcount}
 
 %%%%%%%Theorem environments
\begingroup \makeatletter
\@ifundefined{theorem@style}{\input{theorem.sty}}{}
\ProvidesFile{thp.sty}
             [\FMithmInfo]
\gdef\th@plain{\normalfont\itshape
  \def\@begintheorem##1##2{%
        \item[\hskip\labelsep \theorem@headerfont \hskip22pt ##1\ ##2.]}%
\def\@opargbegintheorem##1##2##3{%
   \item[\hskip\labelsep \theorem@headerfont\hskip22pt  ##1\ ##2 {\rm (##3)}.\ ]}}
\endgroup



\theoremheaderfont{\scshape}



\setlength\theorempreskipamount{10pt plus.1\baselineskip minus.05\baselineskip}%{8pt plus.1\baselineskip minus.05\baselineskip}
\setlength\theorempostskipamount{10pt plus.1\baselineskip minus.05\baselineskip}

 %\newcommand{\thetheorem}{\arabic{theorem}.}


%%%%%%Demos
\def\qed{\vbox{\hrule\hbox{\vrule height6pt\hskip6pt\vrule}\hrule}}

   \newcommand{\demo}[1]
  {\vskip10pt  {\it #1}. 
  }

 
\newcommand{\Proof}{\medbreak {\it Proof}. }
\newcommand{\Endproof}{\hfill\qed\medbreak}

  \newcounter{demo}
 \newcommand{\numbereddemo}[1]{\vskip10pt {\it #1} \refstepcounter{demo}  \thesection.\arabic{demo}.}


 \newcommand{\Enddemo}{\vskip10pt}
%%%%%%%%equations

%%%%%References

\newcommand{\references}[1]{\theinstitutions 
\begin{thebibliography}{#1}}
%\begin{footnotesize}\begin{thebibliography}{#1}}


\newcommand{\Endrefs}{\end{thebibliography}}
\newcommand{\bibline}{$_{\hbox{---------}}$}

\newcommand{\name}[1]{{\scriptsize\scshape#1}}

\makeatletter
\def\eqnarray{%
   \stepcounter{equation}%
   \def\@currentlabel{\p@equation\theequation}%
   \global\@eqnswtrue
   \m@th
   \global\@eqcnt\z@
   \tabskip\@centering
   \let\\\@eqncr
   $$\everycr{}\halign to\displaywidth\bgroup
       \hskip\@centering$\displaystyle\tabskip\z@skip{##}$\@eqnsel
      &\global\@eqcnt\@ne\,\hfil${##}$\hfil
      &\global\@eqcnt\tw@\,$\displaystyle{##}$\hfil\tabskip\@centering
      &\global\@eqcnt\thr@@ \hb@xt@\z@\bgroup\hss##\egroup
         \tabskip\z@skip
      \cr
}


\makeatother
 

\newcommand{\ritem}[1]{\item[{\rm #1}]}

%\makeatletter
%\renewcommand{\theenumi}{\rm (\arabic{enumi})%
%}
%\makeatother

\newenvironment{aenume}{%
  \begin{enumerate}%
  \renewcommand{\theenumi}{\alph{enumi}}%
  \renewcommand{\labelenumi}{(\theenumi)}%
  }{\end{enumerate}}
\renewcommand{\labelenumi}{\rm(\theenumi)}%
 
