%%
%% This is file `vch-book.cls',
%%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{vch-book}
              [2001/01/30 v1.04 Wiley-VCH Berlin GmbH]
% begin from amsbook.cls
\def\@True{00}
\def\@False{01}
\newcommand\newswitch[2][False]{%
  \expandafter\@ifdefinable\csname ?@#2\endcsname{%
    \global\expandafter\let\csname ?@#2\expandafter\endcsname
      \csname @#1\endcsname
  }%
}
\newcommand{\setFalse}[1]{%
  \expandafter\let\csname ?@#1\endcsname\@False
}
\newcommand{\setTrue}[1]{%
  \expandafter\let\csname ?@#1\endcsname\@True
}
\newswitch{}
\DeclareRobustCommand{\except}[1]{%
  \if\csname ?@#1\endcsname \expandafter\@gobble
  \else \expandafter\@firstofone
  \fi
}
\DeclareRobustCommand{\for}[1]{%
  \if\csname ?@#1\endcsname \expandafter\@firstofone
  \else \expandafter\@gobble
  \fi
}
\DeclareRobustCommand{\forany}[1]{%
  \csname for@any@01\endcsname#1,?,\@nil
}
\@namedef{for@any@\@False}#1,{%
  \csname for@any@%
    \csname ?@\zap@space#1 \@empty\endcsname
  \endcsname
}
\@namedef{?@?}{x}
\@namedef{for@any@\@True}#1\@nil#2{#2}
\def\for@any@x{\@car\@gobble}
% end from amsbook.cls
\newcommand\@ptsize{}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagetrue
\newif\if@openright
\newif\if@mainmatter \@mainmattertrue
\if@compatibility\else
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
    {\ClassError{vch-book}{Option `a5paper' not supported}{}}
\DeclareOption{b5paper}
    {\ClassError{vch-book}{Option `b5paper' not supported}{}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\fi
\if@compatibility
  \renewcommand\@ptsize{0}
\else
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\fi
\DeclareOption{11pt}
    {\ClassError{vch-book}{Option `11pt' not supported}{}}
\DeclareOption{12pt}
    {\ClassError{vch-book}{Option `12pt' not supported}{}}
\if@compatibility\else
\DeclareOption{oneside}
    {\ClassError{vch-book}{Option `oneside' not supported}{}}
\fi
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}
\def\ps@empty{%
  \let\@mkboth\@gobbletwo
  \let\@oddhead\@empty\def\@oddfoot{\texttt{\today\hfil D R A F T\hfil\jobname}}
  \let\@evenhead\@empty\let\@evenfoot\@oddfoot}
\AtEndOfClass{
      \def\@oddfoot{\texttt{\today\hfil D R A F T\hfil\jobname}}
		\def\@evenfoot{\texttt{\today\hfil D R A F T\hfil\jobname}}
}}
\if@compatibility\else
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\fi
\DeclareOption{titlepage}{\@titlepagetrue}
\if@compatibility\else
\DeclareOption{notitlepage}{\@titlepagefalse}
\fi
\if@compatibility
\@openrighttrue
\else
\DeclareOption{openright}{\@openrighttrue
\let\cleardouble@page\cleardoublepage
\AtBeginDocument{%
  \ifx\cleardouble@page\cleardoublepage
    \def\cleardoublepage{\clearpage{\pagestyle{empty}\cleardouble@page}}
  \fi
}
}
\DeclareOption{openany}{\@openrightfalse}
\fi
\if@compatibility\else
\DeclareOption{onecolumn}{\@twocolumnfalse}
\fi
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}
    {\ClassError{vch-book}{Option `leqno' not supported}{}}
%%%%%%%%%%%%%%%%%%
\DeclareOption{fleqn}{\input{fleqn.clo}
% fleqn
    \AtEndOfClass{\setlength{\mathindent}{3em}}
% amsmath.sty
    \AtBeginDocument{%
	 	\@ifundefined{@mathmargin}{}{%
		  \let\mathindent=\@mathmargin
		  \@mathmargin=3em minus1.5em
		}%
    }%
}
%%%%%%%%%%%%%%%%
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
      \listparindent \itemindent
      \parsep \z@
      }%
   \renewcommand\newblock{\par}%
   }%
}
% 
\newcount\c@IndexColumns
\newif\if@twocolindex
\DeclareOption{twocolumnindex}
   {\@twocolindextrue\c@IndexColumns = 2}
\DeclareOption{threecolumnindex}
   {\@twocolindexfalse\c@IndexColumns = 3}
%\newif\if@vchbibstyle
%\DeclareOption{vchbibstyle}
%   {\@vchbibstyletrue}
%\DeclareOption{normalbibstyle}
%   {\@vchbibstylefalse}
\newif\if@normalheading
\DeclareOption{indentedheading}{\@normalheadingfalse%
   \renewcommand{\@seccntformat}[1]{%
      \sbox\@tempboxa{\csname the#1\endcsname}%
      \setlength\@tempdimc{12mm}%
      \advance\@tempdimc -\wd\@tempboxa%
      \advance\@tempdimc -.5em%
      \setlength\fboxsep{\z@}\setlength\fboxrule{\z@}%
      \fbox{{\csname the#1\endcsname}}%
      \fbox{\enspace}%
      \fbox{\hskip\@tempdimc}%
      }%
}
\DeclareOption{normalheading}{\@normalheadingtrue%
  \def\@seccntformat#1{\csname the#1\endcsname\quad}}
\ExecuteOptions{letterpaper,10pt,twoside,onecolumn,final,openright,twocolumnindex,normalheading}
\ProcessOptions
%%
%% This is file `vch-bk10.clo',
\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xpt\@xiipt
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\newcommand\small{%
   \@setfontsize\small\@ixpt{11}%
   \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\footnotesize{%
   \@setfontsize\footnotesize\@viiipt{9.5}%
   \abovedisplayskip 6\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 3\p@ \@plus\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 3\p@ \@plus\p@ \@minus\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\scriptsize{\@setfontsize\scriptsize\@viipt\@viiipt}
\newcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
\newcommand\large{\@setfontsize\large\@xiipt{14}}
\newcommand\Large{\@setfontsize\Large\@xivpt{18}}
\newcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\newcommand\huge{\@setfontsize\huge\@xxpt{25}}
\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
\if@twocolumn
  \setlength\parindent{1em}
\else
  \setlength\parindent{15\p@}
\fi
\setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
\setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
\setlength\headheight{12\p@}
\setlength\headsep   {.25in}
\setlength\topskip   {10\p@}
\setlength\footskip{.35in}
\if@compatibility \setlength\maxdepth{4\p@} \else
\setlength\maxdepth{.5\topskip} \fi
\if@compatibility
  \if@twocolumn
    \setlength\textwidth{410\p@}%
  \else
    \setlength\textwidth{360\p@}%
  \fi
\else
  \setlength\@tempdima{\paperwidth}
  \addtolength\@tempdima{-2in}%
  \setlength\@tempdimb{373\p@}%
  \if@twocolumn
    \ifdim\@tempdima>2\@tempdimb\relax
      \setlength\textwidth{2\@tempdimb}
    \else
      \setlength\textwidth{\@tempdima}
    \fi
  \else
    \ifdim\@tempdima>\@tempdimb\relax
      \setlength\textwidth{\@tempdimb}
    \else
      \setlength\textwidth{\@tempdima}
    \fi
  \fi
\fi
\if@compatibility\else
  \@settopoint\textwidth
\fi
\if@compatibility
  \setlength\textheight{44\baselineskip}%
\else
  \setlength{\textheight}{44\baselineskip}%
\fi
\addtolength\textheight{\topskip}
\if@twocolumn
 \setlength\marginparsep {10\p@}%
\else
  \setlength\marginparsep{7\p@}%
\fi
\setlength\marginparpush{5\p@}%
\if@compatibility
   \setlength\oddsidemargin   {.5in}%
   \setlength\evensidemargin  {1.5in}%
   \setlength\marginparwidth {.75in}%
  \if@twocolumn
     \setlength\oddsidemargin  {30\p@}%
     \setlength\evensidemargin {30\p@}%
     \setlength\marginparwidth {48\p@}%
  \fi
\else
  \if@twoside
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.4\@tempdima}
    \addtolength\oddsidemargin  {-1in}%
    \setlength\marginparwidth   {.6\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}%
  \else
    \setlength\@tempdima        {\paperwidth}
    \addtolength\@tempdima      {-\textwidth}
    \setlength\oddsidemargin    {.5\@tempdima}
    \addtolength\oddsidemargin  {-1in}%
    \setlength\marginparwidth   {.5\@tempdima}
    \addtolength\marginparwidth {-\marginparsep}
    \addtolength\marginparwidth {-0.4in}%
%    \addtolength\marginparwidth {-.4in}
  \fi
  \ifdim \marginparwidth >2in%
     \setlength\marginparwidth{2in}%
  \fi
  \@settopoint\oddsidemargin
  \@settopoint\marginparwidth
  \setlength\evensidemargin  {\paperwidth}
  \addtolength\evensidemargin{-2in}%
  \addtolength\evensidemargin{-\textwidth}
  \addtolength\evensidemargin{-\oddsidemargin}
  \@settopoint\evensidemargin
\fi
\if@compatibility
  \setlength\topmargin{.75in}%
\else
  \setlength\topmargin{\paperheight}
  \addtolength\topmargin{-2in}%
  \addtolength\topmargin{-\headheight}
  \addtolength\topmargin{-\headsep}
  \addtolength\topmargin{-\textheight}
  \addtolength\topmargin{-\footskip}     % this might be wrong!
  \addtolength\topmargin{-.5\topmargin}
  \@settopoint\topmargin
\fi
\setlength\footnotesep{6.65\p@}
\setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}
%\setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
%\setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
%\setlength\intextsep   {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\floatsep    {8\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\textfloatsep{14\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\intextsep   {8\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
\setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
\setlength\@fptop{0\p@ \@plus 1fil}
\setlength\@fpsep{8\p@ \@plus 2fil}
\setlength\@fpbot{0\p@ \@plus 1fil}
\setlength\@dblfptop{0\p@ \@plus 1fil}
\setlength\@dblfpsep{8\p@ \@plus 2fil}
\setlength\@dblfpbot{0\p@ \@plus 1fil}
\setlength\partopsep{2\p@ \@plus 1\p@ \@minus 1\p@}
\def\@listi{\leftmargin\leftmargini
            \parsep 4\p@ \@plus2\p@ \@minus\p@
            \topsep 6\p@ \@plus2\p@ \@minus4\p@
            \itemsep4\p@ \@plus2\p@ \@minus\p@}
\let\@listI\@listi
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    4\p@ \@plus2\p@ \@minus\p@
              \parsep    2\p@ \@plus\p@  \@minus\p@
              \itemsep   \parsep}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    2\p@ \@plus\p@\@minus\p@
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@
              \itemsep   \topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}
%%
%% End of file `vch-bk10.clo'.
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{4}
\setcounter{bottomnumber}{4}
\setcounter{totalnumber}{4}
\setcounter{dbltopnumber}{4}
\renewcommand{\topfraction}{.97}
\renewcommand{\bottomfraction}{.97}
\renewcommand{\textfraction}{.03}
\renewcommand{\floatpagefraction}{.9}
\renewcommand{\dbltopfraction}{.97}
\renewcommand{\dblfloatpagefraction}{.9}
\if@twoside
  \def\ps@headings{%
      \let\@oddfoot\@empty\let\@evenfoot\@empty
      \def\@evenhead{\small\thepage\hfil\itshape\leftmark}%
      \def\@oddhead{{\small\itshape\rightmark}\small\hfil\thepage}%
      \let\@mkboth\markboth
    \def\chaptermark##1{%
      \markboth {{%
        \ifnum \c@secnumdepth >\m@ne
          \if@mainmatter
            \thechapter \quad %
%            \thechapter \ %
          \fi
        \fi
        ##1}}{}}%
    \def\sectionmark##1{%
      \markright {{%
        \ifnum \c@secnumdepth >\z@
          \thesection \quad %
%          \thesection \ %
        \fi
        ##1}}}}
\else
  \def\ps@headings{%
    \let\@oddfoot\@empty
    \def\@oddhead{{\small\itshape\rightmark}\small\hfil\thepage}%
    \let\@mkboth\markboth
    \def\chaptermark##1{%
      \markright {{%
        \ifnum \c@secnumdepth >\m@ne
          \if@mainmatter
            \thechapter \quad %
%            \thechapter \ %
          \fi
        \fi
        ##1}}}}
\fi
\def\ps@myheadings{%
    \let\@oddfoot\@empty\let\@evenfoot\@empty
    \def\@evenhead{\small\thepage\hfil\itshape\leftmark}%
    \def\@oddhead{{\small\itshape\rightmark}\small\hfil\thepage}%
    \let\@mkboth\@gobbletwo
    \let\chaptermark\@gobble
    \let\sectionmark\@gobble
    }
  \if@titlepage
  \newcommand\maketitle{\begin{titlepage}%
  \let\footnotesize\small
  \let\footnoterule\relax
  \let \footnote \thanks
  \null\vfil
  \vskip 60\p@\noindent
  \rule{\textwidth}{3\p@}
  \begin{center}%
    {\Huge\bfseries \@title \par}%
    \vskip 3em%
    {\Large
     \lineskip .75em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
      \vskip 1.5em%
  \end{center}\par\noindent
  \rule{\textwidth}{3\p@}
  \@thanks
  \vfill
\begin{center}
	     {\large WILEY-VCH Verlag Berlin GmbH\par \@date \par}%
\end{center}
  \null
  \end{titlepage}%
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\else
\newcommand\maketitle{\par
  \begingroup
    \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
    \def\@makefnmark{\rlap{\@textsuperscript{\normalfont\@thefnmark}}}%
    \long\def\@makefntext##1{\parindent 1em\noindent
            \hb@xt@1.8em{%
                \hss\@textsuperscript{\normalfont\@thefnmark}}##1}%
    \if@twocolumn
      \ifnum \col@number=\@ne
        \@maketitle
      \else
        \twocolumn[\@maketitle]%
      \fi
    \else
      \newpage
      \global\@topnum\z@   % Prevents figures from going at top of page.
      \@maketitle
    \fi
    \thispagestyle{plain}\@thanks
  \endgroup
  \setcounter{footnote}{0}%
  \global\let\thanks\relax
  \global\let\maketitle\relax
  \global\let\@maketitle\relax
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\title\relax
  \global\let\author\relax
  \global\let\date\relax
  \global\let\and\relax
}
\def\@maketitle{%
  \newpage
  \null
  \vskip 2em%
  \begin{center}%
  \let \footnote \thanks
    {\LARGE \@title \par}%
    \vskip 1.5em%
    {\large
      \lineskip .5em%
      \begin{tabular}[t]{c}%
        \@author
      \end{tabular}\par}%
    \vskip 1em%
    {\large \@date}%
  \end{center}%
  \par
  \vskip 1.5em}
\fi
\newcommand*\chaptermark[1]{}
\setcounter{secnumdepth}{2}
\newcounter {part}
\newcounter {chapter}
\newcounter {section}[chapter]
\newcounter {subsection}[section]
\newcounter {auxchapter}
\newcounter {auxsection}[auxchapter]
\newcounter {auxsubsection}[auxsection]
\newcounter {subsubsection}[subsection]
\newcounter {paragraph}[subsubsection]
\renewcommand \thepart {\@Roman\c@part}
\renewcommand \thechapter {\@arabic\c@chapter}
\renewcommand \thesection {\thechapter.\@arabic\c@section}
\renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
\renewcommand \theauxchapter {\@arabic\c@auxchapter}
\renewcommand \theauxsection {\theauxchapter.\@arabic\c@auxsection}
\renewcommand\theauxsubsection   {\theauxsection.\@arabic\c@auxsubsection}
\renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
\renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
% \renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
\newcommand\@chapapp{\chaptername}
\newcommand\frontmatter{%
    \cleardoublepage
  \@mainmatterfalse
  \pagenumbering{roman}}
\newcommand\mainmatter{%
    \cleardoublepage
  \@mainmattertrue
  \pagenumbering{arabic}}
\newcommand\backmatter{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \@mainmatterfalse}
\newcommand\part{%
  \if@openright
    \cleardoublepage
  \else
    \clearpage
  \fi
  \thispagestyle{empty}%
  \if@twocolumn
    \onecolumn
    \@tempswatrue
  \else
    \@tempswafalse
  \fi
  \null\vfil
  \secdef\@part\@spart}

\def\@part[#1]#2{%
    \ifnum \c@secnumdepth >-2\relax
      \refstepcounter{part}%
      \addcontentsline{toc}{part}{\thepart\hspace{1em}#1}%
    \else
      \addcontentsline{toc}{part}{#1}%
    \fi
    \markboth{}{}%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \ifnum \c@secnumdepth >-2\relax
       \huge\bfseries \partname~\thepart
       \par
       \vskip 20\p@
     \fi
     \Huge \bfseries #2\par}%
    \@endpart}
\def\@spart#1{%
    {\centering
     \interlinepenalty \@M
     \normalfont
     \Huge \bfseries #1\par}%
    \@endpart}
\def\@endpart{\vfil\newpage
              \if@twoside
                \null
                \thispagestyle{empty}%
                \newpage
              \fi
              \if@tempswa
                \twocolumn
              \fi}
\newcommand\chapter{\if@openright\cleardoublepage\else\clearpage\fi
                    \thispagestyle{empty}%
                    \global\@topnum\z@% Prevents floats from going at top of page
                    \@afterindentfalse% Suppresses indent in the first paragraph
                    \secdef\@chapter\@schapter}
\def\@chapter[#1]#2{\ifnum \c@secnumdepth >\m@ne
                       \if@mainmatter
			 \setcounter{auxsubsection}{0}% we need this for testing in \authorafterheading
                         \refstepcounter{chapter}%
                         \stepcounter{auxchapter}%
                         \typeout{\@chapapp\space\thechapter.}%
                         \addcontentsline{toc}{chapter}%
                                   {\protect\numberline{\thechapter}#2}%
                       \else
                         \addcontentsline{toc}{chapter}{#2}%
                       \fi
                    \else
                      \addcontentsline{toc}{chapter}{#2}%
                    \fi
                    \chaptermark{#1}%
                    \addtocontents{lof}{\protect\addvspace{10\p@}}%
                    \addtocontents{lot}{\protect\addvspace{10\p@}}%
                    \if@twocolumn
                      \@topnewpage[\@makechapterhead{#2}]%
                    \else
                      \@makechapterhead{#2}%
                      \@afterheading
                    \fi}
\def\@makechapterhead#1{%\vspace*{0\p@}%
  {\parindent \z@ \normalfont
    \ifnum \c@secnumdepth >\m@ne
      \if@mainmatter
        \settowidth{\@tempdima}{\Large\bfseries\thechapter}%
        \addtolength{\@tempdima}{1em}%
        \if@normalheading\else
        \ifdim \the\@tempdima < 12mm \setlength{\@tempdima}{12mm}\fi
        \fi
        \parbox[t]{\@tempdima}{\Large\bfseries\thechapter\hfil}%
      \else \@tempdima=0pt \fi%
    \else \@tempdima=0pt \fi%
       \setlength{\@tempdimb}{\textwidth}%
       \addtolength{\@tempdimb}{-\@tempdima}%
       \parbox[t]{\@tempdimb}{\interlinepenalty\@M\Large\bfseries #1}%
       \par\nobreak\vspace{100\p@}%
  }}
\def\@schapter#1{\if@twocolumn
                   \@topnewpage[\@makeschapterhead{#1}]%
                 \else
                   \@makeschapterhead{#1}%
                   \@afterheading
                 \fi
\setcounter{auxsubsection}{0}% we need this for testing in \authorafterheading
\stepcounter{auxchapter}%
}
\def\@makeschapterhead#1{%
  {\parindent \z@ \raggedright
    \normalfont
    \interlinepenalty\@M
    \LARGE \bfseries  #1\par\nobreak% 
    \vskip 100\p@
  }}
\def\@sect#1#2#3#4#5#6[#7]#8{%
  \ifnum #2>\c@secnumdepth
    \let\@svsec\@empty
  \else
    \refstepcounter{#1}%
    \ifnum #2<3 \stepcounter{aux#1} \fi%
    \protected@edef\@svsec{\@seccntformat{#1}\relax}%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@
    \begingroup
      #6{%
        \@hangfrom{\hskip #3\relax\@svsec}%
          \interlinepenalty \@M #8\@@par}%
    \endgroup
    \csname #1mark\endcsname{#7}%
    \addcontentsline{toc}{#1}{%
      \ifnum #2>\c@secnumdepth \else
        \protect\numberline{\csname the#1\endcsname}%
      \fi
      #8}%
  \else
    \def\@svsechd{%
      #6{\hskip #3\relax
      \@svsec #8}%
      \csname #1mark\endcsname{#7}%
      \addcontentsline{toc}{#1}{%
        \ifnum #2>\c@secnumdepth \else
          \protect\numberline{\csname the#1\endcsname}%
        \fi
        #8}}%
  \fi
  \@xsect{#5}}
\newcommand\section{\suppressfloats[t]%s. LaTeX-Begleiter S.147
                                   \@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\raggedright\normalfont\Large\bfseries}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\raggedright\normalfont\large\bfseries}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\raggedright\normalfont\normalsize\bfseries}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                                    {3.25ex \@plus1ex \@minus.2ex}%
                                    {-1em}%
                                    {\normalfont\normalsize\bfseries}}
% \newcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
%                                        {3.25ex \@plus1ex \@minus .2ex}%
%                                        {-1em}%
%                                       {\normalfont\normalsize\bfseries}}
% preface chapter
\def\preface{\chapter*{\prefacename}
\markboth{\prefacename}{\prefacename}}
\def\endpreface{\newpage\markboth{}{}}
\newcommand{\prefaceauthor}[2]{%
\vskip 2.5ex \@plus .2ex
\begin{flushright}
	 \shortstack[l]{\textit{#1}\\ \rule{0em}{2em}#2}
\end{flushright}
}
% author in heading for toc (chapter, section etc.)
\newswitch{toc}
\newcommand{\toc@author}[1]{%
	\for{toc}{\textnormal{\hskip 2em \@plus.5em \@minus 2em(\textit{#1})}}}
\newcommand{\tocauthor}[1]{\protect\toc@author{#1}}
% author after heading in text
\newcommand{\authorafterheading}[1]{%
\ifnum\c@auxsubsection<1
	 \ifnum\c@auxsection<1
		  \ifnum\c@auxchapter<1
		  \else%
		  \vskip-80pt%
		  \textit{#1}
		  \vskip70pt%
		  \fi%
	 \else%
	 \textit{#1}\vskip 2.3ex \@plus.2ex%
	 \fi%
\else%
\textit{#1}\vskip 1.5ex \@plus .2ex%
\fi%
\@afterindentfalse
\@afterheading
}%
\newcommand{\affil}[1]{%
\ifnum\c@auxsubsection<1
	 \ifnum\c@auxsection<1
		  \ifnum\c@auxchapter<1
		  \else%
		  \vskip-60pt%
				#1 %after chapter
		  \vskip50pt%
		  \fi%
	 \else%
		  #1 %after section
	 \vskip 2.3ex \@plus.2ex%
	 \fi%
\else%
 	 #1 %after subsection
\vskip 1.5ex \@plus .2ex%
\fi%
\@afterindentfalse
\@afterheading
}
% 
\if@twocolumn
  \setlength\leftmargini  {2em}
\else
  \setlength\leftmargini  {2em}
\fi
\leftmargin  \leftmargini
\setlength\leftmarginii  {1.75em}
\setlength\leftmarginiii {1.5em}
\setlength\leftmarginiv  {1.25em}
\if@twocolumn
  \setlength\leftmarginv  {.5em}
  \setlength\leftmarginvi {.5em}
\else
  \setlength\leftmarginv  {1em}
  \setlength\leftmarginvi {1em}
\fi
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}{\list{}{%
  \advance\leftmargini6\p@ \itemindent-12\p@
  \labelwidth\z@ \let\makelabel\descriptionlabel}%
}{
  \endlist
}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}
\def\trivlist{%
  \parsep\parskip
  \@nmbrlistfalse
  \@trivlist
  \labelwidth\z@
  \leftmargin\z@
  \itemindent\z@
  \let\@itemlabel\@empty
  \def\makelabel##1{\upshape##1}}
\renewenvironment{enumerate}{%
  \ifnum \@enumdepth >3 \@toodeep\else
      \advance\@enumdepth \@ne
      \edef\@enumctr{enum\romannumeral\the\@enumdepth}\list
      {\csname label\@enumctr\endcsname}{\usecounter
        {\@enumctr}\def\makelabel##1{\hss\llap{\upshape##1}}}\fi
}{%
  \endlist
}
\let\endenumerate=\endlist % for efficiency
\renewenvironment{itemize}{%
  \ifnum\@itemdepth>3 \@toodeep
  \else \advance\@itemdepth\@ne
    \edef\@itemitem{labelitem\romannumeral\the\@itemdepth}%
    \list{\csname\@itemitem\endcsname}%
      {\def\makelabel##1{\hss\llap{\upshape##1}}}%
  \fi
}{%
  \endlist
}
\let\enditemize=\endlist % for efficiency
\if@compatibility
\newenvironment{titlepage}
    {%
      \cleardoublepage
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\z@
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
    }
\else
\newenvironment{titlepage}
    {%
      \cleardoublepage
      \if@twocolumn
        \@restonecoltrue\onecolumn
      \else
        \@restonecolfalse\newpage
      \fi
      \thispagestyle{empty}%
      \setcounter{page}\@ne
    }%
    {\if@restonecol\twocolumn \else \newpage \fi
     \if@twoside\else
        \setcounter{page}\@ne
     \fi
    }
\fi
\newcommand\appendix{\par
  \setcounter{chapter}{0}%
  \setcounter{section}{0}%
  \setcounter{auxchapter}{0}%
  \setcounter{auxsection}{0}%
  \gdef\@chapapp{\appendixname}%
  \gdef\thechapter{\@Alph\c@chapter}}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\@addtoreset {equation}{chapter}
\renewcommand\theequation
  {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@equation}
\newcounter{figure}[chapter]
\renewcommand \thefigure
     {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@figure}
\def\fps@figure{tbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
\newenvironment{vchfigure}[1][tbp]
               {\begin{figure}[#1]\leftskip=3em}
               {\end{figure}}
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
\newcounter{table}[chapter]
\renewcommand \thetable
     {\ifnum \c@chapter>\z@ \thechapter.\fi \@arabic\c@table}
\def\fps@table{tbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newenvironment{table}
               {\@float{table}}
               {\end@float}
\newenvironment{vchtable}[1][tbp]
               {\begin{table}[#1]\leftskip=3em}
               {\end{table}}
\newenvironment{table*}
               {\@dblfloat{table}}
               {\end@dblfloat}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\setlength\abovecaptionskip{8\p@}
\setlength\belowcaptionskip{5\p@}
\long\def\@makecaption#1#2{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\newlength\captionwidth \captionwidth=\hsize
\def\vchcaption{\refstepcounter\@captype \@dblarg{\@vchcaption\@captype}}
\long\def\@vchcaption#1[#2]#3{%
  \par
  \addcontentsline{\csname ext@#1\endcsname}{#1}%
    {\protect\numberline{\csname the#1\endcsname}{\ignorespaces #2}}%
  \begingroup
    \@parboxrestore
    \if@minipage
      \@setminipage
    \fi
    \normalsize
    \@makevchcaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
  \endgroup}
\long\def\@makevchcaption#1#2{%
  \vskip\abovecaptionskip
  \setlength{\@tempdima}{\hsize}
  \addtolength{\@tempdima}{-3em}%
%  \addtolength{\@tempdima}{-3em}%--uncomment if symmetry is wanted
    \rule{3em}{0mm}\parbox[t]{\@tempdima}{{\small \textbf{#1:} #2}}%
  \vskip\belowcaptionskip}
\IfFileExists{caption2.sty}%
  {\RequirePackage[nooneline,small,bf]{caption2}}%
  {\typeout{Can't find caption2.sty -- will use normal caption layout 
  for oneline caption.}}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
\newcommand\@pnumwidth{1.55em}
\newcommand\@tocrmarg{2.55em}
\newcommand\@dotsep{4.5}
\setcounter{tocdepth}{2}
\newswitch{lof}
\newswitch{lot}
\def\@starttoc#1#2{%
  \begingroup
  \setTrue{#1}%
  \let\secdef\@gobbletwo \chapter%
  \let\@secnumber\@empty % for \@tocwrite and \chaptermark
  \typeout{#2}\expandafter\chaptermark\expandafter{#2}%
  \@makeschapterhead{#2}\@afterheading
  \parskip\z@skip
  \makeatletter
      \@mkboth{%
          \small #2}{\small#2}%
  \@input{\jobname.#1}%
  \if@filesw
    \expandafter\newwrite\csname tf@#1\endcsname
    \immediate\expandafter\openout\csname tf@#1\endcsname \jobname.#1\relax
  \fi
  \global\@nobreakfalse \endgroup
  \newpage
}
\def\tableofcontents{%
  \@starttoc{toc}\contentsname
}
\newcommand*\l@part[2]{%
  \ifnum \c@tocdepth >-2\relax
    \addpenalty{-\@highpenalty}%
    \addvspace{2.25em \@plus\p@}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      {\leavevmode
       \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
       \nobreak
         \global\@nobreaktrue
         \everypar{\global\@nobreakfalse\everypar{}}%
    \endgroup
  \fi}
\newcommand*\l@chapter[2]{%
  \ifnum \c@tocdepth >\m@ne
    \addpenalty{-\@highpenalty}%
    \vskip 1.0em \@plus\p@
    \setlength\@tempdima{1.5em}%
    \begingroup
      \parindent \z@ \rightskip \@pnumwidth
      \parfillskip -\@pnumwidth
      \leavevmode \bfseries
      \advance\leftskip\@tempdima
      \hskip -\leftskip
      #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
      \penalty\@highpenalty
    \endgroup
  \fi}
\newcommand*\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
\newcommand*\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}
\newcommand*\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}
\newcommand*\l@paragraph{\@dottedtocline{4}{10em}{5em}}
% \newcommand*\l@subparagraph{\@dottedtocline{5}{12em}{6em}}
\newcommand\listoffigures{%
\cleardoublepage\addcontentsline{toc}{chapter}{\listfigurename}%
\@starttoc{lof}\listfigurename}%
\newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
% \newcommand*\l@figure{\@dottedtocline{1}{0em}{2.3em}}%--not left indented
\newcommand\listoftables{%
\cleardoublepage\addcontentsline{toc}{chapter}{\listtablename}%
\@starttoc{lot}\listtablename}%
\let\l@table\l@figure
\newdimen\bibindent
\setlength\bibindent{1.5em}
\newcounter{bib@depth}
\newenvironment{thebibliography}[2][0]
     {\setcounter{bib@depth}{#1}%
	  \ifnum\thebib@depth=0
	  \chapter*{\bibname\@mkboth{\small\bibname}{\small\bibname}}%
		  \addcontentsline{toc}{chapter}{\bibname}%
	  \else
	  \ifnum\thebib@depth=1
	  \section*{\bibname\markright{\small\bibname}}%
		  \addcontentsline{toc}{section}{\bibname}%
	  \else
	  \ifnum\thebib@depth=2
	  \subsection*{\bibname}%
		  \addcontentsline{toc}{subsection}{\bibname}%
	  \else
	  \ClassError{vch-book}{Optional argument of `thebibliography' must be 0, 1, or 2}%
	  {0 = chapter, 1 = section, 2 = subsection}
	  \fi\fi\fi%
      \list{\@biblabel{\@arabic\c@enumiv}}%
           {\settowidth\labelwidth{\@biblabel{#2}}%
            \leftmargin\labelwidth
            \advance\leftmargin\labelsep
%            \parsep \z@
            \parsep -2.5\p@ \@plus\p@ \@minus\p@
            \@openbib@code
            \usecounter{enumiv}%
            \let\p@enumiv\@empty
            \renewcommand\theenumiv{\@arabic\c@enumiv}}%
      \sloppy
      \clubpenalty4000
      \@clubpenalty \clubpenalty
      \widowpenalty4000%
      \sfcode`\.\@m}
     {\def\@noitemerr
       {\@latex@warning{Empty `thebibliography' environment}}%
      \endlist}
\newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
\let\@openbib@code\@empty
\newif\ifhave@multicol
\IfFileExists{multicol.sty}{\have@multicoltrue
                            \RequirePackage{multicol}%
                           }{}
\newdimen\IndexMin         \IndexMin       = 80pt
\ifhave@multicol
  \newenvironment{theindex}
    {\begin{multicols}\c@IndexColumns[\index@prologue][\IndexMin]%
		 \if@twocolindex
			 \IndexParmsii
		 \else
			 \IndexParmsiii
		 \fi
		\let\item\@idxitem \ignorespaces}%
    {\end{multicols}}
\else
  \typeout{Can't find multicol.sty -- will use normal index layout if
     necessary.}
  \def\theindex{\@restonecoltrue\if@twocolumn\@restonecolfalse\fi%
		  \if@openright\cleardoublepage\else\clearpage\fi%
		  \twocolumn[\@makeschapterhead{\indexname}]%
		  \@mkboth{\small\indexname}%
					 {\small\indexname}%
                \thispagestyle{empty}\parindent\z@
					 \addcontentsline{toc}{chapter}{\indexname}%
    \IndexParmsii \let\item\@idxitem \ignorespaces}
  \def\endtheindex{\if@restonecol\onecolumn\else\clearpage\fi}
\fi
\@ifundefined{index@prologue}
     {\def\index@prologue{\chapter*{\indexname}%
                \markboth{\small\indexname}{\small\indexname}%
                \thispagestyle{empty}\parindent\z@
		\addcontentsline{toc}{chapter}{\indexname}%
                 }}{}
\@ifundefined{IndexParmsii}
    {\def\IndexParmsii{%
       \parindent \z@
       \columnsep 35pt
       \parskip 0pt plus 0.3pt
       \rightskip 15pt
       \mathsurround \z@
        \small
       \def\@idxitem{\par\hangindent 40pt}%
       \def\subitem{\@idxitem\hspace*{20pt}}%
       \def\subsubitem{\@idxitem\hspace*{30pt}}%
       \def\indexspace{\par\vspace{10pt plus 5pt minus 3pt}}%
      }}{}
\@ifundefined{IndexParmsiii}
    {\def\IndexParmsiii{%
       \parindent \z@
       \columnsep 15pt
       \parskip 0pt plus 1pt
       \rightskip 15pt
       \mathsurround \z@
        \small
       \def\@idxitem{\par\hangindent 30pt}%
       \def\subitem{\@idxitem\hspace*{15pt}}%
       \def\subsubitem{\@idxitem\hspace*{25pt}}%
       \def\indexspace{\par\vspace{10pt plus 2pt minus 3pt}}%
      }}{}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule\@width.4\columnwidth
  \kern2.6\p@}
\@addtoreset{footnote}{chapter}
\newcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}
\newcommand\contentsname{Contents}
\newcommand\listfigurename{List of Figures}
\newcommand\listtablename{List of Tables}
\newcommand\bibname{Bibliography}
\newcommand\indexname{Index}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newcommand\partname{Part}
\newcommand\chaptername{Chapter}
\newcommand\appendixname{Appendix}
\newcommand\prefacename{Preface}
\def\today{\ifcase\month\or
  January\or February\or March\or April\or May\or June\or
  July\or August\or September\or October\or November\or December\fi
  \space\number\day, \number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{headings}
\pagenumbering{arabic}
\if@twoside
\else
  \raggedbottom
\fi
\if@twocolumn
  \twocolumn
  \sloppy
  \flushbottom
\else
  \onecolumn
\fi
\newcommand{\spaced}{\spaceskip=6.66pt plus 6.68pt minus 2.22pt\vspace{0.2cm}}
\newcommand{\onelinespaced}{\spaceskip=6.66pt plus 6.68pt minus 2.22pt}
\endinput
%%
%% End of file `vch-book.cls'.
