%%% STYLE of the Proceedings of Gokava Geometry-Topology Conference.
%%% Author: Tubitak Matbaasi
%%% Revision : 1.0
%%% ====================================================================
%%%  @LaTeX-file{
%%%     filename        = "gokova.cls"
%%%     author          = "Tubitak Matbaasi"
%%%     address         = "Tubitak Matbaasi
%%%                        Kavaklidere Ankara/Turkey"
%%%     telephone       = "(+90) 312-4685300/2106"
%%%     email           = "acan@tubitak.gov.tr"
%%%     keywords        = "gokova.cls"
%%%  }
%%% ====================================================================

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{gokova}[1997/01/07 v1.1 GOKOVA Author Class]


\DeclareOption*{\PassOptionsToClass{\CurrentOption}{amsart}}
\PassOptionsToClass{reqno}{amsart}
\ProcessOptions
\LoadClass{amsart}

\def\serieslogo@{\vtop to 5pt{%
  \parindent\z@ \small\normalfont
  \hbox{Proceedings of \@volume $^{th}$ G\"{o}kova}
  \hbox{Geometry-Topology Conference,}
  \hbox{pp, \pageref{FirstPage}\ -- \pageref{LastPage} %
  } \endgraf\vss}}

\def\maketitle{\par
  \@topnum\z@ 
  \ifx\@empty\shortauthors \let\shortauthors\shorttitle
  \else \andify\shortauthors \fi %%%%%% \uppercasenonmath\shortauthors \fi
  \begingroup
  \@maketitle
  \toks@\@xp{\shortauthors}\@temptokena\@xp{\shorttitle}%
  \edef\@tempa{\@nx\markboth{\the\toks@}{\the\@temptokena}}\@tempa
  \endgroup
  \thispagestyle{firstpage}% this sets first page specifications
  \c@footnote\z@
  \def\do##1{\let##1\relax}%
  \do\maketitle \do\@maketitle \do\title \do\@xtitle \do\@title
  \do\author \do\@xauthor \do\address \do\@xaddress
  \do\email \do\@xemail \do\curraddr \do\@xcurraddr
\do\commby \do\@commby
  \do\dedicatory \do\@dedicatory \do\thanks \do\thankses
  \do\keywords \do\@keywords \do\subjclass \do\@subjclass
}



\def\@maketitle{%
  \normalfont\normalsize
  \let\@makefnmark\relax  \let\@thefnmark\relax
\ifx\@empty\@date\else \@footnotetext{\@setdate}\fi
  \ifx\@empty\@subjclass\else \@footnotetext{\@setsubjclass}\fi
  \ifx\@empty\@keywords\else \@footnotetext{\@setkeywords}\fi
  \ifx\@empty\thankses\else \@footnotetext{%
    \def\par{\let\par\@par}\@setthanks}\fi
  \@mkboth{\@nx\shortauthors}{\@nx\shorttitle}%
\global\topskip42\p@ % 5.5 picas to the base of the first title line
  \@settitle
  \ifx\@empty\authors \else \@setauthors \fi
  \ifx\@empty\@commby
  \else
    \baselineskip18\p@
    \vtop{\centering{\footnotesize\@commby\@@par}%
      \global\dimen@i\prevdepth}\prevdepth\dimen@i
  \fi
  \ifx\@empty\@dedicatory
  \else
    \baselineskip18\p@
    \vtop{\centering{\footnotesize\itshape\@dedicatory\@@par}%
      \global\dimen@i\prevdepth}\prevdepth\dimen@i
  \fi
  \@setabstract
  \normalsize
  \dimen@34\p@ \advance\dimen@-\baselineskip
  \vskip\dimen@\relax
} % end \@maketitle



\headheight=12pt % 5pt
\headsep=25pt    % 14pt
\footskip=30pt   % 12pt
\textheight=17.8truecm %50.0pc
\topskip=10pt
\textwidth=13.6truecm  %30pc
\columnsep=10pt \columnseprule=0pt
\marginparwidth=90pt
\marginparsep=11pt
\marginparpush=5pt
\def\firstpage@putlabel{
   \immediate\write\@auxout{\string
   \newlabel{FirstPage}{{}{\thepage}}}%
}
\AtBeginDocument{\firstpage@putlabel%
	\settoheight{\footnotesep}{\footnotesize M$^1$}}%
\def\lastpage@putlabel{\addtocounter{page}{-1}%
   \immediate\write\@auxout{\string
   \newlabel{LastPage}{{}{\thepage}}}%
   \addtocounter{page}{1}}
\AtEndDocument{\clearpage\lastpage@putlabel}%
\skip\footins=7pt plus11pt
\skip\@mpfootins=\skip\footins
\fboxsep=3pt \fboxrule=.4pt
\arrayrulewidth=.4pt    \doublerulesep=2pt
\labelsep=5pt           \arraycolsep=\labelsep
\tabcolsep=\labelsep    \tabbingsep=\labelsep
\floatsep=15pt plus 12pt    \dblfloatsep=15pt plus 12pt
\textfloatsep=\floatsep  \dbltextfloatsep=15pt plus 12pt
\intextsep=\floatsep
\@fptop=0pt plus1fil     \@dblfptop=0pt plus1fil
\@fpbot=0pt plus1fil     \@dblfpbot=0pt plus1fil
\@fpsep=8pt plus2fil     \@dblfpsep=8pt plus2fil\relax
\parskip=0pt \relax
\newdimen\normalparindent
\normalparindent=12pt
\parindent=\normalparindent
\partopsep=0pt \relax \parsep=0pt \relax \itemsep=0pt \relax
\@lowpenalty=51         \@medpenalty=151        \@highpenalty=301
\@beginparpenalty=-\@lowpenalty
\@endparpenalty=-\@lowpenalty
\@itempenalty=-\@lowpenalty


\def\ps@headings{\ps@empty
   \def\@oddhead{\hfil \small\shortauthors \hfil}
   \let\@evenhead\@oddhead
   \def\@oddfoot{\normalfont  \hfil \thepage }
   \def\@evenfoot{\normalfont \thepage \hfil}
   \let\@mkboth\markboth
}


\def\soyad #1{\gdef\@soyad{#1}}
\def\volume #1{\gdef\@volume{#1}}
\def\year #1{\gdef\@year{#1}}



\def\ps@firstpage{\ps@plain
  \def\@oddfoot{\normalfont \hfil \thepage %\scriptsize \hfil\thepage\hfil
      \global\topskip\normaltopskip}%
  \let\@evenfoot\@oddfoot
  \def\@oddhead{\vbox{\serieslogo@}\hss}
  \let\@evenhead\@oddhead}% in case an article starts on a left-hand page


\def\@settitle{\begin{center}
  \baselineskip14\p@\relax
    \LARGE\bfseries
  \@title
  \end{center}%
}

\def\@setauthors{%
  \begingroup
  \baselineskip32\p@\relax
  \trivlist
  \centering\normalsize       
  \@topsep30\p@\relax
  \advance\@topsep by -\baselineskip
  \item\relax
  \andify\authors
  \it\authors
  \endtrivlist
  \endgroup
}

\def\@sect#1#2#3#4#5#6[#7]#8{%
  \edef\@toclevel{\ifnum#2=\@m 0\else\number#2\fi}%
  \ifnum #2>\c@secnumdepth \let\@secnumber\@empty
  \else \@xp\let\@xp\@secnumber\csname the#1\endcsname\fi
 \ifnum #2>\c@secnumdepth
   \let\@svsec\@empty
 \else
    \refstepcounter{#1}%
    \edef\@svsec{\ifnum#2<\@m
       \@ifundefined{#1name}{}{%
         \ignorespaces\csname #1name\endcsname\space}\fi
       \@nx\textup{%
      \@nx\bfseries  %\mdseries
         \csname the#1\endcsname.}\enspace
    }%
  \fi
  \@tempskipa #5\relax
  \ifdim \@tempskipa>\z@ % then this is not a run-in section heading
    \begingroup #6\relax
    \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty\@M #8\par}%
    \endgroup
    \ifnum#2>\@m \else \@tocwrite{#1}{#8}\fi
 \else
  \def\@svsechd{#6\hskip #3\@svsec
    \@ifnotempty{#8}{\ignorespaces#8\unskip
       \@addpunct.}%
    \ifnum#2>\@m \else \@tocwrite{#1}{#8}\fi
  }%
  \fi
  \global\@nobreaktrue
  \@xsect{#5}}


\def\section{\@startsection{section}{1}%
  \z@{.5\linespacing\@plus\linespacing}{.5\linespacing}%
  {\Large\bfseries}}
\def\subsection{\@startsection{subsection}{2}%
  \z@{.5\linespacing\@plus.7\linespacing}{.5\linespacing}%
  {\large\bfseries}}
\def\subsubsection{\@startsection{subsubsection}{3}%
  \z@{.5\linespacing\@plus.7\linespacing}{.5\linespacing}%
  {\normalfont\bfseries}}


\def\calclayout{
  \advance\oddsidemargin -\textwidth
  \divide\oddsidemargin\tw@
  \ifdim\oddsidemargin<.5truein \oddsidemargin.5truein \fi
  \advance\oddsidemargin -1truein
  \evensidemargin\oddsidemargin
  \topmargin\paperheight
  \advance\topmargin -\textheight
  \advance\topmargin -\headheight
  \advance\topmargin -\headsep
  \divide\topmargin\tw@
  \ifdim\topmargin<.5truein \topmargin.5truein \fi
  \advance\topmargin -1truein\relax
}

\pagenumbering{arabic}
\pagestyle{headings}
\thispagestyle{plain}

\endinput
