%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% This is sfchem.cls, document class for SFCHEM 2002 Proceedings
% Modelled on EslabStyle.cls, version 1.0 for LaTeX2e
% Charles Curry, October 2002
%
% Directions for use may be found in sample.tex
% DO NOT EDIT THIS FILE! 
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{EslabStyle}[1999/06/15 v1.0
^^JEslab publication style file.
^^JLaTeX document class for ESLAB Symposium proceedings]
\newcommand\@ptsize{}
\newcommand{\lae}{\mathrel{<\kern-1.0em\lower0.9ex\hbox{$\sim$}}}
\newcommand{\gae}{\mathrel{>\kern-1.0em\lower0.9ex\hbox{$\sim$}}}
\newif\if@restonecol
\newif\if@titlepage
\@titlepagefalse
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\DeclareOption{openbib}{%
  \AtEndOfPackage{%
   \renewcommand\@openbib@code{%
      \advance\leftmargin\bibindent
      \itemindent -\bibindent
       \listparindent \itemindent
       \parsep \z@
       }%
    \renewcommand\newblock{\par}}%
 }
 %
 \let\if@runhead\iffalse
 \DeclareOption{runningheads}{\let\if@runhead\iftrue}
 \let\if@envcntreset\iffalse
 \DeclareOption{envcountreset}{\let\if@envcntreset\iftrue}
 \let\if@envcntsect\iffalse
 \DeclareOption{envcountsect}{\let\if@envcntsect\iftrue}
 \let\if@nyobjects\iffalse
 %
 \ExecuteOptions{letterpaper,twoside,twocolumn,fleqn,final,10pt,runningheads}
 \ProcessOptions
 \AtEndOfClass{\mathindent\z@}
 %
 \if\@ptsize 0
 %
    \renewcommand\normalsize{%
       \@setfontsize\normalsize\@xpt{12}%
       \abovedisplayskip 8.55\p@ \@plus4\p@ \@minus5\p@
       \abovedisplayshortskip \z@ \@plus3\p@
       \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
       \belowdisplayskip \abovedisplayskip
       \let\@listi\@listI}
    \normalsize
    \newcommand\small{%
       \@setfontsize\small\@ixpt{11}%
       \abovedisplayskip 8.5\p@ \@plus3\p@ \@minus4\p@
       \abovedisplayshortskip \z@ \@plus2\p@
       \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
       \def\@listi{\leftmargin\leftmargini
                   \parsep 0\p@ \@plus1\p@ \@minus\p@
                   \topsep 8\p@ \@plus2\p@ \@minus4\p@
                   \itemsep0\p@}%
       \belowdisplayskip \abovedisplayskip
    }
    \newcommand\scriptsize{\@setfontsize\scriptsize\@viipt\@viiipt}
    \newcommand\tiny{\@setfontsize\tiny\@vpt\@vipt}
    \newcommand\large{\@setfontsize\large\@xiipt{13dd}}
    \newcommand\Large{\@setfontsize\Large\@xviipt{17dd}}
    \newcommand\LARGE{\@setfontsize\LARGE\@xviipt{17dd}}
    \newcommand\huge{\@setfontsize\huge\@xxpt{25}}
    \newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}
    %
    \setlength\parindent{15\p@}
    \setlength\smallskipamount{3\p@ \@plus 1\p@ \@minus 1\p@}
    \setlength\medskipamount{6\p@ \@plus 2\p@ \@minus 2\p@}
    \setlength\bigskipamount{12\p@ \@plus 4\p@ \@minus 4\p@}
    \setlength\headheight{32\p@}
    \setlength\headsep   {44\p@}
    \setlength\topskip   {8\p@}
    \setlength\footskip{30\p@}
    \setlength\maxdepth{.5\topskip}
    %
    \@settopoint\textwidth
    \setlength\marginparsep {10\p@}
    \setlength\marginparpush{5\p@}
    \setlength\oddsidemargin{-0.25in}
    \setlength\evensidemargin{-0.25in}
    \setlength\topmargin{-.7in}
    \setlength\footnotesep{8\p@}
    \setlength{\skip\footins}{9\p@ \@plus 4\p@ \@minus 2\p@}
    \setlength\floatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
    \setlength\textfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
    \setlength\intextsep   {20\p@ \@plus 2\p@ \@minus 2\p@}
    \setlength\dblfloatsep    {12\p@ \@plus 2\p@ \@minus 2\p@}
    \setlength\dbltextfloatsep{20\p@ \@plus 2\p@ \@minus 4\p@}
    \setlength\@fptop{0\p@ \@plus 1fil}
    \setlength\@fpsep{8\p@ \@plus 2fil}
    \setlength\@fpbot{0\p@ \@plus 1fil}
    \setlength\@dblfptop{0\p@ \@plus 1fil}
    \setlength\@dblfpsep{8\p@ \@plus 2fil}
    \setlength\@dblfpbot{0\p@ \@plus 1fil}
    \setlength\partopsep{2\p@ \@plus 1\p@ \@minus 1\p@}
    \def\@listi{\leftmargin\leftmargini
                \parsep \z@
                \topsep 4\p@ \@plus2\p@ \@minus4\p@
                \itemsep\parsep}
    \let\@listI\@listi
    \@listi
    \def\@listii {\leftmargin\leftmarginii
                  \labelwidth\leftmarginii
                  \advance\labelwidth-\labelsep
                  \topsep    \z@
                  \parsep    \topsep
                  \itemsep   \parsep}
    \def\@listiii{\leftmargin\leftmarginiii
                  \labelwidth\leftmarginiii
                  \advance\labelwidth-\labelsep
                  \topsep    \z@
                  \parsep    \topsep
                  \itemsep   \parsep}
    \def\@listiv {\leftmargin\leftmarginiv
                  \labelwidth\leftmarginiv
                  \advance\labelwidth-\labelsep}
    \def\@listv  {\leftmargin\leftmarginv
                  \labelwidth\leftmarginv
                  \advance\labelwidth-\labelsep}
    \def\@listvi {\leftmargin\leftmarginvi
                  \labelwidth\leftmarginvi
                  \advance\labelwidth-\labelsep}
 \else
    \input{size1\@ptsize.clo}
 \fi
 %
 \let\footnotesize\small
 %

 \setlength{\textwidth}{7in}
 \setlength{\textheight}{8.35in}
 %
 \setlength\lineskip{1\p@}
 \setlength\normallineskip{1\p@}
 \renewcommand\baselinestretch{}
 \setlength\parskip{0\p@ \@plus \p@}
 \@lowpenalty   51
 \@medpenalty  151
 \@highpenalty 301
 %
 \setcounter{topnumber}{4}
 \renewcommand\topfraction{.9}
 \setcounter{bottomnumber}{1}
 \renewcommand\bottomfraction{.3}
 \setcounter{totalnumber}{6}
 \renewcommand\textfraction{.15}
 \renewcommand\floatpagefraction{.85}
 \setcounter{dbltopnumber}{3}
 \renewcommand\dbltopfraction{.85}
 \renewcommand\dblfloatpagefraction{.85}
 %
 \def\ps@headings{%
     \let\@oddfoot\@empty\let\@evenfoot\@empty
     \def\@evenhead{\small\rlap{\thepage}\hfil\leftmark\hfil}%
     \def\@oddhead{\small\hfil\rightmark\hfil\llap{\thepage}}%
     \let\@mkboth\@gobbletwo
     \let\sectionmark\@gobble
     \let\subsectionmark\@gobble
     }
 % make indentations changeable
 \def\setitemindent#1{\settowidth{\labelwidth}{#1}%
         \leftmargini\labelwidth
         \advance\leftmargini\labelsep
    \def\@listi{\leftmargin\leftmargini
         \labelwidth\leftmargini\advance\labelwidth by -\labelsep
         \parsep=\parskip
         \topsep=\medskipamount
         \itemsep=\parskip \advance\itemsep by -\parsep}}
 \def\setitemitemindent#1{\settowidth{\labelwidth}{#1}%
         \leftmarginii\labelwidth
         \advance\leftmarginii\labelsep
 \def\@listii{\leftmargin\leftmarginii
         \labelwidth\leftmarginii\advance\labelwidth by -\labelsep
         \parsep=\parskip
         \topsep=\z@
         \itemsep=\parskip \advance\itemsep by -\parsep}}
 \def\descriptionlabel#1{\hspace\labelsep #1\hfil}
 \def\description{\@ifnextchar[{\@describe}{\list{}{\labelwidth\z@
           \itemindent-\leftmargin \let\makelabel\descriptionlabel}}}
 \let\enddescription\endlist
 %
 \def\describelabel#1{#1\hfil}
 \def\@describe[#1]{\relax\ifnum\@listdepth=0
 \setitemindent{#1}\else\ifnum\@listdepth=1
 \setitemitemindent{#1}\fi\fi
 \list{--}{\let\makelabel\describelabel}}
 %
 \newdimen\logodepth
 \logodepth=0cm
 \newdimen\headerboxheight
 \headerboxheight=160.00pt
 \headerboxheight=100.00pt
 \newdimen\betweenumberspace          % dimension for space between
 \betweenumberspace=3.33pt            % number and text of titles.
 \newdimen\aftertext                  % dimension for space after
 \aftertext=5pt                       % text of title.
 \newdimen\headlineindent             % dimension for space between
 \headlineindent=1.166cm              % number and text of headings.
 \def\andname{and}
 \def\keywordname{{Key words:}}
 \def\lastandname{, and}
 \def\keywords{\par\addvspace\baselineskip\noindent\keywordname\
 \ignorespaces}
 %
 \newcounter{inst}
 \newcounter{auth}
 \newdimen\instindent
 \newbox\authrun
 \newtoks\authorrunning
 \newbox\titrun
 \newtoks\titlerunning

 \def\journalname#1{\gdef\@journalname{#1}}
 \gdef\@journalname{A\&A}

 \def\headnote#1{\gdef\@headnote{#1}}
 \def\@headnote{}

 \def\dedication#1{\gdef\@dedic{#1}}
 \def\@dedic{}

 \let\@date\undefined

 \def\institute#1{\gdef\@institute{#1}}

 \def\institutename{\par
  \begingroup
  \parindent=0pt
  \parskip=0pt
  \setcounter{inst}{1}%
  \def\and{\par\stepcounter{inst}%
  \hangindent\instindent
  \noindent
\hbox to\instindent{\hss$^{\theinst}$}\ignorespaces}%
  \setbox0=\vbox{\def\thanks##1{}\@institute}
  \ifnum\value{inst}>9\relax\setbox0=\hbox{$^{88}$}%
                  \else\setbox0=\hbox{$^{8}$}\fi
  \instindent=\wd0\relax
  \ifnum\value{inst}=1\relax
  \else
    \setcounter{inst}{1}%
    \hangindent\instindent
    \noindent
    \hbox to\instindent{\hss$^{\theinst}$}\ignorespaces
  \fi
  \small
  \ignorespaces
  \@institute\par
  \endgroup}

 \def\@thanks{}

 \def\@fnsymbol#1{\ifcase#1\or\star\or{\star\star}\or{\star\star\star}%
    \or \dagger\or \ddagger\or
    \mathchar "278\or \mathchar "27B\or \|\or **\or \dagger\dagger
    \or \ddagger\ddagger \else\@ctrerr\fi\relax}

 \def\inst#1{\unskip$^{#1}$}
 \def\fnmsep{\unskip$^,$}

 \def\subtitle#1{\gdef\@subtitle{#1}}
 \def\@subtitle{}

 \def\headnote#1{\gdef\@headnote{#1}}
 \def\@headnote{}

 \def\thesaurus#1{\gdef\@thesaurus{#1}}

 \def\ch@ckobl#1#2{\@ifundefined{@#1}
  {\typeout{Warning: Missing
 \expandafter\string\csname#1\endcsname}%
   \csname #1\endcsname{#2}}
  {}}

 \newif\if@normhead \@normheadtrue
 \def\hugehead{\@normheadfalse
 \onecolumn
 \let\thanks=\footnote
 \long\def\@makefntext##1{\parindent\bibindent
      \columnwidth\textwidth\advance\columnwidth -\columnsep
      \divide\columnwidth\tw@\hsize\columnwidth \linewidth\columnwidth
      \noindent\hbox to\parindent{\hss$\m@th^{\@thefnmark}$ }##1}%
 }

 \def\maketitle{\par
 \ch@ckobl{journalname}{Noname}
 \ch@ckobl{title}{A title should be given}
 \ch@ckobl{author}{Name(s) and initial(s) of author(s) should be given}
 \ch@ckobl{institute}{Address(es) of author(s) should be given}
 \begingroup
 %
     \renewcommand\thefootnote{\@fnsymbol\c@footnote}%
     \def\@makefnmark{$^{\@thefnmark}$}%
 %
  \def\lastand{\ifnum\value{inst}=2\relax
                  \unskip{} \andname\
               \else
                  \unskip, \andname\
               \fi}%
  \def\and{\stepcounter{auth}\relax
           \ifnum\value{auth}=\value{inst}%
              \lastand
           \else
              \unskip,
           \fi}%
  \ifnum \col@number=\@ne
    \@maketitle
  \else
    \twocolumn[\@maketitle]%
  \fi  
  \thispagestyle{plain}
  \global\@topnum\z@
  \if@normhead
     \@thanks
  \else
     \twocolumn[\vspace{\@tempdima}]
     \addtocounter{page}{-1}
     \if!\the\authorrunning!
        \authorrunning{ }%
     \fi
  \fi
  \if@runhead
     \def\\{\unskip\ \ignorespaces}\def\inst##1{\unskip{}}%
     \def\thanks##1{\unskip{}}\def\fnmsep{\unskip}%
     \def\object##1{##1}%
     \instindent=\textwidth
     \advance\instindent by-2\headlineindent
     \if!\the\titlerunning!\else
       \edef\@title{\the\titlerunning}%
     \fi
     \global\setbox\titrun=\hbox{\small\rm\unboldmath\ignorespaces\@title}%
     \ifdim\wd\titrun>\instindent
        \typeout{^^JWarning: Title too long for running head.}%
        \typeout{Please supply a shorter form with \string\titlerunning
                 \space prior to \string\maketitle}%
        \global\setbox\titrun=\hbox{\small\rm
        Title Suppressed Due to Excessive Length}%
     \fi
     \xdef\@title{\copy\titrun}%
 %
     \if!\the\authorrunning!
     \else
       \setcounter{auth}{1}%
       \edef\@author{\the\authorrunning}%
     \fi
     \ifnum\value{auth}>2
        \def\stripauthor##1\and##2\endauthor{%
        \protected@xdef\@author{##1\unskip\unskip\if!##2!\else
        \ et al.\fi}}%
        \expandafter\stripauthor\@author\and\endauthor
     \else
        \gdef\and{\unskip\ \& \ignorespaces}%
        {\def\and{\noexpand\protect\noexpand\and}%
        \protected@xdef\@author{\@author}}
     \fi
     \global\setbox\authrun=\hbox{\small\unboldmath\@author\unskip:
                                  \unhbox\titrun}%
     \ifdim\wd\authrun>\instindent
 %
     \typeout{^^JWarning: The running head built automatically
              from \string\author\space and \string\title
              ^^Jexceeds the pagewidth, please supply a shorter form
              ^^Jwith \string\authorrunning\space and/or
              \string\titlerunning\space prior to \string\maketitle}%
     \global\setbox\authrun=\hbox{\small\rm Please give a shorter version
        with: {\tt\string\authorrunning\space}and/or{\tt\space
        \string\titilerunning\space}prior to{\tt\space\string\maketitle}}%
     \fi
     \xdef\@author{\copy\authrun}%
     \markboth{\@author}{\@author}%
  \fi
 %
  \endgroup
  \setcounter{footnote}{0}
  \setcounter{footnote}{0}%
  \global\let\@thanks\@empty
  \global\let\@author\@empty
  \global\let\@date\@empty
  \global\let\@title\@empty
  \global\let\@subtitle\@empty
  \global\let\date\relax
  \global\let\and\relax}


 \def\@maketitle{\newpage
  \normalfont
  \vbox to0pt{\vskip-40pt
  \nointerlineskip
  \vss}\nointerlineskip
  \if@normhead
     \setbox\authrun=\vbox\bgroup
  \fi
  {\bf\boldmath
   \hrule\@height\logodepth\@width\z@
   \pretolerance=10000
   \rightskip=0pt plus 4cm
  \if!\@headnote!\else
    \noindent
    {\em\ignorespaces\@headnote\par}\vskip 3.5mm
  \fi
   \noindent\ignorespaces
 \centering{
  \MakeUppercase\@title \par}}\vskip 11.24pt\relax
  \bf
  \if!\@subtitle!\else
    {\large\bf\boldmath
    \pretolerance=10000
    \rightskip=0pt plus 3cm
    \noindent\ignorespaces
\centering{\@subtitle \par}}\vskip 11.24pt
  \fi
  \lineskip .5em
  \setbox0=\vbox{\setcounter{auth}{1}\def\and{\stepcounter{auth} }%
                 \hfuzz=2\textwidth\def\thanks##1{}\@author}%
  \value{inst}=\value{auth}%
  \setcounter{auth}{1}%
  \rightskip=0pt plus 2cm
  \noindent\ignorespaces\centering{\@author}\vskip7.23pt
  \rightskip=0pt\relax
  \small\rm
  \centering{\institutename}

  \if!\@dedic!\else
     \par
     \normalsize\it
     \addvspace\baselineskip
     \noindent\@dedic
  \fi
  \if@normhead
     \egroup % end of header box
     \@tempdima=\headerboxheight
     \advance\@tempdima by-\ht\authrun
     \ifdim\@tempdima>0pt
        \vrule width0pt height\@tempdima
     \fi
     \unvbox\authrun
     \global\@minipagetrue
     \global\everypar{\global\@minipagefalse\global\everypar{}}
  \else
     \typeout{\the\c@auth\space author names and}
     \typeout{\the\c@inst\space institutes processed}
     \global\@tempdima=\pagetotal
     \global\advance\@tempdima by22.47pt
  \fi
  \vskip22.47pt
 }
 %
 \DeclareMathAlphabet{\mathsc}{OT1}{cmr}{m}{sc}
 \def\testbx{bx}%
 \DeclareRobustCommand{\ion}[2]{%
 \relax\ifmmode
 \ifx\testbx\f@series
 {\mathbf{#1\,\mathsc{#2}}}\else
 {\mathrm{#1\,\mathsc{#2}}}\fi
 \else\textup{#1\,{\mdseries\textsc{#2}}}%
 \fi}
 %
 \def\clearelargs{\def\1{}\def\2{}\def\3{}\def\4{}\count255=0}
 \def\druck@lement#1{{}^{\2}_{\3}\mathrm{#1}{}^{\1}_{\4}{}\if@tempswa$\fi}
 \DeclareRobustCommand{\element}{\relax\ifmmode\@tempswafalse
 \else$\@tempswatrue\fi\clearelargs\def\?{\phantom{0}}\@lement}
 \def\@lement#1{\if#1[\expandafter\f@@dargs\else\druck@lement{#1}\fi}
 \def\f@@dargs#1]{\advance\count255by\@ne
 \expandafter\def\csname\number\count255\endcsname{#1}\@lement}
 %
 \def\vec#1{\ensuremath{\mathchoice{\mbox{\boldmath$\displaystyle#1$}}
 {\mbox{\boldmath$\textstyle#1$}}
 {\mbox{\boldmath$\scriptstyle#1$}}
 {\mbox{\boldmath$\scriptscriptstyle#1$}}}}
 %
 \def\tens#1{\ensuremath{\mathsf{#1}}}
 %
 \setcounter{secnumdepth}{3}
 \newcounter {section}
 \newcounter {subsection}[section]
 \newcounter {subsubsection}[subsection]
 \newcounter {paragraph}[subsubsection]
 \newcounter {subparagraph}[paragraph]
 \renewcommand\thesection      {\@arabic\c@section}
 \renewcommand\thesubsection   {\thesection.\@arabic\c@subsection}
 \renewcommand\thesubsubsection{\thesubsection .\@arabic\c@subsubsection}
 \renewcommand\theparagraph    {\thesubsubsection.\@arabic\c@paragraph}
 \renewcommand\thesubparagraph {\theparagraph.\@arabic\c@subparagraph}
 %
 \def\sectcounterend{.}
 \def\@hangfrom#1{\setbox\@tempboxa\hbox{#1}%
       \hangindent \z@\noindent\box\@tempboxa}

 \def\@seccntformat#1{\csname the#1\endcsname\sectcounterend
 \hskip\betweenumberspace}

 \def\@sect#1#2#3#4#5#6[#7]#8{%
   \ifnum #2>\c@secnumdepth
     \let\@svsec\@empty
   \else
     \refstepcounter{#1}%
     \protected@edef\@svsec{\@seccntformat{#1}\relax}%
   \fi
   \@tempskipa #5\relax
   \ifdim \@tempskipa>\z@
     \begingroup
       #6{%
         \@hangfrom{\hskip #3\relax\@svsec}%
           \raggedright
           \hyphenpenalty \@M%
           \interlinepenalty \@M #8\@@par}%
     \endgroup
     \csname #1mark\endcsname{#7}%
     \addcontentsline{toc}{#1}{%
       \ifnum #2>\c@secnumdepth \else
         \protect\numberline{\csname the#1\endcsname}%
       \fi
       #7}%
   \else
     \def\@svsechd{%
       #6{\hskip #3\relax
       \@svsec #8\hskip\aftertext}%
       \csname #1mark\endcsname{#7}%
       \addcontentsline{toc}{#1}{%
         \ifnum #2>\c@secnumdepth \else
           \protect\numberline{\csname the#1\endcsname}%
         \fi
         #7}}%
   \fi
   \@xsect{#5}}

 \def\section{\@startsection{section}{1}{\z@}%
    {-16dd plus-4pt minus-4pt}{6dd}%
      {\scshape\centerline}}
 \def\subsection{\@startsection{subsection}{2}{\z@}%
    {-16dd}{6dd}%
      {\scshape\normalsize\centerline}}
 \def\subsubsection{\@startsection{subsubsection}{3}{\z@}%
    {-16dd}{6dd}%
     {\scshape\normalsize\centerline}}
 \def\paragraph{\@startsection{subsubsection}{4}{\z@}%
     {-16dd}{-1pt}
     {\normalsize\it}}

 \setlength\leftmargini  {\parindent}
 \leftmargin  \leftmargini
 \setlength\leftmarginii {\parindent}
 \setlength\leftmarginiii {1.87em}
 \setlength\leftmarginiv  {1.7em}
 \setlength\leftmarginv  {.5em}
 \setlength\leftmarginvi {.5em}
 \setlength  \labelsep  {.5em}
 \setlength  \labelwidth{\leftmargini}
 \addtolength\labelwidth{-\labelsep}
 \@beginparpenalty -\@lowpenalty
 \@endparpenalty   -\@lowpenalty
 \@itempenalty     -\@lowpenalty
 \renewcommand\theenumi{\@arabic\c@enumi}
 \renewcommand\theenumii{\@alph\c@enumii}
 \renewcommand\theenumiii{\@roman\c@enumiii}
 \renewcommand\theenumiv{\@Alph\c@enumiv}
 \newcommand\labelenumi{\theenumi.}
 \newcommand\labelenumii{(\theenumii)}
 \newcommand\labelenumiii{\theenumiii.}
 \newcommand\labelenumiv{\theenumiv.}
 \renewcommand\p@enumii{\theenumi}
 \renewcommand\p@enumiii{\theenumi(\theenumii)}
 \renewcommand\p@enumiv{\p@enumiii\theenumiii}
 \newcommand\labelitemi{\normalfont\bfseries --}
 \newcommand\labelitemii{\normalfont\bfseries --}
 \newcommand\labelitemiii{$\m@th\bullet$}
 \newcommand\labelitemiv{$\m@th\cdot$}

 \def\@thmcountersep{}
 \def\@thmcounterend{.}

 \def\newtheorem{\@ifstar{\@sthm}{\@Sthm}}

 \def\@Sthm#1{\@ifnextchar[{\@othm{#1}}{\@nthm{#1}}}

 \def\@xnthm#1#2[#3]#4#5{\expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}\@addtoreset{#1}{#3}%
    \expandafter\xdef\csname the#1\endcsname{\expandafter\noexpand
      \csname the#3\endcsname \noexpand\@thmcountersep \@thmcounter{#1}}%
    \expandafter\xdef\csname #1name\endcsname{#2}%
    \global\@namedef{#1}{\@thm{#1}{\csname #1name\endcsname}{#4}{#5}}%
                               \global\@namedef{end#1}{\@endtheorem}}}

 \def\@ynthm#1#2#3#4{\expandafter\@ifdefinable\csname #1\endcsname
    {\@definecounter{#1}%
    \expandafter\xdef\csname the#1\endcsname{\@thmcounter{#1}}%
    \expandafter\xdef\csname #1name\endcsname{#2}%
    \global\@namedef{#1}{\@thm{#1}{\csname #1name\endcsname}{#3}{#4}}%
                                \global\@namedef{end#1}{\@endtheorem}}}

 \def\@othm#1[#2]#3#4#5{%
   \@ifundefined{c@#2}{\@latexerr{No theorem environment `#2'
   defined}\@eha}%
   {\expandafter\@ifdefinable\csname #1\endcsname
   {\global\@namedef{the#1}{\@nameuse{the#2}}%
   \expandafter\xdef\csname #1name\endcsname{#3}%
   \global\@namedef{#1}{\@thm{#2}{\csname #1name\endcsname}{#4}{#5}}%
   \global\@namedef{end#1}{\@endtheorem}}}}

 \def\@thm#1#2#3#4{\refstepcounter
     {#1}\@ifnextchar[{\@ythm{#1}{#2}{#3}{#4}}{\@xthm{#1}{#2}{#3}{#4}}}

 \def\@xthm#1#2#3#4{\@begintheorem{#2}{\csname the#1\endcsname}{#3}{#4}%
                     \ignorespaces}

 \def\@ythm#1#2#3#4[#5]{\@opargbegintheorem{#2}{\csname
        the#1\endcsname}{#5}{#3}{#4}\ignorespaces}

 \def\@begintheorem#1#2#3#4{\trivlist
                  \item[\hskip\labelsep{#3#1\ #2\@thmcounterend}]#4}

 \def\@opargbegintheorem#1#2#3#4#5{\trivlist
       \item[\hskip\labelsep{#4#1\ #2\ (#3)\@thmcounterend}]#5}

 \def\@sthm#1#2{\@Ynthm{#1}{#2}}

 \def\@Ynthm#1#2#3#4{\expandafter\@ifdefinable\csname #1\endcsname
    {\global\@namedef{#1}{\@Thm{\csname #1name\endcsname}{#3}{#4}}%
     \expandafter\xdef\csname #1name\endcsname{#2}%
     \global\@namedef{end#1}{\@endtheorem}}}

 \def\@Thm#1#2#3{\@ifnextchar[{\@Ythm{#1}{#2}{#3}}{\@Xthm{#1}{#2}{#3}}}

 \def\@Xthm#1#2#3{\@Begintheorem{#1}{#2}{#3}\ignorespaces}

 \def\@Ythm#1#2#3[#4]{\@Opargbegintheorem{#1}
        {#4}{#2}{#3}\ignorespaces}

 \def\@Begintheorem#1#2#3{#3\trivlist
                            \item[\hskip\labelsep{#2#1\@thmcounterend}]}

 \def\@Opargbegintheorem#1#2#3#4{#4\trivlist
       \item[\hskip\labelsep{#3#1\ (#2)\@thmcounterend}]}

 \if@envcntsect
    \def\@thmcountersep{.}
    \newtheorem{theorem}{Theorem}[section]{\bf}{\it}
 \else
    \newtheorem{theorem}{Theorem}{\bf}{\it}
    \if@envcntreset
       \@addtoreset{theorem}{section}
    \else
       \@addtoreset{theorem}{chapter}
    \fi
 \fi
 \newtheorem*{proof}{Proof}{\it}{\rm}
 \newtheorem{corollary}[theorem]{Corollary}{\bf}{\it}
 \newtheorem{definition}[theorem]{Definition}{\bf}{\rm}
 \newtheorem{example}[theorem]{Example}{\it}{\rm}
 \newtheorem{exercise}[theorem]{Exercise}{\it}{\rm}
 \newtheorem{lemma}[theorem]{Lemma}{\bf}{\it}
 \newtheorem{note}[theorem]{Note}{\it}{\rm}
 \newtheorem{problem}[theorem]{Problem}{\it}{\rm}
 \newtheorem{proposition}[theorem]{Proposition}{\bf}{\it}
 \newtheorem{question}[theorem]{Question}{\it}{\rm}
 \newtheorem{remark}[theorem]{Remark}{\it}{\rm}
 \newtheorem{solution}[theorem]{Solution}{\it}{\rm}

 \def\@takefromreset#1#2{%
     \def\@tempa{#1}%
     \let\@tempd\@elt
     \def\@elt##1{%
         \def\@tempb{##1}%
         \ifx\@tempa\@tempb\else
             \@addtoreset{##1}{#2}%
         \fi}%
     \expandafter\expandafter\let\expandafter\@tempc\csname cl@#2\endcsname
     \expandafter\def\csname cl@#2\endcsname{}%
     \@tempc
     \let\@elt\@tempd}

 \def\theopargself{\def\@opargbegintheorem##1##2##3##4##5{\trivlist
       \item[\hskip\labelsep{##4##1\ ##2\ ##3}]##5}
                   \def\@Opargbegintheorem##1##2##3##4{##4\trivlist
       \item[\hskip\labelsep{##3##1\ ##2}]}
       }

 \def\squareforqed{\hbox{\rlap{$\sqcap$}$\sqcup$}}
 \def\qed{\ifmmode\else\unskip\quad\fi\squareforqed}

 \def\abstract{\topsep=0pt\partopsep=0pt\parsep=0pt\itemsep=0pt\relax
 {\centerline\abstractname}\vskip4pt}
 \def\endabstract{\endtrivlist\addvspace{5mm}\strich}
 \def\strich{\hrule\vskip3ptplus12pt\null}

 \def\acknowledgements{\par\addvspace{6pt}\small\rm
 \trivlist\item[\hskip\labelsep{\centerline \ackname}]}
 \def\endacknowledgements{\endtrivlist\addvspace{16pt}}

 \newenvironment{verse}
                {\let\\\@centercr
                 \list{}{\itemsep      \z@
                         \itemindent   -1.5em%
                         \listparindent\itemindent
                         \rightmargin  \leftmargin
                         \advance\leftmargin 1.5em}%
                 \item\relax}
                {\endlist}
 \newenvironment{quotation}
                {\list{}{\listparindent 1.5em%
                         \itemindent    \listparindent
                         \rightmargin   \leftmargin
                         \parsep        \z@ \@plus\p@}%
                 \item\relax}
                {\endlist}
 \newenvironment{quote}
                {\list{}{\rightmargin\leftmargin}%
                 \item\relax}
                {\endlist}
 \if@compatibility
 \newenvironment{titlepage}
     {%
       \if@twocolumn
         \@restonecoltrue\onecolumn
       \else
         \@restonecolfalse\newpage
       \fi
       \thispagestyle{empty}%
       \setcounter{page}\z@
     }%
     {\if@restonecol\twocolumn \else \newpage \fi
     }
 \else
 \newenvironment{titlepage}
     {%
       \if@twocolumn
         \@restonecoltrue\onecolumn
       \else
         \@restonecolfalse\newpage
       \fi
       \thispagestyle{empty}%
       \setcounter{page}\@ne
     }%
     {\if@restonecol\twocolumn \else \newpage \fi
      \if@twoside\else
         \setcounter{page}\@ne
      \fi
     }
 \fi
 \newcommand\appendix{\par
   \def\sectcounterend{}%
   \setcounter{section}{0}%
   \setcounter{subsection}{0}%
   \setcounter{figure}{0}%
   \setcounter{table}{0}%
   \renewcommand\thesection{Appendix \@Alph\c@section:}%
   \renewcommand\thesubsection{\@Alph\c@section.\@arabic\c@subsection.}%
   \renewcommand\thesubsubsection{\thesubsection\@arabic\c@subsubsection.}%
   \renewcommand\theequation{\@Alph\c@section\@arabic\c@equation}%
   \renewcommand\thefigure{\@Alph\c@section\@arabic\c@figure}%
   \renewcommand\thetable{\@Alph\c@section\@arabic\c@table}%
   \@addtoreset{equation}{section}%
   \@addtoreset{figure}{section}%
   \@addtoreset{table}{section}%
   \def\subfigures{\stepcounter{figure}\setcounter{auth}{\value{figure}}%
   \setcounter{figure}{0}%
   \def\thefigure{\@Alph\c@section\@arabic\c@auth\alph{figure}}%
   \def\resetsubfig{\setcounter{figure}{\value{auth}}}}}
 %
 \setlength\arraycolsep{2.5\p@}
 \setlength\tabcolsep{6\p@}
 \setlength\arrayrulewidth{.4\p@}
 \setlength\doublerulesep{2\p@}
 \setlength\tabbingsep{\labelsep}
 \skip\@mpfootins = \skip\footins
 \setlength\fboxsep{3\p@}
 \setlength\fboxrule{.4\p@}
 \renewcommand\theequation{\@arabic\c@equation}
 \newcounter{figure}
 \renewcommand\thefigure{\@arabic\c@figure}
 \def\fps@figure{tbp}
 \def\ftype@figure{1}
 \def\ext@figure{lof}
 \def\fnum@figure{\figurename\,\thefigure}
 \newenvironment{figure}
                {\@float{figure}}
                {\resetsubfig\end@float}
 \newenvironment{figure*}
                {\@dblfloat{figure}}
                {\resetsubfig\end@dblfloat}
 \let\resetsubfig\relax
 \def\subfigures{\stepcounter{figure}\setcounter{auth}{\value{figure}}%
 \setcounter{figure}{0}\def\thefigure{\@arabic\c@auth\alph{figure}}%
 \def\resetsubfig{\setcounter{figure}{\value{auth}}}}
 \newcounter{table}
 \renewcommand\thetable{\@arabic\c@table}
 \def\fps@table{tbp}
 \def\ftype@table{2}
 \def\ext@table{lot}
 \def\fnum@table{\tablename~\thetable}
 \newenvironment{table}
                {\@float{table}}
                {\end@float}
 \newenvironment{table*}
                {\@dblfloat{table}}
                {\end@dblfloat}

 \def \@floatboxreset {%
         \reset@font
         \small
         \@setnobreak
         \@setminipage
 }

 \newlength\abovecaptionskip
 \newlength\belowcaptionskip
 \setlength\abovecaptionskip{10\p@}
 \setlength\belowcaptionskip{0\p@}
 \newcommand\leftlegendglue{}

 \def\fig@type{figure}

 \newdimen\figcapgap\figcapgap=3pt
 \newdimen\tabcapgap\tabcapgap=5.5pt
 
\@ifundefined{floatlegendstyle}{\def\floatlegendstyle{\it}}{}
 \def\floatcounterend{.}

 \long\def\@caption#1[#2]#3{\par\addcontentsline{\csname
   ext@#1\endcsname}{#1}{\protect\numberline{\csname
   the#1\endcsname}{\ignorespaces #2}}\begingroup
     \@parboxrestore
     \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}\par
   \endgroup}

 \def\capstrut{\vrule\@width\z@\@height\topskip}

 \long\def\@makecaption#1#2{%
  \ifx\@captype\fig@type
    \vskip\figcapgap
   \setbox\@tempboxa\hbox{{\floatlegendstyle \it{#1}\floatcounterend}
    \capstrut #2}%
    \ifdim \wd\@tempboxa >\hsize
     {\floatlegendstyle \it{#1}\floatcounterend} \capstrut \it{#2}\par
    \else
      \hbox to\hsize{\leftlegendglue\unhbox\@tempboxa\hfil}%
    \fi
  \else
  {\floatlegendstyle \it{#1}\floatcounterend} \capstrut \it{#2}\par
    \vskip\tabcapgap
  \fi}
 \def\acknowledgement{\par\addvspace{17pt}\small\rm
 \trivlist\item[\hskip\labelsep
 {\it\ackname}]}
 \def\endacknowledgement{\endtrivlist\addvspace{6pt}}
 \def\noteadd{\par\addvspace{17pt}\small\rm
 \trivlist\item[\hskip\labelsep
 {\it\noteaddname}]}
 \def\endnoteadd{\endtrivlist\addvspace{6pt}}

 \DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
 \DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
 \DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
 \DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
 \DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
 \DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
 \DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
 \DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
 \DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}
 \newcommand\@pnumwidth{1.55em}
 \newcommand\@tocrmarg{2.55em}
 \newcommand\@dotsep{4.5}
 \setcounter{tocdepth}{0}
 \newcommand\tableofcontents{%
     \section*{\contentsname
         \@mkboth{%
            \MakeUppercase\contentsname}{\MakeUppercase\contentsname}}%
     \@starttoc{toc}%
     }
 \newcommand*\l@part[2]{%
   \ifnum \c@tocdepth >-2\relax
     \addpenalty\@secpenalty
     \addvspace{2.25em \@plus\p@}%
     \begingroup
       \setlength\@tempdima{3em}%
       \parindent \z@ \rightskip \@pnumwidth
       \parfillskip -\@pnumwidth
       {\leavevmode
        \large \bfseries #1\hfil \hb@xt@\@pnumwidth{\hss #2}}\par
        \nobreak
        \if@compatibility
          \global\@nobreaktrue
          \everypar{\global\@nobreakfalse\everypar{}}%
       \fi
     \endgroup
   \fi}
 \newcommand*\l@section[2]{%
   \ifnum \c@tocdepth >\z@
     \addpenalty\@secpenalty
     \addvspace{1.0em \@plus\p@}%
     \setlength\@tempdima{1.5em}%
     \begingroup
       \parindent \z@ \rightskip \@pnumwidth
       \parfillskip -\@pnumwidth
       \leavevmode \bfseries
       \advance\leftskip\@tempdima
       \hskip -\leftskip
       #1\nobreak\hfil \nobreak\hb@xt@\@pnumwidth{\hss #2}\par
     \endgroup
   \fi}
 \newcommand*\l@subsection{\@dottedtocline{2}{1.5em}{2.3em}}
 \newcommand*\l@subsubsection{\@dottedtocline{3}{3.8em}{3.2em}}
 \newcommand*\l@paragraph{\@dottedtocline{4}{7.0em}{4.1em}}
 \newcommand*\l@subparagraph{\@dottedtocline{5}{10em}{5em}}
 \newcommand\listoffigures{%
     \section*{\listfigurename
       \@mkboth{\MakeUppercase\listfigurename}%
               {\MakeUppercase\listfigurename}}%
     \@starttoc{lof}%
     }
 \newcommand*\l@figure{\@dottedtocline{1}{1.5em}{2.3em}}
 \newcommand\listoftables{%
     \section*{\listtablename
       \@mkboth{%
           \MakeUppercase\listtablename}{\MakeUppercase\listtablename}}%
     \@starttoc{lot}%
     }
 \let\l@table\l@figure

 \newdimen\bibindent
 \setlength\bibindent{\parindent}
 \newcommand\newblock{\hskip .11em\@plus.33em\@minus.07em}
 \let\@openbib@code\@empty
 \newenvironment{theindex}
                {\if@twocolumn
                   \@restonecolfalse
                 \else
                   \@restonecoltrue
                 \fi
                 \columnseprule \z@
                 \columnsep 35\p@
                 \twocolumn[\section*{\indexname}]%
                 \@mkboth{\MakeUppercase\indexname}%
                         {\MakeUppercase\indexname}%
                 \thispagestyle{plain}\parindent\z@
                 \parskip\z@ \@plus .3\p@\relax
                 \let\item\@idxitem}
                {\if@restonecol\onecolumn\else\clearpage\fi}
 \newcommand\@idxitem{\par\hangindent 40\p@}
 \newcommand\subitem{\@idxitem \hspace*{20\p@}}
 \newcommand\subsubitem{\@idxitem \hspace*{30\p@}}
 \newcommand\indexspace{\par \vskip 10\p@ \@plus5\p@ \@minus3\p@\relax}
 \renewcommand\footnoterule{%
   \kern-3\p@
   \hrule\@width.4\columnwidth
   \kern2.6\p@}
 \newcommand\@makefntext[1]{%
     \noindent
     \hb@xt@\bibindent{\hss\@makefnmark\enspace}#1}
 %
 \newcommand\listofobjects{\if@nyobjects
   \IfFileExists{\jobname.obj}%
                {\section*{\listobjectname}%
                 \@starttoc{obj}}%
                {\begingroup
                    \makeatletter
                    \if@filesw
                       \newwrite\tf@obj
                       \immediate\openout\tf@obj\jobname.obj
                       \relax
                    \fi
                    \global\@nobreakfalse
                 \endgroup}\fi
                }
 %
 \newcommand*\l@obj[2]{\noindent`#1' on page #2\par}
 %
 \DeclareRobustCommand{\object}[1]{#1\global\let\if@nyobjects\iftrue
 \addcontentsline{obj}{obj}{#1}}
 %
 \newcommand\contentsname{Contents}
 \newcommand\listfigurename{List of Figures}
 \newcommand\listobjectname{List of Objects}
 \newcommand\listtablename{List of Tables}
 \newcommand\refname{References}
 \newcommand\indexname{Index}
 \newcommand\figurename{Figure}
 \newcommand\tablename{Table}
 \newcommand\partname{Part}
 \newcommand\appendixname{Appendix}
\newcommand\abstractname{\scshape{Abstract}}
\newcommand\ackname{\scshape{Acknowledgements}}
 \newcommand\noteaddname{Note added in proof}
 \newcommand\today{}
 \edef\today{\ifcase\month\or
   January\or February\or March\or April\or May\or June\or
   July\or August\or September\or October\or November\or December\fi
   \space\number\day, \number\year}
 \setlength\columnsep{4mm}
 \setlength\columnseprule{0\p@}
 \frenchspacing
 \clubpenalty=10000
 \widowpenalty=10000
 \def\thisbottomragged{\def\@textbottom{\vskip\z@ plus.0001fil
 \global\let\@textbottom\relax}}
 \pagestyle{headings}
 \pagenumbering{arabic}
  \twocolumn
 \flushbottom
 \def\squareforqed{\hbox{\rlap{$\sqcap$}$\sqcup$}}
 \def\sq{\ifmmode\squareforqed\else{\unskip\nobreak\hfil
 \penalty50\hskip1em\null\nobreak\hfil\squareforqed
 \parfillskip=0pt\finalhyphendemerits=0\endgraf}\fi}

 \def\sun{\hbox{$\odot$}}
 \def\la{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr<\cr\sim\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
 <\cr\sim\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 <\cr\sim\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 <\cr\sim\cr}}}}}
 \def\ga{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr>\cr\sim\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
 >\cr\sim\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 >\cr\sim\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 >\cr\sim\cr}}}}}
 \def\degr{\hbox{$^\circ$}}
 \def\arcmin{\hbox{$^\prime$}}
 \def\arcsec{\hbox{$^{\prime\prime}$}}
 \def\utw{\smash{\rlap{\lower5pt\hbox{$\sim$}}}}
 \def\udtw{\smash{\rlap{\lower6pt\hbox{$\approx$}}}}
 \def\fd{\hbox{$.\!\!^{\rm d}$}}
 \def\fh{\hbox{$.\!\!^{\rm h}$}}
 \def\fm{\hbox{$.\!\!^{\rm m}$}}
 \def\fs{\hbox{$.\!\!^{\rm s}$}}
 \def\fdg{\hbox{$.\!\!^\circ$}}
 \def\farcm{\hbox{$.\mkern-4mu^\prime$}}
 \def\farcs{\hbox{$.\!\!^{\prime\prime}$}}
 \def\fp{\hbox{$.\!\!^{\scriptscriptstyle\rm p}$}}
 \def\cor{\mathrel{\mathchoice {\hbox{$\widehat=$}}{\hbox{$\widehat=$}}
 {\hbox{$\scriptstyle\hat=$}}
 {\hbox{$\scriptscriptstyle\hat=$}}}}
 \def\sol{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr\sim\cr<\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\sim\cr
 <\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr\sim\cr
 <\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 \sim\cr<\cr}}}}}
 \def\sog{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr\sim\cr>\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\sim\cr
 >\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 \sim\cr>\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 \sim\cr>\cr}}}}}
 \def\lse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr<\cr\simeq\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
 <\cr\simeq\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 <\cr\simeq\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 <\cr\simeq\cr}}}}}
 \def\gse{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr>\cr\simeq\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
 >\cr\simeq\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 >\cr\simeq\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 >\cr\simeq\cr}}}}}
 \def\grole{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr>\cr\noalign{\vskip-1.5pt}<\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
 >\cr\noalign{\vskip-1.5pt}<\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 >\cr\noalign{\vskip-1pt}<\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 >\cr\noalign{\vskip-0.5pt}<\cr}}}}}
 \def\leogr{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr<\cr\noalign{\vskip-1.5pt}>\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
 <\cr\noalign{\vskip-1.5pt}>\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 <\cr\noalign{\vskip-1pt}>\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 <\cr\noalign{\vskip-0.5pt}>\cr}}}}}
 \def\loa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr<\cr\approx\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
 <\cr\approx\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 <\cr\approx\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 <\cr\approx\cr}}}}}
 \def\goa{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr>\cr\approx\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr
 >\cr\approx\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr
 >\cr\approx\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 >\cr\approx\cr}}}}}
 \def\diameter{{\ifmmode\mathchoice
 {\ooalign{\hfil\hbox{$\displaystyle/$}\hfil\crcr
 {\hbox{$\displaystyle\mathchar"20D$}}}}
 {\ooalign{\hfil\hbox{$\textstyle/$}\hfil\crcr
 {\hbox{$\textstyle\mathchar"20D$}}}}
 {\ooalign{\hfil\hbox{$\scriptstyle/$}\hfil\crcr
 {\hbox{$\scriptstyle\mathchar"20D$}}}}
 {\ooalign{\hfil\hbox{$\scriptscriptstyle/$}\hfil\crcr
 {\hbox{$\scriptscriptstyle\mathchar"20D$}}}}
 \else{\ooalign{\hfil/\hfil\crcr\mathhexbox20D}}%
 \fi}}

 \def\getsto{\mathrel{\mathchoice {\vcenter{\offinterlineskip
 \halign{\hfil
 $\displaystyle##$\hfil\cr\gets\cr\to\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr\gets
 \cr\to\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr\gets
 \cr\to\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 \gets\cr\to\cr}}}}}
 \def\lid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr<\cr\noalign{\vskip1.2pt}=\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr<\cr
 \noalign{\vskip1.2pt}=\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr<\cr
 \noalign{\vskip1pt}=\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 <\cr
 \noalign{\vskip0.9pt}=\cr}}}}}
 \def\gid{\mathrel{\mathchoice {\vcenter{\offinterlineskip\halign{\hfil
 $\displaystyle##$\hfil\cr>\cr\noalign{\vskip1.2pt}=\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\textstyle##$\hfil\cr>\cr
 \noalign{\vskip1.2pt}=\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptstyle##$\hfil\cr>\cr
 \noalign{\vskip1pt}=\cr}}}
 {\vcenter{\offinterlineskip\halign{\hfil$\scriptscriptstyle##$\hfil\cr
 >\cr
 \noalign{\vskip0.9pt}=\cr}}}}}
 \def\bbbr{{\rm I\!R}} %reelle Zahlen
 \def\bbbm{{\rm I\!M}}
 \def\bbbn{{\rm I\!N}} %natuerliche Zahlen
 \def\bbbf{{\rm I\!F}}
 \def\bbbh{{\rm I\!H}}
 \def\bbbk{{\rm I\!K}}
 \def\bbbp{{\rm I\!P}}
 \def\bbbone{{\mathchoice {\rm 1\mskip-4mu l} {\rm 1\mskip-4mu l}
 {\rm 1\mskip-4.5mu l} {\rm 1\mskip-5mu l}}}
 \def\bbbc{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm C$}\hbox{\hbox
 to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
 {\setbox0=\hbox{$\textstyle\rm C$}\hbox{\hbox
 to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
 {\setbox0=\hbox{$\scriptstyle\rm C$}\hbox{\hbox
 to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}
 {\setbox0=\hbox{$\scriptscriptstyle\rm C$}\hbox{\hbox
 to0pt{\kern0.4\wd0\vrule height0.9\ht0\hss}\box0}}}}
 \def\bbbq{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm
 Q$}\hbox{\raise
 0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.8\ht0\hss}\box0}}
 {\setbox0=\hbox{$\textstyle\rm Q$}\hbox{\raise
 0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.8\ht0\hss}\box0}}
 {\setbox0=\hbox{$\scriptstyle\rm Q$}\hbox{\raise
 0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.7\ht0\hss}\box0}}
 {\setbox0=\hbox{$\scriptscriptstyle\rm Q$}\hbox{\raise
 0.15\ht0\hbox to0pt{\kern0.4\wd0\vrule height0.7\ht0\hss}\box0}}}}
 \def\bbbt{{\mathchoice {\setbox0=\hbox{$\displaystyle\rm
 T$}\hbox{\hbox to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
 {\setbox0=\hbox{$\textstyle\rm T$}\hbox{\hbox
 to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
 {\setbox0=\hbox{$\scriptstyle\rm T$}\hbox{\hbox
 to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}
 {\setbox0=\hbox{$\scriptscriptstyle\rm T$}\hbox{\hbox
 to0pt{\kern0.3\wd0\vrule height0.9\ht0\hss}\box0}}}}
 \def\bbbs{{\mathchoice
 {\setbox0=\hbox{$\displaystyle     \rm S$}\hbox{\raise0.5\ht0\hbox
 to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\hbox
 to0pt{\kern0.55\wd0\vrule height0.5\ht0\hss}\box0}}
 {\setbox0=\hbox{$\textstyle        \rm S$}\hbox{\raise0.5\ht0\hbox
 to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\hbox
 to0pt{\kern0.55\wd0\vrule height0.5\ht0\hss}\box0}}
 {\setbox0=\hbox{$\scriptstyle      \rm S$}\hbox{\raise0.5\ht0\hbox
 to0pt{\kern0.35\wd0\vrule height0.45\ht0\hss}\raise0.05\ht0\hbox
 to0pt{\kern0.5\wd0\vrule height0.45\ht0\hss}\box0}}
 {\setbox0=\hbox{$\scriptscriptstyle\rm S$}\hbox{\raise0.5\ht0\hbox
 to0pt{\kern0.4\wd0\vrule height0.45\ht0\hss}\raise0.05\ht0\hbox
 to0pt{\kern0.55\wd0\vrule height0.45\ht0\hss}\box0}}}}
 \def\bbbz{{\mathchoice {\hbox{$\sf\textstyle Z\kern-0.4em Z$}}
 {\hbox{$\sf\textstyle Z\kern-0.4em Z$}}
 {\hbox{$\sf\scriptstyle Z\kern-0.3em Z$}}
 {\hbox{$\sf\scriptscriptstyle Z\kern-0.2em Z$}}}}
 \def\ts{\thinspace}
 
 \def\thebibliography#1{
 \section*{\centering{References}}                          %AA  put back into
\small
   \list
   {\relax}{\setlength{\labelsep}{0em}
         \setlength{\itemindent}{-\bibhang}
         \setlength{\itemsep}{\parskip}          %RR instead of 0pt
         \setlength{\parsep}{0pt}
         \setlength{\leftmargin}{\bibhang}}
     \def\newblock{\hskip .11em plus .33em minus .07em}
     \sloppy\clubpenalty4000\widowpenalty4000
     \sfcode`\.=1000\relax}

 \newlength{\bibhang}
 \setlength{\bibhang}{1.4em}        %AA 1.4em    %RR 4x instead of 1.4em

 \let\@internalcite\cite
 \def\cite{\@ifstar{\citeyear}{\citefull}}
 \def\citefull{\def\astroncite##1##2{##1\ ##2}\@internalcite}  %RR \ in, comma out
 \def\citeyear{\def\astroncite##1##2{##1\ (##2)}\@internalcite} %RR #1, \ and () extra  

 \def\@citex[#1]#2{\if@filesw\immediate\write\@auxout{\string\citation{#2}}\fi
   \def\@citea{}\@cite{\@for\@citeb:=#2\do
     {\@citea\def\@citea{; }\@ifundefined       %RR??   %RR comma instead of ;
        {b@\@citeb}{{\bf ??}\@warning              %RR extra ?
        {Citation `\@citeb' on page \thepage \space undefined}}%
 {\csname b@\@citeb\endcsname}}}{#1}}

 \def\@cite#1#2{#1\if@tempswa #2\fi}       %RR parentheses and comma out
 \def\@biblabel#1{}
 \newcommand\spbibitem[3]{\bibitem[\protect\astroncite{#1}{#2}]{#3}}

\def\lhead{\@ifnextchar[{\@xlhead}{\@ylhead}}
\def\@xlhead[#1]#2{\gdef\@elhead{#1}\gdef\@olhead{#2}}
\def\@ylhead#1{\gdef\@elhead{#1}\gdef\@olhead{#1}}

\def\chead{\@ifnextchar[{\@xchead}{\@ychead}}
\def\@xchead[#1]#2{\gdef\@echead{#1}\gdef\@ochead{#2}}
\def\@ychead#1{\gdef\@echead{#1}\gdef\@ochead{#1}}

\def\rhead{\@ifnextchar[{\@xrhead}{\@yrhead}}
\def\@xrhead[#1]#2{\gdef\@erhead{#1}\gdef\@orhead{#2}}
\def\@yrhead#1{\gdef\@erhead{#1}\gdef\@orhead{#1}}

\def\lfoot{\@ifnextchar[{\@xlfoot}{\@ylfoot}}
\def\@xlfoot[#1]#2{\gdef\@elfoot{#1}\gdef\@olfoot{#2}}
\def\@ylfoot#1{\gdef\@elfoot{#1}\gdef\@olfoot{#1}}

\def\cfoot{\@ifnextchar[{\@xcfoot}{\@ycfoot}}
\def\@xcfoot[#1]#2{\gdef\@ecfoot{#1}\gdef\@ocfoot{#2}}
\def\@ycfoot#1{\gdef\@ecfoot{#1}\gdef\@ocfoot{#1}}

\def\rfoot{\@ifnextchar[{\@xrfoot}{\@yrfoot}}
\def\@xrfoot[#1]#2{\gdef\@erfoot{#1}\gdef\@orfoot{#2}}
\def\@yrfoot#1{\gdef\@erfoot{#1}\gdef\@orfoot{#1}}

\newdimen\headrulewidth
\newdimen\footrulewidth
\newdimen\plainheadrulewidth
\newdimen\plainfootrulewidth
\newdimen\headwidth
\newif\if@fancyplain
\def\fancyplain#1#2{\if@fancyplain#1\else#2\fi}

\def\fancy@reset{\restorecr
 \def\baselinestretch{1}%
 \ifx\undefined\@newbaseline% NFSS not present; 2.09 or 2e
  \ifx\@currsize\normalsize\@normalsize\else\@currsize\fi%
 \else% NFSS (2.09) present
  \@newbaseline%
 \fi}

\headrulewidth 0pt
\footrulewidth\z@
\plainheadrulewidth\z@
\plainfootrulewidth\z@
\plainheadrulewidth 0.pt
\plainfootrulewidth 0.4pt

\lhead[\fancyplain{}{\sl\rightmark}]{\fancyplain{}{\sl\leftmark}}
\chead{}
\rhead[\fancyplain{}{\sl\leftmark}]{\fancyplain{}{\sl\rightmark}}
\lfoot{}
\cfoot{\rm\thepage} % page number
\rfoot{}

\def\@fancyhead#1#2#3#4#5{#1\hbox to\headwidth{\fancy@reset\vbox{\hbox
{\rlap{\parbox[b]{\headwidth}{\raggedright#2\strut}}\hfill
\parbox[b]{\headwidth}{\centering#3\strut}\hfill
\llap{\parbox[b]{\headwidth}{\raggedleft#4\strut}}}\headrule}}#5}


\def\@fancyfoot#1#2#3#4#5{#1\hbox to\headwidth{\fancy@reset\vbox{\footrule
\hbox{\rlap{\parbox[t]{\headwidth}{\raggedright#2\strut}}\hfill
\parbox[t]{\headwidth}{\centering#3\strut}\hfill
\llap{\parbox[t]{\headwidth}{\raggedleft#4\strut}}}}}#5}

\def\headrule{{\if@fancyplain\let\headrulewidth\plainheadrulewidth\fi
\hrule\@height\headrulewidth\@width\headwidth \vskip-\headrulewidth}}

\def\footrule{{\if@fancyplain\let\footrulewidth\plainfootrulewidth\fi
\vskip-0.3\normalbaselineskip\vskip-\footrulewidth
\hrule\@width\headwidth\@height\footrulewidth\vskip0.3\normalbaselineskip}}

\def\ps@fancy{%
\@ifundefined{@chapapp}{\let\@chapapp\chaptername}{}%for amsbook
\@ifundefined{chapter}{\def\sectionmark##1{\markboth
{\uppercase{\ifnum \c@secnumdepth>\z@
 \thesection\hskip 1em\relax \fi ##1}}{}}%
\def\subsectionmark##1{\markright {\ifnum \c@secnumdepth >\@ne
 \thesubsection\hskip 1em\relax \fi ##1}}}%
{\def\chaptermark##1{\markboth {\uppercase{\ifnum \c@secnumdepth>\m@ne
 \@chapapp\ \thechapter. \ \fi ##1}}{}}
\def\sectionmark##1{\markright{\uppercase{\ifnum \c@secnumdepth >\z@
 \thesection. \ \fi ##1}}}}%
\csname ps@headings\endcsname % use \ps@headings defaults if they exist
\ps@@fancy
\gdef\ps@fancy{\@fancyplainfalse\ps@@fancy}%
\headwidth\textwidth}
\def\ps@fancyplain{\ps@fancy \let\ps@plain\ps@plain@fancy}
\def\ps@plain@fancy{\@fancyplaintrue\ps@@fancy}
\def\ps@@fancy{%
\def\@mkboth{\protect\markboth}%
\def\@oddhead{\@fancyhead\@lodd\@olhead\@ochead\@orhead\@rodd}%
\def\@oddfoot{\@fancyfoot\@lodd\@olfoot\@ocfoot\@orfoot\@rodd}%
\def\@evenhead{\@fancyhead\@rodd\@elhead\@echead\@erhead\@lodd}%
\def\@evenfoot{\@fancyfoot\@rodd\@elfoot\@ecfoot\@erfoot\@lodd}%
}
\def\@lodd{\if@reversemargin\hss\else\relax\fi}
\def\@rodd{\if@reversemargin\relax\else\hss\fi}

\let\latex@makecol\@makecol
\def\@makecol{\let\topfloat\@toplist\let\botfloat\@botlist\latex@makecol}
\def\iftopfloat#1#2{\ifx\topfloat\empty #2\else #1\fi}
\def\ifbotfloat#1#2{\ifx\botfloat\empty #2\else #1\fi}
\def\iffloatpage#1#2{\if@fcolmade #1\else #2\fi}

\pagestyle{fancyplain}

\lfoot{\fancyplain{\footnotesize Proceedings of the conference\ 
	\emph{``Chemistry as a Diagnostic of Star
        Formation,''} University of Waterloo, Canada, 21-23 August 2002 
	(C.\,L.~Curry \& M.~Fich eds.).}{}}

\cfoot{}

\pagestyle{headings}
\lhead[\fancyplain{\thepage}{\thepage}]{}
\rhead[]{\fancyplain{\thepage}{\thepage}}

\endinput
%%
%% End of file `sfchem.cls'.

