% 99/06/29: additional revisions vertical spacing
% 98/05/10 later: appendix and appendixname defined
%
% 98/05/10: vertical spacing of section heads closer to 2.09 version
% multiline titles now o.k.
%
% 98/01/14: equation numbering fixed
%
\def\filedate{1999/06/29}
\def\filename{crckbked}
\def\fileversion{0.91}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{crckbked}[\filedate\space \fileversion\space
    Kluwer book class for camera-ready copy]
\newcommand\@ptsize{}
\newcommand\@pttensize{1}
\newif\if@restonecol
\newif\if@openright
\newif\if@inchapnotes
\newif\if@inchaprefs
\DeclareOption{noid}{\PassOptionsToPackage{\CurrentOption}{kluedit}}
\DeclareOption{namedreferences}{\PassOptionsToPackage{\CurrentOption}{kluref}}
\DeclareOption{numreferences}{\PassOptionsToPackage{\CurrentOption}{kluref}}
\DeclareOption{openbib}{\PassOptionsToPackage{\CurrentOption}{kluref}}
\DeclareOption{thms}{\PassOptionsToPackage{\CurrentOption}{klumath}}
\DeclareOption{mathsec}{\PassOptionsToPackage{\CurrentOption}{klumath}}
\DeclareOption{fleqn}{\PassOptionsToPackage{\CurrentOption}{klumath}}
\DeclareOption{leqno}{\PassOptionsToPackage{\CurrentOption}{klumath}}
\DeclareOption{klusym}{\PassOptionsToPackage{\CurrentOption}{klumac}}
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{a5paper}
   {\setlength\paperheight {210mm}%
    \setlength\paperwidth  {148mm}}
\DeclareOption{b5paper}
   {\setlength\paperheight {250mm}%
    \setlength\paperwidth  {176mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{legalpaper}
   {\setlength\paperheight {14in}%
    \setlength\paperwidth  {8.5in}}
\DeclareOption{executivepaper}
   {\setlength\paperheight {10.5in}%
    \setlength\paperwidth  {7.25in}}
\DeclareOption{landscape}
   {\setlength\@tempdima   {\paperheight}%                        
    \setlength\paperheight {\paperwidth}%
    \setlength\paperwidth  {\@tempdima}}
\DeclareOption{9pt}{\renewcommand\@pttensize{}\renewcommand\@ptsize{9}}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
%\DeclareOption{inchapnotes}{\@inchapnotestrue }
%\DeclareOption{inchaprefs}{\@inchaprefstrue }
\DeclareOption{openright}{\@openrighttrue}                       
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{onecolumn}{\@twocolumnfalse}
\DeclareOption{twocolumn}{\@twocolumntrue}
\newif\if@editedvolume
\newif\if@proceedings
\newif\if@nato
\DeclareOption{editedvolume}{\@editedvolumetrue\@proceedingsfalse\@natofalse}
\DeclareOption{proceedings}{\@proceedingstrue\@editedvolumefalse\@natofalse}
\DeclareOption{nato}{\@natotrue\@editedvolumefalse\@proceedingsfalse}
\DeclareOption{NATO}{\@natotrue\@editedvolumefalse\@proceedingsfalse}
\ExecuteOptions{a4paper,11pt,twoside,onecolumn,final,openright,editedvolume}
\ProcessOptions
\@inchapnotestrue\@inchaprefstrue
%\renewcommand{\encodingdefault}{T1}
\IfFileExists{klumac.sty}{\RequirePackage{klumac}[1998/02/11]}{}
\AtBeginDocument{\let\sectioncmd\chapter}
\input{klu\@pttensize\@ptsize.clo}
\let\oldfootnotesize\footnotesize
%\let\footnotesize\small
\def\Uppercase#1{\uppercase{#1}}
\RequirePackage[kaplist]{klulist}[1998/02/11]
\edef\kapitemargs{\kapitemargs
    \topsep 5pt plus 1pt minus1pt}
\let\kapenumargs\kapitemargs
\def\quotation{\list{}{%
  \listparindent 1em
  \leftmargin 1.5em
  \topsep .5ex plus 2pt minus 1pt%
  \itemindent\listparindent
  \parsep 0pt plus1pt}\item[]\hskip-\listparindent}
\let\endquotation=\endlist

\def\quote{\list{}{%
  \leftmargin 1.5em
  \topsep .5ex plus 2pt minus 1pt}\item[]}
\let\endquote=\endlist

\def\descriptionlabel#1{\hspace\labelsep \bf #1}
\def\description{\list{}{\labelwidth\z@ 
   \itemindent-\leftmargin
   \let\makelabel\descriptionlabel}}
\let\enddescription\endlist

\RequirePackage{kluopen}[1998/02/11]                            
\def\tocauthor@{}
\def\toctitle@{} 
\def\gobble#1{}
\def\runningauthor#1{\gdef\@runningauthor{#1}\gdef\tocauthor@{#1}}
\def\indexauthor#1{\gdef\tocauthor@{#1}}

\def\title@#1{\begingroup \def\thanks{\gobble}%
    \let\\=\endgraf
    \xdef\toctitle@{#1}\endgroup 
    \gdef\@title{%
    \baselineskip=1.5\baselineskip
    \@formattitle{#1}\par \vskip \aftertitleskip }}
\def\@maketitle{% 
   \@arttype \@title \@subtitle
   \@authorsandinstitutes
   \@translation \@dedication \@motto
   \@abstract \@keywords \@abbreviations \@classification 
   \@nomenclature \def\myleftmark{\@runningauthor}%
   \refstepcounter{chapter}\enlargethispage{-13pt}%
   \thispagestyle{empty}%
   \ifx\tocauthor@\toctitle@ 
   \addcontentsline{toc}{article}{\toctitle@}{}%
   \else
   \addcontentsline{toc}{article}{\tocauthor@ / \toctitle@}{}%
   \fi 
   }
                               
\def\openingflushstyle{\vspace*{12pt}}
\def\titleflushstyle{}
\def\titlefont{\bf}
\def\titlecase#1{\uppercase{#1}}               
\def\aftertitleskip{2pc}
\def\presubtitleskip{-1.4pc}
\def\aftersubtitleskip{2pc}
\def\subtitlefont{\it}

\def\authorsize{\normalsize\setlength{\leftskip}{5pc}}
\def\authorindent{0pc}
\def\authorcase#1{\uppercase{#1}}
\def\afterallauthorsskip{4em\relax}

\def\institutesize{\normalsize\it}
\def\institutecase#1{#1}

\let\instituteindent\authorindent
%\def\institutesep{.4\baselineskip}

              
\RequirePackage{kluedit}[1998/02/11]
\def\kaplogo{}
%
% This version of the article environment assumes 1 article == 1 chapter
%
\renewenvironment{article}{% 
  \renewcommand{\thearticle}{\roman{article}}%
  \refstepcounter{article}%
  \def\label##1{\ilabel{\thearticle ##1}}%
  \def\ref##1{\iref{\thearticle ##1}}%
  \def\pageref##1{\ipageref{\thearticle ##1}}%
  \setlastpage 
  }{%
    \iflastpagegiven\else \label{lastpage}\fi 
    \clearpage
    \if@openright
      \ifodd \c@page \else ~\thispagestyle{empty}\newpage \fi
    \fi
%    \gdef\@kapidenthead{}\gdef\@kapidentfoot{}%
%    \gdef\@firstpage{\thepage}%
%    \gdef\@lastpage{}%
    \global\lastpagegivenfalse}

\gdef\markboth#1#2{{\let\protect=\noexpand
    \xdef\myleftmark{\rm\normalsize\Uppercase{#1}}%
    \xdef\myrightmark{\rm\normalsize\Uppercase{#2}}}}
\let\imarkboth\markboth
\gdef\@markfont{\rm\Huge}
\gdef\@pgnumfont{\rm\Huge}

\if@nato
  \gdef\imarkboth{\@gobbletwo}
  \gdef\markboth{\@gobbletwo}
\fi

\RequirePackage{klufloa}[1998/02/11]
\renewcommand{\fnum@figure}{{\itshape\figurename~\thefigure.}\/~~}
\renewcommand{\fnum@table}{{\uppercase{\tablename}~\thetable.}~~}
\renewcommand{\thetable}{\Roman{table}}

\RequirePackage{klunote}[1998/02/11] 
\let\oldtheendnotes\theendnotes
\def\theendnotes{\setcounter{endnote}{0}\oldtheendnotes}
\if@inchapnotes
\def\enoteheading{\section*{Notes}\message{Notes}\leavevmode\par}
\else
\def\enoteheading{\chapter*{\notesname}\message{Notes}\leavevmode\par}
\fi        

\def\clearemptydoublepage{\clearpage\ifodd\c@page \else 
    ~ \thispagestyle{empty}\newpage\fi}                                     
\let\cleardoublepage\clearemptydoublepage
\RequirePackage{kluref}[1998/02/11]
                    

\if@inchaprefs
\renewenvironment{thebibliography}[1]{%
  \section*{\refname}%
  \footnotesize
  \message{References}%
  \def\bibwidthlabel{\releft#1\reright}%
  \list{\kapbib@counter}{\kapbib@list}%
  \let\makelabel\@biblabel
  \def\newblock{\hskip .11em plus .33em minus .07em}%
  \sloppy
  \clubpenalty10000
  \widowpenalty10000
  \sfcode`\.=1000\relax
  }{\endlist}
\fi           
     
\setlength{\bibhang}{8pt}
\RequirePackage{klumath}[1998/02/11]
\@addtoreset{equation}{article}
\renewcommand{\theequation}{\arabic{equation}}
\eqnoindent=38pt
%\mathindent=54pt

\RequirePackage[chapter]{klusec}[1998/02/11]
\let\ps@chapter\ps@edittitle
\let\ps@opening\ps@edittitle
\let\ps@headings\ps@editheadings
\renewcommand{\thepart}{\arabic{part}}
\outer\def\part#1{%
    \cleardoublepage
    \ifnum \c@secnumdepth >-2
      \stepcounter{part}%
      \message{\partname\space\thepart\chapterdot}%
      \addcontentsline{toc}{part}{\protect
        \partline{\partname}{\thepart}#1}%
    \fi
    \addtocontents{lof}{\protect\addvspace{12pt}}%
    \addtocontents{lot}{\protect\addvspace{12pt}}%
}
\def\@chapter[#1]#2{%
    \ifnum \c@secnumdepth >\m@ne
      \refstepcounter{chapter}%
      \message{\@chapapp\space\thechapter\chapterdot}%
      \addcontentsline{toc}{chapter}{\protect
        \chapterline{\@chapapp}{\thechapter}#1}%
        \gdef\@runningtitle{#1}%
    \else
      \addcontentsline{toc}{chapter}{#1}%
    \fi
    \chaptermark{#1}%
    \addtocontents{lof}{\protect\addvspace{6pt}}%
    \addtocontents{lot}{\protect\addvspace{6pt}}%
    \@makechapterhead{\thechapter\chapterdot\ }{#2}% 
    \@afterheading
    }
  \def\@schapter#1{\@makechapterhead{#1}{#1}%
    \thispagestyle{plain}%
    \imarkboth{#1}{#1}%
    \addcontentsline{toc}{chapter}{\uppercase{#1}}%
    \@afterheading
    }    

\renewcommand{\thesection}{\arabic{section}}        
\newcommand{\@makeschapterhead}[1]{\vspace*{\Cspaceabove}%
  {\parindent 0pt \hyphenpenalty 10000
   \Cflushstyle
   \Ctextstyle \Ccase{#1}\par
   \nobreak \Cspaceafter \relax
  }}

\def\appendixname{Appendix}
\def\appendix{\section*{\appendixname}}

%
% Toc adjustments
%   

\def\tableofcontents{%
  \@makeschapterhead{\contentsname}\@afterheading
  \thispagestyle{empty}%
  \imarkboth{\contentsname}{\contentsname}%
  \message{\contentsname}%
  \@starttoc{toc}\newpage
}
\def\chapterline#1#2{%
    \def\@tempb{#1}\ifx\@tempb\appendixname 
    \uppercase{#1}\ #2 / 
    \else
    \uppercase{#1}\ \NUMTOWORD{#2} / 
    \fi
    }
\def\partline#1#2{%
    \uppercase{#1}\ \NUMTOWORD{#2} / 
    }
\def\l@chapter#1#2{\par
   \vskip 0.5em plus 1pt
   \begingroup
    \def\\{}%
     \parindent \z@ 
     \rightskip \@pnumwidth \advance\rightskip 2em plus 3em
     \parfillskip -\@pnumwidth \advance\parfillskip -2em
     \leftskip 2em \relax                            
     \leavevmode
     \hskip -\leftskip 
     #1\hfill \hbox to \@pnumwidth{\hss #2}\par
     \penalty\@highpenalty                        
   \endgroup
   }
   
\let\l@article\l@chapter
\def\l@part#1#2{\par
   \vskip 1.5em plus 1pt
   \begingroup
     \parindent \z@ 
     \centering
     \leavevmode
        \large \uppercase{#1}\par
     \penalty\@highpenalty                        
   \endgroup
   \vskip 0.5em plus 1pt
   }

\def\l@figure#1#2{\par 
   \begingroup
    \def\\{}% 
    \def\numberline##1##2{\setbox0\hbox{##2}%
        Fig. ##1
        \ifdim\wd0 < 3pt \else / ##2 \fi
        }%
     \parindent \z@ 
     \rightskip \@pnumwidth \advance\rightskip 2em plus 3em
     \parfillskip -\@pnumwidth \advance\parfillskip -2em
     \leftskip 2em \relax                            
     \leavevmode
     \hskip -\leftskip 
     #1\hfill \hbox to \@pnumwidth{\hss #2}\par
     \penalty\@medpenalty                        
   \endgroup
   }
          
\def\l@table#1#2{\par 
   \begingroup
    \def\\{}% 
    \def\numberline##1##2{\setbox0\hbox{##2}%
        Table ##1
        \ifdim\wd0 < 3pt \else / ##2 \fi
        }%
     \parindent \z@ 
     \rightskip \@pnumwidth \advance\rightskip 2em plus 3em
     \parfillskip -\@pnumwidth \advance\parfillskip -2em
     \leftskip 2em \relax                            
     \leavevmode
     \hskip -\leftskip 
     #1\hfill \hbox to \@pnumwidth{\hss #2}\par
     \penalty\@medpenalty                        
   \endgroup
   }

\def\l@section{\@dottedtocline{1}{1.5em}{2.3em}}
\def\listfigurename{LIST OF FIGURES}
\def\listtablename{LIST OF TABLES}
%\def\l@subsection{\@dottedtocline{2}{3.8em}{3.2em}}
%\def\l@subsubsection{\@dottedtocline{3}{7.0em}{4.1em}}
\def\l@section{\@gobbletwo}
\def\l@subsection{\@gobbletwo}
\def\l@subsubsection{\@gobbletwo}
%\setcounter{tocdepth}{0} 
\def\Chang#1{}
\def\Ctextstyle{\normalsize\bf}
\def\Ccase#1{#1}
\def\Cflushstyle{}
\def\Cspaceabove{26pt}
\def\Cspacebelow{50pt}

\def\Snumstyle{\normalsize\bf}
\def\Stextstyle{\normalsize\bf}
\def\Scase#1{#1}
\def\Sflushstyle{}
\def\Sspaceabove{16pt plus 5pt minus 3pt}
\def\Sspacebelow{8pt plus 1 pt minus 1pt}
\def\SShang#1{\Forcedhang{#1}}
\def\SScase#1{\Uppercase{#1}}
\def\SSnumstyle{\small}
\def\SStextstyle{\small}
\def\SSStextstyle{\small\it}
\def\SSspaceabove{16pt plus 3pt minus 2pt}
\def\SSspacebelow{8pt plus 1 pt minus 1pt}
\def\SSSspaceabove{16pt plus 3pt minus 2pt}
\def\SSSspacebelow{8pt plus 1 pt minus 1pt}
\def\SSShang#1{\Forcedhang{#1}}
\def\SSSnumstyle{}
\def\SSStextstyle{\it}
\def\Phang#1{}
\def\Ptextstyle{\it}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% measures copied from 2.09 version

\oddsidemargin .2in % .25in 
\evensidemargin .2in % 1.25in

\marginparwidth 1in 
\marginparsep 10pt % 7pt

\topmargin -0.6mm % .73in 
\headheight 12pt 
\headsep 6mm % .275in 
\footskip 39pt
 
\textheight 19cm        % 21.5cm     
\advance\textheight by \topskip
\textwidth  12.5cm      % 15cm     
\footnotesep 6.65pt
\skip\footins 12.8pt plus 4pt minus 2pt

\floatsep 14pt plus 2pt minus 4pt 
\textfloatsep 20pt plus 2pt minus 4pt
\intextsep 14pt plus 4pt minus 4pt 

\parskip 0pt plus 1pt 
\parindent 1.5em 
\partopsep 3pt plus 2pt minus 2pt

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}

\def\tablename{TABLE}
\AtBeginDocument{%
    \def\refname{References}}
\def\abstractname{Abstract}
\def\keywordsname{Key words}
\def\indexname{Index}
\def\contentsname{Contents}
\def\abbreviationsname{Abbreviations}
\def\acknowledgementsname{Acknowledgements}
\def\notesname{Notes} 
\def\abstractnamefont{\rm}
\def\keynamefont{\rm}
\def\nomennamefont{\rm}
\def\abbrevnamefont{\rm}
\def\classnamefont{\rm}
\def\afterabstractskip{.8\baselineskip\relax}

\@lowpenalty 51
\@medpenalty 151
\@highpenalty 301
\@beginparpenalty -\@lowpenalty
\@endparpenalty -\@lowpenalty
\@itempenalty -\@lowpenalty
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\providecommand{\cal}{\protect\pcal}
\newcommand{\pcal}{\@fontswitch{\relax}{\mathcal}}
\providecommand{\mit}{\protect\pmit}
\newcommand{\pmit}{\@fontswitch{\relax}{\mathnormal}}
\setlength\tabbingsep{\labelsep}
\clubpenalty=8000
\widowpenalty=8000
%%%%%%%                                            
\def\booktitle#1{\def\thejournal{#1\\}}
\def\copyrightowner#1{\def\thecopyright{#1}}
\def\kapmathindent{14pt}
\setcounter{secnumdepth}{4}
\pagestyle{headings}
\parskip0pt
\pagenumbering{arabic}
\frenchspacing
\def\@firstpage{1}
\endinput
%% 
%% End of file `kluwer.cls'.
