%=========================   jpsj2.cls   =============================
%
% ver.1.0b February 28, 2001
% Minor corrections on April 25, 2001
% Remove the dvips option on June 20, 2001
% Based on jpsj.sty ver. 1.0b
%
% (C) The Institue of Pure and Applied Physics
%=====================================================================

\typeout{***** Document Class <<jpsj2.cls>> ver.1.0b *****}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jpsj2}[2001/06/20 v.1.0b JPSJ document class]
\RequirePackage{amsmath}[1997/03/20]
\RequirePackage{amssymb}
\RequirePackage{latexsym}
\RequirePackage{graphicx}
\RequirePackage{overcite}
\def\@cite#1{\mbox{$\m@th^{\hbox{\@ove@rcfont#1)}}$}}
\renewcommand\theequation{\@arabic\c@equation}
\DeclareOption{seceq}{%
\@addtoreset{equation}{section}
\renewcommand\theequation{\@arabic\c@section.\@arabic\c@equation}
}

\newif\if@letter
\DeclareOption{letter}{\@lettertrue}
\newif\if@shortnote
\DeclareOption{shortnote}{\@shortnotetrue}
\newif\if@comment
\DeclareOption{comment}{\@commenttrue}
\newif\if@addenda
\DeclareOption{addenda}{\@addendatrue}
\newif\if@errata
\DeclareOption{errata}{\@erratatrue}
\newif\if@print
\DeclareOption{print}{\@printtrue}
\DeclareOption{twocolumn}{\@twocolumntrue}
\DeclareOption{a4paper}
   {\setlength\paperheight {297mm}%
    \setlength\paperwidth  {210mm}}
\DeclareOption{letterpaper}
   {\setlength\paperheight {11in}%
    \setlength\paperwidth  {8.5in}}

\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\@nomath\sl}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\@nomath\sc}
\DeclareRobustCommand*\cal{\@fontswitch\relax\mathcal}
\DeclareRobustCommand*\mit{\@fontswitch\relax\mathnormal}

\ExecuteOptions{a4paper}

\newcount\halfflag
\halfflag=0

\def\@typeset{\sffamily Typeset with jpsj2.cls $<$ver.1.0beta$>$}
\@ifundefined{jpage}{\def\jpage{Vol.\ No.\ pp.}}{}
\@ifundefined{runtitle}{\def\runtitle{Title of the Article}}{}
\@ifundefined{runauthor}{\def\runauthor{Author Name}}{}
\@ifundefined{pvol}{\def\pvol{\null}}{}
\@ifundefined{pyear}{\def\pyear{\null}}{}

\raggedbottom
\let\makefigurecaptions\null
\@twosidetrue
\newcommand{\mib}[1]{\boldsymbol{#1}}
\let\mbi\mib

\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}

\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xipt{18}%
   \abovedisplayskip 11\p@ \@plus3\p@ \@minus6\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6.5\p@ \@plus3.5\p@ \@minus3\p@
   \belowdisplayskip \abovedisplayskip
   \let\@listi\@listI}
\normalsize
\newcommand\small{%
   \@setfontsize\small\@xpt\@xiipt
   \abovedisplayskip 10\p@ \@plus2\p@ \@minus5\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 6\p@ \@plus3\p@ \@minus3\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 6\p@ \@plus2\p@ \@minus2\p@
               \parsep 3\p@ \@plus2\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\footnotesize{%
   \@setfontsize\footnotesize\@ixpt{11}%
   \abovedisplayskip 8\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus\p@
   \belowdisplayshortskip 4\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
               \topsep 4\p@ \@plus2\p@ \@minus2\p@
               \parsep 2\p@ \@plus\p@ \@minus\p@
               \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip
}
\newcommand\scriptsize{\@setfontsize\scriptsize\@viiipt{9.5}}
\newcommand\tiny{\@setfontsize\tiny\@vipt\@viipt}
\newcommand\large{\@setfontsize\large\@xiipt{14}}
\newcommand\Large{\@setfontsize\Large\@xivpt{18}}
\newcommand\LARGE{\@setfontsize\LARGE\@xviipt{22}}
\newcommand\huge{\@setfontsize\huge\@xxpt{25}}
\newcommand\Huge{\@setfontsize\Huge\@xxvpt{30}}

\setlength\textheight{23cm}
\setlength\textwidth{16.5cm}
\setlength\columnsep{.5cm}
\setlength\columnseprule{\z@}
\setlength\oddsidemargin{\z@}
\setlength\evensidemargin{\z@}
\setlength\topmargin{\z@}
\setlength\headheight{10\p@}
\setlength\headsep   {12\p@}
\setlength\topskip   {10\p@}
\setlength\footskip{30\p@}

\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}

\newenvironment{verse}
               {\let\\\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item\relax}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item\relax}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item\relax}
               {\endlist}

\arraycolsep 6\p@
\tabcolsep 6\p@
\arrayrulewidth .4\p@
\doublerulesep 2\p@
\tabbingsep \labelsep

\skip\@mpfootins \skip\footins
\fboxsep 3\p@
\fboxrule .4\p@

\newcounter{section}
\newcounter{subsection}[section]
\newcounter{subsubsection}[subsection]

\def\thesection{\arabic{section}}
\def\thesubsection{\arabic{section}.\arabic{subsection}}
\def\thesubsubsection{\thesubsection.\arabic{subsubsection}}

\font\tensyb=cmbsy10\relax
\newcommand{\secsymbol}{\mbox{\tensyb\symbol{'170}}}
\def\@secapp{\secsymbol}

\newcommand\section{\@startsection{section}{1}{\z@}%
                   {12\p@ \@plus .5\p@ \@minus .5\p@}%
                   %{1\baselineskip}%
                   {6\p@ \@plus .5\p@ \@minus .5\p@}%
                   %{.5\baselineskip}%
                   %{.5pt \@plus -.5pt \@minus .5pt}%
                   {\normalfont\normalsize\bfseries}}
\newcommand\subsection{\@startsection{subsection}{2}{\z@}%
                   {12truept}{.5pt \@plus -.5pt \@minus .5pt}
                   {\normalfont\normalsize\itshape}}
\newcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                   {1\baselineskip}%
                   %{.5pt \@plus -.5pt \@minus .5pt}%
                   {.5pt plus -.5pt minus .5pt}%
                   {\normalfont\normalsize\itshape}}
\newcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
                   {\z@}{-1em}%
                   {\normalfont\normalsize\bfseries}}
\newcommand\subparagraph{\@startsection{subparagraph}{4}{\parindent}%
                   {\z@}{-1em}%
                   {\normalfont\normalsize\itshape}}


\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{(\theenumi)}
\newcommand\labelenumii{\theenumii.}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}

\setlength\leftmargini {2em}
\setlength\leftmarginii {1em} 
\setlength\leftmarginiii {1em} 
\setlength\leftmarginiv {1em} 
\setlength\leftmarginv {1em}
\setlength\leftmarginvi {1em}
\setlength\leftmargin{\leftmargini}
\setlength\labelwidth{\leftmargini\advance\labelwidth-\labelsep}
\setlength\labelsep {.5em} 
\setlength\parsep {\z@}
 
\def\@listi{\leftmargin\leftmargini}
\def\@listii{\leftmargin\leftmarginii
 \labelwidth\leftmarginii\advance\labelwidth-\labelsep
 \topsep\z@ 
 \parsep\z@ 
 \itemsep \parsep}
\def\@listiii{\leftmargin\leftmarginiii
 \labelwidth\leftmarginiii\advance\labelwidth-\labelsep
 \topsep\z@
 \parsep\z@
\partopsep\z@
 \itemsep=\z@ \topsep\z@}
\def\@listiv{\leftmargin\leftmarginiv
 \labelwidth\leftmarginiv\advance\labelwidth-\labelsep}
\def\@listv{\leftmargin\leftmarginv
 \labelwidth\leftmarginv\advance\labelwidth-\labelsep}
\def\@listvi{\leftmargin\leftmarginvi
 \labelwidth\leftmarginvi\advance\labelwidth-\labelsep}

\def\thebibliography#1{%
\par
\vspace{18\p@}
\noindent \hrule width \textwidth
\par
\vspace{12\p@}
\renewcommand\baselinestretch{1.2}
\list{\footnotesize\arabic{enumi})}{\footnotesize\settowidth%
 \labelwidth{[#1]}
 \leftmargin\labelwidth
 \advance\leftmargin\labelsep
 \usecounter{enumi}}
 \sloppy
 \sfcode`\.=500\relax}
\let\endthebibliography=\endlist

\newcommand\refname{}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\footnoterule{\vfill \kern-3\p@
     \hrule width \textwidth\kern 2.6\p@}

\def\symbolfootnotes{\setcounter{footnote}{0}%
    \gdef\thefootnote{\fnsymbol{footnote}}}

\gdef\@thanks{}\symbolfootnotes

\long\def\@makefntext#1{%
\vskip3\p@ \hsize=\textwidth \par
\noindent
\footnotesize \hskip3\p@ $^{\@thefnmark}$\hskip+2\p@#1\vskip-2\p@
}

%\ifnum \@footstyle=0 
\def\@fnsymbol#1{\ifcase#1\or *\or **\or ***\or
   ****\or *****\or ******\or *******\or ********
   \or ********* \else\@ctrerr\fi\relax}
%%%\else
%%%\def\@fnsymbol#1{\ifcase#1\or \dagger\or \ddagger\or \dagger\dagger\or
%%%   \ddagger\ddagger\or \dagger\dagger\dagger\or \ddagger\ddagger\ddagger\or
%%%   \dagger\dagger\dagger\dagger\or \ddagger\ddagger\ddagger\ddagger
%%%   \else\@ctrerr\fi\relax}
%%%\fi

\def\fnsymbol#1{\@fnsymbol{\@nameuse{c@#1}}}

\long\def\@makecaption#1#2{\footnotesize
 \vskip 1.5\baselineskip
 \setbox\@tempboxa\hbox{#1.\hskip5\p@#2}
 \ifdim \wd\@tempboxa >\hsize
     \par\hangindent=16\p@ {#1.\hskip5\p@#2\par} 
 \else 
     \hbox to \hsize{\hfil\box\@tempboxa\hfil}
 \fi
}

\long\def\@caption#1[#2]#3{\par
     \begingroup
     \@parboxrestore
     \@makecaption{\csname fnum@#1\endcsname}{\ignorespaces #3}
     \par
     \endgroup
}

\newcounter{figure}
\def\thefigure{\@arabic\c@figure}
\def\fps@figure{htbp}
\def\ftype@figure{1}
\def\fnum@figure{Fig.~\thefigure}
\newcounter{table}
\def\thetable{\@Roman\c@table}
\def\fps@table{htbp}
\def\ftype@table{2} 
\def\fnum@table{Table~\thetable}

%%%%\def\full{\if@twocolumn \vspace{13pt}
%%%%\hrule width \halftextwidth \vspace{2pt}
%%%%\hrule width \halftextwidth \vspace{13pt}
%%%%\fulltext\@dblfloat{figure} \else \fulltext \fi}
%%%%\def\endfull{\if@twocolumn \end@dblfloat\halftext \else \halftext \fi}

\newenvironment{figure}
               {\@float{figure}}
               {\end@float}
               
\newenvironment{halffigure}
               {\@float{figure}}
               {\end@float}
               
\newenvironment{figure*}
               {\@dblfloat{figure}}
               {\end@dblfloat}
               
\newenvironment{fullfigure}
               {\@dblfloat{figure}}
               {\end@dblfloat}

\newenvironment{table}
               {\footnotesize\@float{table}}
               {\end@float}

\newenvironment{halftable}
               {\footnotesize\@float{table}}
               {\end@float}
               
\newenvironment{table*}
               {\footnotesize\@dblfloat{table}}
               {\end@dblfloat}
               
\newenvironment{fulltable}
               {\footnotesize\@dblfloat{table}}
               {\end@dblfloat}

\def\tabular{\vskip5\p@
                 \def\@halignto{to \textwidth}\@tabular}
\def\halftabular{\vskip5\p@
                 \def\@halignto{to \textwidth}\@tabular}
\def\fulltabular{\vskip5\p@
                 \def\@halignto{to \textwidth}\@tabular}

\def\endtabular{\crcr\egroup\egroup $\egroup \vspace{4\p@}}
\def\endhalftabular{\crcr\egroup\egroup $\egroup \vspace{4\p@}}
\def\endfulltabular{\crcr\egroup\egroup $\egroup \vspace{4\p@}}

\def\hline{\\[-8\p@]\noalign{\ifnum0=`}\fi \hrule \@height
\arrayrulewidth \futurelet \@tempa\@xhline \\[-8\p@]}

%%%%%%%%% JPSJ %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    figureheight
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\figureheight[1]{
\vspace{24\p@}
\begin{center} 
       \fbox{\rule{\z@}{#1}}
\end{center}
}

%%%%%%%%% JPSJ %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    epsfigure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand\epsfigure[1]{
\begin{center} 
\includegraphics{#1}
\end{center}
}

%%%%% maketitle %%%%%
\def\maketitle{\par
 \begingroup
 \centering
 \if@twocolumn
 \twocolumn[\@maketitle]
 \else %\newpage
 \global\@topnum\z@ \@maketitle \fi 
 \if@errata\thispagestyle{headings}
 \else
 \thispagestyle{jpsj}\@thanks
 \fi
 \endgroup
 \setcounter{footnote}{0}
 \let\maketitle\relax
 \let\@maketitle\relax
 \gdef\@thanks{}\gdef\@author{}\gdef\@inst{}\gdef\@title{}\let\thanks\relax}
\def\@maketitle{%
\null
%
\def\re{\par\hangindent=0.5cm\hangafter=1\noindent}
\def\hang{\par\hangindent=\z@\hangafter=1\noindent}
\par
\vskip 4\p@
{\large\bfseries\boldmath
\hang
\@title \par}
\vskip 5mm
{%
\hang
\@author
}
\vskip 9\p@
{\footnotesize\itshape
\hang
\@inst \par \vskip 9\p@
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\@ifundefined{@recdate}{}{}
\if@errata\normalsize J. Phys.\ Soc.\ Jpn.\ \@origin
\else
\footnotesize (Received \@recdate)
\fi
\gdef\@recdate{} \par 
\if@errata\vskip\p@ \else \vskip 12\p@ \fi
%
\@ifundefined{@abst}{}{%
\begingroup
{\parbox[t]{380\p@}{\small \hspace*{9\p@} \@abst} \par} 
  \gdef\@abst{}}
\endgroup
\vskip16\p@
\@ifundefined{@kword}{}{%
\hang
\begingroup
{\if@errata\null\else {\footnotesize\sffamily KEYWORDS:} \ \fi
\parbox[t]{350\p@}{\footnotesize\sffamily\@kword}
}
 \vskip 12\p@
  \gdef\@kword{}}\par
\endgroup
\vspace{12.5\p@}
}

\long\def\abst#1{\long\gdef\@abst{#1}}
\long\def\inst#1{\long\gdef\@inst{#1}}
\long\def\kword#1{\long\gdef\@kword{#1}}
%
\def\recdate#1{\gdef\@recdate{#1}}
\def\origin#1{\gdef\@origin{#1}}
%\def\revdate#1{\gdef\@revdate{#1}}
%\def\accdate#1{\gdef\@accdate{#1}}

\mark{{}{}}


%%%%%%Definition of headings%%%%%%
\mark{{}{}}

\def\ps@headings{\let\@mkboth\markboth
\def\@oddfoot{}
\def\@evenfoot{}
\def\@evenhead{%
  \hbox to \textwidth{\footnotesize\thepage\hfill%
  \if@letter{\textsc{Letter}} \else
  \if@shortnote{\textsc{Short Note}} \else
  \if@comment{\textsc{Comment}} \else
  \if@addenda{\textsc{Addenda}} \else
  \if@errata{\textsc{Errata}} \else
  \runauthor
  \fi \fi \fi \fi \fi %
  \hfill}
}
\def\@oddhead{%
  \hbox to \textwidth{\footnotesize%
  \hfill%
  \if@letter{\textsc{Letter}}\else
  \if@shortnote{\textsc{Short Note}} \else
  \if@comment{\textsc{Comment}} \else
  \if@addenda{\textsc{Addenda}} \else
  \if@errata{\textsc{Errata}} \else
  \runtitle%
  \fi \fi \fi \fi \fi \hfill\thepage}}
}

\def\ps@jpsj{%
  \let\@mkboth\@gobbletwo%
  \def\@evenfoot{\footnotesize\hfill{\thepage}\hfill}
  \let\@oddfoot\@evenfoot
  \def\@evenhead{\small%
      {\if@letter{\small\scshape Letter}
      \else
             \if@shortnote{\small\scshape Short Note}
      \else
             \if@comment{\small\scshape Comment}
      \else
             \if@addenda{\small\scshape Addenda}
      \else
      \null
      \fi \fi \fi \fi}
      \hfill\@typeset}
  \let\@oddhead\@evenhead
}

\def\today{\ifcase\month\or
 January\or February\or March\or April\or May\or June\or
 July\or August\or September\or October\or November\or December\fi
 \space\number\day, \number\year}

\pagenumbering{arabic} \onecolumn
\pagestyle{headings}

\def\sloppy{\tolerance=9999
\hfuzz=.5\p@ \vfuzz=.5\p@}

%%%%%%%%% JPSJ %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    acknowledgements 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcommand{\acknowledgement}{\section*{Acknowledgement}}
\newcommand{\acknowledgements}{\section*{Acknowledgements}}

%%%%%%%%% JJAP %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\@nullstring{}
\def\@appendixstring{Appendix}

\def\@sect#1#2#3#4#5#6[#7]#8{\ifnum #2>\c@secnumdepth
     \def\@svsec{}\else
       \ifnum #2=1		% TRUE if \section{}
         \refstepcounter{#1}
         \def\@appendixtitle{#8}
         \ifx\@secapp\@appendixstring
           \ifx\@appendixtitle\@nullstring
             \edef\@svsec{\@secapp \csname the#1\endcsname\hskip1em}
           \else
             \edef\@svsec{\@secapp \csname the#1\endcsname:\hskip1em}
           \fi
         \else
           \ifx\thesection\@nullstring
             \edef\@svsec{\@secapp \csname the#1\endcsname\hskip1em}
           \else
             \edef\@svsec{\@secapp \csname the#1\endcsname.\hskip1em}
           \fi
         \fi
       \else
         \refstepcounter{#1}\edef\@svsec{\csname the#1\endcsname\hskip1em}
       \fi
     \fi
     \@tempskipa #5\relax
      \ifdim \@tempskipa>\z@
        \begingroup #6\relax
          \@hangfrom{\hskip #3\relax\@svsec}{\interlinepenalty \@M #8\par}
        \endgroup
       \csname #1mark\endcsname{#7}
      \else
        \def\@svsechd{#6\hskip #3\@svsec #8\csname #1mark\endcsname{#7}
      }\fi
     \@xsect{#5}}

\setcounter{secnumdepth}{4}

%%%%%%%%% JJAP %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    appendix
%%%%%%%%% JPSJ %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%           modified
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\newcount\@appendixflag
\@appendixflag=0
\newcount\@appendixindex
\@appendixindex=0

\def\getappendix#1{\global\@namedef{appnedix@#1}{1}}
\def\appendix{\par
\renewcommand{\section}[1]{\sectiona{##1}}
}

\def\sectiona{
%%% \c@table=0
%%% \c@figure=0
 \setcounter{equation}{0}
 \ifnum \@appendixflag=0
   \setcounter{section}{0} \@appendixflag=1
   \def\@secapp{Appendix}
%%%   \def\thetable{\Alph{section}$\cdot$\@arabic\c@table}%
%%%   \def\thefigure{\Alph{section}$\cdot$\@arabic\c@figure}
   \def\theequation{\Alph{section}\raise.5ex\hbox{.}\arabic{equation}}
 \fi

 \@ifundefined {appnedix@1}{\def\thesection{}}
   {\def\thesection{\ \Alph{section}}}

% \def\thesubsection {\rm \Alph{section}.\arabic{subsection}}
% \def\thesubsection {{\it \Alph{section}.\arabic{subsection}}}
 \def\thesubsection {\Alph{section}.\arabic{subsection}}
 \if@filesw \immediate\write\@auxout
       {\string\getappendix{\the\@appendixindex}}
 \advance \@appendixindex by 1 \fi
\@startsection{section}{1}{\z@}
{8truept}{4truept}{\normalsize\bfseries}}

\ProcessOptions

\endinput
%% End of jpsj2.cls %%
