#!/usr/bin/env python

# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.

# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

"""
Sample new images.

1. save tokens 

2. save top tokens
"""
import torch
import torch.distributed as dist
from torchvision.utils import save_image
# from transport import create_transport, Sampler
# from diffusers.models import AutoencoderKL
# import models
import argparse
import multiprocessing as mp
import socket
import os
import fairscale.nn.model_parallel.initialize as fs_init
import json
import sys
import torch.nn.functional as F
# from transformers import CLIPVisionModel, AutoProcessor
from PIL import Image
from torchvision import transforms
import functools
import numpy as np
import torchvision
from torch import nn
sys.path.append("/data3/xy/LlamaGen-origin/tokenizer")
from tokenizer_image.vq_model import VQ_models
# from LlamaGen_MaskGIT.autoregressive.models.gpt import GPT_models
import time
# import models
import math
from tqdm import tqdm
# sys.path.append("LlamaGen-MaskGIT")
from Network.gpt import GPT_models
# from autoregressive.models.gpt import GPT_models
# from autoregressive.models.generate import generate

def find_free_port() -> int:
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.bind(("", 0))
    port = sock.getsockname()[1]
    sock.close()
    return port

def adap_sche(step, mode="arccos", leave=False):
    """ Create a sampling scheduler
        :param
        step  -> int:  number of prediction during inference
        mode  -> str:  the rate of value to unmask
        leave -> bool: tqdm arg on either to keep the bar or not
        :return
        scheduler -> torch.LongTensor(): the list of token to predict at each step
    """
    r = torch.linspace(1, 0, step)
    if mode == "root":              # root scheduler
        val_to_mask = 1 - (r ** .5)
    elif mode == "linear":          # linear scheduler
        val_to_mask = 1 - r
    elif mode == "square":          # square scheduler
        val_to_mask = 1 - (r ** 2)
    elif mode == "cosine":          # cosine scheduler
        val_to_mask = torch.cos(r * math.pi * 0.5)
    elif mode == "arccos":          # arc cosine scheduler
        val_to_mask = torch.arccos(r) / (math.pi * 0.5)
    else:
        return

    # fill the scheduler by the ratio of tokens to predict at each step
    sche = (val_to_mask / val_to_mask.sum()) * (256)
    sche = sche.round()
    sche[sche == 0] = 1                                                  # add 1 to predict a least 1 token / step
    sche[-1] += (256) - sche.sum()         # need to sum up nb of code
    return tqdm(sche.int(), leave=leave)


def main(args, rank, master_port):
    # Setup PyTorch:
    torch.manual_seed(args.seed)
    torch.set_grad_enabled(False)

    os.environ["RANK"] = str(rank)
    os.environ["WORLD_SIZE"] = str(args.num_gpus)
    os.environ["MASTER_PORT"] = str(master_port)
    os.environ["MASTER_ADDR"] = "127.0.0.1"

    dist.init_process_group("nccl")
    fs_init.initialize_model_parallel(1)
    device = "cuda"
    seed = args.global_seed * dist.get_world_size() + rank
    torch.manual_seed(seed)
    torch.cuda.set_device(rank)

    # create and load tokenizer
    vq_model = VQ_models['VQ-16'](codebook_size=16384, codebook_embed_dim=8)
    vq_model.eval()
    checkpoint = torch.load('/data3/xy/vq_ds16_c2i.pt', map_location="cpu")
    vq_model.load_state_dict(checkpoint["model"], strict=True)
    vq_model = vq_model.to(device)
    del checkpoint
    print(f"Image tokenizer is loaded")

    # create and load DiT model
    torch_dtype = {"fp32": torch.float, "tf32": torch.float, "bf16": torch.bfloat16, "fp16": torch.float16,}[args.precision]
    latent_size = args.image_size // 16
    """
        load llamagen
    """
    model = GPT_models["GPT-B"](
            vocab_size=args.codebook_size,
            block_size=256,
            num_classes=1000,
            cls_token_num=1,
            model_type='c2i'
        )

    ckpt_path = '/data3/xy/llamagen-llamagen/pretrained_maskgit/MaskGITepoch_050.pth'
    checkpoint = torch.load(ckpt_path, map_location="cpu")
    model.load_state_dict(checkpoint['model_state_dict'], strict=True)
    model = model.to(device)
    model.eval()
    del checkpoint
    print(f"Model is loaded")

    """
        imagenet origin image --> mask 
    """
    # class_labels = [19, 47, 207, 360, 387, 647, 974, 919]
    # latent_size = 16
    # mask_value = 16384
    
    # c_indices = torch.tensor(class_labels, device=device)
    # qzshape = [len(class_labels), args.codebook_embed_dim, latent_size, latent_size]
    # update_mask_nums = int(latent_size * latent_size * 1.0 / args.inference_iters)
    """
        for save tokens
    """
    class_labels = [0, 7, 24]
    image_size = 256
    transform = transforms.Compose([
        transforms.Resize(image_size),
        transforms.CenterCrop((image_size, image_size)),
        transforms.ToTensor(),
    ])

    image_1 = transform(Image.open("/data3/xy/0.jpg"))
    image_2 = transform(Image.open("/data3/xy/7.jpg"))
    image_3 = transform(Image.open("/data3/xy/24.jpg"))
    images = torch.stack((image_1, image_2, image_3), dim=0).to(device)
    images = 2 * images - 1
    _, _, [_, _, indices] = vq_model.encode(images)
    code = indices.reshape(images.shape[0], -1) # [B, 256]

    # save token 
    # save_index = [10,36,49,61,64,65,72,78,85,87,94,98,102,103,122,147,166,170,181,188,204,222,236,237,249]
    # save_index = [2, 4, 8, 9, 10, 22, 24, 36, 45, 49, 53, 61, 64, 65, 72, 78, 79, 84, 85, 87, 94, 98, 102, 103, 122, 131, 144, 147, 157, 161, 166, 170, 176, 180, 181, 182, 183, 188, 194, 196, 204, 213, 216, 222, 225, 236, 237, 242, 243, 249]
    # save_index = [2, 4, 8, 9, 10, 14, 19, 20, 22, 24, 36, 45, 49, 53, 58, 60, 61, 64, 65, 72, 78, 79, 84, 85, 87, 94, 98, 102, 103, 113, 114, 122, 125, 130, 131, 134, 135, 138, 139, 142, 144, 147, 149, 154, 157, 161, 166, 170, 176, 180, 181, 182, 183, 184, 188, 193, 194, 196, 204, 206, 207, 208, 213, 216, 218, 222, 225, 236, 237, 241, 242, 243, 249, 251, 252]
    # save_index = [2, 3, 4, 8, 9, 10, 14, 19, 20, 22, 24, 36, 43, 45, 46, 49, 53, 58, 60, 61, 64, 65, 67, 72, 74, 76, 77, 78, 79, 82, 83, 84, 85, 86, 87, 94, 98, 99, 102, 103, 113, 114, 122, 123, 124, 125, 129, 130, 131, 132, 134, 135, 138, 139, 142, 143, 144, 146, 147, 149, 154, 157, 161, 166, 167, 170, 171, 176, 180, 181, 182, 183, 184, 185, 188, 193, 194, 196, 204, 205, 206, 207, 208, 213, 216, 218, 222, 225, 229, 231, 236, 237, 239, 241, 242, 243, 249, 251, 252, 255]
    save_index = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
    save_index = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26]
    save_index = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39]
    # save_index = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]
    modified_code = torch.full((code.shape[0], 256), 16384, dtype=torch.long).to(device)
    modified_code[:, save_index] = code[:, save_index]
    init_code = modified_code.reshape(code.shape[0], 16, 16)
    # print(init_code)
    l_codes = []  # Save the intermediate codes predicted
    l_mask = []   # Save the intermediate masks
    with torch.no_grad():
        labels = torch.LongTensor(class_labels).to(device)
        drop = torch.ones(len(labels), dtype=torch.bool).to(device)
        if init_code is not None:
            code = init_code
            mask = (init_code == args.codebook_size).float().view(len(labels), 256)
        else:  # Initialize a code 
            code = torch.full((len(labels), 16, 16), args.mask_value).to(device)
            mask = torch.ones((len(labels), 256)).to(device)

        scheduler = adap_sche(step=args.inference_iters, mode='arccos')
        for indice, t in enumerate(scheduler):
            if mask.sum() < t:  # Cannot predict more token than 16*16 or 32*32
                t = int(mask.sum().item())

            if mask.sum() == 0:  # Break if code is fully predicted
                break

            with torch.cuda.amp.autocast():  # half precision
                if args.cfg_scale != 0:
                    # Model Prediction
                    logit = model(torch.cat([code.clone(), code.clone()], dim=0),torch.cat([labels, labels], dim=0), torch.cat([~drop, drop], dim=0))
                    logit_c, logit_u = torch.chunk(logit, 2, dim=0)
                    _w = args.cfg_scale * (indice / (len(scheduler)-1))
                    # Classifier Free Guidance
                    logit = (1 + _w) * logit_c - _w * logit_u
                else:
                    logit = model(code.clone(), labels, drop_label=~drop)

            prob = torch.softmax(logit * args.temperature, -1)
            # Sample the code from the softmax prediction
            distri = torch.distributions.Categorical(probs=prob)
            pred_code = distri.sample()

            conf = torch.gather(prob, 2, pred_code.view(len(labels), 256, 1))

            if args.randomize == "linear":  # add gumbel noise decreasing over the sampling process
                ratio = (indice / (len(scheduler)-1))
                rand = args.r_temp * np.random.gumbel(size=(len(labels), 256)) * (1 - ratio)
                conf = torch.log(conf.squeeze()) + torch.from_numpy(rand).to(device)
            elif args.randomize == "warm_up":  # chose random sample for the 2 first steps
                conf = torch.rand_like(conf) if indice < 2 else conf
            elif args.randomize == "random":   # chose random prediction at each step
                conf = torch.rand_like(conf)

            # do not predict on already predicted tokens
            conf[~mask.bool()] = -math.inf

            # chose the predicted token with the highest confidence
            tresh_conf, indice_mask = torch.topk(conf.view(len(labels), -1), k=t, dim=-1)
            tresh_conf = tresh_conf[:, -1]

            # replace the chosen tokens
            conf = (conf >= tresh_conf.unsqueeze(-1)).view(len(labels), 16, 16)
            f_mask = (mask.view(len(labels), 16, 16).float() * conf.view(len(labels), 16, 16).float()).bool()
            code[f_mask] = pred_code.view(len(labels), 16, 16)[f_mask]

            # update the mask
            for i_mask, ind_mask in enumerate(indice_mask):
                mask[i_mask, ind_mask] = 0
            l_codes.append(pred_code.view(len(labels), 16, 16).clone())
            l_mask.append(mask.view(len(labels), 16, 16).clone())
        _code = torch.clamp(code, 0,  args.codebook_size-1)
        qzshape = [_code.shape[0], args.codebook_embed_dim, 16, 16]
        samples = vq_model.decode_code(code, qzshape)
        save_image(samples, "sample.png", nrow=4, normalize=True, value_range=(-1, 1))

    # # mask t tokens in code
    # # mask = torch.ones(len(class_labels), latent_size*latent_size).to(device)
    # # for i in range(code.shape[0]):
    # #     index = torch.randperm(latent_size*latent_size)
    # #     mask_index = index[:4*update_mask_nums]
    # #     code_mask_index = index[4*update_mask_nums:]
    # #     code[i, code_mask_index] = mask_value
    # #     mask[i, mask_index] = 0

    # # Input & Mask:
    # # mask_value = 16385
    # latent_size = 16
    # mask_value = 16385
    # image_size = 256
    # class_labels = [0, 19, 47, 120, 207, 360, 487, 520, 647, 800, 974, 919]
    # c_indices = torch.tensor(class_labels, device=device)
    # qzshape = [len(class_labels), args.codebook_embed_dim, latent_size, latent_size]

    # code = torch.full((len(class_labels), latent_size*latent_size), mask_value).to(device)
    # mask = torch.ones(len(class_labels), latent_size*latent_size).to(device)
    # update_mask_nums = int(latent_size * latent_size * 1.0 / args.inference_iters)


    # """
    #     process init code
    # """


    # """
    #     exp2: MaskGIT: top k confidence sample
    # """
    # sm_temp = 1.0
    # for t in range(0, args.inference_iters):
    #     if mask.sum() == 0:  # Break if code is fully predicted
    #         break
    #     # predict code
    #     # mask_ratio = mask.sum() / (latent_size*latent_size)
    #     input_t = torch.ones(len(class_labels)).to(device) * mask.sum()
    #     with torch.no_grad():
    #         # logits = model(code, input_t, c_indices)
    #         logits = model(idx = code, cond_idx = c_indices)
    #         uncond = torch.ones_like(c_indices) * args.num_classes
    #         no_logits = model(code, uncond)
    #         print(no_logits.shape)
    #         logits = args.cfg_scale*(logits - no_logits) + no_logits
    #     prob = torch.softmax(logits[:, 1:, :16384] * sm_temp, -1)
    #     _, pred_code = torch.max(prob.data, dim=2)
    #     # print(pred_code.shape, pred_code.max())
    #     # distri = torch.distributions.Categorical(probs=prob)
    #     # pred_code = distri.sample()

    #     # process confidence
    #     conf = torch.gather(prob, 2, pred_code.view(len(class_labels), latent_size*latent_size, 1))
    #     # conf = torch.rand_like(conf) if t == 0 else conf
    #     conf[~mask.bool()] = -math.inf  # do not predict on already predicted tokens

    #     # chose the predicted token with the highest confidence
    #     conf = conf.view(len(class_labels), -1)
    #     tresh_conf, indice_mask = torch.topk(conf, k=update_mask_nums, dim=-1)
    #     tresh_conf = tresh_conf[:, -1]

    #     # replace the chosen tokens
    #     # conf = (conf >= tresh_conf.unsqueeze(-1)).view(len(class_labels), latent_size, latent_size)
    #     conf = conf >= tresh_conf.unsqueeze(-1)
    #     f_mask = (mask.float() * conf.float()).bool()
    #     code[f_mask] = pred_code[f_mask]
    #     print(torch.sum(torch.eq(code, 16384)))

    #     # update the mask
    #     for i_mask, ind_mask in enumerate(indice_mask):
    #         mask[i_mask, ind_mask] = 0
    #     # update_mask_nums += update_mask_nums

    # """
    #    exp1: random sample
    # """
    
    # # for t in range(0, args.inference_iters):
    # #     # Break if code is fully predicted
    # #     if mask.sum() == 0:
    # #         break
    # #     mask_ratio = mask.sum() / (latent_size*latent_size)  # t
    # #     input_t = torch.ones(len(class_labels)).to(device) * mask_ratio
    # #     # predict all tokens
    # #     logits = model(code, input_t, c_indices)
    # #     _, code = torch.max(logits.data, dim=2)

    # #     # update mask  
    # #     for i in range(mask.shape[0]):
    # #         indices = torch.where(mask[i] == 1)[0]
    # #         # select mask 1 to 0
    # #         zero_indices = indices[torch.randperm(len(indices))[:update_mask_nums]]
    # #         mask[i, zero_indices] = 0
    # #         code[i, torch.where(mask[i] == 1)[0]] = mask_value
    # print(code.shape, code.max())
    # samples = vq_model.decode_code(code, qzshape) # output value is between [-1, 1]
    # # print(samples.shape, samples.min(), samples.max())
    # save_image(samples, "sample.png", nrow=4, normalize=True, value_range=(-1, 1))


if __name__ == "__main__":
    parser = argparse.ArgumentParser()

    # parser.add_argument("--model", type=str, default="DiT_Llama_600M_patch2")
    parser.add_argument("--model", type=str, choices=list(GPT_models.keys()), default="GPT-L")
    parser.add_argument("--gpt-type", type=str, choices=['c2i', 't2i'], default="c2i", help="class-conditional or text-conditional") 
    parser.add_argument("--model-ckpt", type=str, default="results/DiT_Llama_600M_patch2_bs512_lr1e-4_bf16_qknorm_lognorm/checkpoints/0110000")
    parser.add_argument("--vq-model", type=str, choices=list(VQ_models.keys()), default="VQ-16")
    parser.add_argument("--vq-ckpt", type=str, default="LlamaGen/vq_ds16_c2i.pt", help="ckpt path for vq model")
    parser.add_argument("--codebook-size", type=int, default=16384, help="codebook size for vector quantization")
    parser.add_argument("--codebook-embed-dim", type=int, default=8, help="codebook dimension for vector quantization")
    parser.add_argument("--qk-norm", action="store_true",)
    parser.add_argument("--num-classes", type=int, default=1000)
    parser.add_argument("--seed", type=int, default=42)
    parser.add_argument("--precision", type=str, choices=["fp32", "tf32", "fp16", "bf16"],default="bf16",)
    parser.add_argument("--image_size", type=int, choices=[256, 512], default=256)
    parser.add_argument("--num_gpus", type=int, default=1)
    parser.add_argument("--global_seed", type=int, default=0)
    parser.add_argument("--compile", action='store_true', default=False)
    parser.add_argument("--inference_iters", type=int, default=12)
    parser.add_argument("--cfg_scale", type=float, default=4.0)
    
    parser.add_argument("--randomize", type=str, default='linear')
    # parser.add_argument("--gpt-type", type=str, choices=['c2i', 't2i'], default="c2i", help="class-conditional or text-conditional")
    # parser.add_argument("--from-fsdp", action='store_true')
    # parser.add_argument("--cls-token-num", type=int, default=1, help="max token number of condition input")
    # parser.add_argument("--image-size", type=int, choices=[256, 384, 512], default=384)
    # parser.add_argument("--downsample-size", type=int, choices=[8, 16], default=16)
    # parser.add_argument("--cfg-scale", type=float, default=4.0)
    parser.add_argument("--r_temp", type=float, default=4.5)
    # parser.add_argument("--top-k", type=int, default=2000,help="top-k value to sample with")
    parser.add_argument("--temperature", type=float, default=1.0, help="temperature value to sample with")
    # parser.add_argument("--top-p", type=float, default=1.0, help="top-p value to sample with")
    args = parser.parse_args()

    master_port = find_free_port()
    mp.set_start_method("spawn")
    procs = []
    for i in range(args.num_gpus):
        p = mp.Process(target=main, args=(args, i, master_port))
        p.start()
        procs.append(p)
    for p in procs:
        p.join()