from collections import defaultdict


class MediaCollection:
    def __init__(self):
        self._type_item_view = defaultdict(lambda: defaultdict(list))

    def add_media(self, media, media_type, item_idx):
        self._type_item_view[media_type][item_idx].append(media)

    def get_type_view(self):
        type_view = defaultdict(list)
        for media_type in self._type_item_view:
            for item_idx in sorted(self._type_item_view[media_type].keys()):
                l_media = self._type_item_view[media_type][item_idx]
                type_view[media_type] += l_media

        return type_view

    def get_item_view(self):
        item_view = defaultdict(list)
        for media_type in self._type_item_view:
            for item_idx in sorted(self._type_item_view[media_type].keys()):
                l_media = self._type_item_view[media_type][item_idx]
                item_view[item_idx] += l_media

        return item_view

    def get_item_type_view(self):
        item_type_view = defaultdict(lambda: defaultdict(list))
        for media_type in self._type_item_view:
            for item_idx in sorted(self._type_item_view[media_type].keys()):
                l_media = self._type_item_view[media_type][item_idx]
                item_type_view[item_idx][media_type] += l_media

        return item_type_view

    def get_type_item_view(self):
        type_item_view = defaultdict(lambda: defaultdict(list))
        for media_type in self._type_item_view:
            for item_idx in sorted(self._type_item_view[media_type].keys()):
                l_media = self._type_item_view[media_type][item_idx]
                type_item_view[media_type][item_idx] += l_media

        return type_item_view
