#!/bin/bash

init_from=$1
load_str=$2

lr=2e-5
wd=0.1
dropout=0.05
z_loss_weight=1e-5

data_config=configs/data/mgm-IdZl-herm-var512.yaml

exp_name=128_mgm-IdZl-herm-var512_lr${lr}wd${wd}drop${dropout}z${z_loss_weight}_load${load_str}
echo "exp name: $exp_name  node: $SLURMD_NODENAME"
mkdir -p output/"$exp_name"

#export NCCL_DEBUG=INFO

python -u finetune_solver_cfg.py \
--batch_size 16 \
--accum_iter 1 \
--epochs 100 \
--warmup_epochs 0.01 \
--lr ${lr} \
--min_lr ${lr} \
--wd ${wd} \
--clip_grad 4 \
--data_config $data_config \
--cache_ann_on_disk \
--num_workers 8 \
--output_dir output/"$exp_name" \
--save_iteration_interval 1000 \
--checkpointing \
--max_seq_len 2048 \
--unmask_image_logits \
--dropout ${dropout} \
--z_loss_weight ${z_loss_weight} \
--init_from ${init_from} \
2>&1 | tee -a output/"$exp_name"/output.log

echo "exp name: $exp_name"
