import{s as va,o as _a,n as Ba}from"../chunks/scheduler.37c15a92.js";import{S as Qa,i as Wa,g as a,s as n,r as M,A as Ra,h as i,f as t,c as p,j as Va,u as o,x as r,k as ip,y as Na,a as l,v as c,d as y,t as J,w as m}from"../chunks/index.2bf4358c.js";import{T as Xa}from"../chunks/Tip.363c041f.js";import{Y as Aa}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ga}from"../chunks/CourseFloatingBanner.06521e8b.js";import{H as Jt,E as La}from"../chunks/EditOnGithub.8916dc7c.js";function qa(mt){let j,w="<strong>更进一步</strong>如果你在包含 unicode 字符的字符串上测试先前 normalizers 的两个版本，你肯定会注意到这两个 normalizers 并不完全等效。",d,u,f="为了避免 <code>normalizers.Sequence</code> 过于复杂，我们的实现没有包含当 <code>clean_text</code> 参数设置为 <code>True</code> 时 <code>BertNormalizer</code> 需要的正则表达式替换 —— 而这是 <code>BertNormalizer</code> 默认会实现的。但不要担心：通过在 normalizer 序列中添加两个 <code>normalizers.Replace</code> 可以在不使用方便的 <code>BertNormalizer</code> 的情况下获得完全相同的标准化。";return{c(){j=a("p"),j.innerHTML=w,d=n(),u=a("p"),u.innerHTML=f},l(k){j=i(k,"P",{"data-svelte-h":!0}),r(j)!=="svelte-5z0bx8"&&(j.innerHTML=w),d=p(k),u=i(k,"P",{"data-svelte-h":!0}),r(u)!=="svelte-1xqyqzu"&&(u.innerHTML=f)},m(k,U){l(k,j,U),l(k,d,U),l(k,u,U)},p:Ba,d(k){k&&(t(j),t(d),t(u))}}}function Ha(mt){let j,w,d,u,f,k,U,Tt,g,rp="正如我们在前几节中看到的，tokenization 包括几个步骤：",jt,x,Mp="<li>标准化（任何认为必要的文本清理，例如删除空格或重音符号、Unicode 规范化等）</li> <li>预分词（将输入拆分为单词）</li> <li>通过模型处理输入（使用预先拆分的词来生成一系列  tokens ）</li> <li>后处理（添加 tokenizer 的特殊 tokens 生成注意力掩码和 token 类型 ID）</li>",kt,h,op="作为复习，这里再看一遍整个过程：",ut,$,cp='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline.svg" alt="The tokenization pipeline."/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter6/tokenization_pipeline-dark.svg" alt="The tokenization pipeline."/>',Ut,z,yp='🤗 Tokenizers 库旨在为每个步骤提供多个选项，你可以任意搭配这些选项。在这一节中，我们将看到如何从零开始构建 tokenizer，而不是像我们在 <a href="/course/chapter6/2">第二节</a> 中那样从旧的 tokenizer 训练新的 tokenizer 然后，你将能够构建任何你能想到的类型的 tokenizer',dt,C,ft,I,Jp="更精确地说，这个库围绕一个中心的 <code>Tokenizer</code> 类，实现了组成 <code>Tokenizer</code> 的各种子模块：",$t,Z,mp='<li><code>normalizers</code> 包含所有可能使用的 <code>Normalizer（标准化）</code> 模块（完整列表 <a href="https://huggingface.co/docs/tokenizers/api/normalizers" rel="nofollow">在这里</a> ）。</li> <li><code>pre_tokenizesr</code> 包含所有可能使用的 <code>PreTokenizer（预处理）</code> 模块（完整列表 [在这里](https://huggi	ngface.co/docs/tokenizers/api/pre-tokenizers) ）。</li> <li><code>models</code> 包含了你可以使用的各种 <code>Model（子词分词算法模型）</code> 模块，如 <code>BPE</code> 、 <code>WordPiece</code> 和 <code>Unigram</code> （完整列表 <a href="https://huggingface.co/docs/tokenizers/api/models" rel="nofollow">在这里</a> ）。</li> <li><code>trainers</code> 包含所有不同类型的 <code>trainer</code> ，你可以使用它们在语料库上训练你的模型（每种模型一个；完整列表 <a href="https://huggingface.co/docs/tokenizers/api/trainers" rel="nofollow">在这里</a> ）。</li> <li><code>post_processors</code> 包含你可以使用的各种类型的 <code>PostProcessor（后处理）</code> 模块，（完整列表 <a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">在这里</a> ）。</li> <li><code>decoders</code> 包含各种类型的 <code>Decoder</code> ，可以用来解码 tokenization 后的输出（完整列表 <a href="https://huggingface.co/docs/tokenizers/components#decoders" rel="nofollow">在这里</a> ）。</li>',bt,V,Tp='你可以 <a href="https://huggingface.co/docs/tokenizers/components" rel="nofollow">在这里</a> 找到完整的模块列表。',wt,v,gt,_,jp='为了训练新的 tokenizer 我们将使用一小部分文本作为语料库（这样运行得更快）。获取语​​料库的步骤与我们在 <a href="/course/chapter6/2">在这章的开头</a> 采取的步骤类似，但这次我们将使用 <a href="https://huggingface.co/datasets/wikitext" rel="nofollow">WikiText-2</a> 数据集：',xt,B,ht,Q,kp="<code>get_training_corpus()</code> 函数是一个生成器，每次调用的时候将产生 1,000 个文本，我们将用它来训练 tokenizer 。",zt,W,up="🤗 Tokenizers 也可以直接在文本文件上进行训练。以下是我们生成一个包含 WikiText-2 所有文本的代码，这样我们就可以在本地离线使用：",Ct,R,It,N,Up="接下来，我们将展示如何模块化地构建你自己的 BERT、GPT-2 和 XLNet  tokenizer 这将包含主要的分词算法：WordPiece、BPE 和 Unigram 的例子。让我们从 BERT 开始吧！",Zt,X,Vt,A,dp="要用🤗 Tokenizers 库构建一个 tokenizer 我们首先实例化一个带有 <code>model</code> 的 <code>Tokenizer</code> 对象，然后将其 <code>normalizer</code> ， <code>pre_tokenizer</code> ， <code>post_processor</code> 和 <code>decoder</code> 属性设置为我们想要的值。",vt,G,fp="以这个例子来说，我们将创建一个使用 WordPiece 模型的 <code>Tokenizer</code> ：",_t,L,Bt,q,$p="我们必须指定 <code>unk_token</code> ，这样当模型遇到它从未见过的字符时，它就会返回 <code>unk_token</code>。我们在这里可以设置的其他参数包括已有的 <code>vocab（词汇表）</code> （我们要重新训练模型，所以我们不需要设置这个）和 <code>max_input_chars_per_word</code> ，它指定了每个词的最大长度（比 <code>max_input_chars_per_word</code> 长的词将被拆分）。",Qt,H,bp="tokenization 的第一步是标准化，所以我们从这里开始。由于 BERT 被广泛使用，所以我们可以使用 <code>BertNormalizer</code> ，我们可以为 BERT 设置经典参数： <code>lowercase（小写）</code> 和 <code>strip_accents（去除重音的字符）</code> ， <code>clean_text</code> 用于删除所有控制字符并将重复的空格替换为一个空格；以及 <code>handle_chinese_chars</code> ，它将在中文字符周围添加空格。要复现 <code>bert-base-uncased</code> tokenizer 我们可以这样设置 <code>normalizer</code> ：",Wt,D,Rt,E,wp="然而，通常来说，当你构建一个新的 tokenizer 时，也需要同步构建一个新的 <code>normalizer</code> —— 所以我们来看看如何手动创建 <code>BERT normalizer</code> 。🤗 Tokenizers 库提供了一个 <code>Lowercase normalizer</code> 和一个 <code>StripAccents normalizer</code> ，并且你可以使用 Sequence 来组合多个 normalizer。",Nt,S,Xt,P,gp="我们还使用了一个 <code>NFD Unicode normalizer</code> ，否则，否则 <code>StripAccents normalizer</code> 将因为无法正确识别带有重音的字符，从而没办法去除重音。",At,F,xp="正如我们之前看到的，我们可以使用 <code>normalizer</code> 的 <code>normalize_str()</code> 方法来对它进行测试：",Gt,Y,Lt,K,qt,b,Ht,O,hp="下一步是预分词。同样，我们可以使用预构建的 <code>BertPreTokenizer</code> ：",Dt,ee,Et,se,zp="或者我们可以从头开始构建它：",St,te,Pt,le,Cp="注意， <code>Whitespace</code> 会使用空格和所有不是字母、数字或下划线的字符进行分割，因此在本次的例子中上会根据空格和标点符号进行分割：",Ft,ne,Yt,pe,Kt,ae,Ip="如果你只想使用空格进行分割，则应该使用 <code>WhitespaceSplit</code> ：",Ot,ie,el,re,sl,Me,Zp="就像 normalizer 一样，你可以使用 <code>Sequence</code> 来组合几个预分词的步骤：",tl,oe,ll,ce,nl,ye,Vp="tokenization 流程的下一步是将输入数据传递给模型。我们已经在初始化时指定了我们的模型，但是我们还需要对其进行训练，这就需要一个 <code>WordPieceTrainer</code> 。在实例化一个🤗 Tokenizers 中的 <code>Trainer</code> 时，一件很重要的事情是，你需要将你打算使用的所有特殊 tokens 都传递给它——否则，由于它们不在训练语料库中，<code>Trainer</code> 就不会将它们添加到词汇表中：",pl,Je,al,me,vp="除了指定 <code>vocab_size</code> 和 <code>special_tokens</code> ，我们还可以设置 <code>min_frequency</code> （一个 tokens 必须达到的最小的出现的次数才能被包含在词汇表中）或更改 <code>continuing_subword_prefix</code> （如果我们想使用其他的字符来替代 <code>##</code> ）。",il,Te,_p="我们只需要执行以下命令就可以使用我们之前定义的迭代器训练我们的模型：",rl,je,Ml,ke,Bp="我们还可以使用本地的文本文件来训练我们的 tokenizer 它看起来像这样（我们需要先使用 <code>WordPiece</code> 初始化一个空的模型）：",ol,ue,cl,Ue,Qp="在这两种情况下，我们都可以通过调用 <code>encode()</code> 方法来测试 tokenizer",yl,de,Jl,fe,ml,$e,Wp="所得到的 <code>encoding</code> 是一个 <code>Encoding</code> 对象，它包含 tokenizer 的所有必要属性： <code>ids</code> 、 <code>type_ids</code> 、 <code>tokens</code> 、 <code>offsets</code> 、 <code>attention_mask</code> 、 <code>special_tokens_mask</code> 和 <code>overflowing</code> 。",Tl,be,Rp="tokenizer 管道的最后一步是后处理。我们需要在开头添加 <code>[CLS]</code> token，然后在结束时（或在每句话后，如果我们有一对句子）添加 <code>[SEP]</code> token。我们将使用 <code>TemplateProcessor</code> 来完成这个任务，但首先我们需要知道词汇表中 <code>[CLS]</code> 和 <code>[SEP]</code> tokens 的 ID：",jl,we,kl,ge,ul,xe,Np="编写 <code>TemplateProcessor</code> 的模板时，我们必须指定如何处理单个句子和一对句子。对于这两者，我们写下我们想使用的特殊 tokens 第一句（或单句）用 <code>$A</code> 表示，而第二句（如果需要编码一对句子）用 <code>$B</code> 表示。对于这些（特殊 tokens 和句子），我们还需要在冒号后指定相应的 token 类型 ID。",Ul,he,Xp="因此，经典的 BERT 模板定义如下：",dl,ze,fl,Ce,Ap="请注意，我们需要传递特殊 tokens 的 ID，这样 tokenizer 才能正确地将它们转换为它们的 ID。",$l,Ie,Gp="添加之后，我们再次对之前的例子进行 tokenization：",bl,Ze,wl,Ve,gl,ve,Lp="在一对句子中，我们也得到了正确的结果：",xl,_e,hl,Be,zl,Qe,qp="我们几乎从头开始构建了这个 tokenizer ——但是还有最后一步：指定一个解码器：",Cl,We,Il,Re,Hp="让我们在之前的 <code>encoding</code> 上测试一下它：",Zl,Ne,Vl,Xe,vl,Ae,Dp="很好！我们可以将 tokenizer 保存在一个 JSON 文件中，如下所示：",_l,Ge,Bl,Le,Ep="然后，我们可以在一个 <code>Tokenizer</code> 对象中使用 <code>from_file()</code> 方法重新加载该文件：",Ql,qe,Wl,He,Sp="要在🤗 Transformers 中使用这个 tokenizer 我们需要将它封装在一个 <code>PreTrainedTokenizerFast</code> 类中。我们可以使用通用类（PreTrainedTokenizerFast），或者，如果我们的 tokenizer 对应于一个现有的模型，则可以使用该类（例如这里的 <code>BertTokenizerFast</code> ）。如果你使用这个课程来构建一个全新的 tokenizer 并且没有一个现有的模型可以使用，就必须需要使用通用类。",Rl,De,Pp="要将构建的 tokenizer 封装在 <code>PreTrainedTokenizerFast</code> 类中，我们可以将我们构建的 tokenizer 作为 <code>tokenizer_object</code> 传入，或者将我们保存的 tokenizer 文件作为 <code>tokenizer_file</code> 传入。要记住的关键一点是，我们需要手动设置所有的特殊 tokens，因为这个类不能从 <code>tokenizer</code> 对象推断出哪个符号是掩码符号， <code>[CLS]</code> 符号等：",Nl,Ee,Xl,Se,Fp="如果你使用的是其他的 tokenizer 类（如 <code>BertTokenizerFast</code> ），你只需要指定那些与默认值不同的特殊符号（这里没有）：",Al,Pe,Gl,Fe,Yp="然后，你就可以像使用其他的🤗 Transformers  tokenizer 一样使用这个 tokenizer 了。你可以使用 <code>save_pretrained()</code> 方法来保存它，或者使用 <code>push_to_hub()</code> 方法将它上传到 Hub。",Ll,Ye,Kp="既然我们已经看到了如何构建一个 WordPiece  tokenizer。那么让我们也尝试构建 BPE  tokenizer。这次我们会快一些，因为你已经知道所有的步骤，我们主要强调其中的区别。",ql,Ke,Hl,Oe,Op="现在让我们构建一个 GPT-2  tokenizer，与 BERT  tokenizer 一样，我们首先通过 BPE model 初始化一个 <code>Tokenizer</code> ：",Dl,es,El,ss,ea="同样，类似于 BERT，如果我们已经有一个词汇表，我们也可以使用这个词汇表来初始化 GPT 模型（在这种情况下，我们需要传入 <code>vocab</code> 和 <code>merges</code> 参数），但是因为我们将从头开始训练，所以我们不需要做这个。我们也不需要指定 <code>unk_token</code> ，因为 GPT-2 使用字节级 BPE，这不需要它。",Sl,ts,sa="GPT-2 不使用 <code>normalizer</code> ，因此我们跳过该步骤并直接进入预分词：",Pl,ls,Fl,ns,ta="我们在这里给 <code>ByteLevel</code> 添加的选项的含义是不在句子的开始添加空格（默认为 ture）。我们可以看一下之前的示例文本经过预分词后的结果：",Yl,ps,Kl,as,Ol,is,la="接下来是需要训练的模型。对于 GPT-2，唯一的特殊符号是文本结束符：",en,rs,sn,Ms,na="就像 <code>WordPieceTrainer</code> 一样，除了 <code>vocab_size</code> 和 <code>special_tokens</code> ，我们也可以设置 <code>min_frequency</code> ，或者如果我们需要添加一个词尾后缀（如 <code>&lt;/w&gt;</code> ），我们可以用 <code>end_of_word_suffix</code> 设置它。",tn,os,pa="这个 tokenizer 也可以在本地的文本文件上训练：",ln,cs,nn,ys,aa="让我们看一下示例文本经过 tokenization 后的结果：",pn,Js,an,ms,rn,Ts,ia="我们对 GPT-2  tokenizer 添加字节级后处理，如下所示：",Mn,js,on,ks,ra="<code>trim_offsets = False</code> 这个选项告诉 post-processor，我们应该让那些以‘Ġ’开始的 tokens 的偏移量保持不变：这样，偏移量起始的索引将指向单词前的空格，而不是单词的第一个字符（因为空格在技术上是 token 的一部分）。让我们看一下我们编码示例文本的结果，其中 <code>&#39;Ġtest&#39;</code> 是索引 4 的 token",cn,us,yn,Us,Jn,ds,Ma="最后，我们添加一个字节级解码器：",mn,fs,Tn,$s,oa="我们可以再次检查它是否工作正常：",jn,bs,kn,ws,un,gs,ca="太好了！现在我们完成了，我们可以像之前一样保存 tokenizer，并且如果我们想在🤗 Transformers 中使用它，可以将它封装在 <code>PreTrainedTokenizerFast</code> 类或者 <code>GPT2TokenizerFast</code> 类中：",Un,xs,dn,hs,ya="或者：",fn,zs,$n,Cs,Ja="作为最后一个示例，我们将向你展示如何从零开始构建 Unigram  tokenizer",bn,Is,wn,Zs,ma="现在让我们构建一个 XLNet tokenizer 与之前的 tokenizer 一样，我们首先使用 Unigram model 初始化一个 <code>Tokenizer</code> ：",gn,Vs,xn,vs,Ta="同样，如果我们有词汇表，我们可以用词汇表初始化这个模型。",hn,_s,ja="在标准化步骤，XLNet 进行了一些替换（来自 SentencePiece 算法）：",zn,Bs,Cn,Qs,ka="这会将<code>“</code>和<code>”</code>替换为<code>”</code>，将任何连续两个或更多的空格替换为一个空格，同时还将去掉待分词文本中的重音符号。",In,Ws,ua="任何 SentencePiece tokenizer 使用的预 tokenizer 是 <code>Metaspace</code> ：",Zn,Rs,Vn,Ns,Ua="我们可以像以前一样查看示例文本的预分词：",vn,Xs,_n,As,Bn,Gs,da="接下来是需要训练的模型。XLNet 有不少特殊的 tokens",Qn,Ls,Wn,qs,fa="对于 <code>UnigramTrainer</code> 来说，一个非常重要的参数是 <code>unk_token</code> 。我们也可以传递一些 Unigram 算法独有的其他参数，例如我们可以设置每个删除 token 时的 <code>shrinking_factor</code> （默认为 0.75），或者指定 token 最大长度的 <code>max_piece_length</code> （默认为 16）。",Rn,Hs,$a="这个 tokenizer 也可以在本地的文本文件上训练：",Nn,Ds,Xn,Es,ba="让我们看一下示例文本的 tokenization 后的结果：",An,Ss,Gn,Ps,Ln,Fs,wa="XLNet 的一个特点是它将 <code>&lt;cls&gt;</code> token 放在句子的末尾，token 类型 ID 为 2（以区别于其他 tokens）。因此，它在左边进行填充。我们可以像对待 BERT 一样，用模板处理所有特殊 tokens 和 tokens 类型 ID，但首先我们需要获取 <code>&lt;cls&gt;</code> 和 <code>&lt;sep&gt;</code> tokens 的 ID：",qn,Ys,Hn,Ks,Dn,Os,ga="模板如下所示：",En,et,Sn,st,xa="我们可以通过编码一对句子来测试它是否有效：",Pn,tt,Fn,lt,Yn,nt,ha="最后，我们添加一个 <code>Metaspace</code> 解码器：",Kn,pt,On,at,za="我们完成了这个 tokenizer。我们可以像保存其他 tokenizer 一样保存它。如果我们想在 🤗 Transformers 中使用它，可以将它封装在 <code>PreTrainedTokenizerFast</code> 类或 <code>XLNetTokenizerFast</code> 类中。使用 <code>PreTrainedTokenizerFast</code> 类时需要注意的一点是，除了特殊 tokens 之外，我们还需要告诉🤗 Transformers 库在左边进行填充：",ep,it,sp,rt,Ca="或者：",tp,Mt,lp,ot,Ia="现在你已经了解了如何使用各种模块来构建现有的 tokenizer，你应该能够使用 🤗 tokenizer 库编写你想要的任何 tokenizer 并能够在 🤗 Transformers 中使用它。",np,ct,pp,yt,ap;return f=new Jt({props:{title:"模块化构建 tokenizer",local:"模块化构建 tokenizer",headingTag:"h1"}}),U=new Ga({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section8.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/zh-CN/chapter6/section8.ipynb"}]}}),C=new Aa({props:{id:"MR8tZm5ViWU"}}),v=new Jt({props:{title:"获取语​​料库",local:"获取语​​料库",headingTag:"h2"}}),B=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMG5hbWUlM0QlMjJ3aWtpdGV4dC0yLXJhdy12MSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBJTBBZGVmJTIwZ2V0X3RyYWluaW5nX2NvcnB1cygpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMCUyQyUyMGxlbihkYXRhc2V0KSUyQyUyMDEwMDApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBkYXRhc2V0JTVCaSUyMCUzQSUyMGklMjAlMkIlMjAxMDAwJTVEJTVCJTIydGV4dCUyMiU1RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, name=<span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_training_corpus</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(dataset), <span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> dataset[i : i + <span class="hljs-number">1000</span>][<span class="hljs-string">&quot;text&quot;</span>]`,wrap:!1}}),R=new T({props:{code:"d2l0aCUyMG9wZW4oJTIyd2lraXRleHQtMi50eHQlMjIlMkMlMjAlMjJ3JTIyJTJDJTIwZW5jb2RpbmclM0QlMjJ1dGYtOCUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oZGF0YXNldCkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShkYXRhc2V0JTVCaSU1RCU1QiUyMnRleHQlMjIlNUQlMjAlMkIlMjAlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>, encoding=<span class="hljs-string">&quot;utf-8&quot;</span>) <span class="hljs-keyword">as</span> f:
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(dataset)):
        f.write(dataset[i][<span class="hljs-string">&quot;text&quot;</span>] + <span class="hljs-string">&quot;\\n&quot;</span>)`,wrap:!1}}),X=new Jt({props:{title:"从头开始构建 WordPiece  tokenizer",local:"从头开始构建 WordPiece  tokenizer",headingTag:"h2"}}),L=new T({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwZGVjb2RlcnMlMkMlMEElMjAlMjAlMjAlMjBtb2RlbHMlMkMlMEElMjAlMjAlMjAlMjBub3JtYWxpemVycyUyQyUwQSUyMCUyMCUyMCUyMHByZV90b2tlbml6ZXJzJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29ycyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluZXJzJTJDJTBBJTIwJTIwJTIwJTIwVG9rZW5pemVyJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMFRva2VuaXplcihtb2RlbHMuV29yZFBpZWNlKHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMikp",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> (
    decoders,
    models,
    normalizers,
    pre_tokenizers,
    processors,
    trainers,
    Tokenizer,
)

tokenizer = Tokenizer(models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>))`,wrap:!1}}),D=new T({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5CZXJ0Tm9ybWFsaXplcihsb3dlcmNhc2UlM0RUcnVlKQ==",highlighted:'tokenizer.normalizer = normalizers.BertNormalizer(lowercase=<span class="hljs-literal">True</span>)',wrap:!1}}),S=new T({props:{code:"dG9rZW5pemVyLm5vcm1hbGl6ZXIlMjAlM0QlMjBub3JtYWxpemVycy5TZXF1ZW5jZSglMEElMjAlMjAlMjAlMjAlNUJub3JtYWxpemVycy5ORkQoKSUyQyUyMG5vcm1hbGl6ZXJzLkxvd2VyY2FzZSgpJTJDJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklNUQlMEEp",highlighted:`tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [normalizers.NFD(), normalizers.Lowercase(), normalizers.StripAccents()]
)`,wrap:!1}}),Y=new T({props:{code:"cHJpbnQodG9rZW5pemVyLm5vcm1hbGl6ZXIubm9ybWFsaXplX3N0ciglMjJIJUMzJUE5bGwlQzMlQjIlMjBoJUMzJUI0dyUyMGFyZSUyMCVDMyVCQyUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(tokenizer.normalizer.normalize_str(<span class="hljs-string">&quot;Héllò hôw are ü?&quot;</span>))',wrap:!1}}),K=new T({props:{code:"aGVsbG8lMjBob3clMjBhcmUlMjB1JTNG",highlighted:"hello how are u?",wrap:!1}}),b=new Xa({props:{$$slots:{default:[qa]},$$scope:{ctx:mt}}}),ee=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CZXJ0UHJlVG9rZW5pemVyKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.BertPreTokenizer()",wrap:!1}}),te=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5XaGl0ZXNwYWNlKCk=",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Whitespace()",wrap:!1}}),ne=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBteSUyMHByZS10b2tlbml6ZXIuJTIyKQ==",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)',wrap:!1}}),pe=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),ie=new T({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTBBcHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKCUyMkxldCdzJTIwdGVzdCUyMG15JTIwcHJlLXRva2VuaXplci4lMjIp",highlighted:`pre_tokenizer = pre_tokenizers.WhitespaceSplit()
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),re=new T({props:{code:"JTVCKCUyMkxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJ3Rlc3QnJTJDJTIwKDYlMkMlMjAxMCkpJTJDJTIwKCdteSclMkMlMjAoMTElMkMlMjAxMykpJTJDJTIwKCdwcmUtdG9rZW5pemVyLiclMkMlMjAoMTQlMkMlMjAyOCkpJTVE",highlighted:'[(<span class="hljs-string">&quot;Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre-tokenizer.&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">28</span>))]',wrap:!1}}),oe=new T({props:{code:"cHJlX3Rva2VuaXplciUyMCUzRCUyMHByZV90b2tlbml6ZXJzLlNlcXVlbmNlKCUwQSUyMCUyMCUyMCUyMCU1QnByZV90b2tlbml6ZXJzLldoaXRlc3BhY2VTcGxpdCgpJTJDJTIwcHJlX3Rva2VuaXplcnMuUHVuY3R1YXRpb24oKSU1RCUwQSklMEFwcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIoJTIyTGV0J3MlMjB0ZXN0JTIwbXklMjBwcmUtdG9rZW5pemVyLiUyMik=",highlighted:`pre_tokenizer = pre_tokenizers.<span class="hljs-type">Sequence</span>(
    [pre_tokenizers.WhitespaceSplit(), pre_tokenizers.Punctuation()]
)
pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test my pre-tokenizer.&quot;</span>)`,wrap:!1}}),ce=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJyUyMiUyQyUyMCgzJTJDJTIwNCkpJTJDJTIwKCdzJyUyQyUyMCg0JTJDJTIwNSkpJTJDJTIwKCd0ZXN0JyUyQyUyMCg2JTJDJTIwMTApKSUyQyUyMCgnbXknJTJDJTIwKDExJTJDJTIwMTMpKSUyQyUyMCgncHJlJyUyQyUyMCgxNCUyQyUyMDE3KSklMkMlMEElMjAoJy0nJTJDJTIwKDE3JTJDJTIwMTgpKSUyQyUyMCgndG9rZW5pemVyJyUyQyUyMCgxOCUyQyUyMDI3KSklMkMlMjAoJy4nJTJDJTIwKDI3JTJDJTIwMjgpKSU1RA==",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">4</span>)), (<span class="hljs-string">&#x27;s&#x27;</span>, (<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;test&#x27;</span>, (<span class="hljs-number">6</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;my&#x27;</span>, (<span class="hljs-number">11</span>, <span class="hljs-number">13</span>)), (<span class="hljs-string">&#x27;pre&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">17</span>)),
 (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">17</span>, <span class="hljs-number">18</span>)), (<span class="hljs-string">&#x27;tokenizer&#x27;</span>, (<span class="hljs-number">18</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;.&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),Je=new T({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlNUJVTkslNUQlMjIlMkMlMjAlMjIlNUJQQUQlNUQlMjIlMkMlMjAlMjIlNUJDTFMlNUQlMjIlMkMlMjAlMjIlNUJTRVAlNUQlMjIlMkMlMjAlMjIlNUJNQVNLJTVEJTIyJTVEJTBBdHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLldvcmRQaWVjZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2Vucyk=",highlighted:`special_tokens = [<span class="hljs-string">&quot;[UNK]&quot;</span>, <span class="hljs-string">&quot;[PAD]&quot;</span>, <span class="hljs-string">&quot;[CLS]&quot;</span>, <span class="hljs-string">&quot;[SEP]&quot;</span>, <span class="hljs-string">&quot;[MASK]&quot;</span>]
trainer = trainers.WordPieceTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens)`,wrap:!1}}),je=new T({props:{code:"dG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:"tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)",wrap:!1}}),ue=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLldvcmRQaWVjZSh1bmtfdG9rZW4lM0QlMjIlNUJVTkslNUQlMjIpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.WordPiece(unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>)
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),de=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),fe=new T({props:{code:"JTVCJ2xldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJ3Rlc3QnJTJDJTIwJ3RoaXMnJTJDJTIwJ3RvayclMkMlMjAnJTIzJTIzZW5pJyUyQyUyMCclMjMlMjN6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),we=new T({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiU1QkNMUyU1RCUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTVCU0VQJTVEJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[CLS]&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;[SEP]&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),ge=new T({props:{code:"KDIlMkMlMjAzKQ==",highlighted:'(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>)',wrap:!1}}),ze=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWlyJTNEZiUyMiU1QkNMUyU1RCUzQTAlMjAlMjRBJTNBMCUyMCU1QlNFUCU1RCUzQTAlMjAlMjRCJTNBMSUyMCU1QlNFUCU1RCUzQTElMjIlMkMlMEElMjAlMjAlMjAlMjBzcGVjaWFsX3Rva2VucyUzRCU1QiglMjIlNUJDTFMlNUQlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTJDJTIwKCUyMiU1QlNFUCU1RCUyMiUyQyUyMHNlcF90b2tlbl9pZCklNUQlMkMlMEEp",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0&quot;</span>,
    pair=<span class="hljs-string">f&quot;[CLS]:0 $A:0 [SEP]:0 $B:1 [SEP]:1&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;[CLS]&quot;</span>, cls_token_id), (<span class="hljs-string">&quot;[SEP]&quot;</span>, sep_token_id)],
)`,wrap:!1}}),Ze=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ve=new T({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLiclMkMlMjAnJTVCU0VQJTVEJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]',wrap:!1}}),_e=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),Be=new T({props:{code:"JTVCJyU1QkNMUyU1RCclMkMlMjAnbGV0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAndGVzdCclMkMlMjAndGhpcyclMkMlMjAndG9rJyUyQyUyMCclMjMlMjNlbmknJTJDJTIwJyUyMyUyM3plciclMkMlMjAnLi4uJyUyQyUyMCclNUJTRVAlNUQnJTJDJTIwJ29uJyUyQyUyMCdhJyUyQyUyMCdwYWlyJyUyQyUyMCdvZiclMkMlMjAnc2VudGVuY2VzJyUyQyUyMCcuJyUyQyUyMCclNUJTRVAlNUQnJTVEJTBBJTVCMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTVE",highlighted:`[<span class="hljs-string">&#x27;[CLS]&#x27;</span>, <span class="hljs-string">&#x27;let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>, <span class="hljs-string">&#x27;this&#x27;</span>, <span class="hljs-string">&#x27;tok&#x27;</span>, <span class="hljs-string">&#x27;##eni&#x27;</span>, <span class="hljs-string">&#x27;##zer&#x27;</span>, <span class="hljs-string">&#x27;...&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;pair&#x27;</span>, <span class="hljs-string">&#x27;of&#x27;</span>, <span class="hljs-string">&#x27;sentences&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;[SEP]&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]`,wrap:!1}}),We=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5Xb3JkUGllY2UocHJlZml4JTNEJTIyJTIzJTIzJTIyKQ==",highlighted:'tokenizer.decoder = decoders.WordPiece(prefix=<span class="hljs-string">&quot;##&quot;</span>)',wrap:!1}}),Ne=new T({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),Xe=new T({props:{code:"JTIybGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4uLiUyMG9uJTIwYSUyMHBhaXIlMjBvZiUyMHNlbnRlbmNlcy4lMjI=",highlighted:'<span class="hljs-string">&quot;let&#x27;s test this tokenizer... on a pair of sentences.&quot;</span>',wrap:!1}}),Ge=new T({props:{code:"dG9rZW5pemVyLnNhdmUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'tokenizer.save(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),qe=new T({props:{code:"bmV3X3Rva2VuaXplciUyMCUzRCUyMFRva2VuaXplci5mcm9tX2ZpbGUoJTIydG9rZW5pemVyLmpzb24lMjIp",highlighted:'new_tokenizer = Tokenizer.from_file(<span class="hljs-string">&quot;tokenizer.json&quot;</span>)',wrap:!1}}),Ee=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwdG9rZW5pemVyX2ZpbGUlM0QlMjJ0b2tlbml6ZXIuanNvbiUyMiUyQyUyMCUyMyUyMCVFNCVCOSU5RiVFNSU4RiVBRiVFNCVCQiVBNSVFNCVCQiU4RXRva2VuaXplciVFNiU5NiU4NyVFNCVCQiVCNiVFNCVCOCVBRCVFNSU4QSVBMCVFOCVCRCVCRCUwQSUyMCUyMCUyMCUyMHVua190b2tlbiUzRCUyMiU1QlVOSyU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbiUzRCUyMiU1QlBBRCU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsc190b2tlbiUzRCUyMiU1QkNMUyU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlcF90b2tlbiUzRCUyMiU1QlNFUCU1RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfdG9rZW4lM0QlMjIlNUJNQVNLJTVEJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    <span class="hljs-comment"># tokenizer_file=&quot;tokenizer.json&quot;, # 也可以从tokenizer文件中加载</span>
    unk_token=<span class="hljs-string">&quot;[UNK]&quot;</span>,
    pad_token=<span class="hljs-string">&quot;[PAD]&quot;</span>,
    cls_token=<span class="hljs-string">&quot;[CLS]&quot;</span>,
    sep_token=<span class="hljs-string">&quot;[SEP]&quot;</span>,
    mask_token=<span class="hljs-string">&quot;[MASK]&quot;</span>,
)`,wrap:!1}}),Pe=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizerFast

wrapped_tokenizer = BertTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Ke=new Jt({props:{title:"从头开始构建 BPE  tokenizer",local:"从头开始构建 BPE  tokenizer",headingTag:"h2"}}),es=new T({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5CUEUoKSk=",highlighted:"tokenizer = Tokenizer(models.BPE())",wrap:!1}}),ls=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5CeXRlTGV2ZWwoYWRkX3ByZWZpeF9zcGFjZSUzREZhbHNlKQ==",highlighted:'tokenizer.pre_tokenizer = pre_tokenizers.ByteLevel(add_prefix_space=<span class="hljs-literal">False</span>)',wrap:!1}}),ps=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjBwcmUtdG9rZW5pemF0aW9uISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test pre-tokenization!&quot;</span>)',wrap:!1}}),as=new T({props:{code:"JTVCKCdMZXQnJTJDJTIwKDAlMkMlMjAzKSklMkMlMjAoJTIyJ3MlMjIlMkMlMjAoMyUyQyUyMDUpKSUyQyUyMCgnJUM0JUEwdGVzdCclMkMlMjAoNSUyQyUyMDEwKSklMkMlMjAoJyVDNCVBMHByZSclMkMlMjAoMTAlMkMlMjAxNCkpJTJDJTIwKCctJyUyQyUyMCgxNCUyQyUyMDE1KSklMkMlMEElMjAoJ3Rva2VuaXphdGlvbiclMkMlMjAoMTUlMkMlMjAyNykpJTJDJTIwKCchJyUyQyUyMCgyNyUyQyUyMDI4KSklNUQ=",highlighted:`[(<span class="hljs-string">&#x27;Let&#x27;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">3</span>)), (<span class="hljs-string">&quot;&#x27;s&quot;</span>, (<span class="hljs-number">3</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;Ġtest&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;Ġpre&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;-&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">15</span>)),
 (<span class="hljs-string">&#x27;tokenization&#x27;</span>, (<span class="hljs-number">15</span>, <span class="hljs-number">27</span>)), (<span class="hljs-string">&#x27;!&#x27;</span>, (<span class="hljs-number">27</span>, <span class="hljs-number">28</span>))]`,wrap:!1}}),rs=new T({props:{code:"dHJhaW5lciUyMCUzRCUyMHRyYWluZXJzLkJwZVRyYWluZXIodm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQpJTBBdG9rZW5pemVyLnRyYWluX2Zyb21faXRlcmF0b3IoZ2V0X3RyYWluaW5nX2NvcnB1cygpJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`trainer = trainers.BpeTrainer(vocab_size=<span class="hljs-number">25000</span>, special_tokens=[<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>])
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),cs=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLkJQRSgpJTBBdG9rZW5pemVyLnRyYWluKCU1QiUyMndpa2l0ZXh0LTIudHh0JTIyJTVEJTJDJTIwdHJhaW5lciUzRHRyYWluZXIp",highlighted:`tokenizer.model = models.BPE()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Js=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),ms=new T({props:{code:"JTVCJ0wnJTJDJTIwJ2V0JyUyQyUyMCUyMiclMjIlMkMlMjAncyclMkMlMjAnJUM0JUEwdGVzdCclMkMlMjAnJUM0JUEwdGhpcyclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2tlbiclMkMlMjAnaXplciclMkMlMjAnLiclNUQ=",highlighted:'[<span class="hljs-string">&#x27;L&#x27;</span>, <span class="hljs-string">&#x27;et&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;Ġtest&#x27;</span>, <span class="hljs-string">&#x27;Ġthis&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),js=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5CeXRlTGV2ZWwodHJpbV9vZmZzZXRzJTNERmFsc2Up",highlighted:'tokenizer.post_processor = processors.ByteLevel(trim_offsets=<span class="hljs-literal">False</span>)',wrap:!1}}),us=new T({props:{code:"c2VudGVuY2UlMjAlM0QlMjAlMjJMZXQncyUyMHRlc3QlMjB0aGlzJTIwdG9rZW5pemVyLiUyMiUwQWVuY29kaW5nJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShzZW50ZW5jZSklMEFzdGFydCUyQyUyMGVuZCUyMCUzRCUyMGVuY29kaW5nLm9mZnNldHMlNUI0JTVEJTBBc2VudGVuY2UlNUJzdGFydCUzQWVuZCU1RA==",highlighted:`sentence = <span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>
encoding = tokenizer.encode(sentence)
start, end = encoding.offsets[<span class="hljs-number">4</span>]
sentence[start:end]`,wrap:!1}}),Us=new T({props:{code:"JyUyMHRlc3Qn",highlighted:'<span class="hljs-string">&#x27; test&#x27;</span>',wrap:!1}}),fs=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5CeXRlTGV2ZWwoKQ==",highlighted:"tokenizer.decoder = decoders.ByteLevel()",wrap:!1}}),bs=new T({props:{code:"dG9rZW5pemVyLmRlY29kZShlbmNvZGluZy5pZHMp",highlighted:"tokenizer.decode(encoding.ids)",wrap:!1}}),ws=new T({props:{code:"JTIyTGV0J3MlMjB0ZXN0JTIwdGhpcyUyMHRva2VuaXplci4lMjI=",highlighted:'<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>',wrap:!1}}),xs=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwZW9zX3Rva2VuJTNEJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
)`,wrap:!1}}),zs=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyRmFzdCh0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2TokenizerFast

wrapped_tokenizer = GPT2TokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),Is=new Jt({props:{title:"从零开始构建 Unigram  tokenizer",local:"从零开始构建 Unigram  tokenizer",headingTag:"h2"}}),Vs=new T({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwVG9rZW5pemVyKG1vZGVscy5VbmlncmFtKCkp",highlighted:"tokenizer = Tokenizer(models.Unigram())",wrap:!1}}),Bs=new T({props:{code:"ZnJvbSUyMHRva2VuaXplcnMlMjBpbXBvcnQlMjBSZWdleCUwQSUwQXRva2VuaXplci5ub3JtYWxpemVyJTIwJTNEJTIwbm9ybWFsaXplcnMuU2VxdWVuY2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuUmVwbGFjZSglMjIlNjAlNjAlMjIlMkMlMjAnJTIyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKCUyMicnJTIyJTJDJTIwJyUyMicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuTkZLRCgpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbm9ybWFsaXplcnMuU3RyaXBBY2NlbnRzKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBub3JtYWxpemVycy5SZXBsYWNlKFJlZ2V4KCUyMiUyMCU3QjIlMkMlN0QlMjIpJTJDJTIwJTIyJTIwJTIyKSUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`<span class="hljs-keyword">from</span> tokenizers <span class="hljs-keyword">import</span> Regex

tokenizer.normalizer = normalizers.<span class="hljs-type">Sequence</span>(
    [
        normalizers.Replace(<span class="hljs-string">&quot;\`\`&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.Replace(<span class="hljs-string">&quot;&#x27;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>),
        normalizers.NFKD(),
        normalizers.StripAccents(),
        normalizers.Replace(Regex(<span class="hljs-string">&quot; {2,}&quot;</span>), <span class="hljs-string">&quot; &quot;</span>),
    ]
)`,wrap:!1}}),Rs=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIlMjAlM0QlMjBwcmVfdG9rZW5pemVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.pre_tokenizer = pre_tokenizers.Metaspace()",wrap:!1}}),Xs=new T({props:{code:"dG9rZW5pemVyLnByZV90b2tlbml6ZXIucHJlX3Rva2VuaXplX3N0ciglMjJMZXQncyUyMHRlc3QlMjB0aGUlMjBwcmUtdG9rZW5pemVyISUyMik=",highlighted:'tokenizer.pre_tokenizer.pre_tokenize_str(<span class="hljs-string">&quot;Let&#x27;s test the pre-tokenizer!&quot;</span>)',wrap:!1}}),As=new T({props:{code:"JTVCKCUyMiVFMiU5NiU4MUxldCdzJTIyJTJDJTIwKDAlMkMlMjA1KSklMkMlMjAoJyVFMiU5NiU4MXRlc3QnJTJDJTIwKDUlMkMlMjAxMCkpJTJDJTIwKCclRTIlOTYlODF0aGUnJTJDJTIwKDEwJTJDJTIwMTQpKSUyQyUyMCgnJUUyJTk2JTgxcHJlLXRva2VuaXplciEnJTJDJTIwKDE0JTJDJTIwMjkpKSU1RA==",highlighted:'[(<span class="hljs-string">&quot;▁Let&#x27;s&quot;</span>, (<span class="hljs-number">0</span>, <span class="hljs-number">5</span>)), (<span class="hljs-string">&#x27;▁test&#x27;</span>, (<span class="hljs-number">5</span>, <span class="hljs-number">10</span>)), (<span class="hljs-string">&#x27;▁the&#x27;</span>, (<span class="hljs-number">10</span>, <span class="hljs-number">14</span>)), (<span class="hljs-string">&#x27;▁pre-tokenizer!&#x27;</span>, (<span class="hljs-number">14</span>, <span class="hljs-number">29</span>))]',wrap:!1}}),Ls=new T({props:{code:"c3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUIlMjIlM0NjbHMlM0UlMjIlMkMlMjAlMjIlM0NzZXAlM0UlMjIlMkMlMjAlMjIlM0N1bmslM0UlMjIlMkMlMjAlMjIlM0NwYWQlM0UlMjIlMkMlMjAlMjIlM0NtYXNrJTNFJTIyJTJDJTIwJTIyJTNDcyUzRSUyMiUyQyUyMCUyMiUzQyUyRnMlM0UlMjIlNUQlMEF0cmFpbmVyJTIwJTNEJTIwdHJhaW5lcnMuVW5pZ3JhbVRyYWluZXIoJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDI1MDAwJTJDJTIwc3BlY2lhbF90b2tlbnMlM0RzcGVjaWFsX3Rva2VucyUyQyUyMHVua190b2tlbiUzRCUyMiUzQ3VuayUzRSUyMiUwQSklMEF0b2tlbml6ZXIudHJhaW5fZnJvbV9pdGVyYXRvcihnZXRfdHJhaW5pbmdfY29ycHVzKCklMkMlMjB0cmFpbmVyJTNEdHJhaW5lcik=",highlighted:`special_tokens = [<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;s&gt;&quot;</span>, <span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>]
trainer = trainers.UnigramTrainer(
    vocab_size=<span class="hljs-number">25000</span>, special_tokens=special_tokens, unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>
)
tokenizer.train_from_iterator(get_training_corpus(), trainer=trainer)`,wrap:!1}}),Ds=new T({props:{code:"dG9rZW5pemVyLm1vZGVsJTIwJTNEJTIwbW9kZWxzLlVuaWdyYW0oKSUwQXRva2VuaXplci50cmFpbiglNUIlMjJ3aWtpdGV4dC0yLnR4dCUyMiU1RCUyQyUyMHRyYWluZXIlM0R0cmFpbmVyKQ==",highlighted:`tokenizer.model = models.Unigram()
tokenizer.train([<span class="hljs-string">&quot;wikitext-2.txt&quot;</span>], trainer=trainer)`,wrap:!1}}),Ss=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2Vucyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer.&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)`,wrap:!1}}),Ps=new T({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTVE",highlighted:'[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),Ys=new T({props:{code:"Y2xzX3Rva2VuX2lkJTIwJTNEJTIwdG9rZW5pemVyLnRva2VuX3RvX2lkKCUyMiUzQ2NscyUzRSUyMiklMEFzZXBfdG9rZW5faWQlMjAlM0QlMjB0b2tlbml6ZXIudG9rZW5fdG9faWQoJTIyJTNDc2VwJTNFJTIyKSUwQXByaW50KGNsc190b2tlbl9pZCUyQyUyMHNlcF90b2tlbl9pZCk=",highlighted:`cls_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>)
sep_token_id = tokenizer.token_to_id(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>)
<span class="hljs-built_in">print</span>(cls_token_id, sep_token_id)`,wrap:!1}}),Ks=new T({props:{code:"MCUyMDE=",highlighted:'<span class="hljs-number">0</span> <span class="hljs-number">1</span>',wrap:!1}}),et=new T({props:{code:"dG9rZW5pemVyLnBvc3RfcHJvY2Vzc29yJTIwJTNEJTIwcHJvY2Vzc29ycy5UZW1wbGF0ZVByb2Nlc3NpbmcoJTBBJTIwJTIwJTIwJTIwc2luZ2xlJTNEJTIyJTI0QSUzQTAlMjAlM0NzZXAlM0UlM0EwJTIwJTNDY2xzJTNFJTNBMiUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhaXIlM0QlMjIlMjRBJTNBMCUyMCUzQ3NlcCUzRSUzQTAlMjAlMjRCJTNBMSUyMCUzQ3NlcCUzRSUzQTElMjAlM0NjbHMlM0UlM0EyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3BlY2lhbF90b2tlbnMlM0QlNUIoJTIyJTNDc2VwJTNFJTIyJTJDJTIwc2VwX3Rva2VuX2lkKSUyQyUyMCglMjIlM0NjbHMlM0UlMjIlMkMlMjBjbHNfdG9rZW5faWQpJTVEJTJDJTBBKQ==",highlighted:`tokenizer.post_processor = processors.TemplateProcessing(
    single=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 &lt;cls&gt;:2&quot;</span>,
    pair=<span class="hljs-string">&quot;$A:0 &lt;sep&gt;:0 $B:1 &lt;sep&gt;:1 &lt;cls&gt;:2&quot;</span>,
    special_tokens=[(<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>, sep_token_id), (<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>, cls_token_id)],
)`,wrap:!1}}),tt=new T({props:{code:"ZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKCUyMkxldCdzJTIwdGVzdCUyMHRoaXMlMjB0b2tlbml6ZXIuLi4lMjIlMkMlMjAlMjJvbiUyMGElMjBwYWlyJTIwb2YlMjBzZW50ZW5jZXMhJTIyKSUwQXByaW50KGVuY29kaW5nLnRva2VucyklMEFwcmludChlbmNvZGluZy50eXBlX2lkcyk=",highlighted:`encoding = tokenizer.encode(<span class="hljs-string">&quot;Let&#x27;s test this tokenizer...&quot;</span>, <span class="hljs-string">&quot;on a pair of sentences!&quot;</span>)
<span class="hljs-built_in">print</span>(encoding.tokens)
<span class="hljs-built_in">print</span>(encoding.type_ids)`,wrap:!1}}),lt=new T({props:{code:"JTVCJyVFMiU5NiU4MUxldCclMkMlMjAlMjInJTIyJTJDJTIwJ3MnJTJDJTIwJyVFMiU5NiU4MXRlc3QnJTJDJTIwJyVFMiU5NiU4MXRoaXMnJTJDJTIwJyVFMiU5NiU4MXRvJyUyQyUyMCdrZW4nJTJDJTIwJ2l6ZXInJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJy4nJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdvbiclMkMlMjAnJUUyJTk2JTgxJyUyQyUyMCdhJyUyQyUyMCclRTIlOTYlODFwYWlyJyUyQyUyMCUwQSUyMCUyMCclRTIlOTYlODFvZiclMkMlMjAnJUUyJTk2JTgxc2VudGVuY2UnJTJDJTIwJ3MnJTJDJTIwJyEnJTJDJTIwJyUzQ3NlcCUzRSclMkMlMjAnJTNDY2xzJTNFJyU1RCUwQSU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDAlMkMlMjAwJTJDJTIwMCUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAxJTJDJTIwMSUyQyUyMDElMkMlMjAyJTVE",highlighted:`[<span class="hljs-string">&#x27;▁Let&#x27;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;▁test&#x27;</span>, <span class="hljs-string">&#x27;▁this&#x27;</span>, <span class="hljs-string">&#x27;▁to&#x27;</span>, <span class="hljs-string">&#x27;ken&#x27;</span>, <span class="hljs-string">&#x27;izer&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;on&#x27;</span>, <span class="hljs-string">&#x27;▁&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;▁pair&#x27;</span>, 
  <span class="hljs-string">&#x27;▁of&#x27;</span>, <span class="hljs-string">&#x27;▁sentence&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;!&#x27;</span>, <span class="hljs-string">&#x27;&lt;sep&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;cls&gt;&#x27;</span>]
[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),pt=new T({props:{code:"dG9rZW5pemVyLmRlY29kZXIlMjAlM0QlMjBkZWNvZGVycy5NZXRhc3BhY2UoKQ==",highlighted:"tokenizer.decoder = decoders.Metaspace()",wrap:!1}}),it=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRUb2tlbml6ZXJGYXN0JTBBJTBBd3JhcHBlZF90b2tlbml6ZXIlMjAlM0QlMjBQcmVUcmFpbmVkVG9rZW5pemVyRmFzdCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZXJfb2JqZWN0JTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwYm9zX3Rva2VuJTNEJTIyJTNDcyUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMGVvc190b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjB1bmtfdG9rZW4lM0QlMjIlM0N1bmslM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBwYWRfdG9rZW4lM0QlMjIlM0NwYWQlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBjbHNfdG9rZW4lM0QlMjIlM0NjbHMlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXBfdG9rZW4lM0QlMjIlM0NzZXAlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjBtYXNrX3Rva2VuJTNEJTIyJTNDbWFzayUzRSUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedTokenizerFast

wrapped_tokenizer = PreTrainedTokenizerFast(
    tokenizer_object=tokenizer,
    bos_token=<span class="hljs-string">&quot;&lt;s&gt;&quot;</span>,
    eos_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>,
    unk_token=<span class="hljs-string">&quot;&lt;unk&gt;&quot;</span>,
    pad_token=<span class="hljs-string">&quot;&lt;pad&gt;&quot;</span>,
    cls_token=<span class="hljs-string">&quot;&lt;cls&gt;&quot;</span>,
    sep_token=<span class="hljs-string">&quot;&lt;sep&gt;&quot;</span>,
    mask_token=<span class="hljs-string">&quot;&lt;mask&gt;&quot;</span>,
    padding_side=<span class="hljs-string">&quot;left&quot;</span>,
)`,wrap:!1}}),Mt=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyRmFzdCUwQSUwQXdyYXBwZWRfdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXJGYXN0KHRva2VuaXplcl9vYmplY3QlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizerFast

wrapped_tokenizer = XLNetTokenizerFast(tokenizer_object=tokenizer)`,wrap:!1}}),ct=new La({props:{source:"https://github.com/huggingface/course/blob/main/chapters/zh-CN/chapter6/8.mdx"}}),{c(){j=a("meta"),w=n(),d=a("p"),u=n(),M(f.$$.fragment),k=n(),M(U.$$.fragment),Tt=n(),g=a("p"),g.textContent=rp,jt=n(),x=a("ul"),x.innerHTML=Mp,kt=n(),h=a("p"),h.textContent=op,ut=n(),$=a("div"),$.innerHTML=cp,Ut=n(),z=a("p"),z.innerHTML=yp,dt=n(),M(C.$$.fragment),ft=n(),I=a("p"),I.innerHTML=Jp,$t=n(),Z=a("ul"),Z.innerHTML=mp,bt=n(),V=a("p"),V.innerHTML=Tp,wt=n(),M(v.$$.fragment),gt=n(),_=a("p"),_.innerHTML=jp,xt=n(),M(B.$$.fragment),ht=n(),Q=a("p"),Q.innerHTML=kp,zt=n(),W=a("p"),W.textContent=up,Ct=n(),M(R.$$.fragment),It=n(),N=a("p"),N.textContent=Up,Zt=n(),M(X.$$.fragment),Vt=n(),A=a("p"),A.innerHTML=dp,vt=n(),G=a("p"),G.innerHTML=fp,_t=n(),M(L.$$.fragment),Bt=n(),q=a("p"),q.innerHTML=$p,Qt=n(),H=a("p"),H.innerHTML=bp,Wt=n(),M(D.$$.fragment),Rt=n(),E=a("p"),E.innerHTML=wp,Nt=n(),M(S.$$.fragment),Xt=n(),P=a("p"),P.innerHTML=gp,At=n(),F=a("p"),F.innerHTML=xp,Gt=n(),M(Y.$$.fragment),Lt=n(),M(K.$$.fragment),qt=n(),M(b.$$.fragment),Ht=n(),O=a("p"),O.innerHTML=hp,Dt=n(),M(ee.$$.fragment),Et=n(),se=a("p"),se.textContent=zp,St=n(),M(te.$$.fragment),Pt=n(),le=a("p"),le.innerHTML=Cp,Ft=n(),M(ne.$$.fragment),Yt=n(),M(pe.$$.fragment),Kt=n(),ae=a("p"),ae.innerHTML=Ip,Ot=n(),M(ie.$$.fragment),el=n(),M(re.$$.fragment),sl=n(),Me=a("p"),Me.innerHTML=Zp,tl=n(),M(oe.$$.fragment),ll=n(),M(ce.$$.fragment),nl=n(),ye=a("p"),ye.innerHTML=Vp,pl=n(),M(Je.$$.fragment),al=n(),me=a("p"),me.innerHTML=vp,il=n(),Te=a("p"),Te.textContent=_p,rl=n(),M(je.$$.fragment),Ml=n(),ke=a("p"),ke.innerHTML=Bp,ol=n(),M(ue.$$.fragment),cl=n(),Ue=a("p"),Ue.innerHTML=Qp,yl=n(),M(de.$$.fragment),Jl=n(),M(fe.$$.fragment),ml=n(),$e=a("p"),$e.innerHTML=Wp,Tl=n(),be=a("p"),be.innerHTML=Rp,jl=n(),M(we.$$.fragment),kl=n(),M(ge.$$.fragment),ul=n(),xe=a("p"),xe.innerHTML=Np,Ul=n(),he=a("p"),he.textContent=Xp,dl=n(),M(ze.$$.fragment),fl=n(),Ce=a("p"),Ce.textContent=Ap,$l=n(),Ie=a("p"),Ie.textContent=Gp,bl=n(),M(Ze.$$.fragment),wl=n(),M(Ve.$$.fragment),gl=n(),ve=a("p"),ve.textContent=Lp,xl=n(),M(_e.$$.fragment),hl=n(),M(Be.$$.fragment),zl=n(),Qe=a("p"),Qe.textContent=qp,Cl=n(),M(We.$$.fragment),Il=n(),Re=a("p"),Re.innerHTML=Hp,Zl=n(),M(Ne.$$.fragment),Vl=n(),M(Xe.$$.fragment),vl=n(),Ae=a("p"),Ae.textContent=Dp,_l=n(),M(Ge.$$.fragment),Bl=n(),Le=a("p"),Le.innerHTML=Ep,Ql=n(),M(qe.$$.fragment),Wl=n(),He=a("p"),He.innerHTML=Sp,Rl=n(),De=a("p"),De.innerHTML=Pp,Nl=n(),M(Ee.$$.fragment),Xl=n(),Se=a("p"),Se.innerHTML=Fp,Al=n(),M(Pe.$$.fragment),Gl=n(),Fe=a("p"),Fe.innerHTML=Yp,Ll=n(),Ye=a("p"),Ye.textContent=Kp,ql=n(),M(Ke.$$.fragment),Hl=n(),Oe=a("p"),Oe.innerHTML=Op,Dl=n(),M(es.$$.fragment),El=n(),ss=a("p"),ss.innerHTML=ea,Sl=n(),ts=a("p"),ts.innerHTML=sa,Pl=n(),M(ls.$$.fragment),Fl=n(),ns=a("p"),ns.innerHTML=ta,Yl=n(),M(ps.$$.fragment),Kl=n(),M(as.$$.fragment),Ol=n(),is=a("p"),is.textContent=la,en=n(),M(rs.$$.fragment),sn=n(),Ms=a("p"),Ms.innerHTML=na,tn=n(),os=a("p"),os.textContent=pa,ln=n(),M(cs.$$.fragment),nn=n(),ys=a("p"),ys.textContent=aa,pn=n(),M(Js.$$.fragment),an=n(),M(ms.$$.fragment),rn=n(),Ts=a("p"),Ts.textContent=ia,Mn=n(),M(js.$$.fragment),on=n(),ks=a("p"),ks.innerHTML=ra,cn=n(),M(us.$$.fragment),yn=n(),M(Us.$$.fragment),Jn=n(),ds=a("p"),ds.textContent=Ma,mn=n(),M(fs.$$.fragment),Tn=n(),$s=a("p"),$s.textContent=oa,jn=n(),M(bs.$$.fragment),kn=n(),M(ws.$$.fragment),un=n(),gs=a("p"),gs.innerHTML=ca,Un=n(),M(xs.$$.fragment),dn=n(),hs=a("p"),hs.textContent=ya,fn=n(),M(zs.$$.fragment),$n=n(),Cs=a("p"),Cs.textContent=Ja,bn=n(),M(Is.$$.fragment),wn=n(),Zs=a("p"),Zs.innerHTML=ma,gn=n(),M(Vs.$$.fragment),xn=n(),vs=a("p"),vs.textContent=Ta,hn=n(),_s=a("p"),_s.textContent=ja,zn=n(),M(Bs.$$.fragment),Cn=n(),Qs=a("p"),Qs.innerHTML=ka,In=n(),Ws=a("p"),Ws.innerHTML=ua,Zn=n(),M(Rs.$$.fragment),Vn=n(),Ns=a("p"),Ns.textContent=Ua,vn=n(),M(Xs.$$.fragment),_n=n(),M(As.$$.fragment),Bn=n(),Gs=a("p"),Gs.textContent=da,Qn=n(),M(Ls.$$.fragment),Wn=n(),qs=a("p"),qs.innerHTML=fa,Rn=n(),Hs=a("p"),Hs.textContent=$a,Nn=n(),M(Ds.$$.fragment),Xn=n(),Es=a("p"),Es.textContent=ba,An=n(),M(Ss.$$.fragment),Gn=n(),M(Ps.$$.fragment),Ln=n(),Fs=a("p"),Fs.innerHTML=wa,qn=n(),M(Ys.$$.fragment),Hn=n(),M(Ks.$$.fragment),Dn=n(),Os=a("p"),Os.textContent=ga,En=n(),M(et.$$.fragment),Sn=n(),st=a("p"),st.textContent=xa,Pn=n(),M(tt.$$.fragment),Fn=n(),M(lt.$$.fragment),Yn=n(),nt=a("p"),nt.innerHTML=ha,Kn=n(),M(pt.$$.fragment),On=n(),at=a("p"),at.innerHTML=za,ep=n(),M(it.$$.fragment),sp=n(),rt=a("p"),rt.textContent=Ca,tp=n(),M(Mt.$$.fragment),lp=n(),ot=a("p"),ot.textContent=Ia,np=n(),M(ct.$$.fragment),pp=n(),yt=a("p"),this.h()},l(e){const s=Ra("svelte-u9bgzb",document.head);j=i(s,"META",{name:!0,content:!0}),s.forEach(t),w=p(e),d=i(e,"P",{}),Va(d).forEach(t),u=p(e),o(f.$$.fragment,e),k=p(e),o(U.$$.fragment,e),Tt=p(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1l229f0"&&(g.textContent=rp),jt=p(e),x=i(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1afkc51"&&(x.innerHTML=Mp),kt=p(e),h=i(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1lp6zkp"&&(h.textContent=op),ut=p(e),$=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r($)!=="svelte-oxfng3"&&($.innerHTML=cp),Ut=p(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-3wijst"&&(z.innerHTML=yp),dt=p(e),o(C.$$.fragment,e),ft=p(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-14xicb7"&&(I.innerHTML=Jp),$t=p(e),Z=i(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-f1jolx"&&(Z.innerHTML=mp),bt=p(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-lm4vlq"&&(V.innerHTML=Tp),wt=p(e),o(v.$$.fragment,e),gt=p(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-h304cz"&&(_.innerHTML=jp),xt=p(e),o(B.$$.fragment,e),ht=p(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-k47fs5"&&(Q.innerHTML=kp),zt=p(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-r885a"&&(W.textContent=up),Ct=p(e),o(R.$$.fragment,e),It=p(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1h3dg4b"&&(N.textContent=Up),Zt=p(e),o(X.$$.fragment,e),Vt=p(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-shwjxs"&&(A.innerHTML=dp),vt=p(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-3wlynn"&&(G.innerHTML=fp),_t=p(e),o(L.$$.fragment,e),Bt=p(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1fwm2oe"&&(q.innerHTML=$p),Qt=p(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1t6ckvm"&&(H.innerHTML=bp),Wt=p(e),o(D.$$.fragment,e),Rt=p(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1qckmck"&&(E.innerHTML=wp),Nt=p(e),o(S.$$.fragment,e),Xt=p(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1kameru"&&(P.innerHTML=gp),At=p(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-bar1jo"&&(F.innerHTML=xp),Gt=p(e),o(Y.$$.fragment,e),Lt=p(e),o(K.$$.fragment,e),qt=p(e),o(b.$$.fragment,e),Ht=p(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1v7hck5"&&(O.innerHTML=hp),Dt=p(e),o(ee.$$.fragment,e),Et=p(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-vuawww"&&(se.textContent=zp),St=p(e),o(te.$$.fragment,e),Pt=p(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1tk5vrx"&&(le.innerHTML=Cp),Ft=p(e),o(ne.$$.fragment,e),Yt=p(e),o(pe.$$.fragment,e),Kt=p(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-vusm0g"&&(ae.innerHTML=Ip),Ot=p(e),o(ie.$$.fragment,e),el=p(e),o(re.$$.fragment,e),sl=p(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1gr3a1c"&&(Me.innerHTML=Zp),tl=p(e),o(oe.$$.fragment,e),ll=p(e),o(ce.$$.fragment,e),nl=p(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1j2tkt5"&&(ye.innerHTML=Vp),pl=p(e),o(Je.$$.fragment,e),al=p(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-sr9wyd"&&(me.innerHTML=vp),il=p(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-11kfccl"&&(Te.textContent=_p),rl=p(e),o(je.$$.fragment,e),Ml=p(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1idb5q1"&&(ke.innerHTML=Bp),ol=p(e),o(ue.$$.fragment,e),cl=p(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-gs4pzl"&&(Ue.innerHTML=Qp),yl=p(e),o(de.$$.fragment,e),Jl=p(e),o(fe.$$.fragment,e),ml=p(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1dxwx8l"&&($e.innerHTML=Wp),Tl=p(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-d04344"&&(be.innerHTML=Rp),jl=p(e),o(we.$$.fragment,e),kl=p(e),o(ge.$$.fragment,e),ul=p(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-w8pwca"&&(xe.innerHTML=Np),Ul=p(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-b5qu8g"&&(he.textContent=Xp),dl=p(e),o(ze.$$.fragment,e),fl=p(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-92l6jr"&&(Ce.textContent=Ap),$l=p(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-lguo0j"&&(Ie.textContent=Gp),bl=p(e),o(Ze.$$.fragment,e),wl=p(e),o(Ve.$$.fragment,e),gl=p(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-6cqgdg"&&(ve.textContent=Lp),xl=p(e),o(_e.$$.fragment,e),hl=p(e),o(Be.$$.fragment,e),zl=p(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-5s8q42"&&(Qe.textContent=qp),Cl=p(e),o(We.$$.fragment,e),Il=p(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-15gpweu"&&(Re.innerHTML=Hp),Zl=p(e),o(Ne.$$.fragment,e),Vl=p(e),o(Xe.$$.fragment,e),vl=p(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-18ulh5y"&&(Ae.textContent=Dp),_l=p(e),o(Ge.$$.fragment,e),Bl=p(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-3ftdzw"&&(Le.innerHTML=Ep),Ql=p(e),o(qe.$$.fragment,e),Wl=p(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1xiknfs"&&(He.innerHTML=Sp),Rl=p(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1wz2yfc"&&(De.innerHTML=Pp),Nl=p(e),o(Ee.$$.fragment,e),Xl=p(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1vrtr3f"&&(Se.innerHTML=Fp),Al=p(e),o(Pe.$$.fragment,e),Gl=p(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-iygluh"&&(Fe.innerHTML=Yp),Ll=p(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-1nve07z"&&(Ye.textContent=Kp),ql=p(e),o(Ke.$$.fragment,e),Hl=p(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-18jz4b6"&&(Oe.innerHTML=Op),Dl=p(e),o(es.$$.fragment,e),El=p(e),ss=i(e,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-1qs6c1r"&&(ss.innerHTML=ea),Sl=p(e),ts=i(e,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-1t5a1tr"&&(ts.innerHTML=sa),Pl=p(e),o(ls.$$.fragment,e),Fl=p(e),ns=i(e,"P",{"data-svelte-h":!0}),r(ns)!=="svelte-9b356c"&&(ns.innerHTML=ta),Yl=p(e),o(ps.$$.fragment,e),Kl=p(e),o(as.$$.fragment,e),Ol=p(e),is=i(e,"P",{"data-svelte-h":!0}),r(is)!=="svelte-1ibccev"&&(is.textContent=la),en=p(e),o(rs.$$.fragment,e),sn=p(e),Ms=i(e,"P",{"data-svelte-h":!0}),r(Ms)!=="svelte-1htjvs9"&&(Ms.innerHTML=na),tn=p(e),os=i(e,"P",{"data-svelte-h":!0}),r(os)!=="svelte-9zdx5b"&&(os.textContent=pa),ln=p(e),o(cs.$$.fragment,e),nn=p(e),ys=i(e,"P",{"data-svelte-h":!0}),r(ys)!=="svelte-f9ey0e"&&(ys.textContent=aa),pn=p(e),o(Js.$$.fragment,e),an=p(e),o(ms.$$.fragment,e),rn=p(e),Ts=i(e,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-1dk3fb5"&&(Ts.textContent=ia),Mn=p(e),o(js.$$.fragment,e),on=p(e),ks=i(e,"P",{"data-svelte-h":!0}),r(ks)!=="svelte-lmmp0z"&&(ks.innerHTML=ra),cn=p(e),o(us.$$.fragment,e),yn=p(e),o(Us.$$.fragment,e),Jn=p(e),ds=i(e,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-1bu1bm"&&(ds.textContent=Ma),mn=p(e),o(fs.$$.fragment,e),Tn=p(e),$s=i(e,"P",{"data-svelte-h":!0}),r($s)!=="svelte-u3j12w"&&($s.textContent=oa),jn=p(e),o(bs.$$.fragment,e),kn=p(e),o(ws.$$.fragment,e),un=p(e),gs=i(e,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-1vzdefe"&&(gs.innerHTML=ca),Un=p(e),o(xs.$$.fragment,e),dn=p(e),hs=i(e,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-fzp8ed"&&(hs.textContent=ya),fn=p(e),o(zs.$$.fragment,e),$n=p(e),Cs=i(e,"P",{"data-svelte-h":!0}),r(Cs)!=="svelte-1ydc4ba"&&(Cs.textContent=Ja),bn=p(e),o(Is.$$.fragment,e),wn=p(e),Zs=i(e,"P",{"data-svelte-h":!0}),r(Zs)!=="svelte-6rfid6"&&(Zs.innerHTML=ma),gn=p(e),o(Vs.$$.fragment,e),xn=p(e),vs=i(e,"P",{"data-svelte-h":!0}),r(vs)!=="svelte-1jkt6ld"&&(vs.textContent=Ta),hn=p(e),_s=i(e,"P",{"data-svelte-h":!0}),r(_s)!=="svelte-187158j"&&(_s.textContent=ja),zn=p(e),o(Bs.$$.fragment,e),Cn=p(e),Qs=i(e,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-15dsv2a"&&(Qs.innerHTML=ka),In=p(e),Ws=i(e,"P",{"data-svelte-h":!0}),r(Ws)!=="svelte-1jqpw05"&&(Ws.innerHTML=ua),Zn=p(e),o(Rs.$$.fragment,e),Vn=p(e),Ns=i(e,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-4jou9m"&&(Ns.textContent=Ua),vn=p(e),o(Xs.$$.fragment,e),_n=p(e),o(As.$$.fragment,e),Bn=p(e),Gs=i(e,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-w73zlc"&&(Gs.textContent=da),Qn=p(e),o(Ls.$$.fragment,e),Wn=p(e),qs=i(e,"P",{"data-svelte-h":!0}),r(qs)!=="svelte-17zoz2j"&&(qs.innerHTML=fa),Rn=p(e),Hs=i(e,"P",{"data-svelte-h":!0}),r(Hs)!=="svelte-9zdx5b"&&(Hs.textContent=$a),Nn=p(e),o(Ds.$$.fragment,e),Xn=p(e),Es=i(e,"P",{"data-svelte-h":!0}),r(Es)!=="svelte-18crjnk"&&(Es.textContent=ba),An=p(e),o(Ss.$$.fragment,e),Gn=p(e),o(Ps.$$.fragment,e),Ln=p(e),Fs=i(e,"P",{"data-svelte-h":!0}),r(Fs)!=="svelte-xt4fe9"&&(Fs.innerHTML=wa),qn=p(e),o(Ys.$$.fragment,e),Hn=p(e),o(Ks.$$.fragment,e),Dn=p(e),Os=i(e,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-ose5sl"&&(Os.textContent=ga),En=p(e),o(et.$$.fragment,e),Sn=p(e),st=i(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-4pbeet"&&(st.textContent=xa),Pn=p(e),o(tt.$$.fragment,e),Fn=p(e),o(lt.$$.fragment,e),Yn=p(e),nt=i(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-y80rw8"&&(nt.innerHTML=ha),Kn=p(e),o(pt.$$.fragment,e),On=p(e),at=i(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1arw03s"&&(at.innerHTML=za),ep=p(e),o(it.$$.fragment,e),sp=p(e),rt=i(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-fzp8ed"&&(rt.textContent=Ca),tp=p(e),o(Mt.$$.fragment,e),lp=p(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-chgqxl"&&(ot.textContent=Ia),np=p(e),o(ct.$$.fragment,e),pp=p(e),yt=i(e,"P",{}),Va(yt).forEach(t),this.h()},h(){ip(j,"name","hf:doc:metadata"),ip(j,"content",Da),ip($,"class","flex justify-center")},m(e,s){Na(document.head,j),l(e,w,s),l(e,d,s),l(e,u,s),c(f,e,s),l(e,k,s),c(U,e,s),l(e,Tt,s),l(e,g,s),l(e,jt,s),l(e,x,s),l(e,kt,s),l(e,h,s),l(e,ut,s),l(e,$,s),l(e,Ut,s),l(e,z,s),l(e,dt,s),c(C,e,s),l(e,ft,s),l(e,I,s),l(e,$t,s),l(e,Z,s),l(e,bt,s),l(e,V,s),l(e,wt,s),c(v,e,s),l(e,gt,s),l(e,_,s),l(e,xt,s),c(B,e,s),l(e,ht,s),l(e,Q,s),l(e,zt,s),l(e,W,s),l(e,Ct,s),c(R,e,s),l(e,It,s),l(e,N,s),l(e,Zt,s),c(X,e,s),l(e,Vt,s),l(e,A,s),l(e,vt,s),l(e,G,s),l(e,_t,s),c(L,e,s),l(e,Bt,s),l(e,q,s),l(e,Qt,s),l(e,H,s),l(e,Wt,s),c(D,e,s),l(e,Rt,s),l(e,E,s),l(e,Nt,s),c(S,e,s),l(e,Xt,s),l(e,P,s),l(e,At,s),l(e,F,s),l(e,Gt,s),c(Y,e,s),l(e,Lt,s),c(K,e,s),l(e,qt,s),c(b,e,s),l(e,Ht,s),l(e,O,s),l(e,Dt,s),c(ee,e,s),l(e,Et,s),l(e,se,s),l(e,St,s),c(te,e,s),l(e,Pt,s),l(e,le,s),l(e,Ft,s),c(ne,e,s),l(e,Yt,s),c(pe,e,s),l(e,Kt,s),l(e,ae,s),l(e,Ot,s),c(ie,e,s),l(e,el,s),c(re,e,s),l(e,sl,s),l(e,Me,s),l(e,tl,s),c(oe,e,s),l(e,ll,s),c(ce,e,s),l(e,nl,s),l(e,ye,s),l(e,pl,s),c(Je,e,s),l(e,al,s),l(e,me,s),l(e,il,s),l(e,Te,s),l(e,rl,s),c(je,e,s),l(e,Ml,s),l(e,ke,s),l(e,ol,s),c(ue,e,s),l(e,cl,s),l(e,Ue,s),l(e,yl,s),c(de,e,s),l(e,Jl,s),c(fe,e,s),l(e,ml,s),l(e,$e,s),l(e,Tl,s),l(e,be,s),l(e,jl,s),c(we,e,s),l(e,kl,s),c(ge,e,s),l(e,ul,s),l(e,xe,s),l(e,Ul,s),l(e,he,s),l(e,dl,s),c(ze,e,s),l(e,fl,s),l(e,Ce,s),l(e,$l,s),l(e,Ie,s),l(e,bl,s),c(Ze,e,s),l(e,wl,s),c(Ve,e,s),l(e,gl,s),l(e,ve,s),l(e,xl,s),c(_e,e,s),l(e,hl,s),c(Be,e,s),l(e,zl,s),l(e,Qe,s),l(e,Cl,s),c(We,e,s),l(e,Il,s),l(e,Re,s),l(e,Zl,s),c(Ne,e,s),l(e,Vl,s),c(Xe,e,s),l(e,vl,s),l(e,Ae,s),l(e,_l,s),c(Ge,e,s),l(e,Bl,s),l(e,Le,s),l(e,Ql,s),c(qe,e,s),l(e,Wl,s),l(e,He,s),l(e,Rl,s),l(e,De,s),l(e,Nl,s),c(Ee,e,s),l(e,Xl,s),l(e,Se,s),l(e,Al,s),c(Pe,e,s),l(e,Gl,s),l(e,Fe,s),l(e,Ll,s),l(e,Ye,s),l(e,ql,s),c(Ke,e,s),l(e,Hl,s),l(e,Oe,s),l(e,Dl,s),c(es,e,s),l(e,El,s),l(e,ss,s),l(e,Sl,s),l(e,ts,s),l(e,Pl,s),c(ls,e,s),l(e,Fl,s),l(e,ns,s),l(e,Yl,s),c(ps,e,s),l(e,Kl,s),c(as,e,s),l(e,Ol,s),l(e,is,s),l(e,en,s),c(rs,e,s),l(e,sn,s),l(e,Ms,s),l(e,tn,s),l(e,os,s),l(e,ln,s),c(cs,e,s),l(e,nn,s),l(e,ys,s),l(e,pn,s),c(Js,e,s),l(e,an,s),c(ms,e,s),l(e,rn,s),l(e,Ts,s),l(e,Mn,s),c(js,e,s),l(e,on,s),l(e,ks,s),l(e,cn,s),c(us,e,s),l(e,yn,s),c(Us,e,s),l(e,Jn,s),l(e,ds,s),l(e,mn,s),c(fs,e,s),l(e,Tn,s),l(e,$s,s),l(e,jn,s),c(bs,e,s),l(e,kn,s),c(ws,e,s),l(e,un,s),l(e,gs,s),l(e,Un,s),c(xs,e,s),l(e,dn,s),l(e,hs,s),l(e,fn,s),c(zs,e,s),l(e,$n,s),l(e,Cs,s),l(e,bn,s),c(Is,e,s),l(e,wn,s),l(e,Zs,s),l(e,gn,s),c(Vs,e,s),l(e,xn,s),l(e,vs,s),l(e,hn,s),l(e,_s,s),l(e,zn,s),c(Bs,e,s),l(e,Cn,s),l(e,Qs,s),l(e,In,s),l(e,Ws,s),l(e,Zn,s),c(Rs,e,s),l(e,Vn,s),l(e,Ns,s),l(e,vn,s),c(Xs,e,s),l(e,_n,s),c(As,e,s),l(e,Bn,s),l(e,Gs,s),l(e,Qn,s),c(Ls,e,s),l(e,Wn,s),l(e,qs,s),l(e,Rn,s),l(e,Hs,s),l(e,Nn,s),c(Ds,e,s),l(e,Xn,s),l(e,Es,s),l(e,An,s),c(Ss,e,s),l(e,Gn,s),c(Ps,e,s),l(e,Ln,s),l(e,Fs,s),l(e,qn,s),c(Ys,e,s),l(e,Hn,s),c(Ks,e,s),l(e,Dn,s),l(e,Os,s),l(e,En,s),c(et,e,s),l(e,Sn,s),l(e,st,s),l(e,Pn,s),c(tt,e,s),l(e,Fn,s),c(lt,e,s),l(e,Yn,s),l(e,nt,s),l(e,Kn,s),c(pt,e,s),l(e,On,s),l(e,at,s),l(e,ep,s),c(it,e,s),l(e,sp,s),l(e,rt,s),l(e,tp,s),c(Mt,e,s),l(e,lp,s),l(e,ot,s),l(e,np,s),c(ct,e,s),l(e,pp,s),l(e,yt,s),ap=!0},p(e,[s]){const Za={};s&2&&(Za.$$scope={dirty:s,ctx:e}),b.$set(Za)},i(e){ap||(y(f.$$.fragment,e),y(U.$$.fragment,e),y(C.$$.fragment,e),y(v.$$.fragment,e),y(B.$$.fragment,e),y(R.$$.fragment,e),y(X.$$.fragment,e),y(L.$$.fragment,e),y(D.$$.fragment,e),y(S.$$.fragment,e),y(Y.$$.fragment,e),y(K.$$.fragment,e),y(b.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(ie.$$.fragment,e),y(re.$$.fragment,e),y(oe.$$.fragment,e),y(ce.$$.fragment,e),y(Je.$$.fragment,e),y(je.$$.fragment,e),y(ue.$$.fragment,e),y(de.$$.fragment,e),y(fe.$$.fragment,e),y(we.$$.fragment,e),y(ge.$$.fragment,e),y(ze.$$.fragment,e),y(Ze.$$.fragment,e),y(Ve.$$.fragment,e),y(_e.$$.fragment,e),y(Be.$$.fragment,e),y(We.$$.fragment,e),y(Ne.$$.fragment,e),y(Xe.$$.fragment,e),y(Ge.$$.fragment,e),y(qe.$$.fragment,e),y(Ee.$$.fragment,e),y(Pe.$$.fragment,e),y(Ke.$$.fragment,e),y(es.$$.fragment,e),y(ls.$$.fragment,e),y(ps.$$.fragment,e),y(as.$$.fragment,e),y(rs.$$.fragment,e),y(cs.$$.fragment,e),y(Js.$$.fragment,e),y(ms.$$.fragment,e),y(js.$$.fragment,e),y(us.$$.fragment,e),y(Us.$$.fragment,e),y(fs.$$.fragment,e),y(bs.$$.fragment,e),y(ws.$$.fragment,e),y(xs.$$.fragment,e),y(zs.$$.fragment,e),y(Is.$$.fragment,e),y(Vs.$$.fragment,e),y(Bs.$$.fragment,e),y(Rs.$$.fragment,e),y(Xs.$$.fragment,e),y(As.$$.fragment,e),y(Ls.$$.fragment,e),y(Ds.$$.fragment,e),y(Ss.$$.fragment,e),y(Ps.$$.fragment,e),y(Ys.$$.fragment,e),y(Ks.$$.fragment,e),y(et.$$.fragment,e),y(tt.$$.fragment,e),y(lt.$$.fragment,e),y(pt.$$.fragment,e),y(it.$$.fragment,e),y(Mt.$$.fragment,e),y(ct.$$.fragment,e),ap=!0)},o(e){J(f.$$.fragment,e),J(U.$$.fragment,e),J(C.$$.fragment,e),J(v.$$.fragment,e),J(B.$$.fragment,e),J(R.$$.fragment,e),J(X.$$.fragment,e),J(L.$$.fragment,e),J(D.$$.fragment,e),J(S.$$.fragment,e),J(Y.$$.fragment,e),J(K.$$.fragment,e),J(b.$$.fragment,e),J(ee.$$.fragment,e),J(te.$$.fragment,e),J(ne.$$.fragment,e),J(pe.$$.fragment,e),J(ie.$$.fragment,e),J(re.$$.fragment,e),J(oe.$$.fragment,e),J(ce.$$.fragment,e),J(Je.$$.fragment,e),J(je.$$.fragment,e),J(ue.$$.fragment,e),J(de.$$.fragment,e),J(fe.$$.fragment,e),J(we.$$.fragment,e),J(ge.$$.fragment,e),J(ze.$$.fragment,e),J(Ze.$$.fragment,e),J(Ve.$$.fragment,e),J(_e.$$.fragment,e),J(Be.$$.fragment,e),J(We.$$.fragment,e),J(Ne.$$.fragment,e),J(Xe.$$.fragment,e),J(Ge.$$.fragment,e),J(qe.$$.fragment,e),J(Ee.$$.fragment,e),J(Pe.$$.fragment,e),J(Ke.$$.fragment,e),J(es.$$.fragment,e),J(ls.$$.fragment,e),J(ps.$$.fragment,e),J(as.$$.fragment,e),J(rs.$$.fragment,e),J(cs.$$.fragment,e),J(Js.$$.fragment,e),J(ms.$$.fragment,e),J(js.$$.fragment,e),J(us.$$.fragment,e),J(Us.$$.fragment,e),J(fs.$$.fragment,e),J(bs.$$.fragment,e),J(ws.$$.fragment,e),J(xs.$$.fragment,e),J(zs.$$.fragment,e),J(Is.$$.fragment,e),J(Vs.$$.fragment,e),J(Bs.$$.fragment,e),J(Rs.$$.fragment,e),J(Xs.$$.fragment,e),J(As.$$.fragment,e),J(Ls.$$.fragment,e),J(Ds.$$.fragment,e),J(Ss.$$.fragment,e),J(Ps.$$.fragment,e),J(Ys.$$.fragment,e),J(Ks.$$.fragment,e),J(et.$$.fragment,e),J(tt.$$.fragment,e),J(lt.$$.fragment,e),J(pt.$$.fragment,e),J(it.$$.fragment,e),J(Mt.$$.fragment,e),J(ct.$$.fragment,e),ap=!1},d(e){e&&(t(w),t(d),t(u),t(k),t(Tt),t(g),t(jt),t(x),t(kt),t(h),t(ut),t($),t(Ut),t(z),t(dt),t(ft),t(I),t($t),t(Z),t(bt),t(V),t(wt),t(gt),t(_),t(xt),t(ht),t(Q),t(zt),t(W),t(Ct),t(It),t(N),t(Zt),t(Vt),t(A),t(vt),t(G),t(_t),t(Bt),t(q),t(Qt),t(H),t(Wt),t(Rt),t(E),t(Nt),t(Xt),t(P),t(At),t(F),t(Gt),t(Lt),t(qt),t(Ht),t(O),t(Dt),t(Et),t(se),t(St),t(Pt),t(le),t(Ft),t(Yt),t(Kt),t(ae),t(Ot),t(el),t(sl),t(Me),t(tl),t(ll),t(nl),t(ye),t(pl),t(al),t(me),t(il),t(Te),t(rl),t(Ml),t(ke),t(ol),t(cl),t(Ue),t(yl),t(Jl),t(ml),t($e),t(Tl),t(be),t(jl),t(kl),t(ul),t(xe),t(Ul),t(he),t(dl),t(fl),t(Ce),t($l),t(Ie),t(bl),t(wl),t(gl),t(ve),t(xl),t(hl),t(zl),t(Qe),t(Cl),t(Il),t(Re),t(Zl),t(Vl),t(vl),t(Ae),t(_l),t(Bl),t(Le),t(Ql),t(Wl),t(He),t(Rl),t(De),t(Nl),t(Xl),t(Se),t(Al),t(Gl),t(Fe),t(Ll),t(Ye),t(ql),t(Hl),t(Oe),t(Dl),t(El),t(ss),t(Sl),t(ts),t(Pl),t(Fl),t(ns),t(Yl),t(Kl),t(Ol),t(is),t(en),t(sn),t(Ms),t(tn),t(os),t(ln),t(nn),t(ys),t(pn),t(an),t(rn),t(Ts),t(Mn),t(on),t(ks),t(cn),t(yn),t(Jn),t(ds),t(mn),t(Tn),t($s),t(jn),t(kn),t(un),t(gs),t(Un),t(dn),t(hs),t(fn),t($n),t(Cs),t(bn),t(wn),t(Zs),t(gn),t(xn),t(vs),t(hn),t(_s),t(zn),t(Cn),t(Qs),t(In),t(Ws),t(Zn),t(Vn),t(Ns),t(vn),t(_n),t(Bn),t(Gs),t(Qn),t(Wn),t(qs),t(Rn),t(Hs),t(Nn),t(Xn),t(Es),t(An),t(Gn),t(Ln),t(Fs),t(qn),t(Hn),t(Dn),t(Os),t(En),t(Sn),t(st),t(Pn),t(Fn),t(Yn),t(nt),t(Kn),t(On),t(at),t(ep),t(sp),t(rt),t(tp),t(lp),t(ot),t(np),t(pp),t(yt)),t(j),m(f,e),m(U,e),m(C,e),m(v,e),m(B,e),m(R,e),m(X,e),m(L,e),m(D,e),m(S,e),m(Y,e),m(K,e),m(b,e),m(ee,e),m(te,e),m(ne,e),m(pe,e),m(ie,e),m(re,e),m(oe,e),m(ce,e),m(Je,e),m(je,e),m(ue,e),m(de,e),m(fe,e),m(we,e),m(ge,e),m(ze,e),m(Ze,e),m(Ve,e),m(_e,e),m(Be,e),m(We,e),m(Ne,e),m(Xe,e),m(Ge,e),m(qe,e),m(Ee,e),m(Pe,e),m(Ke,e),m(es,e),m(ls,e),m(ps,e),m(as,e),m(rs,e),m(cs,e),m(Js,e),m(ms,e),m(js,e),m(us,e),m(Us,e),m(fs,e),m(bs,e),m(ws,e),m(xs,e),m(zs,e),m(Is,e),m(Vs,e),m(Bs,e),m(Rs,e),m(Xs,e),m(As,e),m(Ls,e),m(Ds,e),m(Ss,e),m(Ps,e),m(Ys,e),m(Ks,e),m(et,e),m(tt,e),m(lt,e),m(pt,e),m(it,e),m(Mt,e),m(ct,e)}}}const Da='{"title":"模块化构建 tokenizer","local":"模块化构建 tokenizer","sections":[{"title":"获取语​​料库","local":"获取语​​料库","sections":[],"depth":2},{"title":"从头开始构建 WordPiece  tokenizer","local":"从头开始构建 WordPiece  tokenizer","sections":[],"depth":2},{"title":"从头开始构建 BPE  tokenizer","local":"从头开始构建 BPE  tokenizer","sections":[],"depth":2},{"title":"从零开始构建 Unigram  tokenizer","local":"从零开始构建 Unigram  tokenizer","sections":[],"depth":2}],"depth":1}';function Ea(mt){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class si extends Qa{constructor(j){super(),Wa(this,j,Ea,Ha,va,{})}}export{si as component};
