import{s as xl,o as Zl,n as Os}from"../chunks/scheduler.37c15a92.js";import{S as Gl,i as Il,g as p,s as a,r,A as Rl,h as c,f as e,c as n,j as fl,u as M,x as h,k as N,y as Xl,a as l,v as u,d,t as J,w as y}from"../chunks/index.2bf4358c.js";import{T as qs}from"../chunks/Tip.363c041f.js";import{Y as Cl}from"../chunks/Youtube.1e50a667.js";import{C as m}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as kl}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as Ps,E as Nl}from"../chunks/EditOnGithub.8916dc7c.js";function _l(g){let i,T="✏️ <strong>Try it out!</strong> Click on a few of the URLs in the JSON payload above to get a feel for what type of information each GitHub issue is linked to.";return{c(){i=p("p"),i.innerHTML=T},l(o){i=c(o,"P",{"data-svelte-h":!0}),h(i)!=="svelte-wkcoa8"&&(i.innerHTML=T)},m(o,U){l(o,i,U)},p:Os,d(o){o&&e(i)}}}function vl(g){let i,T='⚠️ Do not share a notebook with your <code>GITHUB_TOKEN</code> pasted in it. We recommend you delete the last cell once you have executed it to avoid leaking this information accidentally. Even better, store the token in a <em>.env</em> file and use the <a href="https://github.com/theskumar/python-dotenv" rel="nofollow"><code>python-dotenv</code> library</a> to load it automatically for you as an environment variable.';return{c(){i=p("p"),i.innerHTML=T},l(o){i=c(o,"P",{"data-svelte-h":!0}),h(i)!=="svelte-r6ie4a"&&(i.innerHTML=T)},m(o,U){l(o,i,U)},p:Os,d(o){o&&e(i)}}}function zl(g){let i,T="✏️ <strong>Try it out!</strong> Calculate the average time it takes to close issues in 🤗 Datasets. You may find the <code>Dataset.filter()</code> function useful to filter out the pull requests and open issues, and you can use the <code>Dataset.set_format()</code> function to convert the dataset to a <code>DataFrame</code> so you can easily manipulate the <code>created_at</code> and <code>closed_at</code> timestamps. For bonus points, calculate the average time it takes to close pull requests.";return{c(){i=p("p"),i.innerHTML=T},l(o){i=c(o,"P",{"data-svelte-h":!0}),h(i)!=="svelte-1atzslz"&&(i.innerHTML=T)},m(o,U){l(o,i,U)},p:Os,d(o){o&&e(i)}}}function Vl(g){let i,T='💡 You can also upload a dataset to the Hugging Face Hub directly from the terminal by using <code>huggingface-cli</code> and a bit of Git magic. See the <a href="https://huggingface.co/docs/datasets/share#share-a-dataset-using-the-cli" rel="nofollow">🤗 Datasets guide</a> for details on how to do this.';return{c(){i=p("p"),i.innerHTML=T},l(o){i=c(o,"P",{"data-svelte-h":!0}),h(i)!=="svelte-bmkg41"&&(i.innerHTML=T)},m(o,U){l(o,i,U)},p:Os,d(o){o&&e(i)}}}function Bl(g){let i,T='✏️ <strong>Try it out!</strong> Use the <code>dataset-tagging</code> application and <a href="https://github.com/huggingface/datasets/blob/master/templates/README_guide.md" rel="nofollow">🤗 Datasets guide</a> to complete the <em>README.md</em> file for your GitHub issues dataset.';return{c(){i=p("p"),i.innerHTML=T},l(o){i=c(o,"P",{"data-svelte-h":!0}),h(i)!=="svelte-jjgp5z"&&(i.innerHTML=T)},m(o,U){l(o,i,U)},p:Os,d(o){o&&e(i)}}}function $l(g){let i,T="✏️ <strong>Try it out!</strong> Go through the steps we took in this section to create a dataset of GitHub issues for your favorite open source library (pick something other than 🤗 Datasets, of course!). For bonus points, fine-tune a multilabel classifier to predict the tags present in the <code>labels</code> field.";return{c(){i=p("p"),i.innerHTML=T},l(o){i=c(o,"P",{"data-svelte-h":!0}),h(i)!=="svelte-nubqxw"&&(i.innerHTML=T)},m(o,U){l(o,i,U)},p:Os,d(o){o&&e(i)}}}function Wl(g){let i,T,o,U,_,st,v,tt,z,Re='Sometimes the dataset that you need to build an NLP application doesn’t exist, so you’ll need to create it yourself. In this section we’ll show you how to create a corpus of <a href="https://github.com/features/issues/" rel="nofollow">GitHub issues</a>, which are commonly used to track bugs or features in GitHub repositories. This corpus could be used for various purposes, including:',et,V,Xe="<li>Exploring how long it takes to close open issues or pull requests</li> <li>Training a <em>multilabel classifier</em> that can tag issues with metadata based on the issue’s description (e.g., “bug,” “enhancement,” or “question”)</li> <li>Creating a semantic search engine to find which issues match a user’s query</li>",lt,B,Ce="Here we’ll focus on creating the corpus, and in the next section we’ll tackle the semantic search application. To keep things meta, we’ll use the GitHub issues associated with a popular open source project: 🤗 Datasets! Let’s take a look at how to get the data and explore the information contained in these issues.",at,$,nt,W,ke='You can find all the issues in 🤗 Datasets by navigating to the repository’s <a href="https://github.com/huggingface/datasets/issues" rel="nofollow">Issues tab</a>. As shown in the following screenshot, at the time of writing there were 331 open issues and 668 closed ones.',it,j,Ne='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter5/datasets-issues.png" alt="The GitHub issues associated with 🤗 Datasets." width="80%"/>',pt,H,_e="If you click on one of these issues you’ll find it contains a title, a description, and a set of labels that characterize the issue. An example is shown in the screenshot below.",ct,w,ve='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter5/datasets-issues-single.png" alt="A typical GitHub issue in the 🤗 Datasets repository." width="80%"/>',ht,F,ze='To download all the repository’s issues, we’ll use the <a href="https://docs.github.com/en/rest" rel="nofollow">GitHub REST API</a> to poll the <a href="https://docs.github.com/en/rest/reference/issues#list-repository-issues" rel="nofollow"><code>Issues</code> endpoint</a>. This endpoint returns a list of JSON objects, with each object containing a large number of fields that include the title and description as well as metadata about the status of the issue and so on.',ot,Q,Ve="A convenient way to download the issues is via the <code>requests</code> library, which is the standard way for making HTTP requests in Python. You can install the library by running:",rt,Y,Mt,E,Be="Once the library is installed, you can make GET requests to the <code>Issues</code> endpoint by invoking the <code>requests.get()</code> function. For example, you can run the following command to retrieve the first issue on the first page:",ut,A,dt,S,$e="The <code>response</code> object contains a lot of useful information about the request, including the HTTP status code:",Jt,L,yt,D,mt,q,We='where a <code>200</code> status means the request was successful (you can find a list of possible HTTP status codes <a href="https://en.wikipedia.org/wiki/List_of_HTTP_status_codes" rel="nofollow">here</a>). What we are really interested in, though, is the <em>payload</em>, which can be accessed in various formats like bytes, strings, or JSON. Since we know our issues are in JSON format, let’s inspect the payload as follows:',Tt,P,Ut,O,gt,K,He="Whoa, that’s a lot of information! We can see useful fields like <code>title</code>, <code>body</code>, and <code>number</code> that describe the issue, as well as information about the GitHub user who opened the issue.",jt,b,wt,ss,Fe='As described in the GitHub <a href="https://docs.github.com/en/rest/overview/resources-in-the-rest-api#rate-limiting" rel="nofollow">documentation</a>, unauthenticated requests are limited to 60 requests per hour. Although you can increase the <code>per_page</code> query parameter to reduce the number of requests you make, you will still hit the rate limit on any repository that has more than a few thousand issues. So instead, you should follow GitHub’s <a href="https://docs.github.com/en/github/authenticating-to-github/creating-a-personal-access-token" rel="nofollow">instructions</a> on creating a <em>personal access token</em> so that you can boost the rate limit to 5,000 requests per hour. Once you have your token, you can include it as part of the request header:',bt,ts,ft,f,xt,es,Qe="Now that we have our access token, let’s create a function that can download all the issues from a GitHub repository:",Zt,ls,Gt,as,Ye="Now when we call <code>fetch_issues()</code> it will download all the issues in batches to avoid exceeding GitHub’s limit on the number of requests per hour; the result will be stored in a <em>repository_name-issues.jsonl</em> file, where each line is a JSON object the represents an issue. Let’s use this function to grab all the issues from 🤗 Datasets:",It,ns,Rt,is,Ee='Once the issues are downloaded we can load them locally using our newfound skills from <a href="/course/chapter5/2">section 2</a>:',Xt,ps,Ct,cs,kt,hs,Ae='Great, we’ve created our first dataset from scratch! But why are there several thousand issues when the <a href="https://github.com/huggingface/datasets/issues" rel="nofollow">Issues tab</a> of the 🤗 Datasets repository only shows around 1,000 issues in total 🤔? As described in the GitHub <a href="https://docs.github.com/en/rest/reference/issues#list-issues-assigned-to-the-authenticated-user" rel="nofollow">documentation</a>, that’s because we’ve downloaded all the pull requests as well:',Nt,os,Se="<p>GitHub’s REST API v3 considers every pull request an issue, but not every issue is a pull request. For this reason, “Issues” endpoints may return both issues and pull requests in the response. You can identify pull requests by the <code>pull_request</code> key. Be aware that the <code>id</code> of a pull request returned from “Issues” endpoints will be an issue id.</p>",_t,rs,Le="Since the contents of issues and pull requests are quite different, let’s do some minor preprocessing to enable us to distinguish between them.",vt,Ms,zt,us,De='The above snippet from GitHub’s documentation tells us that the <code>pull_request</code> column can be used to differentiate between issues and pull requests. Let’s look at a random sample to see what the difference is. As we did in <a href="/course/chapter5/3">section 3</a>, we’ll chain <code>Dataset.shuffle()</code> and <code>Dataset.select()</code> to create a random sample and then zip the <code>html_url</code> and <code>pull_request</code> columns so we can compare the various URLs:',Vt,ds,Bt,Js,$t,ys,qe="Here we can see that each pull request is associated with various URLs, while ordinary issues have a <code>None</code> entry. We can use this distinction to create a new <code>is_pull_request</code> column that checks whether the <code>pull_request</code> field is <code>None</code> or not:",Wt,ms,Ht,x,Ft,Ts,Pe="Although we could proceed to further clean up the dataset by dropping or renaming some columns, it is generally a good practice to keep the dataset as “raw” as possible at this stage so that it can be easily used in multiple applications.",Qt,Us,Oe="Before we push our dataset to the Hugging Face Hub, let’s deal with one thing that’s missing from it: the comments associated with each issue and pull request. We’ll add them next with — you guessed it — the GitHub REST API!",Yt,gs,Et,js,Ke="As shown in the following screenshot, the comments associated with an issue or pull request provide a rich source of information, especially if we’re interested in building a search engine to answer user queries about the library.",At,Z,sl='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter5/datasets-issues-comment.png" alt="Comments associated with an issue about 🤗 Datasets." width="80%"/>',St,ws,tl='The GitHub REST API provides a <a href="https://docs.github.com/en/rest/reference/issues#list-issue-comments" rel="nofollow"><code>Comments</code> endpoint</a> that returns all the comments associated with an issue number. Let’s test the endpoint to see what it returns:',Lt,bs,Dt,fs,qt,xs,el="We can see that the comment is stored in the <code>body</code> field, so let’s write a simple function that returns all the comments associated with an issue by picking out the <code>body</code> contents for each element in <code>response.json()</code>:",Pt,Zs,Ot,Gs,Kt,Is,ll="This looks good, so let’s use <code>Dataset.map()</code> to add a new <code>comments</code> column to each issue in our dataset:",se,Rs,te,Xs,al="The final step is to push our dataset to the Hub. Let’s take a look at how we can do that.",ee,Cs,le,ks,ae,Ns,nl="Now that we have our augmented dataset, it’s time to push it to the Hub so we can share it with the community! Uploading a dataset is very simple: just like models and tokenizers from 🤗 Transformers, we can use a <code>push_to_hub()</code> method to push a dataset. To do that we need an authentication token, which can be obtained by first logging into the Hugging Face Hub with the <code>notebook_login()</code> function:",ne,_s,ie,vs,il="This will create a widget where you can enter your username and password, and an API token will be saved in <em>~/.huggingface/token</em>. If you’re running the code in a terminal, you can log in via the CLI instead:",pe,zs,ce,Vs,pl="Once we’ve done this, we can upload our dataset by running:",he,Bs,oe,$s,cl="From here, anyone can download the dataset by simply providing <code>load_dataset()</code> with the repository ID as the <code>path</code> argument:",re,Ws,Me,Hs,ue,Fs,hl="Cool, we’ve pushed our dataset to the Hub and it’s available for others to use! There’s just one important thing left to do: adding a <em>dataset card</em> that explains how the corpus was created and provides other useful information for the community.",de,G,Je,Qs,ye,Ys,ol="Well-documented datasets are more likely to be useful to others (including your future self!), as they provide the context to enable users to decide whether the dataset is relevant to their task and to evaluate any potential biases in or risks associated with using the dataset.",me,Es,rl="On the Hugging Face Hub, this information is stored in each dataset repository’s <em>README.md</em> file. There are two main steps you should take before creating this file:",Te,As,Ml='<li>Use the <a href="https://huggingface.co/datasets/tagging/" rel="nofollow"><code>datasets-tagging</code> application</a> to create metadata tags in YAML format. These tags are used for a variety of search features on the Hugging Face Hub and ensure your dataset can be easily found by members of the community. Since we have created a custom dataset here, you’ll need to clone the <code>datasets-tagging</code> repository and run the application locally. Here’s what the interface looks like:</li>',Ue,I,ul='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter5/datasets-tagger.png" alt="The &#39;datasets-tagging&#39; interface." width="80%"/>',ge,R,dl='<li>Read the <a href="https://github.com/huggingface/datasets/blob/master/templates/README_guide.md" rel="nofollow">🤗 Datasets guide</a> on creating informative dataset cards and use it as a template.</li>',je,Ss,Jl="You can create the <em>README.md</em> file directly on the Hub, and you can find a template dataset card in the <code>lewtun/github-issues</code> dataset repository. A screenshot of the filled-out dataset card is shown below.",we,X,yl='<img src="https://huggingface.co/datasets/huggingface-course/documentation-images/resolve/main/en/chapter5/dataset-card.png" alt="A dataset card." width="80%"/>',be,C,fe,Ls,ml="That’s it! We’ve seen in this section that creating a good dataset can be quite involved, but fortunately uploading it and sharing it with the community is not. In the next section we’ll use our new dataset to create a semantic search engine with 🤗 Datasets that can match questions to the most relevant issues and comments.",xe,k,Ze,Ds,Ge,Ks,Ie;return _=new Ps({props:{title:"Creating your own dataset",local:"creating-your-own-dataset",headingTag:"h1"}}),v=new kl({props:{chapter:5,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter5/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter5/section5.ipynb"}]}}),$=new Ps({props:{title:"Getting the data",local:"getting-the-data",headingTag:"h2"}}),Y=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjByZXF1ZXN0cw==",highlighted:"!pip install requests",wrap:!1}}),A=new m({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmFwaS5naXRodWIuY29tJTJGcmVwb3MlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGaXNzdWVzJTNGcGFnZSUzRDElMjZwZXJfcGFnZSUzRDElMjIlMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwp",highlighted:`<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://api.github.com/repos/huggingface/datasets/issues?page=1&amp;per_page=1&quot;</span>
response = requests.get(url)`,wrap:!1}}),L=new m({props:{code:"cmVzcG9uc2Uuc3RhdHVzX2NvZGU=",highlighted:"response.status_code",wrap:!1}}),D=new m({props:{code:"MjAw",highlighted:'<span class="hljs-number">200</span>',wrap:!1}}),P=new m({props:{code:"cmVzcG9uc2UuanNvbigp",highlighted:"response.json()",wrap:!1}}),O=new m({props:{code:"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",highlighted:`[{<span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/issues/2792&#x27;</span>,
  <span class="hljs-string">&#x27;repository_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets&#x27;</span>,
  <span class="hljs-string">&#x27;labels_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/issues/2792/labels{/name}&#x27;</span>,
  <span class="hljs-string">&#x27;comments_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/issues/2792/comments&#x27;</span>,
  <span class="hljs-string">&#x27;events_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/issues/2792/events&#x27;</span>,
  <span class="hljs-string">&#x27;html_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/2792&#x27;</span>,
  <span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">968650274</span>,
  <span class="hljs-string">&#x27;node_id&#x27;</span>: <span class="hljs-string">&#x27;MDExOlB1bGxSZXF1ZXN0NzEwNzUyMjc0&#x27;</span>,
  <span class="hljs-string">&#x27;number&#x27;</span>: <span class="hljs-number">2792</span>,
  <span class="hljs-string">&#x27;title&#x27;</span>: <span class="hljs-string">&#x27;Update GooAQ&#x27;</span>,
  <span class="hljs-string">&#x27;user&#x27;</span>: {<span class="hljs-string">&#x27;login&#x27;</span>: <span class="hljs-string">&#x27;bhavitvyamalik&#x27;</span>,
   <span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">19718818</span>,
   <span class="hljs-string">&#x27;node_id&#x27;</span>: <span class="hljs-string">&#x27;MDQ6VXNlcjE5NzE4ODE4&#x27;</span>,
   <span class="hljs-string">&#x27;avatar_url&#x27;</span>: <span class="hljs-string">&#x27;https://avatars.githubusercontent.com/u/19718818?v=4&#x27;</span>,
   <span class="hljs-string">&#x27;gravatar_id&#x27;</span>: <span class="hljs-string">&#x27;&#x27;</span>,
   <span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik&#x27;</span>,
   <span class="hljs-string">&#x27;html_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/bhavitvyamalik&#x27;</span>,
   <span class="hljs-string">&#x27;followers_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/followers&#x27;</span>,
   <span class="hljs-string">&#x27;following_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/following{/other_user}&#x27;</span>,
   <span class="hljs-string">&#x27;gists_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/gists{/gist_id}&#x27;</span>,
   <span class="hljs-string">&#x27;starred_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/starred{/owner}{/repo}&#x27;</span>,
   <span class="hljs-string">&#x27;subscriptions_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/subscriptions&#x27;</span>,
   <span class="hljs-string">&#x27;organizations_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/orgs&#x27;</span>,
   <span class="hljs-string">&#x27;repos_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/repos&#x27;</span>,
   <span class="hljs-string">&#x27;events_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/events{/privacy}&#x27;</span>,
   <span class="hljs-string">&#x27;received_events_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/received_events&#x27;</span>,
   <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;User&#x27;</span>,
   <span class="hljs-string">&#x27;site_admin&#x27;</span>: <span class="hljs-literal">False</span>},
  <span class="hljs-string">&#x27;labels&#x27;</span>: [],
  <span class="hljs-string">&#x27;state&#x27;</span>: <span class="hljs-string">&#x27;open&#x27;</span>,
  <span class="hljs-string">&#x27;locked&#x27;</span>: <span class="hljs-literal">False</span>,
  <span class="hljs-string">&#x27;assignee&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;assignees&#x27;</span>: [],
  <span class="hljs-string">&#x27;milestone&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;comments&#x27;</span>: <span class="hljs-number">1</span>,
  <span class="hljs-string">&#x27;created_at&#x27;</span>: <span class="hljs-string">&#x27;2021-08-12T11:40:18Z&#x27;</span>,
  <span class="hljs-string">&#x27;updated_at&#x27;</span>: <span class="hljs-string">&#x27;2021-08-12T12:31:17Z&#x27;</span>,
  <span class="hljs-string">&#x27;closed_at&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;author_association&#x27;</span>: <span class="hljs-string">&#x27;CONTRIBUTOR&#x27;</span>,
  <span class="hljs-string">&#x27;active_lock_reason&#x27;</span>: <span class="hljs-literal">None</span>,
  <span class="hljs-string">&#x27;pull_request&#x27;</span>: {<span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/pulls/2792&#x27;</span>,
   <span class="hljs-string">&#x27;html_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/2792&#x27;</span>,
   <span class="hljs-string">&#x27;diff_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/2792.diff&#x27;</span>,
   <span class="hljs-string">&#x27;patch_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/2792.patch&#x27;</span>},
  <span class="hljs-string">&#x27;body&#x27;</span>: <span class="hljs-string">&#x27;[GooAQ](https://github.com/allenai/gooaq) dataset was recently updated after splits were added for the same. This PR contains new updated GooAQ with train/val/test splits and updated README as well.&#x27;</span>,
  <span class="hljs-string">&#x27;performed_via_github_app&#x27;</span>: <span class="hljs-literal">None</span>}]`,wrap:!1}}),b=new qs({props:{$$slots:{default:[_l]},$$scope:{ctx:g}}}),ts=new m({props:{code:"R0lUSFVCX1RPS0VOJTIwJTNEJTIweHh4JTIwJTIwJTIzJTIwQ29weSUyMHlvdXIlMjBHaXRIdWIlMjB0b2tlbiUyMGhlcmUlMEFoZWFkZXJzJTIwJTNEJTIwJTdCJTIyQXV0aG9yaXphdGlvbiUyMiUzQSUyMGYlMjJ0b2tlbiUyMCU3QkdJVEhVQl9UT0tFTiU3RCUyMiU3RA==",highlighted:`GITHUB_TOKEN = xxx  <span class="hljs-comment"># Copy your GitHub token here</span>
headers = {<span class="hljs-string">&quot;Authorization&quot;</span>: <span class="hljs-string">f&quot;token <span class="hljs-subst">{GITHUB_TOKEN}</span>&quot;</span>}`,wrap:!1}}),f=new qs({props:{warning:!0,$$slots:{default:[vl]},$$scope:{ctx:g}}}),ls=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> tqdm.notebook <span class="hljs-keyword">import</span> tqdm


<span class="hljs-keyword">def</span> <span class="hljs-title function_">fetch_issues</span>(<span class="hljs-params">
    owner=<span class="hljs-string">&quot;huggingface&quot;</span>,
    repo=<span class="hljs-string">&quot;datasets&quot;</span>,
    num_issues=<span class="hljs-number">10_000</span>,
    rate_limit=<span class="hljs-number">5_000</span>,
    issues_path=Path(<span class="hljs-params"><span class="hljs-string">&quot;.&quot;</span></span>),
</span>):
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> issues_path.is_dir():
        issues_path.mkdir(exist_ok=<span class="hljs-literal">True</span>)

    batch = []
    all_issues = []
    per_page = <span class="hljs-number">100</span>  <span class="hljs-comment"># Number of issues to return per page</span>
    num_pages = math.ceil(num_issues / per_page)
    base_url = <span class="hljs-string">&quot;https://api.github.com/repos&quot;</span>

    <span class="hljs-keyword">for</span> page <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(num_pages)):
        <span class="hljs-comment"># Query with state=all to get both open and closed issues</span>
        query = <span class="hljs-string">f&quot;issues?page=<span class="hljs-subst">{page}</span>&amp;per_page=<span class="hljs-subst">{per_page}</span>&amp;state=all&quot;</span>
        issues = requests.get(<span class="hljs-string">f&quot;<span class="hljs-subst">{base_url}</span>/<span class="hljs-subst">{owner}</span>/<span class="hljs-subst">{repo}</span>/<span class="hljs-subst">{query}</span>&quot;</span>, headers=headers)
        batch.extend(issues.json())

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(batch) &gt; rate_limit <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(all_issues) &lt; num_issues:
            all_issues.extend(batch)
            batch = []  <span class="hljs-comment"># Flush batch for next time period</span>
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Reached GitHub rate limit. Sleeping for one hour ...&quot;</span>)
            time.sleep(<span class="hljs-number">60</span> * <span class="hljs-number">60</span> + <span class="hljs-number">1</span>)

    all_issues.extend(batch)
    df = pd.DataFrame.from_records(all_issues)
    df.to_json(<span class="hljs-string">f&quot;<span class="hljs-subst">{issues_path}</span>/<span class="hljs-subst">{repo}</span>-issues.jsonl&quot;</span>, orient=<span class="hljs-string">&quot;records&quot;</span>, lines=<span class="hljs-literal">True</span>)
    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">f&quot;Downloaded all the issues for <span class="hljs-subst">{repo}</span>! Dataset stored at <span class="hljs-subst">{issues_path}</span>/<span class="hljs-subst">{repo}</span>-issues.jsonl&quot;</span>
    )`,wrap:!1}}),ns=new m({props:{code:"JTIzJTIwRGVwZW5kaW5nJTIwb24lMjB5b3VyJTIwaW50ZXJuZXQlMjBjb25uZWN0aW9uJTJDJTIwdGhpcyUyMGNhbiUyMHRha2UlMjBzZXZlcmFsJTIwbWludXRlcyUyMHRvJTIwcnVuLi4uJTBBZmV0Y2hfaXNzdWVzKCk=",highlighted:`<span class="hljs-comment"># Depending on your internet connection, this can take several minutes to run...</span>
fetch_issues()`,wrap:!1}}),ps=new m({props:{code:"aXNzdWVzX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyanNvbiUyMiUyQyUyMGRhdGFfZmlsZXMlM0QlMjJkYXRhc2V0cy1pc3N1ZXMuanNvbmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWlzc3Vlc19kYXRhc2V0",highlighted:`issues_dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;datasets-issues.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
issues_dataset`,wrap:!1}}),cs=new m({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid1cmwnJTJDJTIwJ3JlcG9zaXRvcnlfdXJsJyUyQyUyMCdsYWJlbHNfdXJsJyUyQyUyMCdjb21tZW50c191cmwnJTJDJTIwJ2V2ZW50c191cmwnJTJDJTIwJ2h0bWxfdXJsJyUyQyUyMCdpZCclMkMlMjAnbm9kZV9pZCclMkMlMjAnbnVtYmVyJyUyQyUyMCd0aXRsZSclMkMlMjAndXNlciclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdGF0ZSclMkMlMjAnbG9ja2VkJyUyQyUyMCdhc3NpZ25lZSclMkMlMjAnYXNzaWduZWVzJyUyQyUyMCdtaWxlc3RvbmUnJTJDJTIwJ2NvbW1lbnRzJyUyQyUyMCdjcmVhdGVkX2F0JyUyQyUyMCd1cGRhdGVkX2F0JyUyQyUyMCdjbG9zZWRfYXQnJTJDJTIwJ2F1dGhvcl9hc3NvY2lhdGlvbiclMkMlMjAnYWN0aXZlX2xvY2tfcmVhc29uJyUyQyUyMCdwdWxsX3JlcXVlc3QnJTJDJTIwJ2JvZHknJTJDJTIwJ3RpbWVsaW5lX3VybCclMkMlMjAncGVyZm9ybWVkX3ZpYV9naXRodWJfYXBwJyU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMzAxOSUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;url&#x27;</span>, <span class="hljs-string">&#x27;repository_url&#x27;</span>, <span class="hljs-string">&#x27;labels_url&#x27;</span>, <span class="hljs-string">&#x27;comments_url&#x27;</span>, <span class="hljs-string">&#x27;events_url&#x27;</span>, <span class="hljs-string">&#x27;html_url&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;node_id&#x27;</span>, <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;state&#x27;</span>, <span class="hljs-string">&#x27;locked&#x27;</span>, <span class="hljs-string">&#x27;assignee&#x27;</span>, <span class="hljs-string">&#x27;assignees&#x27;</span>, <span class="hljs-string">&#x27;milestone&#x27;</span>, <span class="hljs-string">&#x27;comments&#x27;</span>, <span class="hljs-string">&#x27;created_at&#x27;</span>, <span class="hljs-string">&#x27;updated_at&#x27;</span>, <span class="hljs-string">&#x27;closed_at&#x27;</span>, <span class="hljs-string">&#x27;author_association&#x27;</span>, <span class="hljs-string">&#x27;active_lock_reason&#x27;</span>, <span class="hljs-string">&#x27;pull_request&#x27;</span>, <span class="hljs-string">&#x27;body&#x27;</span>, <span class="hljs-string">&#x27;timeline_url&#x27;</span>, <span class="hljs-string">&#x27;performed_via_github_app&#x27;</span>],
    num_rows: <span class="hljs-number">3019</span>
})`,wrap:!1}}),Ms=new Ps({props:{title:"Cleaning up the data",local:"cleaning-up-the-data",headingTag:"h2"}}),ds=new m({props:{code:"c2FtcGxlJTIwJTNEJTIwaXNzdWVzX2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENjY2KS5zZWxlY3QocmFuZ2UoMykpJTBBJTBBJTIzJTIwUHJpbnQlMjBvdXQlMjB0aGUlMjBVUkwlMjBhbmQlMjBwdWxsJTIwcmVxdWVzdCUyMGVudHJpZXMlMEFmb3IlMjB1cmwlMkMlMjBwciUyMGluJTIwemlwKHNhbXBsZSU1QiUyMmh0bWxfdXJsJTIyJTVEJTJDJTIwc2FtcGxlJTVCJTIycHVsbF9yZXF1ZXN0JTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlM0UlM0UlMjBVUkwlM0ElMjAlN0J1cmwlN0QlMjIpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiUzRSUzRSUyMFB1bGwlMjByZXF1ZXN0JTNBJTIwJTdCcHIlN0QlNUNuJTIyKQ==",highlighted:`sample = issues_dataset.shuffle(seed=<span class="hljs-number">666</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>))

<span class="hljs-comment"># Print out the URL and pull request entries</span>
<span class="hljs-keyword">for</span> url, pr <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(sample[<span class="hljs-string">&quot;html_url&quot;</span>], sample[<span class="hljs-string">&quot;pull_request&quot;</span>]):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;&gt;&gt; URL: <span class="hljs-subst">{url}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;&gt;&gt; Pull request: <span class="hljs-subst">{pr}</span>\\n&quot;</span>)`,wrap:!1}}),Js=new m({props:{code:"JTNFJTNFJTIwVVJMJTNBJTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRnB1bGwlMkY4NTAlMEElM0UlM0UlMjBQdWxsJTIwcmVxdWVzdCUzQSUyMCU3Qid1cmwnJTNBJTIwJ2h0dHBzJTNBJTJGJTJGYXBpLmdpdGh1Yi5jb20lMkZyZXBvcyUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZwdWxscyUyRjg1MCclMkMlMjAnaHRtbF91cmwnJTNBJTIwJ2h0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZwdWxsJTJGODUwJyUyQyUyMCdkaWZmX3VybCclM0ElMjAnaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRnB1bGwlMkY4NTAuZGlmZiclMkMlMjAncGF0Y2hfdXJsJyUzQSUyMCdodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGcHVsbCUyRjg1MC5wYXRjaCclN0QlMEElMEElM0UlM0UlMjBVUkwlM0ElMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGaXNzdWVzJTJGMjc3MyUwQSUzRSUzRSUyMFB1bGwlMjByZXF1ZXN0JTNBJTIwTm9uZSUwQSUwQSUzRSUzRSUyMFVSTCUzQSUyMGh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZwdWxsJTJGNzgzJTBBJTNFJTNFJTIwUHVsbCUyMHJlcXVlc3QlM0ElMjAlN0IndXJsJyUzQSUyMCdodHRwcyUzQSUyRiUyRmFwaS5naXRodWIuY29tJTJGcmVwb3MlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGcHVsbHMlMkY3ODMnJTJDJTIwJ2h0bWxfdXJsJyUzQSUyMCdodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGcHVsbCUyRjc4MyclMkMlMjAnZGlmZl91cmwnJTNBJTIwJ2h0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGZGF0YXNldHMlMkZwdWxsJTJGNzgzLmRpZmYnJTJDJTIwJ3BhdGNoX3VybCclM0ElMjAnaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRnB1bGwlMkY3ODMucGF0Y2gnJTdE",highlighted:`&gt;&gt; URL: https://github.com/huggingface/datasets/pull/<span class="hljs-number">850</span>
&gt;&gt; Pull request: {<span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/pulls/850&#x27;</span>, <span class="hljs-string">&#x27;html_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/850&#x27;</span>, <span class="hljs-string">&#x27;diff_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/850.diff&#x27;</span>, <span class="hljs-string">&#x27;patch_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/850.patch&#x27;</span>}

&gt;&gt; URL: https://github.com/huggingface/datasets/issues/<span class="hljs-number">2773</span>
&gt;&gt; Pull request: <span class="hljs-literal">None</span>

&gt;&gt; URL: https://github.com/huggingface/datasets/pull/<span class="hljs-number">783</span>
&gt;&gt; Pull request: {<span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/pulls/783&#x27;</span>, <span class="hljs-string">&#x27;html_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/783&#x27;</span>, <span class="hljs-string">&#x27;diff_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/783.diff&#x27;</span>, <span class="hljs-string">&#x27;patch_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/783.patch&#x27;</span>}`,wrap:!1}}),ms=new m({props:{code:"aXNzdWVzX2RhdGFzZXQlMjAlM0QlMjBpc3N1ZXNfZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIweCUzQSUyMCU3QiUyMmlzX3B1bGxfcmVxdWVzdCUyMiUzQSUyMEZhbHNlJTIwaWYlMjB4JTVCJTIycHVsbF9yZXF1ZXN0JTIyJTVEJTIwaXMlMjBOb25lJTIwZWxzZSUyMFRydWUlN0QlMEEp",highlighted:`issues_dataset = issues_dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;is_pull_request&quot;</span>: <span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> x[<span class="hljs-string">&quot;pull_request&quot;</span>] <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>}
)`,wrap:!1}}),x=new qs({props:{$$slots:{default:[zl]},$$scope:{ctx:g}}}),gs=new Ps({props:{title:"Augmenting the dataset",local:"augmenting-the-dataset",headingTag:"h2"}}),bs=new m({props:{code:"aXNzdWVfbnVtYmVyJTIwJTNEJTIwMjc5MiUwQXVybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRmFwaS5naXRodWIuY29tJTJGcmVwb3MlMkZodWdnaW5nZmFjZSUyRmRhdGFzZXRzJTJGaXNzdWVzJTJGJTdCaXNzdWVfbnVtYmVyJTdEJTJGY29tbWVudHMlMjIlMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwlMkMlMjBoZWFkZXJzJTNEaGVhZGVycyklMEFyZXNwb25zZS5qc29uKCk=",highlighted:`issue_number = <span class="hljs-number">2792</span>
url = <span class="hljs-string">f&quot;https://api.github.com/repos/huggingface/datasets/issues/<span class="hljs-subst">{issue_number}</span>/comments&quot;</span>
response = requests.get(url, headers=headers)
response.json()`,wrap:!1}}),fs=new m({props:{code:"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",highlighted:`[{<span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/issues/comments/897594128&#x27;</span>,
  <span class="hljs-string">&#x27;html_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/huggingface/datasets/pull/2792#issuecomment-897594128&#x27;</span>,
  <span class="hljs-string">&#x27;issue_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/repos/huggingface/datasets/issues/2792&#x27;</span>,
  <span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">897594128</span>,
  <span class="hljs-string">&#x27;node_id&#x27;</span>: <span class="hljs-string">&#x27;IC_kwDODunzps41gDMQ&#x27;</span>,
  <span class="hljs-string">&#x27;user&#x27;</span>: {<span class="hljs-string">&#x27;login&#x27;</span>: <span class="hljs-string">&#x27;bhavitvyamalik&#x27;</span>,
   <span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">19718818</span>,
   <span class="hljs-string">&#x27;node_id&#x27;</span>: <span class="hljs-string">&#x27;MDQ6VXNlcjE5NzE4ODE4&#x27;</span>,
   <span class="hljs-string">&#x27;avatar_url&#x27;</span>: <span class="hljs-string">&#x27;https://avatars.githubusercontent.com/u/19718818?v=4&#x27;</span>,
   <span class="hljs-string">&#x27;gravatar_id&#x27;</span>: <span class="hljs-string">&#x27;&#x27;</span>,
   <span class="hljs-string">&#x27;url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik&#x27;</span>,
   <span class="hljs-string">&#x27;html_url&#x27;</span>: <span class="hljs-string">&#x27;https://github.com/bhavitvyamalik&#x27;</span>,
   <span class="hljs-string">&#x27;followers_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/followers&#x27;</span>,
   <span class="hljs-string">&#x27;following_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/following{/other_user}&#x27;</span>,
   <span class="hljs-string">&#x27;gists_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/gists{/gist_id}&#x27;</span>,
   <span class="hljs-string">&#x27;starred_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/starred{/owner}{/repo}&#x27;</span>,
   <span class="hljs-string">&#x27;subscriptions_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/subscriptions&#x27;</span>,
   <span class="hljs-string">&#x27;organizations_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/orgs&#x27;</span>,
   <span class="hljs-string">&#x27;repos_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/repos&#x27;</span>,
   <span class="hljs-string">&#x27;events_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/events{/privacy}&#x27;</span>,
   <span class="hljs-string">&#x27;received_events_url&#x27;</span>: <span class="hljs-string">&#x27;https://api.github.com/users/bhavitvyamalik/received_events&#x27;</span>,
   <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;User&#x27;</span>,
   <span class="hljs-string">&#x27;site_admin&#x27;</span>: <span class="hljs-literal">False</span>},
  <span class="hljs-string">&#x27;created_at&#x27;</span>: <span class="hljs-string">&#x27;2021-08-12T12:21:52Z&#x27;</span>,
  <span class="hljs-string">&#x27;updated_at&#x27;</span>: <span class="hljs-string">&#x27;2021-08-12T12:31:17Z&#x27;</span>,
  <span class="hljs-string">&#x27;author_association&#x27;</span>: <span class="hljs-string">&#x27;CONTRIBUTOR&#x27;</span>,
  <span class="hljs-string">&#x27;body&#x27;</span>: <span class="hljs-string">&quot;@albertvillanova my tests are failing here:\\r\\n\`\`\`\\r\\ndataset_name = &#x27;gooaq&#x27;\\r\\n\\r\\n    def test_load_dataset(self, dataset_name):\\r\\n        configs = self.dataset_tester.load_all_configs(dataset_name, is_local=True)[:1]\\r\\n&gt;       self.dataset_tester.check_load_dataset(dataset_name, configs, is_local=True, use_local_dummy_data=True)\\r\\n\\r\\ntests/test_dataset_common.py:234: \\r\\n_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ \\r\\ntests/test_dataset_common.py:187: in check_load_dataset\\r\\n    self.parent.assertTrue(len(dataset[split]) &gt; 0)\\r\\nE   AssertionError: False is not true\\r\\n\`\`\`\\r\\nWhen I try loading dataset on local machine it works fine. Any suggestions on how can I avoid this error?&quot;</span>,
  <span class="hljs-string">&#x27;performed_via_github_app&#x27;</span>: <span class="hljs-literal">None</span>}]`,wrap:!1}}),Zs=new m({props:{code:"ZGVmJTIwZ2V0X2NvbW1lbnRzKGlzc3VlX251bWJlciklM0ElMEElMjAlMjAlMjAlMjB1cmwlMjAlM0QlMjBmJTIyaHR0cHMlM0ElMkYlMkZhcGkuZ2l0aHViLmNvbSUyRnJlcG9zJTJGaHVnZ2luZ2ZhY2UlMkZkYXRhc2V0cyUyRmlzc3VlcyUyRiU3Qmlzc3VlX251bWJlciU3RCUyRmNvbW1lbnRzJTIyJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsJTJDJTIwaGVhZGVycyUzRGhlYWRlcnMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTVCciU1QiUyMmJvZHklMjIlNUQlMjBmb3IlMjByJTIwaW4lMjByZXNwb25zZS5qc29uKCklNUQlMEElMEElMEElMjMlMjBUZXN0JTIwb3VyJTIwZnVuY3Rpb24lMjB3b3JrcyUyMGFzJTIwZXhwZWN0ZWQlMEFnZXRfY29tbWVudHMoMjc5Mik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_comments</span>(<span class="hljs-params">issue_number</span>):
    url = <span class="hljs-string">f&quot;https://api.github.com/repos/huggingface/datasets/issues/<span class="hljs-subst">{issue_number}</span>/comments&quot;</span>
    response = requests.get(url, headers=headers)
    <span class="hljs-keyword">return</span> [r[<span class="hljs-string">&quot;body&quot;</span>] <span class="hljs-keyword">for</span> r <span class="hljs-keyword">in</span> response.json()]


<span class="hljs-comment"># Test our function works as expected</span>
get_comments(<span class="hljs-number">2792</span>)`,wrap:!1}}),Gs=new m({props:{code:"JTVCJTIyJTQwYWxiZXJ0dmlsbGFub3ZhJTIwbXklMjB0ZXN0cyUyMGFyZSUyMGZhaWxpbmclMjBoZXJlJTNBJTVDciU1Q24lNjAlNjAlNjAlNUNyJTVDbmRhdGFzZXRfbmFtZSUyMCUzRCUyMCdnb29hcSclNUNyJTVDbiU1Q3IlNUNuJTIwJTIwJTIwJTIwZGVmJTIwdGVzdF9sb2FkX2RhdGFzZXQoc2VsZiUyQyUyMGRhdGFzZXRfbmFtZSklM0ElNUNyJTVDbiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZ3MlMjAlM0QlMjBzZWxmLmRhdGFzZXRfdGVzdGVyLmxvYWRfYWxsX2NvbmZpZ3MoZGF0YXNldF9uYW1lJTJDJTIwaXNfbG9jYWwlM0RUcnVlKSU1QiUzQTElNUQlNUNyJTVDbiUzRSUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGF0YXNldF90ZXN0ZXIuY2hlY2tfbG9hZF9kYXRhc2V0KGRhdGFzZXRfbmFtZSUyQyUyMGNvbmZpZ3MlMkMlMjBpc19sb2NhbCUzRFRydWUlMkMlMjB1c2VfbG9jYWxfZHVtbXlfZGF0YSUzRFRydWUpJTVDciU1Q24lNUNyJTVDbnRlc3RzJTJGdGVzdF9kYXRhc2V0X2NvbW1vbi5weSUzQTIzNCUzQSUyMCU1Q3IlNUNuXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMF8lMjBfJTIwXyUyMCU1Q3IlNUNudGVzdHMlMkZ0ZXN0X2RhdGFzZXRfY29tbW9uLnB5JTNBMTg3JTNBJTIwaW4lMjBjaGVja19sb2FkX2RhdGFzZXQlNUNyJTVDbiUyMCUyMCUyMCUyMHNlbGYucGFyZW50LmFzc2VydFRydWUobGVuKGRhdGFzZXQlNUJzcGxpdCU1RCklMjAlM0UlMjAwKSU1Q3IlNUNuRSUyMCUyMCUyMEFzc2VydGlvbkVycm9yJTNBJTIwRmFsc2UlMjBpcyUyMG5vdCUyMHRydWUlNUNyJTVDbiU2MCU2MCU2MCU1Q3IlNUNuV2hlbiUyMEklMjB0cnklMjBsb2FkaW5nJTIwZGF0YXNldCUyMG9uJTIwbG9jYWwlMjBtYWNoaW5lJTIwaXQlMjB3b3JrcyUyMGZpbmUuJTIwQW55JTIwc3VnZ2VzdGlvbnMlMjBvbiUyMGhvdyUyMGNhbiUyMEklMjBhdm9pZCUyMHRoaXMlMjBlcnJvciUzRiUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;@albertvillanova my tests are failing here:\\r\\n```\\r\\ndataset_name = &#x27;gooaq&#x27;\\r\\n\\r\\n    def test_load_dataset(self, dataset_name):\\r\\n        configs = self.dataset_tester.load_all_configs(dataset_name, is_local=True)[:1]\\r\\n&gt;       self.dataset_tester.check_load_dataset(dataset_name, configs, is_local=True, use_local_dummy_data=True)\\r\\n\\r\\ntests/test_dataset_common.py:234: \\r\\n_ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ \\r\\ntests/test_dataset_common.py:187: in check_load_dataset\\r\\n    self.parent.assertTrue(len(dataset[split]) &gt; 0)\\r\\nE   AssertionError: False is not true\\r\\n```\\r\\nWhen I try loading dataset on local machine it works fine. Any suggestions on how can I avoid this error?&quot;</span>]',wrap:!1}}),Rs=new m({props:{code:"JTIzJTIwRGVwZW5kaW5nJTIwb24lMjB5b3VyJTIwaW50ZXJuZXQlMjBjb25uZWN0aW9uJTJDJTIwdGhpcyUyMGNhbiUyMHRha2UlMjBhJTIwZmV3JTIwbWludXRlcy4uLiUwQWlzc3Vlc193aXRoX2NvbW1lbnRzX2RhdGFzZXQlMjAlM0QlMjBpc3N1ZXNfZGF0YXNldC5tYXAoJTBBJTIwJTIwJTIwJTIwbGFtYmRhJTIweCUzQSUyMCU3QiUyMmNvbW1lbnRzJTIyJTNBJTIwZ2V0X2NvbW1lbnRzKHglNUIlMjJudW1iZXIlMjIlNUQpJTdEJTBBKQ==",highlighted:`<span class="hljs-comment"># Depending on your internet connection, this can take a few minutes...</span>
issues_with_comments_dataset = issues_dataset.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;comments&quot;</span>: get_comments(x[<span class="hljs-string">&quot;number&quot;</span>])}
)`,wrap:!1}}),Cs=new Ps({props:{title:"Uploading the dataset to the Hugging Face Hub",local:"uploading-the-dataset-to-the-hugging-face-hub",headingTag:"h2"}}),ks=new Cl({props:{id:"HaN6qCr_Afc"}}),_s=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),zs=new m({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),Bs=new m({props:{code:"aXNzdWVzX3dpdGhfY29tbWVudHNfZGF0YXNldC5wdXNoX3RvX2h1YiglMjJnaXRodWItaXNzdWVzJTIyKQ==",highlighted:'issues_with_comments_dataset.push_to_hub(<span class="hljs-string">&quot;github-issues&quot;</span>)',wrap:!1}}),Ws=new m({props:{code:"cmVtb3RlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybGV3dHVuJTJGZ2l0aHViLWlzc3VlcyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBcmVtb3RlX2RhdGFzZXQ=",highlighted:`remote_dataset = load_dataset(<span class="hljs-string">&quot;lewtun/github-issues&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
remote_dataset`,wrap:!1}}),Hs=new m({props:{code:"RGF0YXNldCglN0IlMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMCU1Qid1cmwnJTJDJTIwJ3JlcG9zaXRvcnlfdXJsJyUyQyUyMCdsYWJlbHNfdXJsJyUyQyUyMCdjb21tZW50c191cmwnJTJDJTIwJ2V2ZW50c191cmwnJTJDJTIwJ2h0bWxfdXJsJyUyQyUyMCdpZCclMkMlMjAnbm9kZV9pZCclMkMlMjAnbnVtYmVyJyUyQyUyMCd0aXRsZSclMkMlMjAndXNlciclMkMlMjAnbGFiZWxzJyUyQyUyMCdzdGF0ZSclMkMlMjAnbG9ja2VkJyUyQyUyMCdhc3NpZ25lZSclMkMlMjAnYXNzaWduZWVzJyUyQyUyMCdtaWxlc3RvbmUnJTJDJTIwJ2NvbW1lbnRzJyUyQyUyMCdjcmVhdGVkX2F0JyUyQyUyMCd1cGRhdGVkX2F0JyUyQyUyMCdjbG9zZWRfYXQnJTJDJTIwJ2F1dGhvcl9hc3NvY2lhdGlvbiclMkMlMjAnYWN0aXZlX2xvY2tfcmVhc29uJyUyQyUyMCdwdWxsX3JlcXVlc3QnJTJDJTIwJ2JvZHknJTJDJTIwJ3BlcmZvcm1lZF92aWFfZ2l0aHViX2FwcCclMkMlMjAnaXNfcHVsbF9yZXF1ZXN0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwMjg1NSUwQSU3RCk=",highlighted:`Dataset({
    features: [<span class="hljs-string">&#x27;url&#x27;</span>, <span class="hljs-string">&#x27;repository_url&#x27;</span>, <span class="hljs-string">&#x27;labels_url&#x27;</span>, <span class="hljs-string">&#x27;comments_url&#x27;</span>, <span class="hljs-string">&#x27;events_url&#x27;</span>, <span class="hljs-string">&#x27;html_url&#x27;</span>, <span class="hljs-string">&#x27;id&#x27;</span>, <span class="hljs-string">&#x27;node_id&#x27;</span>, <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;title&#x27;</span>, <span class="hljs-string">&#x27;user&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;state&#x27;</span>, <span class="hljs-string">&#x27;locked&#x27;</span>, <span class="hljs-string">&#x27;assignee&#x27;</span>, <span class="hljs-string">&#x27;assignees&#x27;</span>, <span class="hljs-string">&#x27;milestone&#x27;</span>, <span class="hljs-string">&#x27;comments&#x27;</span>, <span class="hljs-string">&#x27;created_at&#x27;</span>, <span class="hljs-string">&#x27;updated_at&#x27;</span>, <span class="hljs-string">&#x27;closed_at&#x27;</span>, <span class="hljs-string">&#x27;author_association&#x27;</span>, <span class="hljs-string">&#x27;active_lock_reason&#x27;</span>, <span class="hljs-string">&#x27;pull_request&#x27;</span>, <span class="hljs-string">&#x27;body&#x27;</span>, <span class="hljs-string">&#x27;performed_via_github_app&#x27;</span>, <span class="hljs-string">&#x27;is_pull_request&#x27;</span>],
    num_rows: <span class="hljs-number">2855</span>
})`,wrap:!1}}),G=new qs({props:{$$slots:{default:[Vl]},$$scope:{ctx:g}}}),Qs=new Ps({props:{title:"Creating a dataset card",local:"creating-a-dataset-card",headingTag:"h2"}}),C=new qs({props:{$$slots:{default:[Bl]},$$scope:{ctx:g}}}),k=new qs({props:{$$slots:{default:[$l]},$$scope:{ctx:g}}}),Ds=new Nl({props:{source:"https://github.com/huggingface/course/blob/main/chapters/en/chapter5/5.mdx"}}),{c(){i=p("meta"),T=a(),o=p("p"),U=a(),r(_.$$.fragment),st=a(),r(v.$$.fragment),tt=a(),z=p("p"),z.innerHTML=Re,et=a(),V=p("ul"),V.innerHTML=Xe,lt=a(),B=p("p"),B.textContent=Ce,at=a(),r($.$$.fragment),nt=a(),W=p("p"),W.innerHTML=ke,it=a(),j=p("div"),j.innerHTML=Ne,pt=a(),H=p("p"),H.textContent=_e,ct=a(),w=p("div"),w.innerHTML=ve,ht=a(),F=p("p"),F.innerHTML=ze,ot=a(),Q=p("p"),Q.innerHTML=Ve,rt=a(),r(Y.$$.fragment),Mt=a(),E=p("p"),E.innerHTML=Be,ut=a(),r(A.$$.fragment),dt=a(),S=p("p"),S.innerHTML=$e,Jt=a(),r(L.$$.fragment),yt=a(),r(D.$$.fragment),mt=a(),q=p("p"),q.innerHTML=We,Tt=a(),r(P.$$.fragment),Ut=a(),r(O.$$.fragment),gt=a(),K=p("p"),K.innerHTML=He,jt=a(),r(b.$$.fragment),wt=a(),ss=p("p"),ss.innerHTML=Fe,bt=a(),r(ts.$$.fragment),ft=a(),r(f.$$.fragment),xt=a(),es=p("p"),es.textContent=Qe,Zt=a(),r(ls.$$.fragment),Gt=a(),as=p("p"),as.innerHTML=Ye,It=a(),r(ns.$$.fragment),Rt=a(),is=p("p"),is.innerHTML=Ee,Xt=a(),r(ps.$$.fragment),Ct=a(),r(cs.$$.fragment),kt=a(),hs=p("p"),hs.innerHTML=Ae,Nt=a(),os=p("blockquote"),os.innerHTML=Se,_t=a(),rs=p("p"),rs.textContent=Le,vt=a(),r(Ms.$$.fragment),zt=a(),us=p("p"),us.innerHTML=De,Vt=a(),r(ds.$$.fragment),Bt=a(),r(Js.$$.fragment),$t=a(),ys=p("p"),ys.innerHTML=qe,Wt=a(),r(ms.$$.fragment),Ht=a(),r(x.$$.fragment),Ft=a(),Ts=p("p"),Ts.textContent=Pe,Qt=a(),Us=p("p"),Us.textContent=Oe,Yt=a(),r(gs.$$.fragment),Et=a(),js=p("p"),js.textContent=Ke,At=a(),Z=p("div"),Z.innerHTML=sl,St=a(),ws=p("p"),ws.innerHTML=tl,Lt=a(),r(bs.$$.fragment),Dt=a(),r(fs.$$.fragment),qt=a(),xs=p("p"),xs.innerHTML=el,Pt=a(),r(Zs.$$.fragment),Ot=a(),r(Gs.$$.fragment),Kt=a(),Is=p("p"),Is.innerHTML=ll,se=a(),r(Rs.$$.fragment),te=a(),Xs=p("p"),Xs.textContent=al,ee=a(),r(Cs.$$.fragment),le=a(),r(ks.$$.fragment),ae=a(),Ns=p("p"),Ns.innerHTML=nl,ne=a(),r(_s.$$.fragment),ie=a(),vs=p("p"),vs.innerHTML=il,pe=a(),r(zs.$$.fragment),ce=a(),Vs=p("p"),Vs.textContent=pl,he=a(),r(Bs.$$.fragment),oe=a(),$s=p("p"),$s.innerHTML=cl,re=a(),r(Ws.$$.fragment),Me=a(),r(Hs.$$.fragment),ue=a(),Fs=p("p"),Fs.innerHTML=hl,de=a(),r(G.$$.fragment),Je=a(),r(Qs.$$.fragment),ye=a(),Ys=p("p"),Ys.textContent=ol,me=a(),Es=p("p"),Es.innerHTML=rl,Te=a(),As=p("ol"),As.innerHTML=Ml,Ue=a(),I=p("div"),I.innerHTML=ul,ge=a(),R=p("ol"),R.innerHTML=dl,je=a(),Ss=p("p"),Ss.innerHTML=Jl,we=a(),X=p("div"),X.innerHTML=yl,be=a(),r(C.$$.fragment),fe=a(),Ls=p("p"),Ls.textContent=ml,xe=a(),r(k.$$.fragment),Ze=a(),r(Ds.$$.fragment),Ge=a(),Ks=p("p"),this.h()},l(s){const t=Rl("svelte-u9bgzb",document.head);i=c(t,"META",{name:!0,content:!0}),t.forEach(e),T=n(s),o=c(s,"P",{}),fl(o).forEach(e),U=n(s),M(_.$$.fragment,s),st=n(s),M(v.$$.fragment,s),tt=n(s),z=c(s,"P",{"data-svelte-h":!0}),h(z)!=="svelte-2pzl18"&&(z.innerHTML=Re),et=n(s),V=c(s,"UL",{"data-svelte-h":!0}),h(V)!=="svelte-1wsg27y"&&(V.innerHTML=Xe),lt=n(s),B=c(s,"P",{"data-svelte-h":!0}),h(B)!=="svelte-ig49qh"&&(B.textContent=Ce),at=n(s),M($.$$.fragment,s),nt=n(s),W=c(s,"P",{"data-svelte-h":!0}),h(W)!=="svelte-14dv5k9"&&(W.innerHTML=ke),it=n(s),j=c(s,"DIV",{class:!0,"data-svelte-h":!0}),h(j)!=="svelte-1htetkm"&&(j.innerHTML=Ne),pt=n(s),H=c(s,"P",{"data-svelte-h":!0}),h(H)!=="svelte-todm9d"&&(H.textContent=_e),ct=n(s),w=c(s,"DIV",{class:!0,"data-svelte-h":!0}),h(w)!=="svelte-1jsgvzc"&&(w.innerHTML=ve),ht=n(s),F=c(s,"P",{"data-svelte-h":!0}),h(F)!=="svelte-okziki"&&(F.innerHTML=ze),ot=n(s),Q=c(s,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-8hfvb9"&&(Q.innerHTML=Ve),rt=n(s),M(Y.$$.fragment,s),Mt=n(s),E=c(s,"P",{"data-svelte-h":!0}),h(E)!=="svelte-6ujpwr"&&(E.innerHTML=Be),ut=n(s),M(A.$$.fragment,s),dt=n(s),S=c(s,"P",{"data-svelte-h":!0}),h(S)!=="svelte-1qxq8bq"&&(S.innerHTML=$e),Jt=n(s),M(L.$$.fragment,s),yt=n(s),M(D.$$.fragment,s),mt=n(s),q=c(s,"P",{"data-svelte-h":!0}),h(q)!=="svelte-55nv3s"&&(q.innerHTML=We),Tt=n(s),M(P.$$.fragment,s),Ut=n(s),M(O.$$.fragment,s),gt=n(s),K=c(s,"P",{"data-svelte-h":!0}),h(K)!=="svelte-1o6ope7"&&(K.innerHTML=He),jt=n(s),M(b.$$.fragment,s),wt=n(s),ss=c(s,"P",{"data-svelte-h":!0}),h(ss)!=="svelte-1n9ehvl"&&(ss.innerHTML=Fe),bt=n(s),M(ts.$$.fragment,s),ft=n(s),M(f.$$.fragment,s),xt=n(s),es=c(s,"P",{"data-svelte-h":!0}),h(es)!=="svelte-gcrsdf"&&(es.textContent=Qe),Zt=n(s),M(ls.$$.fragment,s),Gt=n(s),as=c(s,"P",{"data-svelte-h":!0}),h(as)!=="svelte-kn3xou"&&(as.innerHTML=Ye),It=n(s),M(ns.$$.fragment,s),Rt=n(s),is=c(s,"P",{"data-svelte-h":!0}),h(is)!=="svelte-p41l3v"&&(is.innerHTML=Ee),Xt=n(s),M(ps.$$.fragment,s),Ct=n(s),M(cs.$$.fragment,s),kt=n(s),hs=c(s,"P",{"data-svelte-h":!0}),h(hs)!=="svelte-1agbrha"&&(hs.innerHTML=Ae),Nt=n(s),os=c(s,"BLOCKQUOTE",{"data-svelte-h":!0}),h(os)!=="svelte-165ve2g"&&(os.innerHTML=Se),_t=n(s),rs=c(s,"P",{"data-svelte-h":!0}),h(rs)!=="svelte-1jig2ne"&&(rs.textContent=Le),vt=n(s),M(Ms.$$.fragment,s),zt=n(s),us=c(s,"P",{"data-svelte-h":!0}),h(us)!=="svelte-19lnvc6"&&(us.innerHTML=De),Vt=n(s),M(ds.$$.fragment,s),Bt=n(s),M(Js.$$.fragment,s),$t=n(s),ys=c(s,"P",{"data-svelte-h":!0}),h(ys)!=="svelte-17ui57s"&&(ys.innerHTML=qe),Wt=n(s),M(ms.$$.fragment,s),Ht=n(s),M(x.$$.fragment,s),Ft=n(s),Ts=c(s,"P",{"data-svelte-h":!0}),h(Ts)!=="svelte-semx1k"&&(Ts.textContent=Pe),Qt=n(s),Us=c(s,"P",{"data-svelte-h":!0}),h(Us)!=="svelte-1ndd7nr"&&(Us.textContent=Oe),Yt=n(s),M(gs.$$.fragment,s),Et=n(s),js=c(s,"P",{"data-svelte-h":!0}),h(js)!=="svelte-1btxfy6"&&(js.textContent=Ke),At=n(s),Z=c(s,"DIV",{class:!0,"data-svelte-h":!0}),h(Z)!=="svelte-1fxxwaz"&&(Z.innerHTML=sl),St=n(s),ws=c(s,"P",{"data-svelte-h":!0}),h(ws)!=="svelte-mxjbbm"&&(ws.innerHTML=tl),Lt=n(s),M(bs.$$.fragment,s),Dt=n(s),M(fs.$$.fragment,s),qt=n(s),xs=c(s,"P",{"data-svelte-h":!0}),h(xs)!=="svelte-15735ex"&&(xs.innerHTML=el),Pt=n(s),M(Zs.$$.fragment,s),Ot=n(s),M(Gs.$$.fragment,s),Kt=n(s),Is=c(s,"P",{"data-svelte-h":!0}),h(Is)!=="svelte-1io7odx"&&(Is.innerHTML=ll),se=n(s),M(Rs.$$.fragment,s),te=n(s),Xs=c(s,"P",{"data-svelte-h":!0}),h(Xs)!=="svelte-br1hgc"&&(Xs.textContent=al),ee=n(s),M(Cs.$$.fragment,s),le=n(s),M(ks.$$.fragment,s),ae=n(s),Ns=c(s,"P",{"data-svelte-h":!0}),h(Ns)!=="svelte-ijfj1o"&&(Ns.innerHTML=nl),ne=n(s),M(_s.$$.fragment,s),ie=n(s),vs=c(s,"P",{"data-svelte-h":!0}),h(vs)!=="svelte-1gkh8pe"&&(vs.innerHTML=il),pe=n(s),M(zs.$$.fragment,s),ce=n(s),Vs=c(s,"P",{"data-svelte-h":!0}),h(Vs)!=="svelte-1gte738"&&(Vs.textContent=pl),he=n(s),M(Bs.$$.fragment,s),oe=n(s),$s=c(s,"P",{"data-svelte-h":!0}),h($s)!=="svelte-a91t4n"&&($s.innerHTML=cl),re=n(s),M(Ws.$$.fragment,s),Me=n(s),M(Hs.$$.fragment,s),ue=n(s),Fs=c(s,"P",{"data-svelte-h":!0}),h(Fs)!=="svelte-35u4hy"&&(Fs.innerHTML=hl),de=n(s),M(G.$$.fragment,s),Je=n(s),M(Qs.$$.fragment,s),ye=n(s),Ys=c(s,"P",{"data-svelte-h":!0}),h(Ys)!=="svelte-1truj8y"&&(Ys.textContent=ol),me=n(s),Es=c(s,"P",{"data-svelte-h":!0}),h(Es)!=="svelte-rkb7f5"&&(Es.innerHTML=rl),Te=n(s),As=c(s,"OL",{"data-svelte-h":!0}),h(As)!=="svelte-4ek04i"&&(As.innerHTML=Ml),Ue=n(s),I=c(s,"DIV",{class:!0,"data-svelte-h":!0}),h(I)!=="svelte-1gqifn5"&&(I.innerHTML=ul),ge=n(s),R=c(s,"OL",{start:!0,"data-svelte-h":!0}),h(R)!=="svelte-j2vx37"&&(R.innerHTML=dl),je=n(s),Ss=c(s,"P",{"data-svelte-h":!0}),h(Ss)!=="svelte-1fazmyw"&&(Ss.innerHTML=Jl),we=n(s),X=c(s,"DIV",{class:!0,"data-svelte-h":!0}),h(X)!=="svelte-ct1wn8"&&(X.innerHTML=yl),be=n(s),M(C.$$.fragment,s),fe=n(s),Ls=c(s,"P",{"data-svelte-h":!0}),h(Ls)!=="svelte-15oxvlp"&&(Ls.textContent=ml),xe=n(s),M(k.$$.fragment,s),Ze=n(s),M(Ds.$$.fragment,s),Ge=n(s),Ks=c(s,"P",{}),fl(Ks).forEach(e),this.h()},h(){N(i,"name","hf:doc:metadata"),N(i,"content",Hl),N(j,"class","flex justify-center"),N(w,"class","flex justify-center"),N(Z,"class","flex justify-center"),N(I,"class","flex justify-center"),N(R,"start","2"),N(X,"class","flex justify-center")},m(s,t){Xl(document.head,i),l(s,T,t),l(s,o,t),l(s,U,t),u(_,s,t),l(s,st,t),u(v,s,t),l(s,tt,t),l(s,z,t),l(s,et,t),l(s,V,t),l(s,lt,t),l(s,B,t),l(s,at,t),u($,s,t),l(s,nt,t),l(s,W,t),l(s,it,t),l(s,j,t),l(s,pt,t),l(s,H,t),l(s,ct,t),l(s,w,t),l(s,ht,t),l(s,F,t),l(s,ot,t),l(s,Q,t),l(s,rt,t),u(Y,s,t),l(s,Mt,t),l(s,E,t),l(s,ut,t),u(A,s,t),l(s,dt,t),l(s,S,t),l(s,Jt,t),u(L,s,t),l(s,yt,t),u(D,s,t),l(s,mt,t),l(s,q,t),l(s,Tt,t),u(P,s,t),l(s,Ut,t),u(O,s,t),l(s,gt,t),l(s,K,t),l(s,jt,t),u(b,s,t),l(s,wt,t),l(s,ss,t),l(s,bt,t),u(ts,s,t),l(s,ft,t),u(f,s,t),l(s,xt,t),l(s,es,t),l(s,Zt,t),u(ls,s,t),l(s,Gt,t),l(s,as,t),l(s,It,t),u(ns,s,t),l(s,Rt,t),l(s,is,t),l(s,Xt,t),u(ps,s,t),l(s,Ct,t),u(cs,s,t),l(s,kt,t),l(s,hs,t),l(s,Nt,t),l(s,os,t),l(s,_t,t),l(s,rs,t),l(s,vt,t),u(Ms,s,t),l(s,zt,t),l(s,us,t),l(s,Vt,t),u(ds,s,t),l(s,Bt,t),u(Js,s,t),l(s,$t,t),l(s,ys,t),l(s,Wt,t),u(ms,s,t),l(s,Ht,t),u(x,s,t),l(s,Ft,t),l(s,Ts,t),l(s,Qt,t),l(s,Us,t),l(s,Yt,t),u(gs,s,t),l(s,Et,t),l(s,js,t),l(s,At,t),l(s,Z,t),l(s,St,t),l(s,ws,t),l(s,Lt,t),u(bs,s,t),l(s,Dt,t),u(fs,s,t),l(s,qt,t),l(s,xs,t),l(s,Pt,t),u(Zs,s,t),l(s,Ot,t),u(Gs,s,t),l(s,Kt,t),l(s,Is,t),l(s,se,t),u(Rs,s,t),l(s,te,t),l(s,Xs,t),l(s,ee,t),u(Cs,s,t),l(s,le,t),u(ks,s,t),l(s,ae,t),l(s,Ns,t),l(s,ne,t),u(_s,s,t),l(s,ie,t),l(s,vs,t),l(s,pe,t),u(zs,s,t),l(s,ce,t),l(s,Vs,t),l(s,he,t),u(Bs,s,t),l(s,oe,t),l(s,$s,t),l(s,re,t),u(Ws,s,t),l(s,Me,t),u(Hs,s,t),l(s,ue,t),l(s,Fs,t),l(s,de,t),u(G,s,t),l(s,Je,t),u(Qs,s,t),l(s,ye,t),l(s,Ys,t),l(s,me,t),l(s,Es,t),l(s,Te,t),l(s,As,t),l(s,Ue,t),l(s,I,t),l(s,ge,t),l(s,R,t),l(s,je,t),l(s,Ss,t),l(s,we,t),l(s,X,t),l(s,be,t),u(C,s,t),l(s,fe,t),l(s,Ls,t),l(s,xe,t),u(k,s,t),l(s,Ze,t),u(Ds,s,t),l(s,Ge,t),l(s,Ks,t),Ie=!0},p(s,[t]){const Tl={};t&2&&(Tl.$$scope={dirty:t,ctx:s}),b.$set(Tl);const Ul={};t&2&&(Ul.$$scope={dirty:t,ctx:s}),f.$set(Ul);const gl={};t&2&&(gl.$$scope={dirty:t,ctx:s}),x.$set(gl);const jl={};t&2&&(jl.$$scope={dirty:t,ctx:s}),G.$set(jl);const wl={};t&2&&(wl.$$scope={dirty:t,ctx:s}),C.$set(wl);const bl={};t&2&&(bl.$$scope={dirty:t,ctx:s}),k.$set(bl)},i(s){Ie||(d(_.$$.fragment,s),d(v.$$.fragment,s),d($.$$.fragment,s),d(Y.$$.fragment,s),d(A.$$.fragment,s),d(L.$$.fragment,s),d(D.$$.fragment,s),d(P.$$.fragment,s),d(O.$$.fragment,s),d(b.$$.fragment,s),d(ts.$$.fragment,s),d(f.$$.fragment,s),d(ls.$$.fragment,s),d(ns.$$.fragment,s),d(ps.$$.fragment,s),d(cs.$$.fragment,s),d(Ms.$$.fragment,s),d(ds.$$.fragment,s),d(Js.$$.fragment,s),d(ms.$$.fragment,s),d(x.$$.fragment,s),d(gs.$$.fragment,s),d(bs.$$.fragment,s),d(fs.$$.fragment,s),d(Zs.$$.fragment,s),d(Gs.$$.fragment,s),d(Rs.$$.fragment,s),d(Cs.$$.fragment,s),d(ks.$$.fragment,s),d(_s.$$.fragment,s),d(zs.$$.fragment,s),d(Bs.$$.fragment,s),d(Ws.$$.fragment,s),d(Hs.$$.fragment,s),d(G.$$.fragment,s),d(Qs.$$.fragment,s),d(C.$$.fragment,s),d(k.$$.fragment,s),d(Ds.$$.fragment,s),Ie=!0)},o(s){J(_.$$.fragment,s),J(v.$$.fragment,s),J($.$$.fragment,s),J(Y.$$.fragment,s),J(A.$$.fragment,s),J(L.$$.fragment,s),J(D.$$.fragment,s),J(P.$$.fragment,s),J(O.$$.fragment,s),J(b.$$.fragment,s),J(ts.$$.fragment,s),J(f.$$.fragment,s),J(ls.$$.fragment,s),J(ns.$$.fragment,s),J(ps.$$.fragment,s),J(cs.$$.fragment,s),J(Ms.$$.fragment,s),J(ds.$$.fragment,s),J(Js.$$.fragment,s),J(ms.$$.fragment,s),J(x.$$.fragment,s),J(gs.$$.fragment,s),J(bs.$$.fragment,s),J(fs.$$.fragment,s),J(Zs.$$.fragment,s),J(Gs.$$.fragment,s),J(Rs.$$.fragment,s),J(Cs.$$.fragment,s),J(ks.$$.fragment,s),J(_s.$$.fragment,s),J(zs.$$.fragment,s),J(Bs.$$.fragment,s),J(Ws.$$.fragment,s),J(Hs.$$.fragment,s),J(G.$$.fragment,s),J(Qs.$$.fragment,s),J(C.$$.fragment,s),J(k.$$.fragment,s),J(Ds.$$.fragment,s),Ie=!1},d(s){s&&(e(T),e(o),e(U),e(st),e(tt),e(z),e(et),e(V),e(lt),e(B),e(at),e(nt),e(W),e(it),e(j),e(pt),e(H),e(ct),e(w),e(ht),e(F),e(ot),e(Q),e(rt),e(Mt),e(E),e(ut),e(dt),e(S),e(Jt),e(yt),e(mt),e(q),e(Tt),e(Ut),e(gt),e(K),e(jt),e(wt),e(ss),e(bt),e(ft),e(xt),e(es),e(Zt),e(Gt),e(as),e(It),e(Rt),e(is),e(Xt),e(Ct),e(kt),e(hs),e(Nt),e(os),e(_t),e(rs),e(vt),e(zt),e(us),e(Vt),e(Bt),e($t),e(ys),e(Wt),e(Ht),e(Ft),e(Ts),e(Qt),e(Us),e(Yt),e(Et),e(js),e(At),e(Z),e(St),e(ws),e(Lt),e(Dt),e(qt),e(xs),e(Pt),e(Ot),e(Kt),e(Is),e(se),e(te),e(Xs),e(ee),e(le),e(ae),e(Ns),e(ne),e(ie),e(vs),e(pe),e(ce),e(Vs),e(he),e(oe),e($s),e(re),e(Me),e(ue),e(Fs),e(de),e(Je),e(ye),e(Ys),e(me),e(Es),e(Te),e(As),e(Ue),e(I),e(ge),e(R),e(je),e(Ss),e(we),e(X),e(be),e(fe),e(Ls),e(xe),e(Ze),e(Ge),e(Ks)),e(i),y(_,s),y(v,s),y($,s),y(Y,s),y(A,s),y(L,s),y(D,s),y(P,s),y(O,s),y(b,s),y(ts,s),y(f,s),y(ls,s),y(ns,s),y(ps,s),y(cs,s),y(Ms,s),y(ds,s),y(Js,s),y(ms,s),y(x,s),y(gs,s),y(bs,s),y(fs,s),y(Zs,s),y(Gs,s),y(Rs,s),y(Cs,s),y(ks,s),y(_s,s),y(zs,s),y(Bs,s),y(Ws,s),y(Hs,s),y(G,s),y(Qs,s),y(C,s),y(k,s),y(Ds,s)}}}const Hl='{"title":"Creating your own dataset","local":"creating-your-own-dataset","sections":[{"title":"Getting the data","local":"getting-the-data","sections":[],"depth":2},{"title":"Cleaning up the data","local":"cleaning-up-the-data","sections":[],"depth":2},{"title":"Augmenting the dataset","local":"augmenting-the-dataset","sections":[],"depth":2},{"title":"Uploading the dataset to the Hugging Face Hub","local":"uploading-the-dataset-to-the-hugging-face-hub","sections":[],"depth":2},{"title":"Creating a dataset card","local":"creating-a-dataset-card","sections":[],"depth":2}],"depth":1}';function Fl(g){return Zl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends Gl{constructor(i){super(),Il(this,i,Fl,Wl,xl,{})}}export{ql as component};
