import{s as rt,f as wl,n as it,o as Mt}from"../chunks/scheduler.37c15a92.js";import{S as pt,i as mt,g as o,s as a,r as m,A as ct,h as r,f as t,c as n,j as dl,u as c,x as i,k as p,y as ut,a as s,v as u,d as y,t as J,w as T}from"../chunks/index.2bf4358c.js";import{C as jl}from"../chunks/CodeBlock.4e987730.js";import{H as Je}from"../chunks/Heading.8ada512a.js";import{E as yt}from"../chunks/index.3b54d7fe.js";function Jt(Ul){let j,Te,ue,je,w,we,d,bl="En la última sección, aprendimos cómo podemos crear Agentes desde cero usando código Python, y <strong>vimos lo tedioso que puede ser ese proceso</strong>. Afortunadamente, muchas librerías de Agentes simplifican este trabajo <strong>manejando gran parte del trabajo pesado por ti</strong>.",de,U,hl="En este tutorial, <strong>crearás tu primer Agente</strong> capaz de realizar acciones como generación de imágenes, búsqueda web, verificación de zonas horarias y mucho más.",Ue,b,Il="También publicarás tu agente <strong>en un Space de Hugging Face para que puedas compartirlo con amigos y colegas</strong>.",be,h,Bl="¡Comencemos!",he,I,Ie,B,gl,Be,g,Cl="Para crear este Agente, vamos a usar <code>smolagents</code>, una librería que <strong>proporciona un marco para desarrollar tus agentes con facilidad</strong>.",ge,C,fl="Esta librería ligera está diseñada para ser simple, pero abstrae gran parte de la complejidad de construir un Agente, permitiéndote enfocarte en diseño el comportamiento de tu agente.",Ce,f,vl='Profundizaremos más en smolagents en la siguiente Unidad. Mientras tanto, también puedes consultar esta <a href="https://huggingface.co/blog/smolagents" target="_blank">publicación del blog</a> o el <a href="https://github.com/huggingface/smolagents" target="_blank">repositorio de la librería en GitHub</a>.',fe,v,Wl="En resumen, <code>smolagents</code> es una librería que se enfoca en <strong>codeAgent</strong>, un tipo de agente que realiza <strong>“Acciones”</strong> a través de bloques de código, y luego <strong>“Observa”</strong> los resultados ejecutando el código.",ve,W,Zl="¡Aquí un ejemplo de lo que construiremos!",We,Z,Gl="Proporcionamos a nuestro agente una <strong>herramienta de generación de imágenes</strong> y le pedimos que genere una imagen de un gato.",Ze,G,El="El agente dentro de <code>smolagents</code> va a tener los <strong>mismos comportamientos que el personalizado que construimos anteriormente</strong>: va a <strong>pensar, actuar y observar en ciclo</strong> hasta que llegue a una respuesta final:",Ge,M,Vl,Ee,E,Al="Emocionante, ¿cierto?",Ve,V,Ae,A,Hl='Para comenzar, duplica este Space: <a href="https://huggingface.co/spaces/agents-course/First_agent_template" target="_blank">https://huggingface.co/spaces/agents-course/First_agent_template</a>',He,H,_l='<p>¡Gracias a <a href="https://huggingface.co/m-ric" target="_blank">Aymeric</a> por esta plantilla! 🙌</p>',_e,_,zl="Duplicar este space significa <strong>crear una copia local en tu propio perfil</strong>:",ze,z,Sl,Se,S,kl='A lo largo de esta lección, el único archivo que necesitarás modificar es el (actualmente incompleto) <strong>“app.py”</strong>. Puedes ver aquí el <a href="https://huggingface.co/spaces/agents-course/First_agent_template/blob/main/app.py" rel="nofollow">original en la plantilla</a>. Para encontrar el tuyo, ve a tu copia del space, luego haz clic en la pestaña <code>Files</code> y luego en <code>app.py</code> en el listado de directorios.',ke,k,xl="Analicemos el código juntos:",xe,x,Rl="<li>El archivo comienza con algunas importaciones de bibliotecas simples pero necesarias</li>",Re,R,Qe,Q,Ql="Como se describió anteriormente, usaremos directamente la clase <strong>CodeAgent</strong> de <strong>smolagents</strong>.",Ye,Y,Xe,X,Yl='¡Ahora vamos con las herramientas! Si quieres un repaso sobre las herramientas, no dudes en volver a la sección <a href="tools">Herramientas</a> del curso.',Fe,F,Ne,N,Xl="Las Herramientas son lo que te estamos animando a construir en esta sección. Te damos dos ejemplos:",qe,q,Fl="<li>Una <strong>Herramienta ficticia que no funciona</strong> que puedes modificar para hacer algo útil.</li> <li>Una <strong>Herramienta que realmente funciona</strong> que obtiene la hora actual en algún lugar del mundo.</li>",$e,$,Nl="Para definir tu herramienta es importante:",Le,L,ql="<li>Proporcionar tipos de entrada y salida para tu función, como en <code>get_current_time_in_timezone(timezone: str) -&gt; str:</code></li> <li><strong>Un docstring formateado</strong>. <code>smolagents</code> espera que todos los argumentos tengan una <strong>descripción textual en el docstring</strong>.</li>",Pe,P,De,D,$l='Utiliza <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow"><code>Qwen/Qwen2.5-Coder-32B-Instruct</code></a> como motor LLM. Este es un modelo muy capaz al que accederemos a través de la API sin servidor.',Ke,K,Oe,O,Ll="¡Este Agente todavía usa el <code>InferenceClient</code> que vimos en una sección anterior detrás de la clase <strong>HfApiModel</strong>!",el,ee,Pl="Daremos ejemplos más detallados cuando presentemos el marco en la Unidad 2. Por ahora, debes enfocarte en <strong>agregar nuevas herramientas a la lista de herramientas</strong> usando el parámetro <code>tools</code> de tu Agente.",ll,le,Dl="Por ejemplo, podrías usar el <code>DuckDuckGoSearchTool</code> que se importó en la primera línea del código, o puedes examinar el <code>image_generation_tool</code> que se carga desde el Hub más adelante en el código.",tl,te,Kl="<strong>Agregar herramientas le dará a tu agente nuevas capacidades</strong>, ¡intenta ser creativo aquí!",sl,se,Ol="El “app.py” completo:",al,ae,nl,ne,et="Tu <strong>Objetivo</strong> es familiarizarte con el Space y el Agente.",ol,oe,lt="Actualmente, el agente en la plantilla <strong>no utiliza ninguna herramienta, así que intenta proporcionarle algunas de las prefabricadas o incluso crear algunas herramientas nuevas tú mismo.</strong>",rl,re,tt="¡Estamos esperando ansiosamente tus increíbles resultados de agentes en el canal de Discord <strong>#agents-course-showcase</strong>!",il,Ml,pl,ie,st="¡Felicidades, has construido tu primer Agente! No dudes en compartirlo con tus amigos y colegas.",ml,Me,at="Como este es tu primer intento, es perfectamente normal si es un poco inestable o lento. En futuras unidades, aprenderemos cómo construir Agentes aún mejores.",cl,pe,nt="La mejor manera de aprender es intentarlo, así que no dudes en actualizarlo, agregar más herramientas, probar con otro modelo, etc.",ul,me,ot="En la siguiente sección, completarás el Quiz final y obtendrás tu certificado.",yl,ce,Jl,ye,Tl;return w=new Je({props:{title:"Vamos Crear Nuestro Primer Agente Usando smolagents",local:"vamos-crear-nuestro-primer-agente-usando-smolagents",headingTag:"h1"}}),I=new Je({props:{title:"¿Qué es smolagents?",local:"qué-es-smolagents",headingTag:"h2"}}),V=new Je({props:{title:"¡Construyamos nuestro Agente!",local:"construyamos-nuestro-agente",headingTag:"h2"}}),R=new jl({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUyQyUyMEhmQXBpTW9kZWwlMkMlMjBsb2FkX3Rvb2wlMkMlMjB0b29sJTBBaW1wb3J0JTIwZGF0ZXRpbWUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWltcG9ydCUyMHB5dHolMEFpbXBvcnQlMjB5YW1sJTBBZnJvbSUyMHRvb2xzLmZpbmFsX2Fuc3dlciUyMGltcG9ydCUyMEZpbmFsQW5zd2VyVG9vbA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool`,wrap:!1}}),Y=new Je({props:{title:"Las Herramientas",local:"las-herramientas",headingTag:"h3"}}),F=new jl({props:{code:"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",highlighted:`<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># es importante especificar el tipo que se regresara</span>
    <span class="hljs-comment"># Mantén este formato para la descripción de la herramienta / descripción de args pero siéntete libre de modificar la herramienta</span>
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que aun no hace nada 
    Args:
        arg1: el primer argumento
        arg2: el segundo argumento
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;¿Qué magia construirás?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que obtiene la hora local actual en una zona horaria especificada.
    Args:
        timezone: Una cadena que representa una zona horaria válida (por ejemplo, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Crear objeto de zona horaria</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtener la hora actual en esa zona horaria</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;La hora local actual en <span class="hljs-subst">{timezone}</span> es: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error al obtener la hora para la zona horaria &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),P=new Je({props:{title:"El Agente",local:"el-agente",headingTag:"h3"}}),K=new jl({props:{code:"ZmluYWxfYW5zd2VyJTIwJTNEJTIwRmluYWxBbnN3ZXJUb29sKCklMEFtb2RlbCUyMCUzRCUyMEhmQXBpTW9kZWwoJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDIwOTYlMkMlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTNEJ1F3ZW4lMkZRd2VuMi41LUNvZGVyLTMyQi1JbnN0cnVjdCclMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcm9sZV9jb252ZXJzaW9ucyUzRE5vbmUlMkMlMEEpJTBBJTBBd2l0aCUyMG9wZW4oJTIycHJvbXB0cy55YW1sJTIyJTJDJTIwJ3InKSUyMGFzJTIwc3RyZWFtJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUyMCUzRCUyMHlhbWwuc2FmZV9sb2FkKHN0cmVhbSklMEElMjAlMjAlMjAlMjAlMEElMjMlMjBFc3RhbW9zJTIwY3JlYW5kbyUyMG51ZXN0cm8lMjBDb2RlQWdlbnQlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJmaW5hbF9hbnN3ZXIlNUQlMkMlMjAlMjMlMjBhJUMzJUIxYWRlJTIwdHVzJTIwaGVycmFtaWVudGFzJTIwYXF1JUMzJUFEJTIwKG5vJTIwZWxpbWluZXMlMjBmaW5hbF9hbnN3ZXIpJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNENiUyQyUwQSUyMCUyMCUyMCUyMHZlcmJvc2l0eV9sZXZlbCUzRDElMkMlMEElMjAlMjAlMjAlMjBncmFtbWFyJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHBsYW5uaW5nX2ludGVydmFsJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMG5hbWUlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RlbXBsYXRlcyUzRHByb21wdF90ZW1wbGF0ZXMlMEEpJTBBJTBBR3JhZGlvVUkoYWdlbnQpLmxhdW5jaCgp",highlighted:`final_answer = FinalAnswerTool()
model = HfApiModel(
    max_tokens=<span class="hljs-number">2096</span>,
    temperature=<span class="hljs-number">0.5</span>,
    model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
    custom_role_conversions=<span class="hljs-literal">None</span>,
)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
<span class="hljs-comment"># Estamos creando nuestro CodeAgent</span>
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># añade tus herramientas aquí (no elimines final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)

GradioUI(agent).launch()`,wrap:!1}}),ae=new jl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, DuckDuckGoSearchTool, HfApiModel, load_tool, tool
<span class="hljs-keyword">import</span> datetime
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> pytz
<span class="hljs-keyword">import</span> yaml
<span class="hljs-keyword">from</span> tools.final_answer <span class="hljs-keyword">import</span> FinalAnswerTool

<span class="hljs-keyword">from</span> Gradio_UI <span class="hljs-keyword">import</span> GradioUI

<span class="hljs-comment"># A continuación hay un ejemplo de una herramienta que no hace nada. ¡Sorpréndenos con tu creatividad!</span>
<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_custom_tool</span>(<span class="hljs-params">arg1:<span class="hljs-built_in">str</span>, arg2:<span class="hljs-built_in">int</span></span>)-&gt; <span class="hljs-built_in">str</span>: <span class="hljs-comment"># es importante especificar el tipo de retorno</span>
    <span class="hljs-comment"># Mantén este formato para la descripción de la herramienta / descripción de args pero siéntete libre de modificar la herramienta</span>
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que aún no hace nada 
    Args:
        arg1: el primer argumento
        arg2: el segundo argumento
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;¿Qué magia construirás?&quot;</span>

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_time_in_timezone</span>(<span class="hljs-params">timezone: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Una herramienta que obtiene la hora local actual en una zona horaria especificada.
    Args:
        timezone: Una cadena que representa una zona horaria válida (por ejemplo, &#x27;America/New_York&#x27;).
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Crear objeto de zona horaria</span>
        tz = pytz.timezone(timezone)
        <span class="hljs-comment"># Obtener la hora actual en esa zona horaria</span>
        local_time = datetime.datetime.now(tz).strftime(<span class="hljs-string">&quot;%Y-%m-%d %H:%M:%S&quot;</span>)
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;La hora local actual en <span class="hljs-subst">{timezone}</span> es: <span class="hljs-subst">{local_time}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error al obtener la hora para la zona horaria &#x27;<span class="hljs-subst">{timezone}</span>&#x27;: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>


final_answer = FinalAnswerTool()
model = HfApiModel(
max_tokens=<span class="hljs-number">2096</span>,
temperature=<span class="hljs-number">0.5</span>,
model_id=<span class="hljs-string">&#x27;Qwen/Qwen2.5-Coder-32B-Instruct&#x27;</span>,
custom_role_conversions=<span class="hljs-literal">None</span>,
)


<span class="hljs-comment"># Importar herramienta desde Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;agents-course/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;prompts.yaml&quot;</span>, <span class="hljs-string">&#x27;r&#x27;</span>) <span class="hljs-keyword">as</span> stream:
    prompt_templates = yaml.safe_load(stream)
    
agent = CodeAgent(
    model=model,
    tools=[final_answer], <span class="hljs-comment"># añade tus herramientas aquí (no elimines final_answer)</span>
    max_steps=<span class="hljs-number">6</span>,
    verbosity_level=<span class="hljs-number">1</span>,
    grammar=<span class="hljs-literal">None</span>,
    planning_interval=<span class="hljs-literal">None</span>,
    name=<span class="hljs-literal">None</span>,
    description=<span class="hljs-literal">None</span>,
    prompt_templates=prompt_templates
)


GradioUI(agent).launch()`,wrap:!1}}),ce=new yt({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/es/unit1/tutorial.mdx"}}),{c(){j=o("meta"),Te=a(),ue=o("p"),je=a(),m(w.$$.fragment),we=a(),d=o("p"),d.innerHTML=bl,de=a(),U=o("p"),U.innerHTML=hl,Ue=a(),b=o("p"),b.innerHTML=Il,be=a(),h=o("p"),h.textContent=Bl,he=a(),m(I.$$.fragment),Ie=a(),B=o("img"),Be=a(),g=o("p"),g.innerHTML=Cl,ge=a(),C=o("p"),C.textContent=fl,Ce=a(),f=o("p"),f.innerHTML=vl,fe=a(),v=o("p"),v.innerHTML=Wl,ve=a(),W=o("p"),W.textContent=Zl,We=a(),Z=o("p"),Z.innerHTML=Gl,Ze=a(),G=o("p"),G.innerHTML=El,Ge=a(),M=o("iframe"),Ee=a(),E=o("p"),E.textContent=Al,Ve=a(),m(V.$$.fragment),Ae=a(),A=o("p"),A.innerHTML=Hl,He=a(),H=o("blockquote"),H.innerHTML=_l,_e=a(),_=o("p"),_.innerHTML=zl,ze=a(),z=o("img"),Se=a(),S=o("p"),S.innerHTML=kl,ke=a(),k=o("p"),k.textContent=xl,xe=a(),x=o("ul"),x.innerHTML=Rl,Re=a(),m(R.$$.fragment),Qe=a(),Q=o("p"),Q.innerHTML=Ql,Ye=a(),m(Y.$$.fragment),Xe=a(),X=o("p"),X.innerHTML=Yl,Fe=a(),m(F.$$.fragment),Ne=a(),N=o("p"),N.textContent=Xl,qe=a(),q=o("ol"),q.innerHTML=Fl,$e=a(),$=o("p"),$.textContent=Nl,Le=a(),L=o("ol"),L.innerHTML=ql,Pe=a(),m(P.$$.fragment),De=a(),D=o("p"),D.innerHTML=$l,Ke=a(),m(K.$$.fragment),Oe=a(),O=o("p"),O.innerHTML=Ll,el=a(),ee=o("p"),ee.innerHTML=Pl,ll=a(),le=o("p"),le.innerHTML=Dl,tl=a(),te=o("p"),te.innerHTML=Kl,sl=a(),se=o("p"),se.textContent=Ol,al=a(),m(ae.$$.fragment),nl=a(),ne=o("p"),ne.innerHTML=et,ol=a(),oe=o("p"),oe.innerHTML=lt,rl=a(),re=o("p"),re.innerHTML=tt,il=a(),Ml=o("hr"),pl=a(),ie=o("p"),ie.textContent=st,ml=a(),Me=o("p"),Me.textContent=at,cl=a(),pe=o("p"),pe.textContent=nt,ul=a(),me=o("p"),me.textContent=ot,yl=a(),m(ce.$$.fragment),Jl=a(),ye=o("p"),this.h()},l(e){const l=ct("svelte-u9bgzb",document.head);j=r(l,"META",{name:!0,content:!0}),l.forEach(t),Te=n(e),ue=r(e,"P",{}),dl(ue).forEach(t),je=n(e),c(w.$$.fragment,e),we=n(e),d=r(e,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1k05pg6"&&(d.innerHTML=bl),de=n(e),U=r(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-tievl2"&&(U.innerHTML=hl),Ue=n(e),b=r(e,"P",{"data-svelte-h":!0}),i(b)!=="svelte-11b1hs9"&&(b.innerHTML=Il),be=n(e),h=r(e,"P",{"data-svelte-h":!0}),i(h)!=="svelte-z8wdc9"&&(h.textContent=Bl),he=n(e),c(I.$$.fragment,e),Ie=n(e),B=r(e,"IMG",{src:!0,alt:!0}),Be=n(e),g=r(e,"P",{"data-svelte-h":!0}),i(g)!=="svelte-zqt6ec"&&(g.innerHTML=Cl),ge=n(e),C=r(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-ibz603"&&(C.textContent=fl),Ce=n(e),f=r(e,"P",{"data-svelte-h":!0}),i(f)!=="svelte-1oz1fp9"&&(f.innerHTML=vl),fe=n(e),v=r(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1971uy4"&&(v.innerHTML=Wl),ve=n(e),W=r(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1kjiebb"&&(W.textContent=Zl),We=n(e),Z=r(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-1pdukv3"&&(Z.innerHTML=Gl),Ze=n(e),G=r(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1e49dxv"&&(G.innerHTML=El),Ge=n(e),M=r(e,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0,referrerpolicy:!0}),dl(M).forEach(t),Ee=n(e),E=r(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-160ich6"&&(E.textContent=Al),Ve=n(e),c(V.$$.fragment,e),Ae=n(e),A=r(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-x24dt4"&&(A.innerHTML=Hl),He=n(e),H=r(e,"BLOCKQUOTE",{"data-svelte-h":!0}),i(H)!=="svelte-1lt0ymi"&&(H.innerHTML=_l),_e=n(e),_=r(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-976dli"&&(_.innerHTML=zl),ze=n(e),z=r(e,"IMG",{src:!0,alt:!0}),Se=n(e),S=r(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-ahm5nq"&&(S.innerHTML=kl),ke=n(e),k=r(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-yy81s5"&&(k.textContent=xl),xe=n(e),x=r(e,"UL",{"data-svelte-h":!0}),i(x)!=="svelte-119fxux"&&(x.innerHTML=Rl),Re=n(e),c(R.$$.fragment,e),Qe=n(e),Q=r(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-mt70f8"&&(Q.innerHTML=Ql),Ye=n(e),c(Y.$$.fragment,e),Xe=n(e),X=r(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1ou7f4u"&&(X.innerHTML=Yl),Fe=n(e),c(F.$$.fragment,e),Ne=n(e),N=r(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1q83jk1"&&(N.textContent=Xl),qe=n(e),q=r(e,"OL",{"data-svelte-h":!0}),i(q)!=="svelte-1xx1ttu"&&(q.innerHTML=Fl),$e=n(e),$=r(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-fltuof"&&($.textContent=Nl),Le=n(e),L=r(e,"OL",{"data-svelte-h":!0}),i(L)!=="svelte-1mxmbql"&&(L.innerHTML=ql),Pe=n(e),c(P.$$.fragment,e),De=n(e),D=r(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-4qpjof"&&(D.innerHTML=$l),Ke=n(e),c(K.$$.fragment,e),Oe=n(e),O=r(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-1lzwc7j"&&(O.innerHTML=Ll),el=n(e),ee=r(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-10pkzke"&&(ee.innerHTML=Pl),ll=n(e),le=r(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-vla5kx"&&(le.innerHTML=Dl),tl=n(e),te=r(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-i0yzw0"&&(te.innerHTML=Kl),sl=n(e),se=r(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-kgrbhd"&&(se.textContent=Ol),al=n(e),c(ae.$$.fragment,e),nl=n(e),ne=r(e,"P",{"data-svelte-h":!0}),i(ne)!=="svelte-s8ocjr"&&(ne.innerHTML=et),ol=n(e),oe=r(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-1mir7mg"&&(oe.innerHTML=lt),rl=n(e),re=r(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-f30lju"&&(re.innerHTML=tt),il=n(e),Ml=r(e,"HR",{}),pl=n(e),ie=r(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-bgfucn"&&(ie.textContent=st),ml=n(e),Me=r(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1amxj21"&&(Me.textContent=at),cl=n(e),pe=r(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-nyg79v"&&(pe.textContent=nt),ul=n(e),me=r(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-1dldop1"&&(me.textContent=ot),yl=n(e),c(ce.$$.fragment,e),Jl=n(e),ye=r(e,"P",{}),dl(ye).forEach(t),this.h()},h(){p(j,"name","hf:doc:metadata"),p(j,"content",Tt),wl(B.src,gl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/smolagents.png")||p(B,"src",gl),p(B,"alt","smolagents"),p(M,"width","560"),p(M,"height","315"),wl(M.src,Vl="https://www.youtube.com/embed/PQDKcWiuln4?si=ysSTDZoi8y55FVvA")||p(M,"src",Vl),p(M,"title","YouTube video player"),p(M,"frameborder","0"),p(M,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"),p(M,"referrerpolicy","strict-origin-when-cross-origin"),M.allowFullscreen="",wl(z.src,Sl="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/duplicate-space.gif")||p(z,"src",Sl),p(z,"alt","Duplicate")},m(e,l){ut(document.head,j),s(e,Te,l),s(e,ue,l),s(e,je,l),u(w,e,l),s(e,we,l),s(e,d,l),s(e,de,l),s(e,U,l),s(e,Ue,l),s(e,b,l),s(e,be,l),s(e,h,l),s(e,he,l),u(I,e,l),s(e,Ie,l),s(e,B,l),s(e,Be,l),s(e,g,l),s(e,ge,l),s(e,C,l),s(e,Ce,l),s(e,f,l),s(e,fe,l),s(e,v,l),s(e,ve,l),s(e,W,l),s(e,We,l),s(e,Z,l),s(e,Ze,l),s(e,G,l),s(e,Ge,l),s(e,M,l),s(e,Ee,l),s(e,E,l),s(e,Ve,l),u(V,e,l),s(e,Ae,l),s(e,A,l),s(e,He,l),s(e,H,l),s(e,_e,l),s(e,_,l),s(e,ze,l),s(e,z,l),s(e,Se,l),s(e,S,l),s(e,ke,l),s(e,k,l),s(e,xe,l),s(e,x,l),s(e,Re,l),u(R,e,l),s(e,Qe,l),s(e,Q,l),s(e,Ye,l),u(Y,e,l),s(e,Xe,l),s(e,X,l),s(e,Fe,l),u(F,e,l),s(e,Ne,l),s(e,N,l),s(e,qe,l),s(e,q,l),s(e,$e,l),s(e,$,l),s(e,Le,l),s(e,L,l),s(e,Pe,l),u(P,e,l),s(e,De,l),s(e,D,l),s(e,Ke,l),u(K,e,l),s(e,Oe,l),s(e,O,l),s(e,el,l),s(e,ee,l),s(e,ll,l),s(e,le,l),s(e,tl,l),s(e,te,l),s(e,sl,l),s(e,se,l),s(e,al,l),u(ae,e,l),s(e,nl,l),s(e,ne,l),s(e,ol,l),s(e,oe,l),s(e,rl,l),s(e,re,l),s(e,il,l),s(e,Ml,l),s(e,pl,l),s(e,ie,l),s(e,ml,l),s(e,Me,l),s(e,cl,l),s(e,pe,l),s(e,ul,l),s(e,me,l),s(e,yl,l),u(ce,e,l),s(e,Jl,l),s(e,ye,l),Tl=!0},p:it,i(e){Tl||(y(w.$$.fragment,e),y(I.$$.fragment,e),y(V.$$.fragment,e),y(R.$$.fragment,e),y(Y.$$.fragment,e),y(F.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(ae.$$.fragment,e),y(ce.$$.fragment,e),Tl=!0)},o(e){J(w.$$.fragment,e),J(I.$$.fragment,e),J(V.$$.fragment,e),J(R.$$.fragment,e),J(Y.$$.fragment,e),J(F.$$.fragment,e),J(P.$$.fragment,e),J(K.$$.fragment,e),J(ae.$$.fragment,e),J(ce.$$.fragment,e),Tl=!1},d(e){e&&(t(Te),t(ue),t(je),t(we),t(d),t(de),t(U),t(Ue),t(b),t(be),t(h),t(he),t(Ie),t(B),t(Be),t(g),t(ge),t(C),t(Ce),t(f),t(fe),t(v),t(ve),t(W),t(We),t(Z),t(Ze),t(G),t(Ge),t(M),t(Ee),t(E),t(Ve),t(Ae),t(A),t(He),t(H),t(_e),t(_),t(ze),t(z),t(Se),t(S),t(ke),t(k),t(xe),t(x),t(Re),t(Qe),t(Q),t(Ye),t(Xe),t(X),t(Fe),t(Ne),t(N),t(qe),t(q),t($e),t($),t(Le),t(L),t(Pe),t(De),t(D),t(Ke),t(Oe),t(O),t(el),t(ee),t(ll),t(le),t(tl),t(te),t(sl),t(se),t(al),t(nl),t(ne),t(ol),t(oe),t(rl),t(re),t(il),t(Ml),t(pl),t(ie),t(ml),t(Me),t(cl),t(pe),t(ul),t(me),t(yl),t(Jl),t(ye)),t(j),T(w,e),T(I,e),T(V,e),T(R,e),T(Y,e),T(F,e),T(P,e),T(K,e),T(ae,e),T(ce,e)}}}const Tt='{"title":"Vamos Crear Nuestro Primer Agente Usando smolagents","local":"vamos-crear-nuestro-primer-agente-usando-smolagents","sections":[{"title":"¿Qué es smolagents?","local":"qué-es-smolagents","sections":[],"depth":2},{"title":"¡Construyamos nuestro Agente!","local":"construyamos-nuestro-agente","sections":[{"title":"Las Herramientas","local":"las-herramientas","sections":[],"depth":3},{"title":"El Agente","local":"el-agente","sections":[],"depth":3}],"depth":2}],"depth":1}';function jt(Ul){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends pt{constructor(j){super(),mt(this,j,jt,Jt,rt,{})}}export{It as component};
