import{s as fs,o as Cs,n as Ts}from"../chunks/scheduler.37c15a92.js";import{S as vs,i as Zs,g as c,s as a,r,A as Is,h as M,f as s,c as n,j as bs,u as i,x as d,k as js,y as Bs,a as t,v as o,d as p,t as u,w as m,m as Js,n as ws}from"../chunks/index.2bf4358c.js";import{T as Us}from"../chunks/Tip.363c041f.js";import{Y as hs}from"../chunks/Youtube.1e50a667.js";import{C as y}from"../chunks/CodeBlock.4e987730.js";import{C as $s}from"../chunks/CourseFloatingBanner.6add7356.js";import{H as ge,E as Gs}from"../chunks/getInferenceSnippets.00b99042.js";function gs($e){let b,J="✏️ <strong>Essayez</strong> Modifiez la boucle d’entraînement précédente pour <em>finetuner</em> votre modèle sur le jeu de données SST-2.";return{c(){b=c("p"),b.innerHTML=J},l(w){b=M(w,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1dfxuon"&&(b.innerHTML=J)},m(w,U){t(w,b,U)},p:Ts,d(w){w&&s(b)}}}function ks($e){let b,J,w="tokenizer",U;return{c(){b=Js('⚠️ Afin de bénéficier de la rapidité offerte par les TPUs du Cloud, nous vous recommandons de rembourrer vos échantillons à une longueur fixe avec les arguments `padding="max_length"` et `max_length` du '),J=c("i"),J.textContent=w,U=Js(".")},l(j){b=ws(j,'⚠️ Afin de bénéficier de la rapidité offerte par les TPUs du Cloud, nous vous recommandons de rembourrer vos échantillons à une longueur fixe avec les arguments `padding="max_length"` et `max_length` du '),J=M(j,"I",{"data-svelte-h":!0}),d(J)!=="svelte-ymquwj"&&(J.textContent=w),U=ws(j,".")},m(j,h){t(j,b,h),t(j,J,h),t(j,U,h)},p:Ts,d(j){j&&(s(b),s(J),s(U))}}}function Xs($e){let b,J,w,U,j,h,C,ke,v,Xe,Z,zl="Maintenant nous allons voir comment obtenir les mêmes résultats que dans la dernière section sans utiliser la classe <code>Trainer</code>. Encore une fois, nous supposons que vous avez fait le traitement des données dans la section 2. Voici un court résumé couvrant tout ce dont vous aurez besoin :",We,I,Re,B,_e,$,Nl="Avant d’écrire réellement notre boucle d’entraînement, nous devons définir quelques objets. Les premiers sont les <em>dataloaders</em> que nous utiliserons pour itérer sur les batchs. Mais avant de pouvoir définir ces chargeurs de données, nous devons appliquer un peu de post-traitement à nos <code>tokenized_datasets</code>, pour prendre soin de certaines choses que le <code>Trainer</code> fait pour nous automatiquement. Spécifiquement, nous devons :",Ye,G,El="<li>supprimer les colonnes correspondant aux valeurs que le modèle n’attend pas (comme les colonnes <code>sentence1</code> et <code>sentence2</code>),</li> <li>renommer la colonne <code>label</code> en <code>labels</code> (parce que le modèle s’attend à ce que l’argument soit nommé <code>labels</code>),</li> <li>définir le format des jeux de données pour qu’ils retournent des tenseurs PyTorch au lieu de listes.</li>",Ve,g,xl="Notre <code>tokenized_datasets</code> a une méthode pour chacune de ces étapes :",Ae,k,ze,X,Fl="Nous pouvons alors vérifier que le résultat ne comporte que des colonnes que notre modèle acceptera :",Ne,W,Ee,R,Ql="Maintenant que cela est fait, nous pouvons facilement définir nos <em>dataloaders</em> :",xe,_,Fe,Y,Hl="Pour vérifier rapidement qu’il n’y a pas d’erreur dans le traitement des données, nous pouvons inspecter un batch comme celui-ci :",Qe,V,He,A,qe,z,ql="Notez que les formes réelles seront probablement légèrement différentes pour vous puisque nous avons défini <code>shuffle=True</code> pour le chargeur de données d’entraînement et que nous <em>paddons</em> à la longueur maximale dans le batch.",Se,N,Sl="Maintenant que nous en avons terminé avec le prétraitement des données (un objectif satisfaisant mais difficile à atteindre pour tout praticien d’apprentissage automatique), passons au modèle. Nous l’instancions exactement comme nous l’avons fait dans la section précédente :",Le,E,Ke,x,Ll="Pour s’assurer que tout se passera bien pendant l’entraînement, nous transmettons notre batch à ce modèle :",Pe,F,De,Q,Oe,H,Kl="Tous les modèles 🤗 <em>Transformers</em> renvoient la perte lorsque les <code>labels</code> sont fournis. Nous obtenons également les logits (deux pour chaque entrée de notre batch, donc un tenseur de taille 8 x 2).",el,q,Pl='Nous sommes presque prêts à écrire notre boucle d’entraînement ! Il nous manque juste deux choses : un optimiseur et un planificateur de taux d’apprentissage. Puisque nous essayons de reproduire à la main ce que fait la fonction <code>Trainer</code>, utilisons les mêmes paramètres par défaut. L’optimiseur utilisé par <code>Trainer</code> est <code>AdamW</code>, qui est le même qu’Adam, mais avec une torsion pour la régularisation par décroissance de poids (voir <a href="https://arxiv.org/abs/1711.05101" rel="nofollow"><em>Decoupled Weight Decay Regularization</em></a> par Ilya Loshchilov et Frank Hutter) :',ll,S,sl,L,Dl="Enfin, le planificateur du taux d’apprentissage utilisé par défaut est juste une décroissance linéaire de la valeur maximale (5e-5) à 0. Pour le définir correctement, nous devons connaître le nombre d’étapes d’entraînement que nous prendrons, qui est le nombre d’époques que nous voulons exécuter multiplié par le nombre de batch d’entraînement (qui est la longueur de notre <em>dataloader</em> d’entraînement). Le <code>Trainer</code> utilise trois époques par défaut, nous allons donc suivre ça :",tl,K,al,P,nl,D,rl,O,Ol="Une dernière chose : nous voulons utiliser le GPU si nous en avons un (sur un CPU, l’entraînement peut prendre plusieurs heures au lieu de quelques minutes). Pour ce faire, nous définissons un <code>device</code> sur lequel nous allons placer notre modèle et nos batchs :",il,ee,ol,le,pl,se,es="Nous sommes maintenant prêts à entraîner ! Pour avoir une idée du moment où l’entraînement sera terminé, nous ajoutons une barre de progression sur le nombre d’étapes d’entraînement, en utilisant la bibliothèque <code>tqdm</code> :",ul,te,ml,ae,ls="Vous pouvez voir que le cœur de la boucle d’entraînement ressemble beaucoup à celui de l’introduction. Nous n’avons pas demandé de rapport, donc cette boucle d’entraînement ne nous dira rien sur les résultats du modèle. Pour cela, nous devons ajouter une boucle d’évaluation.",cl,ne,Ml,re,ss="Comme nous l’avons fait précédemment, nous allons utiliser une métrique fournie par la bibliothèque 🤗 <em>Evaluate</em>. Nous avons déjà vu la méthode <code>metric.compute()</code>, mais les métriques peuvent en fait accumuler des batchs pour nous au fur et à mesure que nous parcourons la boucle de prédiction avec la méthode <code>add_batch()</code>. Une fois que nous avons accumulé tous les batchs, nous pouvons obtenir le résultat final avec <code>metric.compute()</code>. Voici comment implémenter tout cela dans une boucle d’évaluation :",dl,ie,yl,oe,bl,pe,ts="Une fois encore, vos résultats seront légèrement différents en raison du caractère aléatoire de l’initialisation de la tête du modèle et du mélange des données, mais ils devraient se situer dans la même fourchette.",jl,T,Jl,ue,wl,me,Ul,ce,as='La boucle d’entraînement que nous avons définie précédemment fonctionne bien sur un seul CPU ou GPU. Mais en utilisant la bibliothèque <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 <em>Accelerate</em></a>, il suffit de quelques ajustements pour permettre un entraînement distribué sur plusieurs GPUs ou TPUs. En partant de la création des <em>dataloaders</em> d’entraînement et de validation, voici à quoi ressemble notre boucle d’entraînement manuel :',hl,Me,Tl,de,ns="Et voici les changements :",fl,ye,Cl,be,rs="La première ligne à ajouter est la ligne d’importation. La deuxième ligne instancie un objet <code>Accelerator</code> qui va regarder l’environnement et initialiser la bonne configuration distribuée. 🤗 <em>Accelerate</em> gère le placement des périphériques pour vous, donc vous pouvez enlever les lignes qui placent le modèle sur le périphérique (ou, si vous préférez, les changer pour utiliser <code>accelerator.device</code> au lieu de <code>device</code>).",vl,je,is="Ensuite, le gros du travail est fait dans la ligne qui envoie les <em>dataloaders</em>, le modèle, et l’optimiseur à <code>accelerator.prepare()</code>. Cela va envelopper ces objets dans le conteneur approprié pour s’assurer que votre entraînement distribué fonctionne comme prévu. Les changements restants à faire sont la suppression de la ligne qui met le batch sur le <code>device</code> (encore une fois, si vous voulez le garder, vous pouvez juste le changer pour utiliser <code>accelerator.device</code>) et le remplacement de <code>loss.backward()</code> par <code>accelerator.backward(loss)</code>.",Zl,f,Il,Je,os="Si vous souhaitez faire un copier-coller pour jouer, voici à quoi ressemble la boucle d’entraînement complète avec 🤗 <i>Accelerate</i> :",Bl,we,$l,Ue,ps="En plaçant ceci dans un script <code>train.py</code>, cela sera exécutable sur n’importe quel type d’installation distribuée. Pour l’essayer dans votre installation distribuée, exécutez la commande :",Gl,he,gl,Te,us="qui vous demandera de répondre à quelques questions et enregistrera vos réponses dans un fichier de configuration utilisé par cette commande :",kl,fe,Xl,Ce,ms="qui lancera l’entraînement distribué.",Wl,ve,cs="Si vous voulez essayer ceci dans un <em>notebook</em> (par exemple, pour le tester avec des TPUs sur Colab), collez simplement le code dans une <code>training_function()</code> et lancez une dernière cellule avec :",Rl,Ze,_l,Ie,Ms='Vous trouverez d’autres exemples dans le dépôt d’<a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 <em>Accelerate</em></a>.',Yl,Be,Vl,Ge,Al;return j=new ge({props:{title:"Un entraînement complet",local:"un-entraînement-complet",headingTag:"h1"}}),C=new $s({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter3/section4.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section4.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter3/section4.ipynb"}]}}),v=new hs({props:{id:"Dh9CL8fyG80"}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),B=new ge({props:{title:"Préparer l’entraînement",local:"préparer-lentraînement",headingTag:"h3"}}),k=new y({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),W=new y({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),_=new y({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),V=new y({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),A=new y({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),E=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),Q=new y({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),S=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),K=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),P=new y({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),D=new ge({props:{title:"La boucle d’entraînement",local:"la-boucle-dentraînement",headingTag:"h3"}}),ee=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),le=new y({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),te=new y({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ne=new ge({props:{title:"La boucle d’évaluation",local:"la-boucle-dévaluation",headingTag:"h3"}}),ie=new y({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),oe=new y({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),T=new Us({props:{$$slots:{default:[gs]},$$scope:{ctx:$e}}}),ue=new ge({props:{title:"Optimisez votre boucle d’entraînement avec 🤗 <i> Accelerate </i>",local:"optimisez-votre-boucle-dentraînement-avec--i-accelerate-i",headingTag:"h3"}}),me=new hs({props:{id:"s7dy8QRgjJ0"}}),Me=new y({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ye=new y({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from torch.optim import AdamW
  from transformers import AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),f=new Us({props:{$$slots:{default:[ks]},$$scope:{ctx:$e}}}),we=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0b3JjaC5vcHRpbSUyMGltcG9ydCUyMEFkYW1XJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),he=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),fe=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Ze=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),Be=new Gs({props:{source:"https://github.com/huggingface/course/blob/main/chapters/fr/chapter3/4.mdx"}}),{c(){b=c("meta"),J=a(),w=c("p"),U=a(),r(j.$$.fragment),h=a(),r(C.$$.fragment),ke=a(),r(v.$$.fragment),Xe=a(),Z=c("p"),Z.innerHTML=zl,We=a(),r(I.$$.fragment),Re=a(),r(B.$$.fragment),_e=a(),$=c("p"),$.innerHTML=Nl,Ye=a(),G=c("ul"),G.innerHTML=El,Ve=a(),g=c("p"),g.innerHTML=xl,Ae=a(),r(k.$$.fragment),ze=a(),X=c("p"),X.textContent=Fl,Ne=a(),r(W.$$.fragment),Ee=a(),R=c("p"),R.innerHTML=Ql,xe=a(),r(_.$$.fragment),Fe=a(),Y=c("p"),Y.textContent=Hl,Qe=a(),r(V.$$.fragment),He=a(),r(A.$$.fragment),qe=a(),z=c("p"),z.innerHTML=ql,Se=a(),N=c("p"),N.textContent=Sl,Le=a(),r(E.$$.fragment),Ke=a(),x=c("p"),x.textContent=Ll,Pe=a(),r(F.$$.fragment),De=a(),r(Q.$$.fragment),Oe=a(),H=c("p"),H.innerHTML=Kl,el=a(),q=c("p"),q.innerHTML=Pl,ll=a(),r(S.$$.fragment),sl=a(),L=c("p"),L.innerHTML=Dl,tl=a(),r(K.$$.fragment),al=a(),r(P.$$.fragment),nl=a(),r(D.$$.fragment),rl=a(),O=c("p"),O.innerHTML=Ol,il=a(),r(ee.$$.fragment),ol=a(),r(le.$$.fragment),pl=a(),se=c("p"),se.innerHTML=es,ul=a(),r(te.$$.fragment),ml=a(),ae=c("p"),ae.textContent=ls,cl=a(),r(ne.$$.fragment),Ml=a(),re=c("p"),re.innerHTML=ss,dl=a(),r(ie.$$.fragment),yl=a(),r(oe.$$.fragment),bl=a(),pe=c("p"),pe.textContent=ts,jl=a(),r(T.$$.fragment),Jl=a(),r(ue.$$.fragment),wl=a(),r(me.$$.fragment),Ul=a(),ce=c("p"),ce.innerHTML=as,hl=a(),r(Me.$$.fragment),Tl=a(),de=c("p"),de.textContent=ns,fl=a(),r(ye.$$.fragment),Cl=a(),be=c("p"),be.innerHTML=rs,vl=a(),je=c("p"),je.innerHTML=is,Zl=a(),r(f.$$.fragment),Il=a(),Je=c("p"),Je.innerHTML=os,Bl=a(),r(we.$$.fragment),$l=a(),Ue=c("p"),Ue.innerHTML=ps,Gl=a(),r(he.$$.fragment),gl=a(),Te=c("p"),Te.textContent=us,kl=a(),r(fe.$$.fragment),Xl=a(),Ce=c("p"),Ce.textContent=ms,Wl=a(),ve=c("p"),ve.innerHTML=cs,Rl=a(),r(Ze.$$.fragment),_l=a(),Ie=c("p"),Ie.innerHTML=Ms,Yl=a(),r(Be.$$.fragment),Vl=a(),Ge=c("p"),this.h()},l(e){const l=Is("svelte-u9bgzb",document.head);b=M(l,"META",{name:!0,content:!0}),l.forEach(s),J=n(e),w=M(e,"P",{}),bs(w).forEach(s),U=n(e),i(j.$$.fragment,e),h=n(e),i(C.$$.fragment,e),ke=n(e),i(v.$$.fragment,e),Xe=n(e),Z=M(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1g0xmca"&&(Z.innerHTML=zl),We=n(e),i(I.$$.fragment,e),Re=n(e),i(B.$$.fragment,e),_e=n(e),$=M(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-17hvgx4"&&($.innerHTML=Nl),Ye=n(e),G=M(e,"UL",{"data-svelte-h":!0}),d(G)!=="svelte-s8mdl4"&&(G.innerHTML=El),Ve=n(e),g=M(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-1vhf3m8"&&(g.innerHTML=xl),Ae=n(e),i(k.$$.fragment,e),ze=n(e),X=M(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1jligxe"&&(X.textContent=Fl),Ne=n(e),i(W.$$.fragment,e),Ee=n(e),R=M(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-15ft7dc"&&(R.innerHTML=Ql),xe=n(e),i(_.$$.fragment,e),Fe=n(e),Y=M(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1rk3y8n"&&(Y.textContent=Hl),Qe=n(e),i(V.$$.fragment,e),He=n(e),i(A.$$.fragment,e),qe=n(e),z=M(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-hfva83"&&(z.innerHTML=ql),Se=n(e),N=M(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-hgf9jd"&&(N.textContent=Sl),Le=n(e),i(E.$$.fragment,e),Ke=n(e),x=M(e,"P",{"data-svelte-h":!0}),d(x)!=="svelte-mg010b"&&(x.textContent=Ll),Pe=n(e),i(F.$$.fragment,e),De=n(e),i(Q.$$.fragment,e),Oe=n(e),H=M(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-iwaa2x"&&(H.innerHTML=Kl),el=n(e),q=M(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-ahwb4"&&(q.innerHTML=Pl),ll=n(e),i(S.$$.fragment,e),sl=n(e),L=M(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-wgcpmp"&&(L.innerHTML=Dl),tl=n(e),i(K.$$.fragment,e),al=n(e),i(P.$$.fragment,e),nl=n(e),i(D.$$.fragment,e),rl=n(e),O=M(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-rbvecl"&&(O.innerHTML=Ol),il=n(e),i(ee.$$.fragment,e),ol=n(e),i(le.$$.fragment,e),pl=n(e),se=M(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-unj8ze"&&(se.innerHTML=es),ul=n(e),i(te.$$.fragment,e),ml=n(e),ae=M(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-w5chrh"&&(ae.textContent=ls),cl=n(e),i(ne.$$.fragment,e),Ml=n(e),re=M(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-as7rjs"&&(re.innerHTML=ss),dl=n(e),i(ie.$$.fragment,e),yl=n(e),i(oe.$$.fragment,e),bl=n(e),pe=M(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-h5j4wt"&&(pe.textContent=ts),jl=n(e),i(T.$$.fragment,e),Jl=n(e),i(ue.$$.fragment,e),wl=n(e),i(me.$$.fragment,e),Ul=n(e),ce=M(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-159rzx0"&&(ce.innerHTML=as),hl=n(e),i(Me.$$.fragment,e),Tl=n(e),de=M(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-3jm87s"&&(de.textContent=ns),fl=n(e),i(ye.$$.fragment,e),Cl=n(e),be=M(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1uypok9"&&(be.innerHTML=rs),vl=n(e),je=M(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-13ypbak"&&(je.innerHTML=is),Zl=n(e),i(f.$$.fragment,e),Il=n(e),Je=M(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1t4du1b"&&(Je.innerHTML=os),Bl=n(e),i(we.$$.fragment,e),$l=n(e),Ue=M(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-dkpmec"&&(Ue.innerHTML=ps),Gl=n(e),i(he.$$.fragment,e),gl=n(e),Te=M(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1qilg93"&&(Te.textContent=us),kl=n(e),i(fe.$$.fragment,e),Xl=n(e),Ce=M(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-16tpdes"&&(Ce.textContent=ms),Wl=n(e),ve=M(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1whbz23"&&(ve.innerHTML=cs),Rl=n(e),i(Ze.$$.fragment,e),_l=n(e),Ie=M(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1qnllaj"&&(Ie.innerHTML=Ms),Yl=n(e),i(Be.$$.fragment,e),Vl=n(e),Ge=M(e,"P",{}),bs(Ge).forEach(s),this.h()},h(){js(b,"name","hf:doc:metadata"),js(b,"content",Ws)},m(e,l){Bs(document.head,b),t(e,J,l),t(e,w,l),t(e,U,l),o(j,e,l),t(e,h,l),o(C,e,l),t(e,ke,l),o(v,e,l),t(e,Xe,l),t(e,Z,l),t(e,We,l),o(I,e,l),t(e,Re,l),o(B,e,l),t(e,_e,l),t(e,$,l),t(e,Ye,l),t(e,G,l),t(e,Ve,l),t(e,g,l),t(e,Ae,l),o(k,e,l),t(e,ze,l),t(e,X,l),t(e,Ne,l),o(W,e,l),t(e,Ee,l),t(e,R,l),t(e,xe,l),o(_,e,l),t(e,Fe,l),t(e,Y,l),t(e,Qe,l),o(V,e,l),t(e,He,l),o(A,e,l),t(e,qe,l),t(e,z,l),t(e,Se,l),t(e,N,l),t(e,Le,l),o(E,e,l),t(e,Ke,l),t(e,x,l),t(e,Pe,l),o(F,e,l),t(e,De,l),o(Q,e,l),t(e,Oe,l),t(e,H,l),t(e,el,l),t(e,q,l),t(e,ll,l),o(S,e,l),t(e,sl,l),t(e,L,l),t(e,tl,l),o(K,e,l),t(e,al,l),o(P,e,l),t(e,nl,l),o(D,e,l),t(e,rl,l),t(e,O,l),t(e,il,l),o(ee,e,l),t(e,ol,l),o(le,e,l),t(e,pl,l),t(e,se,l),t(e,ul,l),o(te,e,l),t(e,ml,l),t(e,ae,l),t(e,cl,l),o(ne,e,l),t(e,Ml,l),t(e,re,l),t(e,dl,l),o(ie,e,l),t(e,yl,l),o(oe,e,l),t(e,bl,l),t(e,pe,l),t(e,jl,l),o(T,e,l),t(e,Jl,l),o(ue,e,l),t(e,wl,l),o(me,e,l),t(e,Ul,l),t(e,ce,l),t(e,hl,l),o(Me,e,l),t(e,Tl,l),t(e,de,l),t(e,fl,l),o(ye,e,l),t(e,Cl,l),t(e,be,l),t(e,vl,l),t(e,je,l),t(e,Zl,l),o(f,e,l),t(e,Il,l),t(e,Je,l),t(e,Bl,l),o(we,e,l),t(e,$l,l),t(e,Ue,l),t(e,Gl,l),o(he,e,l),t(e,gl,l),t(e,Te,l),t(e,kl,l),o(fe,e,l),t(e,Xl,l),t(e,Ce,l),t(e,Wl,l),t(e,ve,l),t(e,Rl,l),o(Ze,e,l),t(e,_l,l),t(e,Ie,l),t(e,Yl,l),o(Be,e,l),t(e,Vl,l),t(e,Ge,l),Al=!0},p(e,[l]){const ds={};l&2&&(ds.$$scope={dirty:l,ctx:e}),T.$set(ds);const ys={};l&2&&(ys.$$scope={dirty:l,ctx:e}),f.$set(ys)},i(e){Al||(p(j.$$.fragment,e),p(C.$$.fragment,e),p(v.$$.fragment,e),p(I.$$.fragment,e),p(B.$$.fragment,e),p(k.$$.fragment,e),p(W.$$.fragment,e),p(_.$$.fragment,e),p(V.$$.fragment,e),p(A.$$.fragment,e),p(E.$$.fragment,e),p(F.$$.fragment,e),p(Q.$$.fragment,e),p(S.$$.fragment,e),p(K.$$.fragment,e),p(P.$$.fragment,e),p(D.$$.fragment,e),p(ee.$$.fragment,e),p(le.$$.fragment,e),p(te.$$.fragment,e),p(ne.$$.fragment,e),p(ie.$$.fragment,e),p(oe.$$.fragment,e),p(T.$$.fragment,e),p(ue.$$.fragment,e),p(me.$$.fragment,e),p(Me.$$.fragment,e),p(ye.$$.fragment,e),p(f.$$.fragment,e),p(we.$$.fragment,e),p(he.$$.fragment,e),p(fe.$$.fragment,e),p(Ze.$$.fragment,e),p(Be.$$.fragment,e),Al=!0)},o(e){u(j.$$.fragment,e),u(C.$$.fragment,e),u(v.$$.fragment,e),u(I.$$.fragment,e),u(B.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(A.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(K.$$.fragment,e),u(P.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(T.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(f.$$.fragment,e),u(we.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(Ze.$$.fragment,e),u(Be.$$.fragment,e),Al=!1},d(e){e&&(s(J),s(w),s(U),s(h),s(ke),s(Xe),s(Z),s(We),s(Re),s(_e),s($),s(Ye),s(G),s(Ve),s(g),s(Ae),s(ze),s(X),s(Ne),s(Ee),s(R),s(xe),s(Fe),s(Y),s(Qe),s(He),s(qe),s(z),s(Se),s(N),s(Le),s(Ke),s(x),s(Pe),s(De),s(Oe),s(H),s(el),s(q),s(ll),s(sl),s(L),s(tl),s(al),s(nl),s(rl),s(O),s(il),s(ol),s(pl),s(se),s(ul),s(ml),s(ae),s(cl),s(Ml),s(re),s(dl),s(yl),s(bl),s(pe),s(jl),s(Jl),s(wl),s(Ul),s(ce),s(hl),s(Tl),s(de),s(fl),s(Cl),s(be),s(vl),s(je),s(Zl),s(Il),s(Je),s(Bl),s($l),s(Ue),s(Gl),s(gl),s(Te),s(kl),s(Xl),s(Ce),s(Wl),s(ve),s(Rl),s(_l),s(Ie),s(Yl),s(Vl),s(Ge)),s(b),m(j,e),m(C,e),m(v,e),m(I,e),m(B,e),m(k,e),m(W,e),m(_,e),m(V,e),m(A,e),m(E,e),m(F,e),m(Q,e),m(S,e),m(K,e),m(P,e),m(D,e),m(ee,e),m(le,e),m(te,e),m(ne,e),m(ie,e),m(oe,e),m(T,e),m(ue,e),m(me,e),m(Me,e),m(ye,e),m(f,e),m(we,e),m(he,e),m(fe,e),m(Ze,e),m(Be,e)}}}const Ws='{"title":"Un entraînement complet","local":"un-entraînement-complet","sections":[{"title":"Préparer l’entraînement","local":"préparer-lentraînement","sections":[],"depth":3},{"title":"La boucle d’entraînement","local":"la-boucle-dentraînement","sections":[],"depth":3},{"title":"La boucle d’évaluation","local":"la-boucle-dévaluation","sections":[],"depth":3},{"title":"Optimisez votre boucle d’entraînement avec 🤗 <i> Accelerate </i>","local":"optimisez-votre-boucle-dentraînement-avec--i-accelerate-i","sections":[],"depth":3}],"depth":1}';function Rs($e){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xs extends vs{constructor(b){super(),Zs(this,b,Rs,Xs,fs,{})}}export{xs as component};
