import{s as yn,f as Ae,n as vn,o as Tn}from"../chunks/scheduler.37c15a92.js";import{S as jn,i as Un,g as i,s,r as p,A as xn,h as a,f as l,c as o,j as bn,u as h,x as r,k as M,y as Jn,a as n,v as m,d,t as c,w as u}from"../chunks/index.7cb9c9b8.js";import{C as Ee}from"../chunks/CodeBlock.a6d3f852.js";import{H as f,E as _n}from"../chunks/EditOnGithub.858acfec.js";function Gn(cl){let g,Qe,He,Ne,w,Ye,b,ul='<a href="https://github.com/edbeeching/godot_rl_agents" rel="nofollow">Godot RL Agents</a> is an Open Source package that allows video game creators, AI researchers, and hobbyists the opportunity <strong>to learn complex behaviors for their Non Player Characters or agents</strong>.',ze,y,Ml="The library provides:",Fe,v,fl='<li>An interface between games created in the <a href="https://godotengine.org/" rel="nofollow">Godot Engine</a> and Machine Learning algorithms running in Python</li> <li>Wrappers for four well known rl frameworks: <a href="https://stable-baselines3.readthedocs.io/en/master/" rel="nofollow">StableBaselines3</a>, <a href="https://docs.cleanrl.dev/" rel="nofollow">CleanRL</a>, <a href="https://www.samplefactory.dev/" rel="nofollow">Sample Factory</a> and <a href="https://docs.ray.io/en/latest/rllib-algorithms.html" rel="nofollow">Ray RLLib</a></li> <li>Support for memory-based agents with LSTM or attention based interfaces</li> <li>Support for <em>2D and 3D games</em></li> <li>A suite of <em>AI sensors</em> to augment your agent’s capacity to observe the game world</li> <li>Godot and Godot RL Agents are <strong>completely free and open source under a very permissive MIT license</strong>. No strings attached, no royalties, nothing.</li>',Ve,T,gl='You can find out more about Godot RL agents on their <a href="https://github.com/edbeeching/godot_rl_agents" rel="nofollow">GitHub page</a> or their AAAI-2022 Workshop <a href="https://arxiv.org/abs/2112.03636" rel="nofollow">paper</a>. The library’s creator, <a href="https://edbeeching.github.io/" rel="nofollow">Ed Beeching</a>, is a Research Scientist here at Hugging Face.',Pe,j,wl="Installation of the library is simple: <code>pip install godot-rl</code>",qe,U,De,x,bl="In this section, you will <strong>learn how to create a custom environment in the Godot Game Engine</strong> and then implement an AI controller that learns to play with Deep Reinforcement Learning.",Oe,J,yl="The example game we create today is simple, <strong>but shows off many of the features of the Godot Engine and the Godot RL Agents library</strong>. You can then dive into the examples for more complex environments and behaviors.",Ke,_,vl="The environment we will be building today is called Ring Pong, the game of pong but the pitch is a ring and the paddle moves around the ring. The <strong>objective is to keep the ball bouncing inside the ring</strong>.",et,G,Tl,tt,C,lt,I,jl='The <a href="https://godotengine.org/" rel="nofollow">Godot game engine</a> is an open source tool for the <strong>creation of video games, tools and user interfaces</strong>.',nt,Z,Ul="Godot Engine is a feature-packed, cross-platform game engine designed to create 2D and 3D games from a unified interface. It provides a comprehensive set of common tools, so users <strong>can focus on making games without having to reinvent the wheel</strong>. Games can be exported in one click to a number of platforms, including the major desktop platforms (Linux, macOS, Windows) as well as mobile (Android, iOS) and web-based (HTML5) platforms.",st,k,xl='While we will guide you through the steps to implement your agent, you may wish to learn more about the Godot Game Engine. Their <a href="https://docs.godotengine.org/en/latest/index.html" rel="nofollow">documentation</a> is thorough, and there are many tutorials on YouTube we would also recommend <a href="https://www.gdquest.com/" rel="nofollow">GDQuest</a>, <a href="https://kidscancode.org/godot_recipes/4.x/" rel="nofollow">KidsCanCode</a> and <a href="https://www.youtube.com/channel/UCczi7Aq_dTKrQPF5ZV5J3gg" rel="nofollow">Bramwell</a> as sources of information.',ot,B,Jl="In order to create games in Godot, <strong>you must first download the editor</strong>. Godot RL Agents supports the latest version of Godot, Godot 4.0.",it,L,_l="Which can be downloaded at the following links:",at,S,Gl='<li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_win64.exe.zip" rel="nofollow">Windows</a></li> <li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_macos.universal.zip" rel="nofollow">Mac</a></li> <li><a href="https://downloads.tuxfamily.org/godotengine/4.0.1/Godot_v4.0.1-stable_linux.x86_64.zip" rel="nofollow">Linux</a></li>',rt,R,pt,$,Cl="We provide two versions of the codebase:",ht,W,Il='<li><a href="https://drive.google.com/file/d/1C7xd3TibJHlxFEJPBgBLpksgxrFZ3D8e/view?usp=share_link" rel="nofollow">A starter project, to download and follow along for this tutorial</a></li> <li><a href="https://drive.google.com/file/d/1k-b2Bu7uIA6poApbouX4c3sq98xqogpZ/view?usp=share_link" rel="nofollow">A final version of the project, for comparison and debugging.</a></li>',mt,A,Zl="To load the project, in the Godot Project Manager click <strong>Import</strong>, navigate to where the files are located and load the <strong>project.godot</strong> file.",dt,E,kl="If you press F5 or play in the editor, you should be able to play the game in human mode. There are several instances of the game running, this is because we want to speed up training our AI agent with many parallel environments.",ct,H,ut,X,Bl="The Godot RL Agents plugin can be installed from the Github repo or with the Godot Asset Lib in the editor.",Mt,Q,Ll="First click on the AssetLib and search for “rl”",ft,N,Sl,gt,Y,Rl="Then click on Godot RL Agents, click Download and unselect the LICENSE and README .md files. Then click install.",wt,z,$l,bt,F,Wl="The Godot RL Agents plugin is now downloaded to your machine. Now click on Project → Project settings and enable the addon:",yt,V,Al,vt,P,Tt,q,El="We now want to add an AI controller to our game. Open the player.tscn scene, on the left you should see a hierarchy of nodes that looks like this:",jt,D,Hl,Ut,O,Xl="Right click the <strong>Player</strong> node and click <strong>Add Child Node.</strong> There are many nodes listed here, search for AIController3D and create it.",xt,K,Ql,Jt,ee,Nl="The AI Controller Node should have been added to the scene tree, next to it is a scroll. Click on it to open the script that is attached to the AIController. The Godot game engine uses a scripting language called GDScript, which is syntactically similar to python. The script contains methods that need to be implemented in order to get our AI controller working.",_t,te,Gt,le,Yl="In order to implement these methods, we will need to create a class that inherits from AIController3D. This is easy to do in Godot, and is called “extending” a class.",Ct,ne,zl="Right click the AIController3D Node and click “Extend Script” and call the new script <code>controller.gd</code>. You should now have an almost empty script file that looks like this:",It,se,Zt,oe,Fl="We will now implement the 4 missing methods, delete this code, and replace it with the following:",kt,ie,Bt,ae,Vl="We have now defined the agent’s observation, which is the position and velocity of the ball in its local coordinate space. We have also defined the action space of the agent, which is a single continuous value ranging from -1 to +1.",Lt,re,Pl="The next step is to update the Player’s script to use the actions from the AIController, edit the Player’s script by clicking on the scroll next to the player node, update the code in <code>Player.gd</code> to the following:",St,pe,Rt,he,ql="We now need to synchronize between the game running in Godot and the neural network being trained in Python. Godot RL agents provides a node that does just that. Open the train.tscn scene, right click on the root node, and click “Add child node”. Then, search for “sync” and add a Godot RL Agents Sync node. This node handles the communication between Python and Godot over TCP.",$t,me,Dl="You can run training live in the editor, by first launching the python training with <code>gdrl</code>.",Wt,de,Ol="In this simple example, a reasonable policy is learned in several minutes. You may wish to speed up training, click on the Sync node in the train scene, and you will see there is a “Speed Up” property exposed in the editor:",At,ce,Kl,Et,ue,en="Try setting this property up to 8 to speed up training. This can be a great benefit on more complex environments, like the multi-player FPS we will learn about in the next chapter.",Ht,Me,Xt,fe,tn='<a href="https://github.com/edbeeching/godot_rl_agents/tree/main?tab=readme-ov-file#exporting-and-loading-your-trained-agent-in-onnx-format" rel="nofollow">Reference doc</a>',Qt,ge,ln="Let’s put aside the Godot editor for now. We’ll need to use terminals to run some commands in order to save models we trained.",Nt,we,nn="The latest version of the Godot RL library provides experimental support for onnx models with the Stable Baselines 3, rllib, and CleanRL training frameworks.",Yt,be,sn='For example, let’s use the Stable Baselines 3 as the framework. Train your agent using the <a href="https://github.com/edbeeching/godot_rl_agents/blob/main/examples/stable_baselines3_example.py" rel="nofollow">sb3 example</a> (<a href="https://github.com/edbeeching/godot_rl_agents/blob/main/docs/ADV_STABLE_BASELINES_3.md#train-a-model-from-scratch" rel="nofollow">instructions for using the script</a>), enabling the option <code>--onnx_export_path=model.onnx</code>',zt,ye,on="Below is an example command line to execute:",Ft,ve,Vt,Te,an="If things work correctly, you should see messages printed out in the terminal like below:",Pt,je,qt,Ue,rn='<p>If you encounter failures about import error in stable_baselines3_example script: “ImportError: cannot import name ‘export_model_as_onnx’ from ‘godot_rl.wrappers.onnx.stable_baselines_export’”, follow the answer in <a href="https://github.com/edbeeching/godot_rl_agents/issues/203" rel="nofollow">this issue</a> here.</p>',Dt,xe,pn="Now it’s time to switch back to the Godot editor, and hit PLAY on the top right corner. Once you hit that, the game scene will pop up showing AI training. In the meantime, the terminal will start to print out metrics. Wait for the training to finish, and if things work correctly, you should be able to find the file <code>model.onnx</code> in the Godot project directory.",Ot,Je,Kt,_e,hn="Now let’s apply this trained model to the game!",el,Ge,mn="In the Godot editor, find the Sync node in <code>train.tscn</code>:",tl,Ce,dn="<li>change the control mode to <code>Onnx Inference</code> from the dropdown</li> <li>set <code>Onnx Model Path</code> to the model file name, in our case here it’s <code>model.onnx</code></li>",ll,Ie,cn='To run this game, we need the mono version (i.e., the .NET version) of the Godot editor, you can download it from the Godot official page. We need to install <a href="https://dotnet.microsoft.com/en-us/download" rel="nofollow">.NET</a> as well.',nl,Ze,un="Most likely you wil encounter errors in the first attempt. Below are the scenarios to help you resolve the errors.",sl,ke,Mn='<li>issue about <code>Invalid Call. Nonexistent function &#39;new&#39; in base &#39;CSharpScript&#39;</code>: <a href="https://github.com/edbeeching/godot_rl_agents/blob/main/docs/TROUBLESHOOTING.md" rel="nofollow">solution</a></li> <li>errors about <code>onnxruntime</code> on MacOS: <a href="https://github.com/microsoft/onnxruntime/issues/9707" rel="nofollow">solution</a></li>',ol,Be,il,Le,fn='We have only scratched the surface of what can be achieved with Godot RL Agents, the library includes custom sensors and cameras to enrich the information available to the agent. Take a look at the <a href="https://github.com/edbeeching/godot_rl_agents_examples" rel="nofollow">examples</a> to find out more!',al,Se,gn='For the ability to export the trained model to .onnx so that you can run inference directly from Godot without the Python server, and other useful training options, take a look at the <a href="https://github.com/edbeeching/godot_rl_agents/blob/main/docs/ADV_STABLE_BASELINES_3.md" rel="nofollow">advanced SB3 tutorial</a>.',rl,Re,pl,$e,wn='This section was written by <a href="https://twitter.com/edwardbeeching">Edward Beeching</a>',hl,We,ml,Xe,dl;return w=new f({props:{title:"Godot RL Agents",local:"godot-rl-agents",headingTag:"h1"}}),U=new f({props:{title:"Create a custom RL environment with Godot RL Agents",local:"create-a-custom-rl-environment-with-godot-rl-agents",headingTag:"h2"}}),C=new f({props:{title:"Installing the Godot Game Engine",local:"installing-the-godot-game-engine",headingTag:"h3"}}),R=new f({props:{title:"Loading the starter project",local:"loading-the-starter-project",headingTag:"h3"}}),H=new f({props:{title:"Installing the Godot RL Agents plugin",local:"installing-the-godot-rl-agents-plugin",headingTag:"h3"}}),P=new f({props:{title:"Adding the AI controller",local:"adding-the-ai-controller",headingTag:"h3"}}),te=new Ee({props:{code:"JTIzLS0lMjBNZXRob2RzJTIwdGhhdCUyMG5lZWQlMjBpbXBsZW1lbnRpbmclMjB1c2luZyUyMHRoZSUyMCUyMmV4dGVuZCUyMHNjcmlwdCUyMiUyMG9wdGlvbiUyMGluJTIwR29kb3QlMjAtLSUyMyUwQWZ1bmMlMjBnZXRfb2JzKCklMjAtJTNFJTIwRGljdGlvbmFyeSUzQSUwQSUwOWFzc2VydChmYWxzZSUyQyUyMCUyMnRoZSUyMGdldF9vYnMlMjBtZXRob2QlMjBpcyUyMG5vdCUyMGltcGxlbWVudGVkJTIwd2hlbiUyMGV4dGVuZGluZyUyMGZyb20lMjBhaV9jb250cm9sbGVyJTIyKSUwQSUwOXJldHVybiUyMCU3QiUyMm9icyUyMiUzQSU1QiU1RCU3RCUwQSUwQWZ1bmMlMjBnZXRfcmV3YXJkKCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXRfcmV3YXJkJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMDlyZXR1cm4lMjAwLjAlMEElMEFmdW5jJTIwZ2V0X2FjdGlvbl9zcGFjZSgpJTIwLSUzRSUyMERpY3Rpb25hcnklM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXQlMjBnZXRfYWN0aW9uX3NwYWNlJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMDlyZXR1cm4lMjAlN0IlMEElMDklMDklMjJleGFtcGxlX2FjdGlvbnNfY29udGlub3VzJTIyJTIwJTNBJTIwJTdCJTBBJTA5JTA5JTA5JTIyc2l6ZSUyMiUzQSUyMDIlMkMlMEElMDklMDklMDklMjJhY3Rpb25fdHlwZSUyMiUzQSUyMCUyMmNvbnRpbnVvdXMlMjIlMEElMDklMDklN0QlMkMlMEElMDklMDklMjJleGFtcGxlX2FjdGlvbnNfZGlzY3JldGUlMjIlMjAlM0ElMjAlN0IlMEElMDklMDklMDklMjJzaXplJTIyJTNBJTIwMiUyQyUwQSUwOSUwOSUwOSUyMmFjdGlvbl90eXBlJTIyJTNBJTIwJTIyZGlzY3JldGUlMjIlMEElMDklMDklN0QlMkMlMEElMDklMDklN0QlMEElMEFmdW5jJTIwc2V0X2FjdGlvbihhY3Rpb24pJTIwLSUzRSUyMHZvaWQlM0ElMEElMDlhc3NlcnQoZmFsc2UlMkMlMjAlMjJ0aGUlMjBnZXQlMjBzZXRfYWN0aW9uJTIwbWV0aG9kJTIwaXMlMjBub3QlMjBpbXBsZW1lbnRlZCUyMHdoZW4lMjBleHRlbmRpbmclMjBmcm9tJTIwYWlfY29udHJvbGxlciUyMiklMEElMjMlMjAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyMw==",highlighted:`<span class="hljs-comment">#-- Methods that need implementing using the &quot;extend script&quot; option in Godot --#</span>
func get_obs() -&gt; Dictionary:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get_obs method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>:[]}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get_reward method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> <span class="hljs-number">0.0</span>

func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get get_action_space method is not implemented when extending from ai_controller&quot;</span>)
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;example_actions_continous&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>
		},
		<span class="hljs-string">&quot;example_actions_discrete&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">2</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;discrete&quot;</span>
		},
		}

func set_action(action) -&gt; void:
	<span class="hljs-keyword">assert</span>(false, <span class="hljs-string">&quot;the get set_action method is not implemented when extending from ai_controller&quot;</span>)
<span class="hljs-comment"># -----------------------------------------------------------------------------#</span>`,wrap:!1}}),se=new Ee({props:{code:"ZXh0ZW5kcyUyMEFJQ29udHJvbGxlcjNEJTBBJTBBJTIzJTIwQ2FsbGVkJTIwd2hlbiUyMHRoZSUyMG5vZGUlMjBlbnRlcnMlMjB0aGUlMjBzY2VuZSUyMHRyZWUlMjBmb3IlMjB0aGUlMjBmaXJzdCUyMHRpbWUuJTBBZnVuYyUyMF9yZWFkeSgpJTNBJTBBJTA5cGFzcyUyMCUyMyUyMFJlcGxhY2UlMjB3aXRoJTIwZnVuY3Rpb24lMjBib2R5LiUwQSUwQSUyMyUyMENhbGxlZCUyMGV2ZXJ5JTIwZnJhbWUuJTIwJ2RlbHRhJyUyMGlzJTIwdGhlJTIwZWxhcHNlZCUyMHRpbWUlMjBzaW5jZSUyMHRoZSUyMHByZXZpb3VzJTIwZnJhbWUuJTBBZnVuYyUyMF9wcm9jZXNzKGRlbHRhKSUzQSUwQSUwOXBhc3M=",highlighted:`extends AIController3D

<span class="hljs-comment"># Called when the node enters the scene tree for the first time.</span>
func _ready():
	<span class="hljs-keyword">pass</span> <span class="hljs-comment"># Replace with function body.</span>

<span class="hljs-comment"># Called every frame. &#x27;delta&#x27; is the elapsed time since the previous frame.</span>
func _process(delta):
	<span class="hljs-keyword">pass</span>`,wrap:!1}}),ie=new Ee({props:{code:"ZXh0ZW5kcyUyMEFJQ29udHJvbGxlcjNEJTBBJTBBJTIzJTIwU3RvcmVzJTIwdGhlJTIwYWN0aW9uJTIwc2FtcGxlZCUyMGZvciUyMHRoZSUyMGFnZW50J3MlMjBwb2xpY3klMkMlMjBydW5uaW5nJTIwaW4lMjBweXRob24lMEF2YXIlMjBtb3ZlX2FjdGlvbiUyMCUzQSUyMGZsb2F0JTIwJTNEJTIwMC4wJTBBJTBBZnVuYyUyMGdldF9vYnMoKSUyMC0lM0UlMjBEaWN0aW9uYXJ5JTNBJTBBJTA5JTIzJTIwZ2V0JTIwdGhlJTIwYmFsbHMlMjBwb3NpdGlvbiUyMGFuZCUyMHZlbG9jaXR5JTIwaW4lMjB0aGUlMjBwYWRkbGUncyUyMGZyYW1lJTIwb2YlMjByZWZlcmVuY2UlMEElMDl2YXIlMjBiYWxsX3BvcyUyMCUzRCUyMHRvX2xvY2FsKF9wbGF5ZXIuYmFsbC5nbG9iYWxfcG9zaXRpb24pJTBBJTA5dmFyJTIwYmFsbF92ZWwlMjAlM0QlMjB0b19sb2NhbChfcGxheWVyLmJhbGwubGluZWFyX3ZlbG9jaXR5KSUwQSUwOXZhciUyMG9icyUyMCUzRCUyMCU1QmJhbGxfcG9zLnglMkMlMjBiYWxsX3Bvcy56JTJDJTIwYmFsbF92ZWwueCUyRjEwLjAlMkMlMjBiYWxsX3ZlbC56JTJGMTAuMCU1RCUwQSUwQSUwOXJldHVybiUyMCU3QiUyMm9icyUyMiUzQW9icyU3RCUwQSUwQWZ1bmMlMjBnZXRfcmV3YXJkKCklMjAtJTNFJTIwZmxvYXQlM0ElMEElMDlyZXR1cm4lMjByZXdhcmQlMEElMEFmdW5jJTIwZ2V0X2FjdGlvbl9zcGFjZSgpJTIwLSUzRSUyMERpY3Rpb25hcnklM0ElMEElMDlyZXR1cm4lMjAlN0IlMEElMDklMDklMjJtb3ZlX2FjdGlvbiUyMiUyMCUzQSUyMCU3QiUwQSUwOSUwOSUwOSUyMnNpemUlMjIlM0ElMjAxJTJDJTBBJTA5JTA5JTA5JTIyYWN0aW9uX3R5cGUlMjIlM0ElMjAlMjJjb250aW51b3VzJTIyJTBBJTA5JTA5JTdEJTJDJTBBJTA5JTA5JTdEJTBBJTBBZnVuYyUyMHNldF9hY3Rpb24oYWN0aW9uKSUyMC0lM0UlMjB2b2lkJTNBJTBBJTA5bW92ZV9hY3Rpb24lMjAlM0QlMjBjbGFtcChhY3Rpb24lNUIlMjJtb3ZlX2FjdGlvbiUyMiU1RCU1QjAlNUQlMkMlMjAtMS4wJTJDJTIwMS4wKQ==",highlighted:`extends AIController3D

<span class="hljs-comment"># Stores the action sampled for the agent&#x27;s policy, running in python</span>
var move_action : <span class="hljs-built_in">float</span> = <span class="hljs-number">0.0</span>

func get_obs() -&gt; Dictionary:
	<span class="hljs-comment"># get the balls position and velocity in the paddle&#x27;s frame of reference</span>
	var ball_pos = to_local(_player.ball.global_position)
	var ball_vel = to_local(_player.ball.linear_velocity)
	var obs = [ball_pos.x, ball_pos.z, ball_vel.x/<span class="hljs-number">10.0</span>, ball_vel.z/<span class="hljs-number">10.0</span>]

	<span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;obs&quot;</span>:obs}

func get_reward() -&gt; <span class="hljs-built_in">float</span>:
	<span class="hljs-keyword">return</span> reward

func get_action_space() -&gt; Dictionary:
	<span class="hljs-keyword">return</span> {
		<span class="hljs-string">&quot;move_action&quot;</span> : {
			<span class="hljs-string">&quot;size&quot;</span>: <span class="hljs-number">1</span>,
			<span class="hljs-string">&quot;action_type&quot;</span>: <span class="hljs-string">&quot;continuous&quot;</span>
		},
		}

func set_action(action) -&gt; void:
	move_action = clamp(action[<span class="hljs-string">&quot;move_action&quot;</span>][<span class="hljs-number">0</span>], -<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>)`,wrap:!1}}),pe=new Ee({props:{code:"ZXh0ZW5kcyUyME5vZGUzRCUwQSUwQSU0MGV4cG9ydCUyMHZhciUyMHJvdGF0aW9uX3NwZWVkJTIwJTNEJTIwMy4wJTBBJTQwb25yZWFkeSUyMHZhciUyMGJhbGwlMjAlM0QlMjBnZXRfbm9kZSglMjIuLiUyRkJhbGwlMjIpJTBBJTQwb25yZWFkeSUyMHZhciUyMGFpX2NvbnRyb2xsZXIlMjAlM0QlMjAlMjRBSUNvbnRyb2xsZXIzRCUwQSUwQWZ1bmMlMjBfcmVhZHkoKSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIuaW5pdChzZWxmKSUwQSUwQWZ1bmMlMjBnYW1lX292ZXIoKSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIuZG9uZSUyMCUzRCUyMHRydWUlMEElMDlhaV9jb250cm9sbGVyLm5lZWRzX3Jlc2V0JTIwJTNEJTIwdHJ1ZSUwQSUwQWZ1bmMlMjBfcGh5c2ljc19wcm9jZXNzKGRlbHRhKSUzQSUwQSUwOWlmJTIwYWlfY29udHJvbGxlci5uZWVkc19yZXNldCUzQSUwQSUwOSUwOWFpX2NvbnRyb2xsZXIucmVzZXQoKSUwQSUwOSUwOWJhbGwucmVzZXQoKSUwQSUwOSUwOXJldHVybiUwQSUwQSUwOXZhciUyMG1vdmVtZW50JTIwJTNBJTIwZmxvYXQlMEElMDlpZiUyMGFpX2NvbnRyb2xsZXIuaGV1cmlzdGljJTIwJTNEJTNEJTIwJTIyaHVtYW4lMjIlM0ElMEElMDklMDltb3ZlbWVudCUyMCUzRCUyMElucHV0LmdldF9heGlzKCUyMnJvdGF0ZV9hbnRpY2xvY2t3aXNlJTIyJTJDJTIwJTIycm90YXRlX2Nsb2Nrd2lzZSUyMiklMEElMDllbHNlJTNBJTBBJTA5JTA5bW92ZW1lbnQlMjAlM0QlMjBhaV9jb250cm9sbGVyLm1vdmVfYWN0aW9uJTBBJTA5cm90YXRlX3kobW92ZW1lbnQqZGVsdGEqcm90YXRpb25fc3BlZWQpJTBBJTBBZnVuYyUyMF9vbl9hcmVhXzNkX2JvZHlfZW50ZXJlZChib2R5KSUzQSUwQSUwOWFpX2NvbnRyb2xsZXIucmV3YXJkJTIwJTJCJTNEJTIwMS4w",highlighted:`extends Node3D

<span class="hljs-meta">@export var rotation_speed = <span class="hljs-number">3.0</span></span>
<span class="hljs-meta">@onready var ball = get_node(<span class="hljs-params"><span class="hljs-string">&quot;../Ball&quot;</span></span>)</span>
<span class="hljs-meta">@onready var ai_controller = $AIController3D</span>

func _ready():
	ai_controller.init(self)

func game_over():
	ai_controller.done = true
	ai_controller.needs_reset = true

func _physics_process(delta):
	<span class="hljs-keyword">if</span> ai_controller.needs_reset:
		ai_controller.reset()
		ball.reset()
		<span class="hljs-keyword">return</span>

	var movement : <span class="hljs-built_in">float</span>
	<span class="hljs-keyword">if</span> ai_controller.heuristic == <span class="hljs-string">&quot;human&quot;</span>:
		movement = Input.get_axis(<span class="hljs-string">&quot;rotate_anticlockwise&quot;</span>, <span class="hljs-string">&quot;rotate_clockwise&quot;</span>)
	<span class="hljs-keyword">else</span>:
		movement = ai_controller.move_action
	rotate_y(movement*delta*rotation_speed)

func _on_area_3d_body_entered(body):
	ai_controller.reward += <span class="hljs-number">1.0</span>`,wrap:!1}}),Me=new f({props:{title:"Export model",local:"export-model",headingTag:"h3"}}),ve=new Ee({props:{code:"Y2QlMjAlM0MuLi4uJTNFJTIwJTIzJTIwZ28lMjBpbnRvJTIwdGhpcyUyMEdvZG90JTIwcHJvamVjdCUyMGRpcmVjdG9yeSUwQXB5dGhvbiUyMHN0YWJsZV9iYXNlbGluZXMzX2V4YW1wbGUucHklMjAtLXRpbWVzdGVwcyUzRDEwMF8wMDAlMjAtLW9ubnhfZXhwb3J0X3BhdGglM0Rtb2RlbC5vbm54JTIwLS1zYXZlX21vZGVsX3BhdGglM0Rtb2RlbC56aXAlMjAtLXNhdmVfY2hlY2twb2ludF9mcmVxdWVuY3klM0QyMF8wMDAlMjAtLWV4cGVyaW1lbnRfbmFtZSUzRGV4cDE=",highlighted:`<span class="hljs-built_in">cd</span> &lt;....&gt; <span class="hljs-comment"># go into this Godot project directory</span>
python stable_baselines3_example.py --timesteps=100_000 --onnx_export_path=model.onnx --save_model_path=model.zip --save_checkpoint_frequency=20_000 --experiment_name=exp1`,wrap:!1}}),je=new Ee({props:{code:"Tm8lMjBnYW1lJTIwYmluYXJ5JTIwaGFzJTIwYmVlbiUyMHByb3ZpZGVkJTJDJTIwcGxlYXNlJTIwcHJlc3MlMjBQTEFZJTIwaW4lMjB0aGUlMjBHb2RvdCUyMGVkaXRvciUwQXdhaXRpbmclMjBmb3IlMjByZW1vdGUlMjBHT0RPVCUyMGNvbm5lY3Rpb24lMjBvbiUyMHBvcnQlMjAxMTAwOA==",highlighted:`No game <span class="hljs-keyword">binary </span>has <span class="hljs-keyword">been </span>provided, please press PLAY in the Godot editor
<span class="hljs-keyword">waiting </span>for remote GODOT connection on port <span class="hljs-number">11008</span>`,wrap:!1}}),Je=new f({props:{title:"Apply AI in the game!",local:"apply-ai-in-the-game",headingTag:"h3"}}),Be=new f({props:{title:"There’s more!",local:"theres-more",headingTag:"h3"}}),Re=new f({props:{title:"Author",local:"author",headingTag:"h2"}}),We=new _n({props:{source:"https://github.com/huggingface/deep-rl-class/blob/main/units/en/unitbonus3/godotrl.mdx"}}),{c(){g=i("meta"),Qe=s(),He=i("p"),Ne=s(),p(w.$$.fragment),Ye=s(),b=i("p"),b.innerHTML=ul,ze=s(),y=i("p"),y.textContent=Ml,Fe=s(),v=i("ul"),v.innerHTML=fl,Ve=s(),T=i("p"),T.innerHTML=gl,Pe=s(),j=i("p"),j.innerHTML=wl,qe=s(),p(U.$$.fragment),De=s(),x=i("p"),x.innerHTML=bl,Oe=s(),J=i("p"),J.innerHTML=yl,Ke=s(),_=i("p"),_.innerHTML=vl,et=s(),G=i("img"),tt=s(),p(C.$$.fragment),lt=s(),I=i("p"),I.innerHTML=jl,nt=s(),Z=i("p"),Z.innerHTML=Ul,st=s(),k=i("p"),k.innerHTML=xl,ot=s(),B=i("p"),B.innerHTML=Jl,it=s(),L=i("p"),L.textContent=_l,at=s(),S=i("ul"),S.innerHTML=Gl,rt=s(),p(R.$$.fragment),pt=s(),$=i("p"),$.textContent=Cl,ht=s(),W=i("ul"),W.innerHTML=Il,mt=s(),A=i("p"),A.innerHTML=Zl,dt=s(),E=i("p"),E.textContent=kl,ct=s(),p(H.$$.fragment),ut=s(),X=i("p"),X.textContent=Bl,Mt=s(),Q=i("p"),Q.textContent=Ll,ft=s(),N=i("img"),gt=s(),Y=i("p"),Y.textContent=Rl,wt=s(),z=i("img"),bt=s(),F=i("p"),F.textContent=Wl,yt=s(),V=i("img"),vt=s(),p(P.$$.fragment),Tt=s(),q=i("p"),q.textContent=El,jt=s(),D=i("img"),Ut=s(),O=i("p"),O.innerHTML=Xl,xt=s(),K=i("img"),Jt=s(),ee=i("p"),ee.textContent=Nl,_t=s(),p(te.$$.fragment),Gt=s(),le=i("p"),le.textContent=Yl,Ct=s(),ne=i("p"),ne.innerHTML=zl,It=s(),p(se.$$.fragment),Zt=s(),oe=i("p"),oe.textContent=Fl,kt=s(),p(ie.$$.fragment),Bt=s(),ae=i("p"),ae.textContent=Vl,Lt=s(),re=i("p"),re.innerHTML=Pl,St=s(),p(pe.$$.fragment),Rt=s(),he=i("p"),he.textContent=ql,$t=s(),me=i("p"),me.innerHTML=Dl,Wt=s(),de=i("p"),de.textContent=Ol,At=s(),ce=i("img"),Et=s(),ue=i("p"),ue.textContent=en,Ht=s(),p(Me.$$.fragment),Xt=s(),fe=i("p"),fe.innerHTML=tn,Qt=s(),ge=i("p"),ge.textContent=ln,Nt=s(),we=i("p"),we.textContent=nn,Yt=s(),be=i("p"),be.innerHTML=sn,zt=s(),ye=i("p"),ye.textContent=on,Ft=s(),p(ve.$$.fragment),Vt=s(),Te=i("p"),Te.textContent=an,Pt=s(),p(je.$$.fragment),qt=s(),Ue=i("blockquote"),Ue.innerHTML=rn,Dt=s(),xe=i("p"),xe.innerHTML=pn,Ot=s(),p(Je.$$.fragment),Kt=s(),_e=i("p"),_e.textContent=hn,el=s(),Ge=i("p"),Ge.innerHTML=mn,tl=s(),Ce=i("ul"),Ce.innerHTML=dn,ll=s(),Ie=i("p"),Ie.innerHTML=cn,nl=s(),Ze=i("p"),Ze.textContent=un,sl=s(),ke=i("ol"),ke.innerHTML=Mn,ol=s(),p(Be.$$.fragment),il=s(),Le=i("p"),Le.innerHTML=fn,al=s(),Se=i("p"),Se.innerHTML=gn,rl=s(),p(Re.$$.fragment),pl=s(),$e=i("p"),$e.innerHTML=wn,hl=s(),p(We.$$.fragment),ml=s(),Xe=i("p"),this.h()},l(e){const t=xn("svelte-u9bgzb",document.head);g=a(t,"META",{name:!0,content:!0}),t.forEach(l),Qe=o(e),He=a(e,"P",{}),bn(He).forEach(l),Ne=o(e),h(w.$$.fragment,e),Ye=o(e),b=a(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-2p47v5"&&(b.innerHTML=ul),ze=o(e),y=a(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-1py9j1o"&&(y.textContent=Ml),Fe=o(e),v=a(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-fbxqzk"&&(v.innerHTML=fl),Ve=o(e),T=a(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-f5k4w1"&&(T.innerHTML=gl),Pe=o(e),j=a(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1tilrrq"&&(j.innerHTML=wl),qe=o(e),h(U.$$.fragment,e),De=o(e),x=a(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-j43km5"&&(x.innerHTML=bl),Oe=o(e),J=a(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1bia7ve"&&(J.innerHTML=yl),Ke=o(e),_=a(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-18kdqtx"&&(_.innerHTML=vl),et=o(e),G=a(e,"IMG",{src:!0,alt:!0}),tt=o(e),h(C.$$.fragment,e),lt=o(e),I=a(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-12z31zk"&&(I.innerHTML=jl),nt=o(e),Z=a(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-15j420f"&&(Z.innerHTML=Ul),st=o(e),k=a(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-11gpv3q"&&(k.innerHTML=xl),ot=o(e),B=a(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-sbxy1m"&&(B.innerHTML=Jl),it=o(e),L=a(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1qow1fz"&&(L.textContent=_l),at=o(e),S=a(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-113hcwa"&&(S.innerHTML=Gl),rt=o(e),h(R.$$.fragment,e),pt=o(e),$=a(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-4xjw3c"&&($.textContent=Cl),ht=o(e),W=a(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-14f47bb"&&(W.innerHTML=Il),mt=o(e),A=a(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-n5pdey"&&(A.innerHTML=Zl),dt=o(e),E=a(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-82774z"&&(E.textContent=kl),ct=o(e),h(H.$$.fragment,e),ut=o(e),X=a(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1czivbr"&&(X.textContent=Bl),Mt=o(e),Q=a(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1mue8hu"&&(Q.textContent=Ll),ft=o(e),N=a(e,"IMG",{src:!0,alt:!0}),gt=o(e),Y=a(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-x1a58g"&&(Y.textContent=Rl),wt=o(e),z=a(e,"IMG",{src:!0,alt:!0}),bt=o(e),F=a(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-kax2n0"&&(F.textContent=Wl),yt=o(e),V=a(e,"IMG",{src:!0,alt:!0}),vt=o(e),h(P.$$.fragment,e),Tt=o(e),q=a(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1k1rgr4"&&(q.textContent=El),jt=o(e),D=a(e,"IMG",{src:!0,alt:!0}),Ut=o(e),O=a(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-wi5wbl"&&(O.innerHTML=Xl),xt=o(e),K=a(e,"IMG",{src:!0,alt:!0}),Jt=o(e),ee=a(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-g41mxc"&&(ee.textContent=Nl),_t=o(e),h(te.$$.fragment,e),Gt=o(e),le=a(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1nxuc10"&&(le.textContent=Yl),Ct=o(e),ne=a(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10r5ldp"&&(ne.innerHTML=zl),It=o(e),h(se.$$.fragment,e),Zt=o(e),oe=a(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1bzu5xq"&&(oe.textContent=Fl),kt=o(e),h(ie.$$.fragment,e),Bt=o(e),ae=a(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-48pe1i"&&(ae.textContent=Vl),Lt=o(e),re=a(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-13nui2f"&&(re.innerHTML=Pl),St=o(e),h(pe.$$.fragment,e),Rt=o(e),he=a(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-vvgyl6"&&(he.textContent=ql),$t=o(e),me=a(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-188118c"&&(me.innerHTML=Dl),Wt=o(e),de=a(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1lptaex"&&(de.textContent=Ol),At=o(e),ce=a(e,"IMG",{src:!0,alt:!0}),Et=o(e),ue=a(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1da9kc0"&&(ue.textContent=en),Ht=o(e),h(Me.$$.fragment,e),Xt=o(e),fe=a(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1liuaan"&&(fe.innerHTML=tn),Qt=o(e),ge=a(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-sbz1aa"&&(ge.textContent=ln),Nt=o(e),we=a(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-my0y52"&&(we.textContent=nn),Yt=o(e),be=a(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1lydsn0"&&(be.innerHTML=sn),zt=o(e),ye=a(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-mkoz3j"&&(ye.textContent=on),Ft=o(e),h(ve.$$.fragment,e),Vt=o(e),Te=a(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-4y18ut"&&(Te.textContent=an),Pt=o(e),h(je.$$.fragment,e),qt=o(e),Ue=a(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Ue)!=="svelte-8exa0x"&&(Ue.innerHTML=rn),Dt=o(e),xe=a(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1j1tpt0"&&(xe.innerHTML=pn),Ot=o(e),h(Je.$$.fragment,e),Kt=o(e),_e=a(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1cqb7q8"&&(_e.textContent=hn),el=o(e),Ge=a(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1pshggz"&&(Ge.innerHTML=mn),tl=o(e),Ce=a(e,"UL",{"data-svelte-h":!0}),r(Ce)!=="svelte-wmeyou"&&(Ce.innerHTML=dn),ll=o(e),Ie=a(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-s7i4td"&&(Ie.innerHTML=cn),nl=o(e),Ze=a(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-1flc2j"&&(Ze.textContent=un),sl=o(e),ke=a(e,"OL",{"data-svelte-h":!0}),r(ke)!=="svelte-1o0yb8q"&&(ke.innerHTML=Mn),ol=o(e),h(Be.$$.fragment,e),il=o(e),Le=a(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-w6yf05"&&(Le.innerHTML=fn),al=o(e),Se=a(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-6qyuz4"&&(Se.innerHTML=gn),rl=o(e),h(Re.$$.fragment,e),pl=o(e),$e=a(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-11016ov"&&($e.innerHTML=wn),hl=o(e),h(We.$$.fragment,e),ml=o(e),Xe=a(e,"P",{}),bn(Xe).forEach(l),this.h()},h(){M(g,"name","hf:doc:metadata"),M(g,"content",Cn),Ae(G.src,Tl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/ringpong.gif")||M(G,"src",Tl),M(G,"alt","Ring Pong"),Ae(N.src,Sl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot1.png")||M(N,"src",Sl),M(N,"alt","Godot"),Ae(z.src,$l="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot2.png")||M(z,"src",$l),M(z,"alt","Godot"),Ae(V.src,Al="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot3.png")||M(V,"src",Al),M(V,"alt","Godot"),Ae(D.src,Hl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot4.png")||M(D,"src",Hl),M(D,"alt","Godot"),Ae(K.src,Ql="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot5.png")||M(K,"src",Ql),M(K,"alt","Godot"),Ae(ce.src,Kl="https://huggingface.co/datasets/huggingface-deep-rl-course/course-images/resolve/main/en/unit9/godot6.png")||M(ce,"src",Kl),M(ce,"alt","Godot")},m(e,t){Jn(document.head,g),n(e,Qe,t),n(e,He,t),n(e,Ne,t),m(w,e,t),n(e,Ye,t),n(e,b,t),n(e,ze,t),n(e,y,t),n(e,Fe,t),n(e,v,t),n(e,Ve,t),n(e,T,t),n(e,Pe,t),n(e,j,t),n(e,qe,t),m(U,e,t),n(e,De,t),n(e,x,t),n(e,Oe,t),n(e,J,t),n(e,Ke,t),n(e,_,t),n(e,et,t),n(e,G,t),n(e,tt,t),m(C,e,t),n(e,lt,t),n(e,I,t),n(e,nt,t),n(e,Z,t),n(e,st,t),n(e,k,t),n(e,ot,t),n(e,B,t),n(e,it,t),n(e,L,t),n(e,at,t),n(e,S,t),n(e,rt,t),m(R,e,t),n(e,pt,t),n(e,$,t),n(e,ht,t),n(e,W,t),n(e,mt,t),n(e,A,t),n(e,dt,t),n(e,E,t),n(e,ct,t),m(H,e,t),n(e,ut,t),n(e,X,t),n(e,Mt,t),n(e,Q,t),n(e,ft,t),n(e,N,t),n(e,gt,t),n(e,Y,t),n(e,wt,t),n(e,z,t),n(e,bt,t),n(e,F,t),n(e,yt,t),n(e,V,t),n(e,vt,t),m(P,e,t),n(e,Tt,t),n(e,q,t),n(e,jt,t),n(e,D,t),n(e,Ut,t),n(e,O,t),n(e,xt,t),n(e,K,t),n(e,Jt,t),n(e,ee,t),n(e,_t,t),m(te,e,t),n(e,Gt,t),n(e,le,t),n(e,Ct,t),n(e,ne,t),n(e,It,t),m(se,e,t),n(e,Zt,t),n(e,oe,t),n(e,kt,t),m(ie,e,t),n(e,Bt,t),n(e,ae,t),n(e,Lt,t),n(e,re,t),n(e,St,t),m(pe,e,t),n(e,Rt,t),n(e,he,t),n(e,$t,t),n(e,me,t),n(e,Wt,t),n(e,de,t),n(e,At,t),n(e,ce,t),n(e,Et,t),n(e,ue,t),n(e,Ht,t),m(Me,e,t),n(e,Xt,t),n(e,fe,t),n(e,Qt,t),n(e,ge,t),n(e,Nt,t),n(e,we,t),n(e,Yt,t),n(e,be,t),n(e,zt,t),n(e,ye,t),n(e,Ft,t),m(ve,e,t),n(e,Vt,t),n(e,Te,t),n(e,Pt,t),m(je,e,t),n(e,qt,t),n(e,Ue,t),n(e,Dt,t),n(e,xe,t),n(e,Ot,t),m(Je,e,t),n(e,Kt,t),n(e,_e,t),n(e,el,t),n(e,Ge,t),n(e,tl,t),n(e,Ce,t),n(e,ll,t),n(e,Ie,t),n(e,nl,t),n(e,Ze,t),n(e,sl,t),n(e,ke,t),n(e,ol,t),m(Be,e,t),n(e,il,t),n(e,Le,t),n(e,al,t),n(e,Se,t),n(e,rl,t),m(Re,e,t),n(e,pl,t),n(e,$e,t),n(e,hl,t),m(We,e,t),n(e,ml,t),n(e,Xe,t),dl=!0},p:vn,i(e){dl||(d(w.$$.fragment,e),d(U.$$.fragment,e),d(C.$$.fragment,e),d(R.$$.fragment,e),d(H.$$.fragment,e),d(P.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(ve.$$.fragment,e),d(je.$$.fragment,e),d(Je.$$.fragment,e),d(Be.$$.fragment,e),d(Re.$$.fragment,e),d(We.$$.fragment,e),dl=!0)},o(e){c(w.$$.fragment,e),c(U.$$.fragment,e),c(C.$$.fragment,e),c(R.$$.fragment,e),c(H.$$.fragment,e),c(P.$$.fragment,e),c(te.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(Me.$$.fragment,e),c(ve.$$.fragment,e),c(je.$$.fragment,e),c(Je.$$.fragment,e),c(Be.$$.fragment,e),c(Re.$$.fragment,e),c(We.$$.fragment,e),dl=!1},d(e){e&&(l(Qe),l(He),l(Ne),l(Ye),l(b),l(ze),l(y),l(Fe),l(v),l(Ve),l(T),l(Pe),l(j),l(qe),l(De),l(x),l(Oe),l(J),l(Ke),l(_),l(et),l(G),l(tt),l(lt),l(I),l(nt),l(Z),l(st),l(k),l(ot),l(B),l(it),l(L),l(at),l(S),l(rt),l(pt),l($),l(ht),l(W),l(mt),l(A),l(dt),l(E),l(ct),l(ut),l(X),l(Mt),l(Q),l(ft),l(N),l(gt),l(Y),l(wt),l(z),l(bt),l(F),l(yt),l(V),l(vt),l(Tt),l(q),l(jt),l(D),l(Ut),l(O),l(xt),l(K),l(Jt),l(ee),l(_t),l(Gt),l(le),l(Ct),l(ne),l(It),l(Zt),l(oe),l(kt),l(Bt),l(ae),l(Lt),l(re),l(St),l(Rt),l(he),l($t),l(me),l(Wt),l(de),l(At),l(ce),l(Et),l(ue),l(Ht),l(Xt),l(fe),l(Qt),l(ge),l(Nt),l(we),l(Yt),l(be),l(zt),l(ye),l(Ft),l(Vt),l(Te),l(Pt),l(qt),l(Ue),l(Dt),l(xe),l(Ot),l(Kt),l(_e),l(el),l(Ge),l(tl),l(Ce),l(ll),l(Ie),l(nl),l(Ze),l(sl),l(ke),l(ol),l(il),l(Le),l(al),l(Se),l(rl),l(pl),l($e),l(hl),l(ml),l(Xe)),l(g),u(w,e),u(U,e),u(C,e),u(R,e),u(H,e),u(P,e),u(te,e),u(se,e),u(ie,e),u(pe,e),u(Me,e),u(ve,e),u(je,e),u(Je,e),u(Be,e),u(Re,e),u(We,e)}}}const Cn='{"title":"Godot RL Agents","local":"godot-rl-agents","sections":[{"title":"Create a custom RL environment with Godot RL Agents","local":"create-a-custom-rl-environment-with-godot-rl-agents","sections":[{"title":"Installing the Godot Game Engine","local":"installing-the-godot-game-engine","sections":[],"depth":3},{"title":"Loading the starter project","local":"loading-the-starter-project","sections":[],"depth":3},{"title":"Installing the Godot RL Agents plugin","local":"installing-the-godot-rl-agents-plugin","sections":[],"depth":3},{"title":"Adding the AI controller","local":"adding-the-ai-controller","sections":[],"depth":3},{"title":"Export model","local":"export-model","sections":[],"depth":3},{"title":"Apply AI in the game!","local":"apply-ai-in-the-game","sections":[],"depth":3},{"title":"There’s more!","local":"theres-more","sections":[],"depth":3}],"depth":2},{"title":"Author","local":"author","sections":[],"depth":2}],"depth":1}';function In(cl){return Tn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sn extends jn{constructor(g){super(),Un(this,g,In,Gn,yn,{})}}export{Sn as component};
