import{s as yn,o as mn,n as jl}from"../chunks/scheduler.b108d059.js";import{S as jn,i as Un,g as o,s as a,r,A as Tn,h as i,f as l,c as s,j as un,u as d,x as M,k as hn,y as Jn,a as n,v as c,d as u,t as h,w as y}from"../chunks/index.008de539.js";import{T as ml}from"../chunks/Tip.aeb15ab7.js";import{C as j}from"../chunks/CodeBlock.3968c746.js";import{H as T,E as wn}from"../chunks/EditOnGithub.d1c48e3d.js";function gn(w){let p,U='Starting from TGI 2.3 DLC i.e. <code>us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124.2-3.ubuntu2204.py311</code>, and onwards, you can set the environment variable value <code>MESSAGES_API_ENABLED=&quot;true&quot;</code> to deploy the <a href="https://huggingface.co/docs/text-generation-inference/main/en/messages_api" rel="nofollow">Messages API</a> on Vertex AI, otherwise, the <a href="https://huggingface.co/docs/text-generation-inference/main/en/quicktour#consuming-tgi" rel="nofollow">Generate API</a> will be deployed instead.';return{c(){p=o("p"),p.innerHTML=U},l(m){p=i(m,"P",{"data-svelte-h":!0}),M(p)!=="svelte-1jcnsbw"&&(p.innerHTML=U)},m(m,J){n(m,p,J)},p:jl,d(m){m&&l(p)}}}function fn(w){let p,U="As mentioned before, since Meta Llama 3.1 405B in FP8 takes ~400 GiB of disk space, that means you need at least 400 GiB of GPU VRAM to load the model, and the GPUs within the node need to support the FP8 data type. In this case, an A3 instance with 8 x NVIDIA H100 80GB with a total of ~640 GiB of VRAM will be used to load the model while also leaving some free VRAM for the KV Cache and the CUDA Graphs.";return{c(){p=o("p"),p.textContent=U},l(m){p=i(m,"P",{"data-svelte-h":!0}),M(p)!=="svelte-1gl89sv"&&(p.textContent=U)},m(m,J){n(m,p,J)},p:jl,d(m){m&&l(p)}}}function bn(w){let p,U="You will need to either retrieve the resource name i.e. the <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code> URL yourself via the Google Cloud Console, or just replace the <code>ENDPOINT_ID</code> below that can either be found via the previously instantiated <code>endpoint</code> as <code>endpoint.id</code> or via the Google Cloud Console under the Online predictions where the endpoint is listed.";return{c(){p=o("p"),p.innerHTML=U},l(m){p=i(m,"P",{"data-svelte-h":!0}),M(p)!=="svelte-10r1du6"&&(p.innerHTML=U)},m(m,J){n(m,p,J)},p:jl,d(m){m&&l(p)}}}function In(w){let p,U,m,J,I,Le,C,Ul='<a href="https://huggingface.co/blog/llama31" rel="nofollow">Meta Llama 3.1</a> is the latest open LLM from Meta, a follow up iteration of Llama 3, released in July 2024. Meta Llama 3.1 comes in three sizes: 8B for efficient deployment and development on consumer-size GPU, 70B for large-scale AI native applications, and 405B for synthetic data, LLM as a Judge or distillation; among other use cases. Amongst Meta Llama 3.1 new features, the ones to highlight are: a large context length of 128K tokens (vs original 8K), multilingual capabilities, tool usage capabilities, and a more permissive license.',Ye,G,Tl='This example showcases how to deploy <a href="https://hf.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> on Vertex AI with an A3 accelerator-optimized instance with 8 NVIDIA H100s via the Hugging Face purpose-built Deep Learning Container (DLC) for Text Generation Inference (TGI) on Google Cloud.',ze,A,Jl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/model-in-hf-hub.png" alt="&#39;meta-llama/Meta-Llama-3.1-405B-Instruct-FP8&#39; in the Hugging Face Hub"/>',qe,v,De,Z,wl='First, you need to install <code>gcloud</code> in your local machine, which is the command-line tool for Google Cloud, following the instructions at <a href="https://cloud.google.com/sdk/docs/install" rel="nofollow">Cloud SDK Documentation - Install the gcloud CLI</a>.',Pe,B,gl="Then, you also need to install the <code>google-cloud-aiplatform</code> Python SDK, required to programmatically create the Vertex AI model, register it, acreate the endpoint, and deploy it on Vertex AI.",Oe,N,Ke,_,fl="Optionally, to ease the usage of the commands within this tutorial, you need to set the following environment variables for GCP:",et,$,tt,W,bl="Then you need to login into your GCP account and set the project ID to the one you want to use to register and deploy the models on Vertex AI.",lt,x,nt,V,Il="Once you are logged in, you need to enable the necessary service APIs in GCP, such as the Vertex AI API, the Compute Engine API, and Google Container Registry related APIs.",at,R,st,k,Cl='Once everything is set up, you can already initialize the Vertex AI session via the <a href="https://github.com/googleapis/python-aiplatform" rel="nofollow"><code>google-cloud-aiplatform</code></a> Python SDK as follows:',ot,Q,it,E,Mt,F,Gl='To serve <a href="https://hf.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> you need an instance with at least 400GiB of GPU VRAM that supports the FP8 data-type, and the A3 accelerator-optimized machines on Google Cloud are the machines you would need to use.',pt,H,Al='Even if the A3 accelerator-optimized machines with 8 x NVIDIA H100 80GB GPUs are available within Google Cloud, you will still need to request a custom quota increase in Google Cloud, as those need a specific approval. Note that the A3 accelerator-optimized machines are only available in some zones, so make sure to check the availability of both A3 High or even A3 Mega per zone at <a href="https://cloud.google.com/compute/docs/gpus/gpu-regions-zones" rel="nofollow">Compute Engine - GPU regions and zones</a>.',rt,X,vl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/a3-general-availability.png" alt="A3 availability in Google Cloud"/>',dt,S,Zl="In this case, to request a quota increase to use the machine with 8 NVIDIA H100s you will need to increase the following quotas:",ct,L,Bl="<li><code>Service: Vertex AI API</code> and <code>Name: Custom model serving Nvidia H100 80GB GPUs per region</code> set to <strong>8</strong></li> <li><code>Service: Vertex AI API</code> and <code>Name: Custom model serving A3 CPUs per region</code> set to <strong>208</strong></li>",ut,Y,Nl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/a3-quota-request.png" alt="A3 Quota Request in Google Cloud"/>',ht,z,_l='Read more on how to request a quota increase at <a href="https://cloud.google.com/docs/quotas/view-manage" rel="nofollow">Google Cloud Documentation - View and manage quotas</a>.',yt,q,mt,D,$l='Since <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> is a gated model, you need to login into your Hugging Face Hub account, accept the gating requirements, and then generate an access token either with fine-grained read access to the gated model only (recommended), or read-access to your account.',jt,P,Wl='Read more about <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">access tokens for the Hugging Face Hub</a>.',Ut,O,xl='To authenticate, you can either use the <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow"><code>huggingface_hub</code></a> Python SDK as shown below (recommended), or just set the environment variable <code>HF_TOKEN</code> instead.',Tt,K,Jt,ee,wt,te,Vl="Then you can already “upload” the model i.e. register the model on Vertex AI. It is not an upload per se, since the model will be automatically downloaded from the Hugging Face Hub in the Hugging Face DLC for TGI on startup via the <code>MODEL_ID</code> environment variable, so what is uploaded is only the configuration, not the model weights.",gt,le,Rl="Before going into the code, let’s quickly review the arguments provided to the <code>upload</code> method:",ft,ne,kl='<li><strong><code>display_name</code></strong> is the name that will be shown in the Vertex AI Model Registry.</li> <li><strong><code>serving_container_image_uri</code></strong> is the location of the Hugging Face DLC for TGI that will be used for serving the model.</li> <li><strong><code>serving_container_environment_variables</code></strong> are the environment variables that will be used during the container runtime, so these are aligned with the environment variables defined by TGI via the <a href="https://huggingface.co/docs/text-generation-inference/en/basic_tutorials/launcher" rel="nofollow"><code>text-generation-launcher</code></a>, which exposes some environment variables such as the following:<ul><li><code>MODEL_ID</code> the model ID on the Hugging Face Hub.</li> <li><code>NUM_SHARD</code> the number of shards to use i.e. the number of GPUs to use, in this case set to 8 as a node with 8 NVIDIA H100s will be used.</li> <li><code>HUGGING_FACE_HUB_TOKEN</code> is the Hugging Face Hub token, required as <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow"><code>meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</code></a> is a gated model.</li> <li><code>HF_HUB_ENABLE_HF_TRANSFER</code> to enable a faster download speed via the <a href="https://github.com/huggingface/hf_transfer" rel="nofollow"><code>hf_transfer</code></a> library.</li></ul></li>',bt,ae,Ql='For more information on the supported arguments, check <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_upload" rel="nofollow"><code>aiplatform.Model.upload</code> Python reference</a>.',It,g,Ct,se,Gt,oe,El='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/vertex-ai-model.png" alt="Meta Llama 3.1 405B FP8 registered on Vertex AI"/>',At,ie,vt,Me,Fl="Once Meta Llama 3.1 405B is registered on Vertex AI Model Registry, you can already deploy it on a Vertex AI Endpoint with the Hugging Face DLC for TGI.",Zt,pe,Hl="The <code>deploy</code> method will link the previously created endpoint resource with the model that contains the configuration of the serving container, and then, it will deploy the model on Vertex AI in the specified instance.",Bt,re,Xl="Before going into the code, let’s quickly review the arguments provided to the <code>deploy</code> method:",Nt,de,Sl='<li><strong><code>endpoint</code></strong> is the endpoint to deploy the model to, which is optional, and by default will be set to the model display name with the <code>_endpoint</code> suffix.</li> <li><strong><code>machine_type</code></strong>, <strong><code>accelerator_type</code></strong> and <strong><code>accelerator_count</code></strong> are arguments that define which instance to use, and additionally, the accelerator to use and the number of accelerators, respectively. The <code>machine_type</code> and the <code>accelerator_type</code> are tied together, so you will need to select an instance that supports the accelerator that you are using and vice-versa. More information about the different instances at <a href="https://cloud.google.com/compute/docs/gpus" rel="nofollow">Compute Engine Documentation - GPU machine types</a>, and about the <code>accelerator_type</code> naming at <a href="https://cloud.google.com/vertex-ai/docs/reference/rest/v1/MachineSpec" rel="nofollow">Vertex AI Documentation - MachineSpec</a>.</li>',_t,ce,Ll='For more information on the supported arguments you can check <a href="https://cloud.google.com/python/docs/reference/aiplatform/latest/google.cloud.aiplatform.Model#google_cloud_aiplatform_Model_deploy" rel="nofollow"><code>aiplatform.Model.deploy</code> Python reference</a>.',$t,f,Wt,ue,xt,he,Yl='[!WARN][`meta-llama/Meta-Llama-3.1-405B-Instruct-FP8`](<a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8" rel="nofollow">https://huggingface.co/meta-llama/Meta-Llama-3.1-405B-Instruct-FP8</a>) deployment on Vertex AI will take ~30 minutes to deploy, as it needs to allocate the resources on Google Cloud, and then download the weights from the Hugging Face Hub (~10 minutes) and load those for inference in TGI (~3 minutes).',Vt,ye,zl='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/vertex-ai-endpoint.png" alt="Meta Llama 3.1 405B Instruct FP8 deployed on Vertex AI"/>',Rt,me,kt,je,ql="Finally, you can run the online predictions on Vertex AI using the <code>predict</code> method, which will send the requests to the running endpoint in the <code>/predict</code> route specified within the container following Vertex AI I/O payload formatting.",Qt,Ue,Dl="As <code>/generate</code> is the endpoint that is being exposed through TGI on Vertex AI, you will need to format the messages with the chat template before sending the request to Vertex AI, so you will need to install 🤗<code>transformers</code> to use the <code>apply_chat_template</code> method from the <code>PreTrainedTokenizerFast</code>.",Et,Te,Ft,Je,Pl="And then apply the chat template to a conversation using the tokenizer as follows:",Ht,we,Xt,ge,Ol='Which is what you will be sending within the payload to the deployed Vertex AI Endpoint, as well as the generation parameters as in <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">Consuming Text Generation Inference (TGI) -&gt; Generate</a>.',St,fe,Lt,be,Yt,Ie,Kl="If you are willing to run the online prediction within the current session, you can send requests programmatically via the <code>aiplatform.Endpoint</code> (returned by the <code>aiplatform.Model.deploy</code> method) as in the following snippet:",zt,Ce,qt,Ge,en="Producing the following <code>output</code>:",Dt,Ae,Pt,ve,Ot,Ze,tn="If the Vertex AI Endpoint was deployed in a different session and you want to use it but don’t have access to the <code>deployed_model</code> variable returned by the <code>aiplatform.Model.deploy</code> method as in the previous section; you can also run the following snippet to instantiate the deployed <code>aiplatform.Endpoint</code> via its resource name as <code>projects/{PROJECT_ID}/locations/{LOCATION}/endpoints/{ENDPOINT_ID}</code>.",Kt,b,el,Be,tl,Ne,ln="Producing the following <code>output</code>:",ll,_e,nl,$e,al,We,nn="Alternatively, for testing purposes you can also use the Vertex AI Online Prediction UI, that provides a field that expects the JSON payload formatted according to the Vertex AI specification (as in the examples above) being:",sl,xe,ol,Ve,an='<img src="https://raw.githubusercontent.com/huggingface/Google-Cloud-Containers/main/examples/vertex-ai/notebooks/deploy-llama-3-1-405b-on-vertex-ai/assets/vertex-ai-online-prediction.png" alt="Meta Llama 3.1 405B Instruct FP8 online prediction on Vertex AI"/>',il,Re,Ml,ke,sn="Finally, you can release the resources that you’ve created as follows, to avoid unnecessary costs:",pl,Qe,on="<li><code>deployed_model.undeploy_all</code> to undeploy the model from all the endpoints.</li> <li><code>deployed_model.delete</code> to delete the endpoint/s where the model was deployed gracefully, after the <code>undeploy_all</code> method.</li> <li><code>model.delete</code> to delete the model from the registry.</li>",rl,Ee,dl,Fe,Mn="Alternatively, you can also remove those from the Google Cloud Console following the steps:",cl,He,pn="<li>Go to Vertex AI in Google Cloud</li> <li>Go to Deploy and use -&gt; Online prediction</li> <li>Click on the endpoint and then on the deployed model/s to “Undeploy model from endpoint”</li> <li>Then go back to the endpoint list and remove the endpoint</li> <li>Finally, go to Deploy and use -&gt; Model Registry, and remove the model</li>",ul,Xe,hl,Se,yl;return I=new T({props:{title:"Deploy Meta Llama 3.1 405B with TGI DLC on Vertex AI",local:"deploy-meta-llama-31-405b-with-tgi-dlc-on-vertex-ai",headingTag:"h1"}}),v=new T({props:{title:"Setup / Configuration",local:"setup--configuration",headingTag:"h2"}}),N=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwZ29vZ2xlLWNsb3VkLWFpcGxhdGZvcm0=",highlighted:"!pip install --upgrade --quiet google-cloud-aiplatform",wrap:!1}}),$=new j({props:{code:"JTI1ZW52JTIwUFJPSkVDVF9JRCUzRHlvdXItcHJvamVjdC1pZCUwQSUyNWVudiUyMExPQ0FUSU9OJTNEeW91ci1sb2NhdGlvbiUwQSUyNWVudiUyMENPTlRBSU5FUl9VUkklM0R1cy1kb2NrZXIucGtnLmRldiUyRmRlZXBsZWFybmluZy1wbGF0Zm9ybS1yZWxlYXNlJTJGZ2NyLmlvJTJGaHVnZ2luZ2ZhY2UtdGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZS1jdTEyNC4yLTMudWJ1bnR1MjIwNC5weTMxMQ==",highlighted:`%env PROJECT_ID=your-project-<span class="hljs-built_in">id</span>
%env LOCATION=your-location
%env CONTAINER_URI=us-docker.pkg.dev/deeplearning-platform-release/gcr.io/huggingface-text-generation-inference-cu124<span class="hljs-number">.2</span>-<span class="hljs-number">3.</span>ubuntu2204.py311`,wrap:!1}}),x=new j({props:{code:"IWdjbG91ZCUyMGF1dGglMjBsb2dpbiUwQSFnY2xvdWQlMjBhdXRoJTIwYXBwbGljYXRpb24tZGVmYXVsdCUyMGxvZ2luJTIwJTIwJTIzJTIwRm9yJTIwbG9jYWwlMjBkZXZlbG9wbWVudCUwQSFnY2xvdWQlMjBjb25maWclMjBzZXQlMjBwcm9qZWN0JTIwJTI0UFJPSkVDVF9JRA==",highlighted:`!gcloud auth login
!gcloud auth application-default login  <span class="hljs-comment"># For local development</span>
!gcloud config <span class="hljs-built_in">set</span> project $PROJECT_ID`,wrap:!1}}),R=new j({props:{code:"IWdjbG91ZCUyMHNlcnZpY2VzJTIwZW5hYmxlJTIwYWlwbGF0Zm9ybS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbXB1dGUuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXIuZ29vZ2xlYXBpcy5jb20lMEEhZ2Nsb3VkJTIwc2VydmljZXMlMjBlbmFibGUlMjBjb250YWluZXJyZWdpc3RyeS5nb29nbGVhcGlzLmNvbSUwQSFnY2xvdWQlMjBzZXJ2aWNlcyUyMGVuYWJsZSUyMGNvbnRhaW5lcmZpbGVzeXN0ZW0uZ29vZ2xlYXBpcy5jb20=",highlighted:`!gcloud services enable aiplatform.googleapis.com
!gcloud services enable compute.googleapis.com
!gcloud services enable container.googleapis.com
!gcloud services enable containerregistry.googleapis.com
!gcloud services enable containerfilesystem.googleapis.com`,wrap:!1}}),Q=new j({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZ29vZ2xlLmNsb3VkJTIwaW1wb3J0JTIwYWlwbGF0Zm9ybSUwQSUwQWFpcGxhdGZvcm0uaW5pdCglMEElMjAlMjAlMjAlMjBwcm9qZWN0JTNEb3MuZ2V0ZW52KCUyMlBST0pFQ1RfSUQlMjIpJTJDJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0Rvcy5nZXRlbnYoJTIyTE9DQVRJT04lMjIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(
    project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>),
    location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>),
)`,wrap:!1}}),E=new T({props:{title:"Quotas on Google Cloud",local:"quotas-on-google-cloud",headingTag:"h3"}}),q=new T({props:{title:"Register model on Vertex AI",local:"register-model-on-vertex-ai",headingTag:"h2"}}),K=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"!pip install --upgrade --quiet huggingface_hub",wrap:!1}}),ee=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGludGVycHJldGVyX2xvZ2luJTBBJTBBaW50ZXJwcmV0ZXJfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> interpreter_login

interpreter_login()`,wrap:!1}}),g=new ml({props:{$$slots:{default:[gn]},$$scope:{ctx:w}}}),se=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF90b2tlbiUwQSUwQW1vZGVsJTIwJTNEJTIwYWlwbGF0Zm9ybS5Nb2RlbC51cGxvYWQoJTBBJTIwJTIwJTIwJTIwZGlzcGxheV9uYW1lJTNEJTIybWV0YS1sbGFtYS0tTWV0YS1MbGFtYS0zLjEtNDA1Qi1JbnN0cnVjdC1GUDglMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9pbWFnZV91cmklM0QlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjBzZXJ2aW5nX2NvbnRhaW5lcl9lbnZpcm9ubWVudF92YXJpYWJsZXMlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNT0RFTF9JRCUyMiUzQSUyMCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMuMS00MDVCLUluc3RydWN0LUZQOCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhVR0dJTkdfRkFDRV9IVUJfVE9LRU4lMjIlM0ElMjBnZXRfdG9rZW4oKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhGX0hVQl9FTkFCTEVfSEZfVFJBTlNGRVIlMjIlM0ElMjAlMjIxJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyTlVNX1NIQVJEJTIyJTNBJTIwJTIyOCUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEFtb2RlbC53YWl0KCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token

model = aiplatform.Model.upload(
    display_name=<span class="hljs-string">&quot;meta-llama--Meta-Llama-3.1-405B-Instruct-FP8&quot;</span>,
    serving_container_image_uri=<span class="hljs-string">&quot;&quot;</span>,
    serving_container_environment_variables={
        <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-405B-Instruct-FP8&quot;</span>,
        <span class="hljs-string">&quot;HUGGING_FACE_HUB_TOKEN&quot;</span>: get_token(),
        <span class="hljs-string">&quot;HF_HUB_ENABLE_HF_TRANSFER&quot;</span>: <span class="hljs-string">&quot;1&quot;</span>,
        <span class="hljs-string">&quot;NUM_SHARD&quot;</span>: <span class="hljs-string">&quot;8&quot;</span>,
    },
)
model.wait()`,wrap:!1}}),ie=new T({props:{title:"Deploy model on Vertex AI",local:"deploy-model-on-vertex-ai",headingTag:"h2"}}),f=new ml({props:{$$slots:{default:[fn]},$$scope:{ctx:w}}}),ue=new j({props:{code:"ZGVwbG95ZWRfbW9kZWwlMjAlM0QlMjBtb2RlbC5kZXBsb3koJTBBJTIwJTIwJTIwJTIwZW5kcG9pbnQlM0RhaXBsYXRmb3JtLkVuZHBvaW50LmNyZWF0ZShkaXNwbGF5X25hbWUlM0QlMjJNZXRhLUxsYW1hLTMuMS00MDVCLUZQOC1FbmRwb2ludCUyMiklMkMlMEElMjAlMjAlMjAlMjBtYWNoaW5lX3R5cGUlM0QlMjJhMy1oaWdoZ3B1LThnJTIyJTJDJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3JfdHlwZSUzRCUyMk5WSURJQV9IMTAwXzgwR0IlMjIlMkMlMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvcl9jb3VudCUzRDglMkMlMEElMjAlMjAlMjAlMjBlbmFibGVfYWNjZXNzX2xvZ2dpbmclM0RUcnVlJTJDJTBBKQ==",highlighted:`deployed_model = model.deploy(
    endpoint=aiplatform.Endpoint.create(display_name=<span class="hljs-string">&quot;Meta-Llama-3.1-405B-FP8-Endpoint&quot;</span>),
    machine_type=<span class="hljs-string">&quot;a3-highgpu-8g&quot;</span>,
    accelerator_type=<span class="hljs-string">&quot;NVIDIA_H100_80GB&quot;</span>,
    accelerator_count=<span class="hljs-number">8</span>,
    enable_access_logging=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),me=new T({props:{title:"Online predictions on Vertex AI",local:"online-predictions-on-vertex-ai",headingTag:"h2"}}),Te=new j({props:{code:"JTI1JTI1YmFzaCUwQXBpcCUyMGluc3RhbGwlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0JTIwdHJhbnNmb3JtZXJz",highlighted:`%%bash
pip install --upgrade --quiet transformers`,wrap:!1}}),we=new j({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwZ2V0X3Rva2VuJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLjEtNDA1Qi1JbnN0cnVjdC1GUDglMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbiUzRGdldF90b2tlbigpJTJDJTBBKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhbiUyMGFzc2lzdGFudCUyMHRoYXQlMjByZXNwb25kcyUyMGFzJTIwYSUyMHBpcmF0ZS4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBUaGVvcnklMjBvZiUyMFJlbGF0aXZpdHklM0YlMjIlN0QlMkMlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTBBKSUwQSUyMyUyMCUzQyU3Q2JlZ2luX29mX3RleHQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0VzeXN0ZW0lM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q25Zb3UlMjBhcmUlMjBhbiUyMGFzc2lzdGFudCUyMHRoYXQlMjByZXNwb25kcyUyMGFzJTIwYSUyMHBpcmF0ZS4lM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0V1c2VyJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuV2hhdCdzJTIwdGhlJTIwVGhlb3J5JTIwb2YlMjBSZWxhdGl2aXR5JTNGJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNu",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_token
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Meta-Llama-3.1-405B-Instruct-FP8&quot;</span>,
    token=get_token(),
)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are an assistant that responds as a pirate.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the Theory of Relativity?&quot;</span>},
]
inputs = tokenizer.apply_chat_template(
    messages,
    tokenize=<span class="hljs-literal">False</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
)
<span class="hljs-comment"># &lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are an assistant that responds as a pirate.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat&#x27;s the Theory of Relativity?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n</span>`,wrap:!1}}),fe=new T({props:{title:"Via Python",local:"via-python",headingTag:"h3"}}),be=new T({props:{title:"Within the same session",local:"within-the-same-session",headingTag:"h4"}}),Ce=new j({props:{code:"b3V0cHV0JTIwJTNEJTIwZGVwbG95ZWRfbW9kZWwucHJlZGljdCglMEElMjAlMjAlMjAlMjBpbnN0YW5jZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJpbnB1dHMlMjIlM0ElMjAlMjIlM0MlN0NiZWdpbl9vZl90ZXh0JTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFc3lzdGVtJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuWW91JTIwYXJlJTIwYW4lMjBhc3Npc3RhbnQlMjB0aGF0JTIwcmVzcG9uZHMlMjBhcyUyMGElMjBwaXJhdGUuJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFdXNlciUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlNUNuJTVDbldoYXQncyUyMHRoZSUyMFRoZW9yeSUyMG9mJTIwUmVsYXRpdml0eSUzRiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRWFzc2lzdGFudCUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlNUNuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQSUyMDEyOCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3BfcCUyMiUzQSUyMDAuOTUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDEuMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMEFwcmludChvdXRwdXQucHJlZGljdGlvbnMlNUIwJTVEKQ==",highlighted:`output = deployed_model.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are an assistant that responds as a pirate.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat&#x27;s the Theory of Relativity?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>,
            },
        },
    ]
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),Ae=new j({props:{code:"UHJlZGljdGlvbihwcmVkaWN0aW9ucyUzRCU1QiUyMlllciUyMHdhbnQlMjB0YSUyMGtub3clMjBhYm91dCUyMHRoZW0lMjBmYW5jeSUyMHNjaWVuY2UlMjB0aGluZ3MlMkMlMjBlaCUzRiUyMEFscmlnaHQlMjB0aGVuJTJDJTIwbWF0ZXklMkMlMjBzZXR0bGUlMjB5ZXJzZWxmJTIwZG93biUyMHdpdGglMjBhJTIwcGludCUyMG8nJTIwZ3JvZyUyMGFuZCUyMGxpc3RlbiUyMGNsb3NlLiUyMEklMjBiZSUyMHRlbGxpbiclMjB5ZSUyMGFib3V0JTIwdGhlJTIwVGhlb3J5JTIwbyclMjBSZWxhdGl2aXR5JTJDJTIwYXMlMjBwcm9wb3NlZCUyMGJ5JTIwdGhhdCUyMHN3YXNoYnVja2xpbiclMjBnZW5pdXMlMkMlMjBBbGJlcnQlMjBFaW5zdGVpbi4lNUNuJTVDbk5vdyUyQyUyMHllJTIwc2VlJTJDJTIwRWluc3RlaW4lMjBzYWlkJTIwdGhhdCUyMHRpbWUlMjBhbmQlMjBzcGFjZSUyMGJlJTIwY29ubmVjdGVkJTIwbGlrZSUyMHRoZSUyMHNlYSUyMGFuZCUyMHRoZSUyMHdpbmQuJTIwWWUlMjBjYW4ndCUyMGhhdmUlMjBvbmUlMjB3aXRob3V0JTIwdGhlJTIwb3RoZXIlMkMlMjBzYXZ2eSUzRiUyMEFuZCUyMGhlJTIwcHJvcG9zZWQlMjB0aGF0JTIwaG93JTIweWUlMjBzZWUlMjB0aW1lJTIwYW5kJTIwc3BhY2UlMjBkZXBlbmRzJTIwb24lMjBob3clMjBmYXN0JTIweWUlMjBiZSUyMG1vdmluJyUyMGFuZCUyMHdoZXJlJTIweWUlMjBiZSUyMHN0YW5kaW4nLiUyMFRoYXQlMjBiZSUyMGNhbGxlZCUyMHJlbGF0aXZpdHklMkMlMjBtZSUyMiU1RCUyQyUyMGRlcGxveWVkX21vZGVsX2lkJTNEJyoqKiclMkMlMjBtZXRhZGF0YSUzRE5vbmUlMkMlMjBtb2RlbF92ZXJzaW9uX2lkJTNEJzEnJTJDJTIwbW9kZWxfcmVzb3VyY2VfbmFtZSUzRCdwcm9qZWN0cyUyRioqKiUyRmxvY2F0aW9ucyUyRnVzLWNlbnRyYWwxJTJGbW9kZWxzJTJGKioqJyUyQyUyMGV4cGxhbmF0aW9ucyUzRE5vbmUp",highlighted:'<span class="hljs-type">Prediction</span>(predictions=[<span class="hljs-comment">&quot;Yer want ta know about them fancy science things, eh? Alright then, matey, settle yerself down with a pint o&#x27; grog and listen close. I be tellin&#x27; ye about the Theory o&#x27; Relativity, as proposed by that swashbucklin&#x27; genius, Albert Einstein.\\n\\nNow, ye see, Einstein said that time and space be connected like the sea and the wind. Ye can&#x27;t have one without the other, savvy? And he proposed that how ye see time and space depends on how fast ye be movin&#x27; and where ye be standin&#x27;. That be called relativity, me&quot;</span>], deployed_model_id=<span class="hljs-string">&#x27;***&#x27;</span>, metadata=<span class="hljs-type">None</span>, model_version_id=<span class="hljs-string">&#x27;1&#x27;</span>, model_resource_name=<span class="hljs-string">&#x27;projects/***/locations/us-central1/models/***&#x27;</span>, explanations=<span class="hljs-type">None</span>)',wrap:!1}}),ve=new T({props:{title:"From a different session",local:"from-a-different-session",headingTag:"h4"}}),b=new ml({props:{$$slots:{default:[bn]},$$scope:{ctx:w}}}),Be=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> google.cloud <span class="hljs-keyword">import</span> aiplatform

aiplatform.init(project=os.getenv(<span class="hljs-string">&quot;PROJECT_ID&quot;</span>), location=os.getenv(<span class="hljs-string">&quot;LOCATION&quot;</span>))

endpoint_display_name = <span class="hljs-string">&quot;Meta-Llama-3.1-405B-FP8-Endpoint&quot;</span>  <span class="hljs-comment"># <span class="hljs-doctag">TODO:</span> change to your endpoint display name</span>

<span class="hljs-comment"># Iterates over all the Vertex AI Endpoints within the current project and keeps the first match (if any), otherwise set to None</span>
ENDPOINT_ID = <span class="hljs-built_in">next</span>(
    (endpoint.name <span class="hljs-keyword">for</span> endpoint <span class="hljs-keyword">in</span> aiplatform.Endpoint.<span class="hljs-built_in">list</span>() <span class="hljs-keyword">if</span> endpoint.display_name == endpoint_display_name), <span class="hljs-literal">None</span>
)
<span class="hljs-keyword">assert</span> ENDPOINT_ID, (
    <span class="hljs-string">&quot;\`ENDPOINT_ID\` is not set, please make sure that the \`endpoint_display_name\` is correct at &quot;</span>
    <span class="hljs-string">f&quot;https://console.cloud.google.com/vertex-ai/online-prediction/endpoints?project=<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>&quot;</span>
)

endpoint = aiplatform.Endpoint(
    <span class="hljs-string">f&quot;projects/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;PROJECT_ID&#x27;</span>)}</span>/locations/<span class="hljs-subst">{os.getenv(<span class="hljs-string">&#x27;LOCATION&#x27;</span>)}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_ID}</span>&quot;</span>
)
output = endpoint.predict(
    instances=[
        {
            <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are an assistant that responds as a pirate.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat&#x27;s the Theory of Relativity?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">128</span>,
                <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>,
                <span class="hljs-string">&quot;top_p&quot;</span>: <span class="hljs-number">0.95</span>,
                <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">0.7</span>,
            },
        },
    ],
)
<span class="hljs-built_in">print</span>(output.predictions[<span class="hljs-number">0</span>])`,wrap:!1}}),_e=new j({props:{code:"UHJlZGljdGlvbihwcmVkaWN0aW9ucyUzRCU1QiUyMlllciUyMGxvb2tpbiclMjBmZXIlMjBhJTIwdHJlYXN1cmUlMjB0cm92ZSUyMG8nJTIwa25vd2xlZGdlJTIwYWJvdXQlMjB0aGVtJTIwZmFuY3klMjBwaHlzaWNzJTJDJTIwZWglM0YlMjBBbHJpZ2h0JTIwdGhlbiUyQyUyMG1hdGV5JTJDJTIwc2V0dGxlJTIweWVyc2VsZiUyMGRvd24lMjB3aXRoJTIwYSUyMHBpbnQlMjBvJyUyMGdyb2clMjBhbmQlMjBsaXN0ZW4lMjBjbG9zZSUyQyUyMGFzJTIwSSUyMHNwaW4lMjB5ZSUyMHRoZSUyMHlhcm4lMjBvJyUyMEVpbnN0ZWluJ3MlMjBUaGVvcnklMjBvJyUyMFJlbGF0aXZpdHkuJTVDbiU1Q25JdCUyMGJlJTIwYSUyMHRhbGUlMjBvJyUyMHR3byUyMHBhcnRzJTJDJTIwbWUlMjBoZWFydHklM0ElMjBTcGVjaWFsJTIwUmVsYXRpdml0eSUyMGFuZCUyMEdlbmVyYWwlMjBSZWxhdGl2aXR5LiUyME5vdyUyQyUyMEklMjBrbm93JTIwd2hhdCUyMHllJTIwYmUlMjB0aGlua2luJyUzQSUyMHdoYXQlMjBpbiUyMGJsYXplcyUyMGJlJTIwdGhlJTIwZGlmZmVyZW5jZSUzRiUyMFdlbGwlMkMlMjBtYXRleSUyQyUyMGxldCUyMG1lJTIwYnJlYWslMjBpdCUyMGRvd24lMjBmZXIlMjB5ZS4lNUNuJTVDblNwZWNpYWwlMjBSZWxhdGl2aXR5JTIwYmUlMjB0aGUlMjBpZGVhJTIwdGhhdCUyMHRpbWUlMjBhbmQlMjBzcGFjZSUyMGJlJTIwY29ubmVjdGVkJTIwbGlrZSUyMHRoZSUyMHNlYSUyMGFuZCUyMHRoZSUyMHNreS4lMjIlNUQlMkMlMjBkZXBsb3llZF9tb2RlbF9pZCUzRCcqKionJTJDJTIwbWV0YWRhdGElM0ROb25lJTJDJTIwbW9kZWxfdmVyc2lvbl9pZCUzRCcxJyUyQyUyMG1vZGVsX3Jlc291cmNlX25hbWUlM0QncHJvamVjdHMlMkYqKiolMkZsb2NhdGlvbnMlMkZ1cy1jZW50cmFsMSUyRm1vZGVscyUyRioqKiclMkMlMjBleHBsYW5hdGlvbnMlM0ROb25lKQ==",highlighted:'Prediction(predictions=[<span class="hljs-string">&quot;Yer lookin&#x27; fer a treasure trove o&#x27; knowledge about them fancy physics, eh? Alright then, matey, settle yerself down with a pint o&#x27; grog and listen close, as I spin ye the yarn o&#x27; Einstein&#x27;s Theory o&#x27; Relativity.\\n\\nIt be a tale o&#x27; two parts, me hearty: Special Relativity and General Relativity. Now, I know what ye be thinkin&#x27;: what in blazes be the difference? Well, matey, let me break it down fer ye.\\n\\nSpecial Relativity be the idea that time and space be connected like the sea and the sky.&quot;</span>], <span class="hljs-attribute">deployed_model_id</span>=<span class="hljs-string">&#x27;***&#x27;</span>, <span class="hljs-attribute">metadata</span>=None, <span class="hljs-attribute">model_version_id</span>=<span class="hljs-string">&#x27;1&#x27;</span>, <span class="hljs-attribute">model_resource_name</span>=<span class="hljs-string">&#x27;projects/***/locations/us-central1/models/***&#x27;</span>, <span class="hljs-attribute">explanations</span>=None)',wrap:!1}}),$e=new T({props:{title:"Via the Vertex AI Online Prediction UI",local:"via-the-vertex-ai-online-prediction-ui",headingTag:"h3"}}),xe=new j({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5zdGFuY2VzJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyJTNDJTdDYmVnaW5fb2ZfdGV4dCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXN5c3RlbSUzQyU3Q2VuZF9oZWFkZXJfaWQlN0MlM0UlNUNuJTVDbllvdSUyMGFyZSUyMGFuJTIwYXNzaXN0YW50JTIwdGhhdCUyMHJlc3BvbmRzJTIwYXMlMjBhJTIwcGlyYXRlLiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q25XaGF0J3MlMjB0aGUlMjBUaGVvcnklMjBvZiUyMFJlbGF0aXZpdHklM0YlM0MlN0Nlb3RfaWQlN0MlM0UlM0MlN0NzdGFydF9oZWFkZXJfaWQlN0MlM0Vhc3Npc3RhbnQlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYXJhbWV0ZXJzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMjglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkb19zYW1wbGUlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydG9wX3AlMjIlM0ElMjAwLjk1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGVtcGVyYXR1cmUlMjIlM0ElMjAwLjclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;instances&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are an assistant that responds as a pirate.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat&#x27;s the Theory of Relativity?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;max_new_tokens&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">128</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;do_sample&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;top_p&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.95</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;temperature&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.7</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Re=new T({props:{title:"Resource clean-up",local:"resource-clean-up",headingTag:"h2"}}),Ee=new j({props:{code:"ZGVwbG95ZWRfbW9kZWwudW5kZXBsb3lfYWxsKCklMEFkZXBsb3llZF9tb2RlbC5kZWxldGUoKSUwQW1vZGVsLmRlbGV0ZSgp",highlighted:`deployed_model.undeploy_all()
deployed_model.delete()
model.delete()`,wrap:!1}}),Xe=new wn({props:{source:"https://github.com/huggingface/Google-Cloud-Containers/blob/main/docs/source/examples/vertex-ai-notebooks-deploy-llama-3-1-405b-on-vertex-ai.mdx"}}),{c(){p=o("meta"),U=a(),m=o("p"),J=a(),r(I.$$.fragment),Le=a(),C=o("p"),C.innerHTML=Ul,Ye=a(),G=o("p"),G.innerHTML=Tl,ze=a(),A=o("p"),A.innerHTML=Jl,qe=a(),r(v.$$.fragment),De=a(),Z=o("p"),Z.innerHTML=wl,Pe=a(),B=o("p"),B.innerHTML=gl,Oe=a(),r(N.$$.fragment),Ke=a(),_=o("p"),_.textContent=fl,et=a(),r($.$$.fragment),tt=a(),W=o("p"),W.textContent=bl,lt=a(),r(x.$$.fragment),nt=a(),V=o("p"),V.textContent=Il,at=a(),r(R.$$.fragment),st=a(),k=o("p"),k.innerHTML=Cl,ot=a(),r(Q.$$.fragment),it=a(),r(E.$$.fragment),Mt=a(),F=o("p"),F.innerHTML=Gl,pt=a(),H=o("p"),H.innerHTML=Al,rt=a(),X=o("p"),X.innerHTML=vl,dt=a(),S=o("p"),S.textContent=Zl,ct=a(),L=o("ul"),L.innerHTML=Bl,ut=a(),Y=o("p"),Y.innerHTML=Nl,ht=a(),z=o("p"),z.innerHTML=_l,yt=a(),r(q.$$.fragment),mt=a(),D=o("p"),D.innerHTML=$l,jt=a(),P=o("p"),P.innerHTML=Wl,Ut=a(),O=o("p"),O.innerHTML=xl,Tt=a(),r(K.$$.fragment),Jt=a(),r(ee.$$.fragment),wt=a(),te=o("p"),te.innerHTML=Vl,gt=a(),le=o("p"),le.innerHTML=Rl,ft=a(),ne=o("ul"),ne.innerHTML=kl,bt=a(),ae=o("p"),ae.innerHTML=Ql,It=a(),r(g.$$.fragment),Ct=a(),r(se.$$.fragment),Gt=a(),oe=o("p"),oe.innerHTML=El,At=a(),r(ie.$$.fragment),vt=a(),Me=o("p"),Me.textContent=Fl,Zt=a(),pe=o("p"),pe.innerHTML=Hl,Bt=a(),re=o("p"),re.innerHTML=Xl,Nt=a(),de=o("ul"),de.innerHTML=Sl,_t=a(),ce=o("p"),ce.innerHTML=Ll,$t=a(),r(f.$$.fragment),Wt=a(),r(ue.$$.fragment),xt=a(),he=o("p"),he.innerHTML=Yl,Vt=a(),ye=o("p"),ye.innerHTML=zl,Rt=a(),r(me.$$.fragment),kt=a(),je=o("p"),je.innerHTML=ql,Qt=a(),Ue=o("p"),Ue.innerHTML=Dl,Et=a(),r(Te.$$.fragment),Ft=a(),Je=o("p"),Je.textContent=Pl,Ht=a(),r(we.$$.fragment),Xt=a(),ge=o("p"),ge.innerHTML=Ol,St=a(),r(fe.$$.fragment),Lt=a(),r(be.$$.fragment),Yt=a(),Ie=o("p"),Ie.innerHTML=Kl,zt=a(),r(Ce.$$.fragment),qt=a(),Ge=o("p"),Ge.innerHTML=en,Dt=a(),r(Ae.$$.fragment),Pt=a(),r(ve.$$.fragment),Ot=a(),Ze=o("p"),Ze.innerHTML=tn,Kt=a(),r(b.$$.fragment),el=a(),r(Be.$$.fragment),tl=a(),Ne=o("p"),Ne.innerHTML=ln,ll=a(),r(_e.$$.fragment),nl=a(),r($e.$$.fragment),al=a(),We=o("p"),We.textContent=nn,sl=a(),r(xe.$$.fragment),ol=a(),Ve=o("p"),Ve.innerHTML=an,il=a(),r(Re.$$.fragment),Ml=a(),ke=o("p"),ke.textContent=sn,pl=a(),Qe=o("ul"),Qe.innerHTML=on,rl=a(),r(Ee.$$.fragment),dl=a(),Fe=o("p"),Fe.textContent=Mn,cl=a(),He=o("ul"),He.innerHTML=pn,ul=a(),r(Xe.$$.fragment),hl=a(),Se=o("p"),this.h()},l(e){const t=Tn("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),U=s(e),m=i(e,"P",{}),un(m).forEach(l),J=s(e),d(I.$$.fragment,e),Le=s(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-1n624pr"&&(C.innerHTML=Ul),Ye=s(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-tsvylf"&&(G.innerHTML=Tl),ze=s(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-70vy49"&&(A.innerHTML=Jl),qe=s(e),d(v.$$.fragment,e),De=s(e),Z=i(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-1o67gfb"&&(Z.innerHTML=wl),Pe=s(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1ebrquh"&&(B.innerHTML=gl),Oe=s(e),d(N.$$.fragment,e),Ke=s(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1i8n6rq"&&(_.textContent=fl),et=s(e),d($.$$.fragment,e),tt=s(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-15nvzfz"&&(W.textContent=bl),lt=s(e),d(x.$$.fragment,e),nt=s(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1nm8o2l"&&(V.textContent=Il),at=s(e),d(R.$$.fragment,e),st=s(e),k=i(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1f1rnfu"&&(k.innerHTML=Cl),ot=s(e),d(Q.$$.fragment,e),it=s(e),d(E.$$.fragment,e),Mt=s(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-49fshu"&&(F.innerHTML=Gl),pt=s(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1ylcy5e"&&(H.innerHTML=Al),rt=s(e),X=i(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-1iv75k3"&&(X.innerHTML=vl),dt=s(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1s5855i"&&(S.textContent=Zl),ct=s(e),L=i(e,"UL",{"data-svelte-h":!0}),M(L)!=="svelte-caffm5"&&(L.innerHTML=Bl),ut=s(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1foax17"&&(Y.innerHTML=Nl),ht=s(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1sivr44"&&(z.innerHTML=_l),yt=s(e),d(q.$$.fragment,e),mt=s(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-14ie1f2"&&(D.innerHTML=$l),jt=s(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1bvo1af"&&(P.innerHTML=Wl),Ut=s(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-16zhg01"&&(O.innerHTML=xl),Tt=s(e),d(K.$$.fragment,e),Jt=s(e),d(ee.$$.fragment,e),wt=s(e),te=i(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1voap9p"&&(te.innerHTML=Vl),gt=s(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-zklutt"&&(le.innerHTML=Rl),ft=s(e),ne=i(e,"UL",{"data-svelte-h":!0}),M(ne)!=="svelte-18m17zt"&&(ne.innerHTML=kl),bt=s(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1f83l3s"&&(ae.innerHTML=Ql),It=s(e),d(g.$$.fragment,e),Ct=s(e),d(se.$$.fragment,e),Gt=s(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-oqn4nj"&&(oe.innerHTML=El),At=s(e),d(ie.$$.fragment,e),vt=s(e),Me=i(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-1cjntg8"&&(Me.textContent=Fl),Zt=s(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-njbdvc"&&(pe.innerHTML=Hl),Bt=s(e),re=i(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-1ezlr9j"&&(re.innerHTML=Xl),Nt=s(e),de=i(e,"UL",{"data-svelte-h":!0}),M(de)!=="svelte-1mv29i5"&&(de.innerHTML=Sl),_t=s(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-1d6p8k5"&&(ce.innerHTML=Ll),$t=s(e),d(f.$$.fragment,e),Wt=s(e),d(ue.$$.fragment,e),xt=s(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-53huk4"&&(he.innerHTML=Yl),Vt=s(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-72g3wd"&&(ye.innerHTML=zl),Rt=s(e),d(me.$$.fragment,e),kt=s(e),je=i(e,"P",{"data-svelte-h":!0}),M(je)!=="svelte-166ya0u"&&(je.innerHTML=ql),Qt=s(e),Ue=i(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1i26vhx"&&(Ue.innerHTML=Dl),Et=s(e),d(Te.$$.fragment,e),Ft=s(e),Je=i(e,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-xmsalg"&&(Je.textContent=Pl),Ht=s(e),d(we.$$.fragment,e),Xt=s(e),ge=i(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-rrzyzn"&&(ge.innerHTML=Ol),St=s(e),d(fe.$$.fragment,e),Lt=s(e),d(be.$$.fragment,e),Yt=s(e),Ie=i(e,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-hnmp6i"&&(Ie.innerHTML=Kl),zt=s(e),d(Ce.$$.fragment,e),qt=s(e),Ge=i(e,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-d9pmg3"&&(Ge.innerHTML=en),Dt=s(e),d(Ae.$$.fragment,e),Pt=s(e),d(ve.$$.fragment,e),Ot=s(e),Ze=i(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-gm5hxo"&&(Ze.innerHTML=tn),Kt=s(e),d(b.$$.fragment,e),el=s(e),d(Be.$$.fragment,e),tl=s(e),Ne=i(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-d9pmg3"&&(Ne.innerHTML=ln),ll=s(e),d(_e.$$.fragment,e),nl=s(e),d($e.$$.fragment,e),al=s(e),We=i(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1ajbcx5"&&(We.textContent=nn),sl=s(e),d(xe.$$.fragment,e),ol=s(e),Ve=i(e,"P",{"data-svelte-h":!0}),M(Ve)!=="svelte-17ryinf"&&(Ve.innerHTML=an),il=s(e),d(Re.$$.fragment,e),Ml=s(e),ke=i(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-762i25"&&(ke.textContent=sn),pl=s(e),Qe=i(e,"UL",{"data-svelte-h":!0}),M(Qe)!=="svelte-16ibgml"&&(Qe.innerHTML=on),rl=s(e),d(Ee.$$.fragment,e),dl=s(e),Fe=i(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-sgegyq"&&(Fe.textContent=Mn),cl=s(e),He=i(e,"UL",{"data-svelte-h":!0}),M(He)!=="svelte-1p833nz"&&(He.innerHTML=pn),ul=s(e),d(Xe.$$.fragment,e),hl=s(e),Se=i(e,"P",{}),un(Se).forEach(l),this.h()},h(){hn(p,"name","hf:doc:metadata"),hn(p,"content",Cn)},m(e,t){Jn(document.head,p),n(e,U,t),n(e,m,t),n(e,J,t),c(I,e,t),n(e,Le,t),n(e,C,t),n(e,Ye,t),n(e,G,t),n(e,ze,t),n(e,A,t),n(e,qe,t),c(v,e,t),n(e,De,t),n(e,Z,t),n(e,Pe,t),n(e,B,t),n(e,Oe,t),c(N,e,t),n(e,Ke,t),n(e,_,t),n(e,et,t),c($,e,t),n(e,tt,t),n(e,W,t),n(e,lt,t),c(x,e,t),n(e,nt,t),n(e,V,t),n(e,at,t),c(R,e,t),n(e,st,t),n(e,k,t),n(e,ot,t),c(Q,e,t),n(e,it,t),c(E,e,t),n(e,Mt,t),n(e,F,t),n(e,pt,t),n(e,H,t),n(e,rt,t),n(e,X,t),n(e,dt,t),n(e,S,t),n(e,ct,t),n(e,L,t),n(e,ut,t),n(e,Y,t),n(e,ht,t),n(e,z,t),n(e,yt,t),c(q,e,t),n(e,mt,t),n(e,D,t),n(e,jt,t),n(e,P,t),n(e,Ut,t),n(e,O,t),n(e,Tt,t),c(K,e,t),n(e,Jt,t),c(ee,e,t),n(e,wt,t),n(e,te,t),n(e,gt,t),n(e,le,t),n(e,ft,t),n(e,ne,t),n(e,bt,t),n(e,ae,t),n(e,It,t),c(g,e,t),n(e,Ct,t),c(se,e,t),n(e,Gt,t),n(e,oe,t),n(e,At,t),c(ie,e,t),n(e,vt,t),n(e,Me,t),n(e,Zt,t),n(e,pe,t),n(e,Bt,t),n(e,re,t),n(e,Nt,t),n(e,de,t),n(e,_t,t),n(e,ce,t),n(e,$t,t),c(f,e,t),n(e,Wt,t),c(ue,e,t),n(e,xt,t),n(e,he,t),n(e,Vt,t),n(e,ye,t),n(e,Rt,t),c(me,e,t),n(e,kt,t),n(e,je,t),n(e,Qt,t),n(e,Ue,t),n(e,Et,t),c(Te,e,t),n(e,Ft,t),n(e,Je,t),n(e,Ht,t),c(we,e,t),n(e,Xt,t),n(e,ge,t),n(e,St,t),c(fe,e,t),n(e,Lt,t),c(be,e,t),n(e,Yt,t),n(e,Ie,t),n(e,zt,t),c(Ce,e,t),n(e,qt,t),n(e,Ge,t),n(e,Dt,t),c(Ae,e,t),n(e,Pt,t),c(ve,e,t),n(e,Ot,t),n(e,Ze,t),n(e,Kt,t),c(b,e,t),n(e,el,t),c(Be,e,t),n(e,tl,t),n(e,Ne,t),n(e,ll,t),c(_e,e,t),n(e,nl,t),c($e,e,t),n(e,al,t),n(e,We,t),n(e,sl,t),c(xe,e,t),n(e,ol,t),n(e,Ve,t),n(e,il,t),c(Re,e,t),n(e,Ml,t),n(e,ke,t),n(e,pl,t),n(e,Qe,t),n(e,rl,t),c(Ee,e,t),n(e,dl,t),n(e,Fe,t),n(e,cl,t),n(e,He,t),n(e,ul,t),c(Xe,e,t),n(e,hl,t),n(e,Se,t),yl=!0},p(e,[t]){const rn={};t&2&&(rn.$$scope={dirty:t,ctx:e}),g.$set(rn);const dn={};t&2&&(dn.$$scope={dirty:t,ctx:e}),f.$set(dn);const cn={};t&2&&(cn.$$scope={dirty:t,ctx:e}),b.$set(cn)},i(e){yl||(u(I.$$.fragment,e),u(v.$$.fragment,e),u(N.$$.fragment,e),u($.$$.fragment,e),u(x.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(E.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(g.$$.fragment,e),u(se.$$.fragment,e),u(ie.$$.fragment,e),u(f.$$.fragment,e),u(ue.$$.fragment,e),u(me.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(Ce.$$.fragment,e),u(Ae.$$.fragment,e),u(ve.$$.fragment,e),u(b.$$.fragment,e),u(Be.$$.fragment,e),u(_e.$$.fragment,e),u($e.$$.fragment,e),u(xe.$$.fragment,e),u(Re.$$.fragment,e),u(Ee.$$.fragment,e),u(Xe.$$.fragment,e),yl=!0)},o(e){h(I.$$.fragment,e),h(v.$$.fragment,e),h(N.$$.fragment,e),h($.$$.fragment,e),h(x.$$.fragment,e),h(R.$$.fragment,e),h(Q.$$.fragment,e),h(E.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(g.$$.fragment,e),h(se.$$.fragment,e),h(ie.$$.fragment,e),h(f.$$.fragment,e),h(ue.$$.fragment,e),h(me.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(Ce.$$.fragment,e),h(Ae.$$.fragment,e),h(ve.$$.fragment,e),h(b.$$.fragment,e),h(Be.$$.fragment,e),h(_e.$$.fragment,e),h($e.$$.fragment,e),h(xe.$$.fragment,e),h(Re.$$.fragment,e),h(Ee.$$.fragment,e),h(Xe.$$.fragment,e),yl=!1},d(e){e&&(l(U),l(m),l(J),l(Le),l(C),l(Ye),l(G),l(ze),l(A),l(qe),l(De),l(Z),l(Pe),l(B),l(Oe),l(Ke),l(_),l(et),l(tt),l(W),l(lt),l(nt),l(V),l(at),l(st),l(k),l(ot),l(it),l(Mt),l(F),l(pt),l(H),l(rt),l(X),l(dt),l(S),l(ct),l(L),l(ut),l(Y),l(ht),l(z),l(yt),l(mt),l(D),l(jt),l(P),l(Ut),l(O),l(Tt),l(Jt),l(wt),l(te),l(gt),l(le),l(ft),l(ne),l(bt),l(ae),l(It),l(Ct),l(Gt),l(oe),l(At),l(vt),l(Me),l(Zt),l(pe),l(Bt),l(re),l(Nt),l(de),l(_t),l(ce),l($t),l(Wt),l(xt),l(he),l(Vt),l(ye),l(Rt),l(kt),l(je),l(Qt),l(Ue),l(Et),l(Ft),l(Je),l(Ht),l(Xt),l(ge),l(St),l(Lt),l(Yt),l(Ie),l(zt),l(qt),l(Ge),l(Dt),l(Pt),l(Ot),l(Ze),l(Kt),l(el),l(tl),l(Ne),l(ll),l(nl),l(al),l(We),l(sl),l(ol),l(Ve),l(il),l(Ml),l(ke),l(pl),l(Qe),l(rl),l(dl),l(Fe),l(cl),l(He),l(ul),l(hl),l(Se)),l(p),y(I,e),y(v,e),y(N,e),y($,e),y(x,e),y(R,e),y(Q,e),y(E,e),y(q,e),y(K,e),y(ee,e),y(g,e),y(se,e),y(ie,e),y(f,e),y(ue,e),y(me,e),y(Te,e),y(we,e),y(fe,e),y(be,e),y(Ce,e),y(Ae,e),y(ve,e),y(b,e),y(Be,e),y(_e,e),y($e,e),y(xe,e),y(Re,e),y(Ee,e),y(Xe,e)}}}const Cn='{"title":"Deploy Meta Llama 3.1 405B with TGI DLC on Vertex AI","local":"deploy-meta-llama-31-405b-with-tgi-dlc-on-vertex-ai","sections":[{"title":"Setup / Configuration","local":"setup--configuration","sections":[{"title":"Quotas on Google Cloud","local":"quotas-on-google-cloud","sections":[],"depth":3}],"depth":2},{"title":"Register model on Vertex AI","local":"register-model-on-vertex-ai","sections":[],"depth":2},{"title":"Deploy model on Vertex AI","local":"deploy-model-on-vertex-ai","sections":[],"depth":2},{"title":"Online predictions on Vertex AI","local":"online-predictions-on-vertex-ai","sections":[{"title":"Via Python","local":"via-python","sections":[{"title":"Within the same session","local":"within-the-same-session","sections":[],"depth":4},{"title":"From a different session","local":"from-a-different-session","sections":[],"depth":4}],"depth":3},{"title":"Via the Vertex AI Online Prediction UI","local":"via-the-vertex-ai-online-prediction-ui","sections":[],"depth":3}],"depth":2},{"title":"Resource clean-up","local":"resource-clean-up","sections":[],"depth":2}],"depth":1}';function Gn(w){return mn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _n extends jn{constructor(p){super(),Un(this,p,Gn,In,yn,{})}}export{_n as component};
