import{s as ls,f as ss,n as Ms,o as as}from"../chunks/scheduler.7bc62968.js";import{S as ts,i as es,g as j,s as t,r as n,A as ns,h as U,f as M,c as e,j as Ol,u as J,x as I,k as Yl,y as Js,a,v as T,d as y,t as p,w}from"../chunks/index.66556066.js";import{C as c}from"../chunks/CodeBlock.a759539a.js";import{H as i,E as Ts}from"../chunks/EditOnGithub.46ca76a5.js";function ys(Nl){let m,ll,K,sl,C,Ml,A,vl="A GGUF parser that works on remotely hosted files.",al,h,tl,P,Wl,el,u,_l='Spec: <a href="https://github.com/ggerganov/ggml/blob/master/docs/gguf.md" rel="nofollow">https://github.com/ggerganov/ggml/blob/master/docs/gguf.md</a>',nl,g,Rl='Reference implementation (Python): <a href="https://github.com/ggerganov/llama.cpp/blob/master/gguf-py/gguf/gguf_reader.py" rel="nofollow">https://github.com/ggerganov/llama.cpp/blob/master/gguf-py/gguf/gguf_reader.py</a>',Jl,o,Tl,r,yl,f,pl,d,wl,b,jl,$,Ul,G,Il,S,il,Z,Vl='By default, known fields in <code>metadata</code> are typed. This includes various fields found in <a href="https://github.com/ggerganov/llama.cpp" rel="nofollow">llama.cpp</a>, <a href="https://github.com/ggerganov/whisper.cpp" rel="nofollow">whisper.cpp</a> and <a href="https://github.com/ggerganov/ggml" rel="nofollow">ggml</a>.',ml,L,cl,B,Cl,k,xl='Because GGUF format can be used to store tensors, we can technically use it for other usages. For example, storing <a href="https://github.com/ggerganov/llama.cpp/pull/5970" rel="nofollow">control vectors</a>, <a href="https://github.com/ggerganov/llama.cpp/pull/2632" rel="nofollow">lora weights</a>, etc.',Al,E,Fl="In case you want to use your own GGUF metadata structure, you can disable strict typing by casting the parse output to <code>GGUFParseOutput&lt;{ strict: false }&gt;</code>:",hl,Q,ul,Y,gl,N,Hl='This package provides a CLI equivalent to <a href="https://github.com/ggml-org/llama.cpp/blob/7a2c913e66353362d7f28d612fd3c9d51a831eda/gguf-py/gguf/scripts/gguf_dump.py" rel="nofollow"><code>gguf_dump.py</code></a> script. You can dump GGUF metadata and list of tensors using this command:',ol,v,rl,W,Dl="Example for the output:",fl,_,dl,R,zl="Alternatively, you can install this package as global, which will provide the <code>gguf-view</code> command:",bl,V,$l,x,Gl,F,ql="The Hub supports all file formats and has built-in features for GGUF format.",Sl,H,Xl='Find more information at: <a href="http://hf.co/docs/hub/gguf" rel="nofollow">http://hf.co/docs/hub/gguf</a>.',Zl,D,Ll,z,Pl='<li><a href="https://github.com/hyparam/hyllama" rel="nofollow">https://github.com/hyparam/hyllama</a> by @platypii (MIT license)</li> <li><a href="https://github.com/ahoylabs/gguf.js" rel="nofollow">https://github.com/ahoylabs/gguf.js</a> by @biw @dkogut1996 @spencekim (MIT license)</li>',Bl,q,Kl="🔥❤️",kl,X,El,O,Ql;return C=new i({props:{title:"@huggingface/gguf",local:"huggingfacegguf",headingTag:"h1"}}),h=new i({props:{title:"Spec",local:"spec",headingTag:"h2"}}),o=new i({props:{title:"Install",local:"install",headingTag:"h2"}}),r=new c({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGZ2d1Zg==",highlighted:"npm install @huggingface/gguf",wrap:!1}}),f=new i({props:{title:"Usage",local:"usage",headingTag:"h2"}}),d=new i({props:{title:"Basic usage",local:"basic-usage",headingTag:"h3"}}),b=new c({props:{code:"aW1wb3J0JTIwJTdCJTIwR0dNTFF1YW50aXphdGlvblR5cGUlMkMlMjBnZ3VmJTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGZ2d1ZiUyMiUzQiUwQSUwQSUyRiUyRiUyMHJlbW90ZSUyMEdHVUYlMjBmaWxlJTIwZnJvbSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZUaGVCbG9rZSUyRkxsYW1hLTItN0ItQ2hhdC1HR1VGJTBBY29uc3QlMjBVUkxfTExBTUElMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGVGhlQmxva2UlMkZMbGFtYS0yLTdCLUNoYXQtR0dVRiUyRnJlc29sdmUlMkYxOTEyMzliJTJGbGxhbWEtMi03Yi1jaGF0LlEyX0suZ2d1ZiUyMiUzQiUwQSUwQWNvbnN0JTIwJTdCJTIwbWV0YWRhdGElMkMlMjB0ZW5zb3JJbmZvcyUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ2d1ZihVUkxfTExBTUEpJTNCJTBBJTBBY29uc29sZS5sb2cobWV0YWRhdGEpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwdmVyc2lvbiUzQSUyMDIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjB0ZW5zb3JfY291bnQlM0ElMjAyOTFuJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwa3ZfY291bnQlM0ElMjAxOW4lMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJnZW5lcmFsLmFyY2hpdGVjdHVyZSUyMiUzQSUyMCUyMmxsYW1hJTIyJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZ2VuZXJhbC5maWxlX3R5cGUlMjIlM0ElMjAxMCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMmdlbmVyYWwubmFtZSUyMiUzQSUyMCUyMkxMYU1BJTIwdjIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAuLi4lMEElMkYlMkYlMjAlN0QlMEElMEFjb25zb2xlLmxvZyh0ZW5zb3JJbmZvcyklM0IlMEElMkYlMkYlMjAlNUIlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBuYW1lJTNBJTIwJTIydG9rZW5fZW1iZC53ZWlnaHQlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaGFwZSUzQSUyMCU1QjQwOTZuJTJDJTIwMzIwMDBuJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZHR5cGUlM0ElMjBHR01MUXVhbnRpemF0aW9uVHlwZS5RMl9LJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwLi4uJTIwJTJDJTBBJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmFtZSUzQSUyMCUyMm91dHB1dF9ub3JtLndlaWdodCUyMiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNoYXBlJTNBJTIwJTVCNDA5Nm4lNUQlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkdHlwZSUzQSUyMEdHTUxRdWFudGl6YXRpb25UeXBlLkYzMiUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyRiUyRiUyMCU1RCUwQQ==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">GGMLQuantizationType</span>, gguf } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/gguf&quot;</span>;

<span class="hljs-comment">// remote GGUF file from https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGUF</span>
<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">URL_LLAMA</span> = <span class="hljs-string">&quot;https://huggingface.co/TheBloke/Llama-2-7B-Chat-GGUF/resolve/191239b/llama-2-7b-chat.Q2_K.gguf&quot;</span>;

<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_LLAMA</span>);

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(metadata);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//     version: 2,</span>
<span class="hljs-comment">//     tensor_count: 291n,</span>
<span class="hljs-comment">//     kv_count: 19n,</span>
<span class="hljs-comment">//     &quot;general.architecture&quot;: &quot;llama&quot;,</span>
<span class="hljs-comment">//     &quot;general.file_type&quot;: 10,</span>
<span class="hljs-comment">//     &quot;general.name&quot;: &quot;LLaMA v2&quot;,</span>
<span class="hljs-comment">//     ...</span>
<span class="hljs-comment">// }</span>

<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(tensorInfos);
<span class="hljs-comment">// [</span>
<span class="hljs-comment">//     {</span>
<span class="hljs-comment">//         name: &quot;token_embd.weight&quot;,</span>
<span class="hljs-comment">//         shape: [4096n, 32000n],</span>
<span class="hljs-comment">//         dtype: GGMLQuantizationType.Q2_K,</span>
<span class="hljs-comment">//     },</span>

<span class="hljs-comment">//     ... ,</span>

<span class="hljs-comment">//     {</span>
<span class="hljs-comment">//         name: &quot;output_norm.weight&quot;,</span>
<span class="hljs-comment">//         shape: [4096n],</span>
<span class="hljs-comment">//         dtype: GGMLQuantizationType.F32,</span>
<span class="hljs-comment">//     }</span>
<span class="hljs-comment">// ]</span>
`,wrap:!1}}),$=new i({props:{title:"Reading a local file",local:"reading-a-local-file",headingTag:"h3"}}),G=new c({props:{code:"JTJGJTJGJTIwUmVhZGluZyUyMGElMjBsb2NhbCUyMGZpbGUuJTIwKE5vdCUyMHN1cHBvcnRlZCUyMG9uJTIwYnJvd3NlciklMEFjb25zdCUyMCU3QiUyMG1ldGFkYXRhJTJDJTIwdGVuc29ySW5mb3MlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMGdndWYoJTBBJTIwJTIwJy4lMkZteV9tb2RlbC5nZ3VmJyUyQyUwQSUyMCUyMCU3QiUyMGFsbG93TG9jYWxGaWxlJTNBJTIwdHJ1ZSUyMCU3RCUyQyUwQSklM0I=",highlighted:`<span class="hljs-comment">// Reading a local file. (Not supported on browser)</span>
<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(
  <span class="hljs-string">&#x27;./my_model.gguf&#x27;</span>,
  { <span class="hljs-attr">allowLocalFile</span>: <span class="hljs-literal">true</span> },
);`,wrap:!1}}),S=new i({props:{title:"Strictly typed",local:"strictly-typed",headingTag:"h3"}}),L=new c({props:{code:"Y29uc3QlMjAlN0IlMjBtZXRhZGF0YSUyQyUyMHRlbnNvckluZm9zJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBnZ3VmKFVSTF9NT0RFTCklM0IlMEElMEElMkYlMkYlMjBUeXBlJTIwY2hlY2slMjBmb3IlMjBtb2RlbCUyMGFyY2hpdGVjdHVyZSUyMGF0JTIwcnVudGltZSUwQWlmJTIwKG1ldGFkYXRhJTVCJTIyZ2VuZXJhbC5hcmNoaXRlY3R1cmUlMjIlNUQlMjAlM0QlM0QlM0QlMjAlMjJsbGFtYSUyMiklMjAlN0IlMEElMEElMjAlMjAlMkYlMkYlMjAlMjJsbGFtYS5hdHRlbnRpb24uaGVhZF9jb3VudCUyMiUyMGlzJTIwYSUyMHZhbGlkJTIwa2V5JTIwZm9yJTIwbGxhbWElMjBhcmNoaXRlY3R1cmUlMkMlMjB0aGlzJTIwaXMlMjB0eXBlZCUyMGFzJTIwYSUyMG51bWJlciUwQSUyMCUyMGNvbnNvbGUubG9nKG1vZGVsJTVCJTIybGxhbWEuYXR0ZW50aW9uLmhlYWRfY291bnQlMjIlNUQpJTNCJTBBJTBBJTIwJTIwJTJGJTJGJTIwJTIybWFtYmEuc3NtLmNvbnZfa2VybmVsJTIyJTIwaXMlMjBhbiUyMGludmFsaWQlMjBrZXklMkMlMjBiZWNhdXNlJTIwaXQlMjByZXF1aXJlcyUyMG1vZGVsJTIwYXJjaGl0ZWN0dXJlJTIwdG8lMjBiZSUyMG1hbWJhJTBBJTIwJTIwY29uc29sZS5sb2cobW9kZWwlNUIlMjJtYW1iYS5zc20uY29udl9rZXJuZWwlMjIlNUQpJTNCJTIwJTJGJTJGJTIwZXJyb3IlMEElN0Q=",highlighted:`<span class="hljs-keyword">const</span> { metadata, tensorInfos } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_MODEL</span>);

<span class="hljs-comment">// Type check for model architecture at runtime</span>
<span class="hljs-keyword">if</span> (metadata[<span class="hljs-string">&quot;general.architecture&quot;</span>] === <span class="hljs-string">&quot;llama&quot;</span>) {

  <span class="hljs-comment">// &quot;llama.attention.head_count&quot; is a valid key for llama architecture, this is typed as a number</span>
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(model[<span class="hljs-string">&quot;llama.attention.head_count&quot;</span>]);

  <span class="hljs-comment">// &quot;mamba.ssm.conv_kernel&quot; is an invalid key, because it requires model architecture to be mamba</span>
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(model[<span class="hljs-string">&quot;mamba.ssm.conv_kernel&quot;</span>]); <span class="hljs-comment">// error</span>
}`,wrap:!1}}),B=new i({props:{title:"Disable strictly typed",local:"disable-strictly-typed",headingTag:"h3"}}),Q=new c({props:{code:"Y29uc3QlMjAlN0IlMjBtZXRhZGF0YSUyQyUyMHRlbnNvckluZm9zJTIwJTdEJTNBJTIwR0dVRlBhcnNlT3V0cHV0JTNDJTdCJTIwc3RyaWN0JTNBJTIwZmFsc2UlMjAlN0QlM0UlMjAlM0QlMjBhd2FpdCUyMGdndWYoVVJMX0xMQU1BKSUzQg==",highlighted:'<span class="hljs-keyword">const</span> { metadata, tensorInfos }: <span class="hljs-title class_">GGUFParseOutput</span>&lt;{ <span class="hljs-attr">strict</span>: <span class="hljs-literal">false</span> }&gt; = <span class="hljs-keyword">await</span> <span class="hljs-title function_">gguf</span>(<span class="hljs-variable constant_">URL_LLAMA</span>);',wrap:!1}}),Y=new i({props:{title:"Command line interface",local:"command-line-interface",headingTag:"h2"}}),v=new c({props:{code:"bnB4JTIwJTQwaHVnZ2luZ2ZhY2UlMkZnZ3VmJTIwbXlfbW9kZWwuZ2d1ZiUwQSUwQSUyMyUyMG9yJTJDJTIwd2l0aCUyMGElMjByZW1vdGUlMjBHR1VGJTIwZmlsZSUzQSUwQSUyMyUyMG5weCUyMCU0MGh1Z2dpbmdmYWNlJTJGZ2d1ZiUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZiYXJ0b3dza2klMkZMbGFtYS0zLjItMUItSW5zdHJ1Y3QtR0dVRiUyRnJlc29sdmUlMkZtYWluJTJGTGxhbWEtMy4yLTFCLUluc3RydWN0LVE0X0tfTS5nZ3Vm",highlighted:`npx @huggingface/gguf my_model.gguf

<span class="hljs-comment"># or, with a remote GGUF file:</span>
<span class="hljs-comment"># npx @huggingface/gguf https://huggingface.co/bartowski/Llama-3.2-1B-Instruct-GGUF/resolve/main/Llama-3.2-1B-Instruct-Q4_K_M.gguf</span>`,wrap:!1}}),_=new c({props:{code:"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",highlighted:`* Dumping <span class="hljs-number">36</span> key/value pair(s)
  Idx | <span class="hljs-type">Count</span>  | <span class="hljs-type">Value</span>                                                                            
  ----|<span class="hljs-type">--------|----------------------------------------------------------------------------------
    1</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">version</span> = <span class="hljs-number">3</span>                                                                      
    <span class="hljs-number">2</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">tensor_count</span> = <span class="hljs-number">292</span>                                                               
    <span class="hljs-number">3</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">kv_count</span> = <span class="hljs-number">33</span>                                                                    
    <span class="hljs-number">4</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.architecture = <span class="hljs-string">&quot;llama&quot;</span>                                                   
    <span class="hljs-number">5</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.type = <span class="hljs-string">&quot;model&quot;</span>                                                           
    <span class="hljs-number">6</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.name = <span class="hljs-string">&quot;Meta Llama 3.1 8B Instruct&quot;</span>                                      
    <span class="hljs-number">7</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.finetune = <span class="hljs-string">&quot;Instruct&quot;</span>                                                    
    <span class="hljs-number">8</span> |      <span class="hljs-type">1</span> | <span class="hljs-type">general</span>.basename = <span class="hljs-string">&quot;Meta-Llama-3.1&quot;</span>                                                   

[truncated]

* Dumping <span class="hljs-number">292</span> tensor(s)
  Idx | <span class="hljs-type">Num</span> Elements | <span class="hljs-type">Shape</span>                          | <span class="hljs-type">Data</span> <span class="hljs-keyword">Type</span> | <span class="hljs-type">Name</span>                     
  ----|<span class="hljs-type">--------------|--------------------------------|-----------|--------------------------
    1</span> |           <span class="hljs-type">64</span> |     <span class="hljs-type">64</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">F32</span>       | <span class="hljs-type">rope_freqs</span>.weight        
    <span class="hljs-number">2</span> |    <span class="hljs-type">525336576</span> |   <span class="hljs-type">4096</span>, <span class="hljs-number">128256</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">Q4_K</span>      | <span class="hljs-type">token_embd</span>.weight        
    <span class="hljs-number">3</span> |         <span class="hljs-type">4096</span> |   <span class="hljs-type">4096</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">F32</span>       | <span class="hljs-type">blk</span><span class="hljs-number">.0</span>.attn_norm.weight   
    <span class="hljs-number">4</span> |     <span class="hljs-type">58720256</span> |  <span class="hljs-type">14336</span>,   <span class="hljs-number">4096</span>,      <span class="hljs-number">1</span>,      <span class="hljs-number">1</span> | <span class="hljs-type">Q6_K</span>      | <span class="hljs-type">blk</span><span class="hljs-number">.0</span>.ffn_down.weight

[truncated]`,wrap:!1}}),V=new c({props:{code:"bnBtJTIwaSUyMC1nJTIwJTQwaHVnZ2luZ2ZhY2UlMkZnZ3VmJTBBZ2d1Zi12aWV3JTIwbXlfbW9kZWwuZ2d1Zg==",highlighted:`npm i -g @huggingface/gguf
gguf-view my_model.gguf`,wrap:!1}}),x=new i({props:{title:"Hugging Face Hub",local:"hugging-face-hub",headingTag:"h2"}}),D=new i({props:{title:"Acknowledgements & Inspirations",local:"acknowledgements--inspirations",headingTag:"h2"}}),X=new Ts({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/gguf/README.md"}}),{c(){m=j("meta"),ll=t(),K=j("p"),sl=t(),n(C.$$.fragment),Ml=t(),A=j("p"),A.textContent=vl,al=t(),n(h.$$.fragment),tl=t(),P=j("img"),el=t(),u=j("p"),u.innerHTML=_l,nl=t(),g=j("p"),g.innerHTML=Rl,Jl=t(),n(o.$$.fragment),Tl=t(),n(r.$$.fragment),yl=t(),n(f.$$.fragment),pl=t(),n(d.$$.fragment),wl=t(),n(b.$$.fragment),jl=t(),n($.$$.fragment),Ul=t(),n(G.$$.fragment),Il=t(),n(S.$$.fragment),il=t(),Z=j("p"),Z.innerHTML=Vl,ml=t(),n(L.$$.fragment),cl=t(),n(B.$$.fragment),Cl=t(),k=j("p"),k.innerHTML=xl,Al=t(),E=j("p"),E.innerHTML=Fl,hl=t(),n(Q.$$.fragment),ul=t(),n(Y.$$.fragment),gl=t(),N=j("p"),N.innerHTML=Hl,ol=t(),n(v.$$.fragment),rl=t(),W=j("p"),W.textContent=Dl,fl=t(),n(_.$$.fragment),dl=t(),R=j("p"),R.innerHTML=zl,bl=t(),n(V.$$.fragment),$l=t(),n(x.$$.fragment),Gl=t(),F=j("p"),F.textContent=ql,Sl=t(),H=j("p"),H.innerHTML=Xl,Zl=t(),n(D.$$.fragment),Ll=t(),z=j("ul"),z.innerHTML=Pl,Bl=t(),q=j("p"),q.textContent=Kl,kl=t(),n(X.$$.fragment),El=t(),O=j("p"),this.h()},l(l){const s=ns("svelte-u9bgzb",document.head);m=U(s,"META",{name:!0,content:!0}),s.forEach(M),ll=e(l),K=U(l,"P",{}),Ol(K).forEach(M),sl=e(l),J(C.$$.fragment,l),Ml=e(l),A=U(l,"P",{"data-svelte-h":!0}),I(A)!=="svelte-fetsp6"&&(A.textContent=vl),al=e(l),J(h.$$.fragment,l),tl=e(l),P=U(l,"IMG",{src:!0}),el=e(l),u=U(l,"P",{"data-svelte-h":!0}),I(u)!=="svelte-1oqo4ac"&&(u.innerHTML=_l),nl=e(l),g=U(l,"P",{"data-svelte-h":!0}),I(g)!=="svelte-9ned1"&&(g.innerHTML=Rl),Jl=e(l),J(o.$$.fragment,l),Tl=e(l),J(r.$$.fragment,l),yl=e(l),J(f.$$.fragment,l),pl=e(l),J(d.$$.fragment,l),wl=e(l),J(b.$$.fragment,l),jl=e(l),J($.$$.fragment,l),Ul=e(l),J(G.$$.fragment,l),Il=e(l),J(S.$$.fragment,l),il=e(l),Z=U(l,"P",{"data-svelte-h":!0}),I(Z)!=="svelte-117gony"&&(Z.innerHTML=Vl),ml=e(l),J(L.$$.fragment,l),cl=e(l),J(B.$$.fragment,l),Cl=e(l),k=U(l,"P",{"data-svelte-h":!0}),I(k)!=="svelte-mha1ue"&&(k.innerHTML=xl),Al=e(l),E=U(l,"P",{"data-svelte-h":!0}),I(E)!=="svelte-ix27qg"&&(E.innerHTML=Fl),hl=e(l),J(Q.$$.fragment,l),ul=e(l),J(Y.$$.fragment,l),gl=e(l),N=U(l,"P",{"data-svelte-h":!0}),I(N)!=="svelte-6r7bxk"&&(N.innerHTML=Hl),ol=e(l),J(v.$$.fragment,l),rl=e(l),W=U(l,"P",{"data-svelte-h":!0}),I(W)!=="svelte-7lmy1n"&&(W.textContent=Dl),fl=e(l),J(_.$$.fragment,l),dl=e(l),R=U(l,"P",{"data-svelte-h":!0}),I(R)!=="svelte-faupl"&&(R.innerHTML=zl),bl=e(l),J(V.$$.fragment,l),$l=e(l),J(x.$$.fragment,l),Gl=e(l),F=U(l,"P",{"data-svelte-h":!0}),I(F)!=="svelte-3kh4"&&(F.textContent=ql),Sl=e(l),H=U(l,"P",{"data-svelte-h":!0}),I(H)!=="svelte-3cfra"&&(H.innerHTML=Xl),Zl=e(l),J(D.$$.fragment,l),Ll=e(l),z=U(l,"UL",{"data-svelte-h":!0}),I(z)!=="svelte-1n1957i"&&(z.innerHTML=Pl),Bl=e(l),q=U(l,"P",{"data-svelte-h":!0}),I(q)!=="svelte-bgm0mh"&&(q.textContent=Kl),kl=e(l),J(X.$$.fragment,l),El=e(l),O=U(l,"P",{}),Ol(O).forEach(M),this.h()},h(){Yl(m,"name","hf:doc:metadata"),Yl(m,"content",ps),ss(P.src,Wl="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/gguf-spec.png")||Yl(P,"src",Wl)},m(l,s){Js(document.head,m),a(l,ll,s),a(l,K,s),a(l,sl,s),T(C,l,s),a(l,Ml,s),a(l,A,s),a(l,al,s),T(h,l,s),a(l,tl,s),a(l,P,s),a(l,el,s),a(l,u,s),a(l,nl,s),a(l,g,s),a(l,Jl,s),T(o,l,s),a(l,Tl,s),T(r,l,s),a(l,yl,s),T(f,l,s),a(l,pl,s),T(d,l,s),a(l,wl,s),T(b,l,s),a(l,jl,s),T($,l,s),a(l,Ul,s),T(G,l,s),a(l,Il,s),T(S,l,s),a(l,il,s),a(l,Z,s),a(l,ml,s),T(L,l,s),a(l,cl,s),T(B,l,s),a(l,Cl,s),a(l,k,s),a(l,Al,s),a(l,E,s),a(l,hl,s),T(Q,l,s),a(l,ul,s),T(Y,l,s),a(l,gl,s),a(l,N,s),a(l,ol,s),T(v,l,s),a(l,rl,s),a(l,W,s),a(l,fl,s),T(_,l,s),a(l,dl,s),a(l,R,s),a(l,bl,s),T(V,l,s),a(l,$l,s),T(x,l,s),a(l,Gl,s),a(l,F,s),a(l,Sl,s),a(l,H,s),a(l,Zl,s),T(D,l,s),a(l,Ll,s),a(l,z,s),a(l,Bl,s),a(l,q,s),a(l,kl,s),T(X,l,s),a(l,El,s),a(l,O,s),Ql=!0},p:Ms,i(l){Ql||(y(C.$$.fragment,l),y(h.$$.fragment,l),y(o.$$.fragment,l),y(r.$$.fragment,l),y(f.$$.fragment,l),y(d.$$.fragment,l),y(b.$$.fragment,l),y($.$$.fragment,l),y(G.$$.fragment,l),y(S.$$.fragment,l),y(L.$$.fragment,l),y(B.$$.fragment,l),y(Q.$$.fragment,l),y(Y.$$.fragment,l),y(v.$$.fragment,l),y(_.$$.fragment,l),y(V.$$.fragment,l),y(x.$$.fragment,l),y(D.$$.fragment,l),y(X.$$.fragment,l),Ql=!0)},o(l){p(C.$$.fragment,l),p(h.$$.fragment,l),p(o.$$.fragment,l),p(r.$$.fragment,l),p(f.$$.fragment,l),p(d.$$.fragment,l),p(b.$$.fragment,l),p($.$$.fragment,l),p(G.$$.fragment,l),p(S.$$.fragment,l),p(L.$$.fragment,l),p(B.$$.fragment,l),p(Q.$$.fragment,l),p(Y.$$.fragment,l),p(v.$$.fragment,l),p(_.$$.fragment,l),p(V.$$.fragment,l),p(x.$$.fragment,l),p(D.$$.fragment,l),p(X.$$.fragment,l),Ql=!1},d(l){l&&(M(ll),M(K),M(sl),M(Ml),M(A),M(al),M(tl),M(P),M(el),M(u),M(nl),M(g),M(Jl),M(Tl),M(yl),M(pl),M(wl),M(jl),M(Ul),M(Il),M(il),M(Z),M(ml),M(cl),M(Cl),M(k),M(Al),M(E),M(hl),M(ul),M(gl),M(N),M(ol),M(rl),M(W),M(fl),M(dl),M(R),M(bl),M($l),M(Gl),M(F),M(Sl),M(H),M(Zl),M(Ll),M(z),M(Bl),M(q),M(kl),M(El),M(O)),M(m),w(C,l),w(h,l),w(o,l),w(r,l),w(f,l),w(d,l),w(b,l),w($,l),w(G,l),w(S,l),w(L,l),w(B,l),w(Q,l),w(Y,l),w(v,l),w(_,l),w(V,l),w(x,l),w(D,l),w(X,l)}}}const ps='{"title":"@huggingface/gguf","local":"huggingfacegguf","sections":[{"title":"Spec","local":"spec","sections":[],"depth":2},{"title":"Install","local":"install","sections":[],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Basic usage","local":"basic-usage","sections":[],"depth":3},{"title":"Reading a local file","local":"reading-a-local-file","sections":[],"depth":3},{"title":"Strictly typed","local":"strictly-typed","sections":[],"depth":3},{"title":"Disable strictly typed","local":"disable-strictly-typed","sections":[],"depth":3}],"depth":2},{"title":"Command line interface","local":"command-line-interface","sections":[],"depth":2},{"title":"Hugging Face Hub","local":"hugging-face-hub","sections":[],"depth":2},{"title":"Acknowledgements & Inspirations","local":"acknowledgements--inspirations","sections":[],"depth":2}],"depth":1}';function ws(Nl){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends ts{constructor(m){super(),es(this,m,ws,ys,ls,{})}}export{ms as component};
