import{s as va,o as $a,n as Ut}from"../chunks/scheduler.2427eaa0.js";import{S as xa,i as Aa,g as i,s as a,r as c,B as ka,h as p,f as s,c as n,j as ba,u,x as r,k as ml,y as qa,a as l,v as y,d as h,t as d,w as m}from"../chunks/index.0f2ff8a3.js";import{T as Jt}from"../chunks/Tip.4e204c61.js";import{C as w}from"../chunks/CodeBlock.1bc84186.js";import{H as U,E as Ba}from"../chunks/index.6909200d.js";function Ga(j){let o,J='Want to be listed as an Inference Provider on the Hugging Face Hub? Please reach out to us on social networks or <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">here on the Hub</a>.';return{c(){o=i("p"),o.innerHTML=J},l(M){o=p(M,"P",{"data-svelte-h":!0}),r(o)!=="svelte-3qkokv"&&(o.innerHTML=J)},m(M,T){l(M,o,T)},p:Ut,d(M){M&&s(o)}}}function Ha(j){let o,J='If your implementation strictly follows the OpenAI API for LLMs and VLMs, you may be able to skip most of this section. In that case, simply open a PR on <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> to register.';return{c(){o=i("p"),o.innerHTML=J},l(M){o=p(M,"P",{"data-svelte-h":!0}),r(o)!=="svelte-90vl22"&&(o.innerHTML=J)},m(M,T){l(M,o,T)},p:Ut,d(M){M&&s(o)}}}function Za(j){let o,J=`Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.`;return{c(){o=i("p"),o.innerHTML=J},l(M){o=p(M,"P",{"data-svelte-h":!0}),r(o)!=="svelte-19q0jcc"&&(o.innerHTML=J)},m(M,T){l(M,o,T)},p:Ut,d(M){M&&s(o)}}}function _a(j){let o,J="To proceed with this step, we have to enable your account server-side. Make sure you have an organization on the Hub for your enterprise.";return{c(){o=i("p"),o.textContent=J},l(M){o=p(M,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1letj1o"&&(o.textContent=J)},m(M,T){l(M,o,T)},p:Ut,d(M){M&&s(o)}}}function Ra(j){let o,J='Important: Make sure that the JS client library can handle LoRA weights for your provider. Check out <a href="https://github.com/huggingface/huggingface.js/blob/904964c9f8cd10ed67114ccb88b9028e89fd6cad/packages/inference/src/providers/fal-ai.ts#L78-L124" rel="nofollow">fal’s implementation</a> for more details.';return{c(){o=i("p"),o.innerHTML=J},l(M){o=p(M,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1c6mi2m"&&(o.innerHTML=J)},m(M,T){l(M,o,T)},p:Ut,d(M){M&&s(o)}}}function Sa(j){let o,J="This is publicly accessible. It’s useful to be transparent by default and it helps debug client SDKs, etc.";return{c(){o=i("p"),o.textContent=J},l(M){o=p(M,"P",{"data-svelte-h":!0}),r(o)!=="svelte-94fcay"&&(o.textContent=J)},m(M,T){l(M,o,T)},p:Ut,d(M){M&&s(o)}}}function Wa(j){let o,J="Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.";return{c(){o=i("p"),o.innerHTML=J},l(M){o=p(M,"P",{"data-svelte-h":!0}),r(o)!=="svelte-33g0sl"&&(o.innerHTML=J)},m(M,T){l(M,o,T)},p:Ut,d(M){M&&s(o)}}}function Va(j){let o,J,M,T,k,jt,f,wt,q,Jl="This guide details the steps for registering as an inference provider on the Hub and provides implementation guidance.",ft,B,Ul='<li><strong>Implement standard task APIs</strong> - Follow our task API schemas for compatibility (see <a href="#1-prerequisites">Prerequisites</a>).</li> <li><strong>Submit a PR for JS client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> (see <a href="#2-js-client-integration">JS Client Integration</a>).</li> <li><strong>Register model mappings</strong> - Use our Model Mapping API to link your models to Hub models (see <a href="#3-model-mapping-api">Model Mapping API</a>).</li> <li><strong>Implement a billing endpoint</strong> - Provide an API for billing (see <a href="#4-billing">Billing</a>).</li> <li><strong>Submit a PR for Python client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> (see <a href="#5-python-client-integration">Python client integration</a>).</li> <li><strong>Register your provider server-side and provide an icon</strong> - Reach out to us to add your provider server-side and provide your SVG icon.</li> <li><strong>Create documentation on your side</strong> - Add documentation and do a lot of communication on your side.</li> <li><strong>Add a documentation page</strong> - Open a Pull Request in this repo (huggingface/hub-docs) to add a provider-specific page in the documentation.</li> <li><strong>Share share share</strong> do a lot of comms so that your integration is as successful as possible!</li>',gt,G,It,g,Ct,H,Tl=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> repo.`,bt,Z,jl=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation downstream (for Python SDK, to generate code snippets, etc.).`,vt,_,$t,R,wl=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,xt,I,fl='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',At,S,gl='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',kt,C,qt,W,Bt,V,Il=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,Gt,X,Cl=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,Ht,Q,bl='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',Zt,Y,_t,E,vl="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation. Here are the steps to follow:",Rt,N,St,F,$l="Create a new file under <code>packages/inference/src/providers/{provider_name}.ts</code> and copy-paste the following snippet.",Wt,P,Vt,z,xl="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. You have to define at least <code>makeRoute</code>, <code>preparePayload</code> and <code>getResponse</code>.",Xt,L,Al='If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern used in the existing providers implementation, e.g. <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/together.ts" rel="nofollow">Together AI provider implementation</a>.',Qt,D,kl='For text-generation and conversational tasks, you can just inherit from <code>BaseTextGenerationTask</code> and <code>BaseConversationalTask</code> respectively (defined in <a href="(https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/providerHelper.ts)">providerHelper.ts</a>) and override the methods if needed. Examples can be found in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/cerebras.ts" rel="nofollow">Cerebras</a> or <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/fireworks.ts" rel="nofollow">Fireworks</a> provider implementations.',Yt,O,Et,K,ql='Go to <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/lib/getProviderHelper.ts" rel="nofollow">packages/inference/src/lib/getProviderHelper.ts</a> and add your provider to <code>PROVIDERS</code>. You will need to add your provider to the <code>INFERENCE_PROVIDERS</code> list as well in <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/types.ts" rel="nofollow">packages/inference/src/types.ts</a>. Please try to respect alphabetical order.',Nt,ee,Bl='Update the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/README.md" rel="nofollow">README.md</a> in the <code>packages/inference</code> directory to include your provider in the list of supported providers and the list of supported models links.',Ft,te,Pt,se,Gl="Congratulations! You now have a JS implementation to successfully make inference calls on your infra! Time to integrate with the Hub!",zt,le,Hl="First step is to use the Model Mapping API to register which HF models are supported.",Lt,b,Dt,ae,Ot,ne,Kt,ie,Zl="Create a new mapping item, with the following body (JSON-encoded):",es,pe,ts,oe,_l=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different).</li>`,ss,re,Rl="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",ls,Me,as,ce,Sl=`We also support mapping HF models based on their <code>tags</code>. Using tag filters, you can automatically map multiple HF models to a single inference endpoint on your side.
For example, any model tagged with both <code>lora</code> and <code>base_model:adapter:black-forest-labs/FLUX.1-dev</code> can be mapped to your Flux-dev LoRA inference endpoint.`,ns,v,is,ue,Wl="The API is as follows:",ps,ye,os,he,Vl="Create a new mapping item, with the following body (JSON-encoded):",rs,de,Ms,me,Xl=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>tags</code> is the set of model tags to match. For example, to match all LoRAs of Flux, you can use: <code>[&quot;lora&quot;, &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot;]</code></li> <li><code>providerModel</code> is the model ID on your side (can be the same or different from the HF model ID).</li> <li><code>adapterType</code> is a literal value that helps client libraries interpret how to call your API. The only supported value at the moment is <code>&quot;lora&quot;</code>.</li>`,cs,Je,Ql="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",us,Ue,ys,Te,Yl=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,hs,je,ds,we,El="The endpoint validates that:",ms,fe,Nl=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>(in the future) we auto-test that the Partner’s API successfully responds to a
huggingface.js/inference call of the corresponding task i.e. the API specs are valid.</li>`,Js,ge,Us,Ie,Ts,Ce,Fl=`Where <code>mapping ID</code> is the mapping’s id obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,js,be,ws,ve,Pl="Call this HTTP PUT endpoint:",fs,$e,gs,xe,zl="With the following body (JSON-encoded):",Is,Ae,Cs,ke,Ll=`Where <code>mapping ID</code> is the mapping’s id obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,bs,qe,vs,Be,$s,Ge,Dl="This gets all mapping items from the DB. For clarity, the output is grouped by task.",xs,$,As,He,Ol="Here is an example of response:",ks,Ze,qs,_e,Bs,Re,Kl=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.
More details about the pricing structure can be found on the <a href="./pricing">pricing page</a>.`,Gs,x,ea='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',Hs,Se,ta=`We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,Zs,We,_s,Ve,sa=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.
The authentication system should be the same as your Inference service; for example, a bearer token.`,Rs,Xe,Ss,Qe,la=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,Ws,Ye,Vs,Ee,Xs,Ne,aa="We require the price to be a <strong>non-negative integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",Qs,Fe,Ys,Pe,na=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,Es,ze,ia="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",Ns,Le,pa="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",Fs,De,Ps,Oe,zs,A,Ls,Ke,Ds,et,oa="Create a new file under <code>src/huggingface_hub/inference/_providers/{provider_name}.py</code> and copy-paste the following snippet.",Os,tt,ra="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of <code>_prepare_payload_as_dict</code> or <code>_prepare_payload_as_bytes</code> must be overwritten.",Ks,st,Ma="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",el,lt,ca="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",tl,at,sl,nt,ll,it,ua='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',al,pt,nl,ot,ya='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</li>',il,rt,pl,Mt,ha="Create a dedicated documentation page for your provider within the Hugging Face documentation. This page should contain a concise description of your provider services, highlight the benefits for users, set expectations regarding performance or features, and include any relevant details such as pricing models or data retention policies. Essentially, provide any information that would be valuable to end users.",ol,ct,da="Here’s how to add your documentation page:",rl,ut,ma='<li>Provide Your Logo: You can send your logo files (separate light and dark mode versions) directly to us. This is often the simplest way. Alternatively, if you prefer, you can open a PR in the <a href="https://huggingface.co/datasets/huggingface/documentation-images/tree/main/inference-providers/logos" rel="nofollow">huggingface/documentation-images</a> repository. If you choose to open a PR:<ul><li>Logos must be in <code>.png</code> format.</li> <li>Name them <code>{provider-name}-light.png</code> and <code>{provider-name}-dark.png</code>.</li> <li>Please ping <code>@Wauplin</code> and <code>@celinah</code> on the PR.</li></ul></li> <li>Create the Documentation File:<ul><li>Use an existing provider page as a template. For example, check out the template for <a href="https://github.com/huggingface/hub-docs/blob/main/scripts/inference-providers/templates/providers/fal-ai.handlebars" rel="nofollow">Fal AI</a>.</li> <li>The file should be located under <code>scripts/inference-providers/templates/providers/{your-provider-name}.handlebars</code>.</li></ul></li> <li>Submit the Documentation PR:<ul><li>Add your new <code>{provider-name}.handlebars</code> file.</li> <li>Update the <a href="./index#partners">partners table</a> to include your company or product.</li> <li>Update the <code>_toctree.yml</code> file in the <code>docs/inference-providers/</code> directory to include your new documentation page in the “Providers” section, maintaining alphabetical order.</li> <li>Update the <code>scripts/inference-providers/scripts/generate.ts</code> file to include your provider in the <code>PROVIDERS_HUB_ORGS</code> and <code>PROVIDERS_URLS</code> constants, maintaining alphabetical order.</li> <li>Run <code>pnpm install</code> (if you haven’t already) and then <code>pnpm run generate</code> at the root of the <code>scripts/inference-providers</code> repository to generate the documentation.</li> <li>Commit all your changes, including the manually edited files (provider page, <code>_toctree.yml</code>, partners table) and the files generated by the script.</li> <li>When you open the PR, please ping @Wauplin, @SBrandeis, @julien-c, and @hanouticelina for a review. If you need any assistance with these steps, please reach out – we’re here to help you!</li></ul></li>',Ml,yt,cl,ht,Ja="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",ul,dt,Ua="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",yl,mt,hl,Tt,dl;return k=new U({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),f=new Jt({props:{$$slots:{default:[Ga]},$$scope:{ctx:j}}}),G=new U({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),g=new Jt({props:{$$slots:{default:[Ha]},$$scope:{ctx:j}}}),_=new U({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),C=new Jt({props:{$$slots:{default:[Za]},$$scope:{ctx:j}}}),W=new U({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),Y=new U({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),N=new U({props:{title:"Implement the provider helper (JS)",local:"implement-the-provider-helper-js",headingTag:"h3"}}),P=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">TaskProviderHelper</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;./providerHelper&quot;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTask</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">TaskProviderHelper</span> {

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params"></span>) {
		<span class="hljs-variable language_">super</span>(<span class="hljs-string">&quot;your-provider-name&quot;</span>, <span class="hljs-string">&quot;your-api-base-url&quot;</span>, <span class="hljs-string">&quot;task-name&quot;</span>);
	}

    <span class="hljs-keyword">override</span> <span class="hljs-title function_">prepareHeaders</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">HeaderParams</span>, <span class="hljs-attr">binary</span>: <span class="hljs-built_in">boolean</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt; {
        <span class="hljs-comment">// Override the headers to use for the request.</span>
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">super</span>.<span class="hljs-title function_">prepareHeaders</span>(params, binary);
    }

	<span class="hljs-title function_">makeRoute</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">UrlParams</span>): <span class="hljs-built_in">string</span> {
        <span class="hljs-comment">// Return the route to use for the request. e.g. /v1/chat/completions route is commonly use for chat completion.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">preparePayload</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">BodyParams</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">unknown</span>&gt; {
        <span class="hljs-comment">// Return the payload to use for the request, as a dict.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">getResponse</span>(<span class="hljs-attr">response</span>: <span class="hljs-built_in">unknown</span>, outputType?: <span class="hljs-string">&quot;url&quot;</span> | <span class="hljs-string">&quot;blob&quot;</span>): <span class="hljs-built_in">string</span> | <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-title class_">Blob</span>&gt;{
		<span class="hljs-comment">// Return the response in the expected format.</span>
        <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
    }
}`,wrap:!1}}),O=new U({props:{title:"Register the provider",local:"register-the-provider",headingTag:"h3"}}),te=new U({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),b=new Jt({props:{$$slots:{default:[_a]},$$scope:{ctx:j}}}),ae=new U({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),ne=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),pe=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Me=new U({props:{title:"Using a tag-filter to map several HF models to a single inference endpoint",local:"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint",headingTag:"h3"}}),v=new Jt({props:{$$slots:{default:[Ra]},$$scope:{ctx:j}}}),ye=new w({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),de=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnRhZy1maWx0ZXIlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJXaWRnZXRUeXBlJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlMEElMjAlMjAlMjAlMjAlMjJ0YWdzJTIyJTNBJTIwJTVCJTIyc3RyaW5nJTIyJTVEJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjBhbnklMjBIRiUyMG1vZGVsJTIwd2l0aCUyMGFsbCUyMG9mJTIwdGhvc2UlMjB0YWdzJTIwd2lsbCUyMGJlJTIwbWFwcGVkJTIwdG8lMjBwcm92aWRlck1vZGVsJTBBJTIwJTIwJTIwJTIwJTIycHJvdmlkZXJNb2RlbCUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUyMCUyRiUyRiUyMHJlcXVpcmVkJTNBJTIwdGhlJTIwcGFydG5lcidzJTIwJTIybW9kZWwlMjBpZCUyMiUyMGkuZS4lMjBpZCUyMG9uJTIweW91ciUyMHNpZGUlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyVHlwZSUyMiUzQSUyMCUyMmxvcmElMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMG9ubHklMjAlMjJsb3JhJTIyJTIwaXMlMjBzdXBwb3J0ZWQlMjBhdCUyMHRoZSUyMG1vbWVudCUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tag-filter&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: any HF model with all of those tags will be mapped to providerModel</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: only &quot;lora&quot; is supported at the moment</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Ue=new U({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),je=new U({props:{title:"Validation",local:"validation",headingTag:"h4"}}),ge=new U({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),Ie=new w({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RA==",highlighted:"DELETE /api/partners/{provider}/models/{mapping ID}",wrap:!1}}),be=new U({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),$e=new w({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RCUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/{mapping ID}/status",wrap:!1}}),Ae=new w({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIybGl2ZSUyMiUyMCU3QyUyMCUyMnN0YWdpbmclMjIlMjAlMkYlMkYlMjBUaGUlMjBuZXclMjBzdGF0dXMlMkMlMjBvbmUlMjBvZiUyMCUyMnN0YWdpbmclMjIlMjBvciUyMCUyMmxpdmUlMjIlMEElN0QlMjAlMjAlMjA=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),qe=new U({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),Be=new w({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),$=new Jt({props:{warning:!0,$$slots:{default:[Sa]},$$scope:{ctx:j}}}),Ze=new w({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;tag-filter=base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0,lora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sdxl-lora-mutualized&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
                <span class="hljs-string">&quot;base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-string">&quot;lora&quot;</span>
            <span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_e=new U({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),We=new U({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),Xe=new w({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQXV0aG9yaXphdGlvbiUzQSUyMCU3QmF1dGhlbnRpY2F0aW9uJTIwaW5mbyUyMC0lMjBlZyUyMCUyMkJlYXJlciUyMHRva2VuJTIyJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Authorization</span><span class="hljs-punctuation">: </span>{authentication info - eg &quot;Bearer token&quot;}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),Ye=new w({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),Ee=new U({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),Fe=new U({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),De=new w({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),Oe=new U({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),A=new Jt({props:{$$slots:{default:[Wa]},$$scope:{ctx:j}}}),Ke=new U({props:{title:"Implement the provider helper (Python)",local:"implement-the-provider-helper-python",headingTag:"h3"}}),at=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),nt=new U({props:{title:"Register the Provider",local:"register-the-provider",headingTag:"h3"}}),pt=new U({props:{title:"Add tests",local:"add-tests",headingTag:"h3"}}),rt=new U({props:{title:"6. Add provider documentation",local:"6-add-provider-documentation",headingTag:"h2"}}),yt=new U({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),mt=new Ba({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/register-as-a-provider.md"}}),{c(){o=i("meta"),J=a(),M=i("p"),T=a(),c(k.$$.fragment),jt=a(),c(f.$$.fragment),wt=a(),q=i("p"),q.textContent=Jl,ft=a(),B=i("ol"),B.innerHTML=Ul,gt=a(),c(G.$$.fragment),It=a(),c(g.$$.fragment),Ct=a(),H=i("p"),H.innerHTML=Tl,bt=a(),Z=i("p"),Z.textContent=jl,vt=a(),c(_.$$.fragment),$t=a(),R=i("p"),R.innerHTML=wl,xt=a(),I=i("div"),I.innerHTML=fl,At=a(),S=i("p"),S.innerHTML=gl,kt=a(),c(C.$$.fragment),qt=a(),c(W.$$.fragment),Bt=a(),V=i("p"),V.textContent=Il,Gt=a(),X=i("p"),X.textContent=Cl,Ht=a(),Q=i("p"),Q.innerHTML=bl,Zt=a(),c(Y.$$.fragment),_t=a(),E=i("p"),E.textContent=vl,Rt=a(),c(N.$$.fragment),St=a(),F=i("p"),F.innerHTML=$l,Wt=a(),c(P.$$.fragment),Vt=a(),z=i("p"),z.innerHTML=xl,Xt=a(),L=i("p"),L.innerHTML=Al,Qt=a(),D=i("p"),D.innerHTML=kl,Yt=a(),c(O.$$.fragment),Et=a(),K=i("p"),K.innerHTML=ql,Nt=a(),ee=i("p"),ee.innerHTML=Bl,Ft=a(),c(te.$$.fragment),Pt=a(),se=i("p"),se.textContent=Gl,zt=a(),le=i("p"),le.textContent=Hl,Lt=a(),c(b.$$.fragment),Dt=a(),c(ae.$$.fragment),Ot=a(),c(ne.$$.fragment),Kt=a(),ie=i("p"),ie.textContent=Zl,es=a(),c(pe.$$.fragment),ts=a(),oe=i("ul"),oe.innerHTML=_l,ss=a(),re=i("p"),re.textContent=Rl,ls=a(),c(Me.$$.fragment),as=a(),ce=i("p"),ce.innerHTML=Sl,ns=a(),c(v.$$.fragment),is=a(),ue=i("p"),ue.textContent=Wl,ps=a(),c(ye.$$.fragment),os=a(),he=i("p"),he.textContent=Vl,rs=a(),c(de.$$.fragment),Ms=a(),me=i("ul"),me.innerHTML=Xl,cs=a(),Je=i("p"),Je.textContent=Ql,us=a(),c(Ue.$$.fragment),ys=a(),Te=i("p"),Te.innerHTML=Yl,hs=a(),c(je.$$.fragment),ds=a(),we=i("p"),we.textContent=El,ms=a(),fe=i("ul"),fe.innerHTML=Nl,Js=a(),c(ge.$$.fragment),Us=a(),c(Ie.$$.fragment),Ts=a(),Ce=i("p"),Ce.innerHTML=Fl,js=a(),c(be.$$.fragment),ws=a(),ve=i("p"),ve.textContent=Pl,fs=a(),c($e.$$.fragment),gs=a(),xe=i("p"),xe.textContent=zl,Is=a(),c(Ae.$$.fragment),Cs=a(),ke=i("p"),ke.innerHTML=Ll,bs=a(),c(qe.$$.fragment),vs=a(),c(Be.$$.fragment),$s=a(),Ge=i("p"),Ge.textContent=Dl,xs=a(),c($.$$.fragment),As=a(),He=i("p"),He.textContent=Ol,ks=a(),c(Ze.$$.fragment),qs=a(),c(_e.$$.fragment),Bs=a(),Re=i("p"),Re.innerHTML=Kl,Gs=a(),x=i("div"),x.innerHTML=ea,Hs=a(),Se=i("p"),Se.textContent=ta,Zs=a(),c(We.$$.fragment),_s=a(),Ve=i("p"),Ve.textContent=sa,Rs=a(),c(Xe.$$.fragment),Ss=a(),Qe=i("p"),Qe.textContent=la,Ws=a(),c(Ye.$$.fragment),Vs=a(),c(Ee.$$.fragment),Xs=a(),Ne=i("p"),Ne.innerHTML=aa,Qs=a(),c(Fe.$$.fragment),Ys=a(),Pe=i("p"),Pe.textContent=na,Es=a(),ze=i("p"),ze.innerHTML=ia,Ns=a(),Le=i("p"),Le.innerHTML=pa,Fs=a(),c(De.$$.fragment),Ps=a(),c(Oe.$$.fragment),zs=a(),c(A.$$.fragment),Ls=a(),c(Ke.$$.fragment),Ds=a(),et=i("p"),et.innerHTML=oa,Os=a(),tt=i("p"),tt.innerHTML=ra,Ks=a(),st=i("p"),st.textContent=Ma,el=a(),lt=i("p"),lt.textContent=ca,tl=a(),c(at.$$.fragment),sl=a(),c(nt.$$.fragment),ll=a(),it=i("ul"),it.innerHTML=ua,al=a(),c(pt.$$.fragment),nl=a(),ot=i("ul"),ot.innerHTML=ya,il=a(),c(rt.$$.fragment),pl=a(),Mt=i("p"),Mt.textContent=ha,ol=a(),ct=i("p"),ct.textContent=da,rl=a(),ut=i("ul"),ut.innerHTML=ma,Ml=a(),c(yt.$$.fragment),cl=a(),ht=i("p"),ht.innerHTML=Ja,ul=a(),dt=i("p"),dt.innerHTML=Ua,yl=a(),c(mt.$$.fragment),hl=a(),Tt=i("p"),this.h()},l(e){const t=ka("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(s),J=n(e),M=p(e,"P",{}),ba(M).forEach(s),T=n(e),u(k.$$.fragment,e),jt=n(e),u(f.$$.fragment,e),wt=n(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-eo2v07"&&(q.textContent=Jl),ft=n(e),B=p(e,"OL",{"data-svelte-h":!0}),r(B)!=="svelte-8emskd"&&(B.innerHTML=Ul),gt=n(e),u(G.$$.fragment,e),It=n(e),u(g.$$.fragment,e),Ct=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-iwney4"&&(H.innerHTML=Tl),bt=n(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1xoupob"&&(Z.textContent=jl),vt=n(e),u(_.$$.fragment,e),$t=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-hjt0h1"&&(R.innerHTML=wl),xt=n(e),I=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(I)!=="svelte-1cxy3tx"&&(I.innerHTML=fl),At=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-vmhaok"&&(S.innerHTML=gl),kt=n(e),u(C.$$.fragment,e),qt=n(e),u(W.$$.fragment,e),Bt=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-epfhsj"&&(V.textContent=Il),Gt=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-n5dyw"&&(X.textContent=Cl),Ht=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qm2nt8"&&(Q.innerHTML=bl),Zt=n(e),u(Y.$$.fragment,e),_t=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-aqaw0f"&&(E.textContent=vl),Rt=n(e),u(N.$$.fragment,e),St=n(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1ccsiy1"&&(F.innerHTML=$l),Wt=n(e),u(P.$$.fragment,e),Vt=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-qutua8"&&(z.innerHTML=xl),Xt=n(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-uj5o95"&&(L.innerHTML=Al),Qt=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1ozzcb1"&&(D.innerHTML=kl),Yt=n(e),u(O.$$.fragment,e),Et=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-dq2kwm"&&(K.innerHTML=ql),Nt=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-kajnqt"&&(ee.innerHTML=Bl),Ft=n(e),u(te.$$.fragment,e),Pt=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1vjzmk"&&(se.textContent=Gl),zt=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1147onl"&&(le.textContent=Hl),Lt=n(e),u(b.$$.fragment,e),Dt=n(e),u(ae.$$.fragment,e),Ot=n(e),u(ne.$$.fragment,e),Kt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-f1hll8"&&(ie.textContent=Zl),es=n(e),u(pe.$$.fragment,e),ts=n(e),oe=p(e,"UL",{"data-svelte-h":!0}),r(oe)!=="svelte-u6m976"&&(oe.innerHTML=_l),ss=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-khk897"&&(re.textContent=Rl),ls=n(e),u(Me.$$.fragment,e),as=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1s9oaze"&&(ce.innerHTML=Sl),ns=n(e),u(v.$$.fragment,e),is=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-m8oll3"&&(ue.textContent=Wl),ps=n(e),u(ye.$$.fragment,e),os=n(e),he=p(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-f1hll8"&&(he.textContent=Vl),rs=n(e),u(de.$$.fragment,e),Ms=n(e),me=p(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-amxywc"&&(me.innerHTML=Xl),cs=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-khk897"&&(Je.textContent=Ql),us=n(e),u(Ue.$$.fragment,e),ys=n(e),Te=p(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1avk6lq"&&(Te.innerHTML=Yl),hs=n(e),u(je.$$.fragment,e),ds=n(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-pwj71q"&&(we.textContent=El),ms=n(e),fe=p(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-1i002r6"&&(fe.innerHTML=Nl),Js=n(e),u(ge.$$.fragment,e),Us=n(e),u(Ie.$$.fragment,e),Ts=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-ojjbo0"&&(Ce.innerHTML=Fl),js=n(e),u(be.$$.fragment,e),ws=n(e),ve=p(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-18yjufw"&&(ve.textContent=Pl),fs=n(e),u($e.$$.fragment,e),gs=n(e),xe=p(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-1ar1qn2"&&(xe.textContent=zl),Is=n(e),u(Ae.$$.fragment,e),Cs=n(e),ke=p(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-ojjbo0"&&(ke.innerHTML=Ll),bs=n(e),u(qe.$$.fragment,e),vs=n(e),u(Be.$$.fragment,e),$s=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-16sv3hm"&&(Ge.textContent=Dl),xs=n(e),u($.$$.fragment,e),As=n(e),He=p(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1ovcz13"&&(He.textContent=Ol),ks=n(e),u(Ze.$$.fragment,e),qs=n(e),u(_e.$$.fragment,e),Bs=n(e),Re=p(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-lf5sv5"&&(Re.innerHTML=Kl),Gs=n(e),x=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-1roilif"&&(x.innerHTML=ea),Hs=n(e),Se=p(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1072wo1"&&(Se.textContent=ta),Zs=n(e),u(We.$$.fragment,e),_s=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-ogq2gt"&&(Ve.textContent=sa),Rs=n(e),u(Xe.$$.fragment,e),Ss=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-krncuc"&&(Qe.textContent=la),Ws=n(e),u(Ye.$$.fragment,e),Vs=n(e),u(Ee.$$.fragment,e),Xs=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-bpbibl"&&(Ne.innerHTML=aa),Qs=n(e),u(Fe.$$.fragment,e),Ys=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-speu7d"&&(Pe.textContent=na),Es=n(e),ze=p(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-13ler1d"&&(ze.innerHTML=ia),Ns=n(e),Le=p(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-ub059v"&&(Le.innerHTML=pa),Fs=n(e),u(De.$$.fragment,e),Ps=n(e),u(Oe.$$.fragment,e),zs=n(e),u(A.$$.fragment,e),Ls=n(e),u(Ke.$$.fragment,e),Ds=n(e),et=p(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-102eqn3"&&(et.innerHTML=oa),Os=n(e),tt=p(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-lavds"&&(tt.innerHTML=ra),Ks=n(e),st=p(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-f0qt8k"&&(st.textContent=Ma),el=n(e),lt=p(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-w9ft7n"&&(lt.textContent=ca),tl=n(e),u(at.$$.fragment,e),sl=n(e),u(nt.$$.fragment,e),ll=n(e),it=p(e,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-117ozzs"&&(it.innerHTML=ua),al=n(e),u(pt.$$.fragment,e),nl=n(e),ot=p(e,"UL",{"data-svelte-h":!0}),r(ot)!=="svelte-vl7c7p"&&(ot.innerHTML=ya),il=n(e),u(rt.$$.fragment,e),pl=n(e),Mt=p(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-ccionj"&&(Mt.textContent=ha),ol=n(e),ct=p(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1dt3smc"&&(ct.textContent=da),rl=n(e),ut=p(e,"UL",{"data-svelte-h":!0}),r(ut)!=="svelte-1n9xyev"&&(ut.innerHTML=ma),Ml=n(e),u(yt.$$.fragment,e),cl=n(e),ht=p(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-1yfr1yr"&&(ht.innerHTML=Ja),ul=n(e),dt=p(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1duzsqa"&&(dt.innerHTML=Ua),yl=n(e),u(mt.$$.fragment,e),hl=n(e),Tt=p(e,"P",{}),ba(Tt).forEach(s),this.h()},h(){ml(o,"name","hf:doc:metadata"),ml(o,"content",Xa),ml(I,"class","flex justify-center"),ml(x,"class","flex justify-center")},m(e,t){qa(document.head,o),l(e,J,t),l(e,M,t),l(e,T,t),y(k,e,t),l(e,jt,t),y(f,e,t),l(e,wt,t),l(e,q,t),l(e,ft,t),l(e,B,t),l(e,gt,t),y(G,e,t),l(e,It,t),y(g,e,t),l(e,Ct,t),l(e,H,t),l(e,bt,t),l(e,Z,t),l(e,vt,t),y(_,e,t),l(e,$t,t),l(e,R,t),l(e,xt,t),l(e,I,t),l(e,At,t),l(e,S,t),l(e,kt,t),y(C,e,t),l(e,qt,t),y(W,e,t),l(e,Bt,t),l(e,V,t),l(e,Gt,t),l(e,X,t),l(e,Ht,t),l(e,Q,t),l(e,Zt,t),y(Y,e,t),l(e,_t,t),l(e,E,t),l(e,Rt,t),y(N,e,t),l(e,St,t),l(e,F,t),l(e,Wt,t),y(P,e,t),l(e,Vt,t),l(e,z,t),l(e,Xt,t),l(e,L,t),l(e,Qt,t),l(e,D,t),l(e,Yt,t),y(O,e,t),l(e,Et,t),l(e,K,t),l(e,Nt,t),l(e,ee,t),l(e,Ft,t),y(te,e,t),l(e,Pt,t),l(e,se,t),l(e,zt,t),l(e,le,t),l(e,Lt,t),y(b,e,t),l(e,Dt,t),y(ae,e,t),l(e,Ot,t),y(ne,e,t),l(e,Kt,t),l(e,ie,t),l(e,es,t),y(pe,e,t),l(e,ts,t),l(e,oe,t),l(e,ss,t),l(e,re,t),l(e,ls,t),y(Me,e,t),l(e,as,t),l(e,ce,t),l(e,ns,t),y(v,e,t),l(e,is,t),l(e,ue,t),l(e,ps,t),y(ye,e,t),l(e,os,t),l(e,he,t),l(e,rs,t),y(de,e,t),l(e,Ms,t),l(e,me,t),l(e,cs,t),l(e,Je,t),l(e,us,t),y(Ue,e,t),l(e,ys,t),l(e,Te,t),l(e,hs,t),y(je,e,t),l(e,ds,t),l(e,we,t),l(e,ms,t),l(e,fe,t),l(e,Js,t),y(ge,e,t),l(e,Us,t),y(Ie,e,t),l(e,Ts,t),l(e,Ce,t),l(e,js,t),y(be,e,t),l(e,ws,t),l(e,ve,t),l(e,fs,t),y($e,e,t),l(e,gs,t),l(e,xe,t),l(e,Is,t),y(Ae,e,t),l(e,Cs,t),l(e,ke,t),l(e,bs,t),y(qe,e,t),l(e,vs,t),y(Be,e,t),l(e,$s,t),l(e,Ge,t),l(e,xs,t),y($,e,t),l(e,As,t),l(e,He,t),l(e,ks,t),y(Ze,e,t),l(e,qs,t),y(_e,e,t),l(e,Bs,t),l(e,Re,t),l(e,Gs,t),l(e,x,t),l(e,Hs,t),l(e,Se,t),l(e,Zs,t),y(We,e,t),l(e,_s,t),l(e,Ve,t),l(e,Rs,t),y(Xe,e,t),l(e,Ss,t),l(e,Qe,t),l(e,Ws,t),y(Ye,e,t),l(e,Vs,t),y(Ee,e,t),l(e,Xs,t),l(e,Ne,t),l(e,Qs,t),y(Fe,e,t),l(e,Ys,t),l(e,Pe,t),l(e,Es,t),l(e,ze,t),l(e,Ns,t),l(e,Le,t),l(e,Fs,t),y(De,e,t),l(e,Ps,t),y(Oe,e,t),l(e,zs,t),y(A,e,t),l(e,Ls,t),y(Ke,e,t),l(e,Ds,t),l(e,et,t),l(e,Os,t),l(e,tt,t),l(e,Ks,t),l(e,st,t),l(e,el,t),l(e,lt,t),l(e,tl,t),y(at,e,t),l(e,sl,t),y(nt,e,t),l(e,ll,t),l(e,it,t),l(e,al,t),y(pt,e,t),l(e,nl,t),l(e,ot,t),l(e,il,t),y(rt,e,t),l(e,pl,t),l(e,Mt,t),l(e,ol,t),l(e,ct,t),l(e,rl,t),l(e,ut,t),l(e,Ml,t),y(yt,e,t),l(e,cl,t),l(e,ht,t),l(e,ul,t),l(e,dt,t),l(e,yl,t),y(mt,e,t),l(e,hl,t),l(e,Tt,t),dl=!0},p(e,[t]){const Ta={};t&2&&(Ta.$$scope={dirty:t,ctx:e}),f.$set(Ta);const ja={};t&2&&(ja.$$scope={dirty:t,ctx:e}),g.$set(ja);const wa={};t&2&&(wa.$$scope={dirty:t,ctx:e}),C.$set(wa);const fa={};t&2&&(fa.$$scope={dirty:t,ctx:e}),b.$set(fa);const ga={};t&2&&(ga.$$scope={dirty:t,ctx:e}),v.$set(ga);const Ia={};t&2&&(Ia.$$scope={dirty:t,ctx:e}),$.$set(Ia);const Ca={};t&2&&(Ca.$$scope={dirty:t,ctx:e}),A.$set(Ca)},i(e){dl||(h(k.$$.fragment,e),h(f.$$.fragment,e),h(G.$$.fragment,e),h(g.$$.fragment,e),h(_.$$.fragment,e),h(C.$$.fragment,e),h(W.$$.fragment,e),h(Y.$$.fragment,e),h(N.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(b.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(Me.$$.fragment,e),h(v.$$.fragment,e),h(ye.$$.fragment,e),h(de.$$.fragment,e),h(Ue.$$.fragment,e),h(je.$$.fragment,e),h(ge.$$.fragment,e),h(Ie.$$.fragment,e),h(be.$$.fragment,e),h($e.$$.fragment,e),h(Ae.$$.fragment,e),h(qe.$$.fragment,e),h(Be.$$.fragment,e),h($.$$.fragment,e),h(Ze.$$.fragment,e),h(_e.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ye.$$.fragment,e),h(Ee.$$.fragment,e),h(Fe.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(A.$$.fragment,e),h(Ke.$$.fragment,e),h(at.$$.fragment,e),h(nt.$$.fragment,e),h(pt.$$.fragment,e),h(rt.$$.fragment,e),h(yt.$$.fragment,e),h(mt.$$.fragment,e),dl=!0)},o(e){d(k.$$.fragment,e),d(f.$$.fragment,e),d(G.$$.fragment,e),d(g.$$.fragment,e),d(_.$$.fragment,e),d(C.$$.fragment,e),d(W.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(b.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(pe.$$.fragment,e),d(Me.$$.fragment,e),d(v.$$.fragment,e),d(ye.$$.fragment,e),d(de.$$.fragment,e),d(Ue.$$.fragment,e),d(je.$$.fragment,e),d(ge.$$.fragment,e),d(Ie.$$.fragment,e),d(be.$$.fragment,e),d($e.$$.fragment,e),d(Ae.$$.fragment,e),d(qe.$$.fragment,e),d(Be.$$.fragment,e),d($.$$.fragment,e),d(Ze.$$.fragment,e),d(_e.$$.fragment,e),d(We.$$.fragment,e),d(Xe.$$.fragment,e),d(Ye.$$.fragment,e),d(Ee.$$.fragment,e),d(Fe.$$.fragment,e),d(De.$$.fragment,e),d(Oe.$$.fragment,e),d(A.$$.fragment,e),d(Ke.$$.fragment,e),d(at.$$.fragment,e),d(nt.$$.fragment,e),d(pt.$$.fragment,e),d(rt.$$.fragment,e),d(yt.$$.fragment,e),d(mt.$$.fragment,e),dl=!1},d(e){e&&(s(J),s(M),s(T),s(jt),s(wt),s(q),s(ft),s(B),s(gt),s(It),s(Ct),s(H),s(bt),s(Z),s(vt),s($t),s(R),s(xt),s(I),s(At),s(S),s(kt),s(qt),s(Bt),s(V),s(Gt),s(X),s(Ht),s(Q),s(Zt),s(_t),s(E),s(Rt),s(St),s(F),s(Wt),s(Vt),s(z),s(Xt),s(L),s(Qt),s(D),s(Yt),s(Et),s(K),s(Nt),s(ee),s(Ft),s(Pt),s(se),s(zt),s(le),s(Lt),s(Dt),s(Ot),s(Kt),s(ie),s(es),s(ts),s(oe),s(ss),s(re),s(ls),s(as),s(ce),s(ns),s(is),s(ue),s(ps),s(os),s(he),s(rs),s(Ms),s(me),s(cs),s(Je),s(us),s(ys),s(Te),s(hs),s(ds),s(we),s(ms),s(fe),s(Js),s(Us),s(Ts),s(Ce),s(js),s(ws),s(ve),s(fs),s(gs),s(xe),s(Is),s(Cs),s(ke),s(bs),s(vs),s($s),s(Ge),s(xs),s(As),s(He),s(ks),s(qs),s(Bs),s(Re),s(Gs),s(x),s(Hs),s(Se),s(Zs),s(_s),s(Ve),s(Rs),s(Ss),s(Qe),s(Ws),s(Vs),s(Xs),s(Ne),s(Qs),s(Ys),s(Pe),s(Es),s(ze),s(Ns),s(Le),s(Fs),s(Ps),s(zs),s(Ls),s(Ds),s(et),s(Os),s(tt),s(Ks),s(st),s(el),s(lt),s(tl),s(sl),s(ll),s(it),s(al),s(nl),s(ot),s(il),s(pl),s(Mt),s(ol),s(ct),s(rl),s(ut),s(Ml),s(cl),s(ht),s(ul),s(dt),s(yl),s(hl),s(Tt)),s(o),m(k,e),m(f,e),m(G,e),m(g,e),m(_,e),m(C,e),m(W,e),m(Y,e),m(N,e),m(P,e),m(O,e),m(te,e),m(b,e),m(ae,e),m(ne,e),m(pe,e),m(Me,e),m(v,e),m(ye,e),m(de,e),m(Ue,e),m(je,e),m(ge,e),m(Ie,e),m(be,e),m($e,e),m(Ae,e),m(qe,e),m(Be,e),m($,e),m(Ze,e),m(_e,e),m(We,e),m(Xe,e),m(Ye,e),m(Ee,e),m(Fe,e),m(De,e),m(Oe,e),m(A,e),m(Ke,e),m(at,e),m(nt,e),m(pt,e),m(rt,e),m(yt,e),m(mt,e)}}}const Xa='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Prerequisites","local":"1-prerequisites","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[{"title":"Implement the provider helper (JS)","local":"implement-the-provider-helper-js","sections":[],"depth":3},{"title":"Register the provider","local":"register-the-provider","sections":[],"depth":3}],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[],"depth":3},{"title":"Using a tag-filter to map several HF models to a single inference endpoint","local":"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"Implement the provider helper (Python)","local":"implement-the-provider-helper-python","sections":[],"depth":3},{"title":"Register the Provider","local":"register-the-provider","sections":[],"depth":3},{"title":"Add tests","local":"add-tests","sections":[],"depth":3}],"depth":2},{"title":"6. Add provider documentation","local":"6-add-provider-documentation","sections":[],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function Qa(j){return $a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends xa{constructor(o){super(),Aa(this,o,Qa,Va,va,{})}}export{za as component};
