import{s as fs,o as bs,n as Js}from"../chunks/scheduler.f6b352c8.js";import{S as Ts,i as hs,g as o,s as a,r,A as Us,h as i,f as l,c as n,j as Il,u as M,x as p,k as ds,y as Cl,a as s,v as c,d as m,t as y,w}from"../chunks/index.b90df637.js";import{T as Is}from"../chunks/Tip.366d2e6e.js";import{C as d}from"../chunks/CodeBlock.e5718f9d.js";import{H as j,E as Cs}from"../chunks/getInferenceSnippets.8f5ff415.js";function vs(Pe){let u,T="Note that these properties must be callable even if the robot is not yet connected, so avoid relying on runtime hardware state to define them.";return{c(){u=o("p"),u.textContent=T},l(f){u=i(f,"P",{"data-svelte-h":!0}),p(u)!=="svelte-12r8tyg"&&(u.textContent=T)},m(f,Le){s(f,u,Le)},p:Js,d(f){f&&l(u)}}}function gs(Pe){let u,T,f,Le,h,De,U,vl="This tutorial will explain how to integrate your own robot design into the LeRobot ecosystem and have it access all of our tools (data collection, control pipelines, policy training and inference).",Ke,I,gl='To that end, we provide the <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/robots/robot.py" rel="nofollow"><code>Robot</code></a> base class in the LeRobot which specifies a standard interface for physical robot integration. Let’s see how to implement it.',Oe,C,et,v,$l='<li>Your own robot which exposes a communication interface (e.g. serial, CAN, TCP)</li> <li>A way to read sensor data and send motor commands programmatically, e.g. manufacturer’s SDK or API, or your own protocol implementation.</li> <li>LeRobot installed in your environment. Follow our <a href="./installation">Installation Guide</a>.</li>',tt,g,lt,$,Al="If you’re using Feetech or Dynamixel motors, LeRobot provides built-in bus interfaces:",st,A,_l='<li><a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/feetech/feetech.py" rel="nofollow"><code>FeetechMotorsBus</code></a> – for controlling Feetech servos</li> <li><a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/dynamixel/dynamixel.py" rel="nofollow"><code>DynamixelMotorsBus</code></a> – for controlling Dynamixel servos</li>',at,_,Bl=`Please refer to the <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/motors_bus.py" rel="nofollow"><code>MotorsBus</code></a> abstract class to learn about its API.
For a good example of how it can be used, you can have a look at our own <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/robots/so101_follower/so101_follower.py" rel="nofollow">SO101 follower implementation</a>`,nt,B,Zl="Use these if compatible. Otherwise, you’ll need to find or write a Python interface (not covered in this tutorial):",ot,Z,kl="<li>Find an existing SDK in Python (or use bindings to C/C++)</li> <li>Or implement a basic communication wrapper (e.g., via pyserial, socket, or CANopen)</li>",it,k,Nl="You’re not alone—many community contributions use custom boards or firmware!",pt,N,Wl="For Feetech and Dynamixel, we currently support these servos:",rt,W,xl="<li>Feetech:<ul><li>STS &amp; SMS series (protocol 0): <code>sts3215</code>, <code>sts3250</code>, <code>sm8512bl</code></li> <li>SCS series (protocol 1): <code>scs0009</code></li></ul></li> <li>Dynamixel (protocol 2.0 only): <code>xl330-m077</code>, <code>xl330-m288</code>, <code>xl430-w250</code>, <code>xm430-w350</code>, <code>xm540-w270</code>, <code>xc430-w150</code></li>",Mt,x,Gl='If you are using Feetech or Dynamixel servos that are not in this list, you can add those in the <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/feetech/tables.py" rel="nofollow">Feetech table</a> or <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/motors/dynamixel/tables.py" rel="nofollow">Dynamixel table</a>. Depending on the model, this will require you to add model-specific information. In most cases though, there shouldn’t be a lot of additions to do.',ct,G,El="In the next sections, we’ll use a <code>FeetechMotorsBus</code> as the motors interface for the examples. Replace it and adapt to your motors if necessary.",mt,E,yt,Y,Yl="You’ll first need to specify the config class and a string identifier (<code>name</code>) for your robot. If your robot has special needs that you’d like to be able to change easily, it should go here (e.g. port/address, baudrate).",wt,S,Sl="Here, we’ll add the port name and one camera by default for our robot:",jt,R,ut,Q,Rl='Have a look at our <a href="./cameras">Cameras tutorial</a> to understand how to detect and add your camera.',dt,H,Ql="Next, we’ll create our actual robot class which inherits from <code>Robot</code>. This abstract class defines a contract you must follow for your robot to be usable with the rest of the LeRobot tools.",ft,z,Hl="Here we’ll create a simple 5-DoF robot with one camera. It could be a simple arm but notice that the <code>Robot</code> abstract class does not assume anything on your robot’s form factor. You can let you imagination run wild when designing new robots!",bt,V,Jt,X,Tt,L,zl="These two properties define the <em>interface contract</em> between your robot and tools that consume it (such as data collection or learning pipelines).",ht,b,Ut,F,It,q,Vl="This property should return a dictionary describing the structure of sensor outputs from your robot. The keys match what <code>get_observation()</code> returns, and the values describe either the shape (for arrays/images) or the type (for simple values).",Ct,P,Xl="Example for our 5-DoF arm with one camera:",vt,D,gt,K,Ll="In this case, observations consist of a simple dict storing each motor’s position and a camera image.",$t,O,At,ee,Fl="This property describes the commands your robot expects via <code>send_action()</code>. Again, keys must match the expected input format, and values define the shape/type of each command.",_t,te,ql="Here, we simply use the same joints proprioceptive features (<code>self._motors_ft</code>) as with <code>observation_features</code>: the action sent will simply the goal position for each motor.",Bt,le,Zt,se,kt,ae,Pl="These methods should handle opening and closing communication with your hardware (e.g. serial ports, CAN interfaces, USB devices, cameras).",Nt,ne,Wt,oe,Dl="This property should simply reflect that communication with the robot’s hardware is established. When this property is <code>True</code>, it should be possible to read and write to the hardware using <code>get_observation()</code> and <code>send_action()</code>.",xt,ie,Gt,pe,Et,re,Kl="This method should establish communication with the hardware. Moreover, if your robot needs calibration and is not calibrated, it should start a calibration procedure by default. If your robot needs some specific configuration, this should also be called here.",Yt,Me,St,ce,Rt,me,Ol="This method should gracefully terminate communication with the hardware: free any related resources (threads or processes), close ports, etc.",Qt,ye,es="Here, we already handle this in our <code>MotorsBus</code> and <code>Camera</code> classes so we just need to call their own <code>disconnect()</code> methods:",Ht,we,zt,je,Vt,ue,ts="LeRobot supports saving and loading calibration data automatically. This is useful for joint offsets, zero positions, or sensor alignment.",Xt,J,Fe,ls="Note that depending on your hardware, this may not apply. If that’s the case, you can simply leave these methods as no-ops:",Ul,de,Lt,fe,Ft,be,ss="This should reflect whether your robot has the required calibration loaded.",qt,Je,Pt,Te,Dt,he,as="The goal of the calibration is twofold:",Kt,Ue,ns="<li>Know the physical range of motion of each motors in order to only send commands within this range.</li> <li>Normalize raw motors positions to sensible continuous values (e.g. percentages, degrees) instead of arbitrary discrete value dependant on the specific motor used that will not replicate elsewhere.</li>",Ot,Ie,os="It should implement the logic for calibration (if relevant) and update the <code>self.calibration</code> dictionary. If you are using Feetech or Dynamixel motors, our bus interfaces already include methods to help with this.",el,Ce,tl,ve,ll,ge,is="Use this to set up any configuration for your hardware (servos control modes, controller gains, etc.). This should usually be run at connection time and be idempotent.",sl,$e,al,Ae,nl,_e,ps="These are the most important runtime functions: the core I/O loop.",ol,Be,il,Ze,rs="Returns a dictionary of sensor values from the robot. These typically include motor states, camera frames, various sensors, etc. In the LeRobot framework, these observations are what will be fed to a policy in order to predict the actions to take. The dictionary keys and structure must match <code>observation_features</code>.",pl,ke,rl,Ne,Ml,We,Ms="Takes a dictionary that matches <code>action_features</code>, and sends it to your hardware. You can add safety limits (clipping, smoothing) and return what was actually sent.",cl,xe,cs="For simplicity, we won’t be adding any modification of the actions in our example here.",ml,Ge,yl,Ee,wl,Ye,ms='For implementing teleoperation devices, we also provide a <a href="https://github.com/huggingface/lerobot/blob/main/lerobot/common/teleoperators/teleoperator.py" rel="nofollow"><code>Teleoperator</code></a> base class. This class is very similar to the <code>Robot</code> base class and also doesn’t assume anything on form factor.',jl,Se,ys="The main differences are in the I/O functions: a teleoperator allows you to produce action via <code>get_action</code> and can receive feedback actions via <code>send_feedback</code>. Feedback could be anything controllable on the teleoperation device that could help the person controlling it understand the consequences of the actions sent. Think motion/force feedback on a leader arm, vibrations on a gamepad controller for example. To implement a teleoperator, you can follow this same tutorial and adapt it for these two methods.",ul,Re,dl,Qe,ws="Once your robot class is complete, you can leverage the LeRobot ecosystem:",fl,He,js="<li>Control your robot with available teleoperators or integrate directly your teleoperating device</li> <li>Record training data and visualize it</li> <li>Integrate it into RL or imitation learning pipelines</li>",bl,ze,us='Don’t hesitate to reach out to the community for help on our <a href="https://discord.gg/s3KuuzsPFb" rel="nofollow">Discord</a> 🤗',Jl,Ve,Tl,qe,hl;return h=new j({props:{title:"Bring Your Own Hardware",local:"bring-your-own-hardware",headingTag:"h1"}}),C=new j({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),g=new j({props:{title:"Choose your motors",local:"choose-your-motors",headingTag:"h2"}}),E=new j({props:{title:"Step 1: Subclass the Robot Interface",local:"step-1-subclass-the-robot-interface",headingTag:"h2"}}),R=new d({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTJDJTIwZmllbGQlMEElMEFmcm9tJTIwbGVyb2JvdC5jb21tb24uY2FtZXJhcyUyMGltcG9ydCUyMENhbWVyYUNvbmZpZyUwQWZyb20lMjBsZXJvYm90LmNvbW1vbi5jYW1lcmFzLm9wZW5jdiUyMGltcG9ydCUyME9wZW5DVkNhbWVyYUNvbmZpZyUwQWZyb20lMjBsZXJvYm90LmNvbW1vbi5yb2JvdHMlMjBpbXBvcnQlMjBSb2JvdENvbmZpZyUwQSUwQSUwQSU0MFJvYm90Q29uZmlnLnJlZ2lzdGVyX3N1YmNsYXNzKCUyMm15X2Nvb2xfcm9ib3QlMjIpJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNeUNvb2xSb2JvdENvbmZpZyhSb2JvdENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwb3J0JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwY2FtZXJhcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBDYW1lcmFDb25maWclNUQlMjAlM0QlMjBmaWVsZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1fMSUyMiUzQSUyME9wZW5DVkNhbWVyYUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRleF9vcl9wYXRoJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0Q2NDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field

<span class="hljs-keyword">from</span> lerobot.common.cameras <span class="hljs-keyword">import</span> CameraConfig
<span class="hljs-keyword">from</span> lerobot.common.cameras.opencv <span class="hljs-keyword">import</span> OpenCVCameraConfig
<span class="hljs-keyword">from</span> lerobot.common.robots <span class="hljs-keyword">import</span> RobotConfig


<span class="hljs-meta">@RobotConfig.register_subclass(<span class="hljs-params"><span class="hljs-string">&quot;my_cool_robot&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobotConfig</span>(<span class="hljs-title class_ inherited__">RobotConfig</span>):
    port: <span class="hljs-built_in">str</span>
    cameras: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, CameraConfig] = field(
        default_factory={
            <span class="hljs-string">&quot;cam_1&quot;</span>: OpenCVCameraConfig(
                index_or_path=<span class="hljs-number">2</span>,
                fps=<span class="hljs-number">30</span>,
                width=<span class="hljs-number">480</span>,
                height=<span class="hljs-number">640</span>,
            ),
        }
    )`,wrap:!1}}),V=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.common.cameras <span class="hljs-keyword">import</span> make_cameras_from_configs
<span class="hljs-keyword">from</span> lerobot.common.motors <span class="hljs-keyword">import</span> Motor, MotorNormMode
<span class="hljs-keyword">from</span> lerobot.common.motors.feetech <span class="hljs-keyword">import</span> FeetechMotorsBus
<span class="hljs-keyword">from</span> lerobot.common.robots <span class="hljs-keyword">import</span> Robot

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobot</span>(<span class="hljs-title class_ inherited__">Robot</span>):
    config_class = MyCoolRobotConfig
    name = <span class="hljs-string">&quot;my_cool_robot&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyCoolRobotConfig</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.bus = FeetechMotorsBus(
            port=self.config.port,
            motors={
                <span class="hljs-string">&quot;joint_1&quot;</span>: Motor(<span class="hljs-number">1</span>, <span class="hljs-string">&quot;sts3250&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_2&quot;</span>: Motor(<span class="hljs-number">2</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_3&quot;</span>: Motor(<span class="hljs-number">3</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_4&quot;</span>: Motor(<span class="hljs-number">4</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_5&quot;</span>: Motor(<span class="hljs-number">5</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
            },
            calibration=self.calibration,
        )
        self.cameras = make_cameras_from_configs(config.cameras)`,wrap:!1}}),X=new j({props:{title:"Step 2: Define Observation and Action Features",local:"step-2-define-observation-and-action-features",headingTag:"h2"}}),b=new Is({props:{warning:!0,$$slots:{default:[vs]},$$scope:{ctx:Pe}}}),F=new j({props:{title:"observation_features",local:"observationfeatures",headingTag:"h3"}}),D=new d({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBfbW90b3JzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0eXBlJTVEJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzIucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJqb2ludF8zLnBvcyUyMiUzQSUyMGZsb2F0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfNC5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzUucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElNDBwcm9wZXJ0eSUwQWRlZiUyMF9jYW1lcmFzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0dXBsZSU1RCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbSUzQSUyMChzZWxmLmNhbWVyYXMlNUJjYW0lNUQuaGVpZ2h0JTJDJTIwc2VsZi5jYW1lcmFzJTVCY2FtJTVELndpZHRoJTJDJTIwMyklMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSU0MHByb3BlcnR5JTBBZGVmJTIwb2JzZXJ2YXRpb25fZmVhdHVyZXMoc2VsZiklMjAtJTNFJTIwZGljdCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3Qioqc2VsZi5fbW90b3JzX2Z0JTJDJTIwKipzZWxmLl9jYW1lcmFzX2Z0JTdE",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_motors_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">type</span>]:
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;joint_1.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_2.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_3.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_4.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_5.pos&quot;</span>: <span class="hljs-built_in">float</span>,
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_cameras_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">tuple</span>]:
    <span class="hljs-keyword">return</span> {
        cam: (self.cameras[cam].height, self.cameras[cam].width, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">observation_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> {**self._motors_ft, **self._cameras_ft}`,wrap:!1}}),O=new j({props:{title:"action_features",local:"actionfeatures",headingTag:"h3"}}),le=new d({props:{code:"ZGVmJTIwYWN0aW9uX2ZlYXR1cmVzKHNlbGYpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9tb3RvcnNfZnQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">action_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> self._motors_ft`,wrap:!1}}),se=new j({props:{title:"Step 3: Handle Connection and Disconnection",local:"step-3-handle-connection-and-disconnection",headingTag:"h2"}}),ne=new j({props:{title:"is_connected",local:"isconnected",headingTag:"h3"}}),ie=new d({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jb25uZWN0ZWQoc2VsZiklMjAtJTNFJTIwYm9vbCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuYnVzLmlzX2Nvbm5lY3RlZCUyMGFuZCUyMGFsbChjYW0uaXNfY29ubmVjdGVkJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCkp",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_connected</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_connected <span class="hljs-keyword">and</span> <span class="hljs-built_in">all</span>(cam.is_connected <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values())`,wrap:!1}}),pe=new j({props:{title:"connect()",local:"connect",headingTag:"h3"}}),Me=new d({props:{code:"ZGVmJTIwY29ubmVjdChzZWxmJTJDJTIwY2FsaWJyYXRlJTNBJTIwYm9vbCUyMCUzRCUyMFRydWUpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25uZWN0KCklMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY2FsaWJyYXRlZCUyMGFuZCUyMGNhbGlicmF0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2FsaWJyYXRlKCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy52YWx1ZXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbS5jb25uZWN0KCklMEElMEElMjAlMjAlMjAlMjBzZWxmLmNvbmZpZ3VyZSgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">connect</span>(<span class="hljs-params">self, calibrate: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span></span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.connect()
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_calibrated <span class="hljs-keyword">and</span> calibrate:
        self.calibrate()

    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.connect()

    self.configure()`,wrap:!1}}),ce=new j({props:{title:"disconnect()",local:"disconnect",headingTag:"h3"}}),we=new d({props:{code:"ZGVmJTIwZGlzY29ubmVjdChzZWxmKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuZGlzY29ubmVjdCgpJTBBJTIwJTIwJTIwJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYW0uZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">disconnect</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disconnect()
    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.disconnect()`,wrap:!1}}),je=new j({props:{title:"Step 4: Support Calibration and Configuration",local:"step-4-support-calibration-and-configuration",headingTag:"h2"}}),de=new d({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElMjAlMjAlMjByZXR1cm4lMjBUcnVlJTBBJTBBZGVmJTIwY2FsaWJyYXRlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
   <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
   <span class="hljs-keyword">pass</span>`,wrap:!1}}),fe=new j({props:{title:"is_calibrated",local:"iscalibrated",headingTag:"h3"}}),Je=new d({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmJ1cy5pc19jYWxpYnJhdGVk",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_calibrated`,wrap:!1}}),Te=new j({props:{title:"calibrate()",local:"calibrate",headingTag:"h3"}}),Ce=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disable_torque()
    <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
        self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)

    <span class="hljs-built_in">input</span>(<span class="hljs-string">f&quot;Move <span class="hljs-subst">{self}</span> to the middle of its range of motion and press ENTER....&quot;</span>)
    homing_offsets = self.bus.set_half_turn_homings()

    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;Move all joints sequentially through their entire ranges &quot;</span>
        <span class="hljs-string">&quot;of motion.\\nRecording positions. Press ENTER to stop...&quot;</span>
    )
    range_mins, range_maxes = self.bus.record_ranges_of_motion()

    self.calibration = {}
    <span class="hljs-keyword">for</span> motor, m <span class="hljs-keyword">in</span> self.bus.motors.items():
        self.calibration[motor] = MotorCalibration(
            <span class="hljs-built_in">id</span>=m.<span class="hljs-built_in">id</span>,
            drive_mode=<span class="hljs-number">0</span>,
            homing_offset=homing_offsets[motor],
            range_min=range_mins[motor],
            range_max=range_maxes[motor],
        )

    self.bus.write_calibration(self.calibration)
    self._save_calibration()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Calibration saved to&quot;</span>, self.calibration_fpath)`,wrap:!1}}),ve=new j({props:{title:"configure()",local:"configure",headingTag:"h3"}}),$e=new d({props:{code:"ZGVmJTIwY29uZmlndXJlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwc2VsZi5idXMudG9ycXVlX2Rpc2FibGVkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25maWd1cmVfbW90b3JzKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBtb3RvciUyMGluJTIwc2VsZi5idXMubW90b3JzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyT3BlcmF0aW5nX01vZGUlMjIlMkMlMjBtb3RvciUyQyUyME9wZXJhdGluZ01vZGUuUE9TSVRJT04udmFsdWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyUF9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMTYpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIySV9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy53cml0ZSglMjJEX0NvZWZmaWNpZW50JTIyJTJDJTIwbW90b3IlMkMlMjAzMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">configure</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">with</span> self.bus.torque_disabled():
        self.bus.configure_motors()
        <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
            self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)
            self.bus.write(<span class="hljs-string">&quot;P_Coefficient&quot;</span>, motor, <span class="hljs-number">16</span>)
            self.bus.write(<span class="hljs-string">&quot;I_Coefficient&quot;</span>, motor, <span class="hljs-number">0</span>)
            self.bus.write(<span class="hljs-string">&quot;D_Coefficient&quot;</span>, motor, <span class="hljs-number">32</span>)`,wrap:!1}}),Ae=new j({props:{title:"Step 5: Implement Sensors Reading and Action Sending",local:"step-5-implement-sensors-reading-and-action-sending",headingTag:"h2"}}),Be=new j({props:{title:"get_observation()",local:"getobservation",headingTag:"h3"}}),ke=new d({props:{code:"ZGVmJTIwZ2V0X29ic2VydmF0aW9uKHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY29ubmVjdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBDb25uZWN0aW9uRXJyb3IoZiUyMiU3QnNlbGYlN0QlMjBpcyUyMG5vdCUyMGNvbm5lY3RlZC4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmVhZCUyMGFybSUyMHBvc2l0aW9uJTBBJTIwJTIwJTIwJTIwb2JzX2RpY3QlMjAlM0QlMjBzZWxmLmJ1cy5zeW5jX3JlYWQoJTIyUHJlc2VudF9Qb3NpdGlvbiUyMiklMEElMjAlMjAlMjAlMjBvYnNfZGljdCUyMCUzRCUyMCU3QmYlMjIlN0Jtb3RvciU3RC5wb3MlMjIlM0ElMjB2YWwlMjBmb3IlMjBtb3RvciUyQyUyMHZhbCUyMGluJTIwb2JzX2RpY3QuaXRlbXMoKSU3RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENhcHR1cmUlMjBpbWFnZXMlMjBmcm9tJTIwY2FtZXJhcyUwQSUyMCUyMCUyMCUyMGZvciUyMGNhbV9rZXklMkMlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzX2RpY3QlNUJjYW1fa2V5JTVEJTIwJTNEJTIwY2FtLmFzeW5jX3JlYWQoKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9ic19kaWN0",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_observation</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_connected:
        <span class="hljs-keyword">raise</span> ConnectionError(<span class="hljs-string">f&quot;<span class="hljs-subst">{self}</span> is not connected.&quot;</span>)

    <span class="hljs-comment"># Read arm position</span>
    obs_dict = self.bus.sync_read(<span class="hljs-string">&quot;Present_Position&quot;</span>)
    obs_dict = {<span class="hljs-string">f&quot;<span class="hljs-subst">{motor}</span>.pos&quot;</span>: val <span class="hljs-keyword">for</span> motor, val <span class="hljs-keyword">in</span> obs_dict.items()}

    <span class="hljs-comment"># Capture images from cameras</span>
    <span class="hljs-keyword">for</span> cam_key, cam <span class="hljs-keyword">in</span> self.cameras.items():
        obs_dict[cam_key] = cam.async_read()

    <span class="hljs-keyword">return</span> obs_dict`,wrap:!1}}),Ne=new j({props:{title:"send_action()",local:"sendaction",headingTag:"h3"}}),Ge=new d({props:{code:"ZGVmJTIwc2VuZF9hY3Rpb24oc2VsZiUyQyUyMGFjdGlvbiUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBnb2FsX3BvcyUyMCUzRCUyMCU3QmtleS5yZW1vdmVzdWZmaXgoJTIyLnBvcyUyMiklM0ElMjB2YWwlMjBmb3IlMjBrZXklMkMlMjB2YWwlMjBpbiUyMGFjdGlvbi5pdGVtcygpJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2VuZCUyMGdvYWwlMjBwb3NpdGlvbiUyMHRvJTIwdGhlJTIwYXJtJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuc3luY193cml0ZSglMjJHb2FsX1Bvc2l0aW9uJTIyJTJDJTIwZ29hbF9wb3MpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">send_action</span>(<span class="hljs-params">self, action: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    goal_pos = {key.removesuffix(<span class="hljs-string">&quot;.pos&quot;</span>): val <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> action.items()}

    <span class="hljs-comment"># Send goal position to the arm</span>
    self.bus.sync_write(<span class="hljs-string">&quot;Goal_Position&quot;</span>, goal_pos)

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),Ee=new j({props:{title:"Adding a Teleoperator",local:"adding-a-teleoperator",headingTag:"h2"}}),Re=new j({props:{title:"Wrapping Up",local:"wrapping-up",headingTag:"h2"}}),Ve=new Cs({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/integrate_hardware.mdx"}}),{c(){u=o("meta"),T=a(),f=o("p"),Le=a(),r(h.$$.fragment),De=a(),U=o("p"),U.textContent=vl,Ke=a(),I=o("p"),I.innerHTML=gl,Oe=a(),r(C.$$.fragment),et=a(),v=o("ul"),v.innerHTML=$l,tt=a(),r(g.$$.fragment),lt=a(),$=o("p"),$.textContent=Al,st=a(),A=o("ul"),A.innerHTML=_l,at=a(),_=o("p"),_.innerHTML=Bl,nt=a(),B=o("p"),B.textContent=Zl,ot=a(),Z=o("ul"),Z.innerHTML=kl,it=a(),k=o("p"),k.textContent=Nl,pt=a(),N=o("p"),N.textContent=Wl,rt=a(),W=o("ul"),W.innerHTML=xl,Mt=a(),x=o("p"),x.innerHTML=Gl,ct=a(),G=o("p"),G.innerHTML=El,mt=a(),r(E.$$.fragment),yt=a(),Y=o("p"),Y.innerHTML=Yl,wt=a(),S=o("p"),S.textContent=Sl,jt=a(),r(R.$$.fragment),ut=a(),Q=o("p"),Q.innerHTML=Rl,dt=a(),H=o("p"),H.innerHTML=Ql,ft=a(),z=o("p"),z.innerHTML=Hl,bt=a(),r(V.$$.fragment),Jt=a(),r(X.$$.fragment),Tt=a(),L=o("p"),L.innerHTML=zl,ht=a(),r(b.$$.fragment),Ut=a(),r(F.$$.fragment),It=a(),q=o("p"),q.innerHTML=Vl,Ct=a(),P=o("p"),P.textContent=Xl,vt=a(),r(D.$$.fragment),gt=a(),K=o("p"),K.textContent=Ll,$t=a(),r(O.$$.fragment),At=a(),ee=o("p"),ee.innerHTML=Fl,_t=a(),te=o("p"),te.innerHTML=ql,Bt=a(),r(le.$$.fragment),Zt=a(),r(se.$$.fragment),kt=a(),ae=o("p"),ae.textContent=Pl,Nt=a(),r(ne.$$.fragment),Wt=a(),oe=o("p"),oe.innerHTML=Dl,xt=a(),r(ie.$$.fragment),Gt=a(),r(pe.$$.fragment),Et=a(),re=o("p"),re.textContent=Kl,Yt=a(),r(Me.$$.fragment),St=a(),r(ce.$$.fragment),Rt=a(),me=o("p"),me.textContent=Ol,Qt=a(),ye=o("p"),ye.innerHTML=es,Ht=a(),r(we.$$.fragment),zt=a(),r(je.$$.fragment),Vt=a(),ue=o("p"),ue.textContent=ts,Xt=a(),J=o("blockquote"),Fe=o("p"),Fe.textContent=ls,Ul=a(),r(de.$$.fragment),Lt=a(),r(fe.$$.fragment),Ft=a(),be=o("p"),be.textContent=ss,qt=a(),r(Je.$$.fragment),Pt=a(),r(Te.$$.fragment),Dt=a(),he=o("p"),he.textContent=as,Kt=a(),Ue=o("ul"),Ue.innerHTML=ns,Ot=a(),Ie=o("p"),Ie.innerHTML=os,el=a(),r(Ce.$$.fragment),tl=a(),r(ve.$$.fragment),ll=a(),ge=o("p"),ge.textContent=is,sl=a(),r($e.$$.fragment),al=a(),r(Ae.$$.fragment),nl=a(),_e=o("p"),_e.textContent=ps,ol=a(),r(Be.$$.fragment),il=a(),Ze=o("p"),Ze.innerHTML=rs,pl=a(),r(ke.$$.fragment),rl=a(),r(Ne.$$.fragment),Ml=a(),We=o("p"),We.innerHTML=Ms,cl=a(),xe=o("p"),xe.textContent=cs,ml=a(),r(Ge.$$.fragment),yl=a(),r(Ee.$$.fragment),wl=a(),Ye=o("p"),Ye.innerHTML=ms,jl=a(),Se=o("p"),Se.innerHTML=ys,ul=a(),r(Re.$$.fragment),dl=a(),Qe=o("p"),Qe.textContent=ws,fl=a(),He=o("ul"),He.innerHTML=js,bl=a(),ze=o("p"),ze.innerHTML=us,Jl=a(),r(Ve.$$.fragment),Tl=a(),qe=o("p"),this.h()},l(e){const t=Us("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(l),T=n(e),f=i(e,"P",{}),Il(f).forEach(l),Le=n(e),M(h.$$.fragment,e),De=n(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-sl443g"&&(U.textContent=vl),Ke=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-njx45z"&&(I.innerHTML=gl),Oe=n(e),M(C.$$.fragment,e),et=n(e),v=i(e,"UL",{"data-svelte-h":!0}),p(v)!=="svelte-11itqwk"&&(v.innerHTML=$l),tt=n(e),M(g.$$.fragment,e),lt=n(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-9dsyh9"&&($.textContent=Al),st=n(e),A=i(e,"UL",{"data-svelte-h":!0}),p(A)!=="svelte-p8d11k"&&(A.innerHTML=_l),at=n(e),_=i(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1yhrrnd"&&(_.innerHTML=Bl),nt=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-12o83v0"&&(B.textContent=Zl),ot=n(e),Z=i(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-1d5xfjp"&&(Z.innerHTML=kl),it=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1e113uy"&&(k.textContent=Nl),pt=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1fd17pl"&&(N.textContent=Wl),rt=n(e),W=i(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-d0ywoi"&&(W.innerHTML=xl),Mt=n(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-17510ml"&&(x.innerHTML=Gl),ct=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-tm2a0s"&&(G.innerHTML=El),mt=n(e),M(E.$$.fragment,e),yt=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-rc24jv"&&(Y.innerHTML=Yl),wt=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1p0w0g0"&&(S.textContent=Sl),jt=n(e),M(R.$$.fragment,e),ut=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-dve2yg"&&(Q.innerHTML=Rl),dt=n(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-dxku0t"&&(H.innerHTML=Ql),ft=n(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-nb93rz"&&(z.innerHTML=Hl),bt=n(e),M(V.$$.fragment,e),Jt=n(e),M(X.$$.fragment,e),Tt=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-l9j1d3"&&(L.innerHTML=zl),ht=n(e),M(b.$$.fragment,e),Ut=n(e),M(F.$$.fragment,e),It=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-u7pcb4"&&(q.innerHTML=Vl),Ct=n(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1t42iyr"&&(P.textContent=Xl),vt=n(e),M(D.$$.fragment,e),gt=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1rkp57y"&&(K.textContent=Ll),$t=n(e),M(O.$$.fragment,e),At=n(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-12yyl6o"&&(ee.innerHTML=Fl),_t=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1h5avx7"&&(te.innerHTML=ql),Bt=n(e),M(le.$$.fragment,e),Zt=n(e),M(se.$$.fragment,e),kt=n(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-h4v7d7"&&(ae.textContent=Pl),Nt=n(e),M(ne.$$.fragment,e),Wt=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1gpnath"&&(oe.innerHTML=Dl),xt=n(e),M(ie.$$.fragment,e),Gt=n(e),M(pe.$$.fragment,e),Et=n(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1iphpc4"&&(re.textContent=Kl),Yt=n(e),M(Me.$$.fragment,e),St=n(e),M(ce.$$.fragment,e),Rt=n(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-lfuhuo"&&(me.textContent=Ol),Qt=n(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-1seywak"&&(ye.innerHTML=es),Ht=n(e),M(we.$$.fragment,e),zt=n(e),M(je.$$.fragment,e),Vt=n(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1e7cuec"&&(ue.textContent=ts),Xt=n(e),J=i(e,"BLOCKQUOTE",{});var Xe=Il(J);Fe=i(Xe,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1dxm2cf"&&(Fe.textContent=ls),Ul=n(Xe),M(de.$$.fragment,Xe),Xe.forEach(l),Lt=n(e),M(fe.$$.fragment,e),Ft=n(e),be=i(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-10g0kc3"&&(be.textContent=ss),qt=n(e),M(Je.$$.fragment,e),Pt=n(e),M(Te.$$.fragment,e),Dt=n(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-15x8ibh"&&(he.textContent=as),Kt=n(e),Ue=i(e,"UL",{"data-svelte-h":!0}),p(Ue)!=="svelte-1ka4i7r"&&(Ue.innerHTML=ns),Ot=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-7etria"&&(Ie.innerHTML=os),el=n(e),M(Ce.$$.fragment,e),tl=n(e),M(ve.$$.fragment,e),ll=n(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1gxojkw"&&(ge.textContent=is),sl=n(e),M($e.$$.fragment,e),al=n(e),M(Ae.$$.fragment,e),nl=n(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1qfd9tp"&&(_e.textContent=ps),ol=n(e),M(Be.$$.fragment,e),il=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-adteeq"&&(Ze.innerHTML=rs),pl=n(e),M(ke.$$.fragment,e),rl=n(e),M(Ne.$$.fragment,e),Ml=n(e),We=i(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-1elar01"&&(We.innerHTML=Ms),cl=n(e),xe=i(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-xmm0bj"&&(xe.textContent=cs),ml=n(e),M(Ge.$$.fragment,e),yl=n(e),M(Ee.$$.fragment,e),wl=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-xkh41l"&&(Ye.innerHTML=ms),jl=n(e),Se=i(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-19bs1hk"&&(Se.innerHTML=ys),ul=n(e),M(Re.$$.fragment,e),dl=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-ta7vyn"&&(Qe.textContent=ws),fl=n(e),He=i(e,"UL",{"data-svelte-h":!0}),p(He)!=="svelte-16m8r0w"&&(He.innerHTML=js),bl=n(e),ze=i(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-o90m39"&&(ze.innerHTML=us),Jl=n(e),M(Ve.$$.fragment,e),Tl=n(e),qe=i(e,"P",{}),Il(qe).forEach(l),this.h()},h(){ds(u,"name","hf:doc:metadata"),ds(u,"content",$s)},m(e,t){Cl(document.head,u),s(e,T,t),s(e,f,t),s(e,Le,t),c(h,e,t),s(e,De,t),s(e,U,t),s(e,Ke,t),s(e,I,t),s(e,Oe,t),c(C,e,t),s(e,et,t),s(e,v,t),s(e,tt,t),c(g,e,t),s(e,lt,t),s(e,$,t),s(e,st,t),s(e,A,t),s(e,at,t),s(e,_,t),s(e,nt,t),s(e,B,t),s(e,ot,t),s(e,Z,t),s(e,it,t),s(e,k,t),s(e,pt,t),s(e,N,t),s(e,rt,t),s(e,W,t),s(e,Mt,t),s(e,x,t),s(e,ct,t),s(e,G,t),s(e,mt,t),c(E,e,t),s(e,yt,t),s(e,Y,t),s(e,wt,t),s(e,S,t),s(e,jt,t),c(R,e,t),s(e,ut,t),s(e,Q,t),s(e,dt,t),s(e,H,t),s(e,ft,t),s(e,z,t),s(e,bt,t),c(V,e,t),s(e,Jt,t),c(X,e,t),s(e,Tt,t),s(e,L,t),s(e,ht,t),c(b,e,t),s(e,Ut,t),c(F,e,t),s(e,It,t),s(e,q,t),s(e,Ct,t),s(e,P,t),s(e,vt,t),c(D,e,t),s(e,gt,t),s(e,K,t),s(e,$t,t),c(O,e,t),s(e,At,t),s(e,ee,t),s(e,_t,t),s(e,te,t),s(e,Bt,t),c(le,e,t),s(e,Zt,t),c(se,e,t),s(e,kt,t),s(e,ae,t),s(e,Nt,t),c(ne,e,t),s(e,Wt,t),s(e,oe,t),s(e,xt,t),c(ie,e,t),s(e,Gt,t),c(pe,e,t),s(e,Et,t),s(e,re,t),s(e,Yt,t),c(Me,e,t),s(e,St,t),c(ce,e,t),s(e,Rt,t),s(e,me,t),s(e,Qt,t),s(e,ye,t),s(e,Ht,t),c(we,e,t),s(e,zt,t),c(je,e,t),s(e,Vt,t),s(e,ue,t),s(e,Xt,t),s(e,J,t),Cl(J,Fe),Cl(J,Ul),c(de,J,null),s(e,Lt,t),c(fe,e,t),s(e,Ft,t),s(e,be,t),s(e,qt,t),c(Je,e,t),s(e,Pt,t),c(Te,e,t),s(e,Dt,t),s(e,he,t),s(e,Kt,t),s(e,Ue,t),s(e,Ot,t),s(e,Ie,t),s(e,el,t),c(Ce,e,t),s(e,tl,t),c(ve,e,t),s(e,ll,t),s(e,ge,t),s(e,sl,t),c($e,e,t),s(e,al,t),c(Ae,e,t),s(e,nl,t),s(e,_e,t),s(e,ol,t),c(Be,e,t),s(e,il,t),s(e,Ze,t),s(e,pl,t),c(ke,e,t),s(e,rl,t),c(Ne,e,t),s(e,Ml,t),s(e,We,t),s(e,cl,t),s(e,xe,t),s(e,ml,t),c(Ge,e,t),s(e,yl,t),c(Ee,e,t),s(e,wl,t),s(e,Ye,t),s(e,jl,t),s(e,Se,t),s(e,ul,t),c(Re,e,t),s(e,dl,t),s(e,Qe,t),s(e,fl,t),s(e,He,t),s(e,bl,t),s(e,ze,t),s(e,Jl,t),c(Ve,e,t),s(e,Tl,t),s(e,qe,t),hl=!0},p(e,[t]){const Xe={};t&2&&(Xe.$$scope={dirty:t,ctx:e}),b.$set(Xe)},i(e){hl||(m(h.$$.fragment,e),m(C.$$.fragment,e),m(g.$$.fragment,e),m(E.$$.fragment,e),m(R.$$.fragment,e),m(V.$$.fragment,e),m(X.$$.fragment,e),m(b.$$.fragment,e),m(F.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(Me.$$.fragment,e),m(ce.$$.fragment,e),m(we.$$.fragment,e),m(je.$$.fragment,e),m(de.$$.fragment,e),m(fe.$$.fragment,e),m(Je.$$.fragment,e),m(Te.$$.fragment,e),m(Ce.$$.fragment,e),m(ve.$$.fragment,e),m($e.$$.fragment,e),m(Ae.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(Ne.$$.fragment,e),m(Ge.$$.fragment,e),m(Ee.$$.fragment,e),m(Re.$$.fragment,e),m(Ve.$$.fragment,e),hl=!0)},o(e){y(h.$$.fragment,e),y(C.$$.fragment,e),y(g.$$.fragment,e),y(E.$$.fragment,e),y(R.$$.fragment,e),y(V.$$.fragment,e),y(X.$$.fragment,e),y(b.$$.fragment,e),y(F.$$.fragment,e),y(D.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),y(ce.$$.fragment,e),y(we.$$.fragment,e),y(je.$$.fragment,e),y(de.$$.fragment,e),y(fe.$$.fragment,e),y(Je.$$.fragment,e),y(Te.$$.fragment,e),y(Ce.$$.fragment,e),y(ve.$$.fragment,e),y($e.$$.fragment,e),y(Ae.$$.fragment,e),y(Be.$$.fragment,e),y(ke.$$.fragment,e),y(Ne.$$.fragment,e),y(Ge.$$.fragment,e),y(Ee.$$.fragment,e),y(Re.$$.fragment,e),y(Ve.$$.fragment,e),hl=!1},d(e){e&&(l(T),l(f),l(Le),l(De),l(U),l(Ke),l(I),l(Oe),l(et),l(v),l(tt),l(lt),l($),l(st),l(A),l(at),l(_),l(nt),l(B),l(ot),l(Z),l(it),l(k),l(pt),l(N),l(rt),l(W),l(Mt),l(x),l(ct),l(G),l(mt),l(yt),l(Y),l(wt),l(S),l(jt),l(ut),l(Q),l(dt),l(H),l(ft),l(z),l(bt),l(Jt),l(Tt),l(L),l(ht),l(Ut),l(It),l(q),l(Ct),l(P),l(vt),l(gt),l(K),l($t),l(At),l(ee),l(_t),l(te),l(Bt),l(Zt),l(kt),l(ae),l(Nt),l(Wt),l(oe),l(xt),l(Gt),l(Et),l(re),l(Yt),l(St),l(Rt),l(me),l(Qt),l(ye),l(Ht),l(zt),l(Vt),l(ue),l(Xt),l(J),l(Lt),l(Ft),l(be),l(qt),l(Pt),l(Dt),l(he),l(Kt),l(Ue),l(Ot),l(Ie),l(el),l(tl),l(ll),l(ge),l(sl),l(al),l(nl),l(_e),l(ol),l(il),l(Ze),l(pl),l(rl),l(Ml),l(We),l(cl),l(xe),l(ml),l(yl),l(wl),l(Ye),l(jl),l(Se),l(ul),l(dl),l(Qe),l(fl),l(He),l(bl),l(ze),l(Jl),l(Tl),l(qe)),l(u),w(h,e),w(C,e),w(g,e),w(E,e),w(R,e),w(V,e),w(X,e),w(b,e),w(F,e),w(D,e),w(O,e),w(le,e),w(se,e),w(ne,e),w(ie,e),w(pe,e),w(Me,e),w(ce,e),w(we,e),w(je,e),w(de),w(fe,e),w(Je,e),w(Te,e),w(Ce,e),w(ve,e),w($e,e),w(Ae,e),w(Be,e),w(ke,e),w(Ne,e),w(Ge,e),w(Ee,e),w(Re,e),w(Ve,e)}}}const $s='{"title":"Bring Your Own Hardware","local":"bring-your-own-hardware","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Choose your motors","local":"choose-your-motors","sections":[],"depth":2},{"title":"Step 1: Subclass the Robot Interface","local":"step-1-subclass-the-robot-interface","sections":[],"depth":2},{"title":"Step 2: Define Observation and Action Features","local":"step-2-define-observation-and-action-features","sections":[{"title":"observation_features","local":"observationfeatures","sections":[],"depth":3},{"title":"action_features","local":"actionfeatures","sections":[],"depth":3}],"depth":2},{"title":"Step 3: Handle Connection and Disconnection","local":"step-3-handle-connection-and-disconnection","sections":[{"title":"is_connected","local":"isconnected","sections":[],"depth":3},{"title":"connect()","local":"connect","sections":[],"depth":3},{"title":"disconnect()","local":"disconnect","sections":[],"depth":3}],"depth":2},{"title":"Step 4: Support Calibration and Configuration","local":"step-4-support-calibration-and-configuration","sections":[{"title":"is_calibrated","local":"iscalibrated","sections":[],"depth":3},{"title":"calibrate()","local":"calibrate","sections":[],"depth":3},{"title":"configure()","local":"configure","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Implement Sensors Reading and Action Sending","local":"step-5-implement-sensors-reading-and-action-sending","sections":[{"title":"get_observation()","local":"getobservation","sections":[],"depth":3},{"title":"send_action()","local":"sendaction","sections":[],"depth":3}],"depth":2},{"title":"Adding a Teleoperator","local":"adding-a-teleoperator","sections":[],"depth":2},{"title":"Wrapping Up","local":"wrapping-up","sections":[],"depth":2}],"depth":1}';function As(Pe){return bs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ws extends Ts{constructor(u){super(),hs(this,u,As,gs,fs,{})}}export{Ws as component};
