import{s as Rt,n as St,o as kt}from"../chunks/scheduler.7da89386.js";import{S as Qt,i as Nt,g as i,s as n,r as m,A as Ft,h as p,f as l,c as a,j as _t,u as o,x as b,k as dt,y as Yt,a as s,v as r,d,t as u,w as c}from"../chunks/index.20910acc.js";import{C as M}from"../chunks/CodeBlock.cde23137.js";import{H as h,E as zt}from"../chunks/EditOnGithub.ba36cbd0.js";function Ht(ut){let f,be,ue,Me,w,he,J,fe,Z,ct=`Stable Diffusion models can also be used when running inference with OpenVINO. When Stable Diffusion models
are exported to the OpenVINO format, they are decomposed into different components that are later combined during inference:`,ye,U,bt="<li>The text encoder</li> <li>The U-NET</li> <li>The VAE encoder</li> <li>The VAE decoder</li>",we,T,Mt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVStableDiffusionPipeline</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>OVStableDiffusionImg2ImgPipeline</code></td></tr> <tr><td><code>inpaint</code></td> <td><code>OVStableDiffusionInpaintPipeline</code></td></tr></tbody>",Je,g,Ze,W,ht="Here is an example of how you can load an OpenVINO Stable Diffusion model and run inference using OpenVINO Runtime:",Ue,j,Te,G,ft="To load your PyTorch model and convert it to OpenVINO on the fly, you can set <code>export=True</code>.",ge,B,We,v,yt="To further speed up inference, the model can be statically reshaped :",je,V,Ge,x,wt="In case you want to change any parameters such as the outputs height or width, you’ll need to statically reshape your model once again.",Be,y,Jt='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/stable_diffusion_v1_5_sail_boat_rembrandt.png"/>',ve,I,Ve,$,Zt="Here is an example of how you can load an OpenVINO Stable Diffusion model with pre-trained textual inversion embeddings and run inference using OpenVINO Runtime:",xe,X,Ut="First, you can run original pipeline without textual inversion",Ie,C,$e,_,Tt='Then, you can load <a href="https://huggingface.co/sd-concepts-library/cat-toy" rel="nofollow">sd-concepts-library/cat-toy</a> textual inversion embedding and run pipeline with same prompt again',Xe,R,Ce,S,gt="The left image shows the generation result of original stable diffusion v1.5, the right image shows the generation result of stable diffusion v1.5 with textual inversion.",_e,k,Wt='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/stable_diffusion_v1_5_without_textual_inversion.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/stable_diffusion_v1_5_with_textual_inversion.png"/></td></tr></tbody>',Re,Q,Se,N,ke,F,Qe,Y,jt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVStableDiffusionXLPipeline</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>OVStableDiffusionXLImg2ImgPipeline</code></td></tr></tbody>",Ne,z,Fe,H,Gt='Here is an example of how you can load a SDXL OpenVINO model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> and run inference using OpenVINO Runtime:',Ye,E,ze,L,Bt='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/train_station_friedrich.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/train_station_friedrich_2.png"/></td></tr></tbody>',He,q,Ee,D,vt='Here is an example of how you can load an SDXL OpenVINO model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> with pre-trained textual inversion embeddings and run inference using OpenVINO Runtime:',Le,P,Vt="First, you can run original pipeline without textual inversion",qe,O,De,A,xt='Then, you can load <a href="https://civitai.com/models/3036/charturner-character-turnaround-helper-for-15-and-21" rel="nofollow">charturnerv2</a> textual inversion embedding and run pipeline with same prompt again',Pe,K,Oe,ee,Ae,te,It="Here is an example of how you can load a PyTorch SDXL model, convert it to OpenVINO on-the-fly and run inference using OpenVINO Runtime for <em>image-to-image</em>:",Ke,le,et,se,tt,ne,$t='The image can be refined by making use of a model like <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-refiner-1.0</a>. In this case, you only have to output the latents from the base model.',lt,ae,st,ie,nt,pe,Xt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVLatentConsistencyModelPipeline</code></td></tr></tbody>",at,me,it,oe,Ct='Here is an example of how you can load a Latent Consistency Model (LCM) from <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> and run inference using OpenVINO :',pt,re,mt,de,ot,ce,rt;return w=new h({props:{title:"Generate images with Diffusion models",local:"generate-images-with-diffusion-models",headingTag:"h1"}}),J=new h({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),g=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),j=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJlY2hhcmxhaXglMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUtb3BlbnZpbm8lMjIlMEFwaXBlbGluZSUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwUmVtYnJhbmR0JTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline

model_id = <span class="hljs-string">&quot;echarlaix/stable-diffusion-v1-5-openvino&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Rembrandt&quot;</span>
images = pipeline(prompt).images`,wrap:!1}}),B=new M({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUyMyUyMERvbid0JTIwZm9yZ2V0JTIwdG8lMjBzYXZlJTIwdGhlJTIwZXhwb3J0ZWQlMjBtb2RlbCUwQXBpcGVsaW5lLnNhdmVfcHJldHJhaW5lZCglMjJvcGVudmluby1zZC12MS01JTIyKQ==",highlighted:`model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Don&#x27;t forget to save the exported model</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-v1-5&quot;</span>)`,wrap:!1}}),V=new M({props:{code:"JTIzJTIwRGVmaW5lJTIwdGhlJTIwc2hhcGVzJTIwcmVsYXRlZCUyMHRvJTIwdGhlJTIwaW5wdXRzJTIwYW5kJTIwZGVzaXJlZCUyMG91dHB1dHMlMEFiYXRjaF9zaXplJTJDJTIwbnVtX2ltYWdlcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwMSUyQyUyMDElMkMlMjA1MTIlMkMlMjA1MTIlMEElMjMlMjBTdGF0aWNhbGx5JTIwcmVzaGFwZSUyMHRoZSUyMG1vZGVsJTBBcGlwZWxpbmUucmVzaGFwZShiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMGhlaWdodCUzRGhlaWdodCUyQyUyMHdpZHRoJTNEd2lkdGglMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzKSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBcGlwZWxpbmUuY29tcGlsZSgpJTBBJTBBJTIzJTIwUnVuJTIwaW5mZXJlbmNlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaGVpZ2h0JTNEaGVpZ2h0JTJDJTIwd2lkdGglM0R3aWR0aCUyQyUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXMpLmltYWdlcw==",highlighted:`<span class="hljs-comment"># Define the shapes related to the inputs and desired outputs</span>
batch_size, num_images, height, width = <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>
<span class="hljs-comment"># Statically reshape the model</span>
pipeline.reshape(batch_size=batch_size, height=height, width=width, num_images_per_prompt=num_images)
<span class="hljs-comment"># Compile the model before the first inference</span>
pipeline.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Run inference</span>
images = pipeline(prompt, height=height, width=width, num_images_per_prompt=num_images).images`,wrap:!1}}),I=new h({props:{title:"Text-to-Image with Textual Inversion",local:"text-to-image-with-textual-inversion",headingTag:"h3"}}),C=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJlY2hhcmxhaXglMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUtb3BlbnZpbm8lMjIlMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwJTNDY2F0LXRveSUzRSUyMGJhY2stcGFjayUyMiUwQSUyMyUyMFNldCUyMGElMjByYW5kb20lMjBzZWVkJTIwZm9yJTIwYmV0dGVyJTIwY29tcGFyaXNvbiUwQW5wLnJhbmRvbS5zZWVkKDQyKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RGYWxzZSUyQyUyMGNvbXBpbGUlM0RGYWxzZSklMEFwaXBlbGluZS5jb21waWxlKCklMEFpbWFnZTElMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZTEuc2F2ZSglMjJzdGFibGVfZGlmZnVzaW9uX3YxXzVfd2l0aG91dF90ZXh0dWFsX2ludmVyc2lvbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;echarlaix/stable-diffusion-v1-5-openvino&quot;</span>
prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; back-pack&quot;</span>
<span class="hljs-comment"># Set a random seed for better comparison</span>
np.random.seed(<span class="hljs-number">42</span>)

pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">False</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
pipeline.<span class="hljs-built_in">compile</span>()
image1 = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image1.save(<span class="hljs-string">&quot;stable_diffusion_v1_5_without_textual_inversion.png&quot;</span>)`,wrap:!1}}),R=new M({props:{code:"JTIzJTIwUmVzZXQlMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQXBpcGVsaW5lLmNsZWFyX3JlcXVlc3RzKCklMEElMEElMjMlMjBMb2FkJTIwdGV4dHVhbCUyMGludmVyc2lvbiUyMGludG8lMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQXBpcGVsaW5lLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIlMkMlMjAlMjIlM0NjYXQtdG95JTNFJTIyKSUwQSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBcGlwZWxpbmUuY29tcGlsZSgpJTBBaW1hZ2UyJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UyLnNhdmUoJTIyc3RhYmxlX2RpZmZ1c2lvbl92MV81X3dpdGhfdGV4dHVhbF9pbnZlcnNpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-comment"># Reset stable diffusion pipeline</span>
pipeline.clear_requests()

<span class="hljs-comment"># Load textual inversion into stable diffusion pipeline</span>
pipeline.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>, <span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span>)

<span class="hljs-comment"># Compile the model before the first inference</span>
pipeline.<span class="hljs-built_in">compile</span>()
image2 = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image2.save(<span class="hljs-string">&quot;stable_diffusion_v1_5_with_textual_inversion.png&quot;</span>)`,wrap:!1}}),Q=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),N=new M({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5pbnRlbCUyMGltcG9ydCUyME9WU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDc2OCUyQyUyMDUxMikpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjc1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>
image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),F=new h({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),z=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),E=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQWJhc2UlMjAlM0QlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb21wdCUyMCUzRCUyMCUyMnRyYWluJTIwc3RhdGlvbiUyMGJ5JTIwQ2FzcGFyJTIwRGF2aWQlMjBGcmllZHJpY2glMjIlMEFpbWFnZSUyMCUzRCUyMGJhc2UocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJ0cmFpbl9zdGF0aW9uLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
base = OVStableDiffusionXLPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;train station by Caspar David Friedrich&quot;</span>
image = base(prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;train_station.png&quot;</span>)`,wrap:!1}}),q=new h({props:{title:"Text-to-Image with Textual Inversion",local:"text-to-image-with-textual-inversion",headingTag:"h3"}}),O=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMHdlYXJpbmclMjBhJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYmxhY2slMjBzaGlydCUyQyUyMGJlc3QlMjBxdWFsaXR5JTJDJTIwaW50cmljYXRlJTIwZGV0YWlscy4lMjIlMEElMjMlMjBTZXQlMjBhJTIwcmFuZG9tJTIwc2VlZCUyMGZvciUyMGJldHRlciUyMGNvbXBhcmlzb24lMEFucC5yYW5kb20uc2VlZCgxMTIpJTBBJTBBYmFzZSUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RGYWxzZSUyQyUyMGNvbXBpbGUlM0RGYWxzZSklMEFiYXNlLmNvbXBpbGUoKSUwQWltYWdlMSUyMCUzRCUyMGJhc2UocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UxLnNhdmUoJTIyc2R4bF93aXRob3V0X3RleHR1YWxfaW52ZXJzaW9uLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround wearing a red jacket and black shirt, best quality, intricate details.&quot;</span>
<span class="hljs-comment"># Set a random seed for better comparison</span>
np.random.seed(<span class="hljs-number">112</span>)

base = OVStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">False</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
base.<span class="hljs-built_in">compile</span>()
image1 = base(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image1.save(<span class="hljs-string">&quot;sdxl_without_textual_inversion.png&quot;</span>)`,wrap:!1}}),K=new M({props:{code:"JTIzJTIwUmVzZXQlMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQWJhc2UuY2xlYXJfcmVxdWVzdHMoKSUwQSUwQSUyMyUyMExvYWQlMjB0ZXh0dWFsJTIwaW52ZXJzaW9uJTIwaW50byUyMHN0YWJsZSUyMGRpZmZ1c2lvbiUyMHBpcGVsaW5lJTBBYmFzZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMi4lMkZjaGFydHVybmVydjIucHQlMjIlMkMlMjAlMjJjaGFydHVybmVydjIlMjIpJTBBJTBBJTIzJTIwQ29tcGlsZSUyMHRoZSUyMG1vZGVsJTIwYmVmb3JlJTIwdGhlJTIwZmlyc3QlMjBpbmZlcmVuY2UlMEFiYXNlLmNvbXBpbGUoKSUwQWltYWdlMiUyMCUzRCUyMGJhc2UocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UyLnNhdmUoJTIyc2R4bF93aXRoX3RleHR1YWxfaW52ZXJzaW9uLnBuZyUyMik=",highlighted:`<span class="hljs-comment"># Reset stable diffusion pipeline</span>
base.clear_requests()

<span class="hljs-comment"># Load textual inversion into stable diffusion pipeline</span>
base.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, <span class="hljs-string">&quot;charturnerv2&quot;</span>)

<span class="hljs-comment"># Compile the model before the first inference</span>
base.<span class="hljs-built_in">compile</span>()
image2 = base(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image2.save(<span class="hljs-string">&quot;sdxl_with_textual_inversion.png&quot;</span>)`,wrap:!1}}),ee=new h({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),le=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRm9wdGltdW0lMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGaW50ZWwlMkZvcGVudmlubyUyRnNkX3hsJTJGY2FzdGxlX2ZyaWVkcmljaC5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJtZWRpZXZhbCUyMGNhc3RsZSUyMGJ5JTIwQ2FzcGFyJTIwRGF2aWQlMjBGcmllZHJpY2glMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEElMjMlMjBEb24ndCUyMGZvcmdldCUyMHRvJTIwc2F2ZSUyMHlvdXIlMjBPcGVuVklOTyUyMG1vZGVsJTIwc28lMjB0aGF0JTIweW91JTIwY2FuJTIwbG9hZCUyMGl0JTIwd2l0aG91dCUyMGV4cG9ydGluZyUyMGl0JTIwd2l0aCUyMCU2MGV4cG9ydCUzRFRydWUlNjAlMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyb3BlbnZpbm8tc2QteGwtcmVmaW5lci0xLjAlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
pipeline = OVStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;medieval castle by Caspar David Friedrich&quot;</span>
image = pipeline(prompt, image=image).images[<span class="hljs-number">0</span>]
<span class="hljs-comment"># Don&#x27;t forget to save your OpenVINO model so that you can load it without exporting it with \`export=True\`</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-xl-refiner-1.0&quot;</span>)`,wrap:!1}}),se=new h({props:{title:"Refining the image output",local:"refining-the-image-output",headingTag:"h3"}}),ae=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMEFyZWZpbmVyJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwYmFzZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
refiner = OVStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ie=new h({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),me=new h({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),re=new M({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyU2ltaWFuTHVvJTJGTENNX0RyZWFtc2hhcGVyX3Y3JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBPVkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwTGVvbmFyZG8lMjBkYSUyMFZpbmNpJTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
pipeline = OVLatentConsistencyModelPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
images = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),de=new zt({props:{source:"https://github.com/huggingface/optimum-intel/blob/main/docs/source/openvino/tutorials/diffusers.mdx"}}),{c(){f=i("meta"),be=n(),ue=i("p"),Me=n(),m(w.$$.fragment),he=n(),m(J.$$.fragment),fe=n(),Z=i("p"),Z.textContent=ct,ye=n(),U=i("ul"),U.innerHTML=bt,we=n(),T=i("table"),T.innerHTML=Mt,Je=n(),m(g.$$.fragment),Ze=n(),W=i("p"),W.textContent=ht,Ue=n(),m(j.$$.fragment),Te=n(),G=i("p"),G.innerHTML=ft,ge=n(),m(B.$$.fragment),We=n(),v=i("p"),v.textContent=yt,je=n(),m(V.$$.fragment),Ge=n(),x=i("p"),x.textContent=wt,Be=n(),y=i("div"),y.innerHTML=Jt,ve=n(),m(I.$$.fragment),Ve=n(),$=i("p"),$.textContent=Zt,xe=n(),X=i("p"),X.textContent=Ut,Ie=n(),m(C.$$.fragment),$e=n(),_=i("p"),_.innerHTML=Tt,Xe=n(),m(R.$$.fragment),Ce=n(),S=i("p"),S.textContent=gt,_e=n(),k=i("table"),k.innerHTML=Wt,Re=n(),m(Q.$$.fragment),Se=n(),m(N.$$.fragment),ke=n(),m(F.$$.fragment),Qe=n(),Y=i("table"),Y.innerHTML=jt,Ne=n(),m(z.$$.fragment),Fe=n(),H=i("p"),H.innerHTML=Gt,Ye=n(),m(E.$$.fragment),ze=n(),L=i("table"),L.innerHTML=Bt,He=n(),m(q.$$.fragment),Ee=n(),D=i("p"),D.innerHTML=vt,Le=n(),P=i("p"),P.textContent=Vt,qe=n(),m(O.$$.fragment),De=n(),A=i("p"),A.innerHTML=xt,Pe=n(),m(K.$$.fragment),Oe=n(),m(ee.$$.fragment),Ae=n(),te=i("p"),te.innerHTML=It,Ke=n(),m(le.$$.fragment),et=n(),m(se.$$.fragment),tt=n(),ne=i("p"),ne.innerHTML=$t,lt=n(),m(ae.$$.fragment),st=n(),m(ie.$$.fragment),nt=n(),pe=i("table"),pe.innerHTML=Xt,at=n(),m(me.$$.fragment),it=n(),oe=i("p"),oe.innerHTML=Ct,pt=n(),m(re.$$.fragment),mt=n(),m(de.$$.fragment),ot=n(),ce=i("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),be=a(e),ue=p(e,"P",{}),_t(ue).forEach(l),Me=a(e),o(w.$$.fragment,e),he=a(e),o(J.$$.fragment,e),fe=a(e),Z=p(e,"P",{"data-svelte-h":!0}),b(Z)!=="svelte-1isd6gx"&&(Z.textContent=ct),ye=a(e),U=p(e,"UL",{"data-svelte-h":!0}),b(U)!=="svelte-bu3ryq"&&(U.innerHTML=bt),we=a(e),T=p(e,"TABLE",{"data-svelte-h":!0}),b(T)!=="svelte-9sg8v5"&&(T.innerHTML=Mt),Je=a(e),o(g.$$.fragment,e),Ze=a(e),W=p(e,"P",{"data-svelte-h":!0}),b(W)!=="svelte-t90xds"&&(W.textContent=ht),Ue=a(e),o(j.$$.fragment,e),Te=a(e),G=p(e,"P",{"data-svelte-h":!0}),b(G)!=="svelte-1870w60"&&(G.innerHTML=ft),ge=a(e),o(B.$$.fragment,e),We=a(e),v=p(e,"P",{"data-svelte-h":!0}),b(v)!=="svelte-f1ib2z"&&(v.textContent=yt),je=a(e),o(V.$$.fragment,e),Ge=a(e),x=p(e,"P",{"data-svelte-h":!0}),b(x)!=="svelte-k76x21"&&(x.textContent=wt),Be=a(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),b(y)!=="svelte-1bbei4i"&&(y.innerHTML=Jt),ve=a(e),o(I.$$.fragment,e),Ve=a(e),$=p(e,"P",{"data-svelte-h":!0}),b($)!=="svelte-gj1zll"&&($.textContent=Zt),xe=a(e),X=p(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-1ephhdh"&&(X.textContent=Ut),Ie=a(e),o(C.$$.fragment,e),$e=a(e),_=p(e,"P",{"data-svelte-h":!0}),b(_)!=="svelte-j9a9m8"&&(_.innerHTML=Tt),Xe=a(e),o(R.$$.fragment,e),Ce=a(e),S=p(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-1ohkhi8"&&(S.textContent=gt),_e=a(e),k=p(e,"TABLE",{"data-svelte-h":!0}),b(k)!=="svelte-1sy4xw8"&&(k.innerHTML=Wt),Re=a(e),o(Q.$$.fragment,e),Se=a(e),o(N.$$.fragment,e),ke=a(e),o(F.$$.fragment,e),Qe=a(e),Y=p(e,"TABLE",{"data-svelte-h":!0}),b(Y)!=="svelte-o49bnr"&&(Y.innerHTML=jt),Ne=a(e),o(z.$$.fragment,e),Fe=a(e),H=p(e,"P",{"data-svelte-h":!0}),b(H)!=="svelte-1kedcjk"&&(H.innerHTML=Gt),Ye=a(e),o(E.$$.fragment,e),ze=a(e),L=p(e,"TABLE",{"data-svelte-h":!0}),b(L)!=="svelte-35z5uj"&&(L.innerHTML=Bt),He=a(e),o(q.$$.fragment,e),Ee=a(e),D=p(e,"P",{"data-svelte-h":!0}),b(D)!=="svelte-1rl3w3v"&&(D.innerHTML=vt),Le=a(e),P=p(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-1ephhdh"&&(P.textContent=Vt),qe=a(e),o(O.$$.fragment,e),De=a(e),A=p(e,"P",{"data-svelte-h":!0}),b(A)!=="svelte-197o8c3"&&(A.innerHTML=xt),Pe=a(e),o(K.$$.fragment,e),Oe=a(e),o(ee.$$.fragment,e),Ae=a(e),te=p(e,"P",{"data-svelte-h":!0}),b(te)!=="svelte-1g03pef"&&(te.innerHTML=It),Ke=a(e),o(le.$$.fragment,e),et=a(e),o(se.$$.fragment,e),tt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-1lzmdpv"&&(ne.innerHTML=$t),lt=a(e),o(ae.$$.fragment,e),st=a(e),o(ie.$$.fragment,e),nt=a(e),pe=p(e,"TABLE",{"data-svelte-h":!0}),b(pe)!=="svelte-veyn1t"&&(pe.innerHTML=Xt),at=a(e),o(me.$$.fragment,e),it=a(e),oe=p(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-5xcutu"&&(oe.innerHTML=Ct),pt=a(e),o(re.$$.fragment,e),mt=a(e),o(de.$$.fragment,e),ot=a(e),ce=p(e,"P",{}),_t(ce).forEach(l),this.h()},h(){dt(f,"name","hf:doc:metadata"),dt(f,"content",Et),dt(y,"class","flex justify-center")},m(e,t){Yt(document.head,f),s(e,be,t),s(e,ue,t),s(e,Me,t),r(w,e,t),s(e,he,t),r(J,e,t),s(e,fe,t),s(e,Z,t),s(e,ye,t),s(e,U,t),s(e,we,t),s(e,T,t),s(e,Je,t),r(g,e,t),s(e,Ze,t),s(e,W,t),s(e,Ue,t),r(j,e,t),s(e,Te,t),s(e,G,t),s(e,ge,t),r(B,e,t),s(e,We,t),s(e,v,t),s(e,je,t),r(V,e,t),s(e,Ge,t),s(e,x,t),s(e,Be,t),s(e,y,t),s(e,ve,t),r(I,e,t),s(e,Ve,t),s(e,$,t),s(e,xe,t),s(e,X,t),s(e,Ie,t),r(C,e,t),s(e,$e,t),s(e,_,t),s(e,Xe,t),r(R,e,t),s(e,Ce,t),s(e,S,t),s(e,_e,t),s(e,k,t),s(e,Re,t),r(Q,e,t),s(e,Se,t),r(N,e,t),s(e,ke,t),r(F,e,t),s(e,Qe,t),s(e,Y,t),s(e,Ne,t),r(z,e,t),s(e,Fe,t),s(e,H,t),s(e,Ye,t),r(E,e,t),s(e,ze,t),s(e,L,t),s(e,He,t),r(q,e,t),s(e,Ee,t),s(e,D,t),s(e,Le,t),s(e,P,t),s(e,qe,t),r(O,e,t),s(e,De,t),s(e,A,t),s(e,Pe,t),r(K,e,t),s(e,Oe,t),r(ee,e,t),s(e,Ae,t),s(e,te,t),s(e,Ke,t),r(le,e,t),s(e,et,t),r(se,e,t),s(e,tt,t),s(e,ne,t),s(e,lt,t),r(ae,e,t),s(e,st,t),r(ie,e,t),s(e,nt,t),s(e,pe,t),s(e,at,t),r(me,e,t),s(e,it,t),s(e,oe,t),s(e,pt,t),r(re,e,t),s(e,mt,t),r(de,e,t),s(e,ot,t),s(e,ce,t),rt=!0},p:St,i(e){rt||(d(w.$$.fragment,e),d(J.$$.fragment,e),d(g.$$.fragment,e),d(j.$$.fragment,e),d(B.$$.fragment,e),d(V.$$.fragment,e),d(I.$$.fragment,e),d(C.$$.fragment,e),d(R.$$.fragment,e),d(Q.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(me.$$.fragment,e),d(re.$$.fragment,e),d(de.$$.fragment,e),rt=!0)},o(e){u(w.$$.fragment,e),u(J.$$.fragment,e),u(g.$$.fragment,e),u(j.$$.fragment,e),u(B.$$.fragment,e),u(V.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(z.$$.fragment,e),u(E.$$.fragment,e),u(q.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),rt=!1},d(e){e&&(l(be),l(ue),l(Me),l(he),l(fe),l(Z),l(ye),l(U),l(we),l(T),l(Je),l(Ze),l(W),l(Ue),l(Te),l(G),l(ge),l(We),l(v),l(je),l(Ge),l(x),l(Be),l(y),l(ve),l(Ve),l($),l(xe),l(X),l(Ie),l($e),l(_),l(Xe),l(Ce),l(S),l(_e),l(k),l(Re),l(Se),l(ke),l(Qe),l(Y),l(Ne),l(Fe),l(H),l(Ye),l(ze),l(L),l(He),l(Ee),l(D),l(Le),l(P),l(qe),l(De),l(A),l(Pe),l(Oe),l(Ae),l(te),l(Ke),l(et),l(tt),l(ne),l(lt),l(st),l(nt),l(pe),l(at),l(it),l(oe),l(pt),l(mt),l(ot),l(ce)),l(f),c(w,e),c(J,e),c(g,e),c(j,e),c(B,e),c(V,e),c(I,e),c(C,e),c(R,e),c(Q,e),c(N,e),c(F,e),c(z,e),c(E,e),c(q,e),c(O,e),c(K,e),c(ee,e),c(le,e),c(se,e),c(ae,e),c(ie,e),c(me,e),c(re,e),c(de,e)}}}const Et='{"title":"Generate images with Diffusion models","local":"generate-images-with-diffusion-models","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Text-to-Image with Textual Inversion","local":"text-to-image-with-textual-inversion","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Text-to-Image with Textual Inversion","local":"text-to-image-with-textual-inversion","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Refining the image output","local":"refining-the-image-output","sections":[],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function Lt(ut){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Qt{constructor(f){super(),Nt(this,f,Lt,Ht,Rt,{})}}export{At as component};
