import{s as _e,n as Pe,o as ke}from"../chunks/scheduler.412302f6.js";import{S as be,i as Be,g as a,s as n,r as m,A as Re,h as p,f as l,c as s,j as Ce,u as r,x as h,k as Ie,y as Le,a as i,v as o,d as u,t as f,w as $}from"../chunks/index.f36f02f5.js";import{C as he}from"../chunks/CodeBlock.f4a4ce81.js";import{H as c}from"../chunks/Heading.41d80af4.js";function Se(Te){let T,E,Z,X,U,Q,w,ce="This guide explains how to run Optimum-TPU within a Docker container using the official PyTorch/XLA image.",A,g,F,M,Ue="Before starting, ensure you have:",W,d,we="<li>Docker installed on your system</li> <li>Access to a TPU instance</li> <li>Sufficient permissions to run privileged containers</li>",Y,y,O,J,z,x,ge="First, set the environment variables for the image URL and version:",D,v,q,V,K,C,Me="Launch the container with the necessary flags for TPU access:",ee,I,te,_,de="<code>--shm-size 16GB --privileged --net=host</code> is required for docker to access the TPU",le,P,ie,k,ye="Once inside the container, install Optimum-TPU:",ne,b,se,B,ae,R,Je="To verify your setup, run this simple test:",pe,L,me,S,xe="You should see output indicating the XLA device is available (e.g., <code>xla:0</code>).",re,j,oe,G,ve="After setting up your container, you can:",ue,H,Ve='<li>Start training models using Optimum-TPU. Refer to our <a href="../howto/more_examples">training example section</a>.</li> <li>Run inference workloads. Check out our <a href="../howto/serving">serving guide</a>.</li>',fe,N,$e;return U=new c({props:{title:"Installing Optimum-TPU inside a Docker Container",local:"installing-optimum-tpu-inside-a-docker-container",headingTag:"h1"}}),g=new c({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),y=new c({props:{title:"Using the PyTorch/XLA Base Image",local:"using-the-pytorchxla-base-image",headingTag:"h2"}}),J=new c({props:{title:"1. Pull the Docker Image",local:"1-pull-the-docker-image",headingTag:"h3"}}),v=new he({props:{code:"ZXhwb3J0JTIwVFBVVk1fSU1BR0VfVVJMJTNEdXMtY2VudHJhbDEtZG9ja2VyLnBrZy5kZXYlMkZ0cHUtcHl0b3JjaC1yZWxlYXNlcyUyRmRvY2tlciUyRnhsYSUwQWV4cG9ydCUyMFRQVVZNX0lNQUdFX1ZFUlNJT04lM0RyMi41LjBfMy4xMF90cHV2bSUwQSUwQSUyMyUyMFB1bGwlMjB0aGUlMjBpbWFnZSUwQWRvY2tlciUyMHB1bGwlMjAlMjQlN0JUUFVWTV9JTUFHRV9VUkwlN0QlM0ElMjQlN0JUUFVWTV9JTUFHRV9WRVJTSU9OJTdE",highlighted:`<span class="hljs-built_in">export</span> TPUVM_IMAGE_URL=us-central1-docker.pkg.dev/tpu-pytorch-releases/docker/xla
<span class="hljs-built_in">export</span> TPUVM_IMAGE_VERSION=r2.5.0_3.10_tpuvm

<span class="hljs-comment"># Pull the image</span>
docker pull <span class="hljs-variable">\${TPUVM_IMAGE_URL}</span>:<span class="hljs-variable">\${TPUVM_IMAGE_VERSION}</span>`,wrap:!1}}),V=new c({props:{title:"2. Run the Container",local:"2-run-the-container",headingTag:"h3"}}),I=new he({props:{code:"ZG9ja2VyJTIwcnVuJTIwLXRpJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ybSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2htLXNpemUlMjAxNkdCJTBBJTIwJTIwJTIwJTIwLS1wcml2aWxlZ2VkJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1uZXQlM0Rob3N0JTIwJTVDJTBBJTIwJTIwJTIwJTIwJTI0JTdCVFBVVk1fSU1BR0VfVVJMJTdEJTQwc2hhMjU2JTNBJTI0JTdCVFBVVk1fSU1BR0VfVkVSU0lPTiU3RCUyMCU1QyUwQSUyMCUyMCUyMCUyMGJhc2g=",highlighted:`docker run -ti \\
    --<span class="hljs-built_in">rm</span> \\
    --shm-size 16GB
    --privileged \\
    --net=host \\
    <span class="hljs-variable">\${TPUVM_IMAGE_URL}</span>@sha256:<span class="hljs-variable">\${TPUVM_IMAGE_VERSION}</span> \\
    bash`,wrap:!1}}),P=new c({props:{title:"3. Install Optimum-TPU",local:"3-install-optimum-tpu",headingTag:"h3"}}),b=new he({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wdGltdW0tdHB1JTIwLWYlMjBodHRwcyUzQSUyRiUyRnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20lMkZsaWJ0cHUtcmVsZWFzZXMlMkZpbmRleC5odG1s",highlighted:"pip install optimum-tpu -f https://storage.googleapis.com/libtpu-releases/index.html",wrap:!1}}),B=new c({props:{title:"Verification",local:"verification",headingTag:"h2"}}),L=new he({props:{code:"cHl0aG9uMyUyMC1jJTIwJTIyaW1wb3J0JTIwdG9yY2hfeGxhLmNvcmUueGxhX21vZGVsJTIwYXMlMjB4bSUzQiUyMHByaW50KHhtLnhsYV9kZXZpY2UoKSklMjI=",highlighted:'python3 -c <span class="hljs-string">&quot;import torch_xla.core.xla_model as xm; print(xm.xla_device())&quot;</span>',wrap:!1}}),j=new c({props:{title:"Next Steps",local:"next-steps",headingTag:"h2"}}),{c(){T=a("meta"),E=n(),Z=a("p"),X=n(),m(U.$$.fragment),Q=n(),w=a("p"),w.textContent=ce,A=n(),m(g.$$.fragment),F=n(),M=a("p"),M.textContent=Ue,W=n(),d=a("ul"),d.innerHTML=we,Y=n(),m(y.$$.fragment),O=n(),m(J.$$.fragment),z=n(),x=a("p"),x.textContent=ge,D=n(),m(v.$$.fragment),q=n(),m(V.$$.fragment),K=n(),C=a("p"),C.textContent=Me,ee=n(),m(I.$$.fragment),te=n(),_=a("p"),_.innerHTML=de,le=n(),m(P.$$.fragment),ie=n(),k=a("p"),k.textContent=ye,ne=n(),m(b.$$.fragment),se=n(),m(B.$$.fragment),ae=n(),R=a("p"),R.textContent=Je,pe=n(),m(L.$$.fragment),me=n(),S=a("p"),S.innerHTML=xe,re=n(),m(j.$$.fragment),oe=n(),G=a("p"),G.textContent=ve,ue=n(),H=a("ul"),H.innerHTML=Ve,fe=n(),N=a("p"),this.h()},l(e){const t=Re("svelte-u9bgzb",document.head);T=p(t,"META",{name:!0,content:!0}),t.forEach(l),E=s(e),Z=p(e,"P",{}),Ce(Z).forEach(l),X=s(e),r(U.$$.fragment,e),Q=s(e),w=p(e,"P",{"data-svelte-h":!0}),h(w)!=="svelte-1c390p2"&&(w.textContent=ce),A=s(e),r(g.$$.fragment,e),F=s(e),M=p(e,"P",{"data-svelte-h":!0}),h(M)!=="svelte-1j691zg"&&(M.textContent=Ue),W=s(e),d=p(e,"UL",{"data-svelte-h":!0}),h(d)!=="svelte-7n99gn"&&(d.innerHTML=we),Y=s(e),r(y.$$.fragment,e),O=s(e),r(J.$$.fragment,e),z=s(e),x=p(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-s1mni2"&&(x.textContent=ge),D=s(e),r(v.$$.fragment,e),q=s(e),r(V.$$.fragment,e),K=s(e),C=p(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-x3xfgy"&&(C.textContent=Me),ee=s(e),r(I.$$.fragment,e),te=s(e),_=p(e,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1yqndd9"&&(_.innerHTML=de),le=s(e),r(P.$$.fragment,e),ie=s(e),k=p(e,"P",{"data-svelte-h":!0}),h(k)!=="svelte-9homax"&&(k.textContent=ye),ne=s(e),r(b.$$.fragment,e),se=s(e),r(B.$$.fragment,e),ae=s(e),R=p(e,"P",{"data-svelte-h":!0}),h(R)!=="svelte-tydhel"&&(R.textContent=Je),pe=s(e),r(L.$$.fragment,e),me=s(e),S=p(e,"P",{"data-svelte-h":!0}),h(S)!=="svelte-16319zy"&&(S.innerHTML=xe),re=s(e),r(j.$$.fragment,e),oe=s(e),G=p(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-1mzbnlo"&&(G.textContent=ve),ue=s(e),H=p(e,"UL",{"data-svelte-h":!0}),h(H)!=="svelte-1obntw4"&&(H.innerHTML=Ve),fe=s(e),N=p(e,"P",{}),Ce(N).forEach(l),this.h()},h(){Ie(T,"name","hf:doc:metadata"),Ie(T,"content",je)},m(e,t){Le(document.head,T),i(e,E,t),i(e,Z,t),i(e,X,t),o(U,e,t),i(e,Q,t),i(e,w,t),i(e,A,t),o(g,e,t),i(e,F,t),i(e,M,t),i(e,W,t),i(e,d,t),i(e,Y,t),o(y,e,t),i(e,O,t),o(J,e,t),i(e,z,t),i(e,x,t),i(e,D,t),o(v,e,t),i(e,q,t),o(V,e,t),i(e,K,t),i(e,C,t),i(e,ee,t),o(I,e,t),i(e,te,t),i(e,_,t),i(e,le,t),o(P,e,t),i(e,ie,t),i(e,k,t),i(e,ne,t),o(b,e,t),i(e,se,t),o(B,e,t),i(e,ae,t),i(e,R,t),i(e,pe,t),o(L,e,t),i(e,me,t),i(e,S,t),i(e,re,t),o(j,e,t),i(e,oe,t),i(e,G,t),i(e,ue,t),i(e,H,t),i(e,fe,t),i(e,N,t),$e=!0},p:Pe,i(e){$e||(u(U.$$.fragment,e),u(g.$$.fragment,e),u(y.$$.fragment,e),u(J.$$.fragment,e),u(v.$$.fragment,e),u(V.$$.fragment,e),u(I.$$.fragment,e),u(P.$$.fragment,e),u(b.$$.fragment,e),u(B.$$.fragment,e),u(L.$$.fragment,e),u(j.$$.fragment,e),$e=!0)},o(e){f(U.$$.fragment,e),f(g.$$.fragment,e),f(y.$$.fragment,e),f(J.$$.fragment,e),f(v.$$.fragment,e),f(V.$$.fragment,e),f(I.$$.fragment,e),f(P.$$.fragment,e),f(b.$$.fragment,e),f(B.$$.fragment,e),f(L.$$.fragment,e),f(j.$$.fragment,e),$e=!1},d(e){e&&(l(E),l(Z),l(X),l(Q),l(w),l(A),l(F),l(M),l(W),l(d),l(Y),l(O),l(z),l(x),l(D),l(q),l(K),l(C),l(ee),l(te),l(_),l(le),l(ie),l(k),l(ne),l(se),l(ae),l(R),l(pe),l(me),l(S),l(re),l(oe),l(G),l(ue),l(H),l(fe),l(N)),l(T),$(U,e),$(g,e),$(y,e),$(J,e),$(v,e),$(V,e),$(I,e),$(P,e),$(b,e),$(B,e),$(L,e),$(j,e)}}}const je='{"title":"Installing Optimum-TPU inside a Docker Container","local":"installing-optimum-tpu-inside-a-docker-container","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Using the PyTorch/XLA Base Image","local":"using-the-pytorchxla-base-image","sections":[{"title":"1. Pull the Docker Image","local":"1-pull-the-docker-image","sections":[],"depth":3},{"title":"2. Run the Container","local":"2-run-the-container","sections":[],"depth":3},{"title":"3. Install Optimum-TPU","local":"3-install-optimum-tpu","sections":[],"depth":3}],"depth":2},{"title":"Verification","local":"verification","sections":[],"depth":2},{"title":"Next Steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function Ge(Te){return ke(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends be{constructor(T){super(),Be(this,T,Ge,Se,_e,{})}}export{Xe as component};
