import{s as Ct,n as Xt,o as It}from"../chunks/scheduler.6062bdaf.js";import{S as Rt,i as vt,g as i,s as a,r,A as $t,h as o,f as l,c as s,j as Wt,u as m,x as p,k as Bt,y as xt,a as n,v as c,d,t as M,w as u}from"../chunks/index.4bca734e.js";import{C as h}from"../chunks/CodeBlock.fa01571c.js";import{H as f,E as kt}from"../chunks/EditOnGithub.74ab2baa.js";function Vt(nt){let y,pe,re,ce,b,de,T,at="This quick tour is intended for developers who are ready to dive into the code and see examples of how to integrate 🤗 Optimum into their model training and inference workflows.",Me,U,ue,g,fe,J,st=`To load a model and run inference with OpenVINO Runtime, you can just replace your <code>AutoModelForXxx</code> class with the corresponding <code>OVModelForXxx</code> class.
If you want to load a PyTorch checkpoint, set <code>export=True</code> to convert your model to the OpenVINO IR (Intermediate Representation).`,he,w,ye,j,it='You can find more examples in the <a href="https://huggingface.co/docs/optimum/intel/inference" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-intel/tree/main/examples/openvino" rel="nofollow">examples</a>.',be,Z,Te,W,ot=`You can load your model and apply IPEX optimizations (including weight prepacking and graph mode). For supported architectures like LLaMA, BERT and ViT, further optimizations will be applied by patching the model to use custom operators.
For now, support is only enabled for CPUs and the original model will be exported via TorchScript. In the future <code>torch.compile</code> will be used and model exported via TorchScript will get deprecated.`,Ue,B,ge,C,rt='You can find more examples in the <a href="https://huggingface.co/docs/optimum/main/intel/ipex/inference" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-intel/tree/main/notebooks/ipex" rel="nofollow">examples</a>.',Je,X,we,I,mt="To accelerate inference with ONNX Runtime, 🤗 Optimum uses <em>configuration objects</em> to define parameters for graph optimization and quantization. These objects are then used to instantiate dedicated <em>optimizers</em> and <em>quantizers</em>.",je,R,pt='Before applying quantization or optimization, first we need to load our model. To load a model and run inference with ONNX Runtime, you can just replace the canonical Transformers <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoModel" rel="nofollow"><code>AutoModelForXxx</code></a> class with the corresponding <a href="https://huggingface.co/docs/optimum/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel" rel="nofollow"><code>ORTModelForXxx</code></a> class. If you want to load from a PyTorch checkpoint, set <code>export=True</code> to export your model to the ONNX format.',Ze,v,We,$,ct="Let’s see now how we can apply dynamic quantization with ONNX Runtime:",Be,x,Ce,k,dt="In this example, we’ve quantized a model from the Hugging Face Hub, in the same manner we can quantize a model hosted locally by providing the path to the directory containing the model weights. The result from applying the <code>quantize()</code> method is a <code>model_quantized.onnx</code> file that can be used to run inference. Here’s an example of how to load an ONNX Runtime model and generate predictions with it:",Xe,V,Ie,G,Mt='You can find more examples in the <a href="https://huggingface.co/docs/optimum/onnxruntime/quickstart" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum/tree/main/examples/onnxruntime" rel="nofollow">examples</a>.',Re,H,ve,Q,$e,N,ut='To train transformers on Habana’s Gaudi processors, 🤗 Optimum provides a <code>GaudiTrainer</code> that is very similar to the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a>. Here is a simple example:',xe,F,ke,E,ft='You can find more examples in the <a href="https://huggingface.co/docs/optimum/habana/quickstart" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum-habana/tree/main/examples" rel="nofollow">examples</a>.',Ve,z,Ge,_,ht='To train transformers with ONNX Runtime’s acceleration features, 🤗 Optimum provides a <code>ORTTrainer</code> that is very similar to the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow">Trainer</a>. Here is a simple example:',He,Y,Qe,S,yt='You can find more examples in the <a href="https://huggingface.co/docs/optimum/onnxruntime/usage_guides/trainer" rel="nofollow">documentation</a> and in the <a href="https://github.com/huggingface/optimum/tree/main/examples/onnxruntime/training" rel="nofollow">examples</a>.',Ne,q,Fe,A,bt="The Optimum library handles out of the box the ONNX export of Transformers and Diffusers models!",Ee,L,Tt="Exporting a model to ONNX is as simple as",ze,O,_e,P,Ut="Check out the help for more options:",Ye,D,Se,K,gt='Check out the <a href="https://huggingface.co/docs/optimum/exporters/onnx/usage_guides/export_a_model" rel="nofollow">documentation</a> for more.',qe,ee,Ae,te,Jt='<a href="https://pytorch.org/blog/a-better-transformer-for-fast-transformer-encoder-inference/" rel="nofollow">BetterTransformer</a> is a free-lunch PyTorch-native optimization to gain x1.25 - x4 speedup on the inference of Transformer-based models. It has been marked as stable in <a href="https://pytorch.org/blog/PyTorch-1.13-release/" rel="nofollow">PyTorch 1.13</a>. We integrated BetterTransformer with the most-used models from the 🤗 Transformers libary, and using the integration is as simple as:',Le,le,Oe,ne,wt='Check out the <a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">documentation</a> for more details, and the <a href="https://medium.com/pytorch/bettertransformer-out-of-the-box-performance-for-huggingface-transformers-3fbe27d50ab2" rel="nofollow">blog post on PyTorch’s Medium</a> to find out more about the integration!',Pe,ae,De,se,jt='Optimum integrates with <code>torch.fx</code>, providing as a one-liner several graph transformations. We aim at supporting a better management of <a href="https://huggingface.co/docs/optimum/concept_guides/quantization" rel="nofollow">quantization</a> through <code>torch.fx</code>, both for quantization-aware training (QAT) and post-training quantization (PTQ).',Ke,ie,Zt='Check out the <a href="https://huggingface.co/docs/optimum/torch_fx/usage_guides/optimization" rel="nofollow">documentation</a> and <a href="https://huggingface.co/docs/optimum/torch_fx/package_reference/optimization" rel="nofollow">reference</a> for more!',et,oe,tt,me,lt;return b=new f({props:{title:"Quick tour",local:"quick-tour",headingTag:"h1"}}),U=new f({props:{title:"Accelerated inference",local:"accelerated-inference",headingTag:"h2"}}),g=new f({props:{title:"OpenVINO",local:"openvino",headingTag:"h4"}}),w=new h({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTJCJTIwZnJvbSUyMG9wdGltdW0uaW50ZWwub3BlbnZpbm8lMjBpbXBvcnQlMjBPVk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUyMCUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwcGlwZWxpbmUlMEElMEElMjAlMjAlMjMlMjBEb3dubG9hZCUyMGElMjB0b2tlbml6ZXIlMjBhbmQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMjBhbmQlMjBjb252ZXJ0JTIwdG8lMjBPcGVuVklOTyUyMGZvcm1hdCUwQSUyMCUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyMCUyMG1vZGVsX2lkJTIwJTNEJTIwJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIlMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMkIlMjBtb2RlbCUyMCUzRCUyME9WTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIwJTIwJTIzJTIwUnVuJTIwaW5mZXJlbmNlISUwQSUyMCUyMGNsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMjAlMjByZXN1bHRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJIZSdzJTIwYSUyMGRyZWFkZnVsJTIwbWFnaWNpYW4uJTIyKQ==",highlighted:`<span class="hljs-deletion">- from transformers import AutoModelForSequenceClassification</span>
<span class="hljs-addition">+ from optimum.intel.openvino import OVModelForSequenceClassification</span>
  from transformers import AutoTokenizer, pipeline

  # Download a tokenizer and model from the Hub and convert to OpenVINO format
  tokenizer = AutoTokenizer.from_pretrained(model_id)
  model_id = &quot;distilbert-base-uncased-finetuned-sst-2-english&quot;
<span class="hljs-deletion">- model = AutoModelForSequenceClassification.from_pretrained(model_id)</span>
<span class="hljs-addition">+ model = OVModelForSequenceClassification.from_pretrained(model_id, export=True)</span>

  # Run inference!
  classifier = pipeline(&quot;text-classification&quot;, model=model, tokenizer=tokenizer)
  results = classifier(&quot;He&#x27;s a dreadful magician.&quot;)`,wrap:!1}}),Z=new f({props:{title:"IPEX",local:"ipex",headingTag:"h4"}}),B=new h({props:{code:"JTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMjAlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMHBpcGVsaW5lJTBBLSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUyQiUyMGZyb20lMjBvcHRpbXVtLmludGVsJTIwaW1wb3J0JTIwSVBFWE1vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjAlMjBtb2RlbF9pZCUyMCUzRCUyMCUyMmdwdDIlMjIlMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwSVBFWE1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTIwJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTIwJTIwcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTIwJTIwcmVzdWx0cyUyMCUzRCUyMHBpcGUoJTIySGUncyUyMGElMjBkcmVhZGZ1bCUyMG1hZ2ljaWFuJTIwYW5kJTIyKQ==",highlighted:`  import torch
  from transformers import AutoTokenizer, pipeline
<span class="hljs-deletion">- from transformers import AutoModelForCausalLM</span>
<span class="hljs-addition">+ from optimum.intel import IPEXModelForCausalLM</span>

  model_id = &quot;gpt2&quot;
<span class="hljs-deletion">- model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16)</span>
<span class="hljs-addition">+ model = IPEXModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, export=True)</span>
  tokenizer = AutoTokenizer.from_pretrained(model_id)
  pipe = pipeline(&quot;text-generation&quot;, model=model, tokenizer=tokenizer)
  results = pipe(&quot;He&#x27;s a dreadful magician and&quot;)`,wrap:!1}}),X=new f({props:{title:"ONNX Runtime",local:"onnx-runtime",headingTag:"h4"}}),v=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsX2NoZWNrcG9pbnQlMjAlM0QlMjAlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiUwQXNhdmVfZGlyZWN0b3J5JTIwJTNEJTIwJTIydG1wJTJGb25ueCUyRiUyMiUwQSUwQSUyMyUyMExvYWQlMjBhJTIwbW9kZWwlMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyME9OTlglMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KSUwQW9ydF9tb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfY2hlY2twb2ludCUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBJTIzJTIwU2F2ZSUyMHRoZSUyME9OTlglMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW9ydF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBdG9rZW5pemVyLnNhdmVfcHJldHJhaW5lZChzYXZlX2RpcmVjdG9yeSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>save_directory = <span class="hljs-string">&quot;tmp/onnx/&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load a model from transformers and export it to ONNX</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model_checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model = ORTModelForSequenceClassification.from_pretrained(model_checkpoint, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the ONNX model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ort_model.save_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.save_pretrained(save_directory)`,wrap:!1}}),x=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUuY29uZmlndXJhdGlvbiUyMGltcG9ydCUyMEF1dG9RdWFudGl6YXRpb25Db25maWclMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFF1YW50aXplciUwQSUwQSUyMyUyMERlZmluZSUyMHRoZSUyMHF1YW50aXphdGlvbiUyMG1ldGhvZG9sb2d5JTBBcWNvbmZpZyUyMCUzRCUyMEF1dG9RdWFudGl6YXRpb25Db25maWcuYXJtNjQoaXNfc3RhdGljJTNERmFsc2UlMkMlMjBwZXJfY2hhbm5lbCUzREZhbHNlKSUwQXF1YW50aXplciUyMCUzRCUyME9SVFF1YW50aXplci5mcm9tX3ByZXRyYWluZWQob3J0X21vZGVsKSUwQSUwQSUyMyUyMEFwcGx5JTIwZHluYW1pYyUyMHF1YW50aXphdGlvbiUyMG9uJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6ZXIucXVhbnRpemUoc2F2ZV9kaXIlM0RzYXZlX2RpcmVjdG9yeSUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxY29uZmlnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime.configuration <span class="hljs-keyword">import</span> AutoQuantizationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTQuantizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Define the quantization methodology</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>qconfig = AutoQuantizationConfig.arm64(is_static=<span class="hljs-literal">False</span>, per_channel=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer = ORTQuantizer.from_pretrained(ort_model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Apply dynamic quantization on the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>quantizer.quantize(save_dir=save_directory, quantization_config=qconfig)`,wrap:!1}}),V=new h({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKHNhdmVfZGlyZWN0b3J5JTJDJTIwZmlsZV9uYW1lJTNEJTIybW9kZWxfcXVhbnRpemVkLm9ubnglMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoc2F2ZV9kaXJlY3RvcnkpJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXJlc3VsdHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkklMjBsb3ZlJTIwYnVycml0b3MhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(save_directory, file_name=<span class="hljs-string">&quot;model_quantized.onnx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(save_directory)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>results = classifier(<span class="hljs-string">&quot;I love burritos!&quot;</span>)`,wrap:!1}}),H=new f({props:{title:"Accelerated training",local:"accelerated-training",headingTag:"h2"}}),Q=new f({props:{title:"Habana",local:"habana",headingTag:"h4"}}),F=new h({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5oYWJhbmElMjBpbXBvcnQlMjBHYXVkaVRyYWluZXIlMkMlMjBHYXVkaVRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTIwJTIwJTIzJTIwRG93bmxvYWQlMjBhJTIwcHJldHJhaW5lZCUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMEh1YiUwQSUyMCUyMG1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yWHh4LmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEElMEElMjAlMjAlMjMlMjBEZWZpbmUlMjB0aGUlMjB0cmFpbmluZyUyMGFyZ3VtZW50cyUwQS0lMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwVHJhaW5pbmdBcmd1bWVudHMoJTBBJTJCJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMEdhdWRpVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnBhdGglMkZ0byUyRnNhdmUlMkZmb2xkZXIlMkYlMjIlMkMlMEElMkIlMjAlMjAlMjAlMjAlMjB1c2VfaGFiYW5hJTNEVHJ1ZSUyQyUwQSUyQiUyMCUyMCUyMCUyMCUyMHVzZV9sYXp5X21vZGUlM0RUcnVlJTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwZ2F1ZGlfY29uZmlnX25hbWUlM0QlMjJIYWJhbmElMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwdHJhaW5lciUwQS0lMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMkIlMjB0cmFpbmVyJTIwJTNEJTIwR2F1ZGlUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwKSUwQSUwQSUyMCUyMCUyMyUyMFVzZSUyMEhhYmFuYSUyMEdhdWRpJTIwcHJvY2Vzc29yJTIwZm9yJTIwdHJhaW5pbmchJTBBJTIwJTIwdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.habana import GaudiTrainer, GaudiTrainingArguments</span>

  # Download a pretrained model from the Hub
  model = AutoModelForXxx.from_pretrained(&quot;bert-base-uncased&quot;)

  # Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = GaudiTrainingArguments(</span>
      output_dir=&quot;path/to/save/folder/&quot;,
<span class="hljs-addition">+     use_habana=True,</span>
<span class="hljs-addition">+     use_lazy_mode=True,</span>
<span class="hljs-addition">+     gaudi_config_name=&quot;Habana/bert-base-uncased&quot;,</span>
      ...
  )

  # Initialize the trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = GaudiTrainer(</span>
      model=model,
      args=training_args,
      train_dataset=train_dataset,
      ...
  )

  # Use Habana Gaudi processor for training!
  trainer.train()`,wrap:!1}}),z=new f({props:{title:"ONNX Runtime",local:"onnx-runtime",headingTag:"h4"}}),Y=new h({props:{code:"LSUyMGZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBUcmFpbmVyJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMEElMkIlMjBmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVFRyYWluZXIlMkMlMjBPUlRUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQSUyMCUyMCUyMyUyMERvd25sb2FkJTIwYSUyMHByZXRyYWluZWQlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBIdWIlMEElMjAlMjBtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQSUwQSUyMCUyMCUyMyUyMERlZmluZSUyMHRoZSUyMHRyYWluaW5nJTIwYXJndW1lbnRzJTBBLSUyMHRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMkIlMjB0cmFpbmluZ19hcmdzJTIwJTNEJTIwT1JUVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnBhdGglMkZ0byUyRnNhdmUlMkZmb2xkZXIlMkYlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBvcHRpbSUzRCUyMmFkYW13X29ydF9mdXNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBDcmVhdGUlMjBhJTIwT05OWCUyMFJ1bnRpbWUlMjBUcmFpbmVyJTBBLSUyMHRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyQiUyMHRyYWluZXIlMjAlM0QlMjBPUlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTJCJTIwJTIwJTIwJTIwJTIwZmVhdHVyZSUzRCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjAlMjMlMjBUaGUlMjBtb2RlbCUyMHR5cGUlMjB0byUyMGV4cG9ydCUyMHRvJTIwT05OWCUwQSUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCklMEElMEElMjAlMjAlMjMlMjBVc2UlMjBPTk5YJTIwUnVudGltZSUyMGZvciUyMHRyYWluaW5nISUwQSUyMCUyMHRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-deletion">- from transformers import Trainer, TrainingArguments</span>
<span class="hljs-addition">+ from optimum.onnxruntime import ORTTrainer, ORTTrainingArguments</span>

  # Download a pretrained model from the Hub
  model = AutoModelForSequenceClassification.from_pretrained(&quot;bert-base-uncased&quot;)

  # Define the training arguments
<span class="hljs-deletion">- training_args = TrainingArguments(</span>
<span class="hljs-addition">+ training_args = ORTTrainingArguments(</span>
      output_dir=&quot;path/to/save/folder/&quot;,
      optim=&quot;adamw_ort_fused&quot;,
      ...
  )

  # Create a ONNX Runtime Trainer
<span class="hljs-deletion">- trainer = Trainer(</span>
<span class="hljs-addition">+ trainer = ORTTrainer(</span>
      model=model,
      args=training_args,
      train_dataset=train_dataset,
<span class="hljs-addition">+     feature=&quot;text-classification&quot;, # The model type to export to ONNX</span>
      ...
  )

  # Use ONNX Runtime for training!
  trainer.train()`,wrap:!1}}),q=new f({props:{title:"Out of the box ONNX export",local:"out-of-the-box-onnx-export",headingTag:"h2"}}),O=new h({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1tb2RlbCUyMGdwdDIlMjBncHQyX29ubnglMkY=",highlighted:'optimum-cli <span class="hljs-built_in">export</span> onnx --model gpt2 gpt2_onnx/',wrap:!1}}),D=new h({props:{code:"b3B0aW11bS1jbGklMjBleHBvcnQlMjBvbm54JTIwLS1oZWxw",highlighted:'optimum-cli <span class="hljs-built_in">export</span> onnx --<span class="hljs-built_in">help</span>',wrap:!1}}),ee=new f({props:{title:"PyTorch’s BetterTransformer support",local:"pytorchs-bettertransformer-support",headingTag:"h2"}}),le=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uYmV0dGVydHJhbnNmb3JtZXIlMjBpbXBvcnQlMjBCZXR0ZXJUcmFuc2Zvcm1lciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtc3N0LTItZW5nbGlzaCUyMiklMEFtb2RlbCUyMCUzRCUyMEJldHRlclRyYW5zZm9ybWVyLnRyYW5zZm9ybShtb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.bettertransformer <span class="hljs-keyword">import</span> BetterTransformer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BetterTransformer.transform(model)`,wrap:!1}}),ae=new f({props:{title:"torch.fx integration",local:"torchfx-integration",headingTag:"h2"}}),oe=new kt({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/quicktour.mdx"}}),{c(){y=i("meta"),pe=a(),re=i("p"),ce=a(),r(b.$$.fragment),de=a(),T=i("p"),T.textContent=at,Me=a(),r(U.$$.fragment),ue=a(),r(g.$$.fragment),fe=a(),J=i("p"),J.innerHTML=st,he=a(),r(w.$$.fragment),ye=a(),j=i("p"),j.innerHTML=it,be=a(),r(Z.$$.fragment),Te=a(),W=i("p"),W.innerHTML=ot,Ue=a(),r(B.$$.fragment),ge=a(),C=i("p"),C.innerHTML=rt,Je=a(),r(X.$$.fragment),we=a(),I=i("p"),I.innerHTML=mt,je=a(),R=i("p"),R.innerHTML=pt,Ze=a(),r(v.$$.fragment),We=a(),$=i("p"),$.textContent=ct,Be=a(),r(x.$$.fragment),Ce=a(),k=i("p"),k.innerHTML=dt,Xe=a(),r(V.$$.fragment),Ie=a(),G=i("p"),G.innerHTML=Mt,Re=a(),r(H.$$.fragment),ve=a(),r(Q.$$.fragment),$e=a(),N=i("p"),N.innerHTML=ut,xe=a(),r(F.$$.fragment),ke=a(),E=i("p"),E.innerHTML=ft,Ve=a(),r(z.$$.fragment),Ge=a(),_=i("p"),_.innerHTML=ht,He=a(),r(Y.$$.fragment),Qe=a(),S=i("p"),S.innerHTML=yt,Ne=a(),r(q.$$.fragment),Fe=a(),A=i("p"),A.textContent=bt,Ee=a(),L=i("p"),L.textContent=Tt,ze=a(),r(O.$$.fragment),_e=a(),P=i("p"),P.textContent=Ut,Ye=a(),r(D.$$.fragment),Se=a(),K=i("p"),K.innerHTML=gt,qe=a(),r(ee.$$.fragment),Ae=a(),te=i("p"),te.innerHTML=Jt,Le=a(),r(le.$$.fragment),Oe=a(),ne=i("p"),ne.innerHTML=wt,Pe=a(),r(ae.$$.fragment),De=a(),se=i("p"),se.innerHTML=jt,Ke=a(),ie=i("p"),ie.innerHTML=Zt,et=a(),r(oe.$$.fragment),tt=a(),me=i("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),pe=s(e),re=o(e,"P",{}),Wt(re).forEach(l),ce=s(e),m(b.$$.fragment,e),de=s(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-3d25f3"&&(T.textContent=at),Me=s(e),m(U.$$.fragment,e),ue=s(e),m(g.$$.fragment,e),fe=s(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-6jviwr"&&(J.innerHTML=st),he=s(e),m(w.$$.fragment,e),ye=s(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1tmum2f"&&(j.innerHTML=it),be=s(e),m(Z.$$.fragment,e),Te=s(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-3oha3z"&&(W.innerHTML=ot),Ue=s(e),m(B.$$.fragment,e),ge=s(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-b6quw1"&&(C.innerHTML=rt),Je=s(e),m(X.$$.fragment,e),we=s(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-bjfa3x"&&(I.innerHTML=mt),je=s(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-a1kook"&&(R.innerHTML=pt),Ze=s(e),m(v.$$.fragment,e),We=s(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-e7rpqh"&&($.textContent=ct),Be=s(e),m(x.$$.fragment,e),Ce=s(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-eh7tzg"&&(k.innerHTML=dt),Xe=s(e),m(V.$$.fragment,e),Ie=s(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-19cbrlu"&&(G.innerHTML=Mt),Re=s(e),m(H.$$.fragment,e),ve=s(e),m(Q.$$.fragment,e),$e=s(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-8h57ng"&&(N.innerHTML=ut),xe=s(e),m(F.$$.fragment,e),ke=s(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-nvdwz8"&&(E.innerHTML=ft),Ve=s(e),m(z.$$.fragment,e),Ge=s(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1q2r63q"&&(_.innerHTML=ht),He=s(e),m(Y.$$.fragment,e),Qe=s(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-sgbmo9"&&(S.innerHTML=yt),Ne=s(e),m(q.$$.fragment,e),Fe=s(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1qcigt9"&&(A.textContent=bt),Ee=s(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1oa09xy"&&(L.textContent=Tt),ze=s(e),m(O.$$.fragment,e),_e=s(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-b35baa"&&(P.textContent=Ut),Ye=s(e),m(D.$$.fragment,e),Se=s(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-q4y2mt"&&(K.innerHTML=gt),qe=s(e),m(ee.$$.fragment,e),Ae=s(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1arwil2"&&(te.innerHTML=Jt),Le=s(e),m(le.$$.fragment,e),Oe=s(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1ufsnqk"&&(ne.innerHTML=wt),Pe=s(e),m(ae.$$.fragment,e),De=s(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1psut32"&&(se.innerHTML=jt),Ke=s(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-p7b5of"&&(ie.innerHTML=Zt),et=s(e),m(oe.$$.fragment,e),tt=s(e),me=o(e,"P",{}),Wt(me).forEach(l),this.h()},h(){Bt(y,"name","hf:doc:metadata"),Bt(y,"content",Gt)},m(e,t){xt(document.head,y),n(e,pe,t),n(e,re,t),n(e,ce,t),c(b,e,t),n(e,de,t),n(e,T,t),n(e,Me,t),c(U,e,t),n(e,ue,t),c(g,e,t),n(e,fe,t),n(e,J,t),n(e,he,t),c(w,e,t),n(e,ye,t),n(e,j,t),n(e,be,t),c(Z,e,t),n(e,Te,t),n(e,W,t),n(e,Ue,t),c(B,e,t),n(e,ge,t),n(e,C,t),n(e,Je,t),c(X,e,t),n(e,we,t),n(e,I,t),n(e,je,t),n(e,R,t),n(e,Ze,t),c(v,e,t),n(e,We,t),n(e,$,t),n(e,Be,t),c(x,e,t),n(e,Ce,t),n(e,k,t),n(e,Xe,t),c(V,e,t),n(e,Ie,t),n(e,G,t),n(e,Re,t),c(H,e,t),n(e,ve,t),c(Q,e,t),n(e,$e,t),n(e,N,t),n(e,xe,t),c(F,e,t),n(e,ke,t),n(e,E,t),n(e,Ve,t),c(z,e,t),n(e,Ge,t),n(e,_,t),n(e,He,t),c(Y,e,t),n(e,Qe,t),n(e,S,t),n(e,Ne,t),c(q,e,t),n(e,Fe,t),n(e,A,t),n(e,Ee,t),n(e,L,t),n(e,ze,t),c(O,e,t),n(e,_e,t),n(e,P,t),n(e,Ye,t),c(D,e,t),n(e,Se,t),n(e,K,t),n(e,qe,t),c(ee,e,t),n(e,Ae,t),n(e,te,t),n(e,Le,t),c(le,e,t),n(e,Oe,t),n(e,ne,t),n(e,Pe,t),c(ae,e,t),n(e,De,t),n(e,se,t),n(e,Ke,t),n(e,ie,t),n(e,et,t),c(oe,e,t),n(e,tt,t),n(e,me,t),lt=!0},p:Xt,i(e){lt||(d(b.$$.fragment,e),d(U.$$.fragment,e),d(g.$$.fragment,e),d(w.$$.fragment,e),d(Z.$$.fragment,e),d(B.$$.fragment,e),d(X.$$.fragment,e),d(v.$$.fragment,e),d(x.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(q.$$.fragment,e),d(O.$$.fragment,e),d(D.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(oe.$$.fragment,e),lt=!0)},o(e){M(b.$$.fragment,e),M(U.$$.fragment,e),M(g.$$.fragment,e),M(w.$$.fragment,e),M(Z.$$.fragment,e),M(B.$$.fragment,e),M(X.$$.fragment,e),M(v.$$.fragment,e),M(x.$$.fragment,e),M(V.$$.fragment,e),M(H.$$.fragment,e),M(Q.$$.fragment,e),M(F.$$.fragment,e),M(z.$$.fragment,e),M(Y.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(D.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),lt=!1},d(e){e&&(l(pe),l(re),l(ce),l(de),l(T),l(Me),l(ue),l(fe),l(J),l(he),l(ye),l(j),l(be),l(Te),l(W),l(Ue),l(ge),l(C),l(Je),l(we),l(I),l(je),l(R),l(Ze),l(We),l($),l(Be),l(Ce),l(k),l(Xe),l(Ie),l(G),l(Re),l(ve),l($e),l(N),l(xe),l(ke),l(E),l(Ve),l(Ge),l(_),l(He),l(Qe),l(S),l(Ne),l(Fe),l(A),l(Ee),l(L),l(ze),l(_e),l(P),l(Ye),l(Se),l(K),l(qe),l(Ae),l(te),l(Le),l(Oe),l(ne),l(Pe),l(De),l(se),l(Ke),l(ie),l(et),l(tt),l(me)),l(y),u(b,e),u(U,e),u(g,e),u(w,e),u(Z,e),u(B,e),u(X,e),u(v,e),u(x,e),u(V,e),u(H,e),u(Q,e),u(F,e),u(z,e),u(Y,e),u(q,e),u(O,e),u(D,e),u(ee,e),u(le,e),u(ae,e),u(oe,e)}}}const Gt='{"title":"Quick tour","local":"quick-tour","sections":[{"title":"Accelerated inference","local":"accelerated-inference","sections":[{"title":"OpenVINO","local":"openvino","sections":[],"depth":4},{"title":"IPEX","local":"ipex","sections":[],"depth":4},{"title":"ONNX Runtime","local":"onnx-runtime","sections":[],"depth":4}],"depth":2},{"title":"Accelerated training","local":"accelerated-training","sections":[{"title":"Habana","local":"habana","sections":[],"depth":4},{"title":"ONNX Runtime","local":"onnx-runtime","sections":[],"depth":4}],"depth":2},{"title":"Out of the box ONNX export","local":"out-of-the-box-onnx-export","sections":[],"depth":2},{"title":"PyTorch’s BetterTransformer support","local":"pytorchs-bettertransformer-support","sections":[],"depth":2},{"title":"torch.fx integration","local":"torchfx-integration","sections":[],"depth":2}],"depth":1}';function Ht(nt){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends Rt{constructor(y){super(),vt(this,y,Ht,Vt,Ct,{})}}export{zt as component};
