import{s as Xt,o as Lt,n as Rt}from"../chunks/scheduler.389d799c.js";import{S as Yt,i as Dt,g as o,s as n,r as u,A as Pt,h as i,f as l,c as a,j as Ft,u as c,x as p,k as Ht,y as Ot,a as s,v as r,d as h,t as m,w as T}from"../chunks/index.8f81d18f.js";import{T as Kt}from"../chunks/Tip.ad26ce4a.js";import{C as y}from"../chunks/CodeBlock.c0898180.js";import{H as me,E as el}from"../chunks/index.379a2bc0.js";function tl(Te){let M,J='📍 Find the complete example on GitHub <a href="https://github.com/huggingface/hub-docs/tree/main/notebooks/sagemaker-sdk/deploy-llama-3-3-70b-inferentia2/sagemaker-notebook.ipynb" rel="nofollow">here</a>!';return{c(){M=o("p"),M.innerHTML=J},l(d){M=i(d,"P",{"data-svelte-h":!0}),p(M)!=="svelte-8vujry"&&(M.innerHTML=J)},m(d,re){s(d,M,re)},p:Rt,d(d){d&&l(M)}}}function ll(Te){let M,J,d,re,I,de,U,rt='In this tutorial you will learn how to deploy <a href="https://huggingface.co/meta-llama/Llama-3.3-70B-Instruct" rel="nofollow">/meta-llama/Llama-3.3-70B-Instruct</a> model on AWS Inferentia2 with Hugging Face Optimum on Amazon SageMaker. We are going to use the Hugging Face TGI Neuron Container, a purpose-built Inference Container to easily deploy LLMs on AWS Inferentia2 powered by<a href="https://huggingface.co/docs/text-generation-inference/index" rel="nofollow">Text Generation Inference</a> and <a href="https://huggingface.co/docs/optimum-neuron/index" rel="nofollow">Optimum Neuron</a>.',ye,g,ht="We will cover how to:",je,w,mt='<li><a href="#1-setup-development-environment">Setup development environment</a></li> <li><a href="#2-retrieve-the-new-hugging-face-tgi-neuron-dlc">Retrieve the new Hugging Face TGI Neuron DLC</a></li> <li><a href="#3-deploy-llama-33-70b-to-inferentia2">Deploy Llama 3.3 70B to inferentia2</a></li> <li><a href="#4-clean-up">Clean up</a></li>',Je,f,Tt="Lets get started! 🚀",Ie,b,dt='<a href="https://aws.amazon.com/ec2/instance-types/inf2/" rel="nofollow">AWS inferentia (Inf2)</a> are purpose-built EC2 for deep learning (DL) inference workloads. Here are the different instances of the Inferentia2 family.',Ue,C,yt="<thead><tr><th>instance size</th> <th>accelerators</th> <th>Neuron Cores</th> <th>accelerator memory</th> <th>vCPU</th> <th>CPU Memory</th> <th>on-demand price ($/h)</th></tr></thead> <tbody><tr><td>inf2.xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>4</td> <td>16</td> <td>0.76</td></tr> <tr><td>inf2.8xlarge</td> <td>1</td> <td>2</td> <td>32</td> <td>32</td> <td>128</td> <td>1.97</td></tr> <tr><td>inf2.24xlarge</td> <td>6</td> <td>12</td> <td>192</td> <td>96</td> <td>384</td> <td>6.49</td></tr> <tr><td>inf2.48xlarge</td> <td>12</td> <td>24</td> <td>384</td> <td>192</td> <td>768</td> <td>12.98</td></tr></tbody>",ge,N,we,q,jt="For this tutorial, we are going to use a Notebook Instance in Amazon SageMaker with the Python 3 (ipykernel) and the <code>sagemaker</code> python SDK to deploy Llama 3.3 70B to a SageMaker inference endpoint.",fe,B,Jt="Make sur you have the latest version of the SageMaker SDK installed.",be,E,Ce,A,It="Then, instantiate the sagemaker role and session.",Ne,W,qe,Z,Be,v,Ut='The latest Hugging Face TGI Neuron DLCs can be used to run inference on AWS Inferentia2. You can use the <code>get_huggingface_llm_image_uri</code> method of the <code>sagemaker</code> SDK to retrieve the appropriate Hugging Face TGI Neuron DLC URI based on your desired <code>backend</code>, <code>session</code>, <code>region</code>, and <code>version</code>. You can find the latest version of the container <a href="https://huggingface.co/docs/optimum-neuron/containers" rel="nofollow">here</a>, if not yet added to the SageMaker SDK.',Ee,k,gt="At the time of the tutorial, the latest version of the container is not yet added to the Sagemaker SDK so we will not use <code>get_huggingface_llm_image_uri</code>.",Ae,x,We,_,Ze,z,wt=`At the time of writing, <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/v2.6.0/general/arch/neuron-features/dynamic-shapes.html#neuron-dynamic-shapes" rel="nofollow">AWS Inferentia2 does not support dynamic shapes for inference</a>, which means that we need to specify our sequence length and batch size ahead of time.
To make it easier for customers to utilize the full power of Inferentia2, we created a <a href="https://huggingface.co/docs/optimum-neuron/guides/cache_system" rel="nofollow">neuron model cache</a>, which contains pre-compiled configurations for the most popular LLMs, including Llama 3.3 70B.`,ve,G,ft='This means we don’t need to compile the model ourselves, but we can use the pre-compiled model from the cache. You can find compiled/cached configurations on the <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/tree/main/inference-cache-config" rel="nofollow">Hugging Face Hub</a>. If your desired configuration is not yet cached, you can compile it yourself using the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model" rel="nofollow">Optimum CLI</a> or open a request at the <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/discussions" rel="nofollow">Cache repository</a>.',ke,V,bt="<strong>Deploying Llama 3.3 70B to a SageMaker Endpoint</strong>",xe,S,Ct="Before deploying the model to Amazon SageMaker, we must define the TGI Neuron endpoint configuration. We need to make sure the following additional parameters are defined:",_e,$,Nt="<li><code>HF_NUM_CORES</code>: Number of Neuron Cores used for the compilation.</li> <li><code>HF_BATCH_SIZE</code>: The batch size that was used to compile the model.</li> <li><code>HF_SEQUENCE_LENGTH</code>: The sequence length that was used to compile the model.</li> <li><code>HF_AUTO_CAST_TYPE</code>: The auto cast type that was used to compile the model.</li>",ze,Q,qt="We still need to define traditional TGI parameters with:",Ge,F,Bt="<li><code>HF_MODEL_ID</code>: The Hugging Face model ID.</li> <li><code>HF_TOKEN</code>: The Hugging Face API token to access gated models.</li> <li><code>MAX_BATCH_SIZE</code>: The maximum batch size that the model can handle, equal to the batch size used for compilation.</li> <li><code>MAX_INPUT_TOKEN</code>: The maximum input length that the model can handle.</li> <li><code>MAX_TOTAL_TOKENS</code>: The maximum total tokens the model can generate, equal to the sequence length used for compilation.</li>",Ve,H,Et="Optionnaly, you can configure the endpoint to support chat templates:",Se,X,At="<li><code>MESSAGES_API_ENABLED</code>: Enable Messages API</li>",$e,L,Wt="<strong>Select the right instance type</strong>",Qe,R,Zt='Llama 3.3 70B is a large model and requires a lot of memory. We are going to use the <code>inf2.48xlarge</code> instance type, which has 192 vCPUs and 384 GB of accelerator memory. The <code>inf2.48xlarge</code> instance comes with 12 Inferentia2 accelerators that include 24 Neuron Cores. If you want to find the cached configurations for Llama 3.3 70B, you can find them <a href="https://huggingface.co/aws-neuron/optimum-neuron-cache/blob/main/inference-cache-config/llama3-70b.json#L16" rel="nofollow">here</a>. In our case we will use a batch size of 4 and a sequence length of 4096.',Fe,Y,vt='Before we can deploy Llama 3.3 70B to Inferentia2, we need to make sure we have the necessary permissions to access the model. You can request access to the model <a href="https://huggingface.co/meta-llama/Llama-3.3-70B-Instruct" rel="nofollow">here</a> and create a User access token following this <a href="https://huggingface.co/docs/hub/en/security-tokens" rel="nofollow">guide</a>.',He,D,kt="After that we can create our endpoint configuration and deploy the model to Amazon SageMaker. We will deploy the endpoint with the Messages API enabled, so that it is fully compatible with the OpenAI Chat Completion API.",Xe,P,Le,O,xt="After we have created the <code>HuggingFaceModel</code> we can deploy it to Amazon SageMaker using the <code>deploy</code> method. We will deploy the model with the <code>ml.inf2.48xlarge</code> instance type. TGI will automatically distribute and shard the model across all Inferentia devices.",Re,K,Ye,ee,_t="SageMaker will now create our endpoint and deploy the model to it. It takes around 30 minutes for deployment.",De,te,zt="After our endpoint is deployed we can run inference on it. We will use the <code>predict</code> method from the <code>predictor</code> to run inference on our endpoint.",Pe,le,Gt="The endpoint supports the Messages API, which is fully compatible with the OpenAI Chat Completion API. The Messages API allows us to interact with the model in a conversational way. We can define the role of the message and the content. The role can be either <code>system</code>,<code>assistant</code> or <code>user</code>. The <code>system</code> role is used to provide context to the model and the <code>user</code> role is used to ask questions or provide input to the model.",Oe,se,Vt='Parameters can be defined as in the <code>parameters</code> attribute of the payload. Check out the chat completion <a href="https://platform.openai.com/docs/api-reference/chat/create" rel="nofollow">documentation</a> to find supported parameters.',Ke,ne,et,ae,tt,oe,St="Okay lets test it.",lt,ie,st,pe,nt,Me,$t="To clean up, we can delete the model and endpoint.",at,ue,ot,it,pt,j,Mt,ce,ut,he,ct;return I=new me({props:{title:"Deploy Llama 3.3 70B on AWS Inferentia2",local:"deploy-llama-33-70b-on-aws-inferentia2",headingTag:"h1"}}),N=new me({props:{title:"1. Setup development environment",local:"1-setup-development-environment",headingTag:"h2"}}),E=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzYWdlbWFrZXIlMjAtLXVwZ3JhZGUlMjAtLXF1aWV0",highlighted:"!pip install sagemaker --upgrade --quiet",wrap:!1}}),W=new y({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBaW1wb3J0JTIwYm90bzMlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oKSUwQSUyMyUyMHNhZ2VtYWtlciUyMHNlc3Npb24lMjBidWNrZXQlMjAtJTNFJTIwdXNlZCUyMGZvciUyMHVwbG9hZGluZyUyMGRhdGElMkMlMjBtb2RlbHMlMjBhbmQlMjBsb2dzJTBBJTIzJTIwc2FnZW1ha2VyJTIwd2lsbCUyMGF1dG9tYXRpY2FsbHklMjBjcmVhdGUlMjB0aGlzJTIwYnVja2V0JTIwaWYlMjBpdCUyMG5vdCUyMGV4aXN0cyUwQXNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyME5vbmUlMEFpZiUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMGlzJTIwTm9uZSUyMGFuZCUyMHNlc3MlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBzZXQlMjB0byUyMGRlZmF1bHQlMjBidWNrZXQlMjBpZiUyMGElMjBidWNrZXQlMjBuYW1lJTIwaXMlMjBub3QlMjBnaXZlbiUwQSUyMCUyMCUyMCUyMHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCUyMCUzRCUyMHNlc3MuZGVmYXVsdF9idWNrZXQoKSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMHJvbGUlMjAlM0QlMjBzYWdlbWFrZXIuZ2V0X2V4ZWN1dGlvbl9yb2xlKCklMEFleGNlcHQlMjBWYWx1ZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwaWFtJTIwJTNEJTIwYm90bzMuY2xpZW50KCUyMmlhbSUyMiklMEElMjAlMjAlMjAlMjByb2xlJTIwJTNEJTIwaWFtLmdldF9yb2xlKFJvbGVOYW1lJTNEJTIyc2FnZW1ha2VyX2V4ZWN1dGlvbl9yb2xlJTIyKSU1QiUyMlJvbGUlMjIlNUQlNUIlMjJBcm4lMjIlNUQlMEElMEFzZXNzJTIwJTNEJTIwc2FnZW1ha2VyLlNlc3Npb24oZGVmYXVsdF9idWNrZXQlM0RzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQpJTBBJTBBcHJpbnQoZiUyMnNhZ2VtYWtlciUyMHJvbGUlMjBhcm4lM0ElMjAlN0Jyb2xlJTdEJTIyKSUwQXByaW50KGYlMjJzYWdlbWFrZXIlMjBzZXNzaW9uJTIwcmVnaW9uJTNBJTIwJTdCc2Vzcy5ib3RvX3JlZ2lvbl9uYW1lJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> sagemaker
<span class="hljs-keyword">import</span> boto3

sess = sagemaker.Session()
<span class="hljs-comment"># sagemaker session bucket -&gt; used for uploading data, models and logs</span>
<span class="hljs-comment"># sagemaker will automatically create this bucket if it not exists</span>
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    <span class="hljs-comment"># set to default bucket if a bucket name is not given</span>
    sagemaker_session_bucket = sess.default_bucket()

<span class="hljs-keyword">try</span>:
    role = sagemaker.get_execution_role()
<span class="hljs-keyword">except</span> ValueError:
    iam = boto3.client(<span class="hljs-string">&quot;iam&quot;</span>)
    role = iam.get_role(RoleName=<span class="hljs-string">&quot;sagemaker_execution_role&quot;</span>)[<span class="hljs-string">&quot;Role&quot;</span>][<span class="hljs-string">&quot;Arn&quot;</span>]

sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker role arn: <span class="hljs-subst">{role}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;sagemaker session region: <span class="hljs-subst">{sess.boto_region_name}</span>&quot;</span>)`,wrap:!1}}),Z=new me({props:{title:"2. Retrieve the latest Hugging Face TGI Neuron DLC",local:"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc",headingTag:"h2"}}),x=new y({props:{code:"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",highlighted:`<span class="hljs-comment"># pulled from https://github.com/aws/sagemaker-python-sdk/blob/master/src/sagemaker/image_uri_config/huggingface-llm-neuronx.json</span>
account_id_dict = {
    <span class="hljs-string">&quot;ap-northeast-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ap-south-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ap-south-2&quot;</span>: <span class="hljs-string">&quot;772153158452&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-2&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-4&quot;</span>: <span class="hljs-string">&quot;457447274322&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-5&quot;</span>: <span class="hljs-string">&quot;550225433462&quot;</span>,
    <span class="hljs-string">&quot;ap-southeast-7&quot;</span>: <span class="hljs-string">&quot;590183813437&quot;</span>,
    <span class="hljs-string">&quot;cn-north-1&quot;</span>: <span class="hljs-string">&quot;727897471807&quot;</span>,
    <span class="hljs-string">&quot;cn-northwest-1&quot;</span>: <span class="hljs-string">&quot;727897471807&quot;</span>,
    <span class="hljs-string">&quot;eu-central-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;eu-central-2&quot;</span>: <span class="hljs-string">&quot;380420809688&quot;</span>,
    <span class="hljs-string">&quot;eu-south-2&quot;</span>: <span class="hljs-string">&quot;503227376785&quot;</span>,
    <span class="hljs-string">&quot;eu-west-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;eu-west-3&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;il-central-1&quot;</span>: <span class="hljs-string">&quot;780543022126&quot;</span>,
    <span class="hljs-string">&quot;mx-central-1&quot;</span>: <span class="hljs-string">&quot;637423239942&quot;</span>,
    <span class="hljs-string">&quot;sa-east-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;us-east-1&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;us-east-2&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;us-gov-east-1&quot;</span>: <span class="hljs-string">&quot;446045086412&quot;</span>,
    <span class="hljs-string">&quot;us-gov-west-1&quot;</span>: <span class="hljs-string">&quot;442386744353&quot;</span>,
    <span class="hljs-string">&quot;us-west-2&quot;</span>: <span class="hljs-string">&quot;763104351884&quot;</span>,
    <span class="hljs-string">&quot;ca-west-1&quot;</span>: <span class="hljs-string">&quot;204538143572&quot;</span>,
}

region = boto3.Session().region_name
llm_image = <span class="hljs-string">f&quot;<span class="hljs-subst">{account_id_dict[region]}</span>.dkr.ecr.<span class="hljs-subst">{region}</span>.amazonaws.com/huggingface-pytorch-tgi-inference:2.1.2-optimum0.0.28-neuronx-py310-ubuntu22.04&quot;</span>`,wrap:!1}}),_=new me({props:{title:"3. Deploy Llama 3.3 70B to Inferentia2",local:"3-deploy-llama-33-70b-to-inferentia2",headingTag:"h2"}}),P=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFaceModel

<span class="hljs-comment"># sagemaker config</span>
instance_type = <span class="hljs-string">&quot;ml.inf2.48xlarge&quot;</span>
health_check_timeout = <span class="hljs-number">3600</span>  <span class="hljs-comment"># additional time to load the model</span>
volume_size = <span class="hljs-number">512</span>  <span class="hljs-comment"># size in GB of the EBS volume</span>

<span class="hljs-comment"># Define Model and Endpoint configuration parameter</span>
config = {
    <span class="hljs-string">&quot;HF_MODEL_ID&quot;</span>: <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
    <span class="hljs-string">&quot;HF_NUM_CORES&quot;</span>: <span class="hljs-string">&quot;24&quot;</span>,  <span class="hljs-comment"># number of neuron cores</span>
    <span class="hljs-string">&quot;HF_AUTO_CAST_TYPE&quot;</span>: <span class="hljs-string">&quot;bf16&quot;</span>,  <span class="hljs-comment"># dtype of the model</span>
    <span class="hljs-string">&quot;MAX_BATCH_SIZE&quot;</span>: <span class="hljs-string">&quot;4&quot;</span>,  <span class="hljs-comment"># max batch size for the model</span>
    <span class="hljs-string">&quot;MAX_INPUT_TOKENS&quot;</span>: <span class="hljs-string">&quot;4000&quot;</span>,  <span class="hljs-comment"># max length of input text</span>
    <span class="hljs-string">&quot;MAX_TOTAL_TOKENS&quot;</span>: <span class="hljs-string">&quot;4096&quot;</span>,  <span class="hljs-comment"># max length of generated text</span>
    <span class="hljs-string">&quot;MESSAGES_API_ENABLED&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>,  <span class="hljs-comment"># Enable the messages API</span>
    <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>,
}

<span class="hljs-keyword">assert</span> (
    config[<span class="hljs-string">&quot;HF_TOKEN&quot;</span>] != <span class="hljs-string">&quot;&lt;REPLACE WITH YOUR TOKEN&gt;&quot;</span>
), <span class="hljs-string">&quot;Please replace &#x27;&lt;REPLACE WITH YOUR TOKEN&gt;&#x27; with your Hugging Face Hub API token&quot;</span>


<span class="hljs-comment"># create HuggingFaceModel with the image uri</span>
llm_model = HuggingFaceModel(role=role, image_uri=llm_image, env=config)`,wrap:!1}}),K=new y({props:{code:"JTIzJTIwZGVhY3RpdmF0ZSUyMHdhcm5pbmclMjBzaW5jZSUyMG1vZGVsJTIwaXMlMjBjb21waWxlZCUwQWxsbV9tb2RlbC5faXNfY29tcGlsZWRfbW9kZWwlMjAlM0QlMjBUcnVlJTBBJTBBbGxtJTIwJTNEJTIwbGxtX21vZGVsLmRlcGxveSglMEElMjAlMjAlMjAlMjBpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX3R5cGUlM0RpbnN0YW5jZV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwY29udGFpbmVyX3N0YXJ0dXBfaGVhbHRoX2NoZWNrX3RpbWVvdXQlM0RoZWFsdGhfY2hlY2tfdGltZW91dCUyQyUwQSUyMCUyMCUyMCUyMHZvbHVtZV9zaXplJTNEdm9sdW1lX3NpemUlMkMlMEEp",highlighted:`<span class="hljs-comment"># deactivate warning since model is compiled</span>
llm_model._is_compiled_model = <span class="hljs-literal">True</span>

llm = llm_model.deploy(
    initial_instance_count=<span class="hljs-number">1</span>,
    instance_type=instance_type,
    container_startup_health_check_timeout=health_check_timeout,
    volume_size=volume_size,
)`,wrap:!1}}),ne=new y({props:{code:"JTdCJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUyMCU3RCUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-punctuation">{</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is deep learning?&quot;</span> <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ae=new y({props:{code:"JTIzJTIwUHJvbXB0JTIwdG8lMjBnZW5lcmF0ZSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjBkZWVwJTIwbGVhcm5pbmclMjBpbiUyMG9uZSUyMHNlbnRlbmNlJTNGJTIyJTdEJTJDJTBBJTVEJTBBJTBBJTIzJTIwR2VuZXJhdGlvbiUyMGFyZ3VtZW50cyUyMGh0dHBzJTNBJTJGJTJGcGxhdGZvcm0ub3BlbmFpLmNvbSUyRmRvY3MlMkZhcGktcmVmZXJlbmNlJTJGY2hhdCUyRmNyZWF0ZSUwQXBhcmFtZXRlcnMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMTAwJTJDJTBBJTdE",highlighted:`<span class="hljs-comment"># Prompt to generate</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning in one sentence?&quot;</span>},
]

<span class="hljs-comment"># Generation arguments https://platform.openai.com/docs/api-reference/chat/create</span>
parameters = {
    <span class="hljs-string">&quot;max_tokens&quot;</span>: <span class="hljs-number">100</span>,
}`,wrap:!1}}),ie=new y({props:{code:"Y2hhdCUyMCUzRCUyMGxsbS5wcmVkaWN0KCU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwbWVzc2FnZXMlMkMlMjAqKnBhcmFtZXRlcnMlMkMlMjAlMjJzdGVhbSUyMiUzQSUyMFRydWUlN0QpJTBBJTBBcHJpbnQoY2hhdCU1QiUyMmNob2ljZXMlMjIlNUQlNUIwJTVEJTVCJTIybWVzc2FnZSUyMiU1RCU1QiUyMmNvbnRlbnQlMjIlNUQuc3RyaXAoKSk=",highlighted:`chat = llm.predict({<span class="hljs-string">&quot;messages&quot;</span>: messages, **parameters, <span class="hljs-string">&quot;steam&quot;</span>: <span class="hljs-literal">True</span>})

<span class="hljs-built_in">print</span>(chat[<span class="hljs-string">&quot;choices&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-string">&quot;message&quot;</span>][<span class="hljs-string">&quot;content&quot;</span>].strip())`,wrap:!1}}),pe=new me({props:{title:"4. Clean up",local:"4-clean-up",headingTag:"h2"}}),ue=new y({props:{code:"bGxtLmRlbGV0ZV9tb2RlbCgpJTBBbGxtLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:`llm.delete_model()
llm.delete_endpoint()`,wrap:!1}}),j=new Kt({props:{$$slots:{default:[tl]},$$scope:{ctx:Te}}}),ce=new el({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/source/examples/sagemaker-sdk-deploy-llama-3-3-70b-inferentia2.mdx"}}),{c(){M=o("meta"),J=n(),d=o("p"),re=n(),u(I.$$.fragment),de=n(),U=o("p"),U.innerHTML=rt,ye=n(),g=o("p"),g.textContent=ht,je=n(),w=o("ol"),w.innerHTML=mt,Je=n(),f=o("p"),f.textContent=Tt,Ie=n(),b=o("p"),b.innerHTML=dt,Ue=n(),C=o("table"),C.innerHTML=yt,ge=n(),u(N.$$.fragment),we=n(),q=o("p"),q.innerHTML=jt,fe=n(),B=o("p"),B.textContent=Jt,be=n(),u(E.$$.fragment),Ce=n(),A=o("p"),A.textContent=It,Ne=n(),u(W.$$.fragment),qe=n(),u(Z.$$.fragment),Be=n(),v=o("p"),v.innerHTML=Ut,Ee=n(),k=o("p"),k.innerHTML=gt,Ae=n(),u(x.$$.fragment),We=n(),u(_.$$.fragment),Ze=n(),z=o("p"),z.innerHTML=wt,ve=n(),G=o("p"),G.innerHTML=ft,ke=n(),V=o("p"),V.innerHTML=bt,xe=n(),S=o("p"),S.textContent=Ct,_e=n(),$=o("ul"),$.innerHTML=Nt,ze=n(),Q=o("p"),Q.textContent=qt,Ge=n(),F=o("ul"),F.innerHTML=Bt,Ve=n(),H=o("p"),H.textContent=Et,Se=n(),X=o("ul"),X.innerHTML=At,$e=n(),L=o("p"),L.innerHTML=Wt,Qe=n(),R=o("p"),R.innerHTML=Zt,Fe=n(),Y=o("p"),Y.innerHTML=vt,He=n(),D=o("p"),D.textContent=kt,Xe=n(),u(P.$$.fragment),Le=n(),O=o("p"),O.innerHTML=xt,Re=n(),u(K.$$.fragment),Ye=n(),ee=o("p"),ee.textContent=_t,De=n(),te=o("p"),te.innerHTML=zt,Pe=n(),le=o("p"),le.innerHTML=Gt,Oe=n(),se=o("p"),se.innerHTML=Vt,Ke=n(),u(ne.$$.fragment),et=n(),u(ae.$$.fragment),tt=n(),oe=o("p"),oe.textContent=St,lt=n(),u(ie.$$.fragment),st=n(),u(pe.$$.fragment),nt=n(),Me=o("p"),Me.textContent=$t,at=n(),u(ue.$$.fragment),ot=n(),it=o("hr"),pt=n(),u(j.$$.fragment),Mt=n(),u(ce.$$.fragment),ut=n(),he=o("p"),this.h()},l(e){const t=Pt("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),J=a(e),d=i(e,"P",{}),Ft(d).forEach(l),re=a(e),c(I.$$.fragment,e),de=a(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-18ykppc"&&(U.innerHTML=rt),ye=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-df2280"&&(g.textContent=ht),je=a(e),w=i(e,"OL",{"data-svelte-h":!0}),p(w)!=="svelte-ouxi3x"&&(w.innerHTML=mt),Je=a(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-fedw35"&&(f.textContent=Tt),Ie=a(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-1q2zsrn"&&(b.innerHTML=dt),Ue=a(e),C=i(e,"TABLE",{"data-svelte-h":!0}),p(C)!=="svelte-1tmwmqe"&&(C.innerHTML=yt),ge=a(e),c(N.$$.fragment,e),we=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1e6mm58"&&(q.innerHTML=jt),fe=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-gxxxnf"&&(B.textContent=Jt),be=a(e),c(E.$$.fragment,e),Ce=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-k2b9z7"&&(A.textContent=It),Ne=a(e),c(W.$$.fragment,e),qe=a(e),c(Z.$$.fragment,e),Be=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-150z9km"&&(v.innerHTML=Ut),Ee=a(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-183iqes"&&(k.innerHTML=gt),Ae=a(e),c(x.$$.fragment,e),We=a(e),c(_.$$.fragment,e),Ze=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-w7lp5p"&&(z.innerHTML=wt),ve=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1kijx5w"&&(G.innerHTML=ft),ke=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-prnhqf"&&(V.innerHTML=bt),xe=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1lo8mr8"&&(S.textContent=Ct),_e=a(e),$=i(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-19xkqok"&&($.innerHTML=Nt),ze=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-7y1w5l"&&(Q.textContent=qt),Ge=a(e),F=i(e,"UL",{"data-svelte-h":!0}),p(F)!=="svelte-21hz0o"&&(F.innerHTML=Bt),Ve=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-ba46xn"&&(H.textContent=Et),Se=a(e),X=i(e,"UL",{"data-svelte-h":!0}),p(X)!=="svelte-i1wt4y"&&(X.innerHTML=At),$e=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1qiwbk5"&&(L.innerHTML=Wt),Qe=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1px60yi"&&(R.innerHTML=Zt),Fe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1mh0xpb"&&(Y.innerHTML=vt),He=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-dbarld"&&(D.textContent=kt),Xe=a(e),c(P.$$.fragment,e),Le=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-eb49q4"&&(O.innerHTML=xt),Re=a(e),c(K.$$.fragment,e),Ye=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-hs5wbn"&&(ee.textContent=_t),De=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1popn9h"&&(te.innerHTML=zt),Pe=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-7vzs06"&&(le.innerHTML=Gt),Oe=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-gr6587"&&(se.innerHTML=Vt),Ke=a(e),c(ne.$$.fragment,e),et=a(e),c(ae.$$.fragment,e),tt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1pq3qhh"&&(oe.textContent=St),lt=a(e),c(ie.$$.fragment,e),st=a(e),c(pe.$$.fragment,e),nt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-100mxno"&&(Me.textContent=$t),at=a(e),c(ue.$$.fragment,e),ot=a(e),it=i(e,"HR",{}),pt=a(e),c(j.$$.fragment,e),Mt=a(e),c(ce.$$.fragment,e),ut=a(e),he=i(e,"P",{}),Ft(he).forEach(l),this.h()},h(){Ht(M,"name","hf:doc:metadata"),Ht(M,"content",sl)},m(e,t){Ot(document.head,M),s(e,J,t),s(e,d,t),s(e,re,t),r(I,e,t),s(e,de,t),s(e,U,t),s(e,ye,t),s(e,g,t),s(e,je,t),s(e,w,t),s(e,Je,t),s(e,f,t),s(e,Ie,t),s(e,b,t),s(e,Ue,t),s(e,C,t),s(e,ge,t),r(N,e,t),s(e,we,t),s(e,q,t),s(e,fe,t),s(e,B,t),s(e,be,t),r(E,e,t),s(e,Ce,t),s(e,A,t),s(e,Ne,t),r(W,e,t),s(e,qe,t),r(Z,e,t),s(e,Be,t),s(e,v,t),s(e,Ee,t),s(e,k,t),s(e,Ae,t),r(x,e,t),s(e,We,t),r(_,e,t),s(e,Ze,t),s(e,z,t),s(e,ve,t),s(e,G,t),s(e,ke,t),s(e,V,t),s(e,xe,t),s(e,S,t),s(e,_e,t),s(e,$,t),s(e,ze,t),s(e,Q,t),s(e,Ge,t),s(e,F,t),s(e,Ve,t),s(e,H,t),s(e,Se,t),s(e,X,t),s(e,$e,t),s(e,L,t),s(e,Qe,t),s(e,R,t),s(e,Fe,t),s(e,Y,t),s(e,He,t),s(e,D,t),s(e,Xe,t),r(P,e,t),s(e,Le,t),s(e,O,t),s(e,Re,t),r(K,e,t),s(e,Ye,t),s(e,ee,t),s(e,De,t),s(e,te,t),s(e,Pe,t),s(e,le,t),s(e,Oe,t),s(e,se,t),s(e,Ke,t),r(ne,e,t),s(e,et,t),r(ae,e,t),s(e,tt,t),s(e,oe,t),s(e,lt,t),r(ie,e,t),s(e,st,t),r(pe,e,t),s(e,nt,t),s(e,Me,t),s(e,at,t),r(ue,e,t),s(e,ot,t),s(e,it,t),s(e,pt,t),r(j,e,t),s(e,Mt,t),r(ce,e,t),s(e,ut,t),s(e,he,t),ct=!0},p(e,[t]){const Qt={};t&2&&(Qt.$$scope={dirty:t,ctx:e}),j.$set(Qt)},i(e){ct||(h(I.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),h(W.$$.fragment,e),h(Z.$$.fragment,e),h(x.$$.fragment,e),h(_.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(ue.$$.fragment,e),h(j.$$.fragment,e),h(ce.$$.fragment,e),ct=!0)},o(e){m(I.$$.fragment,e),m(N.$$.fragment,e),m(E.$$.fragment,e),m(W.$$.fragment,e),m(Z.$$.fragment,e),m(x.$$.fragment,e),m(_.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(ue.$$.fragment,e),m(j.$$.fragment,e),m(ce.$$.fragment,e),ct=!1},d(e){e&&(l(J),l(d),l(re),l(de),l(U),l(ye),l(g),l(je),l(w),l(Je),l(f),l(Ie),l(b),l(Ue),l(C),l(ge),l(we),l(q),l(fe),l(B),l(be),l(Ce),l(A),l(Ne),l(qe),l(Be),l(v),l(Ee),l(k),l(Ae),l(We),l(Ze),l(z),l(ve),l(G),l(ke),l(V),l(xe),l(S),l(_e),l($),l(ze),l(Q),l(Ge),l(F),l(Ve),l(H),l(Se),l(X),l($e),l(L),l(Qe),l(R),l(Fe),l(Y),l(He),l(D),l(Xe),l(Le),l(O),l(Re),l(Ye),l(ee),l(De),l(te),l(Pe),l(le),l(Oe),l(se),l(Ke),l(et),l(tt),l(oe),l(lt),l(st),l(nt),l(Me),l(at),l(ot),l(it),l(pt),l(Mt),l(ut),l(he)),l(M),T(I,e),T(N,e),T(E,e),T(W,e),T(Z,e),T(x,e),T(_,e),T(P,e),T(K,e),T(ne,e),T(ae,e),T(ie,e),T(pe,e),T(ue,e),T(j,e),T(ce,e)}}}const sl='{"title":"Deploy Llama 3.3 70B on AWS Inferentia2","local":"deploy-llama-33-70b-on-aws-inferentia2","sections":[{"title":"1. Setup development environment","local":"1-setup-development-environment","sections":[],"depth":2},{"title":"2. Retrieve the latest Hugging Face TGI Neuron DLC","local":"2-retrieve-the-latest-hugging-face-tgi-neuron-dlc","sections":[],"depth":2},{"title":"3. Deploy Llama 3.3 70B to Inferentia2","local":"3-deploy-llama-33-70b-to-inferentia2","sections":[],"depth":2},{"title":"4. Clean up","local":"4-clean-up","sections":[],"depth":2}],"depth":1}';function nl(Te){return Lt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ul extends Yt{constructor(M){super(),Dt(this,M,nl,ll,Xt,{})}}export{ul as component};
