import{s as ss,n as us,o as ns}from"../chunks/scheduler.b108d059.js";import{S as ms,i as fs,g as o,s as a,r as m,A as ps,h as i,f as e,c as d,j as n,u as f,x as s,k as u,y as hs,a as r,v as p,d as h,t as c,w as T}from"../chunks/index.008de539.js";import{H as y}from"../chunks/Heading.88bfeb84.js";function cs(bo){let v,cl,pl,Tl,F,yl,_,vl,b,xo="Helper module for mathematical processing.",Fl,x,$o=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,_l,$,Ao='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.transpose_data"><code>.transpose_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>any</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.getTopItems"><code>.getTopItems(items, [top_k])</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths..NP2FFT">~NP2FFT</a><ul><li><a href="#new_module_utils/maths..NP2FFT_new"><code>new NP2FFT(fft_length)</code></a></li></ul></li> <li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',bl,xl,$l,A,Al,P,Pl,C,Po='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Cl,H,Co="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",Hl,Ll,Ml,L,wl,M,gl,w,Ho="Helper method to transpose a <code>AnyTypedArray</code> directly",El,g,Lo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The transposed array and the new shape.',Rl,E,Mo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",zl,kl,Kl,R,Ol,z,Bl,k,wo="Compute the softmax of an array of numbers.",Dl,K,go='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The softmax array.',Il,O,Eo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",jl,ql,Ul,B,Sl,D,Nl,I,Ro="Calculates the logarithm of the softmax function for the input array.",Gl,j,zo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>any</code> - The resulting log_softmax array.',Jl,q,ko="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",Ql,Vl,Wl,U,Xl,S,Yl,N,Ko="Calculates the dot product of two arrays.",Zl,G,Oo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',tr,J,Bo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",er,lr,rr,Q,ar,V,dr,W,Do="Get the top k items from an iterable, sorted by descending order",or,X,Io='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array</code> - The top k items, sorted by descending order',ir,Y,jo="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array</code></td><td></td><td><p>The items to be sorted</p></td> </tr><tr><td>[top_k]</td><td><code>number</code></td><td><code>0</code></td><td><p>The number of top items to return (default: 0 = return all)</p></td></tr></tbody>",sr,ur,nr,Z,mr,tt,fr,et,qo="Computes the cosine similarity between two arrays.",pr,lt,Uo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',hr,rt,So="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",cr,Tr,yr,at,vr,dt,Fr,ot,No="Calculates the magnitude of a given array.",_r,it,Go='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',br,st,Jo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",xr,$r,Ar,ut,Pr,nt,Cr,mt,Qo="Returns the value and index of the minimum element in an array.",Hr,ft,Vo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',Lr,pt,Wo="<li><code>Error</code> If array is empty.</li>",Mr,ht,Xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",wr,gr,Er,ct,Rr,Tt,zr,yt,Yo="Returns the value and index of the maximum element in an array.",kr,vt,Zo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',Kr,Ft,ti="<li><code>Error</code> If array is empty.</li>",Or,_t,ei="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Br,Dr,Ir,bt,jr,xt,qr,$t,li="Performs median filter on the provided data. Padding is done by mirroring the data.",Ur,At,ri='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Sr,Pt,ai="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",Nr,Gr,Jr,Ct,Qr,Ht,Vr,Lt,di="Helper function to round a number to a given number of decimals",Wr,Mt,oi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',Xr,wt,ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",Yr,Zr,ta,gt,ea,Et,la,Rt,si="Implementation of Radix-4 FFT.",ra,zt,ui=`P2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are a power of two in length.
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,aa,kt,ni='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',da,Kt,mi='<li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',oa,ia,sa,Ot,ua,Bt,na,Dt,fi="<strong>Throws</strong>:",ma,It,pi="<li><code>Error</code> FFT size must be a power of two larger than 1.</li>",fa,jt,hi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two larger than 1.</p></td></tr></tbody>",pa,ha,ca,qt,Ta,Ut,ya,St,ci="Create a complex number array with size <code>2 * size</code>",va,Nt,Ti='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - A complex number array with size <code>2 * size</code>',Fa,_a,ba,Gt,xa,Jt,$a,Qt,yi="Converts a complex number representation stored in a Float64Array to an array of real numbers.",Aa,Vt,vi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',Pa,Wt,Fi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float64Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",Ca,Ha,La,Xt,Ma,Yt,wa,Zt,_i="Convert a real-valued input array to a complex-valued output array.",ga,te,bi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The complex-valued output array.',Ea,ee,xi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float64Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float64Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",Ra,za,ka,le,Ka,re,Oa,ae,$i="Completes the spectrum by adding its mirrored negative frequency components.",Ba,de,Ai='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Da,oe,Pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>spectrum</td><td><code>Float64Array</code></td><td><p>The input spectrum.</p></td></tr></tbody>",Ia,ja,qa,ie,Ua,se,Sa,ue,Ci="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",Na,ne,Hi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',Ga,me,Li="<li><code>Error</code> Input and output buffers must be different.</li>",Ja,fe,Mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",Qa,Va,Wa,pe,Xa,he,Ya,ce,wi=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,Za,Te,gi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',td,ye,Ei="<li><code>Error</code> If the input and output buffers are the same.</li>",ed,ve,Ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",ld,rd,ad,Fe,dd,_e,od,be,zi=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,id,xe,ki='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',sd,$e,Ki="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",ud,Ae,Oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",nd,md,fd,Pe,pd,Ce,hd,He,Bi="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",cd,Le,Di='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Td,Me,Ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",yd,vd,Fd,we,_d,ge,bd,Ee,ji="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",xd,Re,qi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',$d,ze,Ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",Ad,Pd,Cd,ke,Hd,Ke,Ld,Oe,Si="Performs radix-4 transformation on input data of length 8",Md,Be,Ni='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',wd,De,Gi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",gd,Ed,Rd,Ie,zd,je,kd,qe,Ji="Real input radix-4 implementation",Kd,Ue,Qi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Od,Se,Vi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",Bd,Dd,Id,Ne,jd,Ge,qd,Je,Wi="Performs a single real input radix-2 transformation on the provided data",Ud,Qe,Xi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Sd,Ve,Yi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",Nd,Gd,Jd,We,Qd,Xe,Vd,Ye,Zi=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,Wd,Ze,ts='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Xd,tl,es="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",Yd,Zd,to,el,eo,ll,lo,rl,ls=`NP2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are not a power of two in length. In such cases, the chirp-z transform is used.`,ro,al,rs='For more information, see: <a href="https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156" rel="nofollow">https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156</a>',ao,dl,as='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',oo,io,so,ol,uo,il,no,sl,ds="Constructs a new NP2FFT object.",mo,ul,os="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_length</td><td><code>number</code></td><td><p>The length of the FFT</p></td></tr></tbody>",fo,po,ho,nl,co,ml,To,fl,is='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',yo,vo,Fo,hl,_o;return _=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),P=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),M=new y({props:{title:"utils/maths.transpose_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathstransposedataarray-dims-axes--code--code",headingTag:"h2"}}),z=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathssoftmaxarr--code-array--number--code",headingTag:"h2"}}),D=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> any </code>",local:"utilsmathslogsoftmaxarr--code-any-code",headingTag:"h2"}}),S=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),V=new y({props:{title:"utils/maths.getTopItems(items, [top_k]) ⇒ <code> Array </code>",local:"utilsmathsgettopitemsitems-topk--code-array-code",headingTag:"h2"}}),tt=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),dt=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),nt=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),Tt=new y({props:{title:"utils/maths.max(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsmaxarr--code-array--number--code",headingTag:"h2"}}),xt=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),Ht=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),Et=new y({props:{title:"utils/maths~P2FFT",local:"utilsmathsp2fft",headingTag:"h2"}}),Bt=new y({props:{title:"new P2FFT(size)",local:"new-p2fftsize",headingTag:"h3"}}),Ut=new y({props:{title:"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>",local:"p2fftcreatecomplexarray--code-float64array-code",headingTag:"h3"}}),Jt=new y({props:{title:"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"p2fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),Yt=new y({props:{title:"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>",local:"p2ffttocomplexarrayinput-storage--code-float64array-code",headingTag:"h3"}}),re=new y({props:{title:"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>",local:"p2fftcompletespectrumspectrum--code-void-code",headingTag:"h3"}}),se=new y({props:{title:"p2FFT.transform(out, data) ⇒ <code> void </code>",local:"p2ffttransformout-data--code-void-code",headingTag:"h3"}}),he=new y({props:{title:"p2FFT.realTransform(out, data)",local:"p2fftrealtransformout-data",headingTag:"h3"}}),_e=new y({props:{title:"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>",local:"p2fftinversetransformout-data--code-void-code",headingTag:"h3"}}),Ce=new y({props:{title:"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>",local:"p2ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),ge=new y({props:{title:"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Ke=new y({props:{title:"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),je=new y({props:{title:"p2FFT._realTransform4(out, data, inv)",local:"p2fftrealtransform4out-data-inv",headingTag:"h3"}}),Ge=new y({props:{title:"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Xe=new y({props:{title:"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"p2fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),ll=new y({props:{title:"utils/maths~NP2FFT",local:"utilsmathsnp2fft",headingTag:"h2"}}),il=new y({props:{title:"new NP2FFT(fft_length)",local:"new-np2fftfftlength",headingTag:"h3"}}),ml=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),{c(){v=o("meta"),cl=a(),pl=o("p"),Tl=a(),F=o("a"),yl=a(),m(_.$$.fragment),vl=a(),b=o("p"),b.textContent=xo,Fl=a(),x=o("p"),x.textContent=$o,_l=a(),$=o("ul"),$.innerHTML=Ao,bl=a(),xl=o("hr"),$l=a(),A=o("a"),Al=a(),m(P.$$.fragment),Pl=a(),C=o("p"),C.innerHTML=Po,Cl=a(),H=o("table"),H.innerHTML=Co,Hl=a(),Ll=o("hr"),Ml=a(),L=o("a"),wl=a(),m(M.$$.fragment),gl=a(),w=o("p"),w.innerHTML=Ho,El=a(),g=o("p"),g.innerHTML=Lo,Rl=a(),E=o("table"),E.innerHTML=Mo,zl=a(),kl=o("hr"),Kl=a(),R=o("a"),Ol=a(),m(z.$$.fragment),Bl=a(),k=o("p"),k.textContent=wo,Dl=a(),K=o("p"),K.innerHTML=go,Il=a(),O=o("table"),O.innerHTML=Eo,jl=a(),ql=o("hr"),Ul=a(),B=o("a"),Sl=a(),m(D.$$.fragment),Nl=a(),I=o("p"),I.textContent=Ro,Gl=a(),j=o("p"),j.innerHTML=zo,Jl=a(),q=o("table"),q.innerHTML=ko,Ql=a(),Vl=o("hr"),Wl=a(),U=o("a"),Xl=a(),m(S.$$.fragment),Yl=a(),N=o("p"),N.textContent=Ko,Zl=a(),G=o("p"),G.innerHTML=Oo,tr=a(),J=o("table"),J.innerHTML=Bo,er=a(),lr=o("hr"),rr=a(),Q=o("a"),ar=a(),m(V.$$.fragment),dr=a(),W=o("p"),W.textContent=Do,or=a(),X=o("p"),X.innerHTML=Io,ir=a(),Y=o("table"),Y.innerHTML=jo,sr=a(),ur=o("hr"),nr=a(),Z=o("a"),mr=a(),m(tt.$$.fragment),fr=a(),et=o("p"),et.textContent=qo,pr=a(),lt=o("p"),lt.innerHTML=Uo,hr=a(),rt=o("table"),rt.innerHTML=So,cr=a(),Tr=o("hr"),yr=a(),at=o("a"),vr=a(),m(dt.$$.fragment),Fr=a(),ot=o("p"),ot.textContent=No,_r=a(),it=o("p"),it.innerHTML=Go,br=a(),st=o("table"),st.innerHTML=Jo,xr=a(),$r=o("hr"),Ar=a(),ut=o("a"),Pr=a(),m(nt.$$.fragment),Cr=a(),mt=o("p"),mt.textContent=Qo,Hr=a(),ft=o("p"),ft.innerHTML=Vo,Lr=a(),pt=o("ul"),pt.innerHTML=Wo,Mr=a(),ht=o("table"),ht.innerHTML=Xo,wr=a(),gr=o("hr"),Er=a(),ct=o("a"),Rr=a(),m(Tt.$$.fragment),zr=a(),yt=o("p"),yt.textContent=Yo,kr=a(),vt=o("p"),vt.innerHTML=Zo,Kr=a(),Ft=o("ul"),Ft.innerHTML=ti,Or=a(),_t=o("table"),_t.innerHTML=ei,Br=a(),Dr=o("hr"),Ir=a(),bt=o("a"),jr=a(),m(xt.$$.fragment),qr=a(),$t=o("p"),$t.textContent=li,Ur=a(),At=o("p"),At.innerHTML=ri,Sr=a(),Pt=o("table"),Pt.innerHTML=ai,Nr=a(),Gr=o("hr"),Jr=a(),Ct=o("a"),Qr=a(),m(Ht.$$.fragment),Vr=a(),Lt=o("p"),Lt.textContent=di,Wr=a(),Mt=o("p"),Mt.innerHTML=oi,Xr=a(),wt=o("table"),wt.innerHTML=ii,Yr=a(),Zr=o("hr"),ta=a(),gt=o("a"),ea=a(),m(Et.$$.fragment),la=a(),Rt=o("p"),Rt.textContent=si,ra=a(),zt=o("p"),zt.innerHTML=ui,aa=a(),kt=o("p"),kt.innerHTML=ni,da=a(),Kt=o("ul"),Kt.innerHTML=mi,oa=a(),ia=o("hr"),sa=a(),Ot=o("a"),ua=a(),m(Bt.$$.fragment),na=a(),Dt=o("p"),Dt.innerHTML=fi,ma=a(),It=o("ul"),It.innerHTML=pi,fa=a(),jt=o("table"),jt.innerHTML=hi,pa=a(),ha=o("hr"),ca=a(),qt=o("a"),Ta=a(),m(Ut.$$.fragment),ya=a(),St=o("p"),St.innerHTML=ci,va=a(),Nt=o("p"),Nt.innerHTML=Ti,Fa=a(),_a=o("hr"),ba=a(),Gt=o("a"),xa=a(),m(Jt.$$.fragment),$a=a(),Qt=o("p"),Qt.textContent=yi,Aa=a(),Vt=o("p"),Vt.innerHTML=vi,Pa=a(),Wt=o("table"),Wt.innerHTML=Fi,Ca=a(),Ha=o("hr"),La=a(),Xt=o("a"),Ma=a(),m(Yt.$$.fragment),wa=a(),Zt=o("p"),Zt.textContent=_i,ga=a(),te=o("p"),te.innerHTML=bi,Ea=a(),ee=o("table"),ee.innerHTML=xi,Ra=a(),za=o("hr"),ka=a(),le=o("a"),Ka=a(),m(re.$$.fragment),Oa=a(),ae=o("p"),ae.textContent=$i,Ba=a(),de=o("p"),de.innerHTML=Ai,Da=a(),oe=o("table"),oe.innerHTML=Pi,Ia=a(),ja=o("hr"),qa=a(),ie=o("a"),Ua=a(),m(se.$$.fragment),Sa=a(),ue=o("p"),ue.textContent=Ci,Na=a(),ne=o("p"),ne.innerHTML=Hi,Ga=a(),me=o("ul"),me.innerHTML=Li,Ja=a(),fe=o("table"),fe.innerHTML=Mi,Qa=a(),Va=o("hr"),Wa=a(),pe=o("a"),Xa=a(),m(he.$$.fragment),Ya=a(),ce=o("p"),ce.textContent=wi,Za=a(),Te=o("p"),Te.innerHTML=gi,td=a(),ye=o("ul"),ye.innerHTML=Ei,ed=a(),ve=o("table"),ve.innerHTML=Ri,ld=a(),rd=o("hr"),ad=a(),Fe=o("a"),dd=a(),m(_e.$$.fragment),od=a(),be=o("p"),be.innerHTML=zi,id=a(),xe=o("p"),xe.innerHTML=ki,sd=a(),$e=o("ul"),$e.innerHTML=Ki,ud=a(),Ae=o("table"),Ae.innerHTML=Oi,nd=a(),md=o("hr"),fd=a(),Pe=o("a"),pd=a(),m(Ce.$$.fragment),hd=a(),He=o("p"),He.textContent=Bi,cd=a(),Le=o("p"),Le.innerHTML=Di,Td=a(),Me=o("table"),Me.innerHTML=Ii,yd=a(),vd=o("hr"),Fd=a(),we=o("a"),_d=a(),m(ge.$$.fragment),bd=a(),Ee=o("p"),Ee.textContent=ji,xd=a(),Re=o("p"),Re.innerHTML=qi,$d=a(),ze=o("table"),ze.innerHTML=Ui,Ad=a(),Pd=o("hr"),Cd=a(),ke=o("a"),Hd=a(),m(Ke.$$.fragment),Ld=a(),Oe=o("p"),Oe.textContent=Si,Md=a(),Be=o("p"),Be.innerHTML=Ni,wd=a(),De=o("table"),De.innerHTML=Gi,gd=a(),Ed=o("hr"),Rd=a(),Ie=o("a"),zd=a(),m(je.$$.fragment),kd=a(),qe=o("p"),qe.textContent=Ji,Kd=a(),Ue=o("p"),Ue.innerHTML=Qi,Od=a(),Se=o("table"),Se.innerHTML=Vi,Bd=a(),Dd=o("hr"),Id=a(),Ne=o("a"),jd=a(),m(Ge.$$.fragment),qd=a(),Je=o("p"),Je.textContent=Wi,Ud=a(),Qe=o("p"),Qe.innerHTML=Xi,Sd=a(),Ve=o("table"),Ve.innerHTML=Yi,Nd=a(),Gd=o("hr"),Jd=a(),We=o("a"),Qd=a(),m(Xe.$$.fragment),Vd=a(),Ye=o("p"),Ye.textContent=Zi,Wd=a(),Ze=o("p"),Ze.innerHTML=ts,Xd=a(),tl=o("table"),tl.innerHTML=es,Yd=a(),Zd=o("hr"),to=a(),el=o("a"),eo=a(),m(ll.$$.fragment),lo=a(),rl=o("p"),rl.textContent=ls,ro=a(),al=o("p"),al.innerHTML=rs,ao=a(),dl=o("p"),dl.innerHTML=as,oo=a(),io=o("hr"),so=a(),ol=o("a"),uo=a(),m(il.$$.fragment),no=a(),sl=o("p"),sl.textContent=ds,mo=a(),ul=o("table"),ul.innerHTML=os,fo=a(),po=o("hr"),ho=a(),nl=o("a"),co=a(),m(ml.$$.fragment),To=a(),fl=o("p"),fl.innerHTML=is,yo=a(),vo=o("hr"),Fo=a(),hl=o("p"),this.h()},l(t){const l=ps("svelte-u9bgzb",document.head);v=i(l,"META",{name:!0,content:!0}),l.forEach(e),cl=d(t),pl=i(t,"P",{}),n(pl).forEach(e),Tl=d(t),F=i(t,"A",{id:!0,class:!0}),n(F).forEach(e),yl=d(t),f(_.$$.fragment,t),vl=d(t),b=i(t,"P",{"data-svelte-h":!0}),s(b)!=="svelte-1d3zgi"&&(b.textContent=xo),Fl=d(t),x=i(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-il3kl8"&&(x.textContent=$o),_l=d(t),$=i(t,"UL",{"data-svelte-h":!0}),s($)!=="svelte-io2o1h"&&($.innerHTML=Ao),bl=d(t),xl=i(t,"HR",{}),$l=d(t),A=i(t,"A",{id:!0,class:!0}),n(A).forEach(e),Al=d(t),f(P.$$.fragment,t),Pl=d(t),C=i(t,"P",{"data-svelte-h":!0}),s(C)!=="svelte-z8esp"&&(C.innerHTML=Po),Cl=d(t),H=i(t,"TABLE",{"data-svelte-h":!0}),s(H)!=="svelte-13raiaj"&&(H.innerHTML=Co),Hl=d(t),Ll=i(t,"HR",{}),Ml=d(t),L=i(t,"A",{id:!0,class:!0}),n(L).forEach(e),wl=d(t),f(M.$$.fragment,t),gl=d(t),w=i(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-69x642"&&(w.innerHTML=Ho),El=d(t),g=i(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-1t49mrp"&&(g.innerHTML=Lo),Rl=d(t),E=i(t,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-18fxup5"&&(E.innerHTML=Mo),zl=d(t),kl=i(t,"HR",{}),Kl=d(t),R=i(t,"A",{id:!0,class:!0}),n(R).forEach(e),Ol=d(t),f(z.$$.fragment,t),Bl=d(t),k=i(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1liv70i"&&(k.textContent=wo),Dl=d(t),K=i(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-rbowzb"&&(K.innerHTML=go),Il=d(t),O=i(t,"TABLE",{"data-svelte-h":!0}),s(O)!=="svelte-5w3h5g"&&(O.innerHTML=Eo),jl=d(t),ql=i(t,"HR",{}),Ul=d(t),B=i(t,"A",{id:!0,class:!0}),n(B).forEach(e),Sl=d(t),f(D.$$.fragment,t),Nl=d(t),I=i(t,"P",{"data-svelte-h":!0}),s(I)!=="svelte-5479oq"&&(I.textContent=Ro),Gl=d(t),j=i(t,"P",{"data-svelte-h":!0}),s(j)!=="svelte-qwp7fz"&&(j.innerHTML=zo),Jl=d(t),q=i(t,"TABLE",{"data-svelte-h":!0}),s(q)!=="svelte-1482umh"&&(q.innerHTML=ko),Ql=d(t),Vl=i(t,"HR",{}),Wl=d(t),U=i(t,"A",{id:!0,class:!0}),n(U).forEach(e),Xl=d(t),f(S.$$.fragment,t),Yl=d(t),N=i(t,"P",{"data-svelte-h":!0}),s(N)!=="svelte-1kaf4lx"&&(N.textContent=Ko),Zl=d(t),G=i(t,"P",{"data-svelte-h":!0}),s(G)!=="svelte-gudhvq"&&(G.innerHTML=Oo),tr=d(t),J=i(t,"TABLE",{"data-svelte-h":!0}),s(J)!=="svelte-nyqk4k"&&(J.innerHTML=Bo),er=d(t),lr=i(t,"HR",{}),rr=d(t),Q=i(t,"A",{id:!0,class:!0}),n(Q).forEach(e),ar=d(t),f(V.$$.fragment,t),dr=d(t),W=i(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-s7mgi8"&&(W.textContent=Do),or=d(t),X=i(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-u4yvnz"&&(X.innerHTML=Io),ir=d(t),Y=i(t,"TABLE",{"data-svelte-h":!0}),s(Y)!=="svelte-pqgsee"&&(Y.innerHTML=jo),sr=d(t),ur=i(t,"HR",{}),nr=d(t),Z=i(t,"A",{id:!0,class:!0}),n(Z).forEach(e),mr=d(t),f(tt.$$.fragment,t),fr=d(t),et=i(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-6quqqj"&&(et.textContent=qo),pr=d(t),lt=i(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1y45k06"&&(lt.innerHTML=Uo),hr=d(t),rt=i(t,"TABLE",{"data-svelte-h":!0}),s(rt)!=="svelte-nyqk4k"&&(rt.innerHTML=So),cr=d(t),Tr=i(t,"HR",{}),yr=d(t),at=i(t,"A",{id:!0,class:!0}),n(at).forEach(e),vr=d(t),f(dt.$$.fragment,t),Fr=d(t),ot=i(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-132v21g"&&(ot.textContent=No),_r=d(t),it=i(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-odriss"&&(it.innerHTML=Go),br=d(t),st=i(t,"TABLE",{"data-svelte-h":!0}),s(st)!=="svelte-nbo00i"&&(st.innerHTML=Jo),xr=d(t),$r=i(t,"HR",{}),Ar=d(t),ut=i(t,"A",{id:!0,class:!0}),n(ut).forEach(e),Pr=d(t),f(nt.$$.fragment,t),Cr=d(t),mt=i(t,"P",{"data-svelte-h":!0}),s(mt)!=="svelte-67h0u1"&&(mt.textContent=Qo),Hr=d(t),ft=i(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-cs0f6n"&&(ft.innerHTML=Vo),Lr=d(t),pt=i(t,"UL",{"data-svelte-h":!0}),s(pt)!=="svelte-jusv8t"&&(pt.innerHTML=Wo),Mr=d(t),ht=i(t,"TABLE",{"data-svelte-h":!0}),s(ht)!=="svelte-mtkj0x"&&(ht.innerHTML=Xo),wr=d(t),gr=i(t,"HR",{}),Er=d(t),ct=i(t,"A",{id:!0,class:!0}),n(ct).forEach(e),Rr=d(t),f(Tt.$$.fragment,t),zr=d(t),yt=i(t,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-9vv4b"&&(yt.textContent=Yo),kr=d(t),vt=i(t,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-19uyzyt"&&(vt.innerHTML=Zo),Kr=d(t),Ft=i(t,"UL",{"data-svelte-h":!0}),s(Ft)!=="svelte-jusv8t"&&(Ft.innerHTML=ti),Or=d(t),_t=i(t,"TABLE",{"data-svelte-h":!0}),s(_t)!=="svelte-mtkj0x"&&(_t.innerHTML=ei),Br=d(t),Dr=i(t,"HR",{}),Ir=d(t),bt=i(t,"A",{id:!0,class:!0}),n(bt).forEach(e),jr=d(t),f(xt.$$.fragment,t),qr=d(t),$t=i(t,"P",{"data-svelte-h":!0}),s($t)!=="svelte-xb1vdd"&&($t.textContent=li),Ur=d(t),At=i(t,"P",{"data-svelte-h":!0}),s(At)!=="svelte-z8esp"&&(At.innerHTML=ri),Sr=d(t),Pt=i(t,"TABLE",{"data-svelte-h":!0}),s(Pt)!=="svelte-pk7ooi"&&(Pt.innerHTML=ai),Nr=d(t),Gr=i(t,"HR",{}),Jr=d(t),Ct=i(t,"A",{id:!0,class:!0}),n(Ct).forEach(e),Qr=d(t),f(Ht.$$.fragment,t),Vr=d(t),Lt=i(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-11aka64"&&(Lt.textContent=di),Wr=d(t),Mt=i(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-jttckh"&&(Mt.innerHTML=oi),Xr=d(t),wt=i(t,"TABLE",{"data-svelte-h":!0}),s(wt)!=="svelte-c6gnt1"&&(wt.innerHTML=ii),Yr=d(t),Zr=i(t,"HR",{}),ta=d(t),gt=i(t,"A",{id:!0,class:!0}),n(gt).forEach(e),ea=d(t),f(Et.$$.fragment,t),la=d(t),Rt=i(t,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-16m1u76"&&(Rt.textContent=si),ra=d(t),zt=i(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-698ey0"&&(zt.innerHTML=ui),aa=d(t),kt=i(t,"P",{"data-svelte-h":!0}),s(kt)!=="svelte-tjke50"&&(kt.innerHTML=ni),da=d(t),Kt=i(t,"UL",{"data-svelte-h":!0}),s(Kt)!=="svelte-1iua3xn"&&(Kt.innerHTML=mi),oa=d(t),ia=i(t,"HR",{}),sa=d(t),Ot=i(t,"A",{id:!0,class:!0}),n(Ot).forEach(e),ua=d(t),f(Bt.$$.fragment,t),na=d(t),Dt=i(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-1fz4yns"&&(Dt.innerHTML=fi),ma=d(t),It=i(t,"UL",{"data-svelte-h":!0}),s(It)!=="svelte-ph0ovr"&&(It.innerHTML=pi),fa=d(t),jt=i(t,"TABLE",{"data-svelte-h":!0}),s(jt)!=="svelte-a5vdxc"&&(jt.innerHTML=hi),pa=d(t),ha=i(t,"HR",{}),ca=d(t),qt=i(t,"A",{id:!0,class:!0}),n(qt).forEach(e),Ta=d(t),f(Ut.$$.fragment,t),ya=d(t),St=i(t,"P",{"data-svelte-h":!0}),s(St)!=="svelte-1rrw4ya"&&(St.innerHTML=ci),va=d(t),Nt=i(t,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1gdnoew"&&(Nt.innerHTML=Ti),Fa=d(t),_a=i(t,"HR",{}),ba=d(t),Gt=i(t,"A",{id:!0,class:!0}),n(Gt).forEach(e),xa=d(t),f(Jt.$$.fragment,t),$a=d(t),Qt=i(t,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-1693r4v"&&(Qt.textContent=yi),Aa=d(t),Vt=i(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-33y4ax"&&(Vt.innerHTML=vi),Pa=d(t),Wt=i(t,"TABLE",{"data-svelte-h":!0}),s(Wt)!=="svelte-1td0xj2"&&(Wt.innerHTML=Fi),Ca=d(t),Ha=i(t,"HR",{}),La=d(t),Xt=i(t,"A",{id:!0,class:!0}),n(Xt).forEach(e),Ma=d(t),f(Yt.$$.fragment,t),wa=d(t),Zt=i(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-rsnsrd"&&(Zt.textContent=_i),ga=d(t),te=i(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1xayhm7"&&(te.innerHTML=bi),Ea=d(t),ee=i(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-1up5toh"&&(ee.innerHTML=xi),Ra=d(t),za=i(t,"HR",{}),ka=d(t),le=i(t,"A",{id:!0,class:!0}),n(le).forEach(e),Ka=d(t),f(re.$$.fragment,t),Oa=d(t),ae=i(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-id49q5"&&(ae.textContent=$i),Ba=d(t),de=i(t,"P",{"data-svelte-h":!0}),s(de)!=="svelte-1dkdszr"&&(de.innerHTML=Ai),Da=d(t),oe=i(t,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-15tum1z"&&(oe.innerHTML=Pi),Ia=d(t),ja=i(t,"HR",{}),qa=d(t),ie=i(t,"A",{id:!0,class:!0}),n(ie).forEach(e),Ua=d(t),f(se.$$.fragment,t),Sa=d(t),ue=i(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-846pp1"&&(ue.textContent=Ci),Na=d(t),ne=i(t,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-1t2xajz"&&(ne.innerHTML=Hi),Ga=d(t),me=i(t,"UL",{"data-svelte-h":!0}),s(me)!=="svelte-173tqd8"&&(me.innerHTML=Li),Ja=d(t),fe=i(t,"TABLE",{"data-svelte-h":!0}),s(fe)!=="svelte-1buvx7j"&&(fe.innerHTML=Mi),Qa=d(t),Va=i(t,"HR",{}),Wa=d(t),pe=i(t,"A",{id:!0,class:!0}),n(pe).forEach(e),Xa=d(t),f(he.$$.fragment,t),Ya=d(t),ce=i(t,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-ozshoc"&&(ce.textContent=wi),Za=d(t),Te=i(t,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-1t2xajz"&&(Te.innerHTML=gi),td=d(t),ye=i(t,"UL",{"data-svelte-h":!0}),s(ye)!=="svelte-1ap3720"&&(ye.innerHTML=Ei),ed=d(t),ve=i(t,"TABLE",{"data-svelte-h":!0}),s(ve)!=="svelte-lghmn6"&&(ve.innerHTML=Ri),ld=d(t),rd=i(t,"HR",{}),ad=d(t),Fe=i(t,"A",{id:!0,class:!0}),n(Fe).forEach(e),dd=d(t),f(_e.$$.fragment,t),od=d(t),be=i(t,"P",{"data-svelte-h":!0}),s(be)!=="svelte-ijignt"&&(be.innerHTML=zi),id=d(t),xe=i(t,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-1t2xajz"&&(xe.innerHTML=ki),sd=d(t),$e=i(t,"UL",{"data-svelte-h":!0}),s($e)!=="svelte-1bp21xg"&&($e.innerHTML=Ki),ud=d(t),Ae=i(t,"TABLE",{"data-svelte-h":!0}),s(Ae)!=="svelte-edt5vq"&&(Ae.innerHTML=Oi),nd=d(t),md=i(t,"HR",{}),fd=d(t),Pe=i(t,"A",{id:!0,class:!0}),n(Pe).forEach(e),pd=d(t),f(Ce.$$.fragment,t),hd=d(t),He=i(t,"P",{"data-svelte-h":!0}),s(He)!=="svelte-3r4wxn"&&(He.textContent=Bi),cd=d(t),Le=i(t,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-1dkdszr"&&(Le.innerHTML=Di),Td=d(t),Me=i(t,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-15z8087"&&(Me.innerHTML=Ii),yd=d(t),vd=i(t,"HR",{}),Fd=d(t),we=i(t,"A",{id:!0,class:!0}),n(we).forEach(e),_d=d(t),f(ge.$$.fragment,t),bd=d(t),Ee=i(t,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1jz5wqp"&&(Ee.textContent=ji),xd=d(t),Re=i(t,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1dkdszr"&&(Re.innerHTML=qi),$d=d(t),ze=i(t,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-fx5ob"&&(ze.innerHTML=Ui),Ad=d(t),Pd=i(t,"HR",{}),Cd=d(t),ke=i(t,"A",{id:!0,class:!0}),n(ke).forEach(e),Hd=d(t),f(Ke.$$.fragment,t),Ld=d(t),Oe=i(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1baynqa"&&(Oe.textContent=Si),Md=d(t),Be=i(t,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1dkdszr"&&(Be.innerHTML=Ni),wd=d(t),De=i(t,"TABLE",{"data-svelte-h":!0}),s(De)!=="svelte-szv30n"&&(De.innerHTML=Gi),gd=d(t),Ed=i(t,"HR",{}),Rd=d(t),Ie=i(t,"A",{id:!0,class:!0}),n(Ie).forEach(e),zd=d(t),f(je.$$.fragment,t),kd=d(t),qe=i(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1gll44b"&&(qe.textContent=Ji),Kd=d(t),Ue=i(t,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1dkdszr"&&(Ue.innerHTML=Qi),Od=d(t),Se=i(t,"TABLE",{"data-svelte-h":!0}),s(Se)!=="svelte-159qhrx"&&(Se.innerHTML=Vi),Bd=d(t),Dd=i(t,"HR",{}),Id=d(t),Ne=i(t,"A",{id:!0,class:!0}),n(Ne).forEach(e),jd=d(t),f(Ge.$$.fragment,t),qd=d(t),Je=i(t,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1upf1p8"&&(Je.textContent=Wi),Ud=d(t),Qe=i(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1dkdszr"&&(Qe.innerHTML=Xi),Sd=d(t),Ve=i(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-18nciet"&&(Ve.innerHTML=Yi),Nd=d(t),Gd=i(t,"HR",{}),Jd=d(t),We=i(t,"A",{id:!0,class:!0}),n(We).forEach(e),Qd=d(t),f(Xe.$$.fragment,t),Vd=d(t),Ye=i(t,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-8fqhv2"&&(Ye.textContent=Zi),Wd=d(t),Ze=i(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1dkdszr"&&(Ze.innerHTML=ts),Xd=d(t),tl=i(t,"TABLE",{"data-svelte-h":!0}),s(tl)!=="svelte-pf887e"&&(tl.innerHTML=es),Yd=d(t),Zd=i(t,"HR",{}),to=d(t),el=i(t,"A",{id:!0,class:!0}),n(el).forEach(e),eo=d(t),f(ll.$$.fragment,t),lo=d(t),rl=i(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-yw51a0"&&(rl.textContent=ls),ro=d(t),al=i(t,"P",{"data-svelte-h":!0}),s(al)!=="svelte-1gw6hta"&&(al.innerHTML=rs),ao=d(t),dl=i(t,"P",{"data-svelte-h":!0}),s(dl)!=="svelte-tjke50"&&(dl.innerHTML=as),oo=d(t),io=i(t,"HR",{}),so=d(t),ol=i(t,"A",{id:!0,class:!0}),n(ol).forEach(e),uo=d(t),f(il.$$.fragment,t),no=d(t),sl=i(t,"P",{"data-svelte-h":!0}),s(sl)!=="svelte-lvoqsi"&&(sl.textContent=ds),mo=d(t),ul=i(t,"TABLE",{"data-svelte-h":!0}),s(ul)!=="svelte-1gtay08"&&(ul.innerHTML=os),fo=d(t),po=i(t,"HR",{}),ho=d(t),nl=i(t,"A",{id:!0,class:!0}),n(nl).forEach(e),co=d(t),f(ml.$$.fragment,t),To=d(t),fl=i(t,"P",{"data-svelte-h":!0}),s(fl)!=="svelte-9rr3v5"&&(fl.innerHTML=is),yo=d(t),vo=i(t,"HR",{}),Fo=d(t),hl=i(t,"P",{}),n(hl).forEach(e),this.h()},h(){u(v,"name","hf:doc:metadata"),u(v,"content",Ts),u(F,"id","module_utils/maths"),u(F,"class","group"),u(A,"id","module_utils/maths.interpolate_data"),u(A,"class","group"),u(L,"id","module_utils/maths.transpose_data"),u(L,"class","group"),u(R,"id","module_utils/maths.softmax"),u(R,"class","group"),u(B,"id","module_utils/maths.log_softmax"),u(B,"class","group"),u(U,"id","module_utils/maths.dot"),u(U,"class","group"),u(Q,"id","module_utils/maths.getTopItems"),u(Q,"class","group"),u(Z,"id","module_utils/maths.cos_sim"),u(Z,"class","group"),u(at,"id","module_utils/maths.magnitude"),u(at,"class","group"),u(ut,"id","module_utils/maths.min"),u(ut,"class","group"),u(ct,"id","module_utils/maths.max"),u(ct,"class","group"),u(bt,"id","module_utils/maths.medianFilter"),u(bt,"class","group"),u(Ct,"id","module_utils/maths.round"),u(Ct,"class","group"),u(gt,"id","module_utils/maths..P2FFT"),u(gt,"class","group"),u(Ot,"id","new_module_utils/maths..P2FFT_new"),u(Ot,"class","group"),u(qt,"id","module_utils/maths..P2FFT+createComplexArray"),u(qt,"class","group"),u(Gt,"id","module_utils/maths..P2FFT+fromComplexArray"),u(Gt,"class","group"),u(Xt,"id","module_utils/maths..P2FFT+toComplexArray"),u(Xt,"class","group"),u(le,"id","module_utils/maths..P2FFT+completeSpectrum"),u(le,"class","group"),u(ie,"id","module_utils/maths..P2FFT+transform"),u(ie,"class","group"),u(pe,"id","module_utils/maths..P2FFT+realTransform"),u(pe,"class","group"),u(Fe,"id","module_utils/maths..P2FFT+inverseTransform"),u(Fe,"class","group"),u(Pe,"id","module_utils/maths..P2FFT+_transform4"),u(Pe,"class","group"),u(we,"id","module_utils/maths..P2FFT+_singleTransform2"),u(we,"class","group"),u(ke,"id","module_utils/maths..P2FFT+_singleTransform4"),u(ke,"class","group"),u(Ie,"id","module_utils/maths..P2FFT+_realTransform4"),u(Ie,"class","group"),u(Ne,"id","module_utils/maths..P2FFT+_singleRealTransform2"),u(Ne,"class","group"),u(We,"id","module_utils/maths..P2FFT+_singleRealTransform4"),u(We,"class","group"),u(el,"id","module_utils/maths..NP2FFT"),u(el,"class","group"),u(ol,"id","new_module_utils/maths..NP2FFT_new"),u(ol,"class","group"),u(nl,"id","module_utils/maths..AnyTypedArray"),u(nl,"class","group")},m(t,l){hs(document.head,v),r(t,cl,l),r(t,pl,l),r(t,Tl,l),r(t,F,l),r(t,yl,l),p(_,t,l),r(t,vl,l),r(t,b,l),r(t,Fl,l),r(t,x,l),r(t,_l,l),r(t,$,l),r(t,bl,l),r(t,xl,l),r(t,$l,l),r(t,A,l),r(t,Al,l),p(P,t,l),r(t,Pl,l),r(t,C,l),r(t,Cl,l),r(t,H,l),r(t,Hl,l),r(t,Ll,l),r(t,Ml,l),r(t,L,l),r(t,wl,l),p(M,t,l),r(t,gl,l),r(t,w,l),r(t,El,l),r(t,g,l),r(t,Rl,l),r(t,E,l),r(t,zl,l),r(t,kl,l),r(t,Kl,l),r(t,R,l),r(t,Ol,l),p(z,t,l),r(t,Bl,l),r(t,k,l),r(t,Dl,l),r(t,K,l),r(t,Il,l),r(t,O,l),r(t,jl,l),r(t,ql,l),r(t,Ul,l),r(t,B,l),r(t,Sl,l),p(D,t,l),r(t,Nl,l),r(t,I,l),r(t,Gl,l),r(t,j,l),r(t,Jl,l),r(t,q,l),r(t,Ql,l),r(t,Vl,l),r(t,Wl,l),r(t,U,l),r(t,Xl,l),p(S,t,l),r(t,Yl,l),r(t,N,l),r(t,Zl,l),r(t,G,l),r(t,tr,l),r(t,J,l),r(t,er,l),r(t,lr,l),r(t,rr,l),r(t,Q,l),r(t,ar,l),p(V,t,l),r(t,dr,l),r(t,W,l),r(t,or,l),r(t,X,l),r(t,ir,l),r(t,Y,l),r(t,sr,l),r(t,ur,l),r(t,nr,l),r(t,Z,l),r(t,mr,l),p(tt,t,l),r(t,fr,l),r(t,et,l),r(t,pr,l),r(t,lt,l),r(t,hr,l),r(t,rt,l),r(t,cr,l),r(t,Tr,l),r(t,yr,l),r(t,at,l),r(t,vr,l),p(dt,t,l),r(t,Fr,l),r(t,ot,l),r(t,_r,l),r(t,it,l),r(t,br,l),r(t,st,l),r(t,xr,l),r(t,$r,l),r(t,Ar,l),r(t,ut,l),r(t,Pr,l),p(nt,t,l),r(t,Cr,l),r(t,mt,l),r(t,Hr,l),r(t,ft,l),r(t,Lr,l),r(t,pt,l),r(t,Mr,l),r(t,ht,l),r(t,wr,l),r(t,gr,l),r(t,Er,l),r(t,ct,l),r(t,Rr,l),p(Tt,t,l),r(t,zr,l),r(t,yt,l),r(t,kr,l),r(t,vt,l),r(t,Kr,l),r(t,Ft,l),r(t,Or,l),r(t,_t,l),r(t,Br,l),r(t,Dr,l),r(t,Ir,l),r(t,bt,l),r(t,jr,l),p(xt,t,l),r(t,qr,l),r(t,$t,l),r(t,Ur,l),r(t,At,l),r(t,Sr,l),r(t,Pt,l),r(t,Nr,l),r(t,Gr,l),r(t,Jr,l),r(t,Ct,l),r(t,Qr,l),p(Ht,t,l),r(t,Vr,l),r(t,Lt,l),r(t,Wr,l),r(t,Mt,l),r(t,Xr,l),r(t,wt,l),r(t,Yr,l),r(t,Zr,l),r(t,ta,l),r(t,gt,l),r(t,ea,l),p(Et,t,l),r(t,la,l),r(t,Rt,l),r(t,ra,l),r(t,zt,l),r(t,aa,l),r(t,kt,l),r(t,da,l),r(t,Kt,l),r(t,oa,l),r(t,ia,l),r(t,sa,l),r(t,Ot,l),r(t,ua,l),p(Bt,t,l),r(t,na,l),r(t,Dt,l),r(t,ma,l),r(t,It,l),r(t,fa,l),r(t,jt,l),r(t,pa,l),r(t,ha,l),r(t,ca,l),r(t,qt,l),r(t,Ta,l),p(Ut,t,l),r(t,ya,l),r(t,St,l),r(t,va,l),r(t,Nt,l),r(t,Fa,l),r(t,_a,l),r(t,ba,l),r(t,Gt,l),r(t,xa,l),p(Jt,t,l),r(t,$a,l),r(t,Qt,l),r(t,Aa,l),r(t,Vt,l),r(t,Pa,l),r(t,Wt,l),r(t,Ca,l),r(t,Ha,l),r(t,La,l),r(t,Xt,l),r(t,Ma,l),p(Yt,t,l),r(t,wa,l),r(t,Zt,l),r(t,ga,l),r(t,te,l),r(t,Ea,l),r(t,ee,l),r(t,Ra,l),r(t,za,l),r(t,ka,l),r(t,le,l),r(t,Ka,l),p(re,t,l),r(t,Oa,l),r(t,ae,l),r(t,Ba,l),r(t,de,l),r(t,Da,l),r(t,oe,l),r(t,Ia,l),r(t,ja,l),r(t,qa,l),r(t,ie,l),r(t,Ua,l),p(se,t,l),r(t,Sa,l),r(t,ue,l),r(t,Na,l),r(t,ne,l),r(t,Ga,l),r(t,me,l),r(t,Ja,l),r(t,fe,l),r(t,Qa,l),r(t,Va,l),r(t,Wa,l),r(t,pe,l),r(t,Xa,l),p(he,t,l),r(t,Ya,l),r(t,ce,l),r(t,Za,l),r(t,Te,l),r(t,td,l),r(t,ye,l),r(t,ed,l),r(t,ve,l),r(t,ld,l),r(t,rd,l),r(t,ad,l),r(t,Fe,l),r(t,dd,l),p(_e,t,l),r(t,od,l),r(t,be,l),r(t,id,l),r(t,xe,l),r(t,sd,l),r(t,$e,l),r(t,ud,l),r(t,Ae,l),r(t,nd,l),r(t,md,l),r(t,fd,l),r(t,Pe,l),r(t,pd,l),p(Ce,t,l),r(t,hd,l),r(t,He,l),r(t,cd,l),r(t,Le,l),r(t,Td,l),r(t,Me,l),r(t,yd,l),r(t,vd,l),r(t,Fd,l),r(t,we,l),r(t,_d,l),p(ge,t,l),r(t,bd,l),r(t,Ee,l),r(t,xd,l),r(t,Re,l),r(t,$d,l),r(t,ze,l),r(t,Ad,l),r(t,Pd,l),r(t,Cd,l),r(t,ke,l),r(t,Hd,l),p(Ke,t,l),r(t,Ld,l),r(t,Oe,l),r(t,Md,l),r(t,Be,l),r(t,wd,l),r(t,De,l),r(t,gd,l),r(t,Ed,l),r(t,Rd,l),r(t,Ie,l),r(t,zd,l),p(je,t,l),r(t,kd,l),r(t,qe,l),r(t,Kd,l),r(t,Ue,l),r(t,Od,l),r(t,Se,l),r(t,Bd,l),r(t,Dd,l),r(t,Id,l),r(t,Ne,l),r(t,jd,l),p(Ge,t,l),r(t,qd,l),r(t,Je,l),r(t,Ud,l),r(t,Qe,l),r(t,Sd,l),r(t,Ve,l),r(t,Nd,l),r(t,Gd,l),r(t,Jd,l),r(t,We,l),r(t,Qd,l),p(Xe,t,l),r(t,Vd,l),r(t,Ye,l),r(t,Wd,l),r(t,Ze,l),r(t,Xd,l),r(t,tl,l),r(t,Yd,l),r(t,Zd,l),r(t,to,l),r(t,el,l),r(t,eo,l),p(ll,t,l),r(t,lo,l),r(t,rl,l),r(t,ro,l),r(t,al,l),r(t,ao,l),r(t,dl,l),r(t,oo,l),r(t,io,l),r(t,so,l),r(t,ol,l),r(t,uo,l),p(il,t,l),r(t,no,l),r(t,sl,l),r(t,mo,l),r(t,ul,l),r(t,fo,l),r(t,po,l),r(t,ho,l),r(t,nl,l),r(t,co,l),p(ml,t,l),r(t,To,l),r(t,fl,l),r(t,yo,l),r(t,vo,l),r(t,Fo,l),r(t,hl,l),_o=!0},p:us,i(t){_o||(h(_.$$.fragment,t),h(P.$$.fragment,t),h(M.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(S.$$.fragment,t),h(V.$$.fragment,t),h(tt.$$.fragment,t),h(dt.$$.fragment,t),h(nt.$$.fragment,t),h(Tt.$$.fragment,t),h(xt.$$.fragment,t),h(Ht.$$.fragment,t),h(Et.$$.fragment,t),h(Bt.$$.fragment,t),h(Ut.$$.fragment,t),h(Jt.$$.fragment,t),h(Yt.$$.fragment,t),h(re.$$.fragment,t),h(se.$$.fragment,t),h(he.$$.fragment,t),h(_e.$$.fragment,t),h(Ce.$$.fragment,t),h(ge.$$.fragment,t),h(Ke.$$.fragment,t),h(je.$$.fragment,t),h(Ge.$$.fragment,t),h(Xe.$$.fragment,t),h(ll.$$.fragment,t),h(il.$$.fragment,t),h(ml.$$.fragment,t),_o=!0)},o(t){c(_.$$.fragment,t),c(P.$$.fragment,t),c(M.$$.fragment,t),c(z.$$.fragment,t),c(D.$$.fragment,t),c(S.$$.fragment,t),c(V.$$.fragment,t),c(tt.$$.fragment,t),c(dt.$$.fragment,t),c(nt.$$.fragment,t),c(Tt.$$.fragment,t),c(xt.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(Bt.$$.fragment,t),c(Ut.$$.fragment,t),c(Jt.$$.fragment,t),c(Yt.$$.fragment,t),c(re.$$.fragment,t),c(se.$$.fragment,t),c(he.$$.fragment,t),c(_e.$$.fragment,t),c(Ce.$$.fragment,t),c(ge.$$.fragment,t),c(Ke.$$.fragment,t),c(je.$$.fragment,t),c(Ge.$$.fragment,t),c(Xe.$$.fragment,t),c(ll.$$.fragment,t),c(il.$$.fragment,t),c(ml.$$.fragment,t),_o=!1},d(t){t&&(e(cl),e(pl),e(Tl),e(F),e(yl),e(vl),e(b),e(Fl),e(x),e(_l),e($),e(bl),e(xl),e($l),e(A),e(Al),e(Pl),e(C),e(Cl),e(H),e(Hl),e(Ll),e(Ml),e(L),e(wl),e(gl),e(w),e(El),e(g),e(Rl),e(E),e(zl),e(kl),e(Kl),e(R),e(Ol),e(Bl),e(k),e(Dl),e(K),e(Il),e(O),e(jl),e(ql),e(Ul),e(B),e(Sl),e(Nl),e(I),e(Gl),e(j),e(Jl),e(q),e(Ql),e(Vl),e(Wl),e(U),e(Xl),e(Yl),e(N),e(Zl),e(G),e(tr),e(J),e(er),e(lr),e(rr),e(Q),e(ar),e(dr),e(W),e(or),e(X),e(ir),e(Y),e(sr),e(ur),e(nr),e(Z),e(mr),e(fr),e(et),e(pr),e(lt),e(hr),e(rt),e(cr),e(Tr),e(yr),e(at),e(vr),e(Fr),e(ot),e(_r),e(it),e(br),e(st),e(xr),e($r),e(Ar),e(ut),e(Pr),e(Cr),e(mt),e(Hr),e(ft),e(Lr),e(pt),e(Mr),e(ht),e(wr),e(gr),e(Er),e(ct),e(Rr),e(zr),e(yt),e(kr),e(vt),e(Kr),e(Ft),e(Or),e(_t),e(Br),e(Dr),e(Ir),e(bt),e(jr),e(qr),e($t),e(Ur),e(At),e(Sr),e(Pt),e(Nr),e(Gr),e(Jr),e(Ct),e(Qr),e(Vr),e(Lt),e(Wr),e(Mt),e(Xr),e(wt),e(Yr),e(Zr),e(ta),e(gt),e(ea),e(la),e(Rt),e(ra),e(zt),e(aa),e(kt),e(da),e(Kt),e(oa),e(ia),e(sa),e(Ot),e(ua),e(na),e(Dt),e(ma),e(It),e(fa),e(jt),e(pa),e(ha),e(ca),e(qt),e(Ta),e(ya),e(St),e(va),e(Nt),e(Fa),e(_a),e(ba),e(Gt),e(xa),e($a),e(Qt),e(Aa),e(Vt),e(Pa),e(Wt),e(Ca),e(Ha),e(La),e(Xt),e(Ma),e(wa),e(Zt),e(ga),e(te),e(Ea),e(ee),e(Ra),e(za),e(ka),e(le),e(Ka),e(Oa),e(ae),e(Ba),e(de),e(Da),e(oe),e(Ia),e(ja),e(qa),e(ie),e(Ua),e(Sa),e(ue),e(Na),e(ne),e(Ga),e(me),e(Ja),e(fe),e(Qa),e(Va),e(Wa),e(pe),e(Xa),e(Ya),e(ce),e(Za),e(Te),e(td),e(ye),e(ed),e(ve),e(ld),e(rd),e(ad),e(Fe),e(dd),e(od),e(be),e(id),e(xe),e(sd),e($e),e(ud),e(Ae),e(nd),e(md),e(fd),e(Pe),e(pd),e(hd),e(He),e(cd),e(Le),e(Td),e(Me),e(yd),e(vd),e(Fd),e(we),e(_d),e(bd),e(Ee),e(xd),e(Re),e($d),e(ze),e(Ad),e(Pd),e(Cd),e(ke),e(Hd),e(Ld),e(Oe),e(Md),e(Be),e(wd),e(De),e(gd),e(Ed),e(Rd),e(Ie),e(zd),e(kd),e(qe),e(Kd),e(Ue),e(Od),e(Se),e(Bd),e(Dd),e(Id),e(Ne),e(jd),e(qd),e(Je),e(Ud),e(Qe),e(Sd),e(Ve),e(Nd),e(Gd),e(Jd),e(We),e(Qd),e(Vd),e(Ye),e(Wd),e(Ze),e(Xd),e(tl),e(Yd),e(Zd),e(to),e(el),e(eo),e(lo),e(rl),e(ro),e(al),e(ao),e(dl),e(oo),e(io),e(so),e(ol),e(uo),e(no),e(sl),e(mo),e(ul),e(fo),e(po),e(ho),e(nl),e(co),e(To),e(fl),e(yo),e(vo),e(Fo),e(hl)),e(v),T(_,t),T(P,t),T(M,t),T(z,t),T(D,t),T(S,t),T(V,t),T(tt,t),T(dt,t),T(nt,t),T(Tt,t),T(xt,t),T(Ht,t),T(Et,t),T(Bt,t),T(Ut,t),T(Jt,t),T(Yt,t),T(re,t),T(se,t),T(he,t),T(_e,t),T(Ce,t),T(ge,t),T(Ke,t),T(je,t),T(Ge,t),T(Xe,t),T(ll,t),T(il,t),T(ml,t)}}}const Ts='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.transpose_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathstransposedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathssoftmaxarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> any </code>","local":"utilsmathslogsoftmaxarr--code-any-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.getTopItems(items, [top_k]) ⇒ <code> Array </code>","local":"utilsmathsgettopitemsitems-topk--code-array-code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsmaxarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths~P2FFT","local":"utilsmathsp2fft","sections":[{"title":"new P2FFT(size)","local":"new-p2fftsize","sections":[],"depth":3},{"title":"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>","local":"p2fftcreatecomplexarray--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"p2fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>","local":"p2ffttocomplexarrayinput-storage--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>","local":"p2fftcompletespectrumspectrum--code-void-code","sections":[],"depth":3},{"title":"p2FFT.transform(out, data) ⇒ <code> void </code>","local":"p2ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT.realTransform(out, data)","local":"p2fftrealtransformout-data","sections":[],"depth":3},{"title":"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>","local":"p2fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>","local":"p2ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._realTransform4(out, data, inv)","local":"p2fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"p2fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~NP2FFT","local":"utilsmathsnp2fft","sections":[{"title":"new NP2FFT(fft_length)","local":"new-np2fftfftlength","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function ys(bo){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends ms{constructor(v){super(),fs(this,v,ys,cs,ss,{})}}export{bs as component};
