import{s as Ym,n as Fm,o as Om}from"../chunks/scheduler.b108d059.js";import{S as Gm,i as Zm,g as i,s as n,r as u,A as Xm,h as r,f as l,c as o,j as h,u as m,x as d,k as a,y as ep,a as s,v as p,d as c,t as f,w as T}from"../chunks/index.008de539.js";import{C as Aa}from"../chunks/CodeBlock.3968c746.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function tp(Ua){let $,Us,ws,gs,y,Ps,v,Rs,M,ga="Helper module for <code>Tensor</code> processing.",zs,b,Pa=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,Js,x,Ra='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.transpose"><code>.transpose(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒</li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',js,Es,ks,C,Ds,H,Is,L,za='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',qs,w,Ja='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',Ns,Vs,Bs,A,Ks,U,Qs,g,ja="Create a new Tensor or copy an existing Tensor.",Ss,P,Ea="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",Ws,Ys,Fs,R,Os,z,Gs,J,ka=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,Zs,j,Da='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',Xs,en,tn,E,ln,k,sn,D,Ia="Index into a Tensor object.",nn,I,qa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',on,q,Na="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",rn,dn,an,N,un,V,mn,B,Va='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',pn,K,Ba="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",cn,fn,Tn,Q,hn,S,_n,W,Ka='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',$n,Y,Qa="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",yn,vn,Mn,F,bn,O,xn,G,Sa=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Cn,Z,Wa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',Hn,X,Ya="<li><code>Error</code> If the tensor has more than one element.</li>",Ln,wn,An,ee,Un,te,gn,le,Fa="Convert tensor data to a n-dimensional JS list",Pn,se,Oa='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Rn,zn,Jn,ne,jn,oe,En,ie,Ga="Return a new Tensor with the sigmoid function applied to each element.",kn,re,Za='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Dn,In,qn,de,Nn,ae,Vn,ue,Xa="Applies the sigmoid function to the tensor in place.",Bn,me,eu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Kn,Qn,Sn,pe,Wn,ce,Yn,fe,tu="Return a new Tensor with every element multiplied by a constant.",Fn,Te,lu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',On,he,su="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Gn,Zn,Xn,_e,eo,$e,to,ye,nu="Multiply the tensor by a constant in place.",lo,ve,ou='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',so,Me,iu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",no,oo,io,be,ro,xe,ao,Ce,ru="Return a new Tensor with every element added by a constant.",uo,He,du='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',mo,Le,au="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",po,co,fo,we,To,Ae,ho,Ue,uu="Add the tensor by a constant in place.",_o,ge,mu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',$o,Pe,pu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",yo,vo,Mo,Re,bo,ze,xo,Je,cu="Return a transposed version of this Tensor, according to the provided dimensions.",Co,je,fu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',Ho,Ee,Tu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to transpose.</p></td></tr></tbody>",Lo,wo,Ao,ke,Uo,De,go,Ie,hu="Returns the sum of each row of the input tensor in the given dimension dim.",Po,qe,_u='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',Ro,Ne,$u="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",zo,Jo,jo,Ve,Eo,Be,ko,Ke,yu="Returns the matrix norm or vector norm of a given tensor.",Do,Qe,vu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Io,Se,Mu=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,qo,No,Vo,We,Bo,Ye,Ko,Fe,bu="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Qo,Oe,xu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',So,Ge,Cu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Wo,Yo,Fo,Ze,Oo,Xe,Go,et,Hu="Performs <code>L_p</code> normalization of inputs over specified dimension.",Zo,tt,Lu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',Xo,lt,wu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",ei,ti,li,st,si,nt,ni,ot,Au=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,oi,it,Uu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',ii,ri,di,rt,ai,dt,ui,at,gu="Returns a tensor with all specified dimensions of input of size 1 removed.",mi,ut,Pu=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,pi,mt,Ru='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The squeezed tensor',ci,pt,zu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",fi,Ti,hi,ct,_i,ft,$i,Tt,Ju='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',yi,ht,ju='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',vi,Mi,bi,_t,xi,$t,Ci,yt,Eu="Returns a new tensor with a dimension of size one inserted at the specified position.",Hi,vt,ku="NOTE: The returned tensor shares the same underlying data with this tensor.",Li,Mt,Du='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The unsqueezed tensor',wi,bt,Iu="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",Ai,Ui,gi,xt,Pi,Ct,Ri,Ht,qu='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',zi,Lt,Nu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Ji,ji,Ei,wt,ki,At,Di,Ut,Vu='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Ii,gt,Bu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',qi,Ni,Vi,Pt,Bi,Rt,Ki,zt,Ku=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Qi,Jt,Qu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The flattened tensor.',Si,jt,Su="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Wi,Yi,Fi,Et,Oi,kt,Gi,Dt,Wu="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Zi,It,Yu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',Xi,qt,Fu="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",er,tr,lr,Nt,sr,Vt,nr,Bt,Ou='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',or,Kt,Gu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ir,rr,dr,Qt,ar,St,ur,Wt,Zu="Clamps all elements in input into the range [ min, max ]",mr,Yt,Xu='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',pr,Ft,em="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",cr,fr,Tr,Ot,hr,Gt,_r,Zt,tm='In-place version of @see <a href="Tensor.round">Tensor.round</a>',$r,Xt,lm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',yr,vr,Mr,el,br,tl,xr,ll,sm="Rounds elements of input to the nearest integer.",Cr,sl,nm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',Hr,Lr,wr,nl,Ar,ol,Ur,il,om="Performs Tensor dtype conversion.",gr,rl,im='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',Pr,dl,rm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>type</td><td><code>&#39;bool&#39;</code> | <code>&#39;float32&#39;</code> | <code>&#39;float64&#39;</code> | <code>&#39;string&#39;</code> | <code>&#39;int8&#39;</code> | <code>&#39;uint8&#39;</code> | <code>&#39;int16&#39;</code> | <code>&#39;uint16&#39;</code> | <code>&#39;int32&#39;</code> | <code>&#39;uint32&#39;</code> | <code>&#39;int64&#39;</code></td></tr></tbody>",Rr,zr,Jr,al,jr,ul,Er,ml,dm="Transposes a tensor according to the provided axes.",kr,pl,am='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',Dr,cl,um="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to transpose.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to transpose the tensor along.</p></td></tr></tbody>",Ir,qr,Nr,fl,Vr,Tl,Br,hl,mm="Interpolates an Tensor to the given size.",Kr,_l,pm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Qr,$l,cm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Sr,Wr,Yr,yl,Fr,vl,Or,Ml,fm="Perform mean pooling of the last hidden state followed by a normalization step.",Gr,bl,Tm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',Zr,xl,hm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",Xr,ed,td,Cl,ld,Hl,sd,Ll,_m="Concatenates an array of tensors along a specified dimension.",nd,wl,$m='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',od,Al,ym="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",id,rd,dd,Ul,ad,gl,ud,Pl,vm="Stack an array of tensors along a specified dimension.",md,Rl,Mm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',pd,zl,bm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",cd,fd,Td,Jl,hd,jl,_d,El,xm="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",$d,kl,Cm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',yd,Dl,Hm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",vd,Md,bd,Il,xd,ql,Cd,Nl,Lm="Returns the mean value of each row of the input tensor in the given dimension dim.",Hd,Vl,wm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: A new tensor with means taken along the specified dimension.',Ld,Bl,Am="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",wd,Ad,Ud,Kl,gd,Ql,Pd,Sl,Um=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,Rd,Wl,gm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',zd,Yl,Pm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",Jd,jd,Ed,Fl,kd,Ol,Dd,Gl,Rm="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Id,Zl,zm='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',qd,Xl,Jm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Nd,Vd,Bd,es,Kd,ts,Qd,ls,jm="Returns a tensor filled with the scalar value 1, with the same size as input.",Sd,ss,Em='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: The ones tensor.',Wd,ns,km="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",Yd,Fd,Od,os,Gd,is,Zd,rs,Dm="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",Xd,ds,Im='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',ea,as,qm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array.&lt;T&gt;</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",ta,us,Nm="<strong>Example</strong>",la,ms,sa,na,oa,ps,ia,cs,ra,fs,Vm='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',da,aa,ua,Ts,ma,hs,pa,_s,Bm='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',ca,fa,Ta,$s,ha,ys,_a,vs,Km="This creates a nested array of a given type and depth (see examples).",$a,Ms,Qm='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',ya,bs,va,xs,Sm="<strong>Example</strong>",Ma,Cs,ba,Hs,Wm="<strong>Example</strong>",xa,Ls,Ca,Ha,La,As,wa;return v=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),U=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),z=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),k=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),V=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),S=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),O=new _({props:{title:"tensor.item() ⇒ <code> number </code>",local:"tensoritem--code-number-code",headingTag:"h3"}}),te=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),oe=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ae=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ce=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),$e=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),xe=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Ae=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),ze=new _({props:{title:"tensor.transpose(...dims) ⇒ <code> Tensor </code>",local:"tensortransposedims--code-tensor-code",headingTag:"h3"}}),De=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),Be=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),Ye=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Xe=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),nt=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),dt=new _({props:{title:"tensor.squeeze([dim]) ⇒",local:"tensorsqueezedim-",headingTag:"h3"}}),ft=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),$t=new _({props:{title:"tensor.unsqueeze(dim) ⇒",local:"tensorunsqueezedim-",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),At=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Rt=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒",local:"tensorflattenstartdim-enddim-",headingTag:"h3"}}),kt=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),St=new _({props:{title:"tensor.clamp(min, max) ⇒",local:"tensorclampmin-max-",headingTag:"h3"}}),Gt=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),tl=new _({props:{title:"tensor.round() ⇒",local:"tensorround-",headingTag:"h3"}}),ol=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),ul=new _({props:{title:"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensortransposetensor-axes--code-tensor-code",headingTag:"h2"}}),Tl=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),vl=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Hl=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),gl=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),jl=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),ql=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒",local:"utilstensormeaninput-dim-keepdim-",headingTag:"h2"}}),Ql=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),Ol=new _({props:{title:"utils/tensor.ones(size)",local:"utilstensoronessize",headingTag:"h2"}}),ts=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒",local:"utilstensoronesliketensor-",headingTag:"h2"}}),is=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),ms=new Aa({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),cs=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),hs=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),ys=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),bs=new Aa({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Cs=new Aa({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Ls=new Aa({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),{c(){$=i("meta"),Us=n(),ws=i("p"),gs=n(),y=i("a"),Ps=n(),u(v.$$.fragment),Rs=n(),M=i("p"),M.innerHTML=ga,zs=n(),b=i("p"),b.textContent=Pa,Js=n(),x=i("ul"),x.innerHTML=Ra,js=n(),Es=i("hr"),ks=n(),C=i("a"),Ds=n(),u(H.$$.fragment),Is=n(),L=i("p"),L.innerHTML=za,qs=n(),w=i("ul"),w.innerHTML=Ja,Ns=n(),Vs=i("hr"),Bs=n(),A=i("a"),Ks=n(),u(U.$$.fragment),Qs=n(),g=i("p"),g.textContent=ja,Ss=n(),P=i("table"),P.innerHTML=Ea,Ws=n(),Ys=i("hr"),Fs=n(),R=i("a"),Os=n(),u(z.$$.fragment),Gs=n(),J=i("p"),J.textContent=ka,Zs=n(),j=i("p"),j.innerHTML=Da,Xs=n(),en=i("hr"),tn=n(),E=i("a"),ln=n(),u(k.$$.fragment),sn=n(),D=i("p"),D.textContent=Ia,nn=n(),I=i("p"),I.innerHTML=qa,on=n(),q=i("table"),q.innerHTML=Na,rn=n(),dn=i("hr"),an=n(),N=i("a"),un=n(),u(V.$$.fragment),mn=n(),B=i("p"),B.innerHTML=Va,pn=n(),K=i("table"),K.innerHTML=Ba,cn=n(),fn=i("hr"),Tn=n(),Q=i("a"),hn=n(),u(S.$$.fragment),_n=n(),W=i("p"),W.innerHTML=Ka,$n=n(),Y=i("table"),Y.innerHTML=Qa,yn=n(),vn=i("hr"),Mn=n(),F=i("a"),bn=n(),u(O.$$.fragment),xn=n(),G=i("p"),G.innerHTML=Sa,Cn=n(),Z=i("p"),Z.innerHTML=Wa,Hn=n(),X=i("ul"),X.innerHTML=Ya,Ln=n(),wn=i("hr"),An=n(),ee=i("a"),Un=n(),u(te.$$.fragment),gn=n(),le=i("p"),le.textContent=Fa,Pn=n(),se=i("p"),se.innerHTML=Oa,Rn=n(),zn=i("hr"),Jn=n(),ne=i("a"),jn=n(),u(oe.$$.fragment),En=n(),ie=i("p"),ie.textContent=Ga,kn=n(),re=i("p"),re.innerHTML=Za,Dn=n(),In=i("hr"),qn=n(),de=i("a"),Nn=n(),u(ae.$$.fragment),Vn=n(),ue=i("p"),ue.textContent=Xa,Bn=n(),me=i("p"),me.innerHTML=eu,Kn=n(),Qn=i("hr"),Sn=n(),pe=i("a"),Wn=n(),u(ce.$$.fragment),Yn=n(),fe=i("p"),fe.textContent=tu,Fn=n(),Te=i("p"),Te.innerHTML=lu,On=n(),he=i("table"),he.innerHTML=su,Gn=n(),Zn=i("hr"),Xn=n(),_e=i("a"),eo=n(),u($e.$$.fragment),to=n(),ye=i("p"),ye.textContent=nu,lo=n(),ve=i("p"),ve.innerHTML=ou,so=n(),Me=i("table"),Me.innerHTML=iu,no=n(),oo=i("hr"),io=n(),be=i("a"),ro=n(),u(xe.$$.fragment),ao=n(),Ce=i("p"),Ce.textContent=ru,uo=n(),He=i("p"),He.innerHTML=du,mo=n(),Le=i("table"),Le.innerHTML=au,po=n(),co=i("hr"),fo=n(),we=i("a"),To=n(),u(Ae.$$.fragment),ho=n(),Ue=i("p"),Ue.textContent=uu,_o=n(),ge=i("p"),ge.innerHTML=mu,$o=n(),Pe=i("table"),Pe.innerHTML=pu,yo=n(),vo=i("hr"),Mo=n(),Re=i("a"),bo=n(),u(ze.$$.fragment),xo=n(),Je=i("p"),Je.textContent=cu,Co=n(),je=i("p"),je.innerHTML=fu,Ho=n(),Ee=i("table"),Ee.innerHTML=Tu,Lo=n(),wo=i("hr"),Ao=n(),ke=i("a"),Uo=n(),u(De.$$.fragment),go=n(),Ie=i("p"),Ie.textContent=hu,Po=n(),qe=i("p"),qe.innerHTML=_u,Ro=n(),Ne=i("table"),Ne.innerHTML=$u,zo=n(),Jo=i("hr"),jo=n(),Ve=i("a"),Eo=n(),u(Be.$$.fragment),ko=n(),Ke=i("p"),Ke.textContent=yu,Do=n(),Qe=i("p"),Qe.innerHTML=vu,Io=n(),Se=i("table"),Se.innerHTML=Mu,qo=n(),No=i("hr"),Vo=n(),We=i("a"),Bo=n(),u(Ye.$$.fragment),Ko=n(),Fe=i("p"),Fe.innerHTML=bu,Qo=n(),Oe=i("p"),Oe.innerHTML=xu,So=n(),Ge=i("table"),Ge.innerHTML=Cu,Wo=n(),Yo=i("hr"),Fo=n(),Ze=i("a"),Oo=n(),u(Xe.$$.fragment),Go=n(),et=i("p"),et.innerHTML=Hu,Zo=n(),tt=i("p"),tt.innerHTML=Lu,Xo=n(),lt=i("table"),lt.innerHTML=wu,ei=n(),ti=i("hr"),li=n(),st=i("a"),si=n(),u(nt.$$.fragment),ni=n(),ot=i("p"),ot.textContent=Au,oi=n(),it=i("p"),it.innerHTML=Uu,ii=n(),ri=i("hr"),di=n(),rt=i("a"),ai=n(),u(dt.$$.fragment),ui=n(),at=i("p"),at.textContent=gu,mi=n(),ut=i("p"),ut.innerHTML=Pu,pi=n(),mt=i("p"),mt.innerHTML=Ru,ci=n(),pt=i("table"),pt.innerHTML=zu,fi=n(),Ti=i("hr"),hi=n(),ct=i("a"),_i=n(),u(ft.$$.fragment),$i=n(),Tt=i("p"),Tt.innerHTML=Ju,yi=n(),ht=i("p"),ht.innerHTML=ju,vi=n(),Mi=i("hr"),bi=n(),_t=i("a"),xi=n(),u($t.$$.fragment),Ci=n(),yt=i("p"),yt.textContent=Eu,Hi=n(),vt=i("p"),vt.textContent=ku,Li=n(),Mt=i("p"),Mt.innerHTML=Du,wi=n(),bt=i("table"),bt.innerHTML=Iu,Ai=n(),Ui=i("hr"),gi=n(),xt=i("a"),Pi=n(),u(Ct.$$.fragment),Ri=n(),Ht=i("p"),Ht.innerHTML=qu,zi=n(),Lt=i("p"),Lt.innerHTML=Nu,Ji=n(),ji=i("hr"),Ei=n(),wt=i("a"),ki=n(),u(At.$$.fragment),Di=n(),Ut=i("p"),Ut.innerHTML=Vu,Ii=n(),gt=i("p"),gt.innerHTML=Bu,qi=n(),Ni=i("hr"),Vi=n(),Pt=i("a"),Bi=n(),u(Rt.$$.fragment),Ki=n(),zt=i("p"),zt.innerHTML=Ku,Qi=n(),Jt=i("p"),Jt.innerHTML=Qu,Si=n(),jt=i("table"),jt.innerHTML=Su,Wi=n(),Yi=i("hr"),Fi=n(),Et=i("a"),Oi=n(),u(kt.$$.fragment),Gi=n(),Dt=i("p"),Dt.innerHTML=Wu,Zi=n(),It=i("p"),It.innerHTML=Yu,Xi=n(),qt=i("table"),qt.innerHTML=Fu,er=n(),tr=i("hr"),lr=n(),Nt=i("a"),sr=n(),u(Vt.$$.fragment),nr=n(),Bt=i("p"),Bt.innerHTML=Ou,or=n(),Kt=i("p"),Kt.innerHTML=Gu,ir=n(),rr=i("hr"),dr=n(),Qt=i("a"),ar=n(),u(St.$$.fragment),ur=n(),Wt=i("p"),Wt.textContent=Zu,mr=n(),Yt=i("p"),Yt.innerHTML=Xu,pr=n(),Ft=i("table"),Ft.innerHTML=em,cr=n(),fr=i("hr"),Tr=n(),Ot=i("a"),hr=n(),u(Gt.$$.fragment),_r=n(),Zt=i("p"),Zt.innerHTML=tm,$r=n(),Xt=i("p"),Xt.innerHTML=lm,yr=n(),vr=i("hr"),Mr=n(),el=i("a"),br=n(),u(tl.$$.fragment),xr=n(),ll=i("p"),ll.textContent=sm,Cr=n(),sl=i("p"),sl.innerHTML=nm,Hr=n(),Lr=i("hr"),wr=n(),nl=i("a"),Ar=n(),u(ol.$$.fragment),Ur=n(),il=i("p"),il.textContent=om,gr=n(),rl=i("p"),rl.innerHTML=im,Pr=n(),dl=i("table"),dl.innerHTML=rm,Rr=n(),zr=i("hr"),Jr=n(),al=i("a"),jr=n(),u(ul.$$.fragment),Er=n(),ml=i("p"),ml.textContent=dm,kr=n(),pl=i("p"),pl.innerHTML=am,Dr=n(),cl=i("table"),cl.innerHTML=um,Ir=n(),qr=i("hr"),Nr=n(),fl=i("a"),Vr=n(),u(Tl.$$.fragment),Br=n(),hl=i("p"),hl.textContent=mm,Kr=n(),_l=i("p"),_l.innerHTML=pm,Qr=n(),$l=i("table"),$l.innerHTML=cm,Sr=n(),Wr=i("hr"),Yr=n(),yl=i("a"),Fr=n(),u(vl.$$.fragment),Or=n(),Ml=i("p"),Ml.textContent=fm,Gr=n(),bl=i("p"),bl.innerHTML=Tm,Zr=n(),xl=i("table"),xl.innerHTML=hm,Xr=n(),ed=i("hr"),td=n(),Cl=i("a"),ld=n(),u(Hl.$$.fragment),sd=n(),Ll=i("p"),Ll.textContent=_m,nd=n(),wl=i("p"),wl.innerHTML=$m,od=n(),Al=i("table"),Al.innerHTML=ym,id=n(),rd=i("hr"),dd=n(),Ul=i("a"),ad=n(),u(gl.$$.fragment),ud=n(),Pl=i("p"),Pl.textContent=vm,md=n(),Rl=i("p"),Rl.innerHTML=Mm,pd=n(),zl=i("table"),zl.innerHTML=bm,cd=n(),fd=i("hr"),Td=n(),Jl=i("a"),hd=n(),u(jl.$$.fragment),_d=n(),El=i("p"),El.innerHTML=xm,$d=n(),kl=i("p"),kl.innerHTML=Cm,yd=n(),Dl=i("table"),Dl.innerHTML=Hm,vd=n(),Md=i("hr"),bd=n(),Il=i("a"),xd=n(),u(ql.$$.fragment),Cd=n(),Nl=i("p"),Nl.textContent=Lm,Hd=n(),Vl=i("p"),Vl.innerHTML=wm,Ld=n(),Bl=i("table"),Bl.innerHTML=Am,wd=n(),Ad=i("hr"),Ud=n(),Kl=i("a"),gd=n(),u(Ql.$$.fragment),Pd=n(),Sl=i("p"),Sl.textContent=Um,Rd=n(),Wl=i("p"),Wl.innerHTML=gm,zd=n(),Yl=i("table"),Yl.innerHTML=Pm,Jd=n(),jd=i("hr"),Ed=n(),Fl=i("a"),kd=n(),u(Ol.$$.fragment),Dd=n(),Gl=i("p"),Gl.textContent=Rm,Id=n(),Zl=i("p"),Zl.innerHTML=zm,qd=n(),Xl=i("table"),Xl.innerHTML=Jm,Nd=n(),Vd=i("hr"),Bd=n(),es=i("a"),Kd=n(),u(ts.$$.fragment),Qd=n(),ls=i("p"),ls.textContent=jm,Sd=n(),ss=i("p"),ss.innerHTML=Em,Wd=n(),ns=i("table"),ns.innerHTML=km,Yd=n(),Fd=i("hr"),Od=n(),os=i("a"),Gd=n(),u(is.$$.fragment),Zd=n(),rs=i("p"),rs.textContent=Dm,Xd=n(),ds=i("p"),ds.innerHTML=Im,ea=n(),as=i("table"),as.innerHTML=qm,ta=n(),us=i("p"),us.innerHTML=Nm,la=n(),u(ms.$$.fragment),sa=n(),na=i("hr"),oa=n(),ps=i("a"),ia=n(),u(cs.$$.fragment),ra=n(),fs=i("p"),fs.innerHTML=Vm,da=n(),aa=i("hr"),ua=n(),Ts=i("a"),ma=n(),u(hs.$$.fragment),pa=n(),_s=i("p"),_s.innerHTML=Bm,ca=n(),fa=i("hr"),Ta=n(),$s=i("a"),ha=n(),u(ys.$$.fragment),_a=n(),vs=i("p"),vs.textContent=Km,$a=n(),Ms=i("p"),Ms.innerHTML=Qm,ya=n(),u(bs.$$.fragment),va=n(),xs=i("p"),xs.innerHTML=Sm,Ma=n(),u(Cs.$$.fragment),ba=n(),Hs=i("p"),Hs.innerHTML=Wm,xa=n(),u(Ls.$$.fragment),Ca=n(),Ha=i("hr"),La=n(),As=i("p"),this.h()},l(e){const t=Xm("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),Us=o(e),ws=r(e,"P",{}),h(ws).forEach(l),gs=o(e),y=r(e,"A",{id:!0,class:!0}),h(y).forEach(l),Ps=o(e),m(v.$$.fragment,e),Rs=o(e),M=r(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-uw4y1m"&&(M.innerHTML=ga),zs=o(e),b=r(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-il3kl8"&&(b.textContent=Pa),Js=o(e),x=r(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-rekyzg"&&(x.innerHTML=Ra),js=o(e),Es=r(e,"HR",{}),ks=o(e),C=r(e,"A",{id:!0,class:!0}),h(C).forEach(l),Ds=o(e),m(H.$$.fragment,e),Is=o(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=za),qs=o(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-dqe61m"&&(w.innerHTML=Ja),Ns=o(e),Vs=r(e,"HR",{}),Bs=o(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(l),Ks=o(e),m(U.$$.fragment,e),Qs=o(e),g=r(e,"P",{"data-svelte-h":!0}),d(g)!=="svelte-55wecd"&&(g.textContent=ja),Ss=o(e),P=r(e,"TABLE",{"data-svelte-h":!0}),d(P)!=="svelte-ee7emz"&&(P.innerHTML=Ea),Ws=o(e),Ys=r(e,"HR",{}),Fs=o(e),R=r(e,"A",{id:!0,class:!0}),h(R).forEach(l),Os=o(e),m(z.$$.fragment,e),Gs=o(e),J=r(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1adn56z"&&(J.textContent=ka),Zs=o(e),j=r(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1gxgvk6"&&(j.innerHTML=Da),Xs=o(e),en=r(e,"HR",{}),tn=o(e),E=r(e,"A",{id:!0,class:!0}),h(E).forEach(l),ln=o(e),m(k.$$.fragment,e),sn=o(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1u97xg1"&&(D.textContent=Ia),nn=o(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1afa2dz"&&(I.innerHTML=qa),on=o(e),q=r(e,"TABLE",{"data-svelte-h":!0}),d(q)!=="svelte-1kq04ga"&&(q.innerHTML=Na),rn=o(e),dn=r(e,"HR",{}),an=o(e),N=r(e,"A",{id:!0,class:!0}),h(N).forEach(l),un=o(e),m(V.$$.fragment,e),mn=o(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1cg22af"&&(B.innerHTML=Va),pn=o(e),K=r(e,"TABLE",{"data-svelte-h":!0}),d(K)!=="svelte-1hful42"&&(K.innerHTML=Ba),cn=o(e),fn=r(e,"HR",{}),Tn=o(e),Q=r(e,"A",{id:!0,class:!0}),h(Q).forEach(l),hn=o(e),m(S.$$.fragment,e),_n=o(e),W=r(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1mr58c3"&&(W.innerHTML=Ka),$n=o(e),Y=r(e,"TABLE",{"data-svelte-h":!0}),d(Y)!=="svelte-153ftfy"&&(Y.innerHTML=Qa),yn=o(e),vn=r(e,"HR",{}),Mn=o(e),F=r(e,"A",{id:!0,class:!0}),h(F).forEach(l),bn=o(e),m(O.$$.fragment,e),xn=o(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-13nzfs3"&&(G.innerHTML=Sa),Cn=o(e),Z=r(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-18jnqwq"&&(Z.innerHTML=Wa),Hn=o(e),X=r(e,"UL",{"data-svelte-h":!0}),d(X)!=="svelte-5t2sg3"&&(X.innerHTML=Ya),Ln=o(e),wn=r(e,"HR",{}),An=o(e),ee=r(e,"A",{id:!0,class:!0}),h(ee).forEach(l),Un=o(e),m(te.$$.fragment,e),gn=o(e),le=r(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-87xdyr"&&(le.textContent=Fa),Pn=o(e),se=r(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1mr58c3"&&(se.innerHTML=Oa),Rn=o(e),zn=r(e,"HR",{}),Jn=o(e),ne=r(e,"A",{id:!0,class:!0}),h(ne).forEach(l),jn=o(e),m(oe.$$.fragment,e),En=o(e),ie=r(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-2wti2w"&&(ie.textContent=Ga),kn=o(e),re=r(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-kpq7mo"&&(re.innerHTML=Za),Dn=o(e),In=r(e,"HR",{}),qn=o(e),de=r(e,"A",{id:!0,class:!0}),h(de).forEach(l),Nn=o(e),m(ae.$$.fragment,e),Vn=o(e),ue=r(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1edu6c8"&&(ue.textContent=Xa),Bn=o(e),me=r(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1hc4oxa"&&(me.innerHTML=eu),Kn=o(e),Qn=r(e,"HR",{}),Sn=o(e),pe=r(e,"A",{id:!0,class:!0}),h(pe).forEach(l),Wn=o(e),m(ce.$$.fragment,e),Yn=o(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-xg80lg"&&(fe.textContent=tu),Fn=o(e),Te=r(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1aygav2"&&(Te.innerHTML=lu),On=o(e),he=r(e,"TABLE",{"data-svelte-h":!0}),d(he)!=="svelte-1tbtmqd"&&(he.innerHTML=su),Gn=o(e),Zn=r(e,"HR",{}),Xn=o(e),_e=r(e,"A",{id:!0,class:!0}),h(_e).forEach(l),eo=o(e),m($e.$$.fragment,e),to=o(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1i12x1s"&&(ye.textContent=nu),lo=o(e),ve=r(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-1hc4oxa"&&(ve.innerHTML=ou),so=o(e),Me=r(e,"TABLE",{"data-svelte-h":!0}),d(Me)!=="svelte-1tbtmqd"&&(Me.innerHTML=iu),no=o(e),oo=r(e,"HR",{}),io=o(e),be=r(e,"A",{id:!0,class:!0}),h(be).forEach(l),ro=o(e),m(xe.$$.fragment,e),ao=o(e),Ce=r(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-1hl64jn"&&(Ce.textContent=ru),uo=o(e),He=r(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1aygav2"&&(He.innerHTML=du),mo=o(e),Le=r(e,"TABLE",{"data-svelte-h":!0}),d(Le)!=="svelte-1p5444"&&(Le.innerHTML=au),po=o(e),co=r(e,"HR",{}),fo=o(e),we=r(e,"A",{id:!0,class:!0}),h(we).forEach(l),To=o(e),m(Ae.$$.fragment,e),ho=o(e),Ue=r(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-bbf4x3"&&(Ue.textContent=uu),_o=o(e),ge=r(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-1hc4oxa"&&(ge.innerHTML=mu),$o=o(e),Pe=r(e,"TABLE",{"data-svelte-h":!0}),d(Pe)!=="svelte-1p5444"&&(Pe.innerHTML=pu),yo=o(e),vo=r(e,"HR",{}),Mo=o(e),Re=r(e,"A",{id:!0,class:!0}),h(Re).forEach(l),bo=o(e),m(ze.$$.fragment,e),xo=o(e),Je=r(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-lesh1u"&&(Je.textContent=cu),Co=o(e),je=r(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-rvzl1t"&&(je.innerHTML=fu),Ho=o(e),Ee=r(e,"TABLE",{"data-svelte-h":!0}),d(Ee)!=="svelte-onq75m"&&(Ee.innerHTML=Tu),Lo=o(e),wo=r(e,"HR",{}),Ao=o(e),ke=r(e,"A",{id:!0,class:!0}),h(ke).forEach(l),Uo=o(e),m(De.$$.fragment,e),go=o(e),Ie=r(e,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-yjryb1"&&(Ie.textContent=hu),Po=o(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-xtr8tc"&&(qe.innerHTML=_u),Ro=o(e),Ne=r(e,"TABLE",{"data-svelte-h":!0}),d(Ne)!=="svelte-6xvdso"&&(Ne.innerHTML=$u),zo=o(e),Jo=r(e,"HR",{}),jo=o(e),Ve=r(e,"A",{id:!0,class:!0}),h(Ve).forEach(l),Eo=o(e),m(Be.$$.fragment,e),ko=o(e),Ke=r(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1okfsqx"&&(Ke.textContent=yu),Do=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-1t556pk"&&(Qe.innerHTML=vu),Io=o(e),Se=r(e,"TABLE",{"data-svelte-h":!0}),d(Se)!=="svelte-13m2wni"&&(Se.innerHTML=Mu),qo=o(e),No=r(e,"HR",{}),Vo=o(e),We=r(e,"A",{id:!0,class:!0}),h(We).forEach(l),Bo=o(e),m(Ye.$$.fragment,e),Ko=o(e),Fe=r(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1htpbrk"&&(Fe.innerHTML=bu),Qo=o(e),Oe=r(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1t0m8l6"&&(Oe.innerHTML=xu),So=o(e),Ge=r(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-1qi99pl"&&(Ge.innerHTML=Cu),Wo=o(e),Yo=r(e,"HR",{}),Fo=o(e),Ze=r(e,"A",{id:!0,class:!0}),h(Ze).forEach(l),Oo=o(e),m(Xe.$$.fragment,e),Go=o(e),et=r(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-1ztgqp"&&(et.innerHTML=Hu),Zo=o(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-mvb39p"&&(tt.innerHTML=Lu),Xo=o(e),lt=r(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-1qi99pl"&&(lt.innerHTML=wu),ei=o(e),ti=r(e,"HR",{}),li=o(e),st=r(e,"A",{id:!0,class:!0}),h(st).forEach(l),si=o(e),m(nt.$$.fragment,e),ni=o(e),ot=r(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1a7u185"&&(ot.textContent=Au),oi=o(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1eu3doh"&&(it.innerHTML=Uu),ii=o(e),ri=r(e,"HR",{}),di=o(e),rt=r(e,"A",{id:!0,class:!0}),h(rt).forEach(l),ai=o(e),m(dt.$$.fragment,e),ui=o(e),at=r(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-qls17b"&&(at.textContent=gu),mi=o(e),ut=r(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-5nabmy"&&(ut.innerHTML=Pu),pi=o(e),mt=r(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1skbfxl"&&(mt.innerHTML=Ru),ci=o(e),pt=r(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-52pnzr"&&(pt.innerHTML=zu),fi=o(e),Ti=r(e,"HR",{}),hi=o(e),ct=r(e,"A",{id:!0,class:!0}),h(ct).forEach(l),_i=o(e),m(ft.$$.fragment,e),$i=o(e),Tt=r(e,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-19w0pic"&&(Tt.innerHTML=Ju),yi=o(e),ht=r(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1mr58c3"&&(ht.innerHTML=ju),vi=o(e),Mi=r(e,"HR",{}),bi=o(e),_t=r(e,"A",{id:!0,class:!0}),h(_t).forEach(l),xi=o(e),m($t.$$.fragment,e),Ci=o(e),yt=r(e,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-18ws76n"&&(yt.textContent=Eu),Hi=o(e),vt=r(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-1tnr5gm"&&(vt.textContent=ku),Li=o(e),Mt=r(e,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1aoa5jo"&&(Mt.innerHTML=Du),wi=o(e),bt=r(e,"TABLE",{"data-svelte-h":!0}),d(bt)!=="svelte-1u9lyxp"&&(bt.innerHTML=Iu),Ai=o(e),Ui=r(e,"HR",{}),gi=o(e),xt=r(e,"A",{id:!0,class:!0}),h(xt).forEach(l),Pi=o(e),m(Ct.$$.fragment,e),Ri=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-1b9ygao"&&(Ht.innerHTML=qu),zi=o(e),Lt=r(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-1mr58c3"&&(Lt.innerHTML=Nu),Ji=o(e),ji=r(e,"HR",{}),Ei=o(e),wt=r(e,"A",{id:!0,class:!0}),h(wt).forEach(l),ki=o(e),m(At.$$.fragment,e),Di=o(e),Ut=r(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1vkr5xo"&&(Ut.innerHTML=Vu),Ii=o(e),gt=r(e,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-1mr58c3"&&(gt.innerHTML=Bu),qi=o(e),Ni=r(e,"HR",{}),Vi=o(e),Pt=r(e,"A",{id:!0,class:!0}),h(Pt).forEach(l),Bi=o(e),m(Rt.$$.fragment,e),Ki=o(e),zt=r(e,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1gguudf"&&(zt.innerHTML=Ku),Qi=o(e),Jt=r(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-9ffe42"&&(Jt.innerHTML=Qu),Si=o(e),jt=r(e,"TABLE",{"data-svelte-h":!0}),d(jt)!=="svelte-z6whez"&&(jt.innerHTML=Su),Wi=o(e),Yi=r(e,"HR",{}),Fi=o(e),Et=r(e,"A",{id:!0,class:!0}),h(Et).forEach(l),Oi=o(e),m(kt.$$.fragment,e),Gi=o(e),Dt=r(e,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-d6gvut"&&(Dt.innerHTML=Wu),Zi=o(e),It=r(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-18n9ux4"&&(It.innerHTML=Yu),Xi=o(e),qt=r(e,"TABLE",{"data-svelte-h":!0}),d(qt)!=="svelte-jj58dd"&&(qt.innerHTML=Fu),er=o(e),tr=r(e,"HR",{}),lr=o(e),Nt=r(e,"A",{id:!0,class:!0}),h(Nt).forEach(l),sr=o(e),m(Vt.$$.fragment,e),nr=o(e),Bt=r(e,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-1adolpg"&&(Bt.innerHTML=Ou),or=o(e),Kt=r(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-1mr58c3"&&(Kt.innerHTML=Gu),ir=o(e),rr=r(e,"HR",{}),dr=o(e),Qt=r(e,"A",{id:!0,class:!0}),h(Qt).forEach(l),ar=o(e),m(St.$$.fragment,e),ur=o(e),Wt=r(e,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-1hm8vtj"&&(Wt.textContent=Zu),mr=o(e),Yt=r(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-106ei5g"&&(Yt.innerHTML=Xu),pr=o(e),Ft=r(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-9ff0sy"&&(Ft.innerHTML=em),cr=o(e),fr=r(e,"HR",{}),Tr=o(e),Ot=r(e,"A",{id:!0,class:!0}),h(Ot).forEach(l),hr=o(e),m(Gt.$$.fragment,e),_r=o(e),Zt=r(e,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-1e6kzks"&&(Zt.innerHTML=tm),$r=o(e),Xt=r(e,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1mr58c3"&&(Xt.innerHTML=lm),yr=o(e),vr=r(e,"HR",{}),Mr=o(e),el=r(e,"A",{id:!0,class:!0}),h(el).forEach(l),br=o(e),m(tl.$$.fragment,e),xr=o(e),ll=r(e,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-t5k6jp"&&(ll.textContent=sm),Cr=o(e),sl=r(e,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-106ei5g"&&(sl.innerHTML=nm),Hr=o(e),Lr=r(e,"HR",{}),wr=o(e),nl=r(e,"A",{id:!0,class:!0}),h(nl).forEach(l),Ar=o(e),m(ol.$$.fragment,e),Ur=o(e),il=r(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-avw2a1"&&(il.textContent=om),gr=o(e),rl=r(e,"P",{"data-svelte-h":!0}),d(rl)!=="svelte-16q99cu"&&(rl.innerHTML=im),Pr=o(e),dl=r(e,"TABLE",{"data-svelte-h":!0}),d(dl)!=="svelte-8w2c3y"&&(dl.innerHTML=rm),Rr=o(e),zr=r(e,"HR",{}),Jr=o(e),al=r(e,"A",{id:!0,class:!0}),h(al).forEach(l),jr=o(e),m(ul.$$.fragment,e),Er=o(e),ml=r(e,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-15z3tv8"&&(ml.textContent=dm),kr=o(e),pl=r(e,"P",{"data-svelte-h":!0}),d(pl)!=="svelte-sv4gxb"&&(pl.innerHTML=am),Dr=o(e),cl=r(e,"TABLE",{"data-svelte-h":!0}),d(cl)!=="svelte-q8pfpb"&&(cl.innerHTML=um),Ir=o(e),qr=r(e,"HR",{}),Nr=o(e),fl=r(e,"A",{id:!0,class:!0}),h(fl).forEach(l),Vr=o(e),m(Tl.$$.fragment,e),Br=o(e),hl=r(e,"P",{"data-svelte-h":!0}),d(hl)!=="svelte-fju8tm"&&(hl.textContent=mm),Kr=o(e),_l=r(e,"P",{"data-svelte-h":!0}),d(_l)!=="svelte-13s6o0v"&&(_l.innerHTML=pm),Qr=o(e),$l=r(e,"TABLE",{"data-svelte-h":!0}),d($l)!=="svelte-8i278m"&&($l.innerHTML=cm),Sr=o(e),Wr=r(e,"HR",{}),Yr=o(e),yl=r(e,"A",{id:!0,class:!0}),h(yl).forEach(l),Fr=o(e),m(vl.$$.fragment,e),Or=o(e),Ml=r(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-11ei68w"&&(Ml.textContent=fm),Gr=o(e),bl=r(e,"P",{"data-svelte-h":!0}),d(bl)!=="svelte-1p3llh"&&(bl.innerHTML=Tm),Zr=o(e),xl=r(e,"TABLE",{"data-svelte-h":!0}),d(xl)!=="svelte-1xe0vb8"&&(xl.innerHTML=hm),Xr=o(e),ed=r(e,"HR",{}),td=o(e),Cl=r(e,"A",{id:!0,class:!0}),h(Cl).forEach(l),ld=o(e),m(Hl.$$.fragment,e),sd=o(e),Ll=r(e,"P",{"data-svelte-h":!0}),d(Ll)!=="svelte-k6p1db"&&(Ll.textContent=_m),nd=o(e),wl=r(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-1o30xnd"&&(wl.innerHTML=$m),od=o(e),Al=r(e,"TABLE",{"data-svelte-h":!0}),d(Al)!=="svelte-101obk2"&&(Al.innerHTML=ym),id=o(e),rd=r(e,"HR",{}),dd=o(e),Ul=r(e,"A",{id:!0,class:!0}),h(Ul).forEach(l),ad=o(e),m(gl.$$.fragment,e),ud=o(e),Pl=r(e,"P",{"data-svelte-h":!0}),d(Pl)!=="svelte-8afo9v"&&(Pl.textContent=vm),md=o(e),Rl=r(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-1vvmhgz"&&(Rl.innerHTML=Mm),pd=o(e),zl=r(e,"TABLE",{"data-svelte-h":!0}),d(zl)!=="svelte-wz2jkw"&&(zl.innerHTML=bm),cd=o(e),fd=r(e,"HR",{}),Td=o(e),Jl=r(e,"A",{id:!0,class:!0}),h(Jl).forEach(l),hd=o(e),m(jl.$$.fragment,e),_d=o(e),El=r(e,"P",{"data-svelte-h":!0}),d(El)!=="svelte-11plveb"&&(El.innerHTML=xm),$d=o(e),kl=r(e,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-1wu8g4g"&&(kl.innerHTML=Cm),yd=o(e),Dl=r(e,"TABLE",{"data-svelte-h":!0}),d(Dl)!=="svelte-1vsvca3"&&(Dl.innerHTML=Hm),vd=o(e),Md=r(e,"HR",{}),bd=o(e),Il=r(e,"A",{id:!0,class:!0}),h(Il).forEach(l),xd=o(e),m(ql.$$.fragment,e),Cd=o(e),Nl=r(e,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-17f4oxi"&&(Nl.textContent=Lm),Hd=o(e),Vl=r(e,"P",{"data-svelte-h":!0}),d(Vl)!=="svelte-1lh8r1a"&&(Vl.innerHTML=wm),Ld=o(e),Bl=r(e,"TABLE",{"data-svelte-h":!0}),d(Bl)!=="svelte-m4z8c4"&&(Bl.innerHTML=Am),wd=o(e),Ad=r(e,"HR",{}),Ud=o(e),Kl=r(e,"A",{id:!0,class:!0}),h(Kl).forEach(l),gd=o(e),m(Ql.$$.fragment,e),Pd=o(e),Sl=r(e,"P",{"data-svelte-h":!0}),d(Sl)!=="svelte-kcewlk"&&(Sl.textContent=Um),Rd=o(e),Wl=r(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-17f480h"&&(Wl.innerHTML=gm),zd=o(e),Yl=r(e,"TABLE",{"data-svelte-h":!0}),d(Yl)!=="svelte-1to7jw8"&&(Yl.innerHTML=Pm),Jd=o(e),jd=r(e,"HR",{}),Ed=o(e),Fl=r(e,"A",{id:!0,class:!0}),h(Fl).forEach(l),kd=o(e),m(Ol.$$.fragment,e),Dd=o(e),Gl=r(e,"P",{"data-svelte-h":!0}),d(Gl)!=="svelte-1ayje0f"&&(Gl.textContent=Rm),Id=o(e),Zl=r(e,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-17f480h"&&(Zl.innerHTML=zm),qd=o(e),Xl=r(e,"TABLE",{"data-svelte-h":!0}),d(Xl)!=="svelte-gyxne1"&&(Xl.innerHTML=Jm),Nd=o(e),Vd=r(e,"HR",{}),Bd=o(e),es=r(e,"A",{id:!0,class:!0}),h(es).forEach(l),Kd=o(e),m(ts.$$.fragment,e),Qd=o(e),ls=r(e,"P",{"data-svelte-h":!0}),d(ls)!=="svelte-1wvb8sq"&&(ls.textContent=jm),Sd=o(e),ss=r(e,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-154yhp4"&&(ss.innerHTML=Em),Wd=o(e),ns=r(e,"TABLE",{"data-svelte-h":!0}),d(ns)!=="svelte-1fk5fng"&&(ns.innerHTML=km),Yd=o(e),Fd=r(e,"HR",{}),Od=o(e),os=r(e,"A",{id:!0,class:!0}),h(os).forEach(l),Gd=o(e),m(is.$$.fragment,e),Zd=o(e),rs=r(e,"P",{"data-svelte-h":!0}),d(rs)!=="svelte-40isdg"&&(rs.textContent=Dm),Xd=o(e),ds=r(e,"P",{"data-svelte-h":!0}),d(ds)!=="svelte-tlsa2h"&&(ds.innerHTML=Im),ea=o(e),as=r(e,"TABLE",{"data-svelte-h":!0}),d(as)!=="svelte-1j7v21a"&&(as.innerHTML=qm),ta=o(e),us=r(e,"P",{"data-svelte-h":!0}),d(us)!=="svelte-1aswmub"&&(us.innerHTML=Nm),la=o(e),m(ms.$$.fragment,e),sa=o(e),na=r(e,"HR",{}),oa=o(e),ps=r(e,"A",{id:!0,class:!0}),h(ps).forEach(l),ia=o(e),m(cs.$$.fragment,e),ra=o(e),fs=r(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-kp31r8"&&(fs.innerHTML=Vm),da=o(e),aa=r(e,"HR",{}),ua=o(e),Ts=r(e,"A",{id:!0,class:!0}),h(Ts).forEach(l),ma=o(e),m(hs.$$.fragment,e),pa=o(e),_s=r(e,"P",{"data-svelte-h":!0}),d(_s)!=="svelte-1fs9no9"&&(_s.innerHTML=Bm),ca=o(e),fa=r(e,"HR",{}),Ta=o(e),$s=r(e,"A",{id:!0,class:!0}),h($s).forEach(l),ha=o(e),m(ys.$$.fragment,e),_a=o(e),vs=r(e,"P",{"data-svelte-h":!0}),d(vs)!=="svelte-2mif9c"&&(vs.textContent=Km),$a=o(e),Ms=r(e,"P",{"data-svelte-h":!0}),d(Ms)!=="svelte-1jas2kw"&&(Ms.innerHTML=Qm),ya=o(e),m(bs.$$.fragment,e),va=o(e),xs=r(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-1aswmub"&&(xs.innerHTML=Sm),Ma=o(e),m(Cs.$$.fragment,e),ba=o(e),Hs=r(e,"P",{"data-svelte-h":!0}),d(Hs)!=="svelte-1aswmub"&&(Hs.innerHTML=Wm),xa=o(e),m(Ls.$$.fragment,e),Ca=o(e),Ha=r(e,"HR",{}),La=o(e),As=r(e,"P",{}),h(As).forEach(l),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",lp),a(y,"id","module_utils/tensor"),a(y,"class","group"),a(C,"id","module_utils/tensor.Tensor"),a(C,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(R,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(R,"class","group"),a(E,"id","module_utils/tensor.Tensor+_getitem"),a(E,"class","group"),a(N,"id","module_utils/tensor.Tensor+indexOf"),a(N,"class","group"),a(Q,"id","module_utils/tensor.Tensor+_subarray"),a(Q,"class","group"),a(F,"id","module_utils/tensor.Tensor+item"),a(F,"class","group"),a(ee,"id","module_utils/tensor.Tensor+tolist"),a(ee,"class","group"),a(ne,"id","module_utils/tensor.Tensor+sigmoid"),a(ne,"class","group"),a(de,"id","module_utils/tensor.Tensor+sigmoid_"),a(de,"class","group"),a(pe,"id","module_utils/tensor.Tensor+mul"),a(pe,"class","group"),a(_e,"id","module_utils/tensor.Tensor+mul_"),a(_e,"class","group"),a(be,"id","module_utils/tensor.Tensor+add"),a(be,"class","group"),a(we,"id","module_utils/tensor.Tensor+add_"),a(we,"class","group"),a(Re,"id","module_utils/tensor.Tensor+transpose"),a(Re,"class","group"),a(ke,"id","module_utils/tensor.Tensor+sum"),a(ke,"class","group"),a(Ve,"id","module_utils/tensor.Tensor+norm"),a(Ve,"class","group"),a(We,"id","module_utils/tensor.Tensor+normalize_"),a(We,"class","group"),a(Ze,"id","module_utils/tensor.Tensor+normalize"),a(Ze,"class","group"),a(st,"id","module_utils/tensor.Tensor+stride"),a(st,"class","group"),a(rt,"id","module_utils/tensor.Tensor+squeeze"),a(rt,"class","group"),a(ct,"id","module_utils/tensor.Tensor+squeeze_"),a(ct,"class","group"),a(_t,"id","module_utils/tensor.Tensor+unsqueeze"),a(_t,"class","group"),a(xt,"id","module_utils/tensor.Tensor+unsqueeze_"),a(xt,"class","group"),a(wt,"id","module_utils/tensor.Tensor+flatten_"),a(wt,"class","group"),a(Pt,"id","module_utils/tensor.Tensor+flatten"),a(Pt,"class","group"),a(Et,"id","module_utils/tensor.Tensor+view"),a(Et,"class","group"),a(Nt,"id","module_utils/tensor.Tensor+clamp_"),a(Nt,"class","group"),a(Qt,"id","module_utils/tensor.Tensor+clamp"),a(Qt,"class","group"),a(Ot,"id","module_utils/tensor.Tensor+round_"),a(Ot,"class","group"),a(el,"id","module_utils/tensor.Tensor+round"),a(el,"class","group"),a(nl,"id","module_utils/tensor.Tensor+to"),a(nl,"class","group"),a(al,"id","module_utils/tensor.transpose"),a(al,"class","group"),a(fl,"id","module_utils/tensor.interpolate"),a(fl,"class","group"),a(yl,"id","module_utils/tensor.mean_pooling"),a(yl,"class","group"),a(Cl,"id","module_utils/tensor.cat"),a(Cl,"class","group"),a(Ul,"id","module_utils/tensor.stack"),a(Ul,"class","group"),a(Jl,"id","module_utils/tensor.std_mean"),a(Jl,"class","group"),a(Il,"id","module_utils/tensor.mean"),a(Il,"class","group"),a(Kl,"id","module_utils/tensor.dynamicTimeWarping"),a(Kl,"class","group"),a(Fl,"id","module_utils/tensor.ones"),a(Fl,"class","group"),a(es,"id","module_utils/tensor.ones_like"),a(es,"class","group"),a(os,"id","module_utils/tensor..reshape"),a(os,"class","group"),a(ps,"id","module_utils/tensor..reshape..reshapedArray"),a(ps,"class","group"),a(Ts,"id","module_utils/tensor..DataArray"),a(Ts,"class","group"),a($s,"id","module_utils/tensor..NestArray"),a($s,"class","group")},m(e,t){ep(document.head,$),s(e,Us,t),s(e,ws,t),s(e,gs,t),s(e,y,t),s(e,Ps,t),p(v,e,t),s(e,Rs,t),s(e,M,t),s(e,zs,t),s(e,b,t),s(e,Js,t),s(e,x,t),s(e,js,t),s(e,Es,t),s(e,ks,t),s(e,C,t),s(e,Ds,t),p(H,e,t),s(e,Is,t),s(e,L,t),s(e,qs,t),s(e,w,t),s(e,Ns,t),s(e,Vs,t),s(e,Bs,t),s(e,A,t),s(e,Ks,t),p(U,e,t),s(e,Qs,t),s(e,g,t),s(e,Ss,t),s(e,P,t),s(e,Ws,t),s(e,Ys,t),s(e,Fs,t),s(e,R,t),s(e,Os,t),p(z,e,t),s(e,Gs,t),s(e,J,t),s(e,Zs,t),s(e,j,t),s(e,Xs,t),s(e,en,t),s(e,tn,t),s(e,E,t),s(e,ln,t),p(k,e,t),s(e,sn,t),s(e,D,t),s(e,nn,t),s(e,I,t),s(e,on,t),s(e,q,t),s(e,rn,t),s(e,dn,t),s(e,an,t),s(e,N,t),s(e,un,t),p(V,e,t),s(e,mn,t),s(e,B,t),s(e,pn,t),s(e,K,t),s(e,cn,t),s(e,fn,t),s(e,Tn,t),s(e,Q,t),s(e,hn,t),p(S,e,t),s(e,_n,t),s(e,W,t),s(e,$n,t),s(e,Y,t),s(e,yn,t),s(e,vn,t),s(e,Mn,t),s(e,F,t),s(e,bn,t),p(O,e,t),s(e,xn,t),s(e,G,t),s(e,Cn,t),s(e,Z,t),s(e,Hn,t),s(e,X,t),s(e,Ln,t),s(e,wn,t),s(e,An,t),s(e,ee,t),s(e,Un,t),p(te,e,t),s(e,gn,t),s(e,le,t),s(e,Pn,t),s(e,se,t),s(e,Rn,t),s(e,zn,t),s(e,Jn,t),s(e,ne,t),s(e,jn,t),p(oe,e,t),s(e,En,t),s(e,ie,t),s(e,kn,t),s(e,re,t),s(e,Dn,t),s(e,In,t),s(e,qn,t),s(e,de,t),s(e,Nn,t),p(ae,e,t),s(e,Vn,t),s(e,ue,t),s(e,Bn,t),s(e,me,t),s(e,Kn,t),s(e,Qn,t),s(e,Sn,t),s(e,pe,t),s(e,Wn,t),p(ce,e,t),s(e,Yn,t),s(e,fe,t),s(e,Fn,t),s(e,Te,t),s(e,On,t),s(e,he,t),s(e,Gn,t),s(e,Zn,t),s(e,Xn,t),s(e,_e,t),s(e,eo,t),p($e,e,t),s(e,to,t),s(e,ye,t),s(e,lo,t),s(e,ve,t),s(e,so,t),s(e,Me,t),s(e,no,t),s(e,oo,t),s(e,io,t),s(e,be,t),s(e,ro,t),p(xe,e,t),s(e,ao,t),s(e,Ce,t),s(e,uo,t),s(e,He,t),s(e,mo,t),s(e,Le,t),s(e,po,t),s(e,co,t),s(e,fo,t),s(e,we,t),s(e,To,t),p(Ae,e,t),s(e,ho,t),s(e,Ue,t),s(e,_o,t),s(e,ge,t),s(e,$o,t),s(e,Pe,t),s(e,yo,t),s(e,vo,t),s(e,Mo,t),s(e,Re,t),s(e,bo,t),p(ze,e,t),s(e,xo,t),s(e,Je,t),s(e,Co,t),s(e,je,t),s(e,Ho,t),s(e,Ee,t),s(e,Lo,t),s(e,wo,t),s(e,Ao,t),s(e,ke,t),s(e,Uo,t),p(De,e,t),s(e,go,t),s(e,Ie,t),s(e,Po,t),s(e,qe,t),s(e,Ro,t),s(e,Ne,t),s(e,zo,t),s(e,Jo,t),s(e,jo,t),s(e,Ve,t),s(e,Eo,t),p(Be,e,t),s(e,ko,t),s(e,Ke,t),s(e,Do,t),s(e,Qe,t),s(e,Io,t),s(e,Se,t),s(e,qo,t),s(e,No,t),s(e,Vo,t),s(e,We,t),s(e,Bo,t),p(Ye,e,t),s(e,Ko,t),s(e,Fe,t),s(e,Qo,t),s(e,Oe,t),s(e,So,t),s(e,Ge,t),s(e,Wo,t),s(e,Yo,t),s(e,Fo,t),s(e,Ze,t),s(e,Oo,t),p(Xe,e,t),s(e,Go,t),s(e,et,t),s(e,Zo,t),s(e,tt,t),s(e,Xo,t),s(e,lt,t),s(e,ei,t),s(e,ti,t),s(e,li,t),s(e,st,t),s(e,si,t),p(nt,e,t),s(e,ni,t),s(e,ot,t),s(e,oi,t),s(e,it,t),s(e,ii,t),s(e,ri,t),s(e,di,t),s(e,rt,t),s(e,ai,t),p(dt,e,t),s(e,ui,t),s(e,at,t),s(e,mi,t),s(e,ut,t),s(e,pi,t),s(e,mt,t),s(e,ci,t),s(e,pt,t),s(e,fi,t),s(e,Ti,t),s(e,hi,t),s(e,ct,t),s(e,_i,t),p(ft,e,t),s(e,$i,t),s(e,Tt,t),s(e,yi,t),s(e,ht,t),s(e,vi,t),s(e,Mi,t),s(e,bi,t),s(e,_t,t),s(e,xi,t),p($t,e,t),s(e,Ci,t),s(e,yt,t),s(e,Hi,t),s(e,vt,t),s(e,Li,t),s(e,Mt,t),s(e,wi,t),s(e,bt,t),s(e,Ai,t),s(e,Ui,t),s(e,gi,t),s(e,xt,t),s(e,Pi,t),p(Ct,e,t),s(e,Ri,t),s(e,Ht,t),s(e,zi,t),s(e,Lt,t),s(e,Ji,t),s(e,ji,t),s(e,Ei,t),s(e,wt,t),s(e,ki,t),p(At,e,t),s(e,Di,t),s(e,Ut,t),s(e,Ii,t),s(e,gt,t),s(e,qi,t),s(e,Ni,t),s(e,Vi,t),s(e,Pt,t),s(e,Bi,t),p(Rt,e,t),s(e,Ki,t),s(e,zt,t),s(e,Qi,t),s(e,Jt,t),s(e,Si,t),s(e,jt,t),s(e,Wi,t),s(e,Yi,t),s(e,Fi,t),s(e,Et,t),s(e,Oi,t),p(kt,e,t),s(e,Gi,t),s(e,Dt,t),s(e,Zi,t),s(e,It,t),s(e,Xi,t),s(e,qt,t),s(e,er,t),s(e,tr,t),s(e,lr,t),s(e,Nt,t),s(e,sr,t),p(Vt,e,t),s(e,nr,t),s(e,Bt,t),s(e,or,t),s(e,Kt,t),s(e,ir,t),s(e,rr,t),s(e,dr,t),s(e,Qt,t),s(e,ar,t),p(St,e,t),s(e,ur,t),s(e,Wt,t),s(e,mr,t),s(e,Yt,t),s(e,pr,t),s(e,Ft,t),s(e,cr,t),s(e,fr,t),s(e,Tr,t),s(e,Ot,t),s(e,hr,t),p(Gt,e,t),s(e,_r,t),s(e,Zt,t),s(e,$r,t),s(e,Xt,t),s(e,yr,t),s(e,vr,t),s(e,Mr,t),s(e,el,t),s(e,br,t),p(tl,e,t),s(e,xr,t),s(e,ll,t),s(e,Cr,t),s(e,sl,t),s(e,Hr,t),s(e,Lr,t),s(e,wr,t),s(e,nl,t),s(e,Ar,t),p(ol,e,t),s(e,Ur,t),s(e,il,t),s(e,gr,t),s(e,rl,t),s(e,Pr,t),s(e,dl,t),s(e,Rr,t),s(e,zr,t),s(e,Jr,t),s(e,al,t),s(e,jr,t),p(ul,e,t),s(e,Er,t),s(e,ml,t),s(e,kr,t),s(e,pl,t),s(e,Dr,t),s(e,cl,t),s(e,Ir,t),s(e,qr,t),s(e,Nr,t),s(e,fl,t),s(e,Vr,t),p(Tl,e,t),s(e,Br,t),s(e,hl,t),s(e,Kr,t),s(e,_l,t),s(e,Qr,t),s(e,$l,t),s(e,Sr,t),s(e,Wr,t),s(e,Yr,t),s(e,yl,t),s(e,Fr,t),p(vl,e,t),s(e,Or,t),s(e,Ml,t),s(e,Gr,t),s(e,bl,t),s(e,Zr,t),s(e,xl,t),s(e,Xr,t),s(e,ed,t),s(e,td,t),s(e,Cl,t),s(e,ld,t),p(Hl,e,t),s(e,sd,t),s(e,Ll,t),s(e,nd,t),s(e,wl,t),s(e,od,t),s(e,Al,t),s(e,id,t),s(e,rd,t),s(e,dd,t),s(e,Ul,t),s(e,ad,t),p(gl,e,t),s(e,ud,t),s(e,Pl,t),s(e,md,t),s(e,Rl,t),s(e,pd,t),s(e,zl,t),s(e,cd,t),s(e,fd,t),s(e,Td,t),s(e,Jl,t),s(e,hd,t),p(jl,e,t),s(e,_d,t),s(e,El,t),s(e,$d,t),s(e,kl,t),s(e,yd,t),s(e,Dl,t),s(e,vd,t),s(e,Md,t),s(e,bd,t),s(e,Il,t),s(e,xd,t),p(ql,e,t),s(e,Cd,t),s(e,Nl,t),s(e,Hd,t),s(e,Vl,t),s(e,Ld,t),s(e,Bl,t),s(e,wd,t),s(e,Ad,t),s(e,Ud,t),s(e,Kl,t),s(e,gd,t),p(Ql,e,t),s(e,Pd,t),s(e,Sl,t),s(e,Rd,t),s(e,Wl,t),s(e,zd,t),s(e,Yl,t),s(e,Jd,t),s(e,jd,t),s(e,Ed,t),s(e,Fl,t),s(e,kd,t),p(Ol,e,t),s(e,Dd,t),s(e,Gl,t),s(e,Id,t),s(e,Zl,t),s(e,qd,t),s(e,Xl,t),s(e,Nd,t),s(e,Vd,t),s(e,Bd,t),s(e,es,t),s(e,Kd,t),p(ts,e,t),s(e,Qd,t),s(e,ls,t),s(e,Sd,t),s(e,ss,t),s(e,Wd,t),s(e,ns,t),s(e,Yd,t),s(e,Fd,t),s(e,Od,t),s(e,os,t),s(e,Gd,t),p(is,e,t),s(e,Zd,t),s(e,rs,t),s(e,Xd,t),s(e,ds,t),s(e,ea,t),s(e,as,t),s(e,ta,t),s(e,us,t),s(e,la,t),p(ms,e,t),s(e,sa,t),s(e,na,t),s(e,oa,t),s(e,ps,t),s(e,ia,t),p(cs,e,t),s(e,ra,t),s(e,fs,t),s(e,da,t),s(e,aa,t),s(e,ua,t),s(e,Ts,t),s(e,ma,t),p(hs,e,t),s(e,pa,t),s(e,_s,t),s(e,ca,t),s(e,fa,t),s(e,Ta,t),s(e,$s,t),s(e,ha,t),p(ys,e,t),s(e,_a,t),s(e,vs,t),s(e,$a,t),s(e,Ms,t),s(e,ya,t),p(bs,e,t),s(e,va,t),s(e,xs,t),s(e,Ma,t),p(Cs,e,t),s(e,ba,t),s(e,Hs,t),s(e,xa,t),p(Ls,e,t),s(e,Ca,t),s(e,Ha,t),s(e,La,t),s(e,As,t),wa=!0},p:Fm,i(e){wa||(c(v.$$.fragment,e),c(H.$$.fragment,e),c(U.$$.fragment,e),c(z.$$.fragment,e),c(k.$$.fragment,e),c(V.$$.fragment,e),c(S.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(oe.$$.fragment,e),c(ae.$$.fragment,e),c(ce.$$.fragment,e),c($e.$$.fragment,e),c(xe.$$.fragment,e),c(Ae.$$.fragment,e),c(ze.$$.fragment,e),c(De.$$.fragment,e),c(Be.$$.fragment,e),c(Ye.$$.fragment,e),c(Xe.$$.fragment,e),c(nt.$$.fragment,e),c(dt.$$.fragment,e),c(ft.$$.fragment,e),c($t.$$.fragment,e),c(Ct.$$.fragment,e),c(At.$$.fragment,e),c(Rt.$$.fragment,e),c(kt.$$.fragment,e),c(Vt.$$.fragment,e),c(St.$$.fragment,e),c(Gt.$$.fragment,e),c(tl.$$.fragment,e),c(ol.$$.fragment,e),c(ul.$$.fragment,e),c(Tl.$$.fragment,e),c(vl.$$.fragment,e),c(Hl.$$.fragment,e),c(gl.$$.fragment,e),c(jl.$$.fragment,e),c(ql.$$.fragment,e),c(Ql.$$.fragment,e),c(Ol.$$.fragment,e),c(ts.$$.fragment,e),c(is.$$.fragment,e),c(ms.$$.fragment,e),c(cs.$$.fragment,e),c(hs.$$.fragment,e),c(ys.$$.fragment,e),c(bs.$$.fragment,e),c(Cs.$$.fragment,e),c(Ls.$$.fragment,e),wa=!0)},o(e){f(v.$$.fragment,e),f(H.$$.fragment,e),f(U.$$.fragment,e),f(z.$$.fragment,e),f(k.$$.fragment,e),f(V.$$.fragment,e),f(S.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(ae.$$.fragment,e),f(ce.$$.fragment,e),f($e.$$.fragment,e),f(xe.$$.fragment,e),f(Ae.$$.fragment,e),f(ze.$$.fragment,e),f(De.$$.fragment,e),f(Be.$$.fragment,e),f(Ye.$$.fragment,e),f(Xe.$$.fragment,e),f(nt.$$.fragment,e),f(dt.$$.fragment,e),f(ft.$$.fragment,e),f($t.$$.fragment,e),f(Ct.$$.fragment,e),f(At.$$.fragment,e),f(Rt.$$.fragment,e),f(kt.$$.fragment,e),f(Vt.$$.fragment,e),f(St.$$.fragment,e),f(Gt.$$.fragment,e),f(tl.$$.fragment,e),f(ol.$$.fragment,e),f(ul.$$.fragment,e),f(Tl.$$.fragment,e),f(vl.$$.fragment,e),f(Hl.$$.fragment,e),f(gl.$$.fragment,e),f(jl.$$.fragment,e),f(ql.$$.fragment,e),f(Ql.$$.fragment,e),f(Ol.$$.fragment,e),f(ts.$$.fragment,e),f(is.$$.fragment,e),f(ms.$$.fragment,e),f(cs.$$.fragment,e),f(hs.$$.fragment,e),f(ys.$$.fragment,e),f(bs.$$.fragment,e),f(Cs.$$.fragment,e),f(Ls.$$.fragment,e),wa=!1},d(e){e&&(l(Us),l(ws),l(gs),l(y),l(Ps),l(Rs),l(M),l(zs),l(b),l(Js),l(x),l(js),l(Es),l(ks),l(C),l(Ds),l(Is),l(L),l(qs),l(w),l(Ns),l(Vs),l(Bs),l(A),l(Ks),l(Qs),l(g),l(Ss),l(P),l(Ws),l(Ys),l(Fs),l(R),l(Os),l(Gs),l(J),l(Zs),l(j),l(Xs),l(en),l(tn),l(E),l(ln),l(sn),l(D),l(nn),l(I),l(on),l(q),l(rn),l(dn),l(an),l(N),l(un),l(mn),l(B),l(pn),l(K),l(cn),l(fn),l(Tn),l(Q),l(hn),l(_n),l(W),l($n),l(Y),l(yn),l(vn),l(Mn),l(F),l(bn),l(xn),l(G),l(Cn),l(Z),l(Hn),l(X),l(Ln),l(wn),l(An),l(ee),l(Un),l(gn),l(le),l(Pn),l(se),l(Rn),l(zn),l(Jn),l(ne),l(jn),l(En),l(ie),l(kn),l(re),l(Dn),l(In),l(qn),l(de),l(Nn),l(Vn),l(ue),l(Bn),l(me),l(Kn),l(Qn),l(Sn),l(pe),l(Wn),l(Yn),l(fe),l(Fn),l(Te),l(On),l(he),l(Gn),l(Zn),l(Xn),l(_e),l(eo),l(to),l(ye),l(lo),l(ve),l(so),l(Me),l(no),l(oo),l(io),l(be),l(ro),l(ao),l(Ce),l(uo),l(He),l(mo),l(Le),l(po),l(co),l(fo),l(we),l(To),l(ho),l(Ue),l(_o),l(ge),l($o),l(Pe),l(yo),l(vo),l(Mo),l(Re),l(bo),l(xo),l(Je),l(Co),l(je),l(Ho),l(Ee),l(Lo),l(wo),l(Ao),l(ke),l(Uo),l(go),l(Ie),l(Po),l(qe),l(Ro),l(Ne),l(zo),l(Jo),l(jo),l(Ve),l(Eo),l(ko),l(Ke),l(Do),l(Qe),l(Io),l(Se),l(qo),l(No),l(Vo),l(We),l(Bo),l(Ko),l(Fe),l(Qo),l(Oe),l(So),l(Ge),l(Wo),l(Yo),l(Fo),l(Ze),l(Oo),l(Go),l(et),l(Zo),l(tt),l(Xo),l(lt),l(ei),l(ti),l(li),l(st),l(si),l(ni),l(ot),l(oi),l(it),l(ii),l(ri),l(di),l(rt),l(ai),l(ui),l(at),l(mi),l(ut),l(pi),l(mt),l(ci),l(pt),l(fi),l(Ti),l(hi),l(ct),l(_i),l($i),l(Tt),l(yi),l(ht),l(vi),l(Mi),l(bi),l(_t),l(xi),l(Ci),l(yt),l(Hi),l(vt),l(Li),l(Mt),l(wi),l(bt),l(Ai),l(Ui),l(gi),l(xt),l(Pi),l(Ri),l(Ht),l(zi),l(Lt),l(Ji),l(ji),l(Ei),l(wt),l(ki),l(Di),l(Ut),l(Ii),l(gt),l(qi),l(Ni),l(Vi),l(Pt),l(Bi),l(Ki),l(zt),l(Qi),l(Jt),l(Si),l(jt),l(Wi),l(Yi),l(Fi),l(Et),l(Oi),l(Gi),l(Dt),l(Zi),l(It),l(Xi),l(qt),l(er),l(tr),l(lr),l(Nt),l(sr),l(nr),l(Bt),l(or),l(Kt),l(ir),l(rr),l(dr),l(Qt),l(ar),l(ur),l(Wt),l(mr),l(Yt),l(pr),l(Ft),l(cr),l(fr),l(Tr),l(Ot),l(hr),l(_r),l(Zt),l($r),l(Xt),l(yr),l(vr),l(Mr),l(el),l(br),l(xr),l(ll),l(Cr),l(sl),l(Hr),l(Lr),l(wr),l(nl),l(Ar),l(Ur),l(il),l(gr),l(rl),l(Pr),l(dl),l(Rr),l(zr),l(Jr),l(al),l(jr),l(Er),l(ml),l(kr),l(pl),l(Dr),l(cl),l(Ir),l(qr),l(Nr),l(fl),l(Vr),l(Br),l(hl),l(Kr),l(_l),l(Qr),l($l),l(Sr),l(Wr),l(Yr),l(yl),l(Fr),l(Or),l(Ml),l(Gr),l(bl),l(Zr),l(xl),l(Xr),l(ed),l(td),l(Cl),l(ld),l(sd),l(Ll),l(nd),l(wl),l(od),l(Al),l(id),l(rd),l(dd),l(Ul),l(ad),l(ud),l(Pl),l(md),l(Rl),l(pd),l(zl),l(cd),l(fd),l(Td),l(Jl),l(hd),l(_d),l(El),l($d),l(kl),l(yd),l(Dl),l(vd),l(Md),l(bd),l(Il),l(xd),l(Cd),l(Nl),l(Hd),l(Vl),l(Ld),l(Bl),l(wd),l(Ad),l(Ud),l(Kl),l(gd),l(Pd),l(Sl),l(Rd),l(Wl),l(zd),l(Yl),l(Jd),l(jd),l(Ed),l(Fl),l(kd),l(Dd),l(Gl),l(Id),l(Zl),l(qd),l(Xl),l(Nd),l(Vd),l(Bd),l(es),l(Kd),l(Qd),l(ls),l(Sd),l(ss),l(Wd),l(ns),l(Yd),l(Fd),l(Od),l(os),l(Gd),l(Zd),l(rs),l(Xd),l(ds),l(ea),l(as),l(ta),l(us),l(la),l(sa),l(na),l(oa),l(ps),l(ia),l(ra),l(fs),l(da),l(aa),l(ua),l(Ts),l(ma),l(pa),l(_s),l(ca),l(fa),l(Ta),l($s),l(ha),l(_a),l(vs),l($a),l(Ms),l(ya),l(va),l(xs),l(Ma),l(ba),l(Hs),l(xa),l(Ca),l(Ha),l(La),l(As)),l($),T(v,e),T(H,e),T(U,e),T(z,e),T(k,e),T(V,e),T(S,e),T(O,e),T(te,e),T(oe,e),T(ae,e),T(ce,e),T($e,e),T(xe,e),T(Ae,e),T(ze,e),T(De,e),T(Be,e),T(Ye,e),T(Xe,e),T(nt,e),T(dt,e),T(ft,e),T($t,e),T(Ct,e),T(At,e),T(Rt,e),T(kt,e),T(Vt,e),T(St,e),T(Gt,e),T(tl,e),T(ol,e),T(ul,e),T(Tl,e),T(vl,e),T(Hl,e),T(gl,e),T(jl,e),T(ql,e),T(Ql,e),T(Ol,e),T(ts,e),T(is,e),T(ms,e),T(cs,e),T(hs,e),T(ys,e),T(bs,e),T(Cs,e),T(Ls,e)}}}const lp='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code>","local":"tensoritem--code-number-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.transpose(...dims) ⇒ <code> Tensor </code>","local":"tensortransposedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒","local":"tensorsqueezedim-","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒","local":"tensorunsqueezedim-","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒","local":"tensorflattenstartdim-enddim-","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒","local":"tensorclampmin-max-","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒","local":"tensorround-","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensortransposetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒","local":"utilstensormeaninput-dim-keepdim-","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor.ones(size)","local":"utilstensoronessize","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒","local":"utilstensoronesliketensor-","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function sp(Ua){return Om(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dp extends Gm{constructor($){super(),Zm(this,$,sp,tp,Ym,{})}}export{dp as component};
