import{s as ht,n as wt,o as mt}from"../chunks/scheduler.362310b7.js";import{S as It,i as ft,g as i,s,r as y,A as dt,h as o,f as l,c as a,j as Jt,u as p,x as M,k as Xe,y as Ct,a as n,v as c,d as u,t as r,w as U}from"../chunks/index.57dfc70d.js";import{C as J}from"../chunks/CodeBlock.5d40996c.js";import{H as m,E as gt}from"../chunks/index.fa158b42.js";function jt(Le){let T,ae,ne,ie,I,oe,f,Fe='There are many ways to consume Text Generation Inference (TGI) server in your applications. After launching the server, you can use the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">Messages API</a> <code>/v1/chat/completions</code> route and make a <code>POST</code> request to get results from the server. You can also pass <code>&quot;stream&quot;: true</code> to the call if you want TGI to return a stream of tokens.',Me,d,Pe='For more information on the API, consult the OpenAPI documentation of <code>text-generation-inference</code> available <a href="https://huggingface.github.io/text-generation-inference" rel="nofollow">here</a>.',ye,C,De='You can make the requests using any tool of your preference, such as curl, Python, or TypeScript. For an end-to-end experience, we’ve open-sourced <a href="https://github.com/huggingface/chat-ui" rel="nofollow">ChatUI</a>, a chat interface for open-access models.',pe,g,ce,j,Oe="After a successful server launch, you can query the model using the <code>v1/chat/completions</code> route, to get responses that are compliant to the OpenAI Chat Completion spec:",ue,b,re,$,Ke="For non-chat use-cases, you can also use the <code>/generate</code> and <code>/generate_stream</code> routes.",Ue,G,Te,Q,Je,B,he,q,et='<a href="https://huggingface.co/docs/huggingface_hub/main/en/index" rel="nofollow"><code>huggingface_hub</code></a> is a Python library to interact with the Hugging Face Hub, including its endpoints. It provides a high-level class, <a href="https://huggingface.co/docs/huggingface_hub/package_reference/inference_client#huggingface_hub.InferenceClient" rel="nofollow"><code>huggingface_hub.InferenceClient</code></a>, which makes it easy to make calls to TGI’s Messages API. <code>InferenceClient</code> also takes care of parameter validation and provides a simple-to-use interface.',we,v,tt="Install <code>huggingface_hub</code> package via pip.",me,A,Ie,Z,lt="You can now use <code>InferenceClient</code> the exact same way you would use <code>OpenAI</code> client in Python",fe,Y,de,k,nt='You can check out more details about OpenAI compatibility <a href="https://huggingface.co/docs/huggingface_hub/en/guides/inference#openai-compatibility" rel="nofollow">here</a>.',Ce,S,st='There is also an async version of the client, <code>AsyncInferenceClient</code>, based on <code>asyncio</code> and <code>aiohttp</code>. You can find docs for it <a href="https://huggingface.co/docs/huggingface_hub/package_reference/inference_client#huggingface_hub.AsyncInferenceClient" rel="nofollow">here</a>',ge,E,je,V,at='You can directly use the OpenAI <a href="https://github.com/openai/openai-python" rel="nofollow">Python</a> or <a href="https://github.com/openai/openai-node" rel="nofollow">JS</a> clients to interact with TGI.',be,W,it="Install the OpenAI Python package via pip.",$e,_,Ge,N,Qe,x,Be,H,qe,R,ot="Gradio is a Python library that helps you build web applications for your machine learning models with a few lines of code. It has a <code>ChatInterface</code> wrapper that helps create neat UIs for chatbots. Let’s take a look at how to create a chatbot with streaming mode using TGI and Gradio. Let’s install Gradio and Hub Python library first.",ve,z,Ae,X,Mt='Assume you are serving your model on port 8080, we will query through <a href="consuming_tgi#inference-client">InferenceClient</a>.',Ze,L,Ye,F,yt="You can check out the UI and try the demo directly here 👇",ke,h,pt='<iframe src="https://merve-gradio-tgi-2.hf.space?__theme=light" width="850" height="750"></iframe>',Se,w,ct='<iframe src="https://merve-gradio-tgi-2.hf.space?__theme=dark" width="850" height="750"></iframe>',Ee,P,ut='You can read more about how to customize a <code>ChatInterface</code> <a href="https://www.gradio.app/guides/creating-a-chatbot-fast" rel="nofollow">here</a>.',Ve,D,We,O,rt='<a href="https://github.com/huggingface/chat-ui" rel="nofollow">ChatUI</a> is an open-source interface built for consuming LLMs. It offers many customization options, such as web search with SERP API and more. ChatUI can automatically consume the TGI server and even provides an option to switch between different TGI endpoints. You can try it out at <a href="https://huggingface.co/chat/" rel="nofollow">Hugging Chat</a>, or use the <a href="https://huggingface.co/new-space?template=huggingchat/chat-ui-template" rel="nofollow">ChatUI Docker Space</a> to deploy your own Hugging Chat to Spaces.',_e,K,Ut="To serve both ChatUI and TGI in same environment, simply add your own endpoints to the <code>MODELS</code> variable in <code>.env.local</code> file inside the <code>chat-ui</code> repository. Provide the endpoints pointing to where TGI is served.",Ne,ee,xe,te,Tt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/chatui_screen.png" alt="ChatUI"/>',He,le,Re,se,ze;return I=new m({props:{title:"Consuming Text Generation Inference",local:"consuming-text-generation-inference",headingTag:"h1"}}),g=new m({props:{title:"curl",local:"curl",headingTag:"h2"}}),b=new J({props:{code:"Y3VybCUyMGxvY2FsaG9zdCUzQTgwODAlMkZ2MSUyRmNoYXQlMkZjb21wbGV0aW9ucyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMm1vZGVsJTIyJTNBJTIwJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnN0cmVhbSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJtYXhfdG9rZW5zJTIyJTNBJTIwMjAlMEElN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJw==",highlighted:`curl localhost:8080/v1/chat/completions \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{
  &quot;model&quot;: &quot;tgi&quot;,
  &quot;messages&quot;: [
    {
      &quot;role&quot;: &quot;system&quot;,
      &quot;content&quot;: &quot;You are a helpful assistant.&quot;
    },
    {
      &quot;role&quot;: &quot;user&quot;,
      &quot;content&quot;: &quot;What is deep learning?&quot;
    }
  ],
  &quot;stream&quot;: true,
  &quot;max_tokens&quot;: 20
}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),G=new J({props:{code:"Y3VybCUyMDEyNy4wLjAuMSUzQTgwODAlMkZnZW5lcmF0ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUwQSUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiUyQyUwQSUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElN0IlMEElMjAlMjAlMjAlMjAlMjJtYXhfbmV3X3Rva2VucyUyMiUzQTIwJTBBJTIwJTIwJTdEJTBBJTdEJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJ0NvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbic=",highlighted:`curl 127.0.0.1:8080/generate \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{
  &quot;inputs&quot;:&quot;What is Deep Learning?&quot;,
  &quot;parameters&quot;:{
    &quot;max_new_tokens&quot;:20
  }
}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),Q=new m({props:{title:"Python",local:"python",headingTag:"h2"}}),B=new m({props:{title:"Inference Client",local:"inference-client",headingTag:"h3"}}),A=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:"pip install huggingface_hub",wrap:!1}}),Y=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRCUyMmh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDgwJTJGdjElMkYlMjIlMkMlMEEpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNvdW50JTIwdG8lMjAxMCUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNEMTAyNCUyQyUwQSklMEElMEFmb3IlMjBjaHVuayUyMGluJTIwb3V0cHV0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoY2h1bmsuY2hvaWNlcyU1QjAlNUQuZGVsdGEuY29udGVudCk=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(
    base_url=<span class="hljs-string">&quot;http://localhost:8080/v1/&quot;</span>,
)

output = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),E=new m({props:{title:"OpenAI Client",local:"openai-client",headingTag:"h3"}}),_=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMG9wZW5haQ==",highlighted:"pip install openai",wrap:!1}}),N=new J({props:{code:"ZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSUwQSUwQSUyMyUyMGluaXQlMjB0aGUlMjBjbGllbnQlMjBidXQlMjBwb2ludCUyMGl0JTIwdG8lMjBUR0klMEFjbGllbnQlMjAlM0QlMjBPcGVuQUkoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBODA4MCUyRnYxJTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMi0lMjIlMEEpJTBBJTBBY2hhdF9jb21wbGV0aW9uJTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGdpJTIyJTJDJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBoZWxwZnVsJTIwYXNzaXN0YW50LiUyMiUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMGRlZXAlMjBsZWFybmluZyUzRiUyMiU3RCUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMHN0cmVhbSUzRFRydWUlMEEpJTBBJTBBJTIzJTIwaXRlcmF0ZSUyMGFuZCUyMHByaW50JTIwc3RyZWFtJTBBZm9yJTIwbWVzc2FnZSUyMGluJTIwY2hhdF9jb21wbGV0aW9uJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobWVzc2FnZSk=",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># init the client but point it to TGI</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:8080/v1/&quot;</span>,
    api_key=<span class="hljs-string">&quot;-&quot;</span>
)

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span> },
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is deep learning?&quot;</span>}
    ],
    stream=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># iterate and print stream</span>
<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> chat_completion:
    <span class="hljs-built_in">print</span>(message)`,wrap:!1}}),x=new m({props:{title:"UI",local:"ui",headingTag:"h2"}}),H=new m({props:{title:"Gradio",local:"gradio",headingTag:"h3"}}),z=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlLWh1YiUyMGdyYWRpbw==",highlighted:"pip install huggingface-hub gradio",wrap:!1}}),L=new J({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoYmFzZV91cmwlM0QlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODA4MCUyMiklMEElMEFkZWYlMjBpbmZlcmVuY2UobWVzc2FnZSUyQyUyMGhpc3RvcnkpJTNBJTBBJTIwJTIwJTIwJTIwcGFydGlhbF9tZXNzYWdlJTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjBtZXNzYWdlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwYXJ0aWFsX21lc3NhZ2UlMjAlMkIlM0QlMjBjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBwYXJ0aWFsX21lc3NhZ2UlMEElMEFnci5DaGF0SW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGluZmVyZW5jZSUyQyUwQSUyMCUyMCUyMCUyMHR5cGUlM0QlMjJtZXNzYWdlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyVGhpcyUyMGlzJTIwdGhlJTIwZGVtbyUyMGZvciUyMEdyYWRpbyUyMFVJJTIwY29uc3VtaW5nJTIwVEdJJTIwZW5kcG9pbnQuJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGl0bGUlM0QlMjJHcmFkaW8lMjAlRjAlOUYlQTQlOUQlMjBUR0klMjIlMkMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyUzRCU1QiUyMkFyZSUyMHRvbWF0b2VzJTIwdmVnZXRhYmxlcyUzRiUyMiU1RCUyQyUwQSkucXVldWUoKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(base_url=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">inference</span>(<span class="hljs-params">message, history</span>):
    partial_message = <span class="hljs-string">&quot;&quot;</span>
    output = client.chat.completions.create(
        messages=[
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: message},
        ],
        stream=<span class="hljs-literal">True</span>,
        max_tokens=<span class="hljs-number">1024</span>,
    )

    <span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
        partial_message += chunk.choices[<span class="hljs-number">0</span>].delta.content
        <span class="hljs-keyword">yield</span> partial_message

gr.ChatInterface(
    inference,
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;messages&quot;</span>,
    description=<span class="hljs-string">&quot;This is the demo for Gradio UI consuming TGI endpoint.&quot;</span>,
    title=<span class="hljs-string">&quot;Gradio 🤝 TGI&quot;</span>,
    examples=[<span class="hljs-string">&quot;Are tomatoes vegetables?&quot;</span>],
).queue().launch()`,wrap:!1}}),D=new m({props:{title:"ChatUI",local:"chatui",headingTag:"h3"}}),ee=new J({props:{code:"JTdCJTBBJTJGJTJGJTIwcmVzdCUyMG9mJTIwdGhlJTIwbW9kZWwlMjBjb25maWclMjBoZXJlJTBBJTIyZW5kcG9pbnRzJTIyJTNBJTIwJTVCJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZIT1NUJTNBUE9SVCUyRmdlbmVyYXRlX3N0cmVhbSUyMiU3RCU1RCUwQSU3RA==",highlighted:`{
<span class="hljs-comment">// rest of the model config here</span>
<span class="hljs-string">&quot;endpoints&quot;</span>: <span class="hljs-selector-attr">[{<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://HOST:PORT/generate_stream&quot;</span>}]</span>
}`,wrap:!1}}),le=new gt({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/consuming_tgi.md"}}),{c(){T=i("meta"),ae=s(),ne=i("p"),ie=s(),y(I.$$.fragment),oe=s(),f=i("p"),f.innerHTML=Fe,Me=s(),d=i("p"),d.innerHTML=Pe,ye=s(),C=i("p"),C.innerHTML=De,pe=s(),y(g.$$.fragment),ce=s(),j=i("p"),j.innerHTML=Oe,ue=s(),y(b.$$.fragment),re=s(),$=i("p"),$.innerHTML=Ke,Ue=s(),y(G.$$.fragment),Te=s(),y(Q.$$.fragment),Je=s(),y(B.$$.fragment),he=s(),q=i("p"),q.innerHTML=et,we=s(),v=i("p"),v.innerHTML=tt,me=s(),y(A.$$.fragment),Ie=s(),Z=i("p"),Z.innerHTML=lt,fe=s(),y(Y.$$.fragment),de=s(),k=i("p"),k.innerHTML=nt,Ce=s(),S=i("p"),S.innerHTML=st,ge=s(),y(E.$$.fragment),je=s(),V=i("p"),V.innerHTML=at,be=s(),W=i("p"),W.textContent=it,$e=s(),y(_.$$.fragment),Ge=s(),y(N.$$.fragment),Qe=s(),y(x.$$.fragment),Be=s(),y(H.$$.fragment),qe=s(),R=i("p"),R.innerHTML=ot,ve=s(),y(z.$$.fragment),Ae=s(),X=i("p"),X.innerHTML=Mt,Ze=s(),y(L.$$.fragment),Ye=s(),F=i("p"),F.textContent=yt,ke=s(),h=i("div"),h.innerHTML=pt,Se=s(),w=i("div"),w.innerHTML=ct,Ee=s(),P=i("p"),P.innerHTML=ut,Ve=s(),y(D.$$.fragment),We=s(),O=i("p"),O.innerHTML=rt,_e=s(),K=i("p"),K.innerHTML=Ut,Ne=s(),y(ee.$$.fragment),xe=s(),te=i("p"),te.innerHTML=Tt,He=s(),y(le.$$.fragment),Re=s(),se=i("p"),this.h()},l(e){const t=dt("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(l),ae=a(e),ne=o(e,"P",{}),Jt(ne).forEach(l),ie=a(e),p(I.$$.fragment,e),oe=a(e),f=o(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-1non8wj"&&(f.innerHTML=Fe),Me=a(e),d=o(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1t76z0a"&&(d.innerHTML=Pe),ye=a(e),C=o(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-oukwy6"&&(C.innerHTML=De),pe=a(e),p(g.$$.fragment,e),ce=a(e),j=o(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-1wxmy7l"&&(j.innerHTML=Oe),ue=a(e),p(b.$$.fragment,e),re=a(e),$=o(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-12ryehu"&&($.innerHTML=Ke),Ue=a(e),p(G.$$.fragment,e),Te=a(e),p(Q.$$.fragment,e),Je=a(e),p(B.$$.fragment,e),he=a(e),q=o(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1nct937"&&(q.innerHTML=et),we=a(e),v=o(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-eh4afd"&&(v.innerHTML=tt),me=a(e),p(A.$$.fragment,e),Ie=a(e),Z=o(e,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-e5lfi8"&&(Z.innerHTML=lt),fe=a(e),p(Y.$$.fragment,e),de=a(e),k=o(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-uzsr3u"&&(k.innerHTML=nt),Ce=a(e),S=o(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1m8kffa"&&(S.innerHTML=st),ge=a(e),p(E.$$.fragment,e),je=a(e),V=o(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-nfjply"&&(V.innerHTML=at),be=a(e),W=o(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-11zntwb"&&(W.textContent=it),$e=a(e),p(_.$$.fragment,e),Ge=a(e),p(N.$$.fragment,e),Qe=a(e),p(x.$$.fragment,e),Be=a(e),p(H.$$.fragment,e),qe=a(e),R=o(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-24oiaj"&&(R.innerHTML=ot),ve=a(e),p(z.$$.fragment,e),Ae=a(e),X=o(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-4m25xv"&&(X.innerHTML=Mt),Ze=a(e),p(L.$$.fragment,e),Ye=a(e),F=o(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1cn4b0y"&&(F.textContent=yt),ke=a(e),h=o(e,"DIV",{class:!0,"data-svelte-h":!0}),M(h)!=="svelte-eisylj"&&(h.innerHTML=pt),Se=a(e),w=o(e,"DIV",{class:!0,"data-svelte-h":!0}),M(w)!=="svelte-diccf8"&&(w.innerHTML=ct),Ee=a(e),P=o(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-6b9edz"&&(P.innerHTML=ut),Ve=a(e),p(D.$$.fragment,e),We=a(e),O=o(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1wn8bv6"&&(O.innerHTML=rt),_e=a(e),K=o(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-ll7db"&&(K.innerHTML=Ut),Ne=a(e),p(ee.$$.fragment,e),xe=a(e),te=o(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-16nfqnk"&&(te.innerHTML=Tt),He=a(e),p(le.$$.fragment,e),Re=a(e),se=o(e,"P",{}),Jt(se).forEach(l),this.h()},h(){Xe(T,"name","hf:doc:metadata"),Xe(T,"content",bt),Xe(h,"class","block dark:hidden"),Xe(w,"class","hidden dark:block")},m(e,t){Ct(document.head,T),n(e,ae,t),n(e,ne,t),n(e,ie,t),c(I,e,t),n(e,oe,t),n(e,f,t),n(e,Me,t),n(e,d,t),n(e,ye,t),n(e,C,t),n(e,pe,t),c(g,e,t),n(e,ce,t),n(e,j,t),n(e,ue,t),c(b,e,t),n(e,re,t),n(e,$,t),n(e,Ue,t),c(G,e,t),n(e,Te,t),c(Q,e,t),n(e,Je,t),c(B,e,t),n(e,he,t),n(e,q,t),n(e,we,t),n(e,v,t),n(e,me,t),c(A,e,t),n(e,Ie,t),n(e,Z,t),n(e,fe,t),c(Y,e,t),n(e,de,t),n(e,k,t),n(e,Ce,t),n(e,S,t),n(e,ge,t),c(E,e,t),n(e,je,t),n(e,V,t),n(e,be,t),n(e,W,t),n(e,$e,t),c(_,e,t),n(e,Ge,t),c(N,e,t),n(e,Qe,t),c(x,e,t),n(e,Be,t),c(H,e,t),n(e,qe,t),n(e,R,t),n(e,ve,t),c(z,e,t),n(e,Ae,t),n(e,X,t),n(e,Ze,t),c(L,e,t),n(e,Ye,t),n(e,F,t),n(e,ke,t),n(e,h,t),n(e,Se,t),n(e,w,t),n(e,Ee,t),n(e,P,t),n(e,Ve,t),c(D,e,t),n(e,We,t),n(e,O,t),n(e,_e,t),n(e,K,t),n(e,Ne,t),c(ee,e,t),n(e,xe,t),n(e,te,t),n(e,He,t),c(le,e,t),n(e,Re,t),n(e,se,t),ze=!0},p:wt,i(e){ze||(u(I.$$.fragment,e),u(g.$$.fragment,e),u(b.$$.fragment,e),u(G.$$.fragment,e),u(Q.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(_.$$.fragment,e),u(N.$$.fragment,e),u(x.$$.fragment,e),u(H.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(ee.$$.fragment,e),u(le.$$.fragment,e),ze=!0)},o(e){r(I.$$.fragment,e),r(g.$$.fragment,e),r(b.$$.fragment,e),r(G.$$.fragment,e),r(Q.$$.fragment,e),r(B.$$.fragment,e),r(A.$$.fragment,e),r(Y.$$.fragment,e),r(E.$$.fragment,e),r(_.$$.fragment,e),r(N.$$.fragment,e),r(x.$$.fragment,e),r(H.$$.fragment,e),r(z.$$.fragment,e),r(L.$$.fragment,e),r(D.$$.fragment,e),r(ee.$$.fragment,e),r(le.$$.fragment,e),ze=!1},d(e){e&&(l(ae),l(ne),l(ie),l(oe),l(f),l(Me),l(d),l(ye),l(C),l(pe),l(ce),l(j),l(ue),l(re),l($),l(Ue),l(Te),l(Je),l(he),l(q),l(we),l(v),l(me),l(Ie),l(Z),l(fe),l(de),l(k),l(Ce),l(S),l(ge),l(je),l(V),l(be),l(W),l($e),l(Ge),l(Qe),l(Be),l(qe),l(R),l(ve),l(Ae),l(X),l(Ze),l(Ye),l(F),l(ke),l(h),l(Se),l(w),l(Ee),l(P),l(Ve),l(We),l(O),l(_e),l(K),l(Ne),l(xe),l(te),l(He),l(Re),l(se)),l(T),U(I,e),U(g,e),U(b,e),U(G,e),U(Q,e),U(B,e),U(A,e),U(Y,e),U(E,e),U(_,e),U(N,e),U(x,e),U(H,e),U(z,e),U(L,e),U(D,e),U(ee,e),U(le,e)}}}const bt='{"title":"Consuming Text Generation Inference","local":"consuming-text-generation-inference","sections":[{"title":"curl","local":"curl","sections":[],"depth":2},{"title":"Python","local":"python","sections":[{"title":"Inference Client","local":"inference-client","sections":[],"depth":3},{"title":"OpenAI Client","local":"openai-client","sections":[],"depth":3}],"depth":2},{"title":"UI","local":"ui","sections":[{"title":"Gradio","local":"gradio","sections":[],"depth":3},{"title":"ChatUI","local":"chatui","sections":[],"depth":3}],"depth":2}],"depth":1}';function $t(Le){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends It{constructor(T){super(),ft(this,T,$t,jt,ht,{})}}export{vt as component};
