import{s as ft,n as kt,o as vt}from"../chunks/scheduler.65852ee5.js";import{S as Bt,i as At,g as M,s,r as o,A as $t,h as i,f as l,c as a,j as bt,u as y,x as w,k as gt,y as Zt,a as n,v as J,d as T,t as U,w as p}from"../chunks/index.65a1b999.js";import{D as _t,C as r}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as Pe,E as St}from"../chunks/index.37c62cb6.js";function Wt(De){let C,Me,se,ie,I,we,m,oe,c,Oe='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',ye,d,Ke='<p>This tutorial is advanced. You should have notions from <a href="agents">this other cookbook</a> first!</p>',Je,u,et="In this notebook we will make a <strong>multi-agent web browser: an agentic system with several agents collaborating to solve problems using the web!</strong>",Te,h,tt="It will be a simple hierarchy, using a <code>ManagedAgent</code> object to wrap the managed web search agent:",Ue,j,pe,b,lt="Let’s set up this system.",re,g,nt="Run the line below to install the required dependencies:",Ce,f,Ie,k,st="Let’s login in order to call the HF Inference API:",me,v,ce,B,at='⚡️ Our agent will be powered by <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a> using <code>HfApiEngine</code> class that uses HF’s Inference API: the Inference API allows to quickly and easily run any OS model.',de,A,Mt='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',ue,$,he,Z,je,_,it='For web browsing, we can already use our pre-existing <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/agents/search.py" rel="nofollow"><code>DuckDuckGoSearchTool</code></a> tool to provide a Google search equivalent.',be,S,wt=`But then we will also need to be able to peak into the page found by the <code>DuckDuckGoSearchTool</code>.
To do so, we could import the library’s built-in <code>VisitWebpageTool</code>, but we will build it again to see how it’s done.`,ge,W,ot="So let’s create our <code>VisitWebpageTool</code> tool from scratch using <code>markdownify</code>.",fe,G,ke,Q,yt="Ok, now let’s initialize and test our tool!",ve,L,Be,R,Jt=`Hugging Face - Wikipedia

[Jump to content](#bodyContent)

Main menu

Main menu
move to sidebar
hide

Navigation

* [Main page](/wiki/Main_Page "Visit the main page [z]")
* [Contents](/wiki/Wikipedia:Contents "Guides to browsing Wikipedia")
* [Current events](/wiki/Portal:Current_events "Articles related to current events")
* [Random article](/wiki/Special:Random "Visit a randomly selected article [x]")
* [About Wikipedia](/wiki/Wikipedia:About "Learn about Wikipedia and how it works")
* [Contac
`,Ae,V,$e,x,Tt="Now that we have all the tools <code>search</code> and <code>visit_webpage</code>, we can use them to create the web agent.",Ze,N,Ut="Which configuration to choose for this agent?",_e,X,pt="<li>Web browsing is a single-timeline task that does not require parallel tool calls, so JSON tool calling works well for that. We thus choose a <code>ReactJsonAgent</code>.</li> <li>Also, since sometimes web search requires exploring many pages before finding the correct answer, we prefer to increase the number of <code>max_iterations</code> to 10.</li>",Se,H,We,E,rt="We then wrap this agent into a <code>ManagedAgent</code> that will make it callable by its manager agent.",Ge,q,Qe,Y,Ct="Finally we create a manager agent, and upon initialization we pass our managed agent to it in its <code>managed_agents</code> argument.",Le,F,It="Since this agent is the one tasked with the planning and thinking, advanced reasoning will be beneficial, so a <code>ReactCodeAgent</code> will be the best choice.",Re,z,mt="Also, we want to ask a question that involves the current year: so let us add <code>additional_authorized_imports=[&quot;time&quot;, &quot;datetime&quot;]</code>",Ve,P,xe,D,ct="That’s all! Now let’s run our system! We select a question that requires some calculation and",Ne,O,Xe,K,dt="Our agents managed to efficiently collaborate towards solving the task! ✅",He,ee,ut="💡 You can easily extend this to more agents: one does the code execution, one the web search, one handles file loadings…",Ee,te,ht="🤔💭 One could even think of doing more complex, tree-like hierarchies, with one CEO agent handling multiple middle managers, each with several reports.",qe,le,jt="We could even add more intermediate layers of management, each with multiple daily meetings, lots of agile stuff with scrum masters, and each new component adds enough friction to ensure the tasks never get done… Ehm wait, no, let’s stick with our simple structure.",Ye,ne,Fe,ae,ze;return I=new _t({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/multiagent_web_assistant.ipynb"}]}}),m=new Pe({props:{title:"Have several agents collaborate in a multi-agent hierarchy 🤖🤝🤖",local:"have-several-agents-collaborate-in-a-multi-agent-hierarchy-",headingTag:"h1"}}),j=new r({props:{code:"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",highlighted:`              +----------------+
              |<span class="hljs-string"> Manager agent  </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
  Code interpreter   +--------------------------------+
       tool          |<span class="hljs-string">         Managed agent          </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">      </span>|<span class="hljs-string"> Web Search agent </span>|<span class="hljs-string">      </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">         </span>|<span class="hljs-string">            </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">  Web Search tool     </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">             Visit webpage tool </span>|
                     +--------------------------------+`,wrap:!1}}),f=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjBtYXJrZG93bmlmeSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwc21vbGFnZW50cyUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install markdownify duckduckgo-search smolagents --upgrade -q",wrap:!1}}),v=new r({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),$=new r({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjI=",highlighted:'model_id = <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>',wrap:!1}}),Z=new Pe({props:{title:"🔍 Create a web search tool",local:"-create-a-web-search-tool",headingTag:"h3"}}),G=new r({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify <span class="hljs-keyword">as</span> md
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = md(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),L=new r({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),V=new Pe({props:{title:"Build our multi-agent system 🤖🤝🤖",local:"build-our-multi-agent-system-",headingTag:"h2"}}),H=new r({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBUb29sQ2FsbGluZ0FnZW50JTJDJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwlMkMlMjBNYW5hZ2VkQWdlbnQlMkMlMjBEdWNrRHVja0dvU2VhcmNoVG9vbCUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQpJTBBJTBBd2ViX2FnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QkR1Y2tEdWNrR29TZWFyY2hUb29sKCklMkMlMjB2aXNpdF93ZWJwYWdlJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1heF9pdGVyYXRpb25zJTNEMTAlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, ToolCallingAgent, InferenceClientModel, ManagedAgent, DuckDuckGoSearchTool

model = InferenceClientModel(model_id)

web_agent = ToolCallingAgent(
    tools=[DuckDuckGoSearchTool(), visit_webpage],
    model=model,
    max_iterations=<span class="hljs-number">10</span>,
)`,wrap:!1}}),q=new r({props:{code:"bWFuYWdlZF93ZWJfYWdlbnQlMjAlM0QlMjBNYW5hZ2VkQWdlbnQoJTBBJTIwJTIwJTIwJTIwYWdlbnQlM0R3ZWJfYWdlbnQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoX2FnZW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSdW5zJTIwd2ViJTIwc2VhcmNoZXMlMjBmb3IlMjB5b3UuJTIwR2l2ZSUyMGl0JTIweW91ciUyMHF1ZXJ5JTIwYXMlMjBhbiUyMGFyZ3VtZW50LiUyMiUyQyUwQSk=",highlighted:`managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;search_agent&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>,
)`,wrap:!1}}),P=new r({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1Qm1hbmFnZWRfd2ViX2FnZW50JTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJ0aW1lJTIyJTJDJTIwJTIyZGF0ZXRpbWUlMjIlNUQlMkMlMEEp",highlighted:`manager_agent = CodeAgent(
    tools=[],
    model=model,
    managed_agents=[managed_web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;datetime&quot;</span>],
)`,wrap:!1}}),O=new r({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIySG93JTIwbWFueSUyMHllYXJzJTIwYWdvJTIwd2FzJTIwU3RyaXBlJTIwZm91bmRlZCUzRiUyMik=",highlighted:'manager_agent.run(<span class="hljs-string">&quot;How many years ago was Stripe founded?&quot;</span>)',wrap:!1}}),ne=new St({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/multiagent_web_assistant.md"}}),{c(){C=M("meta"),Me=s(),se=M("p"),ie=s(),o(I.$$.fragment),we=s(),o(m.$$.fragment),oe=s(),c=M("p"),c.innerHTML=Oe,ye=s(),d=M("blockquote"),d.innerHTML=Ke,Je=s(),u=M("p"),u.innerHTML=et,Te=s(),h=M("p"),h.innerHTML=tt,Ue=s(),o(j.$$.fragment),pe=s(),b=M("p"),b.textContent=lt,re=s(),g=M("p"),g.textContent=nt,Ce=s(),o(f.$$.fragment),Ie=s(),k=M("p"),k.textContent=st,me=s(),o(v.$$.fragment),ce=s(),B=M("p"),B.innerHTML=at,de=s(),A=M("p"),A.innerHTML=Mt,ue=s(),o($.$$.fragment),he=s(),o(Z.$$.fragment),je=s(),_=M("p"),_.innerHTML=it,be=s(),S=M("p"),S.innerHTML=wt,ge=s(),W=M("p"),W.innerHTML=ot,fe=s(),o(G.$$.fragment),ke=s(),Q=M("p"),Q.textContent=yt,ve=s(),o(L.$$.fragment),Be=s(),R=M("pre"),R.textContent=Jt,Ae=s(),o(V.$$.fragment),$e=s(),x=M("p"),x.innerHTML=Tt,Ze=s(),N=M("p"),N.textContent=Ut,_e=s(),X=M("ul"),X.innerHTML=pt,Se=s(),o(H.$$.fragment),We=s(),E=M("p"),E.innerHTML=rt,Ge=s(),o(q.$$.fragment),Qe=s(),Y=M("p"),Y.innerHTML=Ct,Le=s(),F=M("p"),F.innerHTML=It,Re=s(),z=M("p"),z.innerHTML=mt,Ve=s(),o(P.$$.fragment),xe=s(),D=M("p"),D.textContent=ct,Ne=s(),o(O.$$.fragment),Xe=s(),K=M("p"),K.textContent=dt,He=s(),ee=M("p"),ee.textContent=ut,Ee=s(),te=M("p"),te.textContent=ht,qe=s(),le=M("p"),le.textContent=jt,Ye=s(),o(ne.$$.fragment),Fe=s(),ae=M("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);C=i(t,"META",{name:!0,content:!0}),t.forEach(l),Me=a(e),se=i(e,"P",{}),bt(se).forEach(l),ie=a(e),y(I.$$.fragment,e),we=a(e),y(m.$$.fragment,e),oe=a(e),c=i(e,"P",{"data-svelte-h":!0}),w(c)!=="svelte-1xlqnsv"&&(c.innerHTML=Oe),ye=a(e),d=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),w(d)!=="svelte-uy67xy"&&(d.innerHTML=Ke),Je=a(e),u=i(e,"P",{"data-svelte-h":!0}),w(u)!=="svelte-45abwn"&&(u.innerHTML=et),Te=a(e),h=i(e,"P",{"data-svelte-h":!0}),w(h)!=="svelte-1se9mth"&&(h.innerHTML=tt),Ue=a(e),y(j.$$.fragment,e),pe=a(e),b=i(e,"P",{"data-svelte-h":!0}),w(b)!=="svelte-1occiln"&&(b.textContent=lt),re=a(e),g=i(e,"P",{"data-svelte-h":!0}),w(g)!=="svelte-ofrdjq"&&(g.textContent=nt),Ce=a(e),y(f.$$.fragment,e),Ie=a(e),k=i(e,"P",{"data-svelte-h":!0}),w(k)!=="svelte-64fox6"&&(k.textContent=st),me=a(e),y(v.$$.fragment,e),ce=a(e),B=i(e,"P",{"data-svelte-h":!0}),w(B)!=="svelte-prbpzw"&&(B.innerHTML=at),de=a(e),A=i(e,"P",{"data-svelte-h":!0}),w(A)!=="svelte-1faawbb"&&(A.innerHTML=Mt),ue=a(e),y($.$$.fragment,e),he=a(e),y(Z.$$.fragment,e),je=a(e),_=i(e,"P",{"data-svelte-h":!0}),w(_)!=="svelte-1ya2chk"&&(_.innerHTML=it),be=a(e),S=i(e,"P",{"data-svelte-h":!0}),w(S)!=="svelte-n7spa8"&&(S.innerHTML=wt),ge=a(e),W=i(e,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1ms2uj2"&&(W.innerHTML=ot),fe=a(e),y(G.$$.fragment,e),ke=a(e),Q=i(e,"P",{"data-svelte-h":!0}),w(Q)!=="svelte-hbvg5t"&&(Q.textContent=yt),ve=a(e),y(L.$$.fragment,e),Be=a(e),R=i(e,"PRE",{"data-svelte-h":!0}),w(R)!=="svelte-28re01"&&(R.textContent=Jt),Ae=a(e),y(V.$$.fragment,e),$e=a(e),x=i(e,"P",{"data-svelte-h":!0}),w(x)!=="svelte-5768lo"&&(x.innerHTML=Tt),Ze=a(e),N=i(e,"P",{"data-svelte-h":!0}),w(N)!=="svelte-noa5rw"&&(N.textContent=Ut),_e=a(e),X=i(e,"UL",{"data-svelte-h":!0}),w(X)!=="svelte-4uouvt"&&(X.innerHTML=pt),Se=a(e),y(H.$$.fragment,e),We=a(e),E=i(e,"P",{"data-svelte-h":!0}),w(E)!=="svelte-1by3x3d"&&(E.innerHTML=rt),Ge=a(e),y(q.$$.fragment,e),Qe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),w(Y)!=="svelte-12kldg5"&&(Y.innerHTML=Ct),Le=a(e),F=i(e,"P",{"data-svelte-h":!0}),w(F)!=="svelte-julrcm"&&(F.innerHTML=It),Re=a(e),z=i(e,"P",{"data-svelte-h":!0}),w(z)!=="svelte-hvhtn0"&&(z.innerHTML=mt),Ve=a(e),y(P.$$.fragment,e),xe=a(e),D=i(e,"P",{"data-svelte-h":!0}),w(D)!=="svelte-1gu46sl"&&(D.textContent=ct),Ne=a(e),y(O.$$.fragment,e),Xe=a(e),K=i(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-ollz3q"&&(K.textContent=dt),He=a(e),ee=i(e,"P",{"data-svelte-h":!0}),w(ee)!=="svelte-1v517hq"&&(ee.textContent=ut),Ee=a(e),te=i(e,"P",{"data-svelte-h":!0}),w(te)!=="svelte-58qi1z"&&(te.textContent=ht),qe=a(e),le=i(e,"P",{"data-svelte-h":!0}),w(le)!=="svelte-9myor3"&&(le.textContent=jt),Ye=a(e),y(ne.$$.fragment,e),Fe=a(e),ae=i(e,"P",{}),bt(ae).forEach(l),this.h()},h(){gt(C,"name","hf:doc:metadata"),gt(C,"content",Gt)},m(e,t){Zt(document.head,C),n(e,Me,t),n(e,se,t),n(e,ie,t),J(I,e,t),n(e,we,t),J(m,e,t),n(e,oe,t),n(e,c,t),n(e,ye,t),n(e,d,t),n(e,Je,t),n(e,u,t),n(e,Te,t),n(e,h,t),n(e,Ue,t),J(j,e,t),n(e,pe,t),n(e,b,t),n(e,re,t),n(e,g,t),n(e,Ce,t),J(f,e,t),n(e,Ie,t),n(e,k,t),n(e,me,t),J(v,e,t),n(e,ce,t),n(e,B,t),n(e,de,t),n(e,A,t),n(e,ue,t),J($,e,t),n(e,he,t),J(Z,e,t),n(e,je,t),n(e,_,t),n(e,be,t),n(e,S,t),n(e,ge,t),n(e,W,t),n(e,fe,t),J(G,e,t),n(e,ke,t),n(e,Q,t),n(e,ve,t),J(L,e,t),n(e,Be,t),n(e,R,t),n(e,Ae,t),J(V,e,t),n(e,$e,t),n(e,x,t),n(e,Ze,t),n(e,N,t),n(e,_e,t),n(e,X,t),n(e,Se,t),J(H,e,t),n(e,We,t),n(e,E,t),n(e,Ge,t),J(q,e,t),n(e,Qe,t),n(e,Y,t),n(e,Le,t),n(e,F,t),n(e,Re,t),n(e,z,t),n(e,Ve,t),J(P,e,t),n(e,xe,t),n(e,D,t),n(e,Ne,t),J(O,e,t),n(e,Xe,t),n(e,K,t),n(e,He,t),n(e,ee,t),n(e,Ee,t),n(e,te,t),n(e,qe,t),n(e,le,t),n(e,Ye,t),J(ne,e,t),n(e,Fe,t),n(e,ae,t),ze=!0},p:kt,i(e){ze||(T(I.$$.fragment,e),T(m.$$.fragment,e),T(j.$$.fragment,e),T(f.$$.fragment,e),T(v.$$.fragment,e),T($.$$.fragment,e),T(Z.$$.fragment,e),T(G.$$.fragment,e),T(L.$$.fragment,e),T(V.$$.fragment,e),T(H.$$.fragment,e),T(q.$$.fragment,e),T(P.$$.fragment,e),T(O.$$.fragment,e),T(ne.$$.fragment,e),ze=!0)},o(e){U(I.$$.fragment,e),U(m.$$.fragment,e),U(j.$$.fragment,e),U(f.$$.fragment,e),U(v.$$.fragment,e),U($.$$.fragment,e),U(Z.$$.fragment,e),U(G.$$.fragment,e),U(L.$$.fragment,e),U(V.$$.fragment,e),U(H.$$.fragment,e),U(q.$$.fragment,e),U(P.$$.fragment,e),U(O.$$.fragment,e),U(ne.$$.fragment,e),ze=!1},d(e){e&&(l(Me),l(se),l(ie),l(we),l(oe),l(c),l(ye),l(d),l(Je),l(u),l(Te),l(h),l(Ue),l(pe),l(b),l(re),l(g),l(Ce),l(Ie),l(k),l(me),l(ce),l(B),l(de),l(A),l(ue),l(he),l(je),l(_),l(be),l(S),l(ge),l(W),l(fe),l(ke),l(Q),l(ve),l(Be),l(R),l(Ae),l($e),l(x),l(Ze),l(N),l(_e),l(X),l(Se),l(We),l(E),l(Ge),l(Qe),l(Y),l(Le),l(F),l(Re),l(z),l(Ve),l(xe),l(D),l(Ne),l(Xe),l(K),l(He),l(ee),l(Ee),l(te),l(qe),l(le),l(Ye),l(Fe),l(ae)),l(C),p(I,e),p(m,e),p(j,e),p(f,e),p(v,e),p($,e),p(Z,e),p(G,e),p(L,e),p(V,e),p(H,e),p(q,e),p(P,e),p(O,e),p(ne,e)}}}const Gt='{"title":"Have several agents collaborate in a multi-agent hierarchy 🤖🤝🤖","local":"have-several-agents-collaborate-in-a-multi-agent-hierarchy-","sections":[{"title":"🔍 Create a web search tool","local":"-create-a-web-search-tool","sections":[],"depth":3},{"title":"Build our multi-agent system 🤖🤝🤖","local":"build-our-multi-agent-system-","sections":[],"depth":2}],"depth":1}';function Qt(De){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nt extends Bt{constructor(C){super(),At(this,C,Qt,Wt,ft,{})}}export{Nt as component};
