import{s as rt,n as ct,o as ut}from"../chunks/scheduler.65852ee5.js";import{S as Ut,i as jt,g as M,s as n,r as p,A as Jt,h as o,f as s,c as a,j as pt,u as y,x as i,k as yt,y as wt,a as e,v as r,d as c,t as u,w as U}from"../chunks/index.65a1b999.js";import{D as Tt,C as J}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as $l,E as mt}from"../chunks/index.37c62cb6.js";function ht(Hl){let j,tl,O,sl,w,el,T,nl,m,_l='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',al,h,Gl="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>smolagents</code>.",Ml,b,xl="What’s the advantage over a standard text-to-SQL pipeline?",ol,d,Xl="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",il,I,Yl="👉 Instead, <strong>an agent system is able to critically inspect outputs and decide if the query needs to be changed or not</strong>, thus giving it a huge performance boost.",pl,C,Fl="Let’s build this agent! 💪",yl,g,rl,f,cl,B,ul,A,Ll="Let’s check that our system works with a basic query:",Ul,Q,jl,q,zl=`(1, 'Alan Payne', 12.06, 1.2)
(2, 'Alex Mason', 23.86, 0.24)
(3, 'Woodrow Wilson', 53.43, 5.43)
(4, 'Margaret James', 21.11, 1.0)
`,Jl,Z,wl,W,Dl="Now let’s make our SQL table retrievable by a tool.",Tl,S,Kl='Our <code>sql_engine</code> tool needs the following: (read <a href="https://huggingface.co/docs/transformers/en/agents#create-a-new-tool" rel="nofollow">the documentation</a> for more detail)',ml,E,Pl="<li>A docstring with an <code>Args:</code> part. This docstring will be parsed to become the tool’s <code>description</code> attribute, which will be used as the instruction manual for the LLM powering the agent, so it’s important to provide it!</li> <li>Type hints for inputs and output.</li>",hl,R,bl,v,Ol="Now let us create an agent that leverages this tool.",dl,k,lt="We use the <code>CodeAgent</code>, which is <code>transformers.agents</code>’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",Il,N,tt='The <code>llm_engine</code> is the LLM that powers the agent system. <code>InferenceClientModel</code> allows you to call LLMs using Hugging Face’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API: check out <a href="agent_change_llm">this other cookbook</a> to learn how to adapt it.',Cl,V,gl,$,fl,H,Bl,_,st="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Al,G,et="So let’s make a second table recording the names of waiters for each <code>receipt_id</code>!",Ql,x,ql,X,nt="We need to update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",Zl,Y,Wl,F,at=`Allows you to perform SQL queries on the table. Beware that this tool's output is a string representation of the execution output.
It can use the following tables:

Table 'receipts':
Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT

Table 'waiters':
Columns:
  - receipt_id: INTEGER
  - waiter_name: VARCHAR(16)
`,Sl,L,Mt='Since this request is a bit harder than the previous one, we’ll switch the llm engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a>!',El,z,Rl,D,ot="It directly works! The setup was surprisingly simple, wasn’t it?",vl,K,it="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",kl,P,Nl,ll,Vl;return w=new Tt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_text_to_sql.ipynb"}]}}),T=new $l({props:{title:"Agent for text-to-SQL with automatic error correction",local:"agent-for-text-to-sql-with-automatic-error-correction",headingTag:"h1"}}),g=new $l({props:{title:"Setup SQL tables",local:"setup-sql-tables",headingTag:"h2"}}),f=new J({props:{code:"ZnJvbSUyMHNxbGFsY2hlbXklMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwY3JlYXRlX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyME1ldGFEYXRhJTJDJTBBJTIwJTIwJTIwJTIwVGFibGUlMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4lMkMlMEElMjAlMjAlMjAlMjBTdHJpbmclMkMlMEElMjAlMjAlMjAlMjBJbnRlZ2VyJTJDJTBBJTIwJTIwJTIwJTIwRmxvYXQlMkMlMEElMjAlMjAlMjAlMjBpbnNlcnQlMkMlMEElMjAlMjAlMjAlMjBpbnNwZWN0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUyQyUwQSklMEElMEFlbmdpbmUlMjAlM0QlMjBjcmVhdGVfZW5naW5lKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRiUzQW1lbW9yeSUzQSUyMiklMEFtZXRhZGF0YV9vYmolMjAlM0QlMjBNZXRhRGF0YSgpJTBBJTBBJTIzJTIwY3JlYXRlJTIwY2l0eSUyMFNRTCUyMHRhYmxlJTBBdGFibGVfbmFtZSUyMCUzRCUyMCUyMnJlY2VpcHRzJTIyJTBBcmVjZWlwdHMlMjAlM0QlMjBUYWJsZSglMEElMjAlMjAlMjAlMjB0YWJsZV9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGFfb2JqJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnJlY2VpcHRfaWQlMjIlMkMlMjBJbnRlZ2VyJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJjdXN0b21lcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycHJpY2UlMjIlMkMlMjBGbG9hdCklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIydGlwJTIyJTJDJTIwRmxvYXQpJTJDJTBBKSUwQW1ldGFkYXRhX29iai5jcmVhdGVfYWxsKGVuZ2luZSk=",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)`,wrap:!1}}),B=new J({props:{code:"cm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyY3VzdG9tZXJfbmFtZSUyMiUzQSUyMCUyMkFsYW4lMjBQYXluZSUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwMTIuMDYlMkMlMjAlMjJ0aXAlMjIlM0ElMjAxLjIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJjdXN0b21lcl9uYW1lJTIyJTNBJTIwJTIyQWxleCUyME1hc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMy44NiUyQyUyMCUyMnRpcCUyMiUzQSUyMDAuMjQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMyUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJXb29kcm93JTIwV2lsc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA1My40MyUyQyUyMCUyMnRpcCUyMiUzQSUyMDUuNDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMS4xMSUyQyUyMCUyMnRpcCUyMiUzQSUyMDEuMDAlN0QlMkMlMEElNUQlMEFmb3IlMjByb3clMjBpbiUyMHJvd3MlM0ElMEElMjAlMjAlMjAlMjBzdG10JTIwJTNEJTIwaW5zZXJ0KHJlY2VpcHRzKS52YWx1ZXMoKipyb3cpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGVuZ2luZS5iZWdpbigpJTIwYXMlMjBjb25uZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3Vyc29yJTIwJTNEJTIwY29ubmVjdGlvbi5leGVjdXRlKHN0bXQp",highlighted:`rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),Q=new J({props:{code:"d2l0aCUyMGVuZ2luZS5jb25uZWN0KCklMjBhcyUyMGNvbiUzQSUwQSUyMCUyMCUyMCUyMHJvd3MlMjAlM0QlMjBjb24uZXhlY3V0ZSh0ZXh0KCUyMiUyMiUyMlNFTEVDVCUyMColMjBmcm9tJTIwcmVjZWlwdHMlMjIlMjIlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KHJvdyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
<span class="hljs-meta">... </span>    rows = con.execute(text(<span class="hljs-string">&quot;&quot;&quot;SELECT * from receipts&quot;&quot;&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(row)`,wrap:!1}}),Z=new $l({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h2"}}),R=new J({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),V=new J({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>),
)`,wrap:!1}}),$=new J({props:{code:"YWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)',wrap:!1}}),H=new $l({props:{title:"Increasing difficulty: Table joins",local:"increasing-difficulty-table-joins",headingTag:"h2"}}),x=new J({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),Y=new J({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
<span class="hljs-meta">... </span>It can use the following tables:&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
<span class="hljs-meta">... </span>    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

<span class="hljs-meta">... </span>    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

<span class="hljs-meta">... </span>    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-meta">... </span>    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),z=new J({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMkMlMEEpJTBBJTBBYWdlbnQucnVuKCUyMldoaWNoJTIwd2FpdGVyJTIwZ290JTIwbW9yZSUyMHRvdGFsJTIwbW9uZXklMjBmcm9tJTIwdGlwcyUzRiUyMik=",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),P=new mt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_text_to_sql.md"}}),{c(){j=M("meta"),tl=n(),O=M("p"),sl=n(),p(w.$$.fragment),el=n(),p(T.$$.fragment),nl=n(),m=M("p"),m.innerHTML=_l,al=n(),h=M("p"),h.innerHTML=Gl,Ml=n(),b=M("p"),b.textContent=xl,ol=n(),d=M("p"),d.textContent=Xl,il=n(),I=M("p"),I.innerHTML=Yl,pl=n(),C=M("p"),C.textContent=Fl,yl=n(),p(g.$$.fragment),rl=n(),p(f.$$.fragment),cl=n(),p(B.$$.fragment),ul=n(),A=M("p"),A.textContent=Ll,Ul=n(),p(Q.$$.fragment),jl=n(),q=M("pre"),q.textContent=zl,Jl=n(),p(Z.$$.fragment),wl=n(),W=M("p"),W.textContent=Dl,Tl=n(),S=M("p"),S.innerHTML=Kl,ml=n(),E=M("ul"),E.innerHTML=Pl,hl=n(),p(R.$$.fragment),bl=n(),v=M("p"),v.textContent=Ol,dl=n(),k=M("p"),k.innerHTML=lt,Il=n(),N=M("p"),N.innerHTML=tt,Cl=n(),p(V.$$.fragment),gl=n(),p($.$$.fragment),fl=n(),p(H.$$.fragment),Bl=n(),_=M("p"),_.textContent=st,Al=n(),G=M("p"),G.innerHTML=et,Ql=n(),p(x.$$.fragment),ql=n(),X=M("p"),X.innerHTML=nt,Zl=n(),p(Y.$$.fragment),Wl=n(),F=M("pre"),F.textContent=at,Sl=n(),L=M("p"),L.innerHTML=Mt,El=n(),p(z.$$.fragment),Rl=n(),D=M("p"),D.textContent=ot,vl=n(),K=M("p"),K.textContent=it,kl=n(),p(P.$$.fragment),Nl=n(),ll=M("p"),this.h()},l(l){const t=Jt("svelte-u9bgzb",document.head);j=o(t,"META",{name:!0,content:!0}),t.forEach(s),tl=a(l),O=o(l,"P",{}),pt(O).forEach(s),sl=a(l),y(w.$$.fragment,l),el=a(l),y(T.$$.fragment,l),nl=a(l),m=o(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1xlqnsv"&&(m.innerHTML=_l),al=a(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1rrh2b0"&&(h.innerHTML=Gl),Ml=a(l),b=o(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-3ojw25"&&(b.textContent=xl),ol=a(l),d=o(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1hw7g6s"&&(d.textContent=Xl),il=a(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-q251yb"&&(I.innerHTML=Yl),pl=a(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1tzrwc8"&&(C.textContent=Fl),yl=a(l),y(g.$$.fragment,l),rl=a(l),y(f.$$.fragment,l),cl=a(l),y(B.$$.fragment,l),ul=a(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-ec23hm"&&(A.textContent=Ll),Ul=a(l),y(Q.$$.fragment,l),jl=a(l),q=o(l,"PRE",{"data-svelte-h":!0}),i(q)!=="svelte-jbb28p"&&(q.textContent=zl),Jl=a(l),y(Z.$$.fragment,l),wl=a(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-fdu5cw"&&(W.textContent=Dl),Tl=a(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-34z7zb"&&(S.innerHTML=Kl),ml=a(l),E=o(l,"UL",{"data-svelte-h":!0}),i(E)!=="svelte-1oybir2"&&(E.innerHTML=Pl),hl=a(l),y(R.$$.fragment,l),bl=a(l),v=o(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1t4r7cu"&&(v.textContent=Ol),dl=a(l),k=o(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-8c37e5"&&(k.innerHTML=lt),Il=a(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-ba2bns"&&(N.innerHTML=tt),Cl=a(l),y(V.$$.fragment,l),gl=a(l),y($.$$.fragment,l),fl=a(l),y(H.$$.fragment,l),Bl=a(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-nr3fl7"&&(_.textContent=st),Al=a(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-6lwjm6"&&(G.innerHTML=et),Ql=a(l),y(x.$$.fragment,l),ql=a(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-frhx8p"&&(X.innerHTML=nt),Zl=a(l),y(Y.$$.fragment,l),Wl=a(l),F=o(l,"PRE",{"data-svelte-h":!0}),i(F)!=="svelte-d75mf2"&&(F.textContent=at),Sl=a(l),L=o(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1rg01xj"&&(L.innerHTML=Mt),El=a(l),y(z.$$.fragment,l),Rl=a(l),D=o(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1umn140"&&(D.textContent=ot),vl=a(l),K=o(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-bt1f1w"&&(K.textContent=it),kl=a(l),y(P.$$.fragment,l),Nl=a(l),ll=o(l,"P",{}),pt(ll).forEach(s),this.h()},h(){yt(j,"name","hf:doc:metadata"),yt(j,"content",bt)},m(l,t){wt(document.head,j),e(l,tl,t),e(l,O,t),e(l,sl,t),r(w,l,t),e(l,el,t),r(T,l,t),e(l,nl,t),e(l,m,t),e(l,al,t),e(l,h,t),e(l,Ml,t),e(l,b,t),e(l,ol,t),e(l,d,t),e(l,il,t),e(l,I,t),e(l,pl,t),e(l,C,t),e(l,yl,t),r(g,l,t),e(l,rl,t),r(f,l,t),e(l,cl,t),r(B,l,t),e(l,ul,t),e(l,A,t),e(l,Ul,t),r(Q,l,t),e(l,jl,t),e(l,q,t),e(l,Jl,t),r(Z,l,t),e(l,wl,t),e(l,W,t),e(l,Tl,t),e(l,S,t),e(l,ml,t),e(l,E,t),e(l,hl,t),r(R,l,t),e(l,bl,t),e(l,v,t),e(l,dl,t),e(l,k,t),e(l,Il,t),e(l,N,t),e(l,Cl,t),r(V,l,t),e(l,gl,t),r($,l,t),e(l,fl,t),r(H,l,t),e(l,Bl,t),e(l,_,t),e(l,Al,t),e(l,G,t),e(l,Ql,t),r(x,l,t),e(l,ql,t),e(l,X,t),e(l,Zl,t),r(Y,l,t),e(l,Wl,t),e(l,F,t),e(l,Sl,t),e(l,L,t),e(l,El,t),r(z,l,t),e(l,Rl,t),e(l,D,t),e(l,vl,t),e(l,K,t),e(l,kl,t),r(P,l,t),e(l,Nl,t),e(l,ll,t),Vl=!0},p:ct,i(l){Vl||(c(w.$$.fragment,l),c(T.$$.fragment,l),c(g.$$.fragment,l),c(f.$$.fragment,l),c(B.$$.fragment,l),c(Q.$$.fragment,l),c(Z.$$.fragment,l),c(R.$$.fragment,l),c(V.$$.fragment,l),c($.$$.fragment,l),c(H.$$.fragment,l),c(x.$$.fragment,l),c(Y.$$.fragment,l),c(z.$$.fragment,l),c(P.$$.fragment,l),Vl=!0)},o(l){u(w.$$.fragment,l),u(T.$$.fragment,l),u(g.$$.fragment,l),u(f.$$.fragment,l),u(B.$$.fragment,l),u(Q.$$.fragment,l),u(Z.$$.fragment,l),u(R.$$.fragment,l),u(V.$$.fragment,l),u($.$$.fragment,l),u(H.$$.fragment,l),u(x.$$.fragment,l),u(Y.$$.fragment,l),u(z.$$.fragment,l),u(P.$$.fragment,l),Vl=!1},d(l){l&&(s(tl),s(O),s(sl),s(el),s(nl),s(m),s(al),s(h),s(Ml),s(b),s(ol),s(d),s(il),s(I),s(pl),s(C),s(yl),s(rl),s(cl),s(ul),s(A),s(Ul),s(jl),s(q),s(Jl),s(wl),s(W),s(Tl),s(S),s(ml),s(E),s(hl),s(bl),s(v),s(dl),s(k),s(Il),s(N),s(Cl),s(gl),s(fl),s(Bl),s(_),s(Al),s(G),s(Ql),s(ql),s(X),s(Zl),s(Wl),s(F),s(Sl),s(L),s(El),s(Rl),s(D),s(vl),s(K),s(kl),s(Nl),s(ll)),s(j),U(w,l),U(T,l),U(g,l),U(f,l),U(B,l),U(Q,l),U(Z,l),U(R,l),U(V,l),U($,l),U(H,l),U(x,l),U(Y,l),U(z,l),U(P,l)}}}const bt='{"title":"Agent for text-to-SQL with automatic error correction","local":"agent-for-text-to-sql-with-automatic-error-correction","sections":[{"title":"Setup SQL tables","local":"setup-sql-tables","sections":[],"depth":2},{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":2},{"title":"Increasing difficulty: Table joins","local":"increasing-difficulty-table-joins","sections":[],"depth":2}],"depth":1}';function dt(Hl){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends Ut{constructor(j){super(),jt(this,j,dt,ht,rt,{})}}export{Bt as component};
