import{s as ue,n as je,o as fe}from"../chunks/scheduler.65852ee5.js";import{S as be,i as he,g as s,s as T,r as a,A as ge,h as n,f as J,c as w,j as ce,u as M,x as I,k as de,y as Be,a as l,v as U,d as p,t as i,w as y}from"../chunks/index.aa74147d.js";import{D as ke,C as r}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as Ft,E as Se}from"../chunks/index.e2566494.js";function _e(zt){let o,Tt,Jt,wt,m,st,C,nt,c,Yt='<em>作者：<a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',It,d,qt='<p>本教程属于进阶内容，建议先了解<a href="agents">另一本指南</a>中的概念！</p>',at,u,Dt="在本笔记本中，我们将构建一个<strong>多智能体网页浏览器：一个多个智能体协作，通过互联网解决问题的智能体系统！</strong>",Mt,j,Pt="它将是一个简单的层级结构，使用 <code>ManagedAgent</code> 对象来封装受管理的网页搜索智能体：",Ut,f,pt,b,Ot="让我们开始搭建这个系统。",it,h,Kt='⚡️ 我们的智能体将由 <a href="https://huggingface.co/meta-llama/Meta-Llama-3.1-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3.1-70B-Instruct</a> 提供支持，使用 <code>HfApiEngine</code> 类，它利用了 HF 的推理 API：推理 API 可以快速、轻松地运行任何操作系统模型。',yt,g,te="运行以下命令来安装所需的依赖项：",ot,B,rt,k,ee='我们将选择使用由 <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a> 提供支持的模型，因为它非常强大，并且在 HF API 中可以免费使用。',mt,S,Ct,_,ct,$,Je='对于网页浏览，我们可以直接使用我们现有的 <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/agents/search.py" rel="nofollow"><code>DuckDuckGoSearchTool</code></a> 工具来提供一个类似于 Google 搜索的功能。',dt,Z,le=`但是，我们还需要能够查看 <code>DuckDuckGoSearchTool</code> 找到的网页内容。<br/>
为此，我们可以导入库中内建的 <code>VisitWebpageTool</code>，但我们将重新构建这个工具，以便了解它是如何实现的。`,ut,A,Te="因此，让我们从零开始，使用 <code>markdownify</code> 创建我们的 <code>VisitWebpageTool</code> 工具。",jt,v,ft,V,we="好了，现在让我们初始化并测试我们的工具！",bt,R,ht,L,se=`Hugging Face \\- Wikipedia

[Jump to content](#bodyContent)

Main menu

Main menu
move to sidebar
hide

 Navigation
 

* [Main page](/wiki/Main_Page "Visit the main page [z]")
* [Contents](/wiki/Wikipedia:Contents "Guides to browsing Wikipedia")
* [Current events](/wiki/Portal:Current_events "Articles related to current events")
* [Random article](/wiki/Special:Random "Visit a randomly selected article [x]")
* [About Wikipedia](/wiki/Wikipedia:About "Learn about Wikipedia and how it works")
* [Co
`,gt,E,Bt,W,ne="现在我们已经拥有了所有的工具 <code>search</code> 和 <code>visit_webpage</code>，可以使用它们来创建网页智能体。",kt,G,Ie="该选择什么配置呢？",St,Q,ae="<li>网页浏览是一个单线程任务，不需要并行调用工具，因此使用 JSON 调用工具非常合适。因此，我们选择 <code>ReactJsonAgent</code>。</li> <li>此外，由于有时网页搜索需要浏览多个页面才能找到正确答案，我们更倾向于将 <code>max_iterations</code> 增加到 10。</li>",_t,x,$t,H,Me="然后，我们将这个智能体封装到一个 <code>ManagedAgent</code> 中，这样它就可以通过管理员智能体进行调用了。",Zt,N,At,X,Ue="最后，我们创建一个管理员智能体，并在初始化时将我们的受管理智能体通过 <code>managed_agents</code> 参数传递给它。",vt,F,pe="由于这个智能体负责规划和思考，因此高级推理将非常有帮助，所以选择 <code>ReactCodeAgent</code> 是最合适的。",Vt,z,ie="另外，我们想提一个涉及当前年份的问题：因此，我们需要添加 <code>additional_authorized_imports=[&quot;time&quot;, &quot;datetime&quot;]</code>。",Rt,Y,Lt,q,ye="就这样！现在让我们运行我们的系统！我们选择一个需要进行一些计算的问题",Et,D,Wt,P,oe="我们的智能体成功地高效协作，解决了任务！ ✅",Gt,O,re="💡 你可以轻松地扩展到更多智能体：一个负责代码执行，一个负责网页搜索，一个负责文件加载……",Qt,K,me="🤔💭 甚至可以考虑构建更复杂的树状层级结构，一个 CEO 智能体负责管理多个中层经理，每个经理下有多个报告。",xt,tt,Ce="我们甚至可以添加更多的中间管理层，每层都有多个日常会议，进行大量敏捷工作和 Scrum 主管，每个新增的组件都会增加足够的摩擦力，确保任务永远无法完成……嗯，等等，不，我们还是坚持我们的简单结构吧。",Ht,et,Nt,lt,Xt;return m=new ke({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/multiagent_web_assistant.ipynb"}]}}),C=new Ft({props:{title:"让多个智能体在多智能体层级中协作 🤖🤝🤖",local:"让多个智能体在多智能体层级中协作-",headingTag:"h1"}}),f=new r({props:{code:"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",highlighted:`              +----------------+
              |<span class="hljs-string"> 管理员智能体    </span>|
              +----------------+
                       |<span class="hljs-string">
        _______________</span>|______________
       |<span class="hljs-string">                              </span>|
  代码解释器       +--------------------------------+
       工具         |<span class="hljs-string">         受管理的智能体        </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">      </span>|<span class="hljs-string"> 网页搜索智能体   </span>|<span class="hljs-string">      </span>|
                     |<span class="hljs-string">      +------------------+      </span>|
                     |<span class="hljs-string">         </span>|<span class="hljs-string">            </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">  网页搜索工具       </span>|<span class="hljs-string">         </span>|
                     |<span class="hljs-string">             访问网页工具   </span>|
                     +--------------------------------+`,wrap:!1}}),B=new r({props:{code:"IXBpcCUyMGluc3RhbGwlMjBtYXJrZG93bmlmeSUyMGR1Y2tkdWNrZ28tc2VhcmNoJTIwJTIydHJhbnNmb3JtZXJzJTVCYWdlbnRzJTVEJTIyJTIwLS11cGdyYWRlJTIwLXE=",highlighted:'!pip install markdownify duckduckgo-search <span class="hljs-string">&quot;transformers[agents]&quot;</span> --upgrade -q',wrap:!1}}),S=new r({props:{code:"bW9kZWwlMjAlM0QlMjAlMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjI=",highlighted:'model = <span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>',wrap:!1}}),_=new Ft({props:{title:"🔍 创建一个网页搜索工具",local:"-创建一个网页搜索工具",headingTag:"h3"}}),v=new r({props:{code:"aW1wb3J0JTIwcmUlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBtYXJrZG93bmlmeSUyMGltcG9ydCUyMG1hcmtkb3duaWZ5JTIwYXMlMjBtZCUwQWZyb20lMjByZXF1ZXN0cy5leGNlcHRpb25zJTIwaW1wb3J0JTIwUmVxdWVzdEV4Y2VwdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzJTIwaW1wb3J0JTIwdG9vbCUwQSUwQSUwQSU0MHRvb2wlMEFkZWYlMjB2aXNpdF93ZWJwYWdlKHVybCUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyVmlzaXRzJTIwYSUyMHdlYnBhZ2UlMjBhdCUyMHRoZSUyMGdpdmVuJTIwVVJMJTIwYW5kJTIwcmV0dXJucyUyMGl0cyUyMGNvbnRlbnQlMjBhcyUyMGElMjBtYXJrZG93biUyMHN0cmluZy4lMEElMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXJsJTNBJTIwVGhlJTIwVVJMJTIwb2YlMjB0aGUlMjB3ZWJwYWdlJTIwdG8lMjB2aXNpdC4lMEElMEElMjAlMjAlMjAlMjBSZXR1cm5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVGhlJTIwY29udGVudCUyMG9mJTIwdGhlJTIwd2VicGFnZSUyMGNvbnZlcnRlZCUyMHRvJTIwTWFya2Rvd24lMkMlMjBvciUyMGFuJTIwZXJyb3IlMjBtZXNzYWdlJTIwaWYlMjB0aGUlMjByZXF1ZXN0JTIwZmFpbHMuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwU2VuZCUyMGElMjBHRVQlMjByZXF1ZXN0JTIwdG8lMjB0aGUlMjBVUkwlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UucmFpc2VfZm9yX3N0YXR1cygpJTIwJTIwJTIzJTIwUmFpc2UlMjBhbiUyMGV4Y2VwdGlvbiUyMGZvciUyMGJhZCUyMHN0YXR1cyUyMGNvZGVzJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ29udmVydCUyMHRoZSUyMEhUTUwlMjBjb250ZW50JTIwdG8lMjBNYXJrZG93biUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1hcmtkb3duX2NvbnRlbnQlMjAlM0QlMjBtZChyZXNwb25zZS50ZXh0KS5zdHJpcCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVtb3ZlJTIwbXVsdGlwbGUlMjBsaW5lJTIwYnJlYWtzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWFya2Rvd25fY29udGVudCUyMCUzRCUyMHJlLnN1YihyJTIyJTVDbiU3QjMlMkMlN0QlMjIlMkMlMjAlMjIlNUNuJTVDbiUyMiUyQyUyMG1hcmtkb3duX2NvbnRlbnQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWFya2Rvd25fY29udGVudCUwQSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMFJlcXVlc3RFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyRXJyb3IlMjBmZXRjaGluZyUyMHRoZSUyMHdlYnBhZ2UlM0ElMjAlN0JzdHIoZSklN0QlMjIlMEElMjAlMjAlMjAlMjBleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBmJTIyQW4lMjB1bmV4cGVjdGVkJTIwZXJyb3IlMjBvY2N1cnJlZCUzQSUyMCU3QnN0cihlKSU3RCUyMg==",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> markdownify <span class="hljs-keyword">import</span> markdownify <span class="hljs-keyword">as</span> md
<span class="hljs-keyword">from</span> requests.exceptions <span class="hljs-keyword">import</span> RequestException
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">visit_webpage</span>(<span class="hljs-params">url: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;Visits a webpage at the given URL and returns its content as a markdown string.

    Args:
        url: The URL of the webpage to visit.

    Returns:
        The content of the webpage converted to Markdown, or an error message if the request fails.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">try</span>:
        <span class="hljs-comment"># Send a GET request to the URL</span>
        response = requests.get(url)
        response.raise_for_status()  <span class="hljs-comment"># Raise an exception for bad status codes</span>

        <span class="hljs-comment"># Convert the HTML content to Markdown</span>
        markdown_content = md(response.text).strip()

        <span class="hljs-comment"># Remove multiple line breaks</span>
        markdown_content = re.sub(<span class="hljs-string">r&quot;\\n{3,}&quot;</span>, <span class="hljs-string">&quot;\\n\\n&quot;</span>, markdown_content)

        <span class="hljs-keyword">return</span> markdown_content

    <span class="hljs-keyword">except</span> RequestException <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;Error fetching the webpage: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;An unexpected error occurred: <span class="hljs-subst">{<span class="hljs-built_in">str</span>(e)}</span>&quot;</span>`,wrap:!1}}),R=new r({props:{code:"cHJpbnQodmlzaXRfd2VicGFnZSglMjJodHRwcyUzQSUyRiUyRmVuLndpa2lwZWRpYS5vcmclMkZ3aWtpJTJGSHVnZ2luZ19GYWNlJTIyKSU1QiUzQTUwMCU1RCk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(visit_webpage(<span class="hljs-string">&quot;https://en.wikipedia.org/wiki/Hugging_Face&quot;</span>)[:<span class="hljs-number">500</span>])',wrap:!1}}),E=new Ft({props:{title:"构建我们的多智能体系统 🤖🤝🤖",local:"构建我们的多智能体系统-",headingTag:"h2"}}),x=new r({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwUmVhY3RDb2RlQWdlbnQlMkMlMEElMjAlMjAlMjAlMjBSZWFjdEpzb25BZ2VudCUyQyUwQSUyMCUyMCUyMCUyMEhmQXBpRW5naW5lJTJDJTBBJTIwJTIwJTIwJTIwTWFuYWdlZEFnZW50JTJDJTBBKSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMuYWdlbnRzLnNlYXJjaCUyMGltcG9ydCUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKG1vZGVsKSUwQSUwQXdlYl9hZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUyQyUyMHZpc2l0X3dlYnBhZ2UlNUQlMkMlMEElMjAlMjAlMjAlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9pdGVyYXRpb25zJTNEMTAlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> (
    ReactCodeAgent,
    ReactJsonAgent,
    HfApiEngine,
    ManagedAgent,
)
<span class="hljs-keyword">from</span> transformers.agents.search <span class="hljs-keyword">import</span> DuckDuckGoSearchTool

llm_engine = HfApiEngine(model)

web_agent = ReactJsonAgent(
    tools=[DuckDuckGoSearchTool(), visit_webpage],
    llm_engine=llm_engine,
    max_iterations=<span class="hljs-number">10</span>,
)`,wrap:!1}}),N=new r({props:{code:"bWFuYWdlZF93ZWJfYWdlbnQlMjAlM0QlMjBNYW5hZ2VkQWdlbnQoJTBBJTIwJTIwJTIwJTIwYWdlbnQlM0R3ZWJfYWdlbnQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIyc2VhcmNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJSdW5zJTIwd2ViJTIwc2VhcmNoZXMlMjBmb3IlMjB5b3UuJTIwR2l2ZSUyMGl0JTIweW91ciUyMHF1ZXJ5JTIwYXMlMjBhbiUyMGFyZ3VtZW50LiUyMiUyQyUwQSk=",highlighted:`managed_web_agent = ManagedAgent(
    agent=web_agent,
    name=<span class="hljs-string">&quot;search&quot;</span>,
    description=<span class="hljs-string">&quot;Runs web searches for you. Give it your query as an argument.&quot;</span>,
)`,wrap:!1}}),Y=new r({props:{code:"bWFuYWdlcl9hZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMEElMjAlMjAlMjAlMjBtYW5hZ2VkX2FnZW50cyUzRCU1Qm1hbmFnZWRfd2ViX2FnZW50JTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJ0aW1lJTIyJTJDJTIwJTIyZGF0ZXRpbWUlMjIlNUQlMkMlMEEp",highlighted:`manager_agent = ReactCodeAgent(
    tools=[],
    llm_engine=llm_engine,
    managed_agents=[managed_web_agent],
    additional_authorized_imports=[<span class="hljs-string">&quot;time&quot;</span>, <span class="hljs-string">&quot;datetime&quot;</span>],
)`,wrap:!1}}),D=new r({props:{code:"bWFuYWdlcl9hZ2VudC5ydW4oJTIySG93JTIwbWFueSUyMHllYXJzJTIwYWdvJTIwd2FzJTIwU3RyaXBlJTIwZm91bmRlZCUzRiUyMik=",highlighted:'manager_agent.run(<span class="hljs-string">&quot;How many years ago was Stripe founded?&quot;</span>)',wrap:!1}}),et=new Se({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/multiagent_web_assistant.md"}}),{c(){o=s("meta"),Tt=T(),Jt=s("p"),wt=T(),a(m.$$.fragment),st=T(),a(C.$$.fragment),nt=T(),c=s("p"),c.innerHTML=Yt,It=T(),d=s("blockquote"),d.innerHTML=qt,at=T(),u=s("p"),u.innerHTML=Dt,Mt=T(),j=s("p"),j.innerHTML=Pt,Ut=T(),a(f.$$.fragment),pt=T(),b=s("p"),b.textContent=Ot,it=T(),h=s("p"),h.innerHTML=Kt,yt=T(),g=s("p"),g.textContent=te,ot=T(),a(B.$$.fragment),rt=T(),k=s("p"),k.innerHTML=ee,mt=T(),a(S.$$.fragment),Ct=T(),a(_.$$.fragment),ct=T(),$=s("p"),$.innerHTML=Je,dt=T(),Z=s("p"),Z.innerHTML=le,ut=T(),A=s("p"),A.innerHTML=Te,jt=T(),a(v.$$.fragment),ft=T(),V=s("p"),V.textContent=we,bt=T(),a(R.$$.fragment),ht=T(),L=s("pre"),L.textContent=se,gt=T(),a(E.$$.fragment),Bt=T(),W=s("p"),W.innerHTML=ne,kt=T(),G=s("p"),G.textContent=Ie,St=T(),Q=s("ul"),Q.innerHTML=ae,_t=T(),a(x.$$.fragment),$t=T(),H=s("p"),H.innerHTML=Me,Zt=T(),a(N.$$.fragment),At=T(),X=s("p"),X.innerHTML=Ue,vt=T(),F=s("p"),F.innerHTML=pe,Vt=T(),z=s("p"),z.innerHTML=ie,Rt=T(),a(Y.$$.fragment),Lt=T(),q=s("p"),q.textContent=ye,Et=T(),a(D.$$.fragment),Wt=T(),P=s("p"),P.textContent=oe,Gt=T(),O=s("p"),O.textContent=re,Qt=T(),K=s("p"),K.textContent=me,xt=T(),tt=s("p"),tt.textContent=Ce,Ht=T(),a(et.$$.fragment),Nt=T(),lt=s("p"),this.h()},l(t){const e=ge("svelte-u9bgzb",document.head);o=n(e,"META",{name:!0,content:!0}),e.forEach(J),Tt=w(t),Jt=n(t,"P",{}),ce(Jt).forEach(J),wt=w(t),M(m.$$.fragment,t),st=w(t),M(C.$$.fragment,t),nt=w(t),c=n(t,"P",{"data-svelte-h":!0}),I(c)!=="svelte-w1hogd"&&(c.innerHTML=Yt),It=w(t),d=n(t,"BLOCKQUOTE",{"data-svelte-h":!0}),I(d)!=="svelte-6sxzpj"&&(d.innerHTML=qt),at=w(t),u=n(t,"P",{"data-svelte-h":!0}),I(u)!=="svelte-pc1j50"&&(u.innerHTML=Dt),Mt=w(t),j=n(t,"P",{"data-svelte-h":!0}),I(j)!=="svelte-1y2xf6m"&&(j.innerHTML=Pt),Ut=w(t),M(f.$$.fragment,t),pt=w(t),b=n(t,"P",{"data-svelte-h":!0}),I(b)!=="svelte-1msaor7"&&(b.textContent=Ot),it=w(t),h=n(t,"P",{"data-svelte-h":!0}),I(h)!=="svelte-19tzwyu"&&(h.innerHTML=Kt),yt=w(t),g=n(t,"P",{"data-svelte-h":!0}),I(g)!=="svelte-1fttkle"&&(g.textContent=te),ot=w(t),M(B.$$.fragment,t),rt=w(t),k=n(t,"P",{"data-svelte-h":!0}),I(k)!=="svelte-1gsndad"&&(k.innerHTML=ee),mt=w(t),M(S.$$.fragment,t),Ct=w(t),M(_.$$.fragment,t),ct=w(t),$=n(t,"P",{"data-svelte-h":!0}),I($)!=="svelte-q4xqvz"&&($.innerHTML=Je),dt=w(t),Z=n(t,"P",{"data-svelte-h":!0}),I(Z)!=="svelte-1lh8bvv"&&(Z.innerHTML=le),ut=w(t),A=n(t,"P",{"data-svelte-h":!0}),I(A)!=="svelte-tauqux"&&(A.innerHTML=Te),jt=w(t),M(v.$$.fragment,t),ft=w(t),V=n(t,"P",{"data-svelte-h":!0}),I(V)!=="svelte-bb05j9"&&(V.textContent=we),bt=w(t),M(R.$$.fragment,t),ht=w(t),L=n(t,"PRE",{"data-svelte-h":!0}),I(L)!=="svelte-1dfvpav"&&(L.textContent=se),gt=w(t),M(E.$$.fragment,t),Bt=w(t),W=n(t,"P",{"data-svelte-h":!0}),I(W)!=="svelte-r341rq"&&(W.innerHTML=ne),kt=w(t),G=n(t,"P",{"data-svelte-h":!0}),I(G)!=="svelte-1566qf1"&&(G.textContent=Ie),St=w(t),Q=n(t,"UL",{"data-svelte-h":!0}),I(Q)!=="svelte-1rb4eel"&&(Q.innerHTML=ae),_t=w(t),M(x.$$.fragment,t),$t=w(t),H=n(t,"P",{"data-svelte-h":!0}),I(H)!=="svelte-nxzc92"&&(H.innerHTML=Me),Zt=w(t),M(N.$$.fragment,t),At=w(t),X=n(t,"P",{"data-svelte-h":!0}),I(X)!=="svelte-pk8g1s"&&(X.innerHTML=Ue),vt=w(t),F=n(t,"P",{"data-svelte-h":!0}),I(F)!=="svelte-16uc2j7"&&(F.innerHTML=pe),Vt=w(t),z=n(t,"P",{"data-svelte-h":!0}),I(z)!=="svelte-1lh1i1b"&&(z.innerHTML=ie),Rt=w(t),M(Y.$$.fragment,t),Lt=w(t),q=n(t,"P",{"data-svelte-h":!0}),I(q)!=="svelte-tekfny"&&(q.textContent=ye),Et=w(t),M(D.$$.fragment,t),Wt=w(t),P=n(t,"P",{"data-svelte-h":!0}),I(P)!=="svelte-vgzsdt"&&(P.textContent=oe),Gt=w(t),O=n(t,"P",{"data-svelte-h":!0}),I(O)!=="svelte-1meg492"&&(O.textContent=re),Qt=w(t),K=n(t,"P",{"data-svelte-h":!0}),I(K)!=="svelte-2ib908"&&(K.textContent=me),xt=w(t),tt=n(t,"P",{"data-svelte-h":!0}),I(tt)!=="svelte-13th9au"&&(tt.textContent=Ce),Ht=w(t),M(et.$$.fragment,t),Nt=w(t),lt=n(t,"P",{}),ce(lt).forEach(J),this.h()},h(){de(o,"name","hf:doc:metadata"),de(o,"content",$e)},m(t,e){Be(document.head,o),l(t,Tt,e),l(t,Jt,e),l(t,wt,e),U(m,t,e),l(t,st,e),U(C,t,e),l(t,nt,e),l(t,c,e),l(t,It,e),l(t,d,e),l(t,at,e),l(t,u,e),l(t,Mt,e),l(t,j,e),l(t,Ut,e),U(f,t,e),l(t,pt,e),l(t,b,e),l(t,it,e),l(t,h,e),l(t,yt,e),l(t,g,e),l(t,ot,e),U(B,t,e),l(t,rt,e),l(t,k,e),l(t,mt,e),U(S,t,e),l(t,Ct,e),U(_,t,e),l(t,ct,e),l(t,$,e),l(t,dt,e),l(t,Z,e),l(t,ut,e),l(t,A,e),l(t,jt,e),U(v,t,e),l(t,ft,e),l(t,V,e),l(t,bt,e),U(R,t,e),l(t,ht,e),l(t,L,e),l(t,gt,e),U(E,t,e),l(t,Bt,e),l(t,W,e),l(t,kt,e),l(t,G,e),l(t,St,e),l(t,Q,e),l(t,_t,e),U(x,t,e),l(t,$t,e),l(t,H,e),l(t,Zt,e),U(N,t,e),l(t,At,e),l(t,X,e),l(t,vt,e),l(t,F,e),l(t,Vt,e),l(t,z,e),l(t,Rt,e),U(Y,t,e),l(t,Lt,e),l(t,q,e),l(t,Et,e),U(D,t,e),l(t,Wt,e),l(t,P,e),l(t,Gt,e),l(t,O,e),l(t,Qt,e),l(t,K,e),l(t,xt,e),l(t,tt,e),l(t,Ht,e),U(et,t,e),l(t,Nt,e),l(t,lt,e),Xt=!0},p:je,i(t){Xt||(p(m.$$.fragment,t),p(C.$$.fragment,t),p(f.$$.fragment,t),p(B.$$.fragment,t),p(S.$$.fragment,t),p(_.$$.fragment,t),p(v.$$.fragment,t),p(R.$$.fragment,t),p(E.$$.fragment,t),p(x.$$.fragment,t),p(N.$$.fragment,t),p(Y.$$.fragment,t),p(D.$$.fragment,t),p(et.$$.fragment,t),Xt=!0)},o(t){i(m.$$.fragment,t),i(C.$$.fragment,t),i(f.$$.fragment,t),i(B.$$.fragment,t),i(S.$$.fragment,t),i(_.$$.fragment,t),i(v.$$.fragment,t),i(R.$$.fragment,t),i(E.$$.fragment,t),i(x.$$.fragment,t),i(N.$$.fragment,t),i(Y.$$.fragment,t),i(D.$$.fragment,t),i(et.$$.fragment,t),Xt=!1},d(t){t&&(J(Tt),J(Jt),J(wt),J(st),J(nt),J(c),J(It),J(d),J(at),J(u),J(Mt),J(j),J(Ut),J(pt),J(b),J(it),J(h),J(yt),J(g),J(ot),J(rt),J(k),J(mt),J(Ct),J(ct),J($),J(dt),J(Z),J(ut),J(A),J(jt),J(ft),J(V),J(bt),J(ht),J(L),J(gt),J(Bt),J(W),J(kt),J(G),J(St),J(Q),J(_t),J($t),J(H),J(Zt),J(At),J(X),J(vt),J(F),J(Vt),J(z),J(Rt),J(Lt),J(q),J(Et),J(Wt),J(P),J(Gt),J(O),J(Qt),J(K),J(xt),J(tt),J(Ht),J(Nt),J(lt)),J(o),y(m,t),y(C,t),y(f,t),y(B,t),y(S,t),y(_,t),y(v,t),y(R,t),y(E,t),y(x,t),y(N,t),y(Y,t),y(D,t),y(et,t)}}}const $e='{"title":"让多个智能体在多智能体层级中协作 🤖🤝🤖","local":"让多个智能体在多智能体层级中协作-","sections":[{"title":"🔍 创建一个网页搜索工具","local":"-创建一个网页搜索工具","sections":[],"depth":3},{"title":"构建我们的多智能体系统 🤖🤝🤖","local":"构建我们的多智能体系统-","sections":[],"depth":2}],"depth":1}';function Ze(zt){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Le extends be{constructor(o){super(),he(this,o,Ze,_e,ue,{})}}export{Le as component};
