import{s as Vs,o as Cs,n as $s}from"../chunks/scheduler.65852ee5.js";import{S as Rs,i as Bs,g as p,s as n,r as i,A as _s,h as M,f as e,c as a,j as hs,u as U,x as T,k as Is,y as ks,a as s,v as r,d as m,t as y,w as J}from"../chunks/index.aa74147d.js";import{T as gs}from"../chunks/Tip.bb8ccac8.js";import{D as Ns,C as w}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as c,E as Gs}from"../chunks/index.e2566494.js";function Es(lt){let b,j='如果你使用 Google Colab，SQLite 已经安装。它可能没有安装在您的本地计算机上。如果未安装，请按照 <a href="https://www.sqlite.org/download.html" rel="nofollow">SQLite 网站</a> 上的说明进行安装。Python 接口代码已经集成在 Python 中，无需额外安装任何 Python 模块。';return{c(){b=p("p"),b.innerHTML=j},l(u){b=M(u,"P",{"data-svelte-h":!0}),T(b)!=="svelte-g5tn5b"&&(b.innerHTML=j)},m(u,Kl){s(u,b,Kl)},p:$s,d(u){u&&e(b)}}}function Zs(lt){let b,j,u,Kl,f,tt,d,et,h,Ge='<em>作者：<a href="https://github.com/scott-martens" rel="nofollow">Scott Martens</a> @ <a href="https://jina.ai" rel="nofollow">Jina AI</a></em>',st,I,Ee="本教程将展示如何构建一个简单的检索增强生成（RAG）系统，该系统从 SQL 数据库中提取信息，而不是从文档存储中提取。",nt,V,at,C,Ze='<li>给定一个 SQL 数据库，我们提取 SQL 表的定义（SQL 导出文件中的 <code>CREATE</code> 语句），并将其存储。在本教程中，我们已经为您完成了这部分操作，表定义被存储在内存中，作为一个列表。根据此示例扩展可能需要更复杂的存储方案。</li> <li>用户输入一个自然语言查询。</li> <li><a href="https://jina.ai/reranker/" rel="nofollow">Jina Reranker v2</a>（<a href="https://huggingface.co/jinaai/jina-reranker-v2-base-multilingual" rel="nofollow"><code>jinaai/jina-reranker-v2-base-multilingual</code></a>），一个由 <a href="https://jina.ai" rel="nofollow">Jina AI</a> 提供的 SQL 感知排序模型，会根据查询的相关性对表定义进行排序。</li> <li>我们将用户的查询和排名前三的表定义作为提示，传递给 <a href="https://huggingface.co/mistralai/Mistral-7B-Instruct-v0.1" rel="nofollow">Mistral 7B Instruct v0.1 (<code>mistralai/Mistral-7B-Instruct-v0.1</code>)</a>，并请求生成一个 SQL 查询来完成任务。</li> <li>Mistral Instruct 生成一个 SQL 查询，我们将其在数据库上执行并检索结果。</li> <li>SQL 查询结果被转换为 JSON 格式，并作为新提示传递给 Mistral Instruct，包含用户的原始查询、SQL 查询及请求，要求生成自然语言形式的答案。</li> <li>Mistral Instruct 的自然语言文本响应返回给用户。</li>',pt,$,Mt,R,Fe='本教程使用一个小型的开放访问视频游戏销售记录数据库，存储在 <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">GitHub</a> 上。我们将使用 <a href="https://www.sqlite.org/index.html" rel="nofollow">SQLite</a> 版本，因为 SQLite 非常紧凑，跨平台，并且内置对 Python 的支持。',it,B,Ut,_,Qe="我们将在本地运行 Jina Reranker v2 模型。如果您使用 Google Colab 运行此笔记本，请确保使用支持 GPU 的运行时。如果您在本地运行，您需要 Python 3（本教程使用 Python 3.11 编写），并且在启用了 CUDA 的 GPU 上运行将会 <em>大大</em> 提升速度。",rt,k,Se='本教程还将广泛使用开源的 <a href="https://www.llamaindex.ai/" rel="nofollow">LlamaIndex RAG 框架</a>，以及 <a href="https://huggingface.co/inference-api/serverless" rel="nofollow">Hugging Face Inference API</a> 来访问 Mistral 7B Instruct v0.1。您需要一个 <a href="https://huggingface.co/login" rel="nofollow">Hugging Face 账户</a> 和一个至少具有 <code>READ</code> 权限的 <a href="https://huggingface.co/settings/tokens" rel="nofollow">访问令牌</a>。',mt,o,yt,g,Jt,N,Tt,G,xe="首先，安装需要的 python 模块：",wt,E,bt,Z,ct,F,Xe='接下来，从 <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">GitHub</a> 下载 SQLite 数据库 <code>videogames.db</code> 到本地文件系统。如果你的系统上没有 <code>wget</code> 命令，可以通过 <a href="https://github.com/bbrumm/databasestar/raw/main/sample_databases/sample_db_videogames/sqlite/videogames.db" rel="nofollow">这个链接</a> 下载数据库，并将其放置在你运行本 Notebook 的相同目录中。',ut,Q,ot,S,jt,x,We="以下代码将下载模型 <code>jina-reranker-v2-base-multilingual</code> 并在本地运行：",ft,X,dt,W,ht,v,ve="我们将使用 LlamaIndex 创建一个持有对象，用于连接 Hugging Face 推理 API 和运行在那里的 <code>mistralai/Mistral-7B-Instruct-v0.1</code> 模型。",It,H,He='首先，从你的 <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face 账户设置页面</a> 获取一个 Hugging Face 访问令牌。',Vt,q,qe="在下面的提示中输入该令牌：",Ct,Y,$t,L,Ye="接下来，初始化 LlamaIndex 中 <code>HuggingFaceInferenceAPI</code> 类的实例，并将其存储为 <code>mistral_llm</code>：",Rt,A,Bt,z,_t,P,Le='我们从 <a href="https://github.com/bbrumm/databasestar/tree/main/sample_databases/sample_db_videogames/sqlite" rel="nofollow">GitHub 上的数据库导入文件</a> 中提取了八个表的定义。运行以下命令，将它们放入名为 <code>table_declarations</code> 的 Python 列表中：',kt,D,gt,K,Ae="现在，我们定义一个函数，该函数接受一个自然语言查询和表定义列表，使用 Jina Reranker v2 对所有表进行评分，并按得分从高到低返回它们：",Nt,O,Gt,ll,ze="Jina Reranker v2 会对我们提供的每个表定义进行评分，默认情况下，这个函数将返回所有表及其得分。可选参数 <code>top_n</code> 限制返回的结果数量，按得分从高到低，直到用户定义的数量。",Et,tl,Pe="试试这个。首先，定义一个查询：",Zt,el,Ft,sl,De="运行 <code>rank_tables</code> 来获取表定义的列表。我们将 <code>top_n</code> 设置为 3，以限制返回列表的大小，并将结果赋值给变量 <code>ranked_tables</code>，然后检查结果：",Qt,nl,St,al,Ke="输出应该包括 <code>region_sales</code>、<code>platform</code> 和 <code>game_platform</code> 这三个表，它们似乎都是查找查询答案的合理地方。",xt,pl,Xt,Ml,Oe="我们将使用 Mistral Instruct v0.1 编写一个 SQL 查询，满足用户的查询需求，基于根据重新排序器得出的前三个表的声明。",Wt,il,ls="首先，我们使用 LlamaIndex 的 <code>PromptTemplate</code> 类为此目的创建一个提示：",vt,Ul,Ht,rl,ts="我们使用 <code>format</code> 方法将用户查询和来自 Jina Reranker v2 的前三个表定义填充到模板字段中：",qt,ml,Yt,yl,es="你可以看到我们将传递给 Mistral Instruct 的实际文本：",Lt,Jl,At,Tl,ss="现在，让我们将提示发送给 Mistral Instruct 并获取其响应：",zt,wl,Pt,bl,Dt,cl,ns="使用内置的 Python SQLite 接口，针对数据库 <code>videogames.db</code> 运行上面的 SQL 查询：",Kt,ul,Ot,ol,as='有关 SQLite 接口的详细信息，请参阅 <a href="https://docs.python.org/3/library/sqlite3.html" rel="nofollow">Python3 文档</a>。',le,jl,ps="检查结果：",te,fl,ee,dl,Ms="你可以通过运行您自己的 SQL 查询来检查结果是否正确。该数据库中存储的销售数据是浮动点数，可能是以千或百万为单位的销售数量。",se,hl,ne,Il,is="现在，我们将用户的查询、SQL 查询和结果通过一个新的提示模板传递回 Mistral Instruct。",ae,Vl,Us="首先，使用 LlamaIndex 创建新的提示模板，和之前一样：",pe,Cl,Me,$l,rs="我们将把 SQL 输出转换为 JSON 格式，这是 Mistral Instruct v0.1 理解的格式。",ie,Rl,ms="填充模板字段：",Ue,Bl,re,_l,ys="现在从 Mistral Instruct 请求自然语言回答：",me,kl,ye,gl,Je,Nl,Js="让我们将所有步骤组织成一个函数，并加入异常处理：",Te,Gl,we,El,Ts="尝试:",be,Zl,ce,Fl,ws="试一试其他的问题:",ue,Ql,oe,Sl,je,xl,fe,Xl,de,Wl,he,vl,bs="试一试你自己的问题:",Ie,Hl,Ve,ql,Ce,Yl,cs="我们向你展示了如何构建一个非常基础的 RAG（检索增强生成）系统，用于自然语言问答，并将 SQL 数据库作为信息来源。在这个实现中，我们使用相同的大型语言模型（Mistral Instruct v0.1）来生成 SQL 查询和构造自然语言回答。",$e,Ll,us="这里的数据库是一个非常小的示例，扩展到更大规模可能需要比仅仅对表定义进行排序更复杂的方法。你可能需要使用一个双阶段的过程，其中嵌入模型和向量存储首先检索更多的结果，但重排序模型会将结果修剪到你能够放入生成语言模型提示中的数量。",Re,Al,os="本 Notebook 假设没有任何请求需要超过三个表来满足，显然，在实际应用中，这种假设并不总是成立。Mistral 7B Instruct v0.1 并不保证生成正确（甚至是可执行的）SQL 输出。在生产环境中，类似的实现需要更深入的错误处理。",Be,zl,js="更复杂的错误处理、更长的输入上下文窗口以及专门用于 SQL 任务的生成模型，可能在实际应用中带来显著的改进。",_e,Pl,fs="尽管如此，你可以看到 RAG 概念如何扩展到结构化数据库，极大地扩展了其应用范围。",ke,Dl,ge,Ol,Ne;return f=new Ns({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_sql_reranker.ipynb"}]}}),d=new c({props:{title:"基于 SQL 和 Jina Reranker v2 的 RAG",local:"基于-sql-和-jina-reranker-v2-的-rag",headingTag:"h1"}}),V=new c({props:{title:"工作原理",local:"工作原理",headingTag:"h3"}}),$=new c({props:{title:"数据库",local:"数据库",headingTag:"h3"}}),B=new c({props:{title:"软件和硬件要求",local:"软件和硬件要求",headingTag:"h3"}}),o=new gs({props:{warning:!0,$$slots:{default:[Es]},$$scope:{ctx:lt}}}),g=new c({props:{title:"开始",local:"开始",headingTag:"h2"}}),N=new c({props:{title:"安装环境",local:"安装环境",headingTag:"h3"}}),E=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcVUlMjB0cmFuc2Zvcm1lcnMlMjBlaW5vcHMlMjBsbGFtYS1pbmRleCUyMGxsYW1hLWluZGV4LXBvc3Rwcm9jZXNzb3ItamluYWFpLXJlcmFuayUyMCUyMGxsYW1hLWluZGV4LWxsbXMtaHVnZ2luZ2ZhY2UlMjAlMjJodWdnaW5nZmFjZV9odWIlNUJpbmZlcmVuY2UlNUQlMjI=",highlighted:'!pip install -qU transformers einops llama-index llama-index-postprocessor-jinaai-rerank  llama-index-llms-huggingface <span class="hljs-string">&quot;huggingface_hub[inference]&quot;</span>',wrap:!1}}),Z=new c({props:{title:"下载数据库",local:"下载数据库",headingTag:"h3"}}),Q=new w({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZiYnJ1bW0lMkZkYXRhYmFzZXN0YXIlMkZyYXclMkZtYWluJTJGc2FtcGxlX2RhdGFiYXNlcyUyRnNhbXBsZV9kYl92aWRlb2dhbWVzJTJGc3FsaXRlJTJGdmlkZW9nYW1lcy5kYg==",highlighted:"!wget https://github.com/bbrumm/databasestar/raw/main/sample_databases/sample_db_videogames/sqlite/videogames.db",wrap:!1}}),S=new c({props:{title:"下载并运行 Jina Reranker v2",local:"下载并运行-jina-reranker-v2",headingTag:"h3"}}),X=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFyZXJhbmtlcl9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmppbmFhaSUyRmppbmEtcmVyYW5rZXItdjItYmFzZS1tdWx0aWxpbmd1YWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMEEpJTBBJTBBcmVyYW5rZXJfbW9kZWwudG8oJTIyY3VkYSUyMiklMjAlMjAlMjMlMjBvciUyMCdjcHUnJTIwaWYlMjBubyUyMEdQVSUyMGlzJTIwYXZhaWxhYmxlJTBBcmVyYW5rZXJfbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

reranker_model = AutoModelForSequenceClassification.from_pretrained(
    <span class="hljs-string">&quot;jinaai/jina-reranker-v2-base-multilingual&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    trust_remote_code=<span class="hljs-literal">True</span>,
)

reranker_model.to(<span class="hljs-string">&quot;cuda&quot;</span>)  <span class="hljs-comment"># or &#x27;cpu&#x27; if no GPU is available</span>
reranker_model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),W=new c({props:{title:"设置 Mistral Instruct 的接口",local:"设置-mistral-instruct-的接口",headingTag:"h3"}}),Y=new w({props:{code:"aW1wb3J0JTIwZ2V0cGFzcyUwQSUwQXByaW50KCUyMlBhc3RlJTIweW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwYWNjZXNzJTIwdG9rZW4lMjBoZXJlJTNBJTIwJTIyKSUwQWhmX3Rva2VuJTIwJTNEJTIwZ2V0cGFzcy5nZXRwYXNzKCk=",highlighted:`<span class="hljs-keyword">import</span> getpass

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Paste your Hugging Face access token here: &quot;</span>)
hf_token = getpass.getpass()`,wrap:!1}}),A=new w({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmxsbXMuaHVnZ2luZ2ZhY2UlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUluZmVyZW5jZUFQSSUwQSUwQW1pc3RyYWxfbGxtJTIwJTNEJTIwSHVnZ2luZ0ZhY2VJbmZlcmVuY2VBUEkobW9kZWxfbmFtZSUzRCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTJDJTIwdG9rZW4lM0RoZl90b2tlbik=",highlighted:`<span class="hljs-keyword">from</span> llama_index.llms.huggingface <span class="hljs-keyword">import</span> HuggingFaceInferenceAPI

mistral_llm = HuggingFaceInferenceAPI(model_name=<span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>, token=hf_token)`,wrap:!1}}),z=new c({props:{title:"使用 SQL 感知的 Jina Reranker v2",local:"使用-sql-感知的-jina-reranker-v2",headingTag:"h2"}}),D=new w({props:{code:"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",highlighted:`table_declarations = [
    <span class="hljs-string">&quot;CREATE TABLE platform (\\n\\tid INTEGER PRIMARY KEY,\\n\\tplatform_name TEXT DEFAULT NULL\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE genre (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgenre_name TEXT DEFAULT NULL\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE publisher (\\n\\tid INTEGER PRIMARY KEY,\\n\\tpublisher_name TEXT DEFAULT NULL\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE region (\\n\\tid INTEGER PRIMARY KEY,\\n\\tregion_name TEXT DEFAULT NULL\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE game (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgenre_id INTEGER,\\n\\tgame_name TEXT DEFAULT NULL,\\n\\tCONSTRAINT fk_gm_gen FOREIGN KEY (genre_id) REFERENCES genre(id)\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE game_publisher (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgame_id INTEGER DEFAULT NULL,\\n\\tpublisher_id INTEGER DEFAULT NULL,\\n\\tCONSTRAINT fk_gpu_gam FOREIGN KEY (game_id) REFERENCES game(id),\\n\\tCONSTRAINT fk_gpu_pub FOREIGN KEY (publisher_id) REFERENCES publisher(id)\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE game_platform (\\n\\tid INTEGER PRIMARY KEY,\\n\\tgame_publisher_id INTEGER DEFAULT NULL,\\n\\tplatform_id INTEGER DEFAULT NULL,\\n\\trelease_year INTEGER DEFAULT NULL,\\n\\tCONSTRAINT fk_gpl_gp FOREIGN KEY (game_publisher_id) REFERENCES game_publisher(id),\\n\\tCONSTRAINT fk_gpl_pla FOREIGN KEY (platform_id) REFERENCES platform(id)\\n);&quot;</span>,
    <span class="hljs-string">&quot;CREATE TABLE region_sales (\\n\\tregion_id INTEGER DEFAULT NULL,\\n\\tgame_platform_id INTEGER DEFAULT NULL,\\n\\tnum_sales REAL,\\n   CONSTRAINT fk_rs_gp FOREIGN KEY (game_platform_id) REFERENCES game_platform(id),\\n\\tCONSTRAINT fk_rs_reg FOREIGN KEY (region_id) REFERENCES region(id)\\n);&quot;</span>,
]`,wrap:!1}}),O=new w({props:{code:"ZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyMExpc3QlMkMlMjBUdXBsZSUwQSUwQSUwQWRlZiUyMHJhbmtfdGFibGVzKHF1ZXJ5JTNBJTIwc3RyJTJDJTIwdGFibGVfc3BlY3MlM0ElMjBMaXN0JTVCc3RyJTVEJTJDJTIwdG9wX24lM0ElMjBpbnQlMjAlM0QlMjAwKSUyMC0lM0UlMjBMaXN0JTVCVHVwbGUlNUJmbG9hdCUyQyUyMHN0ciU1RCU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEdldCUyMHNvcnRlZCUyMHBhaXJzJTIwb2YlMjBzY29yZXMlMjBhbmQlMjB0YWJsZSUyMHNwZWNpZmljYXRpb25zJTJDJTIwdGhlbiUyMHJldHVybiUyMHRoZSUyMHRvcCUyME4lMkMlMEElMjAlMjAlMjAlMjBvciUyMGFsbCUyMGlmJTIwdG9wX24lMjBpcyUyMDAlMjBvciUyMGRlZmF1bHQuJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcGFpcnMlMjAlM0QlMjAlNUIlNUJxdWVyeSUyQyUyMHRhYmxlX3NwZWMlNUQlMjBmb3IlMjB0YWJsZV9zcGVjJTIwaW4lMjB0YWJsZV9zcGVjcyU1RCUwQSUyMCUyMCUyMCUyMHNjb3JlcyUyMCUzRCUyMHJlcmFua2VyX21vZGVsLmNvbXB1dGVfc2NvcmUocGFpcnMpJTBBJTIwJTIwJTIwJTIwc2NvcmVkX3RhYmxlcyUyMCUzRCUyMCU1QihzY29yZSUyQyUyMHRhYmxlX3NwZWMpJTIwZm9yJTIwc2NvcmUlMkMlMjB0YWJsZV9zcGVjJTIwaW4lMjB6aXAoc2NvcmVzJTJDJTIwdGFibGVfc3BlY3MpJTVEJTBBJTIwJTIwJTIwJTIwc2NvcmVkX3RhYmxlcy5zb3J0KGtleSUzRGxhbWJkYSUyMHglM0ElMjB4JTVCMCU1RCUyQyUyMHJldmVyc2UlM0RUcnVlKSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9wX24lMjBhbmQlMjB0b3BfbiUyMCUzQyUyMGxlbihzY29yZWRfdGFibGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNjb3JlZF90YWJsZXMlNUIwJTNBdG9wX24lNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzY29yZWRfdGFibGVz",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">rank_tables</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span>, table_specs: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>], top_n: <span class="hljs-built_in">int</span> = <span class="hljs-number">0</span></span>) -&gt; <span class="hljs-type">List</span>[<span class="hljs-type">Tuple</span>[<span class="hljs-built_in">float</span>, <span class="hljs-built_in">str</span>]]:
    <span class="hljs-string">&quot;&quot;&quot;
    Get sorted pairs of scores and table specifications, then return the top N,
    or all if top_n is 0 or default.
    &quot;&quot;&quot;</span>
    pairs = [[query, table_spec] <span class="hljs-keyword">for</span> table_spec <span class="hljs-keyword">in</span> table_specs]
    scores = reranker_model.compute_score(pairs)
    scored_tables = [(score, table_spec) <span class="hljs-keyword">for</span> score, table_spec <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(scores, table_specs)]
    scored_tables.sort(key=<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-number">0</span>], reverse=<span class="hljs-literal">True</span>)
    <span class="hljs-keyword">if</span> top_n <span class="hljs-keyword">and</span> top_n &lt; <span class="hljs-built_in">len</span>(scored_tables):
        <span class="hljs-keyword">return</span> scored_tables[<span class="hljs-number">0</span>:top_n]
    <span class="hljs-keyword">return</span> scored_tables`,wrap:!1}}),el=new w({props:{code:"dXNlcl9xdWVyeSUyMCUzRCUyMCUyMklkZW50aWZ5JTIwdGhlJTIwdG9wJTIwMTAlMjBwbGF0Zm9ybXMlMjBieSUyMHRvdGFsJTIwc2FsZXMuJTIy",highlighted:'user_query = <span class="hljs-string">&quot;Identify the top 10 platforms by total sales.&quot;</span>',wrap:!1}}),nl=new w({props:{code:"cmFua2VkX3RhYmxlcyUyMCUzRCUyMHJhbmtfdGFibGVzKHVzZXJfcXVlcnklMkMlMjB0YWJsZV9kZWNsYXJhdGlvbnMlMkMlMjB0b3BfbiUzRDMpJTBBcmFua2VkX3RhYmxlcw==",highlighted:`ranked_tables = rank_tables(user_query, table_declarations, top_n=<span class="hljs-number">3</span>)
ranked_tables`,wrap:!1}}),pl=new c({props:{title:"使用 Mistral Instruct 生成 SQL 查询",local:"使用-mistral-instruct-生成-sql-查询",headingTag:"h2"}}),Ul=new w({props:{code:"ZnJvbSUyMGxsYW1hX2luZGV4LmNvcmUlMjBpbXBvcnQlMjBQcm9tcHRUZW1wbGF0ZSUwQSUwQW1ha2Vfc3FsX3Byb21wdF90bXBsX3RleHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFHZW5lcmF0ZSUyMGElMjBTUUwlMjBxdWVyeSUyMHRvJTIwYW5zd2VyJTIwdGhlJTIwZm9sbG93aW5nJTIwcXVlc3Rpb24lMjBmcm9tJTIwdGhlJTIwdXNlciUzQSUwQSU1QyUyMiU3QnF1ZXJ5X3N0ciU3RCU1QyUyMiUwQSUwQVRoZSUyMFNRTCUyMHF1ZXJ5JTIwc2hvdWxkJTIwdXNlJTIwb25seSUyMHRhYmxlcyUyMHdpdGglMjB0aGUlMjBmb2xsb3dpbmclMjBTUUwlMjBkZWZpbml0aW9ucyUzQSUwQSUwQVRhYmxlJTIwMSUzQSUwQSU3QnRhYmxlXzElN0QlMEElMEFUYWJsZSUyMDIlM0ElMEElN0J0YWJsZV8yJTdEJTBBJTBBVGFibGUlMjAzJTNBJTBBJTdCdGFibGVfMyU3RCUwQSUwQU1ha2UlMjBzdXJlJTIweW91JTIwT05MWSUyMG91dHB1dCUyMGFuJTIwU1FMJTIwcXVlcnklMjBhbmQlMjBubyUyMGV4cGxhbmF0aW9uLiUwQSUyMiUyMiUyMiUwQW1ha2Vfc3FsX3Byb21wdF90bXBsJTIwJTNEJTIwUHJvbXB0VGVtcGxhdGUobWFrZV9zcWxfcHJvbXB0X3RtcGxfdGV4dCk=",highlighted:`<span class="hljs-keyword">from</span> llama_index.core <span class="hljs-keyword">import</span> PromptTemplate

make_sql_prompt_tmpl_text = <span class="hljs-string">&quot;&quot;&quot;
Generate a SQL query to answer the following question from the user:
\\&quot;{query_str}\\&quot;

The SQL query should use only tables with the following SQL definitions:

Table 1:
{table_1}

Table 2:
{table_2}

Table 3:
{table_3}

Make sure you ONLY output an SQL query and no explanation.
&quot;&quot;&quot;</span>
make_sql_prompt_tmpl = PromptTemplate(make_sql_prompt_tmpl_text)`,wrap:!1}}),ml=new w({props:{code:"bWFrZV9zcWxfcHJvbXB0JTIwJTNEJTIwbWFrZV9zcWxfcHJvbXB0X3RtcGwuZm9ybWF0KCUwQSUyMCUyMCUyMCUyMHF1ZXJ5X3N0ciUzRHVzZXJfcXVlcnklMkMlMjB0YWJsZV8xJTNEcmFua2VkX3RhYmxlcyU1QjAlNUQlNUIxJTVEJTJDJTIwdGFibGVfMiUzRHJhbmtlZF90YWJsZXMlNUIxJTVEJTVCMSU1RCUyQyUyMHRhYmxlXzMlM0RyYW5rZWRfdGFibGVzJTVCMiU1RCU1QjElNUQlMEEp",highlighted:`make_sql_prompt = make_sql_prompt_tmpl.<span class="hljs-built_in">format</span>(
    query_str=user_query, table_1=ranked_tables[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>], table_2=ranked_tables[<span class="hljs-number">1</span>][<span class="hljs-number">1</span>], table_3=ranked_tables[<span class="hljs-number">2</span>][<span class="hljs-number">1</span>]
)`,wrap:!1}}),Jl=new w({props:{code:"cHJpbnQobWFrZV9zcWxfcHJvbXB0KQ==",highlighted:'<span class="hljs-built_in">print</span>(make_sql_prompt)',wrap:!1}}),wl=new w({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBtaXN0cmFsX2xsbS5jb21wbGV0ZShtYWtlX3NxbF9wcm9tcHQpJTBBc3FsX3F1ZXJ5JTIwJTNEJTIwc3RyKHJlc3BvbnNlKSUwQXByaW50KHNxbF9xdWVyeSk=",highlighted:`response = mistral_llm.complete(make_sql_prompt)
sql_query = <span class="hljs-built_in">str</span>(response)
<span class="hljs-built_in">print</span>(sql_query)`,wrap:!1}}),bl=new c({props:{title:"运行 SQL 查询",local:"运行-sql-查询",headingTag:"h2"}}),ul=new w({props:{code:"aW1wb3J0JTIwc3FsaXRlMyUwQSUwQWNvbiUyMCUzRCUyMHNxbGl0ZTMuY29ubmVjdCglMjJ2aWRlb2dhbWVzLmRiJTIyKSUwQWN1ciUyMCUzRCUyMGNvbi5jdXJzb3IoKSUwQXNxbF9yZXNwb25zZSUyMCUzRCUyMGN1ci5leGVjdXRlKHNxbF9xdWVyeSkuZmV0Y2hhbGwoKQ==",highlighted:`<span class="hljs-keyword">import</span> sqlite3

con = sqlite3.connect(<span class="hljs-string">&quot;videogames.db&quot;</span>)
cur = con.cursor()
sql_response = cur.execute(sql_query).fetchall()`,wrap:!1}}),fl=new w({props:{code:"c3FsX3Jlc3BvbnNl",highlighted:"sql_response",wrap:!1}}),hl=new c({props:{title:"获取自然语言回答",local:"获取自然语言回答",headingTag:"h2"}}),Cl=new w({props:{code:"cmFnX3Byb21wdF90bXBsX3N0ciUyMCUzRCUyMCUyMiUyMiUyMiUwQVVzZSUyMHRoZSUyMGluZm9ybWF0aW9uJTIwaW4lMjB0aGUlMjBKU09OJTIwdGFibGUlMjB0byUyMGFuc3dlciUyMHRoZSUyMGZvbGxvd2luZyUyMHVzZXIlMjBxdWVyeS4lMEFEbyUyMG5vdCUyMGV4cGxhaW4lMjBhbnl0aGluZyUyQyUyMGp1c3QlMjBhbnN3ZXIlMjBjb25jaXNlbHkuJTIwVXNlJTIwbmF0dXJhbCUyMGxhbmd1YWdlJTIwaW4lMjB5b3VyJTBBYW5zd2VyJTJDJTIwbm90JTIwY29tcHV0ZXIlMjBmb3JtYXR0aW5nLiUwQSUwQVVTRVIlMjBRVUVSWSUzQSUyMCU3QnF1ZXJ5X3N0ciU3RCUwQSUwQUpTT04lMjB0YWJsZSUzQSUwQSU3Qmpzb25fdGFibGUlN0QlMEElMEFUaGlzJTIwdGFibGUlMjB3YXMlMjBnZW5lcmF0ZWQlMjBieSUyMHRoZSUyMGZvbGxvd2luZyUyMFNRTCUyMHF1ZXJ5JTNBJTBBJTdCc3FsX3F1ZXJ5JTdEJTBBJTBBQW5zd2VyJTIwT05MWSUyMHVzaW5nJTIwdGhlJTIwaW5mb3JtYXRpb24lMjBpbiUyMHRoZSUyMHRhYmxlJTIwYW5kJTIwdGhlJTIwU1FMJTIwcXVlcnklMkMlMjBhbmQlMjBpZiUyMHRoZSUwQXRhYmxlJTIwZG9lcyUyMG5vdCUyMHByb3ZpZGUlMjB0aGUlMjBpbmZvcm1hdGlvbiUyMHRvJTIwYW5zd2VyJTIwdGhlJTIwcXVlc3Rpb24lMkMlMjBhbnN3ZXIlMEElMjJObyUyMEluZm9ybWF0aW9uJTIyLiUwQSUyMiUyMiUyMiUwQXJhZ19wcm9tcHRfdG1wbCUyMCUzRCUyMFByb21wdFRlbXBsYXRlKHJhZ19wcm9tcHRfdG1wbF9zdHIp",highlighted:`rag_prompt_tmpl_str = <span class="hljs-string">&quot;&quot;&quot;
Use the information in the JSON table to answer the following user query.
Do not explain anything, just answer concisely. Use natural language in your
answer, not computer formatting.

USER QUERY: {query_str}

JSON table:
{json_table}

This table was generated by the following SQL query:
{sql_query}

Answer ONLY using the information in the table and the SQL query, and if the
table does not provide the information to answer the question, answer
&quot;No Information&quot;.
&quot;&quot;&quot;</span>
rag_prompt_tmpl = PromptTemplate(rag_prompt_tmpl_str)`,wrap:!1}}),Bl=new w({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXJhZ19wcm9tcHQlMjAlM0QlMjByYWdfcHJvbXB0X3RtcGwuZm9ybWF0KCUwQSUyMCUyMCUyMCUyMHF1ZXJ5X3N0ciUzRCUyMklkZW50aWZ5JTIwdGhlJTIwdG9wJTIwMTAlMjBwbGF0Zm9ybXMlMjBieSUyMHRvdGFsJTIwc2FsZXMlMjIlMkMlMjBqc29uX3RhYmxlJTNEanNvbi5kdW1wcyhzcWxfcmVzcG9uc2UpJTJDJTIwc3FsX3F1ZXJ5JTNEc3FsX3F1ZXJ5JTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> json

rag_prompt = rag_prompt_tmpl.<span class="hljs-built_in">format</span>(
    query_str=<span class="hljs-string">&quot;Identify the top 10 platforms by total sales&quot;</span>, json_table=json.dumps(sql_response), sql_query=sql_query
)`,wrap:!1}}),kl=new w({props:{code:"cmFnX3Jlc3BvbnNlJTIwJTNEJTIwbWlzdHJhbF9sbG0uY29tcGxldGUocmFnX3Byb21wdCklMEFwcmludChzdHIocmFnX3Jlc3BvbnNlKSk=",highlighted:`rag_response = mistral_llm.complete(rag_prompt)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">str</span>(rag_response))`,wrap:!1}}),gl=new c({props:{title:"尝试自己动手",local:"尝试自己动手",headingTag:"h2"}}),Gl=new w({props:{code:"ZGVmJTIwYW5zd2VyX3NxbCh1c2VyX3F1ZXJ5JTNBJTIwc3RyKSUyMC0lM0UlMjBzdHIlM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYW5rZWRfdGFibGVzJTIwJTNEJTIwcmFua190YWJsZXModXNlcl9xdWVyeSUyQyUyMHRhYmxlX2RlY2xhcmF0aW9ucyUyQyUyMHRvcF9uJTNEMyklMEElMjAlMjAlMjAlMjBleGNlcHQlMjBFeGNlcHRpb24lMjBhcyUyMGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyUmFua2luZyUyMGZhaWxlZC4lNUNuVXNlciUyMHF1ZXJ5JTNBJTVDbiU3QnVzZXJfcXVlcnklN0QlNUNuJTVDbiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYWlzZSUyMChlKSUwQSUwQSUyMCUyMCUyMCUyMG1ha2Vfc3FsX3Byb21wdCUyMCUzRCUyMG1ha2Vfc3FsX3Byb21wdF90bXBsLmZvcm1hdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeV9zdHIlM0R1c2VyX3F1ZXJ5JTJDJTIwdGFibGVfMSUzRHJhbmtlZF90YWJsZXMlNUIwJTVEJTVCMSU1RCUyQyUyMHRhYmxlXzIlM0RyYW5rZWRfdGFibGVzJTVCMSU1RCU1QjElNUQlMkMlMjB0YWJsZV8zJTNEcmFua2VkX3RhYmxlcyU1QjIlNUQlNUIxJTVEJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwbWlzdHJhbF9sbG0uY29tcGxldGUobWFrZV9zcWxfcHJvbXB0KSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJTUUwlMjBxdWVyeSUyMGdlbmVyYXRpb24lMjBmYWlsZWQlNUNuUHJvbXB0JTNBJTVDbiU3Qm1ha2Vfc3FsX3Byb21wdCU3RCU1Q24lNUNuJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwKGUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQmFja3NsYXNoJTIwcmVtb3ZhbCUyMGlzJTIwYSUyMG5lY2Vzc2FyeSUyMGhhY2slMjBiZWNhdXNlJTIwc29tZXRpbWVzJTIwTWlzdHJhbCUyMHB1dHMlMjB0aGVtJTBBJTIwJTIwJTIwJTIwJTIzJTIwaW4lMjBpdHMlMjBnZW5lcmF0ZWQlMjBjb2RlLiUwQSUyMCUyMCUyMCUyMHNxbF9xdWVyeSUyMCUzRCUyMHN0cihyZXNwb25zZSkucmVwbGFjZSglMjIlNUMlNUMlMjIlMkMlMjAlMjIlMjIpJTBBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3FsX3Jlc3BvbnNlJTIwJTNEJTIwc3FsaXRlMy5jb25uZWN0KCUyMnZpZGVvZ2FtZXMuZGIlMjIpLmN1cnNvcigpLmV4ZWN1dGUoc3FsX3F1ZXJ5KS5mZXRjaGFsbCgpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlNRTCUyMHF1ZXJ5aW5nJTIwZmFpbGVkLiUyMFF1ZXJ5JTNBJTVDbiU3QnNxbF9xdWVyeSU3RCU1Q24lNUNuJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhaXNlJTIwKGUpJTBBJTBBJTIwJTIwJTIwJTIwcmFnX3Byb21wdCUyMCUzRCUyMHJhZ19wcm9tcHRfdG1wbC5mb3JtYXQocXVlcnlfc3RyJTNEdXNlcl9xdWVyeSUyQyUyMGpzb25fdGFibGUlM0Rqc29uLmR1bXBzKHNxbF9yZXNwb25zZSklMkMlMjBzcWxfcXVlcnklM0RzcWxfcXVlcnkpJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFnX3Jlc3BvbnNlJTIwJTNEJTIwbWlzdHJhbF9sbG0uY29tcGxldGUocmFnX3Byb21wdCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzdHIocmFnX3Jlc3BvbnNlKSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJBbnN3ZXIlMjBnZW5lcmF0aW9uJTIwZmFpbGVkLiUyMFByb21wdCUzQSU1Q24lN0JyYWdfcHJvbXB0JTdEJTVDbiU1Q24lMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjAoZSk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_sql</span>(<span class="hljs-params">user_query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-keyword">try</span>:
        ranked_tables = rank_tables(user_query, table_declarations, top_n=<span class="hljs-number">3</span>)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Ranking failed.\\nUser query:\\n<span class="hljs-subst">{user_query}</span>\\n\\n&quot;</span>)
        <span class="hljs-keyword">raise</span> (e)

    make_sql_prompt = make_sql_prompt_tmpl.<span class="hljs-built_in">format</span>(
        query_str=user_query, table_1=ranked_tables[<span class="hljs-number">0</span>][<span class="hljs-number">1</span>], table_2=ranked_tables[<span class="hljs-number">1</span>][<span class="hljs-number">1</span>], table_3=ranked_tables[<span class="hljs-number">2</span>][<span class="hljs-number">1</span>]
    )

    <span class="hljs-keyword">try</span>:
        response = mistral_llm.complete(make_sql_prompt)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SQL query generation failed\\nPrompt:\\n<span class="hljs-subst">{make_sql_prompt}</span>\\n\\n&quot;</span>)
        <span class="hljs-keyword">raise</span> (e)

    <span class="hljs-comment"># Backslash removal is a necessary hack because sometimes Mistral puts them</span>
    <span class="hljs-comment"># in its generated code.</span>
    sql_query = <span class="hljs-built_in">str</span>(response).replace(<span class="hljs-string">&quot;\\\\&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)

    <span class="hljs-keyword">try</span>:
        sql_response = sqlite3.connect(<span class="hljs-string">&quot;videogames.db&quot;</span>).cursor().execute(sql_query).fetchall()
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;SQL querying failed. Query:\\n<span class="hljs-subst">{sql_query}</span>\\n\\n&quot;</span>)
        <span class="hljs-keyword">raise</span> (e)

    rag_prompt = rag_prompt_tmpl.<span class="hljs-built_in">format</span>(query_str=user_query, json_table=json.dumps(sql_response), sql_query=sql_query)
    <span class="hljs-keyword">try</span>:
        rag_response = mistral_llm.complete(rag_prompt)
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(rag_response)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer generation failed. Prompt:\\n<span class="hljs-subst">{rag_prompt}</span>\\n\\n&quot;</span>)
        <span class="hljs-keyword">raise</span> (e)`,wrap:!1}}),Zl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJJZGVudGlmeSUyMHRoZSUyMHRvcCUyMDEwJTIwcGxhdGZvcm1zJTIwYnklMjB0b3RhbCUyMHNhbGVzLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Identify the top 10 platforms by total sales.&quot;</span>))',wrap:!1}}),Ql=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJTdW1tYXJpemUlMjBzYWxlcyUyMGJ5JTIwcmVnaW9uLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Summarize sales by region.&quot;</span>))',wrap:!1}}),Sl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJMaXN0JTIwdGhlJTIwcHVibGlzaGVyJTIwd2l0aCUyMHRoZSUyMGxhcmdlc3QlMjBudW1iZXIlMjBvZiUyMHB1Ymxpc2hlZCUyMGdhbWVzLiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;List the publisher with the largest number of published games.&quot;</span>))',wrap:!1}}),xl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJEaXNwbGF5JTIwdGhlJTIweWVhciUyMHdpdGglMjBtb3N0JTIwZ2FtZXMlMjByZWxlYXNlZC4lMjIpKQ==",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;Display the year with most games released.&quot;</span>))',wrap:!1}}),Xl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJXaGF0JTIwaXMlMjB0aGUlMjBtb3N0JTIwcG9wdWxhciUyMGdhbWUlMjBnZW5yZSUyMG9uJTIwdGhlJTIwV2lpJTIwcGxhdGZvcm0lM0YlMjIpKQ==",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;What is the most popular game genre on the Wii platform?&quot;</span>))',wrap:!1}}),Wl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjJXaGF0JTIwaXMlMjB0aGUlMjBtb3N0JTIwcG9wdWxhciUyMGdhbWUlMjBnZW5yZSUyMG9mJTIwMjAxMiUzRiUyMikp",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;What is the most popular game genre of 2012?&quot;</span>))',wrap:!1}}),Hl=new w({props:{code:"cHJpbnQoYW5zd2VyX3NxbCglMjIlM0NJTlNFUlQlMjBRVUVTVElPTiUyME9SJTIwSU5TVFJVQ1RJT04lMjBIRVJFJTNFJTIyKSk=",highlighted:'<span class="hljs-built_in">print</span>(answer_sql(<span class="hljs-string">&quot;&lt;INSERT QUESTION OR INSTRUCTION HERE&gt;&quot;</span>))',wrap:!1}}),ql=new c({props:{title:"复习与总结",local:"复习与总结",headingTag:"h2"}}),Dl=new Gs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_sql_reranker.md"}}),{c(){b=p("meta"),j=n(),u=p("p"),Kl=n(),i(f.$$.fragment),tt=n(),i(d.$$.fragment),et=n(),h=p("p"),h.innerHTML=Ge,st=n(),I=p("p"),I.textContent=Ee,nt=n(),i(V.$$.fragment),at=n(),C=p("ul"),C.innerHTML=Ze,pt=n(),i($.$$.fragment),Mt=n(),R=p("p"),R.innerHTML=Fe,it=n(),i(B.$$.fragment),Ut=n(),_=p("p"),_.innerHTML=Qe,rt=n(),k=p("p"),k.innerHTML=Se,mt=n(),i(o.$$.fragment),yt=n(),i(g.$$.fragment),Jt=n(),i(N.$$.fragment),Tt=n(),G=p("p"),G.textContent=xe,wt=n(),i(E.$$.fragment),bt=n(),i(Z.$$.fragment),ct=n(),F=p("p"),F.innerHTML=Xe,ut=n(),i(Q.$$.fragment),ot=n(),i(S.$$.fragment),jt=n(),x=p("p"),x.innerHTML=We,ft=n(),i(X.$$.fragment),dt=n(),i(W.$$.fragment),ht=n(),v=p("p"),v.innerHTML=ve,It=n(),H=p("p"),H.innerHTML=He,Vt=n(),q=p("p"),q.textContent=qe,Ct=n(),i(Y.$$.fragment),$t=n(),L=p("p"),L.innerHTML=Ye,Rt=n(),i(A.$$.fragment),Bt=n(),i(z.$$.fragment),_t=n(),P=p("p"),P.innerHTML=Le,kt=n(),i(D.$$.fragment),gt=n(),K=p("p"),K.textContent=Ae,Nt=n(),i(O.$$.fragment),Gt=n(),ll=p("p"),ll.innerHTML=ze,Et=n(),tl=p("p"),tl.textContent=Pe,Zt=n(),i(el.$$.fragment),Ft=n(),sl=p("p"),sl.innerHTML=De,Qt=n(),i(nl.$$.fragment),St=n(),al=p("p"),al.innerHTML=Ke,xt=n(),i(pl.$$.fragment),Xt=n(),Ml=p("p"),Ml.textContent=Oe,Wt=n(),il=p("p"),il.innerHTML=ls,vt=n(),i(Ul.$$.fragment),Ht=n(),rl=p("p"),rl.innerHTML=ts,qt=n(),i(ml.$$.fragment),Yt=n(),yl=p("p"),yl.textContent=es,Lt=n(),i(Jl.$$.fragment),At=n(),Tl=p("p"),Tl.textContent=ss,zt=n(),i(wl.$$.fragment),Pt=n(),i(bl.$$.fragment),Dt=n(),cl=p("p"),cl.innerHTML=ns,Kt=n(),i(ul.$$.fragment),Ot=n(),ol=p("p"),ol.innerHTML=as,le=n(),jl=p("p"),jl.textContent=ps,te=n(),i(fl.$$.fragment),ee=n(),dl=p("p"),dl.textContent=Ms,se=n(),i(hl.$$.fragment),ne=n(),Il=p("p"),Il.textContent=is,ae=n(),Vl=p("p"),Vl.textContent=Us,pe=n(),i(Cl.$$.fragment),Me=n(),$l=p("p"),$l.textContent=rs,ie=n(),Rl=p("p"),Rl.textContent=ms,Ue=n(),i(Bl.$$.fragment),re=n(),_l=p("p"),_l.textContent=ys,me=n(),i(kl.$$.fragment),ye=n(),i(gl.$$.fragment),Je=n(),Nl=p("p"),Nl.textContent=Js,Te=n(),i(Gl.$$.fragment),we=n(),El=p("p"),El.textContent=Ts,be=n(),i(Zl.$$.fragment),ce=n(),Fl=p("p"),Fl.textContent=ws,ue=n(),i(Ql.$$.fragment),oe=n(),i(Sl.$$.fragment),je=n(),i(xl.$$.fragment),fe=n(),i(Xl.$$.fragment),de=n(),i(Wl.$$.fragment),he=n(),vl=p("p"),vl.textContent=bs,Ie=n(),i(Hl.$$.fragment),Ve=n(),i(ql.$$.fragment),Ce=n(),Yl=p("p"),Yl.textContent=cs,$e=n(),Ll=p("p"),Ll.textContent=us,Re=n(),Al=p("p"),Al.textContent=os,Be=n(),zl=p("p"),zl.textContent=js,_e=n(),Pl=p("p"),Pl.textContent=fs,ke=n(),i(Dl.$$.fragment),ge=n(),Ol=p("p"),this.h()},l(l){const t=_s("svelte-u9bgzb",document.head);b=M(t,"META",{name:!0,content:!0}),t.forEach(e),j=a(l),u=M(l,"P",{}),hs(u).forEach(e),Kl=a(l),U(f.$$.fragment,l),tt=a(l),U(d.$$.fragment,l),et=a(l),h=M(l,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1cm10yi"&&(h.innerHTML=Ge),st=a(l),I=M(l,"P",{"data-svelte-h":!0}),T(I)!=="svelte-d4wr3x"&&(I.textContent=Ee),nt=a(l),U(V.$$.fragment,l),at=a(l),C=M(l,"UL",{"data-svelte-h":!0}),T(C)!=="svelte-173ju6z"&&(C.innerHTML=Ze),pt=a(l),U($.$$.fragment,l),Mt=a(l),R=M(l,"P",{"data-svelte-h":!0}),T(R)!=="svelte-1mhnsso"&&(R.innerHTML=Fe),it=a(l),U(B.$$.fragment,l),Ut=a(l),_=M(l,"P",{"data-svelte-h":!0}),T(_)!=="svelte-acagts"&&(_.innerHTML=Qe),rt=a(l),k=M(l,"P",{"data-svelte-h":!0}),T(k)!=="svelte-xrjnu7"&&(k.innerHTML=Se),mt=a(l),U(o.$$.fragment,l),yt=a(l),U(g.$$.fragment,l),Jt=a(l),U(N.$$.fragment,l),Tt=a(l),G=M(l,"P",{"data-svelte-h":!0}),T(G)!=="svelte-2bhcxb"&&(G.textContent=xe),wt=a(l),U(E.$$.fragment,l),bt=a(l),U(Z.$$.fragment,l),ct=a(l),F=M(l,"P",{"data-svelte-h":!0}),T(F)!=="svelte-vp2yk2"&&(F.innerHTML=Xe),ut=a(l),U(Q.$$.fragment,l),ot=a(l),U(S.$$.fragment,l),jt=a(l),x=M(l,"P",{"data-svelte-h":!0}),T(x)!=="svelte-5s2xfp"&&(x.innerHTML=We),ft=a(l),U(X.$$.fragment,l),dt=a(l),U(W.$$.fragment,l),ht=a(l),v=M(l,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1dfawf"&&(v.innerHTML=ve),It=a(l),H=M(l,"P",{"data-svelte-h":!0}),T(H)!=="svelte-kuh6vr"&&(H.innerHTML=He),Vt=a(l),q=M(l,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1mdyrb7"&&(q.textContent=qe),Ct=a(l),U(Y.$$.fragment,l),$t=a(l),L=M(l,"P",{"data-svelte-h":!0}),T(L)!=="svelte-gut780"&&(L.innerHTML=Ye),Rt=a(l),U(A.$$.fragment,l),Bt=a(l),U(z.$$.fragment,l),_t=a(l),P=M(l,"P",{"data-svelte-h":!0}),T(P)!=="svelte-hwgfp8"&&(P.innerHTML=Le),kt=a(l),U(D.$$.fragment,l),gt=a(l),K=M(l,"P",{"data-svelte-h":!0}),T(K)!=="svelte-52ja36"&&(K.textContent=Ae),Nt=a(l),U(O.$$.fragment,l),Gt=a(l),ll=M(l,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-1v32w9l"&&(ll.innerHTML=ze),Et=a(l),tl=M(l,"P",{"data-svelte-h":!0}),T(tl)!=="svelte-w44dxh"&&(tl.textContent=Pe),Zt=a(l),U(el.$$.fragment,l),Ft=a(l),sl=M(l,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-r8jqr4"&&(sl.innerHTML=De),Qt=a(l),U(nl.$$.fragment,l),St=a(l),al=M(l,"P",{"data-svelte-h":!0}),T(al)!=="svelte-1h4047d"&&(al.innerHTML=Ke),xt=a(l),U(pl.$$.fragment,l),Xt=a(l),Ml=M(l,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-4d0pet"&&(Ml.textContent=Oe),Wt=a(l),il=M(l,"P",{"data-svelte-h":!0}),T(il)!=="svelte-nyadiw"&&(il.innerHTML=ls),vt=a(l),U(Ul.$$.fragment,l),Ht=a(l),rl=M(l,"P",{"data-svelte-h":!0}),T(rl)!=="svelte-19mo587"&&(rl.innerHTML=ts),qt=a(l),U(ml.$$.fragment,l),Yt=a(l),yl=M(l,"P",{"data-svelte-h":!0}),T(yl)!=="svelte-2f1d0z"&&(yl.textContent=es),Lt=a(l),U(Jl.$$.fragment,l),At=a(l),Tl=M(l,"P",{"data-svelte-h":!0}),T(Tl)!=="svelte-yd2kef"&&(Tl.textContent=ss),zt=a(l),U(wl.$$.fragment,l),Pt=a(l),U(bl.$$.fragment,l),Dt=a(l),cl=M(l,"P",{"data-svelte-h":!0}),T(cl)!=="svelte-1gwivqm"&&(cl.innerHTML=ns),Kt=a(l),U(ul.$$.fragment,l),Ot=a(l),ol=M(l,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-w89ofp"&&(ol.innerHTML=as),le=a(l),jl=M(l,"P",{"data-svelte-h":!0}),T(jl)!=="svelte-1hgowlu"&&(jl.textContent=ps),te=a(l),U(fl.$$.fragment,l),ee=a(l),dl=M(l,"P",{"data-svelte-h":!0}),T(dl)!=="svelte-18ax3iq"&&(dl.textContent=Ms),se=a(l),U(hl.$$.fragment,l),ne=a(l),Il=M(l,"P",{"data-svelte-h":!0}),T(Il)!=="svelte-8v2irz"&&(Il.textContent=is),ae=a(l),Vl=M(l,"P",{"data-svelte-h":!0}),T(Vl)!=="svelte-v6t0j4"&&(Vl.textContent=Us),pe=a(l),U(Cl.$$.fragment,l),Me=a(l),$l=M(l,"P",{"data-svelte-h":!0}),T($l)!=="svelte-fdqrw4"&&($l.textContent=rs),ie=a(l),Rl=M(l,"P",{"data-svelte-h":!0}),T(Rl)!=="svelte-r6x816"&&(Rl.textContent=ms),Ue=a(l),U(Bl.$$.fragment,l),re=a(l),_l=M(l,"P",{"data-svelte-h":!0}),T(_l)!=="svelte-1wjlt84"&&(_l.textContent=ys),me=a(l),U(kl.$$.fragment,l),ye=a(l),U(gl.$$.fragment,l),Je=a(l),Nl=M(l,"P",{"data-svelte-h":!0}),T(Nl)!=="svelte-40ibhh"&&(Nl.textContent=Js),Te=a(l),U(Gl.$$.fragment,l),we=a(l),El=M(l,"P",{"data-svelte-h":!0}),T(El)!=="svelte-1f4skn0"&&(El.textContent=Ts),be=a(l),U(Zl.$$.fragment,l),ce=a(l),Fl=M(l,"P",{"data-svelte-h":!0}),T(Fl)!=="svelte-2zvtxo"&&(Fl.textContent=ws),ue=a(l),U(Ql.$$.fragment,l),oe=a(l),U(Sl.$$.fragment,l),je=a(l),U(xl.$$.fragment,l),fe=a(l),U(Xl.$$.fragment,l),de=a(l),U(Wl.$$.fragment,l),he=a(l),vl=M(l,"P",{"data-svelte-h":!0}),T(vl)!=="svelte-17vlt6v"&&(vl.textContent=bs),Ie=a(l),U(Hl.$$.fragment,l),Ve=a(l),U(ql.$$.fragment,l),Ce=a(l),Yl=M(l,"P",{"data-svelte-h":!0}),T(Yl)!=="svelte-dmjhiw"&&(Yl.textContent=cs),$e=a(l),Ll=M(l,"P",{"data-svelte-h":!0}),T(Ll)!=="svelte-1dmhq65"&&(Ll.textContent=us),Re=a(l),Al=M(l,"P",{"data-svelte-h":!0}),T(Al)!=="svelte-1c1xjkh"&&(Al.textContent=os),Be=a(l),zl=M(l,"P",{"data-svelte-h":!0}),T(zl)!=="svelte-1k8jjj4"&&(zl.textContent=js),_e=a(l),Pl=M(l,"P",{"data-svelte-h":!0}),T(Pl)!=="svelte-uim3uu"&&(Pl.textContent=fs),ke=a(l),U(Dl.$$.fragment,l),ge=a(l),Ol=M(l,"P",{}),hs(Ol).forEach(e),this.h()},h(){Is(b,"name","hf:doc:metadata"),Is(b,"content",Fs)},m(l,t){ks(document.head,b),s(l,j,t),s(l,u,t),s(l,Kl,t),r(f,l,t),s(l,tt,t),r(d,l,t),s(l,et,t),s(l,h,t),s(l,st,t),s(l,I,t),s(l,nt,t),r(V,l,t),s(l,at,t),s(l,C,t),s(l,pt,t),r($,l,t),s(l,Mt,t),s(l,R,t),s(l,it,t),r(B,l,t),s(l,Ut,t),s(l,_,t),s(l,rt,t),s(l,k,t),s(l,mt,t),r(o,l,t),s(l,yt,t),r(g,l,t),s(l,Jt,t),r(N,l,t),s(l,Tt,t),s(l,G,t),s(l,wt,t),r(E,l,t),s(l,bt,t),r(Z,l,t),s(l,ct,t),s(l,F,t),s(l,ut,t),r(Q,l,t),s(l,ot,t),r(S,l,t),s(l,jt,t),s(l,x,t),s(l,ft,t),r(X,l,t),s(l,dt,t),r(W,l,t),s(l,ht,t),s(l,v,t),s(l,It,t),s(l,H,t),s(l,Vt,t),s(l,q,t),s(l,Ct,t),r(Y,l,t),s(l,$t,t),s(l,L,t),s(l,Rt,t),r(A,l,t),s(l,Bt,t),r(z,l,t),s(l,_t,t),s(l,P,t),s(l,kt,t),r(D,l,t),s(l,gt,t),s(l,K,t),s(l,Nt,t),r(O,l,t),s(l,Gt,t),s(l,ll,t),s(l,Et,t),s(l,tl,t),s(l,Zt,t),r(el,l,t),s(l,Ft,t),s(l,sl,t),s(l,Qt,t),r(nl,l,t),s(l,St,t),s(l,al,t),s(l,xt,t),r(pl,l,t),s(l,Xt,t),s(l,Ml,t),s(l,Wt,t),s(l,il,t),s(l,vt,t),r(Ul,l,t),s(l,Ht,t),s(l,rl,t),s(l,qt,t),r(ml,l,t),s(l,Yt,t),s(l,yl,t),s(l,Lt,t),r(Jl,l,t),s(l,At,t),s(l,Tl,t),s(l,zt,t),r(wl,l,t),s(l,Pt,t),r(bl,l,t),s(l,Dt,t),s(l,cl,t),s(l,Kt,t),r(ul,l,t),s(l,Ot,t),s(l,ol,t),s(l,le,t),s(l,jl,t),s(l,te,t),r(fl,l,t),s(l,ee,t),s(l,dl,t),s(l,se,t),r(hl,l,t),s(l,ne,t),s(l,Il,t),s(l,ae,t),s(l,Vl,t),s(l,pe,t),r(Cl,l,t),s(l,Me,t),s(l,$l,t),s(l,ie,t),s(l,Rl,t),s(l,Ue,t),r(Bl,l,t),s(l,re,t),s(l,_l,t),s(l,me,t),r(kl,l,t),s(l,ye,t),r(gl,l,t),s(l,Je,t),s(l,Nl,t),s(l,Te,t),r(Gl,l,t),s(l,we,t),s(l,El,t),s(l,be,t),r(Zl,l,t),s(l,ce,t),s(l,Fl,t),s(l,ue,t),r(Ql,l,t),s(l,oe,t),r(Sl,l,t),s(l,je,t),r(xl,l,t),s(l,fe,t),r(Xl,l,t),s(l,de,t),r(Wl,l,t),s(l,he,t),s(l,vl,t),s(l,Ie,t),r(Hl,l,t),s(l,Ve,t),r(ql,l,t),s(l,Ce,t),s(l,Yl,t),s(l,$e,t),s(l,Ll,t),s(l,Re,t),s(l,Al,t),s(l,Be,t),s(l,zl,t),s(l,_e,t),s(l,Pl,t),s(l,ke,t),r(Dl,l,t),s(l,ge,t),s(l,Ol,t),Ne=!0},p(l,[t]){const ds={};t&2&&(ds.$$scope={dirty:t,ctx:l}),o.$set(ds)},i(l){Ne||(m(f.$$.fragment,l),m(d.$$.fragment,l),m(V.$$.fragment,l),m($.$$.fragment,l),m(B.$$.fragment,l),m(o.$$.fragment,l),m(g.$$.fragment,l),m(N.$$.fragment,l),m(E.$$.fragment,l),m(Z.$$.fragment,l),m(Q.$$.fragment,l),m(S.$$.fragment,l),m(X.$$.fragment,l),m(W.$$.fragment,l),m(Y.$$.fragment,l),m(A.$$.fragment,l),m(z.$$.fragment,l),m(D.$$.fragment,l),m(O.$$.fragment,l),m(el.$$.fragment,l),m(nl.$$.fragment,l),m(pl.$$.fragment,l),m(Ul.$$.fragment,l),m(ml.$$.fragment,l),m(Jl.$$.fragment,l),m(wl.$$.fragment,l),m(bl.$$.fragment,l),m(ul.$$.fragment,l),m(fl.$$.fragment,l),m(hl.$$.fragment,l),m(Cl.$$.fragment,l),m(Bl.$$.fragment,l),m(kl.$$.fragment,l),m(gl.$$.fragment,l),m(Gl.$$.fragment,l),m(Zl.$$.fragment,l),m(Ql.$$.fragment,l),m(Sl.$$.fragment,l),m(xl.$$.fragment,l),m(Xl.$$.fragment,l),m(Wl.$$.fragment,l),m(Hl.$$.fragment,l),m(ql.$$.fragment,l),m(Dl.$$.fragment,l),Ne=!0)},o(l){y(f.$$.fragment,l),y(d.$$.fragment,l),y(V.$$.fragment,l),y($.$$.fragment,l),y(B.$$.fragment,l),y(o.$$.fragment,l),y(g.$$.fragment,l),y(N.$$.fragment,l),y(E.$$.fragment,l),y(Z.$$.fragment,l),y(Q.$$.fragment,l),y(S.$$.fragment,l),y(X.$$.fragment,l),y(W.$$.fragment,l),y(Y.$$.fragment,l),y(A.$$.fragment,l),y(z.$$.fragment,l),y(D.$$.fragment,l),y(O.$$.fragment,l),y(el.$$.fragment,l),y(nl.$$.fragment,l),y(pl.$$.fragment,l),y(Ul.$$.fragment,l),y(ml.$$.fragment,l),y(Jl.$$.fragment,l),y(wl.$$.fragment,l),y(bl.$$.fragment,l),y(ul.$$.fragment,l),y(fl.$$.fragment,l),y(hl.$$.fragment,l),y(Cl.$$.fragment,l),y(Bl.$$.fragment,l),y(kl.$$.fragment,l),y(gl.$$.fragment,l),y(Gl.$$.fragment,l),y(Zl.$$.fragment,l),y(Ql.$$.fragment,l),y(Sl.$$.fragment,l),y(xl.$$.fragment,l),y(Xl.$$.fragment,l),y(Wl.$$.fragment,l),y(Hl.$$.fragment,l),y(ql.$$.fragment,l),y(Dl.$$.fragment,l),Ne=!1},d(l){l&&(e(j),e(u),e(Kl),e(tt),e(et),e(h),e(st),e(I),e(nt),e(at),e(C),e(pt),e(Mt),e(R),e(it),e(Ut),e(_),e(rt),e(k),e(mt),e(yt),e(Jt),e(Tt),e(G),e(wt),e(bt),e(ct),e(F),e(ut),e(ot),e(jt),e(x),e(ft),e(dt),e(ht),e(v),e(It),e(H),e(Vt),e(q),e(Ct),e($t),e(L),e(Rt),e(Bt),e(_t),e(P),e(kt),e(gt),e(K),e(Nt),e(Gt),e(ll),e(Et),e(tl),e(Zt),e(Ft),e(sl),e(Qt),e(St),e(al),e(xt),e(Xt),e(Ml),e(Wt),e(il),e(vt),e(Ht),e(rl),e(qt),e(Yt),e(yl),e(Lt),e(At),e(Tl),e(zt),e(Pt),e(Dt),e(cl),e(Kt),e(Ot),e(ol),e(le),e(jl),e(te),e(ee),e(dl),e(se),e(ne),e(Il),e(ae),e(Vl),e(pe),e(Me),e($l),e(ie),e(Rl),e(Ue),e(re),e(_l),e(me),e(ye),e(Je),e(Nl),e(Te),e(we),e(El),e(be),e(ce),e(Fl),e(ue),e(oe),e(je),e(fe),e(de),e(he),e(vl),e(Ie),e(Ve),e(Ce),e(Yl),e($e),e(Ll),e(Re),e(Al),e(Be),e(zl),e(_e),e(Pl),e(ke),e(ge),e(Ol)),e(b),J(f,l),J(d,l),J(V,l),J($,l),J(B,l),J(o,l),J(g,l),J(N,l),J(E,l),J(Z,l),J(Q,l),J(S,l),J(X,l),J(W,l),J(Y,l),J(A,l),J(z,l),J(D,l),J(O,l),J(el,l),J(nl,l),J(pl,l),J(Ul,l),J(ml,l),J(Jl,l),J(wl,l),J(bl,l),J(ul,l),J(fl,l),J(hl,l),J(Cl,l),J(Bl,l),J(kl,l),J(gl,l),J(Gl,l),J(Zl,l),J(Ql,l),J(Sl,l),J(xl,l),J(Xl,l),J(Wl,l),J(Hl,l),J(ql,l),J(Dl,l)}}}const Fs='{"title":"基于 SQL 和 Jina Reranker v2 的 RAG","local":"基于-sql-和-jina-reranker-v2-的-rag","sections":[{"title":"工作原理","local":"工作原理","sections":[],"depth":3},{"title":"数据库","local":"数据库","sections":[],"depth":3},{"title":"软件和硬件要求","local":"软件和硬件要求","sections":[],"depth":3},{"title":"开始","local":"开始","sections":[{"title":"安装环境","local":"安装环境","sections":[],"depth":3},{"title":"下载数据库","local":"下载数据库","sections":[],"depth":3},{"title":"下载并运行 Jina Reranker v2","local":"下载并运行-jina-reranker-v2","sections":[],"depth":3},{"title":"设置 Mistral Instruct 的接口","local":"设置-mistral-instruct-的接口","sections":[],"depth":3}],"depth":2},{"title":"使用 SQL 感知的 Jina Reranker v2","local":"使用-sql-感知的-jina-reranker-v2","sections":[],"depth":2},{"title":"使用 Mistral Instruct 生成 SQL 查询","local":"使用-mistral-instruct-生成-sql-查询","sections":[],"depth":2},{"title":"运行 SQL 查询","local":"运行-sql-查询","sections":[],"depth":2},{"title":"获取自然语言回答","local":"获取自然语言回答","sections":[],"depth":2},{"title":"尝试自己动手","local":"尝试自己动手","sections":[],"depth":2},{"title":"复习与总结","local":"复习与总结","sections":[],"depth":2}],"depth":1}';function Qs(lt){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Rs{constructor(b){super(),Bs(this,b,Qs,Zs,Vs,{})}}export{Hs as component};
