import{s as Jl,n as bl,o as wl}from"../chunks/scheduler.65852ee5.js";import{S as hl,i as Tl,g as p,s as n,r as i,A as jl,h as o,f as l,c as a,j as rl,u as M,x as c,k as yl,y as Ul,a as s,v as d,d as m,t as u,w as r}from"../chunks/index.aa74147d.js";import{D as fl,C as y}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as jt,E as Zl}from"../chunks/index.e2566494.js";function Gl(ge){let J,Zt,Ut,Gt,b,It,w,Bt,h,ve='<em>作者: <a href="https://github.com/MKhalusova" rel="nofollow">Maria Khalusova</a></em>',Wt,T,Xe='如果你是 RAG 的新手，请先在<a href="https://huggingface.co/learn/cookbook/rag_zephyr_langchain" rel="nofollow">这个其他笔记</a>中探索 RAG 的基础知识，然后回到这里学习如何使用自定义数据构建 RAG。',Ct,j,ke="无论你是正在构建基于 RAG 的个人助理、宠物项目还是企业级 RAG 系统，你很快就会发现，许多重要的知识存储在各种格式中，如 PDF 文件、电子邮件、Markdown 文件、PowerPoint 演示文稿、HTML 页面、Word 文档等。",Rt,U,Ve="你如何预处理所有这些数据，以便你能将其用于 RAG？",gt,f,xe='在这个快速教程中，你将学习如何构建一个将包含多种数据类型的 RAG 系统。你将使用 <a href="https://github.com/Unstructured-IO/unstructured" rel="nofollow">Unstructured</a> 进行数据预处理，Hugging Face Hub 上的开源模型进行嵌入和文本生成，ChromaDB 作为向量存储，以及 LangChain 将所有内容整合在一起。',vt,Z,_e="让我们开始吧！我们首先安装所需的依赖项：",Xt,G,kt,I,$e="接下来，让我们获取一些文档的混合体。假设我想构建一个 RAG 系统，帮助我管理花园中的害虫。为此，我将使用涵盖 IPM（综合害虫管理）主题的多样化文档：",Vt,B,Ye="<li>PDF: <code>https://www.gov.nl.ca/ecc/files/env-protection-pesticides-business-manuals-applic-chapter7.pdf</code></li> <li>PowerPoint: <code>https://ipm.ifas.ufl.edu/pdfs/Citrus_IPM_090913.pptx</code></li> <li>EPUB: <code>https://www.gutenberg.org/ebooks/45957</code></li> <li>HTML: <code>https://blog.fifthroom.com/what-to-do-about-harmful-garden-and-plant-insects-and-pests.html</code></li>",xt,W,He="请随意使用你自己选择的主题文档，这些文档类型由 Unstructured 支持：<code>.eml</code>, <code>.html</code>, <code>.md</code>, <code>.msg</code>, <code>.rst</code>, <code>.rtf</code>, <code>.txt</code>, <code>.xml</code>, <code>.png</code>, <code>.jpg</code>, <code>.jpeg</code>, <code>.tiff</code>, <code>.bmp</code>, <code>.heic</code>, <code>.csv</code>, <code>.doc</code>, <code>.docx</code>, <code>.epub</code>, <code>.odt</code>, <code>.pdf</code>, <code>.ppt</code>, <code>.pptx</code>, <code>.tsv</code>, <code>.xlsx</code>。",_t,C,$t,R,Yt,g,Ne="你可以使用 Unstructured 库逐个预处理文档，并编写自己的脚本来遍历一个目录，但使用本地源连接器（Local source connector）来摄取给定目录中的所有文档会更加简单。Unstructured 可以从本地目录、S3 存储桶、Blob 存储、SFTP 以及许多其他可能存储文档的地方摄取文档。从这些来源摄取文档的过程非常相似，主要区别在于认证选项。",Ht,v,Qe=`在这里，你将使用本地源连接器，但也可以自由探索<a href="https://docs.unstructured.io/open-source/ingest/source-connectors/overview" rel="nofollow">Unstructured 文档</a>中的其他选项。
可选地，你还可以为处理后的文档选择一个<a href="https://docs.unstructured.io/open-source/ingest/destination-connectors/overview" rel="nofollow">目的地</a> - 这可以是 MongoDB、Pinecone、Weaviate 等。在这个 notebook 中，我们将保持所有内容为本地。`,Nt,X,Qt,k,zt,V,ze=`INFO: NumExpr defaulting to 2 threads.
`,Ft,x,Fe="让我们更详细地看看这里的配置。",Et,_,Ee="<code>ProcessorConfig</code> 控制处理管道的各个方面，包括输出位置、工作线程数量、错误处理行为、日志详细程度等。这里的唯一必填参数是 <code>output_dir</code> - 你希望存储输出的本地目录。",At,$,Ae="<code>ReadConfig</code> 可以用来为不同场景自定义数据读取过程，例如重新下载数据、保留已下载的文件或限制处理的文档数量。在大多数情况下，默认的 <code>ReadConfig</code> 将适用。",St,Y,Se='在 <code>PartitionConfig</code> 中，你可以选择是在本地还是通过 API 对文档进行分区。这个例子使用 API，因此需要 Unstructured API 密钥。你可以在这里<a href="https://unstructured.io/api-key-free" rel="nofollow">获取</a>。免费的 Unstructured API 限制为 1000 页，并且为基于图像的文档提供了比本地安装的 Unstructured 更好的 OCR 模型。',Lt,H,Le="如果你删除这两个参数，文档将本地处理，但如果文档需要 OCR 和/或文档理解模型，你可能需要安装额外的依赖项。具体来说，在这种情况下，你可能需要安装 poppler 和 tesseract，你可以使用 brew 来获取：",qt,N,Pt,Q,qe='如果你使用的是 Windows 系统，你可以在<a href="https://docs.unstructured.io/open-source/installation/full-installation" rel="nofollow">Unstructured 文档</a>中找到替代的安装说明。',Dt,z,Pe="最后，在 <code>SimpleLocalConfig</code> 中，你需要指定原始文档所在的位置，以及你是否想要递归地遍历目录。",Kt,F,De="一旦文档被处理，你将在 <code>local-ingest-output</code> 目录中找到 4 个 json 文件，每个被处理的文档对应一个。",Ot,E,Ke="Unstructured 以统一的方式对所有类型的文档进行分区，并返回带有文档元素的 json。",te,A,Oe='<a href="https://docs.unstructured.io/api-reference/api-services/document-elements" rel="nofollow">文档元素</a> 有一个类型，例如 <code>NarrativeText</code>，<code>Title</code> 或 <code>Table</code>，它们包含提取的文本，以及 Unstructured 能够获取的元数据。一些元数据对所有元素都是通用的，比如元素所在的文档的文件名。其他元数据取决于文件类型或元素类型。例如，<code>Table</code> 元素将在元数据中包含表格的 html 表示，而电子邮件的元数据将包含关于发件人和收件人的信息。',ee,S,tl="让我们从这些 json 文件中导入元素对象。",le,L,se,q,el="现在你已经从文档中提取了元素，你可以将它们分块以适应嵌入模型的上下文窗口。",ne,P,ae,D,ll="如果你熟悉将长文本文档分割成较小块的分块方法，你会注意到 Unstructured 的分块方法略有不同，因为分区步骤已经将整个文档分割成其结构元素：标题、列表项、表格、文本等。通过这种方式对文档进行分区，你可以避免不相关的文本片段最终出现在同一个元素，甚至是同一个块中的情况。",pe,K,sl="现在，当你使用 Unstructured 对文档元素进行分块时，单个元素已经是小的，因此只有当它们超过所需的最大块大小时才会被分割。否则，它们将保持原样。你还可以选择性地将连续的文本元素（例如列表项）组合在一起，使它们共同符合块大小限制。",oe,O,ce,tt,nl="这些块已经准备好用于 RAG 了。为了将它们与 LangChain 一起使用，你可以轻松地将 Unstructured 元素转换为 LangChain 文档。",ie,et,Me,lt,de,st,al='这个例子使用 ChromaDB 作为向量存储，以及 <a href="https://huggingface.co/BAAI/bge-base-en-v1.5" rel="nofollow"><code>BAAI/bge-base-en-v1.5</code></a> 嵌入模型，你可以自由使用任何其他向量存储。',me,nt,ue,at,pl="如果你打算使用 Hugging Face Hub 上的门控模型，无论是嵌入模型还是文本生成模型，你都需要使用你的 Hugging Face token 进行身份验证，你可以在你的 Hugging Face 个人资料设置中获取这个 token 。",re,pt,ye,ot,Je,ct,ol="让我们将所有内容整合在一起，使用 LangChain 构建 RAG。",be,it,cl='在这个例子中，我们将使用来自 Meta 的<a href="https://huggingface.co/meta-llama/Meta-Llama-3-8B-Instruct" rel="nofollow"><code>Llama-3-8B-Instruct</code></a>。为了确保它可以在 Google Colab 的免费 T4 运行时中顺利运行，你需要对其进行量化。',we,Mt,he,dt,Te,mt,je,ut,il="现在你已经有了 RAG 链，让我们问问它关于蚜虫的问题。在我的花园里，它们是害虫吗？",Ue,rt,fe,yt,Ml="输出:",Ze,Jt,Ge,bt,dl="这看起来是一个很有希望的开始！现在你已经了解了预处理复杂非结构化数据以供 RAG 使用的基础知识，你可以继续改进这个例子。以下是一些建议：",Ie,wt,ml='<li>你可以连接到不同的源来摄取文档，例如，从一个 S3 存储桶。</li> <li>你可以在 <code>qa_chain</code> 参数中添加 <code>return_source_documents=True</code>，使链在返回答案时同时返回作为上下文传递给提示的文档。这有助于理解生成答案时使用了哪些源。</li> <li>如果你想要在检索阶段利用元素元数据，可以考虑使用 Hugging Face Agent 并创建一个自定义检索器工具，如<a href="https://huggingface.co/learn/cookbook/agents#2--rag-with-iterative-query-refinement--source-selection" rel="nofollow">这个其他 notebook</a> 中所述。</li> <li>有许多方法可以改善搜索结果。例如，你可以使用混合搜索代替单一的相似性搜索检索器。混合搜索结合了多种搜索算法，以提高搜索结果的准确性和相关性。通常，它是基于关键词的搜索算法与向量搜索方法的结合。</li>',Be,ht,ul="在使用非结构化数据构建 RAG 应用程序时玩得开心！",We,Tt,Ce,ft,Re;return b=new fl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_unstructured_data.ipynb"}]}}),w=new jt({props:{title:"使用自定义非结构化数据构建 RAG",local:"使用自定义非结构化数据构建-rag",headingTag:"h1"}}),G=new y({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMHVuc3RydWN0dXJlZCU1QmFsbC1kb2NzJTVEJTIwbGFuZ2NoYWluJTIwY2hyb21hZGIlMjBsYW5nY2hhaW5fY29tbXVuaXR5",highlighted:'!pip install -q torch transformers accelerate bitsandbytes sentence-transformers unstructured[<span class="hljs-built_in">all</span>-docs] langchain chromadb langchain_community',wrap:!1}}),C=new y({props:{code:"IW1rZGlyJTIwLXAlMjAlMjIuJTJGZG9jdW1lbnRzJTIyJTBBIXdnZXQlMjBodHRwcyUzQSUyRiUyRnd3dy5nb3YubmwuY2ElMkZlY2MlMkZmaWxlcyUyRmVudi1wcm90ZWN0aW9uLXBlc3RpY2lkZXMtYnVzaW5lc3MtbWFudWFscy1hcHBsaWMtY2hhcHRlcjcucGRmJTIwLU8lMjAlMjIuJTJGZG9jdW1lbnRzJTJGZW52LXByb3RlY3Rpb24tcGVzdGljaWRlcy1idXNpbmVzcy1tYW51YWxzLWFwcGxpYy1jaGFwdGVyNy5wZGYlMjIlMEEhd2dldCUyMGh0dHBzJTNBJTJGJTJGaXBtLmlmYXMudWZsLmVkdSUyRnBkZnMlMkZDaXRydXNfSVBNXzA5MDkxMy5wcHR4JTIwLU8lMjAlMjIuJTJGZG9jdW1lbnRzJTJGQ2l0cnVzX0lQTV8wOTA5MTMucHB0eCUyMiUwQSF3Z2V0JTIwaHR0cHMlM0ElMkYlMkZ3d3cuZ3V0ZW5iZXJnLm9yZyUyRmVib29rcyUyRjQ1OTU3LmVwdWIzLmltYWdlcyUyMC1PJTIwJTIyLiUyRmRvY3VtZW50cyUyRjQ1OTU3LmVwdWIlMjIlMEEhd2dldCUyMGh0dHBzJTNBJTJGJTJGYmxvZy5maWZ0aHJvb20uY29tJTJGd2hhdC10by1kby1hYm91dC1oYXJtZnVsLWdhcmRlbi1hbmQtcGxhbnQtaW5zZWN0cy1hbmQtcGVzdHMuaHRtbCUyMC1PJTIwJTIyLiUyRmRvY3VtZW50cyUyRndoYXQtdG8tZG8tYWJvdXQtaGFybWZ1bC1nYXJkZW4tYW5kLXBsYW50LWluc2VjdHMtYW5kLXBlc3RzLmh0bWwlMjI=",highlighted:`!mkdir -p <span class="hljs-string">&quot;./documents&quot;</span>
!wget https://www.gov.nl.ca/ecc/files/env-protection-pesticides-business-manuals-applic-chapter7.pdf -O <span class="hljs-string">&quot;./documents/env-protection-pesticides-business-manuals-applic-chapter7.pdf&quot;</span>
!wget https://ipm.ifas.ufl.edu/pdfs/Citrus_IPM_090913.pptx -O <span class="hljs-string">&quot;./documents/Citrus_IPM_090913.pptx&quot;</span>
!wget https://www.gutenberg.org/ebooks/<span class="hljs-number">45957.</span>epub3.images -O <span class="hljs-string">&quot;./documents/45957.epub&quot;</span>
!wget https://blog.fifthroom.com/what-to-do-about-harmful-garden-<span class="hljs-keyword">and</span>-plant-insects-<span class="hljs-keyword">and</span>-pests.html -O <span class="hljs-string">&quot;./documents/what-to-do-about-harmful-garden-and-plant-insects-and-pests.html&quot;</span>`,wrap:!1}}),R=new jt({props:{title:"非结构化数据预处理",local:"非结构化数据预处理",headingTag:"h2"}}),X=new y({props:{code:"JTIzJTIwT3B0aW9uYWwlMjBjZWxsJTIwdG8lMjByZWR1Y2UlMjB0aGUlMjBhbW91bnQlMjBvZiUyMGxvZ3MlMEElMEFpbXBvcnQlMjBsb2dnaW5nJTBBJTBBbG9nZ2VyJTIwJTNEJTIwbG9nZ2luZy5nZXRMb2dnZXIoJTIydW5zdHJ1Y3R1cmVkLmluZ2VzdCUyMiklMEFsb2dnZXIucm9vdC5yZW1vdmVIYW5kbGVyKGxvZ2dlci5yb290LmhhbmRsZXJzJTVCMCU1RCk=",highlighted:`<span class="hljs-comment"># Optional cell to reduce the amount of logs</span>

<span class="hljs-keyword">import</span> logging

logger = logging.getLogger(<span class="hljs-string">&quot;unstructured.ingest&quot;</span>)
logger.root.removeHandler(logger.root.handlers[<span class="hljs-number">0</span>])`,wrap:!1}}),k=new y({props:{code:"aW1wb3J0JTIwb3MlMEElMEFmcm9tJTIwdW5zdHJ1Y3R1cmVkLmluZ2VzdC5jb25uZWN0b3IubG9jYWwlMjBpbXBvcnQlMjBTaW1wbGVMb2NhbENvbmZpZyUwQWZyb20lMjB1bnN0cnVjdHVyZWQuaW5nZXN0LmludGVyZmFjZXMlMjBpbXBvcnQlMjBQYXJ0aXRpb25Db25maWclMkMlMjBQcm9jZXNzb3JDb25maWclMkMlMjBSZWFkQ29uZmlnJTBBZnJvbSUyMHVuc3RydWN0dXJlZC5pbmdlc3QucnVubmVyJTIwaW1wb3J0JTIwTG9jYWxSdW5uZXIlMEElMEFvdXRwdXRfcGF0aCUyMCUzRCUyMCUyMi4lMkZsb2NhbC1pbmdlc3Qtb3V0cHV0JTIyJTBBJTBBcnVubmVyJTIwJTNEJTIwTG9jYWxSdW5uZXIoJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc29yX2NvbmZpZyUzRFByb2Nlc3NvckNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb2dzJTIwdmVyYm9zaXR5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVyYm9zZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjB0aGUlMjBsb2NhbCUyMGRpcmVjdG9yeSUyMHRvJTIwc3RvcmUlMjBvdXRwdXRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRG91dHB1dF9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3Byb2Nlc3NlcyUzRDIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwcmVhZF9jb25maWclM0RSZWFkQ29uZmlnKCklMkMlMEElMjAlMjAlMjAlMjBwYXJ0aXRpb25fY29uZmlnJTNEUGFydGl0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcnRpdGlvbl9ieV9hcGklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMllPVVJfVU5TVFJVQ1RVUkVEX0FQSV9LRVklMjIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwY29ubmVjdG9yX2NvbmZpZyUzRFNpbXBsZUxvY2FsQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0X3BhdGglM0QlMjIuJTJGZG9jdW1lbnRzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwd2hldGhlciUyMHRvJTIwZ2V0JTIwdGhlJTIwZG9jdW1lbnRzJTIwcmVjdXJzaXZlbHklMjBmcm9tJTIwZ2l2ZW4lMjBkaXJlY3RvcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZWN1cnNpdmUlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMkMlMEEpJTBBcnVubmVyLnJ1bigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.connector.local <span class="hljs-keyword">import</span> SimpleLocalConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.interfaces <span class="hljs-keyword">import</span> PartitionConfig, ProcessorConfig, ReadConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> unstructured.ingest.runner <span class="hljs-keyword">import</span> LocalRunner

<span class="hljs-meta">&gt;&gt;&gt; </span>output_path = <span class="hljs-string">&quot;./local-ingest-output&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>runner = LocalRunner(
<span class="hljs-meta">... </span>    processor_config=ProcessorConfig(
<span class="hljs-meta">... </span>        <span class="hljs-comment"># logs verbosity</span>
<span class="hljs-meta">... </span>        verbose=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># the local directory to store outputs</span>
<span class="hljs-meta">... </span>        output_dir=output_path,
<span class="hljs-meta">... </span>        num_processes=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    read_config=ReadConfig(),
<span class="hljs-meta">... </span>    partition_config=PartitionConfig(
<span class="hljs-meta">... </span>        partition_by_api=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        api_key=<span class="hljs-string">&quot;YOUR_UNSTRUCTURED_API_KEY&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    connector_config=SimpleLocalConfig(
<span class="hljs-meta">... </span>        input_path=<span class="hljs-string">&quot;./documents&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-comment"># whether to get the documents recursively from given directory</span>
<span class="hljs-meta">... </span>        recursive=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>runner.run()`,wrap:!1}}),N=new y({props:{code:"IWJyZXclMjBpbnN0YWxsJTIwcG9wcGxlciUwQSFicmV3JTIwaW5zdGFsbCUyMHRlc3NlcmFjdA==",highlighted:`!<span class="hljs-keyword">brew </span><span class="hljs-keyword">install </span>poppler
!<span class="hljs-keyword">brew </span><span class="hljs-keyword">install </span>tesseract`,wrap:!1}}),L=new y({props:{code:"ZnJvbSUyMHVuc3RydWN0dXJlZC5zdGFnaW5nLmJhc2UlMjBpbXBvcnQlMjBlbGVtZW50c19mcm9tX2pzb24lMEElMEFlbGVtZW50cyUyMCUzRCUyMCU1QiU1RCUwQSUwQWZvciUyMGZpbGVuYW1lJTIwaW4lMjBvcy5saXN0ZGlyKG91dHB1dF9wYXRoKSUzQSUwQSUyMCUyMCUyMCUyMGZpbGVwYXRoJTIwJTNEJTIwb3MucGF0aC5qb2luKG91dHB1dF9wYXRoJTJDJTIwZmlsZW5hbWUpJTBBJTIwJTIwJTIwJTIwZWxlbWVudHMuZXh0ZW5kKGVsZW1lbnRzX2Zyb21fanNvbihmaWxlcGF0aCkp",highlighted:`<span class="hljs-keyword">from</span> unstructured.staging.base <span class="hljs-keyword">import</span> elements_from_json

elements = []

<span class="hljs-keyword">for</span> filename <span class="hljs-keyword">in</span> os.listdir(output_path):
    filepath = os.path.join(output_path, filename)
    elements.extend(elements_from_json(filepath))`,wrap:!1}}),P=new jt({props:{title:"分块",local:"分块",headingTag:"h2"}}),O=new y({props:{code:"ZnJvbSUyMHVuc3RydWN0dXJlZC5jaHVua2luZy50aXRsZSUyMGltcG9ydCUyMGNodW5rX2J5X3RpdGxlJTBBJTBBY2h1bmtlZF9lbGVtZW50cyUyMCUzRCUyMGNodW5rX2J5X3RpdGxlKCUwQSUyMCUyMCUyMCUyMGVsZW1lbnRzJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwbWF4aW11bSUyMGZvciUyMGNodW5rJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMG1heF9jaGFyYWN0ZXJzJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwWW91JTIwY2FuJTIwY2hvb3NlJTIwdG8lMjBjb21iaW5lJTIwY29uc2VjdXRpdmUlMjBlbGVtZW50cyUyMHRoYXQlMjBhcmUlMjB0b28lMjBzbWFsbCUwQSUyMCUyMCUyMCUyMCUyMyUyMGUuZy4lMjBpbmRpdmlkdWFsJTIwbGlzdCUyMGl0ZW1zJTBBJTIwJTIwJTIwJTIwY29tYmluZV90ZXh0X3VuZGVyX25fY2hhcnMlM0QyMDAlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> unstructured.chunking.title <span class="hljs-keyword">import</span> chunk_by_title

chunked_elements = chunk_by_title(
    elements,
    <span class="hljs-comment"># maximum for chunk size</span>
    max_characters=<span class="hljs-number">512</span>,
    <span class="hljs-comment"># You can choose to combine consecutive elements that are too small</span>
    <span class="hljs-comment"># e.g. individual list items</span>
    combine_text_under_n_chars=<span class="hljs-number">200</span>,
)`,wrap:!1}}),et=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb3JlLmRvY3VtZW50cyUyMGltcG9ydCUyMERvY3VtZW50JTBBJTBBZG9jdW1lbnRzJTIwJTNEJTIwJTVCJTVEJTBBZm9yJTIwY2h1bmtlZF9lbGVtZW50JTIwaW4lMjBjaHVua2VkX2VsZW1lbnRzJTNBJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElMjAlM0QlMjBjaHVua2VkX2VsZW1lbnQubWV0YWRhdGEudG9fZGljdCgpJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjAlM0QlMjBtZXRhZGF0YSU1QiUyMmZpbGVuYW1lJTIyJTVEJTBBJTIwJTIwJTIwJTIwZGVsJTIwbWV0YWRhdGElNUIlMjJsYW5ndWFnZXMlMjIlNUQlMEElMjAlMjAlMjAlMjBkb2N1bWVudHMuYXBwZW5kKERvY3VtZW50KHBhZ2VfY29udGVudCUzRGNodW5rZWRfZWxlbWVudC50ZXh0JTJDJTIwbWV0YWRhdGElM0RtZXRhZGF0YSkp",highlighted:`<span class="hljs-keyword">from</span> langchain_core.documents <span class="hljs-keyword">import</span> Document

documents = []
<span class="hljs-keyword">for</span> chunked_element <span class="hljs-keyword">in</span> chunked_elements:
    metadata = chunked_element.metadata.to_dict()
    metadata[<span class="hljs-string">&quot;source&quot;</span>] = metadata[<span class="hljs-string">&quot;filename&quot;</span>]
    <span class="hljs-keyword">del</span> metadata[<span class="hljs-string">&quot;languages&quot;</span>]
    documents.append(Document(page_content=chunked_element.text, metadata=metadata))`,wrap:!1}}),lt=new jt({props:{title:"设置检索器",local:"设置检索器",headingTag:"h2"}}),nt=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbl9jb21tdW5pdHkudmVjdG9yc3RvcmVzJTIwaW1wb3J0JTIwQ2hyb21hJTBBZnJvbSUyMGxhbmdjaGFpbi5lbWJlZGRpbmdzJTIwaW1wb3J0JTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzJTBBJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjB1dGlscyUyMGFzJTIwY2hyb21hdXRpbHMlMEElMEElMjMlMjBDaHJvbWFEQiUyMGRvZXNuJ3QlMjBzdXBwb3J0JTIwY29tcGxleCUyMG1ldGFkYXRhJTJDJTIwZS5nLiUyMGxpc3RzJTJDJTIwc28lMjB3ZSUyMGRyb3AlMjBpdCUyMGhlcmUuJTBBJTIzJTIwSWYlMjB5b3UncmUlMjB1c2luZyUyMGElMjBkaWZmZXJlbnQlMjB2ZWN0b3IlMjBzdG9yZSUyQyUyMHlvdSUyMG1heSUyMG5vdCUyMG5lZWQlMjB0byUyMGRvJTIwdGhpcyUwQWRvY3MlMjAlM0QlMjBjaHJvbWF1dGlscy5maWx0ZXJfY29tcGxleF9tZXRhZGF0YShkb2N1bWVudHMpJTBBJTBBZW1iZWRkaW5ncyUyMCUzRCUyMEh1Z2dpbmdGYWNlRW1iZWRkaW5ncyhtb2RlbF9uYW1lJTNEJTIyQkFBSSUyRmJnZS1iYXNlLWVuLXYxLjUlMjIpJTBBdmVjdG9yc3RvcmUlMjAlM0QlMjBDaHJvbWEuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTJDJTIwZW1iZWRkaW5ncyklMEFyZXRyaWV2ZXIlMjAlM0QlMjB2ZWN0b3JzdG9yZS5hc19yZXRyaWV2ZXIoc2VhcmNoX3R5cGUlM0QlMjJzaW1pbGFyaXR5JTIyJTJDJTIwc2VhcmNoX2t3YXJncyUzRCU3QiUyMmslMjIlM0ElMjAzJTdEKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain_community.vectorstores <span class="hljs-keyword">import</span> Chroma
<span class="hljs-keyword">from</span> langchain.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> utils <span class="hljs-keyword">as</span> chromautils

<span class="hljs-comment"># ChromaDB doesn&#x27;t support complex metadata, e.g. lists, so we drop it here.</span>
<span class="hljs-comment"># If you&#x27;re using a different vector store, you may not need to do this</span>
docs = chromautils.filter_complex_metadata(documents)

embeddings = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;BAAI/bge-base-en-v1.5&quot;</span>)
vectorstore = Chroma.from_documents(documents, embeddings)
retriever = vectorstore.as_retriever(search_type=<span class="hljs-string">&quot;similarity&quot;</span>, search_kwargs={<span class="hljs-string">&quot;k&quot;</span>: <span class="hljs-number">3</span>})`,wrap:!1}}),pt=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),ot=new jt({props:{title:"使用 LangChain 构建 RAG",local:"使用-langchain-构建-rag",headingTag:"h2"}}),Mt=new y({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5wcm9tcHRzJTIwaW1wb3J0JTIwUHJvbXB0VGVtcGxhdGUlMEFmcm9tJTIwbGFuZ2NoYWluLmxsbXMlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZVBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBZnJvbSUyMGxhbmdjaGFpbi5jaGFpbnMlMjBpbXBvcnQlMjBSZXRyaWV2YWxRQQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.prompts <span class="hljs-keyword">import</span> PromptTemplate
<span class="hljs-keyword">from</span> langchain.llms <span class="hljs-keyword">import</span> HuggingFacePipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">from</span> langchain.chains <span class="hljs-keyword">import</span> RetrievalQA`,wrap:!1}}),dt=new y({props:{code:"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",highlighted:`model_name = <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>, bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>, bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(model_name, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(model_name)

terminators = [tokenizer.eos_token_id, tokenizer.convert_tokens_to_ids(<span class="hljs-string">&quot;&lt;|eot_id|&gt;&quot;</span>)]

text_generation_pipeline = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    temperature=<span class="hljs-number">0.2</span>,
    do_sample=<span class="hljs-literal">True</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    max_new_tokens=<span class="hljs-number">200</span>,
    eos_token_id=terminators,
)

llm = HuggingFacePipeline(pipeline=text_generation_pipeline)

prompt_template = <span class="hljs-string">&quot;&quot;&quot;
&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;
You are an assistant for answering questions using provided context.
You are given the extracted parts of a long document and a question. Provide a conversational answer.
If you don&#x27;t know the answer, just say &quot;I do not know.&quot; Don&#x27;t make up an answer.
Question: {question}
Context: {context}&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;
&quot;&quot;&quot;</span>

prompt = PromptTemplate(
    input_variables=[<span class="hljs-string">&quot;context&quot;</span>, <span class="hljs-string">&quot;question&quot;</span>],
    template=prompt_template,
)


qa_chain = RetrievalQA.from_chain_type(llm, retriever=retriever, chain_type_kwargs={<span class="hljs-string">&quot;prompt&quot;</span>: prompt})`,wrap:!1}}),mt=new jt({props:{title:"结果和下一步",local:"结果和下一步",headingTag:"h2"}}),rt=new y({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJBcmUlMjBhcGhpZHMlMjBhJTIwcGVzdCUzRiUyMiUwQSUwQXFhX2NoYWluLmludm9rZShxdWVzdGlvbiklNUIlMjJyZXN1bHQlMjIlNUQ=",highlighted:`question = <span class="hljs-string">&quot;Are aphids a pest?&quot;</span>

qa_chain.invoke(question)[<span class="hljs-string">&quot;result&quot;</span>]`,wrap:!1}}),Jt=new y({props:{code:"WWVzJTJDJTIwYXBoaWRzJTIwYXJlJTIwY29uc2lkZXJlZCUyMHBlc3RzJTIwYmVjYXVzZSUyMHRoZXklMjBmZWVkJTIwb24lMjB0aGUlMjBudXRyaWVudC1yaWNoJTIwbGlxdWlkcyUyMHdpdGhpbiUyMHBsYW50cyUyQyUyMGNhdXNpbmclMjBkYW1hZ2UlMjBhbmQlMjBwb3RlbnRpYWxseSUyMHNwcmVhZGluZyUyMGRpc2Vhc2UuJTIwSW4lMjBmYWN0JTJDJTIwdGhleSdyZSUyMGtub3duJTIwdG8lMjBtdWx0aXBseSUyMHF1aWNrbHklMkMlMjB3aGljaCUyMGlzJTIwd2h5JTIwaXQncyUyMGVzc2VudGlhbCUyMHRvJTIwY29udHJvbCUyMHRoZW0lMjBwcm9tcHRseS4lMjBBcyUyMG1lbnRpb25lZCUyMGluJTIwdGhlJTIwdGV4dCUyQyUyMGFwaGlkcyUyMGNhbiUyMGFsc28lMjBhdHRyYWN0JTIwYW50cyUyQyUyMHdoaWNoJTIwYXJlJTIwYXR0cmFjdGVkJTIwdG8lMjB0aGUlMjBzd2VldCUyQyUyMHN0aWNreSUyMHN1YnN0YW5jZSUyMHRoZXklMjBwcm9kdWNlJTIwY2FsbGVkJTIwaG9uZXlkZXcuJTIwU28lMkMlMjB5ZXMlMkMlMjBhcGhpZHMlMjBhcmUlMjBpbmRlZWQlMjBhJTIwcGVzdCUyMHRoYXQlMjByZXF1aXJlcyUyMGF0dGVudGlvbiUyMHRvJTIwcHJldmVudCUyMGZ1cnRoZXIlMjBoYXJtJTIwdG8lMjB5b3VyJTIwcGxhbnRzIQ==",highlighted:'Yes, aphids are considered pests because they feed on the nutrient-rich liquids within plants, causing damage and potentially spreading disease. In fact, they<span class="hljs-string">&#x27;re known to multiply quickly, which is why it&#x27;</span>s essential to control them promptly. As mentioned <span class="hljs-keyword">in</span> the text, aphids can also attract ants, <span class="hljs-built_in">which</span> are attracted to the sweet, sticky substance they produce called honeydew. So, <span class="hljs-built_in">yes</span>, aphids are indeed a pest that requires attention to prevent further harm to your plants!',wrap:!1}}),Tt=new Zl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/rag_with_unstructured_data.md"}}),{c(){J=p("meta"),Zt=n(),Ut=p("p"),Gt=n(),i(b.$$.fragment),It=n(),i(w.$$.fragment),Bt=n(),h=p("p"),h.innerHTML=ve,Wt=n(),T=p("p"),T.innerHTML=Xe,Ct=n(),j=p("p"),j.textContent=ke,Rt=n(),U=p("p"),U.textContent=Ve,gt=n(),f=p("p"),f.innerHTML=xe,vt=n(),Z=p("p"),Z.textContent=_e,Xt=n(),i(G.$$.fragment),kt=n(),I=p("p"),I.textContent=$e,Vt=n(),B=p("ul"),B.innerHTML=Ye,xt=n(),W=p("p"),W.innerHTML=He,_t=n(),i(C.$$.fragment),$t=n(),i(R.$$.fragment),Yt=n(),g=p("p"),g.textContent=Ne,Ht=n(),v=p("p"),v.innerHTML=Qe,Nt=n(),i(X.$$.fragment),Qt=n(),i(k.$$.fragment),zt=n(),V=p("pre"),V.textContent=ze,Ft=n(),x=p("p"),x.textContent=Fe,Et=n(),_=p("p"),_.innerHTML=Ee,At=n(),$=p("p"),$.innerHTML=Ae,St=n(),Y=p("p"),Y.innerHTML=Se,Lt=n(),H=p("p"),H.textContent=Le,qt=n(),i(N.$$.fragment),Pt=n(),Q=p("p"),Q.innerHTML=qe,Dt=n(),z=p("p"),z.innerHTML=Pe,Kt=n(),F=p("p"),F.innerHTML=De,Ot=n(),E=p("p"),E.textContent=Ke,te=n(),A=p("p"),A.innerHTML=Oe,ee=n(),S=p("p"),S.textContent=tl,le=n(),i(L.$$.fragment),se=n(),q=p("p"),q.textContent=el,ne=n(),i(P.$$.fragment),ae=n(),D=p("p"),D.textContent=ll,pe=n(),K=p("p"),K.textContent=sl,oe=n(),i(O.$$.fragment),ce=n(),tt=p("p"),tt.textContent=nl,ie=n(),i(et.$$.fragment),Me=n(),i(lt.$$.fragment),de=n(),st=p("p"),st.innerHTML=al,me=n(),i(nt.$$.fragment),ue=n(),at=p("p"),at.textContent=pl,re=n(),i(pt.$$.fragment),ye=n(),i(ot.$$.fragment),Je=n(),ct=p("p"),ct.textContent=ol,be=n(),it=p("p"),it.innerHTML=cl,we=n(),i(Mt.$$.fragment),he=n(),i(dt.$$.fragment),Te=n(),i(mt.$$.fragment),je=n(),ut=p("p"),ut.textContent=il,Ue=n(),i(rt.$$.fragment),fe=n(),yt=p("p"),yt.textContent=Ml,Ze=n(),i(Jt.$$.fragment),Ge=n(),bt=p("p"),bt.textContent=dl,Ie=n(),wt=p("ul"),wt.innerHTML=ml,Be=n(),ht=p("p"),ht.textContent=ul,We=n(),i(Tt.$$.fragment),Ce=n(),ft=p("p"),this.h()},l(t){const e=jl("svelte-u9bgzb",document.head);J=o(e,"META",{name:!0,content:!0}),e.forEach(l),Zt=a(t),Ut=o(t,"P",{}),rl(Ut).forEach(l),Gt=a(t),M(b.$$.fragment,t),It=a(t),M(w.$$.fragment,t),Bt=a(t),h=o(t,"P",{"data-svelte-h":!0}),c(h)!=="svelte-1dsumsc"&&(h.innerHTML=ve),Wt=a(t),T=o(t,"P",{"data-svelte-h":!0}),c(T)!=="svelte-3uc38r"&&(T.innerHTML=Xe),Ct=a(t),j=o(t,"P",{"data-svelte-h":!0}),c(j)!=="svelte-1jejzpj"&&(j.textContent=ke),Rt=a(t),U=o(t,"P",{"data-svelte-h":!0}),c(U)!=="svelte-108lwow"&&(U.textContent=Ve),gt=a(t),f=o(t,"P",{"data-svelte-h":!0}),c(f)!=="svelte-u2nlko"&&(f.innerHTML=xe),vt=a(t),Z=o(t,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-atnnoi"&&(Z.textContent=_e),Xt=a(t),M(G.$$.fragment,t),kt=a(t),I=o(t,"P",{"data-svelte-h":!0}),c(I)!=="svelte-c6aicn"&&(I.textContent=$e),Vt=a(t),B=o(t,"UL",{"data-svelte-h":!0}),c(B)!=="svelte-vnyaw6"&&(B.innerHTML=Ye),xt=a(t),W=o(t,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1tzlo34"&&(W.innerHTML=He),_t=a(t),M(C.$$.fragment,t),$t=a(t),M(R.$$.fragment,t),Yt=a(t),g=o(t,"P",{"data-svelte-h":!0}),c(g)!=="svelte-qerbdo"&&(g.textContent=Ne),Ht=a(t),v=o(t,"P",{"data-svelte-h":!0}),c(v)!=="svelte-3h3z97"&&(v.innerHTML=Qe),Nt=a(t),M(X.$$.fragment,t),Qt=a(t),M(k.$$.fragment,t),zt=a(t),V=o(t,"PRE",{"data-svelte-h":!0}),c(V)!=="svelte-v64b1c"&&(V.textContent=ze),Ft=a(t),x=o(t,"P",{"data-svelte-h":!0}),c(x)!=="svelte-17tjh3m"&&(x.textContent=Fe),Et=a(t),_=o(t,"P",{"data-svelte-h":!0}),c(_)!=="svelte-1qepdby"&&(_.innerHTML=Ee),At=a(t),$=o(t,"P",{"data-svelte-h":!0}),c($)!=="svelte-m7nago"&&($.innerHTML=Ae),St=a(t),Y=o(t,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-9useuz"&&(Y.innerHTML=Se),Lt=a(t),H=o(t,"P",{"data-svelte-h":!0}),c(H)!=="svelte-10673q4"&&(H.textContent=Le),qt=a(t),M(N.$$.fragment,t),Pt=a(t),Q=o(t,"P",{"data-svelte-h":!0}),c(Q)!=="svelte-kxreac"&&(Q.innerHTML=qe),Dt=a(t),z=o(t,"P",{"data-svelte-h":!0}),c(z)!=="svelte-ekilao"&&(z.innerHTML=Pe),Kt=a(t),F=o(t,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1yh9txq"&&(F.innerHTML=De),Ot=a(t),E=o(t,"P",{"data-svelte-h":!0}),c(E)!=="svelte-f6f8r3"&&(E.textContent=Ke),te=a(t),A=o(t,"P",{"data-svelte-h":!0}),c(A)!=="svelte-10x7mns"&&(A.innerHTML=Oe),ee=a(t),S=o(t,"P",{"data-svelte-h":!0}),c(S)!=="svelte-jxqg42"&&(S.textContent=tl),le=a(t),M(L.$$.fragment,t),se=a(t),q=o(t,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1km01k9"&&(q.textContent=el),ne=a(t),M(P.$$.fragment,t),ae=a(t),D=o(t,"P",{"data-svelte-h":!0}),c(D)!=="svelte-7gjri4"&&(D.textContent=ll),pe=a(t),K=o(t,"P",{"data-svelte-h":!0}),c(K)!=="svelte-k9vqp3"&&(K.textContent=sl),oe=a(t),M(O.$$.fragment,t),ce=a(t),tt=o(t,"P",{"data-svelte-h":!0}),c(tt)!=="svelte-e3h6u7"&&(tt.textContent=nl),ie=a(t),M(et.$$.fragment,t),Me=a(t),M(lt.$$.fragment,t),de=a(t),st=o(t,"P",{"data-svelte-h":!0}),c(st)!=="svelte-1cr8uox"&&(st.innerHTML=al),me=a(t),M(nt.$$.fragment,t),ue=a(t),at=o(t,"P",{"data-svelte-h":!0}),c(at)!=="svelte-1rh6uwh"&&(at.textContent=pl),re=a(t),M(pt.$$.fragment,t),ye=a(t),M(ot.$$.fragment,t),Je=a(t),ct=o(t,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-o074ge"&&(ct.textContent=ol),be=a(t),it=o(t,"P",{"data-svelte-h":!0}),c(it)!=="svelte-i9iff9"&&(it.innerHTML=cl),we=a(t),M(Mt.$$.fragment,t),he=a(t),M(dt.$$.fragment,t),Te=a(t),M(mt.$$.fragment,t),je=a(t),ut=o(t,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1plyclu"&&(ut.textContent=il),Ue=a(t),M(rt.$$.fragment,t),fe=a(t),yt=o(t,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-19x0bp9"&&(yt.textContent=Ml),Ze=a(t),M(Jt.$$.fragment,t),Ge=a(t),bt=o(t,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-18h7dlv"&&(bt.textContent=dl),Ie=a(t),wt=o(t,"UL",{"data-svelte-h":!0}),c(wt)!=="svelte-1gtr0du"&&(wt.innerHTML=ml),Be=a(t),ht=o(t,"P",{"data-svelte-h":!0}),c(ht)!=="svelte-hm5lnw"&&(ht.textContent=ul),We=a(t),M(Tt.$$.fragment,t),Ce=a(t),ft=o(t,"P",{}),rl(ft).forEach(l),this.h()},h(){yl(J,"name","hf:doc:metadata"),yl(J,"content",Il)},m(t,e){Ul(document.head,J),s(t,Zt,e),s(t,Ut,e),s(t,Gt,e),d(b,t,e),s(t,It,e),d(w,t,e),s(t,Bt,e),s(t,h,e),s(t,Wt,e),s(t,T,e),s(t,Ct,e),s(t,j,e),s(t,Rt,e),s(t,U,e),s(t,gt,e),s(t,f,e),s(t,vt,e),s(t,Z,e),s(t,Xt,e),d(G,t,e),s(t,kt,e),s(t,I,e),s(t,Vt,e),s(t,B,e),s(t,xt,e),s(t,W,e),s(t,_t,e),d(C,t,e),s(t,$t,e),d(R,t,e),s(t,Yt,e),s(t,g,e),s(t,Ht,e),s(t,v,e),s(t,Nt,e),d(X,t,e),s(t,Qt,e),d(k,t,e),s(t,zt,e),s(t,V,e),s(t,Ft,e),s(t,x,e),s(t,Et,e),s(t,_,e),s(t,At,e),s(t,$,e),s(t,St,e),s(t,Y,e),s(t,Lt,e),s(t,H,e),s(t,qt,e),d(N,t,e),s(t,Pt,e),s(t,Q,e),s(t,Dt,e),s(t,z,e),s(t,Kt,e),s(t,F,e),s(t,Ot,e),s(t,E,e),s(t,te,e),s(t,A,e),s(t,ee,e),s(t,S,e),s(t,le,e),d(L,t,e),s(t,se,e),s(t,q,e),s(t,ne,e),d(P,t,e),s(t,ae,e),s(t,D,e),s(t,pe,e),s(t,K,e),s(t,oe,e),d(O,t,e),s(t,ce,e),s(t,tt,e),s(t,ie,e),d(et,t,e),s(t,Me,e),d(lt,t,e),s(t,de,e),s(t,st,e),s(t,me,e),d(nt,t,e),s(t,ue,e),s(t,at,e),s(t,re,e),d(pt,t,e),s(t,ye,e),d(ot,t,e),s(t,Je,e),s(t,ct,e),s(t,be,e),s(t,it,e),s(t,we,e),d(Mt,t,e),s(t,he,e),d(dt,t,e),s(t,Te,e),d(mt,t,e),s(t,je,e),s(t,ut,e),s(t,Ue,e),d(rt,t,e),s(t,fe,e),s(t,yt,e),s(t,Ze,e),d(Jt,t,e),s(t,Ge,e),s(t,bt,e),s(t,Ie,e),s(t,wt,e),s(t,Be,e),s(t,ht,e),s(t,We,e),d(Tt,t,e),s(t,Ce,e),s(t,ft,e),Re=!0},p:bl,i(t){Re||(m(b.$$.fragment,t),m(w.$$.fragment,t),m(G.$$.fragment,t),m(C.$$.fragment,t),m(R.$$.fragment,t),m(X.$$.fragment,t),m(k.$$.fragment,t),m(N.$$.fragment,t),m(L.$$.fragment,t),m(P.$$.fragment,t),m(O.$$.fragment,t),m(et.$$.fragment,t),m(lt.$$.fragment,t),m(nt.$$.fragment,t),m(pt.$$.fragment,t),m(ot.$$.fragment,t),m(Mt.$$.fragment,t),m(dt.$$.fragment,t),m(mt.$$.fragment,t),m(rt.$$.fragment,t),m(Jt.$$.fragment,t),m(Tt.$$.fragment,t),Re=!0)},o(t){u(b.$$.fragment,t),u(w.$$.fragment,t),u(G.$$.fragment,t),u(C.$$.fragment,t),u(R.$$.fragment,t),u(X.$$.fragment,t),u(k.$$.fragment,t),u(N.$$.fragment,t),u(L.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(lt.$$.fragment,t),u(nt.$$.fragment,t),u(pt.$$.fragment,t),u(ot.$$.fragment,t),u(Mt.$$.fragment,t),u(dt.$$.fragment,t),u(mt.$$.fragment,t),u(rt.$$.fragment,t),u(Jt.$$.fragment,t),u(Tt.$$.fragment,t),Re=!1},d(t){t&&(l(Zt),l(Ut),l(Gt),l(It),l(Bt),l(h),l(Wt),l(T),l(Ct),l(j),l(Rt),l(U),l(gt),l(f),l(vt),l(Z),l(Xt),l(kt),l(I),l(Vt),l(B),l(xt),l(W),l(_t),l($t),l(Yt),l(g),l(Ht),l(v),l(Nt),l(Qt),l(zt),l(V),l(Ft),l(x),l(Et),l(_),l(At),l($),l(St),l(Y),l(Lt),l(H),l(qt),l(Pt),l(Q),l(Dt),l(z),l(Kt),l(F),l(Ot),l(E),l(te),l(A),l(ee),l(S),l(le),l(se),l(q),l(ne),l(ae),l(D),l(pe),l(K),l(oe),l(ce),l(tt),l(ie),l(Me),l(de),l(st),l(me),l(ue),l(at),l(re),l(ye),l(Je),l(ct),l(be),l(it),l(we),l(he),l(Te),l(je),l(ut),l(Ue),l(fe),l(yt),l(Ze),l(Ge),l(bt),l(Ie),l(wt),l(Be),l(ht),l(We),l(Ce),l(ft)),l(J),r(b,t),r(w,t),r(G,t),r(C,t),r(R,t),r(X,t),r(k,t),r(N,t),r(L,t),r(P,t),r(O,t),r(et,t),r(lt,t),r(nt,t),r(pt,t),r(ot,t),r(Mt,t),r(dt,t),r(mt,t),r(rt,t),r(Jt,t),r(Tt,t)}}}const Il='{"title":"使用自定义非结构化数据构建 RAG","local":"使用自定义非结构化数据构建-rag","sections":[{"title":"非结构化数据预处理","local":"非结构化数据预处理","sections":[],"depth":2},{"title":"分块","local":"分块","sections":[],"depth":2},{"title":"设置检索器","local":"设置检索器","sections":[],"depth":2},{"title":"使用 LangChain 构建 RAG","local":"使用-langchain-构建-rag","sections":[],"depth":2},{"title":"结果和下一步","local":"结果和下一步","sections":[],"depth":2}],"depth":1}';function Bl(ge){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vl extends hl{constructor(J){super(),Tl(this,J,Bl,Gl,Jl,{})}}export{vl as component};
