import{s as ws,n as Cs,o as Is}from"../chunks/scheduler.65852ee5.js";import{S as hs,i as bs,g as M,s as n,r as i,A as ds,h as p,f as t,c as a,j as Ts,u as o,x as y,k as ms,y as gs,a as e,v as j,d as U,t as c,w as J}from"../chunks/index.aa74147d.js";import{D as fs,C as u}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as Yl,E as Bs}from"../chunks/index.e2566494.js";function Qs(Fl){let r,nl,tl,al,T,Ml,m,pl,w,zl='<em>作者：<a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',yl,C,Ll="在本教程中，我们将学习如何实现一个利用 SQL 的智能体，使用 <code>transformers.agents</code>。",il,I,Dl="与标准文本到 SQL pipeline 相比，<strong>它有什么优势？</strong>",ol,h,Kl="标准的文本到 SQL pipeline 是脆弱的，因为生成的 SQL 查询可能是错误的。更糟糕的是，查询可能是错误的，但并不会引发错误，而是返回一些错误的/无用的输出，且不会发出警报。",jl,b,Pl="👉 相比之下，<strong>智能体系统能够批判性地检查输出，并决定是否需要更改查询</strong>，从而大大提高其性能。",Ul,d,Ol="让我们开始构建这个智能体吧！💪",cl,g,Jl,f,ul,B,rl,Q,ls="让我们检查系统是否能通过一个基本查询正常工作：",Tl,A,ml,q,ss=`(1, 'Alan Payne', 12.06, 1.2)
(2, 'Alex Mason', 23.86, 0.24)
(3, 'Woodrow Wilson', 53.43, 5.43)
(4, 'Margaret James', 21.11, 1.0)
`,wl,Z,Cl,W,ts="现在，让我们将 SQL 表格使其可由智能体（工具）检索。",Il,R,es="智能体的 <code>description</code> 属性将被嵌入到大语言模型（LLM）的提示中，这样它就能了解如何使用这个工具。在这个步骤中，我们需要描述 SQL 表格的结构，以便让智能体能够正确地执行查询并与数据库交互。",hl,E,bl,S,ns=`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT
`,dl,N,as='现在，让我们构建我们的工具。它需要以下内容：（详细信息请参阅<a href="https://huggingface.co/docs/transformers/en/agents#create-a-new-tool" rel="nofollow">文档</a>）',gl,v,Ms="<li>带有 <code>Args:</code> 部分的文档字符串</li> <li>类型提示</li>",fl,H,Bl,V,ps="现在让我们创建一个利用这个工具的智能体。",Ql,$,ys="我们将使用 <code>ReactCodeAgent</code>，它是 <code>transformers.agents</code> 的主要智能体类：一个根据 ReAct 框架编写代码并能迭代先前输出的智能体。",Al,G,is='<code>llm_engine</code> 是驱动智能体系统的 LLM。<code>HfEngine</code> 允许你通过 HF 的推理 API 调用 LLM，无论是通过无服务器或专用端点，但你也可以使用任何专有的 API：查看<a href="agent_change_llm">这个指南</a>以了解如何进行适配。',ql,k,Zl,_,Wl,X,Rl,x,os="现在让我们增加一点难度！我们希望智能体能够处理跨多个表的连接查询。",El,Y,js="因此，让我们创建一个第二个表，用于记录每个 <code>receipt_id</code> 对应的服务员姓名！",Sl,F,Nl,z,Us="我们需要更新 <code>SQLExecutorTool</code>，将这个表的描述添加进去，以便让 LLM 能够正确地利用这个表中的信息。",vl,L,Hl,D,cs=`Allows you to perform SQL queries on the table. Beware that this tool's output is a string representation of the execution output.
It can use the following tables:

Table 'receipts':
Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT

Table 'waiters':
Columns:
  - receipt_id: INTEGER
  - waiter_name: VARCHAR(16)
`,Vl,K,Js='由于这个请求比之前的更具挑战性，我们将切换 LLM 引擎，使用更强大的 <a href="https://huggingface.co/Qwen/Qwen2.5-72B-Instruct" rel="nofollow">Qwen/Qwen2.5-72B-Instruct</a>！',$l,P,Gl,O,us="它直接就能工作！设置过程出乎意料地简单，不是吗？",kl,ll,rs="✅ 现在你可以去构建你一直梦想的文本到 SQL 系统了！✨",_l,sl,Xl,el,xl;return T=new fs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/agent_text_to_sql.ipynb"}]}}),m=new Yl({props:{title:"用于文本到 SQL 的智能体，带有自动错误修正功能",local:"用于文本到-sql-的智能体带有自动错误修正功能",headingTag:"h1"}}),g=new Yl({props:{title:"设置 SQL 表",local:"设置-sql-表",headingTag:"h2"}}),f=new u({props:{code:"ZnJvbSUyMHNxbGFsY2hlbXklMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwY3JlYXRlX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyME1ldGFEYXRhJTJDJTBBJTIwJTIwJTIwJTIwVGFibGUlMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4lMkMlMEElMjAlMjAlMjAlMjBTdHJpbmclMkMlMEElMjAlMjAlMjAlMjBJbnRlZ2VyJTJDJTBBJTIwJTIwJTIwJTIwRmxvYXQlMkMlMEElMjAlMjAlMjAlMjBpbnNlcnQlMkMlMEElMjAlMjAlMjAlMjBpbnNwZWN0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUyQyUwQSklMEElMEFlbmdpbmUlMjAlM0QlMjBjcmVhdGVfZW5naW5lKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRiUzQW1lbW9yeSUzQSUyMiklMEFtZXRhZGF0YV9vYmolMjAlM0QlMjBNZXRhRGF0YSgpJTBBJTBBJTIzJTIwY3JlYXRlJTIwY2l0eSUyMFNRTCUyMHRhYmxlJTBBdGFibGVfbmFtZSUyMCUzRCUyMCUyMnJlY2VpcHRzJTIyJTBBcmVjZWlwdHMlMjAlM0QlMjBUYWJsZSglMEElMjAlMjAlMjAlMjB0YWJsZV9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGFfb2JqJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnJlY2VpcHRfaWQlMjIlMkMlMjBJbnRlZ2VyJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJjdXN0b21lcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycHJpY2UlMjIlMkMlMjBGbG9hdCklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIydGlwJTIyJTJDJTIwRmxvYXQpJTJDJTBBKSUwQW1ldGFkYXRhX29iai5jcmVhdGVfYWxsKGVuZ2luZSk=",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)`,wrap:!1}}),B=new u({props:{code:"cm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyY3VzdG9tZXJfbmFtZSUyMiUzQSUyMCUyMkFsYW4lMjBQYXluZSUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwMTIuMDYlMkMlMjAlMjJ0aXAlMjIlM0ElMjAxLjIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJjdXN0b21lcl9uYW1lJTIyJTNBJTIwJTIyQWxleCUyME1hc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMy44NiUyQyUyMCUyMnRpcCUyMiUzQSUyMDAuMjQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMyUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJXb29kcm93JTIwV2lsc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA1My40MyUyQyUyMCUyMnRpcCUyMiUzQSUyMDUuNDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMS4xMSUyQyUyMCUyMnRpcCUyMiUzQSUyMDEuMDAlN0QlMkMlMEElNUQlMEFmb3IlMjByb3clMjBpbiUyMHJvd3MlM0ElMEElMjAlMjAlMjAlMjBzdG10JTIwJTNEJTIwaW5zZXJ0KHJlY2VpcHRzKS52YWx1ZXMoKipyb3cpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGVuZ2luZS5iZWdpbigpJTIwYXMlMjBjb25uZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3Vyc29yJTIwJTNEJTIwY29ubmVjdGlvbi5leGVjdXRlKHN0bXQp",highlighted:`rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),A=new u({props:{code:"d2l0aCUyMGVuZ2luZS5jb25uZWN0KCklMjBhcyUyMGNvbiUzQSUwQSUyMCUyMCUyMCUyMHJvd3MlMjAlM0QlMjBjb24uZXhlY3V0ZSh0ZXh0KCUyMiUyMiUyMlNFTEVDVCUyMColMjBmcm9tJTIwcmVjZWlwdHMlMjIlMjIlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KHJvdyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
<span class="hljs-meta">... </span>    rows = con.execute(text(<span class="hljs-string">&quot;&quot;&quot;SELECT * from receipts&quot;&quot;&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(row)`,wrap:!1}}),Z=new Yl({props:{title:"构建我们的智能体",local:"构建我们的智能体",headingTag:"h2"}}),E=new u({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span>columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

<span class="hljs-meta">&gt;&gt;&gt; </span>table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),H=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> tool


<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),k=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmQXBpRW5naW5lJTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBsbG1fZW5naW5lJTNESGZBcGlFbmdpbmUoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiklMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> ReactCodeAgent, HfApiEngine

agent = ReactCodeAgent(
    tools=[sql_engine],
    llm_engine=HfApiEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>),
)`,wrap:!1}}),_=new u({props:{code:"YWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)',wrap:!1}}),X=new Yl({props:{title:"提高难度：表格连接",local:"提高难度表格连接",headingTag:"h2"}}),F=new u({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),L=new u({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
<span class="hljs-meta">... </span>It can use the following tables:&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
<span class="hljs-meta">... </span>    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

<span class="hljs-meta">... </span>    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

<span class="hljs-meta">... </span>    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-meta">... </span>    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),P=new u({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMFJlYWN0Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbV9lbmdpbmUlM0RIZkFwaUVuZ2luZSglMjJRd2VuJTJGUXdlbjIuNS03MkItSW5zdHJ1Y3QlMjIpJTJDJTBBKSUwQSUwQWFnZW50LnJ1biglMjJXaGljaCUyMHdhaXRlciUyMGdvdCUyMG1vcmUlMjB0b3RhbCUyMG1vbmV5JTIwZnJvbSUyMHRpcHMlM0YlMjIp",highlighted:`sql_engine.description = updated_description

agent = ReactCodeAgent(
    tools=[sql_engine],
    llm_engine=HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),sl=new Bs({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/agent_text_to_sql.md"}}),{c(){r=M("meta"),nl=n(),tl=M("p"),al=n(),i(T.$$.fragment),Ml=n(),i(m.$$.fragment),pl=n(),w=M("p"),w.innerHTML=zl,yl=n(),C=M("p"),C.innerHTML=Ll,il=n(),I=M("p"),I.innerHTML=Dl,ol=n(),h=M("p"),h.textContent=Kl,jl=n(),b=M("p"),b.innerHTML=Pl,Ul=n(),d=M("p"),d.textContent=Ol,cl=n(),i(g.$$.fragment),Jl=n(),i(f.$$.fragment),ul=n(),i(B.$$.fragment),rl=n(),Q=M("p"),Q.textContent=ls,Tl=n(),i(A.$$.fragment),ml=n(),q=M("pre"),q.textContent=ss,wl=n(),i(Z.$$.fragment),Cl=n(),W=M("p"),W.textContent=ts,Il=n(),R=M("p"),R.innerHTML=es,hl=n(),i(E.$$.fragment),bl=n(),S=M("pre"),S.textContent=ns,dl=n(),N=M("p"),N.innerHTML=as,gl=n(),v=M("ul"),v.innerHTML=Ms,fl=n(),i(H.$$.fragment),Bl=n(),V=M("p"),V.textContent=ps,Ql=n(),$=M("p"),$.innerHTML=ys,Al=n(),G=M("p"),G.innerHTML=is,ql=n(),i(k.$$.fragment),Zl=n(),i(_.$$.fragment),Wl=n(),i(X.$$.fragment),Rl=n(),x=M("p"),x.textContent=os,El=n(),Y=M("p"),Y.innerHTML=js,Sl=n(),i(F.$$.fragment),Nl=n(),z=M("p"),z.innerHTML=Us,vl=n(),i(L.$$.fragment),Hl=n(),D=M("pre"),D.textContent=cs,Vl=n(),K=M("p"),K.innerHTML=Js,$l=n(),i(P.$$.fragment),Gl=n(),O=M("p"),O.textContent=us,kl=n(),ll=M("p"),ll.textContent=rs,_l=n(),i(sl.$$.fragment),Xl=n(),el=M("p"),this.h()},l(l){const s=ds("svelte-u9bgzb",document.head);r=p(s,"META",{name:!0,content:!0}),s.forEach(t),nl=a(l),tl=p(l,"P",{}),Ts(tl).forEach(t),al=a(l),o(T.$$.fragment,l),Ml=a(l),o(m.$$.fragment,l),pl=a(l),w=p(l,"P",{"data-svelte-h":!0}),y(w)!=="svelte-w1hogd"&&(w.innerHTML=zl),yl=a(l),C=p(l,"P",{"data-svelte-h":!0}),y(C)!=="svelte-1kzip2m"&&(C.innerHTML=Ll),il=a(l),I=p(l,"P",{"data-svelte-h":!0}),y(I)!=="svelte-s9giff"&&(I.innerHTML=Dl),ol=a(l),h=p(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-1yq44h6"&&(h.textContent=Kl),jl=a(l),b=p(l,"P",{"data-svelte-h":!0}),y(b)!=="svelte-10z3rx4"&&(b.innerHTML=Pl),Ul=a(l),d=p(l,"P",{"data-svelte-h":!0}),y(d)!=="svelte-ox2w5p"&&(d.textContent=Ol),cl=a(l),o(g.$$.fragment,l),Jl=a(l),o(f.$$.fragment,l),ul=a(l),o(B.$$.fragment,l),rl=a(l),Q=p(l,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-vrancr"&&(Q.textContent=ls),Tl=a(l),o(A.$$.fragment,l),ml=a(l),q=p(l,"PRE",{"data-svelte-h":!0}),y(q)!=="svelte-jbb28p"&&(q.textContent=ss),wl=a(l),o(Z.$$.fragment,l),Cl=a(l),W=p(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-1iymuye"&&(W.textContent=ts),Il=a(l),R=p(l,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1vaxqe4"&&(R.innerHTML=es),hl=a(l),o(E.$$.fragment,l),bl=a(l),S=p(l,"PRE",{"data-svelte-h":!0}),y(S)!=="svelte-1pz02dc"&&(S.textContent=ns),dl=a(l),N=p(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-7y2etl"&&(N.innerHTML=as),gl=a(l),v=p(l,"UL",{"data-svelte-h":!0}),y(v)!=="svelte-ciujzo"&&(v.innerHTML=Ms),fl=a(l),o(H.$$.fragment,l),Bl=a(l),V=p(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-fykgvz"&&(V.textContent=ps),Ql=a(l),$=p(l,"P",{"data-svelte-h":!0}),y($)!=="svelte-suwmw6"&&($.innerHTML=ys),Al=a(l),G=p(l,"P",{"data-svelte-h":!0}),y(G)!=="svelte-fo5zjp"&&(G.innerHTML=is),ql=a(l),o(k.$$.fragment,l),Zl=a(l),o(_.$$.fragment,l),Wl=a(l),o(X.$$.fragment,l),Rl=a(l),x=p(l,"P",{"data-svelte-h":!0}),y(x)!=="svelte-15yz8gi"&&(x.textContent=os),El=a(l),Y=p(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-1l1nhz2"&&(Y.innerHTML=js),Sl=a(l),o(F.$$.fragment,l),Nl=a(l),z=p(l,"P",{"data-svelte-h":!0}),y(z)!=="svelte-xsp927"&&(z.innerHTML=Us),vl=a(l),o(L.$$.fragment,l),Hl=a(l),D=p(l,"PRE",{"data-svelte-h":!0}),y(D)!=="svelte-d75mf2"&&(D.textContent=cs),Vl=a(l),K=p(l,"P",{"data-svelte-h":!0}),y(K)!=="svelte-1npnq3m"&&(K.innerHTML=Js),$l=a(l),o(P.$$.fragment,l),Gl=a(l),O=p(l,"P",{"data-svelte-h":!0}),y(O)!=="svelte-4etgcn"&&(O.textContent=us),kl=a(l),ll=p(l,"P",{"data-svelte-h":!0}),y(ll)!=="svelte-7shr5l"&&(ll.textContent=rs),_l=a(l),o(sl.$$.fragment,l),Xl=a(l),el=p(l,"P",{}),Ts(el).forEach(t),this.h()},h(){ms(r,"name","hf:doc:metadata"),ms(r,"content",As)},m(l,s){gs(document.head,r),e(l,nl,s),e(l,tl,s),e(l,al,s),j(T,l,s),e(l,Ml,s),j(m,l,s),e(l,pl,s),e(l,w,s),e(l,yl,s),e(l,C,s),e(l,il,s),e(l,I,s),e(l,ol,s),e(l,h,s),e(l,jl,s),e(l,b,s),e(l,Ul,s),e(l,d,s),e(l,cl,s),j(g,l,s),e(l,Jl,s),j(f,l,s),e(l,ul,s),j(B,l,s),e(l,rl,s),e(l,Q,s),e(l,Tl,s),j(A,l,s),e(l,ml,s),e(l,q,s),e(l,wl,s),j(Z,l,s),e(l,Cl,s),e(l,W,s),e(l,Il,s),e(l,R,s),e(l,hl,s),j(E,l,s),e(l,bl,s),e(l,S,s),e(l,dl,s),e(l,N,s),e(l,gl,s),e(l,v,s),e(l,fl,s),j(H,l,s),e(l,Bl,s),e(l,V,s),e(l,Ql,s),e(l,$,s),e(l,Al,s),e(l,G,s),e(l,ql,s),j(k,l,s),e(l,Zl,s),j(_,l,s),e(l,Wl,s),j(X,l,s),e(l,Rl,s),e(l,x,s),e(l,El,s),e(l,Y,s),e(l,Sl,s),j(F,l,s),e(l,Nl,s),e(l,z,s),e(l,vl,s),j(L,l,s),e(l,Hl,s),e(l,D,s),e(l,Vl,s),e(l,K,s),e(l,$l,s),j(P,l,s),e(l,Gl,s),e(l,O,s),e(l,kl,s),e(l,ll,s),e(l,_l,s),j(sl,l,s),e(l,Xl,s),e(l,el,s),xl=!0},p:Cs,i(l){xl||(U(T.$$.fragment,l),U(m.$$.fragment,l),U(g.$$.fragment,l),U(f.$$.fragment,l),U(B.$$.fragment,l),U(A.$$.fragment,l),U(Z.$$.fragment,l),U(E.$$.fragment,l),U(H.$$.fragment,l),U(k.$$.fragment,l),U(_.$$.fragment,l),U(X.$$.fragment,l),U(F.$$.fragment,l),U(L.$$.fragment,l),U(P.$$.fragment,l),U(sl.$$.fragment,l),xl=!0)},o(l){c(T.$$.fragment,l),c(m.$$.fragment,l),c(g.$$.fragment,l),c(f.$$.fragment,l),c(B.$$.fragment,l),c(A.$$.fragment,l),c(Z.$$.fragment,l),c(E.$$.fragment,l),c(H.$$.fragment,l),c(k.$$.fragment,l),c(_.$$.fragment,l),c(X.$$.fragment,l),c(F.$$.fragment,l),c(L.$$.fragment,l),c(P.$$.fragment,l),c(sl.$$.fragment,l),xl=!1},d(l){l&&(t(nl),t(tl),t(al),t(Ml),t(pl),t(w),t(yl),t(C),t(il),t(I),t(ol),t(h),t(jl),t(b),t(Ul),t(d),t(cl),t(Jl),t(ul),t(rl),t(Q),t(Tl),t(ml),t(q),t(wl),t(Cl),t(W),t(Il),t(R),t(hl),t(bl),t(S),t(dl),t(N),t(gl),t(v),t(fl),t(Bl),t(V),t(Ql),t($),t(Al),t(G),t(ql),t(Zl),t(Wl),t(Rl),t(x),t(El),t(Y),t(Sl),t(Nl),t(z),t(vl),t(Hl),t(D),t(Vl),t(K),t($l),t(Gl),t(O),t(kl),t(ll),t(_l),t(Xl),t(el)),t(r),J(T,l),J(m,l),J(g,l),J(f,l),J(B,l),J(A,l),J(Z,l),J(E,l),J(H,l),J(k,l),J(_,l),J(X,l),J(F,l),J(L,l),J(P,l),J(sl,l)}}}const As='{"title":"用于文本到 SQL 的智能体，带有自动错误修正功能","local":"用于文本到-sql-的智能体带有自动错误修正功能","sections":[{"title":"设置 SQL 表","local":"设置-sql-表","sections":[],"depth":2},{"title":"构建我们的智能体","local":"构建我们的智能体","sections":[],"depth":2},{"title":"提高难度：表格连接","local":"提高难度表格连接","sections":[],"depth":2}],"depth":1}';function qs(Fl){return Is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends hs{constructor(r){super(),bs(this,r,qs,Qs,ws,{})}}export{Ss as component};
