import{s as ct,n as ut,o as dt}from"../chunks/scheduler.9bc65507.js";import{S as ft,i as ht,g as o,s,r as p,A as wt,h as i,f as n,c as a,j as pt,u as m,x as r,k as mt,y as yt,a as l,v as c,d as u,t as d,w as f}from"../chunks/index.707bf1b6.js";import{C as w}from"../chunks/CodeBlock.54a9f38d.js";import{D as Tt}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as te}from"../chunks/Heading.342b1fa6.js";function Mt(Le){let h,ne,O,le,y,se,T,ae,M,Ee='Accelerated Linear Algebra, dubbed XLA, is a compiler for accelerating the runtime of TensorFlow Models. From the <a href="https://www.tensorflow.org/xla" rel="nofollow">official documentation</a>:',oe,b,Ye="XLA (Accelerated Linear Algebra) is a domain-specific compiler for linear algebra that can accelerate TensorFlow models with potentially no source code changes.",ie,g,He='Using XLA in TensorFlow is simple – it comes packaged inside the <code>tensorflow</code> library, and it can be triggered with the <code>jit_compile</code> argument in any graph-creating function such as <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>. When using Keras methods like <code>fit()</code> and <code>predict()</code>, you can enable XLA simply by passing the <code>jit_compile</code> argument to <code>model.compile()</code>. However, XLA is not limited to these methods - it can also be used to accelerate any arbitrary <code>tf.function</code>.',re,J,Ne='Several TensorFlow methods in 🤗 Transformers have been rewritten to be XLA-compatible, including text generation for models such as <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>, <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a> and <a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>, as well as speech processing for models such as <a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.',pe,U,Ae="While the exact amount of speed-up is very much model-dependent, for TensorFlow text generation models inside 🤗 Transformers, we noticed a speed-up of ~100x. This document will explain how you can use XLA for these models to get the maximum amount of performance. We’ll also provide links to additional resources if you’re interested to learn more about the benchmarks and our design philosophy behind the XLA integration.",me,j,ce,k,Qe="Let us consider the following model in TensorFlow:",ue,Z,de,_,qe="The above model accepts inputs having a dimension of <code>(10, )</code>. We can use the model for running a forward pass like so:",fe,X,he,G,Se="In order to run the forward pass with an XLA-compiled function, we’d need to do:",we,R,ye,v,Pe="The default <code>call()</code> function of the <code>model</code> is used for compiling the XLA graph. But if there’s any other model function you want to compile into XLA that’s also possible with:",Te,W,Me,I,be,x,De="To enable XLA-accelerated generation within 🤗 Transformers, you need to have a recent version of <code>transformers</code> installed. You can install it by running:",ge,V,Je,F,Ke="And then you can run the following code:",Ue,$,je,C,Oe="As you can notice, enabling XLA on <code>generate()</code> is just a single line of code. The rest of the code remains unchanged. However, there are a couple of gotchas in the above code snippet that are specific to XLA. You need to be aware of those to realize the speed-ups that XLA can bring in. We discuss these in the following section.",ke,B,Ze,z,et='When you are executing an XLA-enabled function (like <code>xla_generate()</code> above) for the first time, it will internally try to infer the computation graph, which is time-consuming.  This process is known as <a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“tracing”</a>.',_e,L,tt="You might notice that the generation time is not fast. Successive calls of <code>xla_generate()</code> (or any other XLA-enabled function) won’t have to infer the computation graph, given the inputs to the function follow the same shape with which the computation graph was initially built. While this is not a problem for modalities with fixed input shapes (e.g., images), you must pay attention if you are working with variable input shape modalities (e.g., text).",Xe,E,nt="To ensure <code>xla_generate()</code> always operates with the same input shapes, you can specify the <code>padding</code> arguments when calling the tokenizer.",Ge,Y,Re,H,lt="This way, you can ensure that the inputs to <code>xla_generate()</code> will always receive inputs with the shape it was traced with and thus leading to speed-ups in the generation time. You can verify this with the code below:",ve,N,We,A,st="On a Tesla T4 GPU, you can expect the outputs like so:",Ie,Q,xe,q,at="The first call to <code>xla_generate()</code> is time-consuming because of tracing, but the successive calls are orders of magnitude faster. Keep in mind that any change in the generation options at any point with trigger re-tracing and thus leading to slow-downs in the generation time.",Ve,S,ot="We didn’t cover all the text generation options 🤗 Transformers provides in this document. We encourage you to read the documentation for advanced use cases.",Fe,P,$e,D,it="Here, we leave you with some additional resources if you want to delve deeper into XLA in 🤗 Transformers and in general.",Ce,K,rt='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">This Colab Notebook</a> provides an interactive demonstration if you want to fiddle with the XLA-compatible encoder-decoder (like <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>) and decoder-only (like <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>) text generation models.</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">This blog post</a> provides an overview of the comparison benchmarks for XLA-compatible models along with a friendly introduction to XLA in TensorFlow.</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">This blog post</a> discusses our design philosophy behind adding XLA support to the TensorFlow models in 🤗 Transformers.</li> <li>Recommended posts for learning more about XLA and TensorFlow graphs in general:<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: Optimizing Compiler for Machine Learning</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">Introduction to graphs and tf.function</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">Better performance with tf.function</a></li></ul></li>',Be,ee,ze;return y=new te({props:{title:"XLA Integration for TensorFlow Models",local:"xla-integration-for-tensorflow-models",headingTag:"h1"}}),T=new Tt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"}]}}),j=new te({props:{title:"Running TF functions with XLA",local:"running-tf-functions-with-xla",headingTag:"h2"}}),Z=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),X=new w({props:{code:"JTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEFfJTIwJTNEJTIwbW9kZWwocmFuZG9tX2lucHV0cyk=",highlighted:`<span class="hljs-comment"># Generate random inputs for the model.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># Run a forward pass.</span>
_ = model(random_inputs)`,wrap:!1}}),R=new w({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),W=new w({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),I=new te({props:{title:"Running a TF text generation model with XLA from 🤗 Transformers",local:"running-a-tf-text-generation-model-with-xla-from--transformers",headingTag:"h2"}}),V=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),$=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQSUyMyUyME9uZSUyMGxpbmUlMjB0byUyMGNyZWF0ZSUyMGFuJTIwWExBJTIwZ2VuZXJhdGlvbiUyMGZ1bmN0aW9uJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMiklMEElMjMlMjBHZW5lcmF0ZWQlMjAtLSUyMFRlbnNvckZsb3clMjBpcyUyMGFuJTIwb3Blbi1zb3VyY2UlMkMlMjBvcGVuLXNvdXJjZSUyQyUyMGRpc3RyaWJ1dGVkLXNvdXJjZSUyMGFwcGxpY2F0aW9uJTIwJTIzJTIwZnJhbWV3b3JrJTIwZm9yJTIwdGhl",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># One line to create an XLA generation function</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),B=new te({props:{title:"Gotchas to be aware of",local:"gotchas-to-be-aware-of",headingTag:"h2"}}),Y=new w({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBJTIzJTIwSGVyZSUyQyUyMHdlJTIwY2FsbCUyMHRoZSUyMHRva2VuaXplciUyMHdpdGglMjBwYWRkaW5nJTIwb3B0aW9ucy4lMEF0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEFkZWNvZGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZiUyMkdlbmVyYXRlZCUyMC0tJTIwJTdCZGVjb2RlZF90ZXh0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Here, we call the tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),N=new w({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQWZvciUyMGlucHV0X3N0cmluZyUyMGluJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTJDJTIwJTIyVGVuc29yRmxvdyUyMGlzJTIwYSUyMiUyQyUyMCUyMlRGTGl0ZSUyMGlzJTIwYSUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjBwYWRfdG9fbXVsdGlwbGVfb2YlM0Q4JTJDJTIwcGFkZGluZyUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQSUyMCUyMCUyMCUyMHN0YXJ0JTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEElMjAlMjAlMjAlMjBlbmQlMjAlM0QlMjB0aW1lLnRpbWVfbnMoKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJFeGVjdXRpb24lMjB0aW1lJTIwLS0lMjAlN0IoZW5kJTIwLSUyMHN0YXJ0KSUyMCUyRiUyMDFlNiUzQS4xZiU3RCUyMG1zJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),Q=new w({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),P=new te({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),{c(){h=o("meta"),ne=s(),O=o("p"),le=s(),p(y.$$.fragment),se=s(),p(T.$$.fragment),ae=s(),M=o("p"),M.innerHTML=Ee,oe=s(),b=o("p"),b.textContent=Ye,ie=s(),g=o("p"),g.innerHTML=He,re=s(),J=o("p"),J.innerHTML=Ne,pe=s(),U=o("p"),U.textContent=Ae,me=s(),p(j.$$.fragment),ce=s(),k=o("p"),k.textContent=Qe,ue=s(),p(Z.$$.fragment),de=s(),_=o("p"),_.innerHTML=qe,fe=s(),p(X.$$.fragment),he=s(),G=o("p"),G.textContent=Se,we=s(),p(R.$$.fragment),ye=s(),v=o("p"),v.innerHTML=Pe,Te=s(),p(W.$$.fragment),Me=s(),p(I.$$.fragment),be=s(),x=o("p"),x.innerHTML=De,ge=s(),p(V.$$.fragment),Je=s(),F=o("p"),F.textContent=Ke,Ue=s(),p($.$$.fragment),je=s(),C=o("p"),C.innerHTML=Oe,ke=s(),p(B.$$.fragment),Ze=s(),z=o("p"),z.innerHTML=et,_e=s(),L=o("p"),L.innerHTML=tt,Xe=s(),E=o("p"),E.innerHTML=nt,Ge=s(),p(Y.$$.fragment),Re=s(),H=o("p"),H.innerHTML=lt,ve=s(),p(N.$$.fragment),We=s(),A=o("p"),A.textContent=st,Ie=s(),p(Q.$$.fragment),xe=s(),q=o("p"),q.innerHTML=at,Ve=s(),S=o("p"),S.textContent=ot,Fe=s(),p(P.$$.fragment),$e=s(),D=o("p"),D.textContent=it,Ce=s(),K=o("ul"),K.innerHTML=rt,Be=s(),ee=o("p"),this.h()},l(e){const t=wt("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(n),ne=a(e),O=i(e,"P",{}),pt(O).forEach(n),le=a(e),m(y.$$.fragment,e),se=a(e),m(T.$$.fragment,e),ae=a(e),M=i(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-afit4t"&&(M.innerHTML=Ee),oe=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1rjg69l"&&(b.textContent=Ye),ie=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-8rwpb7"&&(g.innerHTML=He),re=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1sup5o3"&&(J.innerHTML=Ne),pe=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-v22hyz"&&(U.textContent=Ae),me=a(e),m(j.$$.fragment,e),ce=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1n8d5xl"&&(k.textContent=Qe),ue=a(e),m(Z.$$.fragment,e),de=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-137qaqi"&&(_.innerHTML=qe),fe=a(e),m(X.$$.fragment,e),he=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1xkaplb"&&(G.textContent=Se),we=a(e),m(R.$$.fragment,e),ye=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3tnenm"&&(v.innerHTML=Pe),Te=a(e),m(W.$$.fragment,e),Me=a(e),m(I.$$.fragment,e),be=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1tqra4o"&&(x.innerHTML=De),ge=a(e),m(V.$$.fragment,e),Je=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-5mrt6v"&&(F.textContent=Ke),Ue=a(e),m($.$$.fragment,e),je=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-xz55ih"&&(C.innerHTML=Oe),ke=a(e),m(B.$$.fragment,e),Ze=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1tw7ufk"&&(z.innerHTML=et),_e=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1v603pg"&&(L.innerHTML=tt),Xe=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1s9agvy"&&(E.innerHTML=nt),Ge=a(e),m(Y.$$.fragment,e),Re=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1nbul0x"&&(H.innerHTML=lt),ve=a(e),m(N.$$.fragment,e),We=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-zm3wt3"&&(A.textContent=st),Ie=a(e),m(Q.$$.fragment,e),xe=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-18ijq7m"&&(q.innerHTML=at),Ve=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-149gqik"&&(S.textContent=ot),Fe=a(e),m(P.$$.fragment,e),$e=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-k2oxa5"&&(D.textContent=it),Ce=a(e),K=i(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-19xtsh9"&&(K.innerHTML=rt),Be=a(e),ee=i(e,"P",{}),pt(ee).forEach(n),this.h()},h(){mt(h,"name","hf:doc:metadata"),mt(h,"content",bt)},m(e,t){yt(document.head,h),l(e,ne,t),l(e,O,t),l(e,le,t),c(y,e,t),l(e,se,t),c(T,e,t),l(e,ae,t),l(e,M,t),l(e,oe,t),l(e,b,t),l(e,ie,t),l(e,g,t),l(e,re,t),l(e,J,t),l(e,pe,t),l(e,U,t),l(e,me,t),c(j,e,t),l(e,ce,t),l(e,k,t),l(e,ue,t),c(Z,e,t),l(e,de,t),l(e,_,t),l(e,fe,t),c(X,e,t),l(e,he,t),l(e,G,t),l(e,we,t),c(R,e,t),l(e,ye,t),l(e,v,t),l(e,Te,t),c(W,e,t),l(e,Me,t),c(I,e,t),l(e,be,t),l(e,x,t),l(e,ge,t),c(V,e,t),l(e,Je,t),l(e,F,t),l(e,Ue,t),c($,e,t),l(e,je,t),l(e,C,t),l(e,ke,t),c(B,e,t),l(e,Ze,t),l(e,z,t),l(e,_e,t),l(e,L,t),l(e,Xe,t),l(e,E,t),l(e,Ge,t),c(Y,e,t),l(e,Re,t),l(e,H,t),l(e,ve,t),c(N,e,t),l(e,We,t),l(e,A,t),l(e,Ie,t),c(Q,e,t),l(e,xe,t),l(e,q,t),l(e,Ve,t),l(e,S,t),l(e,Fe,t),c(P,e,t),l(e,$e,t),l(e,D,t),l(e,Ce,t),l(e,K,t),l(e,Be,t),l(e,ee,t),ze=!0},p:ut,i(e){ze||(u(y.$$.fragment,e),u(T.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(X.$$.fragment,e),u(R.$$.fragment,e),u(W.$$.fragment,e),u(I.$$.fragment,e),u(V.$$.fragment,e),u($.$$.fragment,e),u(B.$$.fragment,e),u(Y.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),ze=!0)},o(e){d(y.$$.fragment,e),d(T.$$.fragment,e),d(j.$$.fragment,e),d(Z.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(W.$$.fragment,e),d(I.$$.fragment,e),d(V.$$.fragment,e),d($.$$.fragment,e),d(B.$$.fragment,e),d(Y.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),ze=!1},d(e){e&&(n(ne),n(O),n(le),n(se),n(ae),n(M),n(oe),n(b),n(ie),n(g),n(re),n(J),n(pe),n(U),n(me),n(ce),n(k),n(ue),n(de),n(_),n(fe),n(he),n(G),n(we),n(ye),n(v),n(Te),n(Me),n(be),n(x),n(ge),n(Je),n(F),n(Ue),n(je),n(C),n(ke),n(Ze),n(z),n(_e),n(L),n(Xe),n(E),n(Ge),n(Re),n(H),n(ve),n(We),n(A),n(Ie),n(xe),n(q),n(Ve),n(S),n(Fe),n($e),n(D),n(Ce),n(K),n(Be),n(ee)),n(h),f(y,e),f(T,e),f(j,e),f(Z,e),f(X,e),f(R,e),f(W,e),f(I,e),f(V,e),f($,e),f(B,e),f(Y,e),f(N,e),f(Q,e),f(P,e)}}}const bt='{"title":"XLA Integration for TensorFlow Models","local":"xla-integration-for-tensorflow-models","sections":[{"title":"Running TF functions with XLA","local":"running-tf-functions-with-xla","sections":[],"depth":2},{"title":"Running a TF text generation model with XLA from 🤗 Transformers","local":"running-a-tf-text-generation-model-with-xla-from--transformers","sections":[],"depth":2},{"title":"Gotchas to be aware of","local":"gotchas-to-be-aware-of","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function gt(Le){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends ft{constructor(h){super(),ht(this,h,gt,Mt,ct,{})}}export{_t as component};
