import{s as It,n as vt,o as Bt}from"../chunks/scheduler.39a43cde.js";import{S as Gt,i as Rt,g as o,s as n,r as M,A as Wt,h as i,f as s,c as a,j as Ct,u as p,x as r,k as Zt,y as kt,a as l,v as c,d as y,t as m,w as u}from"../chunks/index.23ec2204.js";import{D as $t,C as d}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as ae,E as Xt}from"../chunks/EditOnGithub.f2d09226.js";function _t(Oe){let h,re,oe,Me,j,pe,w,ce,U,et='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',ye,b,tt='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow"><strong>Transformers Agents</strong></a> to build awesome <strong>agents</strong>!',me,J,st="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",ue,g,lt='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',he,f,nt='What is <strong>Transformers Agents</strong>? it’s an extension of our <code>transformers</code> library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>.',de,T,at="Let’s see how to use it, and which use cases it can solve.",je,C,ot="We install transformers agents from source since it has not been released as of writing, but later this week when it gets release you can simply install it with <code>pip install transformers[agents]</code>.",we,Z,Ue,I,be,v,Je,B,it="For this use case, we want to show an agent that browses the web and is able to generate image.",ge,G,rt="To build it, we simply need to have two tools ready: image generation and web search.",fe,R,Mt="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we load a LangChain tool.</li>",Te,W,Ce,k,pt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',Ze,$,Ie,X,ct="Quick definition: Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",ve,_,yt="Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong>",Be,S,mt="🔧 Well, we can solve this by in a simple way: we will <strong>give our agent control over these parameters!</strong>",Ge,V,ut="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",Re,N,We,Q,ht="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",ke,x,$e,H,dt="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",Xe,A,jt="We want our system to select only from the most relevant sources of information, depending on the query.",_e,q,wt="Our documentation pages come from the following sources:",Se,Y,Ve,E,Ne,z,Qe,L,Ut="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",xe,F,bt="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",He,P,Ae,K,qe,D,Ye,O,Jt=`Final output:
https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/text_to_image_lora.py
`,Ee,ee,ze,te,gt="These two use cases should give you a glimpse into the possibilities of our Agents framework!",Le,se,ft='For more advanced usage, read the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>, and <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">this experiment</a> that allowed us to build our own agent based on Llama-3-70B that beats many GPT-4 agents on the very difficult <a href="https://huggingface.co/spaces/gaia-benchmark/leaderboard" rel="nofollow">GAIA Leaderboard</a>!',Fe,le,Tt="All feedback is welcome, it will help us improve the framework together! 🚀",Pe,ne,Ke,ie,De;return j=new $t({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agents.ipynb"}]}}),w=new ae({props:{title:"Build an agent with tool-calling superpowers 🦸 using Transformers Agents",local:"build-an-agent-with-tool-calling-superpowers--using-transformers-agents",headingTag:"h1"}}),Z=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJnaXQlMkJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQlMjNlZ2clM0R0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjI=",highlighted:'!pip install <span class="hljs-string">&quot;git+https://github.com/huggingface/transformers.git#egg=transformers[agents]&quot;</span>',wrap:!1}}),I=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjBodWdnaW5nZmFjZV9odWIlMjBsYW5nY2hhaW4lMjBzZW50ZW5jZS10cmFuc2Zvcm1lcnMlMjBmYWlzcy1jcHUlMjBzZXJwYXBpJTIwZ29vZ2xlLXNlYXJjaC1yZXN1bHRzJTIwLXE=",highlighted:"!pip install huggingface_hub langchain sentence-transformers faiss-cpu serpapi google-search-results -q",wrap:!1}}),v=new ae({props:{title:"🏞️ Multimodal + 🌐 Web-browsing assistant",local:"-multimodal---web-browsing-assistant",headingTag:"h2"}}),W=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBsb2FkX3Rvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmRW5naW5lJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwTGFuZ0NoYWluJTBBZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZSglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwYWdlbnQlMjB3aXRoJTIwYm90aCUyMHRvb2xzJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBJTIzJTIwUnVuJTIwaXQhJTBBYWdlbnQucnVuKCUyMkdlbmVyYXRlJTIwbWUlMjBhJTIwcGhvdG8lMjBvZiUyMHRoZSUyMGNhciUyMHRoYXQlMjBKYW1lcyUyMGJvbmQlMjBkcm92ZSUyMGluJTIwdGhlJTIwbGF0ZXN0JTIwbW92aWUuJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, ReactCodeAgent, HfEngine

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

<span class="hljs-comment"># Import tool from LangChain</span>
<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])

llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-comment"># Initialize the agent with both tools</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Run it!</span>
agent.run(<span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>)`,wrap:!1}}),$=new ae({props:{title:"📚💬 Retrieval-Augmented Generation with source selection",local:"-retrieval-augmented-generation-with-source-selection",headingTag:"h2"}}),N=new d({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),x=new d({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),Y=new d({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFhbGxfc291cmNlcw==",highlighted:`all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
all_sources`,wrap:!1}}),E=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][
            <span class="hljs-string">&quot;description&quot;</span>
        ] = <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(query, <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>), k=<span class="hljs-number">3</span>)

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),z=new ae({props:{title:"Optional Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),P=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTBBbG9naW4oJTIyeW91cl90b2tlbiUyMiklMEElMEFmcm9tJTIwcmV0cmlldmVyJTIwaW1wb3J0JTIwUmV0cmlldmVyVG9vbCUwQSUwQXRvb2wlMjAlM0QlMjBSZXRyaWV2ZXJUb29sKHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMpJTBBJTBBdG9vbC5wdXNoX3RvX2h1YihyZXBvX2lkJTNEJTIybS1yaWMlMkZsYW5nY2hhaW4tcmV0cmlldmVyLXRvb2wlMjIp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login

login(<span class="hljs-string">&quot;your_token&quot;</span>)

<span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

tool = RetrieverTool(vectordb, all_sources)

tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/langchain-retriever-tool&quot;</span>)`,wrap:!1}}),K=new ae({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),D=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmRW5naW5lKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUwQSUwQWFnZW50JTIwJTNEJTIwUmVhY3RKc29uQWdlbnQodG9vbHMlM0QlNUJSZXRyaWV2ZXJUb29sKHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMpJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBYWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMHNob3clMjBtZSUyMGElMjBMT1JBJTIwZmluZXR1bmluZyUyMHNjcmlwdCUyMiklMEElMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactJsonAgent

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactJsonAgent(tools=[RetrieverTool(vectordb, all_sources)], llm_engine=llm_engine)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),ee=new ae({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),ne=new Xt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){h=o("meta"),re=n(),oe=o("p"),Me=n(),M(j.$$.fragment),pe=n(),M(w.$$.fragment),ce=n(),U=o("p"),U.innerHTML=et,ye=n(),b=o("p"),b.innerHTML=tt,me=n(),J=o("p"),J.innerHTML=st,ue=n(),g=o("p"),g.innerHTML=lt,he=n(),f=o("p"),f.innerHTML=nt,de=n(),T=o("p"),T.textContent=at,je=n(),C=o("p"),C.innerHTML=ot,we=n(),M(Z.$$.fragment),Ue=n(),M(I.$$.fragment),be=n(),M(v.$$.fragment),Je=n(),B=o("p"),B.textContent=it,ge=n(),G=o("p"),G.textContent=rt,fe=n(),R=o("ul"),R.innerHTML=Mt,Te=n(),M(W.$$.fragment),Ce=n(),k=o("p"),k.innerHTML=pt,Ze=n(),M($.$$.fragment),Ie=n(),X=o("p"),X.textContent=ct,ve=n(),_=o("p"),_.innerHTML=yt,Be=n(),S=o("p"),S.innerHTML=mt,Ge=n(),V=o("p"),V.innerHTML=ut,Re=n(),M(N.$$.fragment),We=n(),Q=o("p"),Q.textContent=ht,ke=n(),M(x.$$.fragment),$e=n(),H=o("p"),H.textContent=dt,Xe=n(),A=o("p"),A.textContent=jt,_e=n(),q=o("p"),q.textContent=wt,Se=n(),M(Y.$$.fragment),Ve=n(),M(E.$$.fragment),Ne=n(),M(z.$$.fragment),Qe=n(),L=o("p"),L.innerHTML=Ut,xe=n(),F=o("p"),F.innerHTML=bt,He=n(),M(P.$$.fragment),Ae=n(),M(K.$$.fragment),qe=n(),M(D.$$.fragment),Ye=n(),O=o("pre"),O.textContent=Jt,Ee=n(),M(ee.$$.fragment),ze=n(),te=o("p"),te.textContent=gt,Le=n(),se=o("p"),se.innerHTML=ft,Fe=n(),le=o("p"),le.textContent=Tt,Pe=n(),M(ne.$$.fragment),Ke=n(),ie=o("p"),this.h()},l(e){const t=Wt("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(s),re=a(e),oe=i(e,"P",{}),Ct(oe).forEach(s),Me=a(e),p(j.$$.fragment,e),pe=a(e),p(w.$$.fragment,e),ce=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1xlqnsv"&&(U.innerHTML=et),ye=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-o14ioo"&&(b.innerHTML=tt),me=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1mh34dv"&&(J.innerHTML=st),ue=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-mmy9qo"&&(g.innerHTML=lt),he=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-gwofaa"&&(f.innerHTML=nt),de=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-fc6q9b"&&(T.textContent=at),je=a(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-psgh4s"&&(C.innerHTML=ot),we=a(e),p(Z.$$.fragment,e),Ue=a(e),p(I.$$.fragment,e),be=a(e),p(v.$$.fragment,e),Je=a(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1354tpb"&&(B.textContent=it),ge=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1yb5yrl"&&(G.textContent=rt),fe=a(e),R=i(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1dqrk95"&&(R.innerHTML=Mt),Te=a(e),p(W.$$.fragment,e),Ce=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1hg95q8"&&(k.innerHTML=pt),Ze=a(e),p($.$$.fragment,e),Ie=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-wr7xp9"&&(X.textContent=ct),ve=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-108grnk"&&(_.innerHTML=yt),Be=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1283j65"&&(S.innerHTML=mt),Ge=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1qw64fs"&&(V.innerHTML=ut),Re=a(e),p(N.$$.fragment,e),We=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-jy4i2f"&&(Q.textContent=ht),ke=a(e),p(x.$$.fragment,e),$e=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-5pp8py"&&(H.textContent=dt),Xe=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1cx88lu"&&(A.textContent=jt),_e=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1vgfwws"&&(q.textContent=wt),Se=a(e),p(Y.$$.fragment,e),Ve=a(e),p(E.$$.fragment,e),Ne=a(e),p(z.$$.fragment,e),Qe=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-19hckuz"&&(L.innerHTML=Ut),xe=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1wpkyax"&&(F.innerHTML=bt),He=a(e),p(P.$$.fragment,e),Ae=a(e),p(K.$$.fragment,e),qe=a(e),p(D.$$.fragment,e),Ye=a(e),O=i(e,"PRE",{"data-svelte-h":!0}),r(O)!=="svelte-1b4adej"&&(O.textContent=Jt),Ee=a(e),p(ee.$$.fragment,e),ze=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1tpdrvo"&&(te.textContent=gt),Le=a(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1nxb7v"&&(se.innerHTML=ft),Fe=a(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-qsgdbf"&&(le.textContent=Tt),Pe=a(e),p(ne.$$.fragment,e),Ke=a(e),ie=i(e,"P",{}),Ct(ie).forEach(s),this.h()},h(){Zt(h,"name","hf:doc:metadata"),Zt(h,"content",St)},m(e,t){kt(document.head,h),l(e,re,t),l(e,oe,t),l(e,Me,t),c(j,e,t),l(e,pe,t),c(w,e,t),l(e,ce,t),l(e,U,t),l(e,ye,t),l(e,b,t),l(e,me,t),l(e,J,t),l(e,ue,t),l(e,g,t),l(e,he,t),l(e,f,t),l(e,de,t),l(e,T,t),l(e,je,t),l(e,C,t),l(e,we,t),c(Z,e,t),l(e,Ue,t),c(I,e,t),l(e,be,t),c(v,e,t),l(e,Je,t),l(e,B,t),l(e,ge,t),l(e,G,t),l(e,fe,t),l(e,R,t),l(e,Te,t),c(W,e,t),l(e,Ce,t),l(e,k,t),l(e,Ze,t),c($,e,t),l(e,Ie,t),l(e,X,t),l(e,ve,t),l(e,_,t),l(e,Be,t),l(e,S,t),l(e,Ge,t),l(e,V,t),l(e,Re,t),c(N,e,t),l(e,We,t),l(e,Q,t),l(e,ke,t),c(x,e,t),l(e,$e,t),l(e,H,t),l(e,Xe,t),l(e,A,t),l(e,_e,t),l(e,q,t),l(e,Se,t),c(Y,e,t),l(e,Ve,t),c(E,e,t),l(e,Ne,t),c(z,e,t),l(e,Qe,t),l(e,L,t),l(e,xe,t),l(e,F,t),l(e,He,t),c(P,e,t),l(e,Ae,t),c(K,e,t),l(e,qe,t),c(D,e,t),l(e,Ye,t),l(e,O,t),l(e,Ee,t),c(ee,e,t),l(e,ze,t),l(e,te,t),l(e,Le,t),l(e,se,t),l(e,Fe,t),l(e,le,t),l(e,Pe,t),c(ne,e,t),l(e,Ke,t),l(e,ie,t),De=!0},p:vt,i(e){De||(y(j.$$.fragment,e),y(w.$$.fragment,e),y(Z.$$.fragment,e),y(I.$$.fragment,e),y(v.$$.fragment,e),y(W.$$.fragment,e),y($.$$.fragment,e),y(N.$$.fragment,e),y(x.$$.fragment,e),y(Y.$$.fragment,e),y(E.$$.fragment,e),y(z.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(D.$$.fragment,e),y(ee.$$.fragment,e),y(ne.$$.fragment,e),De=!0)},o(e){m(j.$$.fragment,e),m(w.$$.fragment,e),m(Z.$$.fragment,e),m(I.$$.fragment,e),m(v.$$.fragment,e),m(W.$$.fragment,e),m($.$$.fragment,e),m(N.$$.fragment,e),m(x.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(z.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(D.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),De=!1},d(e){e&&(s(re),s(oe),s(Me),s(pe),s(ce),s(U),s(ye),s(b),s(me),s(J),s(ue),s(g),s(he),s(f),s(de),s(T),s(je),s(C),s(we),s(Ue),s(be),s(Je),s(B),s(ge),s(G),s(fe),s(R),s(Te),s(Ce),s(k),s(Ze),s(Ie),s(X),s(ve),s(_),s(Be),s(S),s(Ge),s(V),s(Re),s(We),s(Q),s(ke),s($e),s(H),s(Xe),s(A),s(_e),s(q),s(Se),s(Ve),s(Ne),s(Qe),s(L),s(xe),s(F),s(He),s(Ae),s(qe),s(Ye),s(O),s(Ee),s(ze),s(te),s(Le),s(se),s(Fe),s(le),s(Pe),s(Ke),s(ie)),s(h),u(j,e),u(w,e),u(Z,e),u(I,e),u(v,e),u(W,e),u($,e),u(N,e),u(x,e),u(Y,e),u(E,e),u(z,e),u(P,e),u(K,e),u(D,e),u(ee,e),u(ne,e)}}}const St='{"title":"Build an agent with tool-calling superpowers 🦸 using Transformers Agents","local":"build-an-agent-with-tool-calling-superpowers--using-transformers-agents","sections":[{"title":"🏞️ Multimodal + 🌐 Web-browsing assistant","local":"-multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"📚💬 Retrieval-Augmented Generation with source selection","local":"-retrieval-augmented-generation-with-source-selection","sections":[{"title":"Optional Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function Vt(Oe){return Bt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Gt{constructor(h){super(),Rt(this,h,Vt,_t,It,{})}}export{At as component};
