import{s as Pe,o as qe,n as Ve}from"../chunks/scheduler.69131cc3.js";import{S as Oe,i as el,g as p,s as n,r as d,A as ll,h as r,f as t,c,j as Le,u as m,x as J,k as De,y as tl,a,v as u,d as w,t as y,w as h}from"../chunks/index.e1f30d73.js";import{T as Ze}from"../chunks/Tip.22e79575.js";import{C as I}from"../chunks/CodeBlock.30cef355.js";import{H as O}from"../chunks/Heading.0aab6758.js";function al(U){let s,j='In its current state, this code is not going to perform gradient accumulation efficiently due to a process called gradient synchronization. Read more about that in the <a href="../concept_guides/gradient_synchronization">Concepts tutorial</a>!';return{c(){s=p("p"),s.innerHTML=j},l(i){s=r(i,"P",{"data-svelte-h":!0}),J(s)!=="svelte-s0dec7"&&(s.innerHTML=j)},m(i,M){a(i,s,M)},p:Ve,d(i){i&&t(s)}}}function sl(U){let s,j=`Typically with gradient accumulation, you would need to adjust the number of steps to reflect the change in total batches you are
training on. 🤗 Accelerate automagically does this for you by default. Behind the scenes we instantiate a <code>GradientAccumulationPlugin</code> configured to do this.`;return{c(){s=p("p"),s.innerHTML=j},l(i){s=r(i,"P",{"data-svelte-h":!0}),J(s)!=="svelte-1niv7yj"&&(s.innerHTML=j)},m(i,M){a(i,s,M)},p:Ve,d(i){i&&t(s)}}}function nl(U){let s,j='The <a href="/docs/accelerate/v0.27.1/en/package_reference/state#accelerate.state.GradientState">state.GradientState</a> is sync’d with the active dataloader being iterated upon. As such it assumes naively that when we have reached the end of the dataloader everything will sync and a step will be performed. To disable this, set <code>sync_with_dataloader</code> to be <code>False</code> in the <code>GradientAccumulationPlugin</code>:',i,M,b;return M=new I({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwR3JhZGllbnRBY2N1bXVsYXRpb25QbHVnaW4lMEElMEFwbHVnaW4lMjAlM0QlMjBHcmFkaWVudEFjY3VtdWxhdGlvblBsdWdpbihzeW5jX3dpdGhfZGF0YWxvYWRlciUzREZhbHNlKSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoLi4uJTJDJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3BsdWdpbiUzRHBsdWdpbik=",highlighted:`<span class="hljs-keyword">from</span> accelerate import Accelerator
<span class="hljs-keyword">from</span> accelerate.utils import GradientAccumulationPlugin

plugin = GradientAccumulationPlugin(<span class="hljs-attribute">sync_with_dataloader</span>=<span class="hljs-literal">False</span>)
accelerator = Accelerator(<span class="hljs-built_in">..</span>., <span class="hljs-attribute">gradient_accumulation_plugin</span>=plugin)`,wrap:!1}}),{c(){s=p("p"),s.innerHTML=j,i=n(),d(M.$$.fragment)},l(o){s=r(o,"P",{"data-svelte-h":!0}),J(s)!=="svelte-gc9wmu"&&(s.innerHTML=j),i=c(o),m(M.$$.fragment,o)},m(o,T){a(o,s,T),a(o,i,T),u(M,o,T),b=!0},p:Ve,i(o){b||(w(M.$$.fragment,o),b=!0)},o(o){y(M.$$.fragment,o),b=!1},d(o){o&&(t(s),t(i)),h(M,o)}}}function cl(U){let s,j="It’s important that <strong>only one forward/backward</strong> should be done inside the context manager <code>with accelerator.accumulate(model)</code>.";return{c(){s=p("p"),s.innerHTML=j},l(i){s=r(i,"P",{"data-svelte-h":!0}),J(s)!=="svelte-1kw2co7"&&(s.innerHTML=j)},m(i,M){a(i,s,M)},p:Ve,d(i){i&&t(s)}}}function il(U){let s,j,i,M,b,o,T,Xe=`Gradient accumulation is a technique where you can train on bigger batch sizes than
your machine would normally be able to fit into memory. This is done by accumulating gradients over
several batches, and only stepping the optimizer after a certain number of batches have been performed.`,ee,B,$e=`While technically standard gradient accumulation code would work fine in a distributed setup, it is not the most efficient
method for doing so and you may experience considerable slowdowns!`,le,g,ve=`In this tutorial you will see how to quickly setup gradient accumulation and perform it with the utilities provided in 🤗 Accelerate,
which can total to adding just one new line of code!`,te,Z,Ye="This example will use a very simplistic PyTorch training loop that performs gradient accumulation every two batches:",ae,V,se,X,ne,$,Ae="First the code shown earlier will be converted to utilize 🤗 Accelerate without the special gradient accumulation helper:",ce,v,ie,f,pe,Y,re,A,ke=`All that is left now is to let 🤗 Accelerate handle the gradient accumulation for us. To do so you should pass in a <code>gradient_accumulation_steps</code> parameter to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>, dictating the number
of steps to perform before each call to <code>step()</code> and how to automatically adjust the loss during the call to <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.backward">backward()</a>:`,oe,k,Me,R,Re=`Alternatively, you can pass in a <code>gradient_accumulation_plugin</code> parameter to the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object’s <code>__init__</code>, which will allow you to further customize the gradient accumulation behavior.
Read more about that in the <a href="../package_reference/accelerator#accelerate.utils.GradientAccumulationPlugin">GradientAccumulationPlugin</a> docs.`,de,_,_e=`From here you can use the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> context manager from inside your training loop to automatically perform the gradient accumulation for you!
You just wrap it around the entire training part of our code:`,me,Q,ue,z,Qe="You can remove all the special checks for the step number and the loss adjustment:",we,N,ye,x,ze='As you can see the <a href="/docs/accelerate/v0.27.1/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is able to keep track of the batch number you are on and it will automatically know whether to step through the prepared optimizer and how to adjust the loss.',he,G,Je,C,je,F,be,S,Ne="Below is the finished implementation for performing gradient accumulation with 🤗 Accelerate",Te,E,Ue,W,Ie,H,xe='To learn more about what magic this wraps around, read the <a href="../concept_guides/gradient_synchronization">Gradient Synchronization concept guide</a>',fe,K,Ge,L,Fe="Here is a self-contained example that you can run to see gradient accumulation in action with 🤗 Accelerate:",Ce,D,We,P,Be,q,ge;return b=new O({props:{title:"Performing gradient accumulation with 🤗 Accelerate",local:"performing-gradient-accumulation-with--accelerate",headingTag:"h1"}}),V=new I({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsLnRvKGRldmljZSklMEElMEFncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAyJTBBJTBBZm9yJTIwaW5kZXglMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRyYWluaW5nX2RhdGFsb2FkZXIpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwaW5wdXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyMCUyMCUyMCUyMGxvc3MuYmFja3dhcmQoKSUwQSUyMCUyMCUyMCUyMGlmJTIwKGluZGV4JTIwJTJCJTIwMSklMjAlMjUlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span>
model.to(device)

gradient_accumulation_steps = <span class="hljs-number">2</span>

<span class="hljs-keyword">for</span> index, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(training_dataloader):
    inputs, targets = batch
    inputs = inputs.to(device)
    targets = targets.to(device)
    outputs = model(inputs)
    loss = loss_function(outputs, targets)
    loss = loss / gradient_accumulation_steps
    loss.backward()
    <span class="hljs-keyword">if</span> (index + <span class="hljs-number">1</span>) % gradient_accumulation_steps == <span class="hljs-number">0</span>:
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),X=new O({props:{title:"Converting it to 🤗 Accelerate",local:"converting-it-to--accelerate",headingTag:"h2"}}),v=new I({props:{code:"JTJCJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUyQiUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTJCJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbmluZ19kYXRhbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTBBJTJCJTIwKSUwQSUwQSUyMCUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQS0lMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQS0lMjAlMjAlMjAlMjAlMjB0YXJnZXRzJTIwJTNEJTIwdGFyZ2V0cy50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jdGlvbihvdXRwdXRzJTJDJTIwdGFyZ2V0cyklMEElMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zcyUyMCUyRiUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUwQSUyQiUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
<span class="hljs-addition">+ accelerator = Accelerator()</span>

<span class="hljs-addition">+ model, optimizer, training_dataloader, scheduler = accelerator.prepare(</span>
<span class="hljs-addition">+     model, optimizer, training_dataloader, scheduler</span>
<span class="hljs-addition">+ )</span>

  for index, batch in enumerate(training_dataloader):
      inputs, targets = batch
<span class="hljs-deletion">-     inputs = inputs.to(device)</span>
<span class="hljs-deletion">-     targets = targets.to(device)</span>
      outputs = model(inputs)
      loss = loss_function(outputs, targets)
      loss = loss / gradient_accumulation_steps
<span class="hljs-addition">+     accelerator.backward(loss)</span>
      if (index+1) % gradient_accumulation_steps == 0:
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),f=new Ze({props:{warning:!0,$$slots:{default:[al]},$$scope:{ctx:U}}}),Y=new O({props:{title:"Letting 🤗 Accelerate handle gradient accumulation",local:"letting--accelerate-handle-gradient-accumulation",headingTag:"h2"}}),k=new I({props:{code:"JTIwJTIwZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQS0lMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEElMkIlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIp",highlighted:`  from accelerate import Accelerator
<span class="hljs-deletion">- accelerator = Accelerator()</span>
<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>`,wrap:!1}}),Q=new I({props:{code:"LSUyMGZvciUyMGluZGV4JTJDJTIwYmF0Y2glMjBpbiUyMGVudW1lcmF0ZSh0cmFpbmluZ19kYXRhbG9hZGVyKSUzQSUwQSUyQiUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbmluZ19kYXRhbG9hZGVyJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGFjY2VsZXJhdG9yLmFjY3VtdWxhdGUobW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyk=",highlighted:`<span class="hljs-deletion">- for index, batch in enumerate(training_dataloader):</span>
<span class="hljs-addition">+ for batch in training_dataloader:</span>
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          inputs, targets = batch
          outputs = model(inputs)`,wrap:!1}}),N=new I({props:{code:"LSUyMGxvc3MlMjAlM0QlMjBsb3NzJTIwJTJGJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTBBJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEEtJTIwaWYlMjAoaW5kZXglMkIxKSUyMCUyNSUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-deletion">- loss = loss / gradient_accumulation_steps</span>
  accelerator.backward(loss)
<span class="hljs-deletion">- if (index+1) % gradient_accumulation_steps == 0:</span>
  optimizer.step()
  scheduler.step()
  optimizer.zero_grad()`,wrap:!1}}),G=new Ze({props:{$$slots:{default:[sl]},$$scope:{ctx:U}}}),C=new Ze({props:{warning:!0,$$slots:{default:[nl]},$$scope:{ctx:U}}}),F=new O({props:{title:"The finished code",local:"the-finished-code",headingTag:"h2"}}),E=new I({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiklMEFtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluaW5nX2RhdGFsb2FkZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUyQyUyMHNjaGVkdWxlciUwQSklMEFmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5pbmdfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjBhY2NlbGVyYXRvci5hY2N1bXVsYXRlKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyQyUyMHRhcmdldHMlMjAlM0QlMjBiYXRjaCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuY3Rpb24ob3V0cHV0cyUyQyUyMHRhcmdldHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">2</span>)
model, optimizer, training_dataloader, scheduler = accelerator.prepare(
    model, optimizer, training_dataloader, scheduler
)
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> training_dataloader:
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        inputs, targets = batch
        outputs = model(inputs)
        loss = loss_function(outputs, targets)
        accelerator.backward(loss)
        optimizer.step()
        scheduler.step()
        optimizer.zero_grad()`,wrap:!1}}),W=new Ze({props:{warning:!0,$$slots:{default:[cl]},$$scope:{ctx:U}}}),K=new O({props:{title:"Self-contained example",local:"self-contained-example",headingTag:"h2"}}),D=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBjb3B5JTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjBhY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMFRlbnNvckRhdGFzZXQlMkMlMjBEYXRhTG9hZGVyJTBBJTBBJTIzJTIwc2VlZCUwQXNldF9zZWVkKDApJTBBJTBBJTIzJTIwZGVmaW5lJTIwdG95JTIwaW5wdXRzJTIwYW5kJTIwbGFiZWxzJTBBeCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxLiUyQyUyMDIuJTJDJTIwMy4lMkMlMjA0LiUyQyUyMDUuJTJDJTIwNi4lMkMlMjA3LiUyQyUyMDguJTVEKSUwQXklMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMi4lMkMlMjA0LiUyQyUyMDYuJTJDJTIwOC4lMkMlMjAxMC4lMkMlMjAxMi4lMkMlMjAxNC4lMkMlMjAxNi4lNUQpJTBBZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTIwJTNEJTIwNCUwQWJhdGNoX3NpemUlMjAlM0QlMjBsZW4oeCklMjAlMkYlMkYlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMEElMEElMjMlMjBkZWZpbmUlMjBkYXRhc2V0JTIwYW5kJTIwZGF0YWxvYWRlciUwQWRhdGFzZXQlMjAlM0QlMjBUZW5zb3JEYXRhc2V0KHglMkMlMjB5KSUwQWRhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSklMEElMEElMjMlMjBkZWZpbmUlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyMGFuZCUyMGxvc3MlMjBmdW5jdGlvbiUwQW1vZGVsJTIwJTNEJTIwdG9yY2guemVyb3MoKDElMkMlMjAxKSUyQyUyMHJlcXVpcmVzX2dyYWQlM0RUcnVlKSUwQW1vZGVsX2Nsb25lJTIwJTNEJTIwY29weS5kZWVwY29weShtb2RlbCklMEFjcml0ZXJpb24lMjAlM0QlMjB0b3JjaC5ubi5NU0VMb3NzKCklMEFtb2RlbF9vcHRpbWl6ZXIlMjAlM0QlMjB0b3JjaC5vcHRpbS5TR0QoJTVCbW9kZWwlNUQlMkMlMjBsciUzRDAuMDIpJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0RncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMpJTBBbW9kZWwlMkMlMjBtb2RlbF9vcHRpbWl6ZXIlMkMlMjBkYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZShtb2RlbCUyQyUyMG1vZGVsX29wdGltaXplciUyQyUyMGRhdGFsb2FkZXIpJTBBbW9kZWxfY2xvbmVfb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uU0dEKCU1Qm1vZGVsX2Nsb25lJTVEJTJDJTIwbHIlM0QwLjAyKSUwQXByaW50KGYlMjJpbml0aWFsJTIwbW9kZWwlMjB3ZWlnaHQlMjBpcyUyMCU3Qm1vZGVsLm1lYW4oKS5pdGVtKCklM0EuNWYlN0QlMjIpJTBBcHJpbnQoZiUyMmluaXRpYWwlMjBtb2RlbCUyMHdlaWdodCUyMGlzJTIwJTdCbW9kZWxfY2xvbmUubWVhbigpLml0ZW0oKSUzQS41ZiU3RCUyMiklMEFmb3IlMjBpJTJDJTIwKGlucHV0cyUyQyUyMGxhYmVscyklMjBpbiUyMGVudW1lcmF0ZShkYXRhbG9hZGVyKSUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjBhY2NlbGVyYXRvci5hY2N1bXVsYXRlKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMGlucHV0cy52aWV3KC0xJTJDJTIwMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChpJTJDJTIwaW5wdXRzLmZsYXR0ZW4oKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjBsYWJlbHMudmlldygtMSUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMGlucHV0cyUyMCU0MCUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGNyaXRlcmlvbihvdXRwdXRzJTJDJTIwbGFiZWxzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX29wdGltaXplci56ZXJvX2dyYWQoKSUwQWxvc3MlMjAlM0QlMjBjcml0ZXJpb24oeC52aWV3KC0xJTJDJTIwMSklMjAlNDAlMjBtb2RlbF9jbG9uZSUyQyUyMHkudmlldygtMSUyQyUyMDEpKSUwQW1vZGVsX2Nsb25lX29wdGltaXplci56ZXJvX2dyYWQoKSUwQWxvc3MuYmFja3dhcmQoKSUwQW1vZGVsX2Nsb25lX29wdGltaXplci5zdGVwKCklMEFwcmludChmJTIydyUyRiUyMGFjY3VtdWxhdGlvbiUyQyUyMHRoZSUyMGZpbmFsJTIwbW9kZWwlMjB3ZWlnaHQlMjBpcyUyMCU3Qm1vZGVsLm1lYW4oKS5pdGVtKCklM0EuNWYlN0QlMjIpJTBBcHJpbnQoZiUyMnclMkZvJTIwYWNjdW11bGF0aW9uJTJDJTIwdGhlJTIwZmluYWwlMjBtb2RlbCUyMHdlaWdodCUyMGlzJTIwJTdCbW9kZWxfY2xvbmUubWVhbigpLml0ZW0oKSUzQS41ZiU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> copy
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> TensorDataset, DataLoader

<span class="hljs-comment"># seed</span>
set_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># define toy inputs and labels</span>
x = torch.tensor([<span class="hljs-number">1.</span>, <span class="hljs-number">2.</span>, <span class="hljs-number">3.</span>, <span class="hljs-number">4.</span>, <span class="hljs-number">5.</span>, <span class="hljs-number">6.</span>, <span class="hljs-number">7.</span>, <span class="hljs-number">8.</span>])
y = torch.tensor([<span class="hljs-number">2.</span>, <span class="hljs-number">4.</span>, <span class="hljs-number">6.</span>, <span class="hljs-number">8.</span>, <span class="hljs-number">10.</span>, <span class="hljs-number">12.</span>, <span class="hljs-number">14.</span>, <span class="hljs-number">16.</span>])
gradient_accumulation_steps = <span class="hljs-number">4</span>
batch_size = <span class="hljs-built_in">len</span>(x) // gradient_accumulation_steps

<span class="hljs-comment"># define dataset and dataloader</span>
dataset = TensorDataset(x, y)
dataloader = DataLoader(dataset, batch_size=batch_size)

<span class="hljs-comment"># define model, optimizer and loss function</span>
model = torch.zeros((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), requires_grad=<span class="hljs-literal">True</span>)
model_clone = copy.deepcopy(model)
criterion = torch.nn.MSELoss()
model_optimizer = torch.optim.SGD([model], lr=<span class="hljs-number">0.02</span>)
accelerator = Accelerator(gradient_accumulation_steps=gradient_accumulation_steps)
model, model_optimizer, dataloader = accelerator.prepare(model, model_optimizer, dataloader)
model_clone_optimizer = torch.optim.SGD([model_clone], lr=<span class="hljs-number">0.02</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;initial model weight is <span class="hljs-subst">{model_clone.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-keyword">for</span> i, (inputs, labels) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataloader):
    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
        inputs = inputs.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
        <span class="hljs-built_in">print</span>(i, inputs.flatten())
        labels = labels.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
        outputs = inputs @ model
        loss = criterion(outputs, labels)
        accelerator.backward(loss)
        model_optimizer.step()
        model_optimizer.zero_grad()
loss = criterion(x.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>) @ model_clone, y.view(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>))
model_clone_optimizer.zero_grad()
loss.backward()
model_clone_optimizer.step()
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;w/ accumulation, the final model weight is <span class="hljs-subst">{model.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;w/o accumulation, the final model weight is <span class="hljs-subst">{model_clone.mean().item():<span class="hljs-number">.5</span>f}</span>&quot;</span>)`,wrap:!1}}),P=new I({props:{code:"aW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAwLjAwMDAwJTBBaW5pdGlhbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAwLjAwMDAwJTBBMCUyMHRlbnNvciglNUIxLiUyQyUyMDIuJTVEKSUwQTElMjB0ZW5zb3IoJTVCMy4lMkMlMjA0LiU1RCklMEEyJTIwdGVuc29yKCU1QjUuJTJDJTIwNi4lNUQpJTBBMyUyMHRlbnNvciglNUI3LiUyQyUyMDguJTVEKSUwQXclMkYlMjBhY2N1bXVsYXRpb24lMkMlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAyLjA0MDAwJTBBdyUyRm8lMjBhY2N1bXVsYXRpb24lMkMlMjB0aGUlMjBmaW5hbCUyMG1vZGVsJTIwd2VpZ2h0JTIwaXMlMjAyLjA0MDAw",highlighted:`<span class="hljs-attribute">initial</span> model weight is <span class="hljs-number">0</span>.<span class="hljs-number">00000</span>
<span class="hljs-attribute">initial</span> model weight is <span class="hljs-number">0</span>.<span class="hljs-number">00000</span>
<span class="hljs-attribute">0</span> tensor([<span class="hljs-number">1</span>., <span class="hljs-number">2</span>.])
<span class="hljs-attribute">1</span> tensor([<span class="hljs-number">3</span>., <span class="hljs-number">4</span>.])
<span class="hljs-attribute">2</span> tensor([<span class="hljs-number">5</span>., <span class="hljs-number">6</span>.])
<span class="hljs-attribute">3</span> tensor([<span class="hljs-number">7</span>., <span class="hljs-number">8</span>.])
<span class="hljs-attribute">w</span>/ accumulation, the final model weight is <span class="hljs-number">2</span>.<span class="hljs-number">04000</span>
<span class="hljs-attribute">w</span>/o accumulation, the final model weight is <span class="hljs-number">2</span>.<span class="hljs-number">04000</span>`,wrap:!1}}),{c(){s=p("meta"),j=n(),i=p("p"),M=n(),d(b.$$.fragment),o=n(),T=p("p"),T.textContent=Xe,ee=n(),B=p("p"),B.textContent=$e,le=n(),g=p("p"),g.textContent=ve,te=n(),Z=p("p"),Z.textContent=Ye,ae=n(),d(V.$$.fragment),se=n(),d(X.$$.fragment),ne=n(),$=p("p"),$.textContent=Ae,ce=n(),d(v.$$.fragment),ie=n(),d(f.$$.fragment),pe=n(),d(Y.$$.fragment),re=n(),A=p("p"),A.innerHTML=ke,oe=n(),d(k.$$.fragment),Me=n(),R=p("p"),R.innerHTML=Re,de=n(),_=p("p"),_.innerHTML=_e,me=n(),d(Q.$$.fragment),ue=n(),z=p("p"),z.textContent=Qe,we=n(),d(N.$$.fragment),ye=n(),x=p("p"),x.innerHTML=ze,he=n(),d(G.$$.fragment),Je=n(),d(C.$$.fragment),je=n(),d(F.$$.fragment),be=n(),S=p("p"),S.textContent=Ne,Te=n(),d(E.$$.fragment),Ue=n(),d(W.$$.fragment),Ie=n(),H=p("p"),H.innerHTML=xe,fe=n(),d(K.$$.fragment),Ge=n(),L=p("p"),L.textContent=Fe,Ce=n(),d(D.$$.fragment),We=n(),d(P.$$.fragment),Be=n(),q=p("p"),this.h()},l(e){const l=ll("svelte-u9bgzb",document.head);s=r(l,"META",{name:!0,content:!0}),l.forEach(t),j=c(e),i=r(e,"P",{}),Le(i).forEach(t),M=c(e),m(b.$$.fragment,e),o=c(e),T=r(e,"P",{"data-svelte-h":!0}),J(T)!=="svelte-1762c2w"&&(T.textContent=Xe),ee=c(e),B=r(e,"P",{"data-svelte-h":!0}),J(B)!=="svelte-1u2vc4p"&&(B.textContent=$e),le=c(e),g=r(e,"P",{"data-svelte-h":!0}),J(g)!=="svelte-elnr4k"&&(g.textContent=ve),te=c(e),Z=r(e,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-n9bxrd"&&(Z.textContent=Ye),ae=c(e),m(V.$$.fragment,e),se=c(e),m(X.$$.fragment,e),ne=c(e),$=r(e,"P",{"data-svelte-h":!0}),J($)!=="svelte-41b2zq"&&($.textContent=Ae),ce=c(e),m(v.$$.fragment,e),ie=c(e),m(f.$$.fragment,e),pe=c(e),m(Y.$$.fragment,e),re=c(e),A=r(e,"P",{"data-svelte-h":!0}),J(A)!=="svelte-1ec4adn"&&(A.innerHTML=ke),oe=c(e),m(k.$$.fragment,e),Me=c(e),R=r(e,"P",{"data-svelte-h":!0}),J(R)!=="svelte-19h9y7n"&&(R.innerHTML=Re),de=c(e),_=r(e,"P",{"data-svelte-h":!0}),J(_)!=="svelte-178exqb"&&(_.innerHTML=_e),me=c(e),m(Q.$$.fragment,e),ue=c(e),z=r(e,"P",{"data-svelte-h":!0}),J(z)!=="svelte-1mcvl9w"&&(z.textContent=Qe),we=c(e),m(N.$$.fragment,e),ye=c(e),x=r(e,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1so3sqd"&&(x.innerHTML=ze),he=c(e),m(G.$$.fragment,e),Je=c(e),m(C.$$.fragment,e),je=c(e),m(F.$$.fragment,e),be=c(e),S=r(e,"P",{"data-svelte-h":!0}),J(S)!=="svelte-9alw5p"&&(S.textContent=Ne),Te=c(e),m(E.$$.fragment,e),Ue=c(e),m(W.$$.fragment,e),Ie=c(e),H=r(e,"P",{"data-svelte-h":!0}),J(H)!=="svelte-aw0h59"&&(H.innerHTML=xe),fe=c(e),m(K.$$.fragment,e),Ge=c(e),L=r(e,"P",{"data-svelte-h":!0}),J(L)!=="svelte-1wysb4w"&&(L.textContent=Fe),Ce=c(e),m(D.$$.fragment,e),We=c(e),m(P.$$.fragment,e),Be=c(e),q=r(e,"P",{}),Le(q).forEach(t),this.h()},h(){De(s,"name","hf:doc:metadata"),De(s,"content",pl)},m(e,l){tl(document.head,s),a(e,j,l),a(e,i,l),a(e,M,l),u(b,e,l),a(e,o,l),a(e,T,l),a(e,ee,l),a(e,B,l),a(e,le,l),a(e,g,l),a(e,te,l),a(e,Z,l),a(e,ae,l),u(V,e,l),a(e,se,l),u(X,e,l),a(e,ne,l),a(e,$,l),a(e,ce,l),u(v,e,l),a(e,ie,l),u(f,e,l),a(e,pe,l),u(Y,e,l),a(e,re,l),a(e,A,l),a(e,oe,l),u(k,e,l),a(e,Me,l),a(e,R,l),a(e,de,l),a(e,_,l),a(e,me,l),u(Q,e,l),a(e,ue,l),a(e,z,l),a(e,we,l),u(N,e,l),a(e,ye,l),a(e,x,l),a(e,he,l),u(G,e,l),a(e,Je,l),u(C,e,l),a(e,je,l),u(F,e,l),a(e,be,l),a(e,S,l),a(e,Te,l),u(E,e,l),a(e,Ue,l),u(W,e,l),a(e,Ie,l),a(e,H,l),a(e,fe,l),u(K,e,l),a(e,Ge,l),a(e,L,l),a(e,Ce,l),u(D,e,l),a(e,We,l),u(P,e,l),a(e,Be,l),a(e,q,l),ge=!0},p(e,[l]){const Se={};l&2&&(Se.$$scope={dirty:l,ctx:e}),f.$set(Se);const Ee={};l&2&&(Ee.$$scope={dirty:l,ctx:e}),G.$set(Ee);const He={};l&2&&(He.$$scope={dirty:l,ctx:e}),C.$set(He);const Ke={};l&2&&(Ke.$$scope={dirty:l,ctx:e}),W.$set(Ke)},i(e){ge||(w(b.$$.fragment,e),w(V.$$.fragment,e),w(X.$$.fragment,e),w(v.$$.fragment,e),w(f.$$.fragment,e),w(Y.$$.fragment,e),w(k.$$.fragment,e),w(Q.$$.fragment,e),w(N.$$.fragment,e),w(G.$$.fragment,e),w(C.$$.fragment,e),w(F.$$.fragment,e),w(E.$$.fragment,e),w(W.$$.fragment,e),w(K.$$.fragment,e),w(D.$$.fragment,e),w(P.$$.fragment,e),ge=!0)},o(e){y(b.$$.fragment,e),y(V.$$.fragment,e),y(X.$$.fragment,e),y(v.$$.fragment,e),y(f.$$.fragment,e),y(Y.$$.fragment,e),y(k.$$.fragment,e),y(Q.$$.fragment,e),y(N.$$.fragment,e),y(G.$$.fragment,e),y(C.$$.fragment,e),y(F.$$.fragment,e),y(E.$$.fragment,e),y(W.$$.fragment,e),y(K.$$.fragment,e),y(D.$$.fragment,e),y(P.$$.fragment,e),ge=!1},d(e){e&&(t(j),t(i),t(M),t(o),t(T),t(ee),t(B),t(le),t(g),t(te),t(Z),t(ae),t(se),t(ne),t($),t(ce),t(ie),t(pe),t(re),t(A),t(oe),t(Me),t(R),t(de),t(_),t(me),t(ue),t(z),t(we),t(ye),t(x),t(he),t(Je),t(je),t(be),t(S),t(Te),t(Ue),t(Ie),t(H),t(fe),t(Ge),t(L),t(Ce),t(We),t(Be),t(q)),t(s),h(b,e),h(V,e),h(X,e),h(v,e),h(f,e),h(Y,e),h(k,e),h(Q,e),h(N,e),h(G,e),h(C,e),h(F,e),h(E,e),h(W,e),h(K,e),h(D,e),h(P,e)}}}const pl='{"title":"Performing gradient accumulation with 🤗 Accelerate","local":"performing-gradient-accumulation-with--accelerate","sections":[{"title":"Converting it to 🤗 Accelerate","local":"converting-it-to--accelerate","sections":[],"depth":2},{"title":"Letting 🤗 Accelerate handle gradient accumulation","local":"letting--accelerate-handle-gradient-accumulation","sections":[],"depth":2},{"title":"The finished code","local":"the-finished-code","sections":[],"depth":2},{"title":"Self-contained example","local":"self-contained-example","sections":[],"depth":2}],"depth":1}';function rl(U){return qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wl extends Oe{constructor(s){super(),el(this,s,rl,il,Pe,{})}}export{wl as component};
